/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2ddl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.tool.hbm2ddl.ColumnMetadata;
import net.sf.hibernate.tool.hbm2ddl.ForeignKeyMetadata;
import net.sf.hibernate.tool.hbm2ddl.IndexMetadata;

public class TableMetadata {
    private final String schema;
    private final String name;
    private final Map columns = new HashMap();
    private final Map foreignKeys = new HashMap();
    private final Map indexes = new HashMap();

    TableMetadata(ResultSet rs, DatabaseMetaData meta) throws SQLException {
        this.schema = rs.getString("TABLE_SCHEM");
        this.name = rs.getString("TABLE_NAME");
        this.initColumns(meta);
        this.initForeignKeys(meta);
        this.initIndexes(meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initForeignKeys(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = null;
        try {
            rs = meta.getImportedKeys(null, this.schema, this.name);
            while (rs.next()) {
                this.addForeignKey(rs);
            }
            Object var4_3 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initIndexes(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = null;
        try {
            rs = meta.getIndexInfo(null, this.schema, this.name, false, true);
            while (rs.next()) {
                if (rs.getShort("TYPE") == 0) continue;
                this.addIndex(rs);
            }
            Object var4_3 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
    }

    public ColumnMetadata getColumnMetadata(String name) {
        return (ColumnMetadata)this.columns.get(name.toLowerCase());
    }

    public void addColumn(ResultSet rs) throws SQLException {
        String column = rs.getString("COLUMN_NAME");
        if (column == null) {
            return;
        }
        if (this.getColumnMetadata(column) == null) {
            ColumnMetadata info = new ColumnMetadata(rs);
            this.columns.put(info.getName().toLowerCase(), info);
        }
    }

    public ForeignKeyMetadata getForeignKeyMetadata(String name) {
        return (ForeignKeyMetadata)this.foreignKeys.get(name.toUpperCase());
    }

    private void addForeignKey(ResultSet rs) throws SQLException {
        String fk = rs.getString("FK_NAME");
        if (fk == null) {
            return;
        }
        ForeignKeyMetadata info = this.getForeignKeyMetadata(fk);
        if (info == null) {
            info = new ForeignKeyMetadata(rs);
            this.foreignKeys.put(info.getName().toUpperCase(), info);
        }
        info.addColumn(this.getColumnMetadata("FKCOLUMN_NAME"));
    }

    public IndexMetadata getIndexMetadata(String name) {
        return (IndexMetadata)this.indexes.get(name.toUpperCase());
    }

    private void addIndex(ResultSet rs) throws SQLException {
        String index = rs.getString("INDEX_NAME");
        if (index == null) {
            return;
        }
        IndexMetadata info = this.getIndexMetadata(index);
        if (info == null) {
            info = new IndexMetadata(rs);
            this.indexes.put(info.getName().toUpperCase(), info);
        }
        info.addColumn(this.getColumnMetadata("COLUMN_NAME"));
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initColumns(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = null;
        try {
            rs = meta.getColumns(null, "%", this.getName(), "%");
            while (rs.next()) {
                this.addColumn(rs);
            }
            Object var4_3 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
    }
}

