/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ResolveData;
import fr.jayasoft.ivy.ResolvedModuleRevision;
import fr.jayasoft.ivy.report.DownloadReport;
import fr.jayasoft.ivy.resolver.ModuleEntry;
import fr.jayasoft.ivy.resolver.OrganisationEntry;
import fr.jayasoft.ivy.resolver.ResolvedResource;
import fr.jayasoft.ivy.resolver.RevisionEntry;
import fr.jayasoft.ivy.resolver.URLResolver;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.XMLHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IvyRepResolver
extends URLResolver {
    public static final String DEFAULT_IVYPATTERN = "[organisation]/[module]/ivy-[revision].xml";
    public static final String DEFAULT_IVYROOT = "http://ivyrep.jayasoft.org/";
    private String _ivyroot = null;
    private String _ivypattern = null;
    private String _artroot = null;
    private String _artpattern = null;

    private void ensureArtifactConfigured(Ivy ivy) {
        if (ivy != null && (this._artroot == null || this._artpattern == null)) {
            if (this._artroot == null) {
                String root = ivy.getVariable("ivy.ivyrep.default.artifact.root");
                if (root != null) {
                    this._artroot = root;
                } else {
                    ivy.configureRepositories(true);
                    this._artroot = ivy.getVariable("ivy.ivyrep.default.artifact.root");
                }
            }
            if (this._artpattern == null) {
                String pattern = ivy.getVariable("ivy.ivyrep.default.artifact.pattern");
                if (pattern != null) {
                    this._artpattern = pattern;
                } else {
                    ivy.configureRepositories(false);
                    this._artpattern = ivy.getVariable("ivy.ivyrep.default.artifact.pattern");
                }
            }
            this.updateWholeArtPattern();
        }
    }

    private void ensureIvyConfigured(Ivy ivy) {
        if (ivy != null && (this._ivyroot == null || this._ivypattern == null)) {
            if (this._ivyroot == null) {
                String root = ivy.getVariable("ivy.ivyrep.default.ivy.root");
                if (root != null) {
                    this._ivyroot = root;
                } else {
                    ivy.configureRepositories(true);
                    this._ivyroot = ivy.getVariable("ivy.ivyrep.default.ivy.root");
                }
            }
            if (this._ivypattern == null) {
                String pattern = ivy.getVariable("ivy.ivyrep.default.ivy.pattern");
                if (pattern != null) {
                    this._ivypattern = pattern;
                } else {
                    ivy.configureRepositories(false);
                    this._ivypattern = ivy.getVariable("ivy.ivyrep.default.ivy.pattern");
                }
            }
            this.updateWholeIvyPattern();
        }
    }

    private String getWholeIvyPattern() {
        if (this._ivyroot == null || this._ivypattern == null) {
            return null;
        }
        return this._ivyroot + this._ivypattern;
    }

    private String getWholeArtPattern() {
        return this._artroot + this._artpattern;
    }

    public String getIvypattern() {
        return this._ivypattern;
    }

    public void setIvypattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern must not be null");
        }
        this._ivypattern = pattern;
        this.ensureIvyConfigured(this.getIvy());
        this.updateWholeIvyPattern();
    }

    public String getIvyroot() {
        return this._ivyroot;
    }

    public void setIvyroot(String root) {
        if (root == null) {
            throw new NullPointerException("root must not be null");
        }
        this._ivyroot = !root.endsWith("/") ? root + "/" : root;
        this.ensureIvyConfigured(this.getIvy());
        this.updateWholeIvyPattern();
    }

    public void setM2compatible(boolean m2compatible) {
        if (m2compatible) {
            throw new IllegalArgumentException("ivyrep does not support maven2 compatibility. Please use ibiblio resolver instead, or even url or filesystem resolvers for more specific needs.");
        }
    }

    private void updateWholeIvyPattern() {
        this.setIvyPatterns(Collections.singletonList(this.getWholeIvyPattern()));
    }

    private void updateWholeArtPattern() {
        this.setArtifactPatterns(Collections.singletonList(this.getWholeArtPattern()));
    }

    public void publish(Artifact artifact, File src) {
        throw new UnsupportedOperationException("publish not supported by IBiblioResolver");
    }

    public String getArtroot() {
        return this._artroot;
    }

    public String getArtpattern() {
        return this._artpattern;
    }

    public void setArtpattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern must not be null");
        }
        this._artpattern = pattern;
        this.ensureArtifactConfigured(this.getIvy());
        this.updateWholeArtPattern();
    }

    public void setArtroot(String root) {
        if (root == null) {
            throw new NullPointerException("root must not be null");
        }
        this._artroot = !root.endsWith("/") ? root + "/" : root;
        this.ensureArtifactConfigured(this.getIvy());
        this.updateWholeArtPattern();
    }

    public OrganisationEntry[] listOrganisations() {
        this.ensureIvyConfigured(this.getIvy());
        try {
            URL content = new URL(this._ivyroot + "content.xml");
            final ArrayList ret = new ArrayList();
            XMLHelper.parse(content, null, new DefaultHandler(){

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    String org;
                    if ("organisation".equals(qName) && (org = attributes.getValue("name")) != null) {
                        ret.add(new OrganisationEntry(IvyRepResolver.this, org));
                    }
                }
            });
            return ret.toArray(new OrganisationEntry[ret.size()]);
        }
        catch (MalformedURLException e) {
        }
        catch (Exception e) {
            Message.warn("unable to parse content.xml file on ivyrep: " + e.getMessage());
        }
        return super.listOrganisations();
    }

    public ModuleEntry[] listModules(OrganisationEntry org) {
        this.ensureIvyConfigured(this.getIvy());
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", org.getOrganisation());
        Collection names = this.findIvyNames(tokenValues, "module");
        ModuleEntry[] ret = new ModuleEntry[names.size()];
        int i = 0;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ret[i] = new ModuleEntry(org, name);
            ++i;
        }
        return ret;
    }

    public RevisionEntry[] listRevisions(ModuleEntry mod) {
        this.ensureIvyConfigured(this.getIvy());
        this.ensureArtifactConfigured(this.getIvy());
        return super.listRevisions(mod);
    }

    public String getTypeName() {
        return "ivyrep";
    }

    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        this.ensureIvyConfigured(data.getIvy());
        return super.getDependency(dd, data);
    }

    protected ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        this.ensureArtifactConfigured(this.getIvy());
        return super.findArtifactRef(artifact, date);
    }

    public DownloadReport download(Artifact[] artifacts, Ivy ivy, File cache) {
        this.ensureArtifactConfigured(ivy);
        return super.download(artifacts, ivy, cache);
    }

    public boolean exists(Artifact artifact) {
        this.ensureArtifactConfigured(this.getIvy());
        return super.exists(artifact);
    }

    public List getIvyPatterns() {
        this.ensureIvyConfigured(this.getIvy());
        return super.getIvyPatterns();
    }

    public List getArtifactPatterns() {
        this.ensureArtifactConfigured(this.getIvy());
        return super.getArtifactPatterns();
    }
}

