/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.log4j.helpers.PlatformInfo;
import org.apache.log4j.spi.VectorWriter;

public class ThrowableInformation
implements Serializable {
    static final long serialVersionUID = -4748765566864322735L;
    private transient Throwable throwable = null;
    private String[] rep;

    public ThrowableInformation(Throwable throwable) {
        this.throwable = throwable;
        VectorWriter vw = new VectorWriter();
        this.extractStringRep(throwable, vw);
        this.rep = vw.toStringArray();
    }

    public ThrowableInformation(String[] rep) {
        this.rep = rep;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void extractStringRep(Throwable t, VectorWriter vw) {
        t.printStackTrace(vw);
        try {
            Throwable nextT;
            Class<?> tC = t.getClass();
            Method[] mA = tC.getMethods();
            Method nextThrowableMethod = null;
            int i = 0;
            while (i < mA.length) {
                Class<?>[] params;
                if (("getCause".equals(mA[i].getName()) && !PlatformInfo.isJDK14OrLater() || "getRootCause".equals(mA[i].getName()) || "getNextException".equals(mA[i].getName()) || "getException".equals(mA[i].getName())) && ((params = mA[i].getParameterTypes()) == null || params.length == 0)) {
                    nextThrowableMethod = mA[i];
                    break;
                }
                ++i;
            }
            if (nextThrowableMethod != null && (nextT = (Throwable)nextThrowableMethod.invoke((Object)t, new Object[0])) != null) {
                vw.print("Root cause follows.");
                this.extractStringRep(nextT, vw);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getThrowableStrRep() {
        return (String[])this.rep.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThrowableInformation)) {
            return false;
        }
        ThrowableInformation r = (ThrowableInformation)o;
        if (this.rep == null) {
            return r.rep == null;
        }
        if (this.rep.length != r.rep.length) {
            return false;
        }
        int len = this.rep.length;
        int i = 0;
        while (i < len) {
            if (!this.rep[i].equals(r.rep[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

