/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Stack;
import org.apache.log4j.LogManager;
import org.apache.log4j.rule.AndRule;
import org.apache.log4j.rule.EqualsRule;
import org.apache.log4j.rule.ExistsRule;
import org.apache.log4j.rule.InequalityRule;
import org.apache.log4j.rule.NotEqualsRule;
import org.apache.log4j.rule.NotRule;
import org.apache.log4j.rule.OrRule;
import org.apache.log4j.rule.PartialTextMatchRule;
import org.apache.log4j.rule.Rule;

public class RuleFactory {
    private static final RuleFactory factory_ = new RuleFactory();
    private static final Collection rules = new LinkedList();
    private static final String AND_RULE = "&&";
    private static final String OR_RULE = "||";
    private static final String NOT_RULE = "!";
    private static final String NOT_EQUALS_RULE = "!=";
    private static final String EQUALS_RULE = "==";
    private static final String PARTIAL_TEXT_MATCH_RULE = "~=";
    private static final String LIKE_RULE = "like";
    private static final String EXISTS_RULE = "exists";
    private static final String LESS_THAN_RULE = "<";
    private static final String GREATER_THAN_RULE = ">";
    private static final String LESS_THAN_EQUALS_RULE = "<=";
    private static final String GREATER_THAN_EQUALS_RULE = ">=";
    static /* synthetic */ Class class$org$apache$log4j$rule$RuleFactory;
    static /* synthetic */ Class class$java$util$Stack;

    private RuleFactory() {
    }

    public static RuleFactory getInstance() {
        return factory_;
    }

    public boolean isRule(String symbol) {
        return symbol != null && rules.contains(symbol.toLowerCase());
    }

    public Rule getRule(String symbol, Stack stack) {
        if (AND_RULE.equals(symbol)) {
            return AndRule.getRule(stack);
        }
        if (OR_RULE.equals(symbol)) {
            return OrRule.getRule(stack);
        }
        if (NOT_RULE.equals(symbol)) {
            return NotRule.getRule(stack);
        }
        if (NOT_EQUALS_RULE.equals(symbol)) {
            return NotEqualsRule.getRule(stack);
        }
        if (EQUALS_RULE.equals(symbol)) {
            return EqualsRule.getRule(stack);
        }
        if (PARTIAL_TEXT_MATCH_RULE.equals(symbol)) {
            return PartialTextMatchRule.getRule(stack);
        }
        if (rules.contains(LIKE_RULE) && LIKE_RULE.equalsIgnoreCase(symbol)) {
            String methodName = "getRule";
            try {
                Class<?> likeClass = Class.forName("org.apache.log4j.rule.LikeRule");
                Method method = likeClass.getDeclaredMethod(methodName, class$java$util$Stack == null ? (class$java$util$Stack = RuleFactory.class$("java.util.Stack")) : class$java$util$Stack);
                return (Rule)method.invoke(null, stack);
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (InvocationTargetException iae) {
                // empty catch block
            }
        }
        if (EXISTS_RULE.equalsIgnoreCase(symbol)) {
            return ExistsRule.getRule(stack);
        }
        if (LESS_THAN_RULE.equals(symbol)) {
            return InequalityRule.getRule(LESS_THAN_RULE, stack);
        }
        if (GREATER_THAN_RULE.equals(symbol)) {
            return InequalityRule.getRule(GREATER_THAN_RULE, stack);
        }
        if (LESS_THAN_EQUALS_RULE.equals(symbol)) {
            return InequalityRule.getRule(LESS_THAN_EQUALS_RULE, stack);
        }
        if (GREATER_THAN_EQUALS_RULE.equals(symbol)) {
            return InequalityRule.getRule(GREATER_THAN_EQUALS_RULE, stack);
        }
        throw new IllegalArgumentException("Invalid rule: " + symbol);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        rules.add(AND_RULE);
        rules.add(OR_RULE);
        rules.add(NOT_RULE);
        rules.add(NOT_EQUALS_RULE);
        rules.add(EQUALS_RULE);
        rules.add(PARTIAL_TEXT_MATCH_RULE);
        try {
            Class.forName("org.apache.log4j.rule.LikeRule");
            rules.add(LIKE_RULE);
        }
        catch (Exception e) {
            LogManager.getLogger(class$org$apache$log4j$rule$RuleFactory == null ? (class$org$apache$log4j$rule$RuleFactory = RuleFactory.class$("org.apache.log4j.rule.RuleFactory")) : class$org$apache$log4j$rule$RuleFactory).info("Like (regular expression) rule not supported");
        }
        rules.add(EXISTS_RULE);
        rules.add(LESS_THAN_RULE);
        rules.add(GREATER_THAN_RULE);
        rules.add(LESS_THAN_EQUALS_RULE);
        rules.add(GREATER_THAN_EQUALS_RULE);
    }
}

