/*
 * Unix SMB/CIFS implementation.
 *
 * DCERPC mgmt client
 *
 * Copyright (C) David Disseldorp 2013
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "includes.h"
#include "rpcclient.h"
#include "../librpc/gen_ndr/ndr_mgmt.h"
#include "../librpc/gen_ndr/ndr_mgmt_c.h"

static void cmd_mgmt_inq_server_princ_name_usage(const char *script_name)
{
	printf("usage: %s <authn_svc>\n", script_name);
}

static NTSTATUS cmd_mgmt_inq_server_princ_name(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx, int argc,
					       const char **argv)
{
	NTSTATUS status;
	struct mgmt_inq_princ_name r;
	struct dcerpc_binding_handle *b = cli->binding_handle;

	if (argc != 2) {
		cmd_mgmt_inq_server_princ_name_usage(argv[0]);
		return NT_STATUS_UNSUCCESSFUL;
	}

	ZERO_STRUCT(r);
	r.in.authn_proto = atoi(argv[1]);
	r.in.princ_name_size = 256;

	status = dcerpc_mgmt_inq_princ_name_r(b, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		DEBUG(0, ("inq_princ_name failed with authn_proto %d\n",
			  (int)r.in.authn_proto));
		return NT_STATUS_UNSUCCESSFUL;
	} else if (!W_ERROR_IS_OK(r.out.result)) {
		DEBUG(0, ("failed inq_princ_name response: %s\n",
			  win_errstr(r.out.result)));
		return NT_STATUS_UNSUCCESSFUL;
	}
	printf("Server principle name(%d): %s\n",
	       r.in.authn_proto, r.out.princ_name);

	return NT_STATUS_OK;
}

/* List of commands exported by this module */
struct cmd_set mgmt_commands[] = {

	{
		.name = "MGMT"
	},

	{
		.name = "mgmt_inq_server_princ_name",
		.returntype = RPC_RTYPE_NTSTATUS,
		.ntfn = cmd_mgmt_inq_server_princ_name,
		.table = &ndr_table_mgmt,
		.rpc_pipe = NULL,
		.description = "get a server\'s principle name",
		.usage = "",
	},
	{
		.name = NULL
	}
};
