; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt < %s -passes=asan -S | FileCheck %s
; RUN: opt < %s -passes=asan -asan-recover -S | FileCheck %s --check-prefix=RECOV
target datalayout = "e-p:64:64-p1:64:64-p2:32:32-p3:32:32-p4:64:64-p5:32:32-p6:32:32-p7:160:256:256:32-p8:128:128-i64:64-v16:16-v24:32-v32:32-v48:64-v96:128-v192:256-v256:256-v512:512-v1024:1024-v2048:2048-n32:64-S32-A5-G1-ni:7:8:9"
target triple = "amdgcn-amd-amdhsa"

define protected amdgpu_kernel void @generic_store(ptr addrspace(1) %p, i32 %i) sanitize_address {
; CHECK-LABEL: define protected amdgpu_kernel void @generic_store(
; CHECK-SAME: ptr addrspace(1) [[P:%.*]], i32 [[I:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[Q:%.*]] = addrspacecast ptr addrspace(1) [[P]] to ptr
; CHECK-NEXT:    [[TMP0:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[Q]])
; CHECK-NEXT:    [[TMP1:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[Q]])
; CHECK-NEXT:    [[TMP2:%.*]] = or i1 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[TMP3:%.*]] = xor i1 [[TMP2]], true
; CHECK-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP21:%.*]]
; CHECK:       4:
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[Q]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = lshr i64 [[TMP5]], 3
; CHECK-NEXT:    [[TMP7:%.*]] = add i64 [[TMP6]], 2147450880
; CHECK-NEXT:    [[TMP8:%.*]] = inttoptr i64 [[TMP7]] to ptr
; CHECK-NEXT:    [[TMP9:%.*]] = load i8, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP10:%.*]] = icmp ne i8 [[TMP9]], 0
; CHECK-NEXT:    [[TMP11:%.*]] = and i64 [[TMP5]], 7
; CHECK-NEXT:    [[TMP12:%.*]] = add i64 [[TMP11]], 3
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i64 [[TMP12]] to i8
; CHECK-NEXT:    [[TMP14:%.*]] = icmp sge i8 [[TMP13]], [[TMP9]]
; CHECK-NEXT:    [[TMP15:%.*]] = and i1 [[TMP10]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = call i64 @llvm.amdgcn.ballot.i64(i1 [[TMP15]])
; CHECK-NEXT:    [[TMP17:%.*]] = icmp ne i64 [[TMP16]], 0
; CHECK-NEXT:    br i1 [[TMP17]], label [[ASAN_REPORT:%.*]], label [[TMP20:%.*]], !prof [[PROF0:![0-9]+]]
; CHECK:       asan.report:
; CHECK-NEXT:    br i1 [[TMP15]], label [[TMP18:%.*]], label [[TMP19:%.*]]
; CHECK:       18:
; CHECK-NEXT:    call void @__asan_report_store4(i64 [[TMP5]]) #[[ATTR5:[0-9]+]]
; CHECK-NEXT:    call void @llvm.amdgcn.unreachable()
; CHECK-NEXT:    br label [[TMP19]]
; CHECK:       19:
; CHECK-NEXT:    br label [[TMP20]]
; CHECK:       20:
; CHECK-NEXT:    br label [[TMP21]]
; CHECK:       21:
; CHECK-NEXT:    store i32 0, ptr [[Q]], align 4
; CHECK-NEXT:    ret void
;
; RECOV-LABEL: define protected amdgpu_kernel void @generic_store(
; RECOV-SAME: ptr addrspace(1) [[P:%.*]], i32 [[I:%.*]]) #[[ATTR0:[0-9]+]] {
; RECOV-NEXT:  entry:
; RECOV-NEXT:    [[Q:%.*]] = addrspacecast ptr addrspace(1) [[P]] to ptr
; RECOV-NEXT:    [[TMP0:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[Q]])
; RECOV-NEXT:    [[TMP1:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[Q]])
; RECOV-NEXT:    [[TMP2:%.*]] = or i1 [[TMP0]], [[TMP1]]
; RECOV-NEXT:    [[TMP3:%.*]] = xor i1 [[TMP2]], true
; RECOV-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP17:%.*]]
; RECOV:       4:
; RECOV-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[Q]] to i64
; RECOV-NEXT:    [[TMP6:%.*]] = lshr i64 [[TMP5]], 3
; RECOV-NEXT:    [[TMP7:%.*]] = add i64 [[TMP6]], 2147450880
; RECOV-NEXT:    [[TMP8:%.*]] = inttoptr i64 [[TMP7]] to ptr
; RECOV-NEXT:    [[TMP9:%.*]] = load i8, ptr [[TMP8]], align 1
; RECOV-NEXT:    [[TMP10:%.*]] = icmp ne i8 [[TMP9]], 0
; RECOV-NEXT:    [[TMP11:%.*]] = and i64 [[TMP5]], 7
; RECOV-NEXT:    [[TMP12:%.*]] = add i64 [[TMP11]], 3
; RECOV-NEXT:    [[TMP13:%.*]] = trunc i64 [[TMP12]] to i8
; RECOV-NEXT:    [[TMP14:%.*]] = icmp sge i8 [[TMP13]], [[TMP9]]
; RECOV-NEXT:    [[TMP15:%.*]] = and i1 [[TMP10]], [[TMP14]]
; RECOV-NEXT:    br i1 [[TMP15]], label [[ASAN_REPORT:%.*]], label [[TMP16:%.*]], !prof [[PROF0:![0-9]+]]
; RECOV:       asan.report:
; RECOV-NEXT:    call void @__asan_report_store4_noabort(i64 [[TMP5]]) #[[ATTR3:[0-9]+]]
; RECOV-NEXT:    br label [[TMP16]]
; RECOV:       16:
; RECOV-NEXT:    br label [[TMP17]]
; RECOV:       17:
; RECOV-NEXT:    store i32 0, ptr [[Q]], align 4
; RECOV-NEXT:    ret void
;
entry:

  %q = addrspacecast ptr addrspace(1) %p to ptr
  store i32 0, ptr %q, align 4
  ret void
}

define protected amdgpu_kernel void @generic_load(ptr addrspace(1) %p, i32 %i) sanitize_address {
; CHECK-LABEL: define protected amdgpu_kernel void @generic_load(
; CHECK-SAME: ptr addrspace(1) [[P:%.*]], i32 [[I:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[Q:%.*]] = addrspacecast ptr addrspace(1) [[P]] to ptr
; CHECK-NEXT:    [[TMP0:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[Q]])
; CHECK-NEXT:    [[TMP1:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[Q]])
; CHECK-NEXT:    [[TMP2:%.*]] = or i1 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[TMP3:%.*]] = xor i1 [[TMP2]], true
; CHECK-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP21:%.*]]
; CHECK:       4:
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[Q]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = lshr i64 [[TMP5]], 3
; CHECK-NEXT:    [[TMP7:%.*]] = add i64 [[TMP6]], 2147450880
; CHECK-NEXT:    [[TMP8:%.*]] = inttoptr i64 [[TMP7]] to ptr
; CHECK-NEXT:    [[TMP9:%.*]] = load i8, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP10:%.*]] = icmp ne i8 [[TMP9]], 0
; CHECK-NEXT:    [[TMP11:%.*]] = and i64 [[TMP5]], 7
; CHECK-NEXT:    [[TMP12:%.*]] = add i64 [[TMP11]], 3
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i64 [[TMP12]] to i8
; CHECK-NEXT:    [[TMP14:%.*]] = icmp sge i8 [[TMP13]], [[TMP9]]
; CHECK-NEXT:    [[TMP15:%.*]] = and i1 [[TMP10]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = call i64 @llvm.amdgcn.ballot.i64(i1 [[TMP15]])
; CHECK-NEXT:    [[TMP17:%.*]] = icmp ne i64 [[TMP16]], 0
; CHECK-NEXT:    br i1 [[TMP17]], label [[ASAN_REPORT:%.*]], label [[TMP20:%.*]], !prof [[PROF0]]
; CHECK:       asan.report:
; CHECK-NEXT:    br i1 [[TMP15]], label [[TMP18:%.*]], label [[TMP19:%.*]]
; CHECK:       18:
; CHECK-NEXT:    call void @__asan_report_load4(i64 [[TMP5]]) #[[ATTR5]]
; CHECK-NEXT:    call void @llvm.amdgcn.unreachable()
; CHECK-NEXT:    br label [[TMP19]]
; CHECK:       19:
; CHECK-NEXT:    br label [[TMP20]]
; CHECK:       20:
; CHECK-NEXT:    br label [[TMP21]]
; CHECK:       21:
; CHECK-NEXT:    [[R:%.*]] = load i32, ptr [[Q]], align 4
; CHECK-NEXT:    ret void
;
; RECOV-LABEL: define protected amdgpu_kernel void @generic_load(
; RECOV-SAME: ptr addrspace(1) [[P:%.*]], i32 [[I:%.*]]) #[[ATTR0]] {
; RECOV-NEXT:  entry:
; RECOV-NEXT:    [[Q:%.*]] = addrspacecast ptr addrspace(1) [[P]] to ptr
; RECOV-NEXT:    [[TMP0:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[Q]])
; RECOV-NEXT:    [[TMP1:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[Q]])
; RECOV-NEXT:    [[TMP2:%.*]] = or i1 [[TMP0]], [[TMP1]]
; RECOV-NEXT:    [[TMP3:%.*]] = xor i1 [[TMP2]], true
; RECOV-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP17:%.*]]
; RECOV:       4:
; RECOV-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[Q]] to i64
; RECOV-NEXT:    [[TMP6:%.*]] = lshr i64 [[TMP5]], 3
; RECOV-NEXT:    [[TMP7:%.*]] = add i64 [[TMP6]], 2147450880
; RECOV-NEXT:    [[TMP8:%.*]] = inttoptr i64 [[TMP7]] to ptr
; RECOV-NEXT:    [[TMP9:%.*]] = load i8, ptr [[TMP8]], align 1
; RECOV-NEXT:    [[TMP10:%.*]] = icmp ne i8 [[TMP9]], 0
; RECOV-NEXT:    [[TMP11:%.*]] = and i64 [[TMP5]], 7
; RECOV-NEXT:    [[TMP12:%.*]] = add i64 [[TMP11]], 3
; RECOV-NEXT:    [[TMP13:%.*]] = trunc i64 [[TMP12]] to i8
; RECOV-NEXT:    [[TMP14:%.*]] = icmp sge i8 [[TMP13]], [[TMP9]]
; RECOV-NEXT:    [[TMP15:%.*]] = and i1 [[TMP10]], [[TMP14]]
; RECOV-NEXT:    br i1 [[TMP15]], label [[ASAN_REPORT:%.*]], label [[TMP16:%.*]], !prof [[PROF0]]
; RECOV:       asan.report:
; RECOV-NEXT:    call void @__asan_report_load4_noabort(i64 [[TMP5]]) #[[ATTR3]]
; RECOV-NEXT:    br label [[TMP16]]
; RECOV:       16:
; RECOV-NEXT:    br label [[TMP17]]
; RECOV:       17:
; RECOV-NEXT:    [[R:%.*]] = load i32, ptr [[Q]], align 4
; RECOV-NEXT:    ret void
;
entry:

  %q = addrspacecast ptr addrspace(1) %p to ptr
  %r = load i32, ptr %q, align 4
  ret void
}

define protected amdgpu_kernel void @generic_store_8(ptr addrspace(1) %p) sanitize_address {
; CHECK-LABEL: define protected amdgpu_kernel void @generic_store_8(
; CHECK-SAME: ptr addrspace(1) [[P:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[Q:%.*]] = addrspacecast ptr addrspace(1) [[P]] to ptr
; CHECK-NEXT:    [[TMP0:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[Q]])
; CHECK-NEXT:    [[TMP1:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[Q]])
; CHECK-NEXT:    [[TMP2:%.*]] = or i1 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[TMP3:%.*]] = xor i1 [[TMP2]], true
; CHECK-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP16:%.*]]
; CHECK:       4:
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[Q]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = lshr i64 [[TMP5]], 3
; CHECK-NEXT:    [[TMP7:%.*]] = add i64 [[TMP6]], 2147450880
; CHECK-NEXT:    [[TMP8:%.*]] = inttoptr i64 [[TMP7]] to ptr
; CHECK-NEXT:    [[TMP9:%.*]] = load i8, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP10:%.*]] = icmp ne i8 [[TMP9]], 0
; CHECK-NEXT:    [[TMP11:%.*]] = call i64 @llvm.amdgcn.ballot.i64(i1 [[TMP10]])
; CHECK-NEXT:    [[TMP12:%.*]] = icmp ne i64 [[TMP11]], 0
; CHECK-NEXT:    br i1 [[TMP12]], label [[ASAN_REPORT:%.*]], label [[TMP15:%.*]], !prof [[PROF0]]
; CHECK:       asan.report:
; CHECK-NEXT:    br i1 [[TMP10]], label [[TMP13:%.*]], label [[TMP14:%.*]]
; CHECK:       13:
; CHECK-NEXT:    call void @__asan_report_store8(i64 [[TMP5]]) #[[ATTR5]]
; CHECK-NEXT:    call void @llvm.amdgcn.unreachable()
; CHECK-NEXT:    br label [[TMP14]]
; CHECK:       14:
; CHECK-NEXT:    br label [[TMP15]]
; CHECK:       15:
; CHECK-NEXT:    br label [[TMP16]]
; CHECK:       16:
; CHECK-NEXT:    store i64 0, ptr [[Q]], align 8
; CHECK-NEXT:    ret void
;
; RECOV-LABEL: define protected amdgpu_kernel void @generic_store_8(
; RECOV-SAME: ptr addrspace(1) [[P:%.*]]) #[[ATTR0]] {
; RECOV-NEXT:  entry:
; RECOV-NEXT:    [[Q:%.*]] = addrspacecast ptr addrspace(1) [[P]] to ptr
; RECOV-NEXT:    [[TMP0:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[Q]])
; RECOV-NEXT:    [[TMP1:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[Q]])
; RECOV-NEXT:    [[TMP2:%.*]] = or i1 [[TMP0]], [[TMP1]]
; RECOV-NEXT:    [[TMP3:%.*]] = xor i1 [[TMP2]], true
; RECOV-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP12:%.*]]
; RECOV:       4:
; RECOV-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[Q]] to i64
; RECOV-NEXT:    [[TMP6:%.*]] = lshr i64 [[TMP5]], 3
; RECOV-NEXT:    [[TMP7:%.*]] = add i64 [[TMP6]], 2147450880
; RECOV-NEXT:    [[TMP8:%.*]] = inttoptr i64 [[TMP7]] to ptr
; RECOV-NEXT:    [[TMP9:%.*]] = load i8, ptr [[TMP8]], align 1
; RECOV-NEXT:    [[TMP10:%.*]] = icmp ne i8 [[TMP9]], 0
; RECOV-NEXT:    br i1 [[TMP10]], label [[ASAN_REPORT:%.*]], label [[TMP11:%.*]], !prof [[PROF0]]
; RECOV:       asan.report:
; RECOV-NEXT:    call void @__asan_report_store8_noabort(i64 [[TMP5]]) #[[ATTR3]]
; RECOV-NEXT:    br label [[TMP11]]
; RECOV:       11:
; RECOV-NEXT:    br label [[TMP12]]
; RECOV:       12:
; RECOV-NEXT:    store i64 0, ptr [[Q]], align 8
; RECOV-NEXT:    ret void
;
entry:
  %q = addrspacecast ptr addrspace(1) %p to ptr
  store i64 0, ptr %q, align 8
  ret void
}

define protected amdgpu_kernel void @generic_load_8(ptr addrspace(1) %p) sanitize_address {
; CHECK-LABEL: define protected amdgpu_kernel void @generic_load_8(
; CHECK-SAME: ptr addrspace(1) [[P:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[Q:%.*]] = addrspacecast ptr addrspace(1) [[P]] to ptr
; CHECK-NEXT:    [[TMP0:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[Q]])
; CHECK-NEXT:    [[TMP1:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[Q]])
; CHECK-NEXT:    [[TMP2:%.*]] = or i1 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[TMP3:%.*]] = xor i1 [[TMP2]], true
; CHECK-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP16:%.*]]
; CHECK:       4:
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[Q]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = lshr i64 [[TMP5]], 3
; CHECK-NEXT:    [[TMP7:%.*]] = add i64 [[TMP6]], 2147450880
; CHECK-NEXT:    [[TMP8:%.*]] = inttoptr i64 [[TMP7]] to ptr
; CHECK-NEXT:    [[TMP9:%.*]] = load i8, ptr [[TMP8]], align 1
; CHECK-NEXT:    [[TMP10:%.*]] = icmp ne i8 [[TMP9]], 0
; CHECK-NEXT:    [[TMP11:%.*]] = call i64 @llvm.amdgcn.ballot.i64(i1 [[TMP10]])
; CHECK-NEXT:    [[TMP12:%.*]] = icmp ne i64 [[TMP11]], 0
; CHECK-NEXT:    br i1 [[TMP12]], label [[ASAN_REPORT:%.*]], label [[TMP15:%.*]], !prof [[PROF0]]
; CHECK:       asan.report:
; CHECK-NEXT:    br i1 [[TMP10]], label [[TMP13:%.*]], label [[TMP14:%.*]]
; CHECK:       13:
; CHECK-NEXT:    call void @__asan_report_load8(i64 [[TMP5]]) #[[ATTR5]]
; CHECK-NEXT:    call void @llvm.amdgcn.unreachable()
; CHECK-NEXT:    br label [[TMP14]]
; CHECK:       14:
; CHECK-NEXT:    br label [[TMP15]]
; CHECK:       15:
; CHECK-NEXT:    br label [[TMP16]]
; CHECK:       16:
; CHECK-NEXT:    [[R:%.*]] = load i64, ptr [[Q]], align 8
; CHECK-NEXT:    ret void
;
; RECOV-LABEL: define protected amdgpu_kernel void @generic_load_8(
; RECOV-SAME: ptr addrspace(1) [[P:%.*]]) #[[ATTR0]] {
; RECOV-NEXT:  entry:
; RECOV-NEXT:    [[Q:%.*]] = addrspacecast ptr addrspace(1) [[P]] to ptr
; RECOV-NEXT:    [[TMP0:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[Q]])
; RECOV-NEXT:    [[TMP1:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[Q]])
; RECOV-NEXT:    [[TMP2:%.*]] = or i1 [[TMP0]], [[TMP1]]
; RECOV-NEXT:    [[TMP3:%.*]] = xor i1 [[TMP2]], true
; RECOV-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP12:%.*]]
; RECOV:       4:
; RECOV-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[Q]] to i64
; RECOV-NEXT:    [[TMP6:%.*]] = lshr i64 [[TMP5]], 3
; RECOV-NEXT:    [[TMP7:%.*]] = add i64 [[TMP6]], 2147450880
; RECOV-NEXT:    [[TMP8:%.*]] = inttoptr i64 [[TMP7]] to ptr
; RECOV-NEXT:    [[TMP9:%.*]] = load i8, ptr [[TMP8]], align 1
; RECOV-NEXT:    [[TMP10:%.*]] = icmp ne i8 [[TMP9]], 0
; RECOV-NEXT:    br i1 [[TMP10]], label [[ASAN_REPORT:%.*]], label [[TMP11:%.*]], !prof [[PROF0]]
; RECOV:       asan.report:
; RECOV-NEXT:    call void @__asan_report_load8_noabort(i64 [[TMP5]]) #[[ATTR3]]
; RECOV-NEXT:    br label [[TMP11]]
; RECOV:       11:
; RECOV-NEXT:    br label [[TMP12]]
; RECOV:       12:
; RECOV-NEXT:    [[R:%.*]] = load i64, ptr [[Q]], align 8
; RECOV-NEXT:    ret void
;
entry:
  %q = addrspacecast ptr addrspace(1) %p to ptr
  %r = load i64, ptr %q, align 8
  ret void
}
