/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.net.SocketNodeEventListener;
import org.apache.log4j.plugins.Pauseable;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class SocketNode
extends ComponentBase
implements Runnable,
Pauseable {
    private boolean paused;
    private Socket socket;
    private Receiver receiver;
    private SocketNodeEventListener listener;
    private List listenerList = Collections.synchronizedList(new ArrayList());

    public SocketNode(Socket socket, LoggerRepository hierarchy) {
        this.socket = socket;
        this.repository = hierarchy;
    }

    public SocketNode(Socket socket, Receiver receiver) {
        this.socket = socket;
        this.receiver = receiver;
    }

    public void setListener(SocketNodeEventListener _listener) {
        this.removeSocketNodeEventListener(_listener);
        this.addSocketNodeEventListener(_listener);
    }

    public void addSocketNodeEventListener(SocketNodeEventListener listener) {
        this.listenerList.add(listener);
    }

    public void removeSocketNodeEventListener(SocketNodeEventListener listener) {
        this.listenerList.remove(listener);
    }

    public void run() {
        Exception listenerException = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (Exception e) {
            ois = null;
            listenerException = e;
            this.getLogger().error((Object)("Exception opening ObjectInputStream to " + this.socket), e);
        }
        if (ois != null) {
            String remoteInfo = this.socket.getInetAddress().getHostName() + ":" + this.socket.getPort();
            this.fireSocketOpened(remoteInfo);
            try {
                while (true) {
                    LoggingEvent event = (LoggingEvent)ois.readObject();
                    event.setProperty("log4j.remoteSourceInfo", remoteInfo);
                    if (this.isPaused()) continue;
                    if (this.receiver != null) {
                        this.receiver.doPost(event);
                        continue;
                    }
                    Logger remoteLogger = this.repository.getLogger(event.getLoggerName());
                    if (!event.getLevel().isGreaterOrEqual(remoteLogger.getEffectiveLevel())) continue;
                    remoteLogger.callAppenders(event);
                }
            }
            catch (EOFException e) {
                this.getLogger().info("Caught java.io.EOFException closing connection.");
                listenerException = e;
            }
            catch (SocketException e) {
                this.getLogger().info("Caught java.net.SocketException closing connection.");
                listenerException = e;
            }
            catch (IOException e) {
                this.getLogger().info("Caught java.io.IOException: " + e);
                this.getLogger().info("Closing connection.");
                listenerException = e;
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Unexpected exception. Closing connection.", e);
                listenerException = e;
            }
        }
        try {
            if (ois != null) {
                ois.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.listener != null || this.listenerList.size() > 0) {
            this.fireSocketClosedEvent(listenerException);
        }
    }

    private void fireSocketClosedEvent(Exception listenerException) {
        List list = this.listenerList;
        synchronized (list) {
            Iterator iter = this.listenerList.iterator();
            while (iter.hasNext()) {
                SocketNodeEventListener snel = (SocketNodeEventListener)iter.next();
                if (snel == null) continue;
                snel.socketClosedEvent(listenerException);
            }
        }
    }

    private void fireSocketOpened(String remoteInfo) {
        List list = this.listenerList;
        synchronized (list) {
            Iterator iter = this.listenerList.iterator();
            while (iter.hasNext()) {
                SocketNodeEventListener snel = (SocketNodeEventListener)iter.next();
                if (snel == null) continue;
                snel.socketOpened(remoteInfo);
            }
        }
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }
}

