/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.scripting;

import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.scripting.ScriptingEngine;

public abstract class ScriptableDelegate {
    private ScriptingEngine _scriptEngine;
    private static final ScriptingEngine NULL_SCRIPT_ENGINE = new ScriptingEngine(){

        public boolean supportsScriptLanguage(String language) {
            return false;
        }

        public String executeScript(String language, String script) {
            return "";
        }

        public boolean performEvent(String eventScript) {
            return true;
        }

        public String getURLContents(String urlString) {
            return null;
        }

        public ScriptingEngine newScriptingEngine(ScriptableDelegate child) {
            return this;
        }
    };

    public boolean supportsScript(String language) {
        return this.getScriptEngine().supportsScriptLanguage(language);
    }

    public boolean doEvent(String eventScript) {
        if (eventScript.length() == 0) {
            return true;
        }
        return this.getScriptEngine().performEvent(eventScript);
    }

    public String runScript(String language, String script) {
        return script.length() == 0 ? "" : this.getScriptEngine().executeScript(language, script);
    }

    public String evaluateURL(String urlString) {
        if (urlString.length() == 0) {
            return null;
        }
        return this.getScriptEngine().getURLContents(urlString);
    }

    public Object get(String propertyName) {
        return null;
    }

    public Object get(int index) {
        return null;
    }

    public void set(String propertyName, Object value) {
        throw new RuntimeException("No such property: " + propertyName);
    }

    public void setScriptEngine(ScriptingEngine scriptEngine) {
        this._scriptEngine = scriptEngine;
    }

    public ScriptingEngine getScriptEngine() {
        return this._scriptEngine != null ? this._scriptEngine : NULL_SCRIPT_ENGINE;
    }

    public ScriptingEngine getScriptEngine(ScriptableDelegate child) {
        return this.getScriptEngine().newScriptingEngine(child);
    }

    protected ScriptableDelegate[] getDelegates(HTMLElement[] elements) {
        ScriptableDelegate[] result = new ScriptableDelegate[elements.length];
        int i = 0;
        while (i < elements.length) {
            result[i] = elements[i].getScriptableDelegate();
            ++i;
        }
        return result;
    }
}

