/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.jpg;

import com.sun.jimi.core.encoder.jpg.CompressInfo;
import com.sun.jimi.core.encoder.jpg.util;

public class Sample {
    public static void downsample(CompressInfo compressInfo, int n, int n2, int n3, short[][] sArray, short[][] sArray2) {
        int n4 = compressInfo.max_v_samp_factor / compressInfo.comp_info[n].v_samp_factor;
        int n5 = compressInfo.max_h_samp_factor / compressInfo.comp_info[n].h_samp_factor;
        if (n4 == 1 && n5 == 1) {
            Sample.fullsize_downsample(n2, n3, sArray, sArray2);
        } else if (n5 == 2 && n4 == 2) {
            Sample.h2v2_downsample(n2, n3, sArray, sArray2);
        } else if (n5 == 2 && n4 == 1) {
            Sample.h2v1_downsample(n2, n3, sArray, sArray2);
        } else {
            util.errexit("Down sample ratio not supported.");
        }
    }

    public static void edge_expand(CompressInfo compressInfo, int n, int n2, int n3, int n4, short[][][] sArray) {
        int n5;
        int n6;
        int n7;
        if (n < n3) {
            int n8 = n3 - n;
            short s = 0;
            while (s < compressInfo.num_components) {
                n7 = 0;
                while (n7 < n2) {
                    n6 = sArray[s][n7][n - 1];
                    n5 = n8;
                    while (n5 > 0) {
                        sArray[s][n7][n3 - n5] = n6;
                        --n5;
                    }
                    ++n7;
                }
                s = (short)(s + 1);
            }
        }
        if (n2 < n4) {
            n7 = 0;
            while (n7 < compressInfo.num_components) {
                n6 = n2;
                while (n6 < n4) {
                    n5 = 0;
                    while (n5 < n3) {
                        sArray[n7][n6][n5] = sArray[n7][n2 - 1][n5];
                        ++n5;
                    }
                    ++n6;
                }
                n7 = (short)(n7 + 1);
            }
        }
    }

    public static void fullsize_downsample(int n, int n2, short[][] sArray, short[][] sArray2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                sArray2[n3][n4] = sArray[n3][n4];
                ++n4;
            }
            ++n3;
        }
    }

    public static void h2v1_downsample(int n, int n2, short[][] sArray, short[][] sArray2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = 0;
            while (n4 < n) {
                sArray2[n3][n4] = (short)((sArray[n3][n5] + sArray[n3][n5 + 1] + 1) / 2);
                ++n4;
                n5 += 2;
            }
            ++n3;
        }
    }

    public static void h2v2_downsample(int n, int n2, short[][] sArray, short[][] sArray2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            int n6 = 0;
            while (n5 < n) {
                sArray2[n4][n5] = (short)((sArray[n3][n6] + sArray[n3][n6 + 1] + sArray[n3 + 1][n6] + sArray[n3 + 1][n6 + 1] + 2) / 4);
                ++n5;
                n6 += 2;
            }
            n3 += 2;
            ++n4;
        }
    }
}

