/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.ftp2.parser;

import java.util.Calendar;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.ftp2.FTPFileEntryParser;
import org.apache.commons.net.ftp.ftp2.parser.MatchApparatus;

public class OS2FTPEntryParser
extends MatchApparatus
implements FTPFileEntryParser {
    private static final String REGEX = "(\\s+|[0-9]+)\\s*(\\s+|[A-Z]+)\\s*(DIR|\\s+)\\s*((?:0[1-9])|(?:1[0-2]))-((?:0[1-9])|(?:[1-2]\\d)|(?:3[0-1]))-(\\d\\d)\\s*(?:([0-1]\\d)|(?:2[0-3])):([0-5]\\d)\\s*(\\S.*)";

    public OS2FTPEntryParser() {
        super(REGEX);
    }

    public FTPFile parseFTPEntry(String entry) {
        FTPFile f = new FTPFile();
        if (this.matches(entry)) {
            String size = this.group(1);
            String attrib = this.group(2);
            String dirString = this.group(3);
            String mo = this.group(4);
            String da = this.group(5);
            String yr = this.group(6);
            String hr = this.group(7);
            String min = this.group(8);
            String name = this.group(9);
            if (dirString.trim().equals("DIR") || attrib.trim().equals("DIR")) {
                f.setType(1);
            } else {
                f.setType(0);
            }
            Calendar cal = Calendar.getInstance();
            int month = new Integer(mo) - 1;
            int day = new Integer(da);
            int year = new Integer(yr) + 2000;
            int hour = new Integer(hr);
            int minutes = new Integer(min);
            if (year > 2080) {
                year -= 100;
            }
            cal.set(13, 0);
            cal.set(12, minutes);
            cal.set(11, hour);
            cal.set(1, year);
            cal.set(5, day);
            cal.set(2, month);
            f.setTimestamp(cal);
            f.setName(name.trim());
            Long theSize = new Long(size.trim());
            theSize = new Long(String.valueOf(theSize.intValue()));
            f.setSize(theSize);
            return f;
        }
        return null;
    }
}

