// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct GetParametersForImportOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key to use in a subsequent <code>ImportKeyMaterial</code> request. This is the same KMS key specified in the <code>GetParametersForImport</code> request.</p>
    pub key_id: ::std::option::Option<::std::string::String>,
    /// <p>The import token to send in a subsequent <code>ImportKeyMaterial</code> request.</p>
    pub import_token: ::std::option::Option<::aws_smithy_types::Blob>,
    /// <p>The public key to use to encrypt the key material before importing it with <code>ImportKeyMaterial</code>.</p>
    pub public_key: ::std::option::Option<::aws_smithy_types::Blob>,
    /// <p>The time at which the import token and public key are no longer valid. After this time, you cannot use them to make an <code>ImportKeyMaterial</code> request and you must send another <code>GetParametersForImport</code> request to get new ones.</p>
    pub parameters_valid_to: ::std::option::Option<::aws_smithy_types::DateTime>,
    _request_id: Option<String>,
}
impl GetParametersForImportOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key to use in a subsequent <code>ImportKeyMaterial</code> request. This is the same KMS key specified in the <code>GetParametersForImport</code> request.</p>
    pub fn key_id(&self) -> ::std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The import token to send in a subsequent <code>ImportKeyMaterial</code> request.</p>
    pub fn import_token(&self) -> ::std::option::Option<&::aws_smithy_types::Blob> {
        self.import_token.as_ref()
    }
    /// <p>The public key to use to encrypt the key material before importing it with <code>ImportKeyMaterial</code>.</p>
    pub fn public_key(&self) -> ::std::option::Option<&::aws_smithy_types::Blob> {
        self.public_key.as_ref()
    }
    /// <p>The time at which the import token and public key are no longer valid. After this time, you cannot use them to make an <code>ImportKeyMaterial</code> request and you must send another <code>GetParametersForImport</code> request to get new ones.</p>
    pub fn parameters_valid_to(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.parameters_valid_to.as_ref()
    }
}
impl ::std::fmt::Debug for GetParametersForImportOutput {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("GetParametersForImportOutput");
        formatter.field("key_id", &self.key_id);
        formatter.field("import_token", &self.import_token);
        formatter.field("public_key", &"*** Sensitive Data Redacted ***");
        formatter.field("parameters_valid_to", &self.parameters_valid_to);
        formatter.field("_request_id", &self._request_id);
        formatter.finish()
    }
}
impl ::aws_types::request_id::RequestId for GetParametersForImportOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl GetParametersForImportOutput {
    /// Creates a new builder-style object to manufacture [`GetParametersForImportOutput`](crate::operation::get_parameters_for_import::GetParametersForImportOutput).
    pub fn builder() -> crate::operation::get_parameters_for_import::builders::GetParametersForImportOutputBuilder {
        crate::operation::get_parameters_for_import::builders::GetParametersForImportOutputBuilder::default()
    }
}

/// A builder for [`GetParametersForImportOutput`](crate::operation::get_parameters_for_import::GetParametersForImportOutput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
pub struct GetParametersForImportOutputBuilder {
    pub(crate) key_id: ::std::option::Option<::std::string::String>,
    pub(crate) import_token: ::std::option::Option<::aws_smithy_types::Blob>,
    pub(crate) public_key: ::std::option::Option<::aws_smithy_types::Blob>,
    pub(crate) parameters_valid_to: ::std::option::Option<::aws_smithy_types::DateTime>,
    _request_id: Option<String>,
}
impl GetParametersForImportOutputBuilder {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key to use in a subsequent <code>ImportKeyMaterial</code> request. This is the same KMS key specified in the <code>GetParametersForImport</code> request.</p>
    pub fn key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key to use in a subsequent <code>ImportKeyMaterial</code> request. This is the same KMS key specified in the <code>GetParametersForImport</code> request.</p>
    pub fn set_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.key_id = input;
        self
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key to use in a subsequent <code>ImportKeyMaterial</code> request. This is the same KMS key specified in the <code>GetParametersForImport</code> request.</p>
    pub fn get_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.key_id
    }
    /// <p>The import token to send in a subsequent <code>ImportKeyMaterial</code> request.</p>
    pub fn import_token(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.import_token = ::std::option::Option::Some(input);
        self
    }
    /// <p>The import token to send in a subsequent <code>ImportKeyMaterial</code> request.</p>
    pub fn set_import_token(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.import_token = input;
        self
    }
    /// <p>The import token to send in a subsequent <code>ImportKeyMaterial</code> request.</p>
    pub fn get_import_token(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.import_token
    }
    /// <p>The public key to use to encrypt the key material before importing it with <code>ImportKeyMaterial</code>.</p>
    pub fn public_key(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.public_key = ::std::option::Option::Some(input);
        self
    }
    /// <p>The public key to use to encrypt the key material before importing it with <code>ImportKeyMaterial</code>.</p>
    pub fn set_public_key(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.public_key = input;
        self
    }
    /// <p>The public key to use to encrypt the key material before importing it with <code>ImportKeyMaterial</code>.</p>
    pub fn get_public_key(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.public_key
    }
    /// <p>The time at which the import token and public key are no longer valid. After this time, you cannot use them to make an <code>ImportKeyMaterial</code> request and you must send another <code>GetParametersForImport</code> request to get new ones.</p>
    pub fn parameters_valid_to(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.parameters_valid_to = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time at which the import token and public key are no longer valid. After this time, you cannot use them to make an <code>ImportKeyMaterial</code> request and you must send another <code>GetParametersForImport</code> request to get new ones.</p>
    pub fn set_parameters_valid_to(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.parameters_valid_to = input;
        self
    }
    /// <p>The time at which the import token and public key are no longer valid. After this time, you cannot use them to make an <code>ImportKeyMaterial</code> request and you must send another <code>GetParametersForImport</code> request to get new ones.</p>
    pub fn get_parameters_valid_to(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.parameters_valid_to
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`GetParametersForImportOutput`](crate::operation::get_parameters_for_import::GetParametersForImportOutput).
    pub fn build(self) -> crate::operation::get_parameters_for_import::GetParametersForImportOutput {
        crate::operation::get_parameters_for_import::GetParametersForImportOutput {
            key_id: self.key_id,
            import_token: self.import_token,
            public_key: self.public_key,
            parameters_valid_to: self.parameters_valid_to,
            _request_id: self._request_id,
        }
    }
}
impl ::std::fmt::Debug for GetParametersForImportOutputBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("GetParametersForImportOutputBuilder");
        formatter.field("key_id", &self.key_id);
        formatter.field("import_token", &self.import_token);
        formatter.field("public_key", &"*** Sensitive Data Redacted ***");
        formatter.field("parameters_valid_to", &self.parameters_valid_to);
        formatter.field("_request_id", &self._request_id);
        formatter.finish()
    }
}
