// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) Go Code Generator. DO NOT EDIT.

package azkeys

// CurveName - Elliptic curve name.
type CurveName string

const (
	// CurveNameP256 - The NIST P-256 elliptic curve, AKA SECG curve SECP256R1.
	CurveNameP256 CurveName = "P-256"
	// CurveNameP256K - The SECG SECP256K1 elliptic curve.
	CurveNameP256K CurveName = "P-256K"
	// CurveNameP384 - The NIST P-384 elliptic curve, AKA SECG curve SECP384R1.
	CurveNameP384 CurveName = "P-384"
	// CurveNameP521 - The NIST P-521 elliptic curve, AKA SECG curve SECP521R1.
	CurveNameP521 CurveName = "P-521"
)

// PossibleCurveNameValues returns the possible values for the CurveName const type.
func PossibleCurveNameValues() []CurveName {
	return []CurveName{
		CurveNameP256,
		CurveNameP256K,
		CurveNameP384,
		CurveNameP521,
	}
}

// EncryptionAlgorithm - An algorithm used for encryption and decryption.
type EncryptionAlgorithm string

const (
	// EncryptionAlgorithmA128CBC - 128-bit AES-CBC.
	EncryptionAlgorithmA128CBC EncryptionAlgorithm = "A128CBC"
	// EncryptionAlgorithmA128CBCPAD - 128-bit AES-CBC with PKCS padding.
	EncryptionAlgorithmA128CBCPAD EncryptionAlgorithm = "A128CBCPAD"
	// EncryptionAlgorithmA128GCM - 128-bit AES-GCM.
	EncryptionAlgorithmA128GCM EncryptionAlgorithm = "A128GCM"
	// EncryptionAlgorithmA128KW - 128-bit AES key wrap.
	EncryptionAlgorithmA128KW EncryptionAlgorithm = "A128KW"
	// EncryptionAlgorithmA192CBC - 192-bit AES-CBC.
	EncryptionAlgorithmA192CBC EncryptionAlgorithm = "A192CBC"
	// EncryptionAlgorithmA192CBCPAD - 192-bit AES-CBC with PKCS padding.
	EncryptionAlgorithmA192CBCPAD EncryptionAlgorithm = "A192CBCPAD"
	// EncryptionAlgorithmA192GCM - 192-bit AES-GCM.
	EncryptionAlgorithmA192GCM EncryptionAlgorithm = "A192GCM"
	// EncryptionAlgorithmA192KW - 192-bit AES key wrap.
	EncryptionAlgorithmA192KW EncryptionAlgorithm = "A192KW"
	// EncryptionAlgorithmA256CBC - 256-bit AES-CBC.
	EncryptionAlgorithmA256CBC EncryptionAlgorithm = "A256CBC"
	// EncryptionAlgorithmA256CBCPAD - 256-bit AES-CBC with PKCS padding.
	EncryptionAlgorithmA256CBCPAD EncryptionAlgorithm = "A256CBCPAD"
	// EncryptionAlgorithmA256GCM - 256-bit AES-GCM.
	EncryptionAlgorithmA256GCM EncryptionAlgorithm = "A256GCM"
	// EncryptionAlgorithmA256KW - 256-bit AES key wrap.
	EncryptionAlgorithmA256KW EncryptionAlgorithm = "A256KW"
	// EncryptionAlgorithmRSA15 - RSAES-PKCS1-V1_5 key encryption, as described in https://tools.ietf.org/html/rfc3447.
	EncryptionAlgorithmRSA15 EncryptionAlgorithm = "RSA1_5"
	// EncryptionAlgorithmRSAOAEP - RSAES using Optimal Asymmetric Encryption Padding (OAEP), as described in https://tools.ietf.org/html/rfc3447,
	// with the default parameters specified by RFC 3447 in Section A.2.1. Those default parameters are using a hash function
	// of SHA-1 and a mask generation function of MGF1 with SHA-1.
	EncryptionAlgorithmRSAOAEP EncryptionAlgorithm = "RSA-OAEP"
	// EncryptionAlgorithmRSAOAEP256 - RSAES using Optimal Asymmetric Encryption Padding with a hash function of SHA-256 and a
	// mask generation function of MGF1 with SHA-256.
	EncryptionAlgorithmRSAOAEP256 EncryptionAlgorithm = "RSA-OAEP-256"
)

// PossibleEncryptionAlgorithmValues returns the possible values for the EncryptionAlgorithm const type.
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return []EncryptionAlgorithm{
		EncryptionAlgorithmA128CBC,
		EncryptionAlgorithmA128CBCPAD,
		EncryptionAlgorithmA128GCM,
		EncryptionAlgorithmA128KW,
		EncryptionAlgorithmA192CBC,
		EncryptionAlgorithmA192CBCPAD,
		EncryptionAlgorithmA192GCM,
		EncryptionAlgorithmA192KW,
		EncryptionAlgorithmA256CBC,
		EncryptionAlgorithmA256CBCPAD,
		EncryptionAlgorithmA256GCM,
		EncryptionAlgorithmA256KW,
		EncryptionAlgorithmRSA15,
		EncryptionAlgorithmRSAOAEP,
		EncryptionAlgorithmRSAOAEP256,
	}
}

// KeyEncryptionAlgorithm - The encryption algorithm to use to protected the exported key material
type KeyEncryptionAlgorithm string

const (
	// KeyEncryptionAlgorithmCKMRSAAESKEYWRAP - The CKM_RSA_AES_KEY_WRAP key wrap mechanism.
	KeyEncryptionAlgorithmCKMRSAAESKEYWRAP KeyEncryptionAlgorithm = "CKM_RSA_AES_KEY_WRAP"
	// KeyEncryptionAlgorithmRSAAESKEYWRAP256 - The RSA_AES_KEY_WRAP_256 key wrap mechanism.
	KeyEncryptionAlgorithmRSAAESKEYWRAP256 KeyEncryptionAlgorithm = "RSA_AES_KEY_WRAP_256"
	// KeyEncryptionAlgorithmRSAAESKEYWRAP384 - The RSA_AES_KEY_WRAP_384 key wrap mechanism.
	KeyEncryptionAlgorithmRSAAESKEYWRAP384 KeyEncryptionAlgorithm = "RSA_AES_KEY_WRAP_384"
)

// PossibleKeyEncryptionAlgorithmValues returns the possible values for the KeyEncryptionAlgorithm const type.
func PossibleKeyEncryptionAlgorithmValues() []KeyEncryptionAlgorithm {
	return []KeyEncryptionAlgorithm{
		KeyEncryptionAlgorithmCKMRSAAESKEYWRAP,
		KeyEncryptionAlgorithmRSAAESKEYWRAP256,
		KeyEncryptionAlgorithmRSAAESKEYWRAP384,
	}
}

// KeyOperation - JSON web key operations.
type KeyOperation string

const (
	// KeyOperationDecrypt - Indicates that the key can be used to decrypt.
	KeyOperationDecrypt KeyOperation = "decrypt"
	// KeyOperationEncrypt - Indicates that the key can be used to encrypt.
	KeyOperationEncrypt KeyOperation = "encrypt"

	// KeyOperationImport - Indicates that the key can be imported during creation.
	KeyOperationImport KeyOperation = "import"
	// KeyOperationSign - Indicates that the key can be used to sign.
	KeyOperationSign KeyOperation = "sign"
	// KeyOperationUnwrapKey - Indicates that the key can be used to unwrap another key.
	KeyOperationUnwrapKey KeyOperation = "unwrapKey"
	// KeyOperationVerify - Indicates that the key can be used to verify.
	KeyOperationVerify KeyOperation = "verify"
	// KeyOperationWrapKey - Indicates that the key can be used to wrap another key.
	KeyOperationWrapKey KeyOperation = "wrapKey"
)

// PossibleKeyOperationValues returns the possible values for the KeyOperation const type.
func PossibleKeyOperationValues() []KeyOperation {
	return []KeyOperation{
		KeyOperationDecrypt,
		KeyOperationEncrypt,

		KeyOperationImport,
		KeyOperationSign,
		KeyOperationUnwrapKey,
		KeyOperationVerify,
		KeyOperationWrapKey,
	}
}

// KeyRotationPolicyAction - The type of the action. The value should be compared case-insensitively.
type KeyRotationPolicyAction string

const (
	// KeyRotationPolicyActionNotify - Trigger Event Grid events. Defaults to 30 days before expiry. Key Vault only.
	KeyRotationPolicyActionNotify KeyRotationPolicyAction = "Notify"
	// KeyRotationPolicyActionRotate - Rotate the key based on the key policy.
	KeyRotationPolicyActionRotate KeyRotationPolicyAction = "Rotate"
)

// PossibleKeyRotationPolicyActionValues returns the possible values for the KeyRotationPolicyAction const type.
func PossibleKeyRotationPolicyActionValues() []KeyRotationPolicyAction {
	return []KeyRotationPolicyAction{
		KeyRotationPolicyActionNotify,
		KeyRotationPolicyActionRotate,
	}
}

// KeyType - JsonWebKey Key Type (kty), as defined in https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
type KeyType string

const (
	// KeyTypeEC - Elliptic Curve.
	KeyTypeEC KeyType = "EC"
	// KeyTypeECHSM - Elliptic Curve with a private key which is stored in the HSM.
	KeyTypeECHSM KeyType = "EC-HSM"
	// KeyTypeOct - Octet sequence (used to represent symmetric keys)
	KeyTypeOct KeyType = "oct"
	// KeyTypeOctHSM - Octet sequence (used to represent symmetric keys) which is stored the HSM.
	KeyTypeOctHSM KeyType = "oct-HSM"
	// KeyTypeRSA - RSA (https://tools.ietf.org/html/rfc3447)
	KeyTypeRSA KeyType = "RSA"
	// KeyTypeRSAHSM - RSA with a private key which is stored in the HSM.
	KeyTypeRSAHSM KeyType = "RSA-HSM"
)

// PossibleKeyTypeValues returns the possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{
		KeyTypeEC,
		KeyTypeECHSM,
		KeyTypeOct,
		KeyTypeOctHSM,
		KeyTypeRSA,
		KeyTypeRSAHSM,
	}
}

// SignatureAlgorithm - The signing/verification algorithm identifier.
type SignatureAlgorithm string

const (
	// SignatureAlgorithmES256 - ECDSA using P-256 and SHA-256, as described in https://tools.ietf.org/html/rfc7518.
	SignatureAlgorithmES256 SignatureAlgorithm = "ES256"
	// SignatureAlgorithmES256K - ECDSA using P-256K and SHA-256, as described in https://tools.ietf.org/html/rfc7518
	SignatureAlgorithmES256K SignatureAlgorithm = "ES256K"
	// SignatureAlgorithmES384 - ECDSA using P-384 and SHA-384, as described in https://tools.ietf.org/html/rfc7518
	SignatureAlgorithmES384 SignatureAlgorithm = "ES384"
	// SignatureAlgorithmES512 - ECDSA using P-521 and SHA-512, as described in https://tools.ietf.org/html/rfc7518
	SignatureAlgorithmES512 SignatureAlgorithm = "ES512"
	// SignatureAlgorithmPS256 - RSASSA-PSS using SHA-256 and MGF1 with SHA-256, as described in https://tools.ietf.org/html/rfc7518
	SignatureAlgorithmPS256 SignatureAlgorithm = "PS256"
	// SignatureAlgorithmPS384 - RSASSA-PSS using SHA-384 and MGF1 with SHA-384, as described in https://tools.ietf.org/html/rfc7518
	SignatureAlgorithmPS384 SignatureAlgorithm = "PS384"
	// SignatureAlgorithmPS512 - RSASSA-PSS using SHA-512 and MGF1 with SHA-512, as described in https://tools.ietf.org/html/rfc7518
	SignatureAlgorithmPS512 SignatureAlgorithm = "PS512"
	// SignatureAlgorithmRS256 - RSASSA-PKCS1-v1_5 using SHA-256, as described in https://tools.ietf.org/html/rfc7518
	SignatureAlgorithmRS256 SignatureAlgorithm = "RS256"
	// SignatureAlgorithmRS384 - RSASSA-PKCS1-v1_5 using SHA-384, as described in https://tools.ietf.org/html/rfc7518
	SignatureAlgorithmRS384 SignatureAlgorithm = "RS384"
	// SignatureAlgorithmRS512 - RSASSA-PKCS1-v1_5 using SHA-512, as described in https://tools.ietf.org/html/rfc7518
	SignatureAlgorithmRS512 SignatureAlgorithm = "RS512"
)

// PossibleSignatureAlgorithmValues returns the possible values for the SignatureAlgorithm const type.
func PossibleSignatureAlgorithmValues() []SignatureAlgorithm {
	return []SignatureAlgorithm{
		SignatureAlgorithmES256,
		SignatureAlgorithmES256K,
		SignatureAlgorithmES384,
		SignatureAlgorithmES512,
		SignatureAlgorithmPS256,
		SignatureAlgorithmPS384,
		SignatureAlgorithmPS512,
		SignatureAlgorithmRS256,
		SignatureAlgorithmRS384,
		SignatureAlgorithmRS512,
	}
}
