// emif_ddr4.v

// Generated using ACDS version 17.0 290

`timescale 1 ps / 1 ps
module emif_ddr4 #(
	// To be fixed: These are all currently ignored.
	parameter DDR_ADDR_WIDTH = 26,
	parameter DDR_DATA_WIDTH = 512,
	parameter SYMBOL_WIDTH = 8,
	parameter NUM_SYMBOLS = (DDR_DATA_WIDTH + SYMBOL_WIDTH - 1) / SYMBOL_WIDTH
) (
		output wire         ddr4a_avmm_waitrequest,                     //                    ddr4a_avmm.waitrequest
		output wire [511:0] ddr4a_avmm_readdata,                        //                              .readdata
		output wire         ddr4a_avmm_readdatavalid,                   //                              .readdatavalid
		input  wire [6:0]   ddr4a_avmm_burstcount,                      //                              .burstcount
		input  wire [511:0] ddr4a_avmm_writedata,                       //                              .writedata
		input  wire [25:0]  ddr4a_avmm_address,                         //                              .address
		input  wire         ddr4a_avmm_write,                           //                              .write
		input  wire         ddr4a_avmm_read,                            //                              .read
		input  wire [63:0]  ddr4a_avmm_byteenable,                      //                              .byteenable
		input  wire         ddr4a_avmm_debugaccess,                     //                              .debugaccess
		output wire         ddr4a_avmm_clk_clk,                         //                ddr4a_avmm_clk.clk
		input  wire         ddr4a_global_reset_reset_sink_reset_n,      // ddr4a_global_reset_reset_sink.reset_n
		output wire [0:0]   ddr4a_mem_conduit_end_mem_ck,               //         ddr4a_mem_conduit_end.mem_ck
		output wire [0:0]   ddr4a_mem_conduit_end_mem_ck_n,             //                              .mem_ck_n
		output wire [16:0]  ddr4a_mem_conduit_end_mem_a,                //                              .mem_a
		output wire [0:0]   ddr4a_mem_conduit_end_mem_act_n,            //                              .mem_act_n
		output wire [1:0]   ddr4a_mem_conduit_end_mem_ba,               //                              .mem_ba
		output wire [1:0]   ddr4a_mem_conduit_end_mem_bg,               //                              .mem_bg
		output wire [0:0]   ddr4a_mem_conduit_end_mem_cke,              //                              .mem_cke
		output wire [0:0]   ddr4a_mem_conduit_end_mem_cs_n,             //                              .mem_cs_n
		output wire [0:0]   ddr4a_mem_conduit_end_mem_odt,              //                              .mem_odt
		output wire [0:0]   ddr4a_mem_conduit_end_mem_reset_n,          //                              .mem_reset_n
		output wire [0:0]   ddr4a_mem_conduit_end_mem_par,              //                              .mem_par
		input  wire [0:0]   ddr4a_mem_conduit_end_mem_alert_n,          //                              .mem_alert_n
		inout  wire [7:0]   ddr4a_mem_conduit_end_mem_dqs,              //                              .mem_dqs
		inout  wire [7:0]   ddr4a_mem_conduit_end_mem_dqs_n,            //                              .mem_dqs_n
		inout  wire [63:0]  ddr4a_mem_conduit_end_mem_dq,               //                              .mem_dq
		inout  wire [7:0]   ddr4a_mem_conduit_end_mem_dbi_n,            //                              .mem_dbi_n
		input  wire         ddr4a_oct_conduit_end_oct_rzqin,            //         ddr4a_oct_conduit_end.oct_rzqin
		input  wire         ddr4a_pll_ref_clk_clock_sink_clk,           //  ddr4a_pll_ref_clk_clock_sink.clk
		output wire         ddr4a_status_conduit_end_local_cal_success, //      ddr4a_status_conduit_end.local_cal_success
		output wire         ddr4a_status_conduit_end_local_cal_fail,    //                              .local_cal_fail
		output wire         ddr4b_avmm_waitrequest,                     //                    ddr4b_avmm.waitrequest
		output wire [511:0] ddr4b_avmm_readdata,                        //                              .readdata
		output wire         ddr4b_avmm_readdatavalid,                   //                              .readdatavalid
		input  wire [6:0]   ddr4b_avmm_burstcount,                      //                              .burstcount
		input  wire [511:0] ddr4b_avmm_writedata,                       //                              .writedata
		input  wire [25:0]  ddr4b_avmm_address,                         //                              .address
		input  wire         ddr4b_avmm_write,                           //                              .write
		input  wire         ddr4b_avmm_read,                            //                              .read
		input  wire [63:0]  ddr4b_avmm_byteenable,                      //                              .byteenable
		input  wire         ddr4b_avmm_debugaccess,                     //                              .debugaccess
		output wire         ddr4b_avmm_clk_clk,                         //                ddr4b_avmm_clk.clk
		output wire [0:0]   ddr4b_mem_conduit_end_mem_ck,               //         ddr4b_mem_conduit_end.mem_ck
		output wire [0:0]   ddr4b_mem_conduit_end_mem_ck_n,             //                              .mem_ck_n
		output wire [16:0]  ddr4b_mem_conduit_end_mem_a,                //                              .mem_a
		output wire [0:0]   ddr4b_mem_conduit_end_mem_act_n,            //                              .mem_act_n
		output wire [1:0]   ddr4b_mem_conduit_end_mem_ba,               //                              .mem_ba
		output wire [1:0]   ddr4b_mem_conduit_end_mem_bg,               //                              .mem_bg
		output wire [0:0]   ddr4b_mem_conduit_end_mem_cke,              //                              .mem_cke
		output wire [0:0]   ddr4b_mem_conduit_end_mem_cs_n,             //                              .mem_cs_n
		output wire [0:0]   ddr4b_mem_conduit_end_mem_odt,              //                              .mem_odt
		output wire [0:0]   ddr4b_mem_conduit_end_mem_reset_n,          //                              .mem_reset_n
		output wire [0:0]   ddr4b_mem_conduit_end_mem_par,              //                              .mem_par
		input  wire [0:0]   ddr4b_mem_conduit_end_mem_alert_n,          //                              .mem_alert_n
		inout  wire [7:0]   ddr4b_mem_conduit_end_mem_dqs,              //                              .mem_dqs
		inout  wire [7:0]   ddr4b_mem_conduit_end_mem_dqs_n,            //                              .mem_dqs_n
		inout  wire [63:0]  ddr4b_mem_conduit_end_mem_dq,               //                              .mem_dq
		inout  wire [7:0]   ddr4b_mem_conduit_end_mem_dbi_n,            //                              .mem_dbi_n
		input  wire         ddr4b_oct_conduit_end_oct_rzqin,            //         ddr4b_oct_conduit_end.oct_rzqin
		output wire         ddr4b_status_conduit_end_local_cal_success, //      ddr4b_status_conduit_end.local_cal_success
		output wire         ddr4b_status_conduit_end_local_cal_fail     //                              .local_cal_fail
	);

	wire          ddr4a_emif_usr_clk_clk;                           // ddr4a:emif_usr_clk -> [ddr4a_bridge:clk, ddr4a_clock_bridge:in_clk, mm_interconnect_0:ddr4a_emif_usr_clk_clk, rst_controller:clk]
	wire          ddr4b_emif_usr_clk_clk;                           // ddr4b:emif_usr_clk -> [ddr4b_bridge:clk, ddr4b_clock_bridge:in_clk, mm_interconnect_1:ddr4b_emif_usr_clk_clk, rst_controller_001:clk]
	wire   [31:0] ddr4a_clks_sharing_master_out_clks_sharing;       // ddr4a:clks_sharing_master_out -> ddr4b:clks_sharing_slave_in
	wire          ddr4a_bridge_m0_waitrequest;                      // mm_interconnect_0:ddr4a_bridge_m0_waitrequest -> ddr4a_bridge:m0_waitrequest
	wire  [511:0] ddr4a_bridge_m0_readdata;                         // mm_interconnect_0:ddr4a_bridge_m0_readdata -> ddr4a_bridge:m0_readdata
	wire          ddr4a_bridge_m0_debugaccess;                      // ddr4a_bridge:m0_debugaccess -> mm_interconnect_0:ddr4a_bridge_m0_debugaccess
	wire   [25:0] ddr4a_bridge_m0_address;                          // ddr4a_bridge:m0_address -> mm_interconnect_0:ddr4a_bridge_m0_address
	wire          ddr4a_bridge_m0_read;                             // ddr4a_bridge:m0_read -> mm_interconnect_0:ddr4a_bridge_m0_read
	wire   [63:0] ddr4a_bridge_m0_byteenable;                       // ddr4a_bridge:m0_byteenable -> mm_interconnect_0:ddr4a_bridge_m0_byteenable
	wire          ddr4a_bridge_m0_readdatavalid;                    // mm_interconnect_0:ddr4a_bridge_m0_readdatavalid -> ddr4a_bridge:m0_readdatavalid
	wire  [511:0] ddr4a_bridge_m0_writedata;                        // ddr4a_bridge:m0_writedata -> mm_interconnect_0:ddr4a_bridge_m0_writedata
	wire          ddr4a_bridge_m0_write;                            // ddr4a_bridge:m0_write -> mm_interconnect_0:ddr4a_bridge_m0_write
	wire    [6:0] ddr4a_bridge_m0_burstcount;                       // ddr4a_bridge:m0_burstcount -> mm_interconnect_0:ddr4a_bridge_m0_burstcount
	wire  [511:0] mm_interconnect_0_ddr4a_ctrl_amm_0_readdata;      // ddr4a:amm_readdata_0 -> mm_interconnect_0:ddr4a_ctrl_amm_0_readdata
	wire          mm_interconnect_0_ddr4a_ctrl_amm_0_waitrequest;   // ddr4a:amm_ready_0 -> mm_interconnect_0:ddr4a_ctrl_amm_0_waitrequest
	wire   [25:0] mm_interconnect_0_ddr4a_ctrl_amm_0_address;       // mm_interconnect_0:ddr4a_ctrl_amm_0_address -> ddr4a:amm_address_0
	wire          mm_interconnect_0_ddr4a_ctrl_amm_0_read;          // mm_interconnect_0:ddr4a_ctrl_amm_0_read -> ddr4a:amm_read_0
	wire   [63:0] mm_interconnect_0_ddr4a_ctrl_amm_0_byteenable;    // mm_interconnect_0:ddr4a_ctrl_amm_0_byteenable -> ddr4a:amm_byteenable_0
	wire          mm_interconnect_0_ddr4a_ctrl_amm_0_readdatavalid; // ddr4a:amm_readdatavalid_0 -> mm_interconnect_0:ddr4a_ctrl_amm_0_readdatavalid
	wire          mm_interconnect_0_ddr4a_ctrl_amm_0_write;         // mm_interconnect_0:ddr4a_ctrl_amm_0_write -> ddr4a:amm_write_0
	wire  [511:0] mm_interconnect_0_ddr4a_ctrl_amm_0_writedata;     // mm_interconnect_0:ddr4a_ctrl_amm_0_writedata -> ddr4a:amm_writedata_0
	wire    [6:0] mm_interconnect_0_ddr4a_ctrl_amm_0_burstcount;    // mm_interconnect_0:ddr4a_ctrl_amm_0_burstcount -> ddr4a:amm_burstcount_0
	wire          ddr4b_bridge_m0_waitrequest;                      // mm_interconnect_1:ddr4b_bridge_m0_waitrequest -> ddr4b_bridge:m0_waitrequest
	wire  [511:0] ddr4b_bridge_m0_readdata;                         // mm_interconnect_1:ddr4b_bridge_m0_readdata -> ddr4b_bridge:m0_readdata
	wire          ddr4b_bridge_m0_debugaccess;                      // ddr4b_bridge:m0_debugaccess -> mm_interconnect_1:ddr4b_bridge_m0_debugaccess
	wire   [25:0] ddr4b_bridge_m0_address;                          // ddr4b_bridge:m0_address -> mm_interconnect_1:ddr4b_bridge_m0_address
	wire          ddr4b_bridge_m0_read;                             // ddr4b_bridge:m0_read -> mm_interconnect_1:ddr4b_bridge_m0_read
	wire   [63:0] ddr4b_bridge_m0_byteenable;                       // ddr4b_bridge:m0_byteenable -> mm_interconnect_1:ddr4b_bridge_m0_byteenable
	wire          ddr4b_bridge_m0_readdatavalid;                    // mm_interconnect_1:ddr4b_bridge_m0_readdatavalid -> ddr4b_bridge:m0_readdatavalid
	wire  [511:0] ddr4b_bridge_m0_writedata;                        // ddr4b_bridge:m0_writedata -> mm_interconnect_1:ddr4b_bridge_m0_writedata
	wire          ddr4b_bridge_m0_write;                            // ddr4b_bridge:m0_write -> mm_interconnect_1:ddr4b_bridge_m0_write
	wire    [6:0] ddr4b_bridge_m0_burstcount;                       // ddr4b_bridge:m0_burstcount -> mm_interconnect_1:ddr4b_bridge_m0_burstcount
	wire  [511:0] mm_interconnect_1_ddr4b_ctrl_amm_0_readdata;      // ddr4b:amm_readdata_0 -> mm_interconnect_1:ddr4b_ctrl_amm_0_readdata
	wire          mm_interconnect_1_ddr4b_ctrl_amm_0_waitrequest;   // ddr4b:amm_ready_0 -> mm_interconnect_1:ddr4b_ctrl_amm_0_waitrequest
	wire   [25:0] mm_interconnect_1_ddr4b_ctrl_amm_0_address;       // mm_interconnect_1:ddr4b_ctrl_amm_0_address -> ddr4b:amm_address_0
	wire          mm_interconnect_1_ddr4b_ctrl_amm_0_read;          // mm_interconnect_1:ddr4b_ctrl_amm_0_read -> ddr4b:amm_read_0
	wire   [63:0] mm_interconnect_1_ddr4b_ctrl_amm_0_byteenable;    // mm_interconnect_1:ddr4b_ctrl_amm_0_byteenable -> ddr4b:amm_byteenable_0
	wire          mm_interconnect_1_ddr4b_ctrl_amm_0_readdatavalid; // ddr4b:amm_readdatavalid_0 -> mm_interconnect_1:ddr4b_ctrl_amm_0_readdatavalid
	wire          mm_interconnect_1_ddr4b_ctrl_amm_0_write;         // mm_interconnect_1:ddr4b_ctrl_amm_0_write -> ddr4b:amm_write_0
	wire  [511:0] mm_interconnect_1_ddr4b_ctrl_amm_0_writedata;     // mm_interconnect_1:ddr4b_ctrl_amm_0_writedata -> ddr4b:amm_writedata_0
	wire    [6:0] mm_interconnect_1_ddr4b_ctrl_amm_0_burstcount;    // mm_interconnect_1:ddr4b_ctrl_amm_0_burstcount -> ddr4b:amm_burstcount_0
	wire          rst_controller_reset_out_reset;                   // rst_controller:reset_out -> [ddr4a_bridge:reset, mm_interconnect_0:ddr4a_bridge_reset_reset_bridge_in_reset_reset]
	wire          ddr4a_emif_usr_reset_n_reset;                     // ddr4a:emif_usr_reset_n -> rst_controller:reset_in0
	wire          rst_controller_001_reset_out_reset;               // rst_controller_001:reset_out -> [ddr4b_bridge:reset, mm_interconnect_1:ddr4b_bridge_reset_reset_bridge_in_reset_reset]
	wire          ddr4b_emif_usr_reset_n_reset;                     // ddr4b:emif_usr_reset_n -> rst_controller_001:reset_in0

	emif_ddr4_ddr4a ddr4a (
		.clks_sharing_master_out (ddr4a_clks_sharing_master_out_clks_sharing),       // clks_sharing_master_out.clks_sharing
		.amm_ready_0             (mm_interconnect_0_ddr4a_ctrl_amm_0_waitrequest),   //              ctrl_amm_0.waitrequest_n
		.amm_read_0              (mm_interconnect_0_ddr4a_ctrl_amm_0_read),          //                        .read
		.amm_write_0             (mm_interconnect_0_ddr4a_ctrl_amm_0_write),         //                        .write
		.amm_address_0           (mm_interconnect_0_ddr4a_ctrl_amm_0_address),       //                        .address
		.amm_readdata_0          (mm_interconnect_0_ddr4a_ctrl_amm_0_readdata),      //                        .readdata
		.amm_writedata_0         (mm_interconnect_0_ddr4a_ctrl_amm_0_writedata),     //                        .writedata
		.amm_burstcount_0        (mm_interconnect_0_ddr4a_ctrl_amm_0_burstcount),    //                        .burstcount
		.amm_byteenable_0        (mm_interconnect_0_ddr4a_ctrl_amm_0_byteenable),    //                        .byteenable
		.amm_readdatavalid_0     (mm_interconnect_0_ddr4a_ctrl_amm_0_readdatavalid), //                        .readdatavalid
		.emif_usr_clk            (ddr4a_emif_usr_clk_clk),                           //            emif_usr_clk.clk
		.emif_usr_reset_n        (ddr4a_emif_usr_reset_n_reset),                     //        emif_usr_reset_n.reset_n
		.global_reset_n          (ddr4a_global_reset_reset_sink_reset_n),            //          global_reset_n.reset_n
		.mem_ck                  (ddr4a_mem_conduit_end_mem_ck),                     //                     mem.mem_ck
		.mem_ck_n                (ddr4a_mem_conduit_end_mem_ck_n),                   //                        .mem_ck_n
		.mem_a                   (ddr4a_mem_conduit_end_mem_a),                      //                        .mem_a
		.mem_act_n               (ddr4a_mem_conduit_end_mem_act_n),                  //                        .mem_act_n
		.mem_ba                  (ddr4a_mem_conduit_end_mem_ba),                     //                        .mem_ba
		.mem_bg                  (ddr4a_mem_conduit_end_mem_bg),                     //                        .mem_bg
		.mem_cke                 (ddr4a_mem_conduit_end_mem_cke),                    //                        .mem_cke
		.mem_cs_n                (ddr4a_mem_conduit_end_mem_cs_n),                   //                        .mem_cs_n
		.mem_odt                 (ddr4a_mem_conduit_end_mem_odt),                    //                        .mem_odt
		.mem_reset_n             (ddr4a_mem_conduit_end_mem_reset_n),                //                        .mem_reset_n
		.mem_par                 (ddr4a_mem_conduit_end_mem_par),                    //                        .mem_par
		.mem_alert_n             (ddr4a_mem_conduit_end_mem_alert_n),                //                        .mem_alert_n
		.mem_dqs                 (ddr4a_mem_conduit_end_mem_dqs),                    //                        .mem_dqs
		.mem_dqs_n               (ddr4a_mem_conduit_end_mem_dqs_n),                  //                        .mem_dqs_n
		.mem_dq                  (ddr4a_mem_conduit_end_mem_dq),                     //                        .mem_dq
		.mem_dbi_n               (ddr4a_mem_conduit_end_mem_dbi_n),                  //                        .mem_dbi_n
		.oct_rzqin               (ddr4a_oct_conduit_end_oct_rzqin),                  //                     oct.oct_rzqin
		.pll_ref_clk             (ddr4a_pll_ref_clk_clock_sink_clk),                 //             pll_ref_clk.clk
		.local_cal_success       (ddr4a_status_conduit_end_local_cal_success),       //                  status.local_cal_success
		.local_cal_fail          (ddr4a_status_conduit_end_local_cal_fail)           //                        .local_cal_fail
	);

	ddr4a_bridge ddr4a_bridge (
		.clk              (ddr4a_emif_usr_clk_clk),         //   clk.clk
		.m0_waitrequest   (ddr4a_bridge_m0_waitrequest),    //    m0.waitrequest
		.m0_readdata      (ddr4a_bridge_m0_readdata),       //      .readdata
		.m0_readdatavalid (ddr4a_bridge_m0_readdatavalid),  //      .readdatavalid
		.m0_burstcount    (ddr4a_bridge_m0_burstcount),     //      .burstcount
		.m0_writedata     (ddr4a_bridge_m0_writedata),      //      .writedata
		.m0_address       (ddr4a_bridge_m0_address),        //      .address
		.m0_write         (ddr4a_bridge_m0_write),          //      .write
		.m0_read          (ddr4a_bridge_m0_read),           //      .read
		.m0_byteenable    (ddr4a_bridge_m0_byteenable),     //      .byteenable
		.m0_debugaccess   (ddr4a_bridge_m0_debugaccess),    //      .debugaccess
		.reset            (rst_controller_reset_out_reset), // reset.reset
		.s0_waitrequest   (ddr4a_avmm_waitrequest),         //    s0.waitrequest
		.s0_readdata      (ddr4a_avmm_readdata),            //      .readdata
		.s0_readdatavalid (ddr4a_avmm_readdatavalid),       //      .readdatavalid
		.s0_burstcount    (ddr4a_avmm_burstcount),          //      .burstcount
		.s0_writedata     (ddr4a_avmm_writedata),           //      .writedata
		.s0_address       (ddr4a_avmm_address),             //      .address
		.s0_write         (ddr4a_avmm_write),               //      .write
		.s0_read          (ddr4a_avmm_read),                //      .read
		.s0_byteenable    (ddr4a_avmm_byteenable),          //      .byteenable
		.s0_debugaccess   (ddr4a_avmm_debugaccess)          //      .debugaccess
	);

	ddr4a_clock_bridge ddr4a_clock_bridge (
		.in_clk  (ddr4a_emif_usr_clk_clk), //  in_clk.clk
		.out_clk (ddr4a_avmm_clk_clk)      // out_clk.clk
	);

	emif_ddr4_ddr4b ddr4b (
		.clks_sharing_slave_in (ddr4a_clks_sharing_master_out_clks_sharing),       // clks_sharing_slave_in.clks_sharing
		.amm_ready_0           (mm_interconnect_1_ddr4b_ctrl_amm_0_waitrequest),   //            ctrl_amm_0.waitrequest_n
		.amm_read_0            (mm_interconnect_1_ddr4b_ctrl_amm_0_read),          //                      .read
		.amm_write_0           (mm_interconnect_1_ddr4b_ctrl_amm_0_write),         //                      .write
		.amm_address_0         (mm_interconnect_1_ddr4b_ctrl_amm_0_address),       //                      .address
		.amm_readdata_0        (mm_interconnect_1_ddr4b_ctrl_amm_0_readdata),      //                      .readdata
		.amm_writedata_0       (mm_interconnect_1_ddr4b_ctrl_amm_0_writedata),     //                      .writedata
		.amm_burstcount_0      (mm_interconnect_1_ddr4b_ctrl_amm_0_burstcount),    //                      .burstcount
		.amm_byteenable_0      (mm_interconnect_1_ddr4b_ctrl_amm_0_byteenable),    //                      .byteenable
		.amm_readdatavalid_0   (mm_interconnect_1_ddr4b_ctrl_amm_0_readdatavalid), //                      .readdatavalid
		.emif_usr_clk          (ddr4b_emif_usr_clk_clk),                           //          emif_usr_clk.clk
		.emif_usr_reset_n      (ddr4b_emif_usr_reset_n_reset),                     //      emif_usr_reset_n.reset_n
		.mem_ck                (ddr4b_mem_conduit_end_mem_ck),                     //                   mem.mem_ck
		.mem_ck_n              (ddr4b_mem_conduit_end_mem_ck_n),                   //                      .mem_ck_n
		.mem_a                 (ddr4b_mem_conduit_end_mem_a),                      //                      .mem_a
		.mem_act_n             (ddr4b_mem_conduit_end_mem_act_n),                  //                      .mem_act_n
		.mem_ba                (ddr4b_mem_conduit_end_mem_ba),                     //                      .mem_ba
		.mem_bg                (ddr4b_mem_conduit_end_mem_bg),                     //                      .mem_bg
		.mem_cke               (ddr4b_mem_conduit_end_mem_cke),                    //                      .mem_cke
		.mem_cs_n              (ddr4b_mem_conduit_end_mem_cs_n),                   //                      .mem_cs_n
		.mem_odt               (ddr4b_mem_conduit_end_mem_odt),                    //                      .mem_odt
		.mem_reset_n           (ddr4b_mem_conduit_end_mem_reset_n),                //                      .mem_reset_n
		.mem_par               (ddr4b_mem_conduit_end_mem_par),                    //                      .mem_par
		.mem_alert_n           (ddr4b_mem_conduit_end_mem_alert_n),                //                      .mem_alert_n
		.mem_dqs               (ddr4b_mem_conduit_end_mem_dqs),                    //                      .mem_dqs
		.mem_dqs_n             (ddr4b_mem_conduit_end_mem_dqs_n),                  //                      .mem_dqs_n
		.mem_dq                (ddr4b_mem_conduit_end_mem_dq),                     //                      .mem_dq
		.mem_dbi_n             (ddr4b_mem_conduit_end_mem_dbi_n),                  //                      .mem_dbi_n
		.oct_rzqin             (ddr4b_oct_conduit_end_oct_rzqin),                  //                   oct.oct_rzqin
		.local_cal_success     (ddr4b_status_conduit_end_local_cal_success),       //                status.local_cal_success
		.local_cal_fail        (ddr4b_status_conduit_end_local_cal_fail)           //                      .local_cal_fail
	);

	ddr4b_bridge ddr4b_bridge (
		.clk              (ddr4b_emif_usr_clk_clk),             //   clk.clk
		.m0_waitrequest   (ddr4b_bridge_m0_waitrequest),        //    m0.waitrequest
		.m0_readdata      (ddr4b_bridge_m0_readdata),           //      .readdata
		.m0_readdatavalid (ddr4b_bridge_m0_readdatavalid),      //      .readdatavalid
		.m0_burstcount    (ddr4b_bridge_m0_burstcount),         //      .burstcount
		.m0_writedata     (ddr4b_bridge_m0_writedata),          //      .writedata
		.m0_address       (ddr4b_bridge_m0_address),            //      .address
		.m0_write         (ddr4b_bridge_m0_write),              //      .write
		.m0_read          (ddr4b_bridge_m0_read),               //      .read
		.m0_byteenable    (ddr4b_bridge_m0_byteenable),         //      .byteenable
		.m0_debugaccess   (ddr4b_bridge_m0_debugaccess),        //      .debugaccess
		.reset            (rst_controller_001_reset_out_reset), // reset.reset
		.s0_waitrequest   (ddr4b_avmm_waitrequest),             //    s0.waitrequest
		.s0_readdata      (ddr4b_avmm_readdata),                //      .readdata
		.s0_readdatavalid (ddr4b_avmm_readdatavalid),           //      .readdatavalid
		.s0_burstcount    (ddr4b_avmm_burstcount),              //      .burstcount
		.s0_writedata     (ddr4b_avmm_writedata),               //      .writedata
		.s0_address       (ddr4b_avmm_address),                 //      .address
		.s0_write         (ddr4b_avmm_write),                   //      .write
		.s0_read          (ddr4b_avmm_read),                    //      .read
		.s0_byteenable    (ddr4b_avmm_byteenable),              //      .byteenable
		.s0_debugaccess   (ddr4b_avmm_debugaccess)              //      .debugaccess
	);

	ddr4b_clock_bridge ddr4b_clock_bridge (
		.in_clk  (ddr4b_emif_usr_clk_clk), //  in_clk.clk
		.out_clk (ddr4b_avmm_clk_clk)      // out_clk.clk
	);

	emif_ddr4_altera_mm_interconnect_170_xwbw35a mm_interconnect_0 (
		.ddr4a_bridge_m0_address                        (ddr4a_bridge_m0_address),                          //                          ddr4a_bridge_m0.address
		.ddr4a_bridge_m0_waitrequest                    (ddr4a_bridge_m0_waitrequest),                      //                                         .waitrequest
		.ddr4a_bridge_m0_burstcount                     (ddr4a_bridge_m0_burstcount),                       //                                         .burstcount
		.ddr4a_bridge_m0_byteenable                     (ddr4a_bridge_m0_byteenable),                       //                                         .byteenable
		.ddr4a_bridge_m0_read                           (ddr4a_bridge_m0_read),                             //                                         .read
		.ddr4a_bridge_m0_readdata                       (ddr4a_bridge_m0_readdata),                         //                                         .readdata
		.ddr4a_bridge_m0_readdatavalid                  (ddr4a_bridge_m0_readdatavalid),                    //                                         .readdatavalid
		.ddr4a_bridge_m0_write                          (ddr4a_bridge_m0_write),                            //                                         .write
		.ddr4a_bridge_m0_writedata                      (ddr4a_bridge_m0_writedata),                        //                                         .writedata
		.ddr4a_bridge_m0_debugaccess                    (ddr4a_bridge_m0_debugaccess),                      //                                         .debugaccess
		.ddr4a_bridge_reset_reset_bridge_in_reset_reset (rst_controller_reset_out_reset),                   // ddr4a_bridge_reset_reset_bridge_in_reset.reset
		.ddr4a_ctrl_amm_0_address                       (mm_interconnect_0_ddr4a_ctrl_amm_0_address),       //                         ddr4a_ctrl_amm_0.address
		.ddr4a_ctrl_amm_0_write                         (mm_interconnect_0_ddr4a_ctrl_amm_0_write),         //                                         .write
		.ddr4a_ctrl_amm_0_read                          (mm_interconnect_0_ddr4a_ctrl_amm_0_read),          //                                         .read
		.ddr4a_ctrl_amm_0_readdata                      (mm_interconnect_0_ddr4a_ctrl_amm_0_readdata),      //                                         .readdata
		.ddr4a_ctrl_amm_0_writedata                     (mm_interconnect_0_ddr4a_ctrl_amm_0_writedata),     //                                         .writedata
		.ddr4a_ctrl_amm_0_burstcount                    (mm_interconnect_0_ddr4a_ctrl_amm_0_burstcount),    //                                         .burstcount
		.ddr4a_ctrl_amm_0_byteenable                    (mm_interconnect_0_ddr4a_ctrl_amm_0_byteenable),    //                                         .byteenable
		.ddr4a_ctrl_amm_0_readdatavalid                 (mm_interconnect_0_ddr4a_ctrl_amm_0_readdatavalid), //                                         .readdatavalid
		.ddr4a_ctrl_amm_0_waitrequest                   (~mm_interconnect_0_ddr4a_ctrl_amm_0_waitrequest),  //                                         .waitrequest
		.ddr4a_emif_usr_clk_clk                         (ddr4a_emif_usr_clk_clk)                            //                       ddr4a_emif_usr_clk.clk
	);

	emif_ddr4_altera_mm_interconnect_170_253puaa mm_interconnect_1 (
		.ddr4b_bridge_m0_address                        (ddr4b_bridge_m0_address),                          //                          ddr4b_bridge_m0.address
		.ddr4b_bridge_m0_waitrequest                    (ddr4b_bridge_m0_waitrequest),                      //                                         .waitrequest
		.ddr4b_bridge_m0_burstcount                     (ddr4b_bridge_m0_burstcount),                       //                                         .burstcount
		.ddr4b_bridge_m0_byteenable                     (ddr4b_bridge_m0_byteenable),                       //                                         .byteenable
		.ddr4b_bridge_m0_read                           (ddr4b_bridge_m0_read),                             //                                         .read
		.ddr4b_bridge_m0_readdata                       (ddr4b_bridge_m0_readdata),                         //                                         .readdata
		.ddr4b_bridge_m0_readdatavalid                  (ddr4b_bridge_m0_readdatavalid),                    //                                         .readdatavalid
		.ddr4b_bridge_m0_write                          (ddr4b_bridge_m0_write),                            //                                         .write
		.ddr4b_bridge_m0_writedata                      (ddr4b_bridge_m0_writedata),                        //                                         .writedata
		.ddr4b_bridge_m0_debugaccess                    (ddr4b_bridge_m0_debugaccess),                      //                                         .debugaccess
		.ddr4b_bridge_reset_reset_bridge_in_reset_reset (rst_controller_001_reset_out_reset),               // ddr4b_bridge_reset_reset_bridge_in_reset.reset
		.ddr4b_ctrl_amm_0_address                       (mm_interconnect_1_ddr4b_ctrl_amm_0_address),       //                         ddr4b_ctrl_amm_0.address
		.ddr4b_ctrl_amm_0_write                         (mm_interconnect_1_ddr4b_ctrl_amm_0_write),         //                                         .write
		.ddr4b_ctrl_amm_0_read                          (mm_interconnect_1_ddr4b_ctrl_amm_0_read),          //                                         .read
		.ddr4b_ctrl_amm_0_readdata                      (mm_interconnect_1_ddr4b_ctrl_amm_0_readdata),      //                                         .readdata
		.ddr4b_ctrl_amm_0_writedata                     (mm_interconnect_1_ddr4b_ctrl_amm_0_writedata),     //                                         .writedata
		.ddr4b_ctrl_amm_0_burstcount                    (mm_interconnect_1_ddr4b_ctrl_amm_0_burstcount),    //                                         .burstcount
		.ddr4b_ctrl_amm_0_byteenable                    (mm_interconnect_1_ddr4b_ctrl_amm_0_byteenable),    //                                         .byteenable
		.ddr4b_ctrl_amm_0_readdatavalid                 (mm_interconnect_1_ddr4b_ctrl_amm_0_readdatavalid), //                                         .readdatavalid
		.ddr4b_ctrl_amm_0_waitrequest                   (~mm_interconnect_1_ddr4b_ctrl_amm_0_waitrequest),  //                                         .waitrequest
		.ddr4b_emif_usr_clk_clk                         (ddr4b_emif_usr_clk_clk)                            //                       ddr4b_emif_usr_clk.clk
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller (
		.reset_in0      (~ddr4a_emif_usr_reset_n_reset),  // reset_in0.reset
		.clk            (ddr4a_emif_usr_clk_clk),         //       clk.clk
		.reset_out      (rst_controller_reset_out_reset), // reset_out.reset
		.reset_req      (),                               // (terminated)
		.reset_req_in0  (1'b0),                           // (terminated)
		.reset_in1      (1'b0),                           // (terminated)
		.reset_req_in1  (1'b0),                           // (terminated)
		.reset_in2      (1'b0),                           // (terminated)
		.reset_req_in2  (1'b0),                           // (terminated)
		.reset_in3      (1'b0),                           // (terminated)
		.reset_req_in3  (1'b0),                           // (terminated)
		.reset_in4      (1'b0),                           // (terminated)
		.reset_req_in4  (1'b0),                           // (terminated)
		.reset_in5      (1'b0),                           // (terminated)
		.reset_req_in5  (1'b0),                           // (terminated)
		.reset_in6      (1'b0),                           // (terminated)
		.reset_req_in6  (1'b0),                           // (terminated)
		.reset_in7      (1'b0),                           // (terminated)
		.reset_req_in7  (1'b0),                           // (terminated)
		.reset_in8      (1'b0),                           // (terminated)
		.reset_req_in8  (1'b0),                           // (terminated)
		.reset_in9      (1'b0),                           // (terminated)
		.reset_req_in9  (1'b0),                           // (terminated)
		.reset_in10     (1'b0),                           // (terminated)
		.reset_req_in10 (1'b0),                           // (terminated)
		.reset_in11     (1'b0),                           // (terminated)
		.reset_req_in11 (1'b0),                           // (terminated)
		.reset_in12     (1'b0),                           // (terminated)
		.reset_req_in12 (1'b0),                           // (terminated)
		.reset_in13     (1'b0),                           // (terminated)
		.reset_req_in13 (1'b0),                           // (terminated)
		.reset_in14     (1'b0),                           // (terminated)
		.reset_req_in14 (1'b0),                           // (terminated)
		.reset_in15     (1'b0),                           // (terminated)
		.reset_req_in15 (1'b0)                            // (terminated)
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_001 (
		.reset_in0      (~ddr4b_emif_usr_reset_n_reset),      // reset_in0.reset
		.clk            (ddr4b_emif_usr_clk_clk),             //       clk.clk
		.reset_out      (rst_controller_001_reset_out_reset), // reset_out.reset
		.reset_req      (),                                   // (terminated)
		.reset_req_in0  (1'b0),                               // (terminated)
		.reset_in1      (1'b0),                               // (terminated)
		.reset_req_in1  (1'b0),                               // (terminated)
		.reset_in2      (1'b0),                               // (terminated)
		.reset_req_in2  (1'b0),                               // (terminated)
		.reset_in3      (1'b0),                               // (terminated)
		.reset_req_in3  (1'b0),                               // (terminated)
		.reset_in4      (1'b0),                               // (terminated)
		.reset_req_in4  (1'b0),                               // (terminated)
		.reset_in5      (1'b0),                               // (terminated)
		.reset_req_in5  (1'b0),                               // (terminated)
		.reset_in6      (1'b0),                               // (terminated)
		.reset_req_in6  (1'b0),                               // (terminated)
		.reset_in7      (1'b0),                               // (terminated)
		.reset_req_in7  (1'b0),                               // (terminated)
		.reset_in8      (1'b0),                               // (terminated)
		.reset_req_in8  (1'b0),                               // (terminated)
		.reset_in9      (1'b0),                               // (terminated)
		.reset_req_in9  (1'b0),                               // (terminated)
		.reset_in10     (1'b0),                               // (terminated)
		.reset_req_in10 (1'b0),                               // (terminated)
		.reset_in11     (1'b0),                               // (terminated)
		.reset_req_in11 (1'b0),                               // (terminated)
		.reset_in12     (1'b0),                               // (terminated)
		.reset_req_in12 (1'b0),                               // (terminated)
		.reset_in13     (1'b0),                               // (terminated)
		.reset_req_in13 (1'b0),                               // (terminated)
		.reset_in14     (1'b0),                               // (terminated)
		.reset_req_in14 (1'b0),                               // (terminated)
		.reset_in15     (1'b0),                               // (terminated)
		.reset_req_in15 (1'b0)                                // (terminated)
	);

endmodule
