// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eksauth

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opAssumeRoleForPodIdentity = "AssumeRoleForPodIdentity"

// AssumeRoleForPodIdentityRequest generates a "aws/request.Request" representing the
// client's request for the AssumeRoleForPodIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssumeRoleForPodIdentity for more information on using the AssumeRoleForPodIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssumeRoleForPodIdentityRequest method.
//	req, resp := client.AssumeRoleForPodIdentityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-auth-2023-11-26/AssumeRoleForPodIdentity
func (c *EKSAuth) AssumeRoleForPodIdentityRequest(input *AssumeRoleForPodIdentityInput) (req *request.Request, output *AssumeRoleForPodIdentityOutput) {
	op := &request.Operation{
		Name:       opAssumeRoleForPodIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{clusterName}/assume-role-for-pod-identity",
	}

	if input == nil {
		input = &AssumeRoleForPodIdentityInput{}
	}

	output = &AssumeRoleForPodIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssumeRoleForPodIdentity API operation for Amazon EKS Auth.
//
// The Amazon EKS Auth API and the AssumeRoleForPodIdentity action are only
// used by the EKS Pod Identity Agent.
//
// We recommend that applications use the Amazon Web Services SDKs to connect
// to Amazon Web Services services; if credentials from an EKS Pod Identity
// association are available in the pod, the latest versions of the SDKs use
// them automatically.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EKS Auth's
// API operation AssumeRoleForPodIdentity for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because your request rate is too high. Reduce the
//     frequency of requests.
//
//   - InvalidRequestException
//     This exception is thrown if the request contains a semantic error. The precise
//     meaning will depend on the API, and will be documented in the error message.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The IAM principal
//     making the request must have at least one IAM permissions policy attached
//     that grants the required permissions. For more information, see Access management
//     (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html) in the IAM
//     User Guide.
//
//   - InternalServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidTokenException
//     The specified Kubernetes service account token is invalid.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ExpiredTokenException
//     The specified Kubernetes service account token is expired.
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-auth-2023-11-26/AssumeRoleForPodIdentity
func (c *EKSAuth) AssumeRoleForPodIdentity(input *AssumeRoleForPodIdentityInput) (*AssumeRoleForPodIdentityOutput, error) {
	req, out := c.AssumeRoleForPodIdentityRequest(input)
	return out, req.Send()
}

// AssumeRoleForPodIdentityWithContext is the same as AssumeRoleForPodIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See AssumeRoleForPodIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKSAuth) AssumeRoleForPodIdentityWithContext(ctx aws.Context, input *AssumeRoleForPodIdentityInput, opts ...request.Option) (*AssumeRoleForPodIdentityOutput, error) {
	req, out := c.AssumeRoleForPodIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have permissions to perform the requested operation. The IAM principal
// making the request must have at least one IAM permissions policy attached
// that grants the required permissions. For more information, see Access management
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html) in the IAM
// User Guide.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssumeRoleForPodIdentityInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster for the request.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"clusterName" min:"1" type:"string" required:"true"`

	// The token of the Kubernetes service account for the pod.
	//
	// Token is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssumeRoleForPodIdentityInput's
	// String and GoString methods.
	//
	// Token is a required field
	Token *string `locationName:"token" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeRoleForPodIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeRoleForPodIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssumeRoleForPodIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssumeRoleForPodIdentityInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.Token == nil {
		invalidParams.Add(request.NewErrParamRequired("Token"))
	}
	if s.Token != nil && len(*s.Token) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Token", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *AssumeRoleForPodIdentityInput) SetClusterName(v string) *AssumeRoleForPodIdentityInput {
	s.ClusterName = &v
	return s
}

// SetToken sets the Token field's value.
func (s *AssumeRoleForPodIdentityInput) SetToken(v string) *AssumeRoleForPodIdentityInput {
	s.Token = &v
	return s
}

type AssumeRoleForPodIdentityOutput struct {
	_ struct{} `type:"structure"`

	// An object with the permanent IAM role identity and the temporary session
	// name.
	//
	// The ARN of the IAM role that the temporary credentials authenticate to.
	//
	// The session name of the temporary session requested to STS. The value is
	// a unique identifier that contains the role ID, a colon (:), and the role
	// session name of the role that is being assumed. The role ID is generated
	// by IAM when the role is created. The role session name part of the value
	// follows this format: eks-clustername-podname-random UUID
	//
	// AssumedRoleUser is a required field
	AssumedRoleUser *AssumedRoleUser `locationName:"assumedRoleUser" type:"structure" required:"true"`

	// The identity that is allowed to use the credentials. This value is always
	// pods.eks.amazonaws.com.
	//
	// Audience is a required field
	Audience *string `locationName:"audience" type:"string" required:"true"`

	// The Amazon Web Services Signature Version 4 type of temporary credentials.
	//
	// Credentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssumeRoleForPodIdentityOutput's
	// String and GoString methods.
	//
	// Credentials is a required field
	Credentials *Credentials `locationName:"credentials" type:"structure" required:"true" sensitive:"true"`

	// The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
	//
	// PodIdentityAssociation is a required field
	PodIdentityAssociation *PodIdentityAssociation `locationName:"podIdentityAssociation" type:"structure" required:"true"`

	// The name of the Kubernetes service account inside the cluster to associate
	// the IAM credentials with.
	//
	// Subject is a required field
	Subject *Subject `locationName:"subject" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeRoleForPodIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeRoleForPodIdentityOutput) GoString() string {
	return s.String()
}

// SetAssumedRoleUser sets the AssumedRoleUser field's value.
func (s *AssumeRoleForPodIdentityOutput) SetAssumedRoleUser(v *AssumedRoleUser) *AssumeRoleForPodIdentityOutput {
	s.AssumedRoleUser = v
	return s
}

// SetAudience sets the Audience field's value.
func (s *AssumeRoleForPodIdentityOutput) SetAudience(v string) *AssumeRoleForPodIdentityOutput {
	s.Audience = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *AssumeRoleForPodIdentityOutput) SetCredentials(v *Credentials) *AssumeRoleForPodIdentityOutput {
	s.Credentials = v
	return s
}

// SetPodIdentityAssociation sets the PodIdentityAssociation field's value.
func (s *AssumeRoleForPodIdentityOutput) SetPodIdentityAssociation(v *PodIdentityAssociation) *AssumeRoleForPodIdentityOutput {
	s.PodIdentityAssociation = v
	return s
}

// SetSubject sets the Subject field's value.
func (s *AssumeRoleForPodIdentityOutput) SetSubject(v *Subject) *AssumeRoleForPodIdentityOutput {
	s.Subject = v
	return s
}

// An object with the permanent IAM role identity and the temporary session
// name.
type AssumedRoleUser struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role that the temporary credentials authenticate to.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The session name of the temporary session requested to STS. The value is
	// a unique identifier that contains the role ID, a colon (:), and the role
	// session name of the role that is being assumed. The role ID is generated
	// by IAM when the role is created. The role session name part of the value
	// follows this format: eks-clustername-podname-random UUID
	//
	// AssumeRoleId is a required field
	AssumeRoleId *string `locationName:"assumeRoleId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumedRoleUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumedRoleUser) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssumedRoleUser) SetArn(v string) *AssumedRoleUser {
	s.Arn = &v
	return s
}

// SetAssumeRoleId sets the AssumeRoleId field's value.
func (s *AssumedRoleUser) SetAssumeRoleId(v string) *AssumedRoleUser {
	s.AssumeRoleId = &v
	return s
}

// The Amazon Web Services Signature Version 4 type of temporary credentials.
type Credentials struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The access key ID that identifies the temporary security credentials.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `locationName:"accessKeyId" type:"string" required:"true"`

	// The Unix epoch timestamp in seconds when the current credentials expire.
	//
	// Expiration is a required field
	Expiration *time.Time `locationName:"expiration" type:"timestamp" required:"true"`

	// The secret access key that applications inside the pods use to sign requests.
	//
	// SecretAccessKey is a required field
	SecretAccessKey *string `locationName:"secretAccessKey" type:"string" required:"true"`

	// The token that applications inside the pods must pass to any service API
	// to use the temporary credentials.
	//
	// SessionToken is a required field
	SessionToken *string `locationName:"sessionToken" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Credentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Credentials) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *Credentials) SetAccessKeyId(v string) *Credentials {
	s.AccessKeyId = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *Credentials) SetExpiration(v time.Time) *Credentials {
	s.Expiration = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *Credentials) SetSecretAccessKey(v string) *Credentials {
	s.SecretAccessKey = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *Credentials) SetSessionToken(v string) *Credentials {
	s.SessionToken = &v
	return s
}

// The specified Kubernetes service account token is expired.
type ExpiredTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredTokenException) GoString() string {
	return s.String()
}

func newErrorExpiredTokenException(v protocol.ResponseMetadata) error {
	return &ExpiredTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ExpiredTokenException) Code() string {
	return "ExpiredTokenException"
}

// Message returns the exception's message.
func (s *ExpiredTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ExpiredTokenException) OrigErr() error {
	return nil
}

func (s *ExpiredTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ExpiredTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ExpiredTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// These errors are usually caused by a server-side issue.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified parameter is invalid. Review the available parameters for the
// API request.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown if the request contains a semantic error. The precise
// meaning will depend on the API, and will be documented in the error message.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified Kubernetes service account token is invalid.
type InvalidTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidTokenException(v protocol.ResponseMetadata) error {
	return &InvalidTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTokenException) Code() string {
	return "InvalidTokenException"
}

// Message returns the exception's message.
func (s *InvalidTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTokenException) OrigErr() error {
	return nil
}

func (s *InvalidTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Amazon EKS Pod Identity associations provide the ability to manage credentials
// for your applications, similar to the way that Amazon EC2 instance profiles
// provide credentials to Amazon EC2 instances.
type PodIdentityAssociation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the EKS Pod Identity association.
	//
	// AssociationArn is a required field
	AssociationArn *string `locationName:"associationArn" type:"string" required:"true"`

	// The ID of the association.
	//
	// AssociationId is a required field
	AssociationId *string `locationName:"associationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PodIdentityAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PodIdentityAssociation) GoString() string {
	return s.String()
}

// SetAssociationArn sets the AssociationArn field's value.
func (s *PodIdentityAssociation) SetAssociationArn(v string) *PodIdentityAssociation {
	s.AssociationArn = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *PodIdentityAssociation) SetAssociationId(v string) *PodIdentityAssociation {
	s.AssociationId = &v
	return s
}

// The specified resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is unavailable. Back off and retry the operation.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object containing the name of the Kubernetes service account inside the
// cluster to associate the IAM credentials with.
type Subject struct {
	_ struct{} `type:"structure"`

	// The name of the Kubernetes namespace inside the cluster to create the association
	// in. The service account and the pods that use the service account must be
	// in this namespace.
	//
	// Namespace is a required field
	Namespace *string `locationName:"namespace" type:"string" required:"true"`

	// The name of the Kubernetes service account inside the cluster to associate
	// the IAM credentials with.
	//
	// ServiceAccount is a required field
	ServiceAccount *string `locationName:"serviceAccount" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Subject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Subject) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *Subject) SetNamespace(v string) *Subject {
	s.Namespace = &v
	return s
}

// SetServiceAccount sets the ServiceAccount field's value.
func (s *Subject) SetServiceAccount(v string) *Subject {
	s.ServiceAccount = &v
	return s
}

// The request was denied because your request rate is too high. Reduce the
// frequency of requests.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}
