// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitosync

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBulkPublish = "BulkPublish"

// BulkPublishRequest generates a "aws/request.Request" representing the
// client's request for the BulkPublish operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BulkPublish for more information on using the BulkPublish
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BulkPublishRequest method.
//	req, resp := client.BulkPublishRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/BulkPublish
func (c *CognitoSync) BulkPublishRequest(input *BulkPublishInput) (req *request.Request, output *BulkPublishOutput) {
	op := &request.Operation{
		Name:       opBulkPublish,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/bulkpublish",
	}

	if input == nil {
		input = &BulkPublishInput{}
	}

	output = &BulkPublishOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BulkPublish API operation for Amazon Cognito Sync.
//
// Initiates a bulk publish of all existing datasets for an Identity Pool to
// the configured stream. Customers are limited to one successful bulk publish
// per 24 hours. Bulk publish is an asynchronous request, customers can see
// the status of the request via the GetBulkPublishDetails operation.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation BulkPublish for usage and error information.
//
// Returned Error Types:
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - DuplicateRequestException
//     An exception thrown when there is an IN_PROGRESS bulk publish operation for
//     the given identity pool.
//
//   - AlreadyStreamedException
//     An exception thrown when a bulk publish operation is requested less than
//     24 hours after a previous bulk publish operation completed successfully.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/BulkPublish
func (c *CognitoSync) BulkPublish(input *BulkPublishInput) (*BulkPublishOutput, error) {
	req, out := c.BulkPublishRequest(input)
	return out, req.Send()
}

// BulkPublishWithContext is the same as BulkPublish with the addition of
// the ability to pass a context and additional request options.
//
// See BulkPublish for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) BulkPublishWithContext(ctx aws.Context, input *BulkPublishInput, opts ...request.Option) (*BulkPublishOutput, error) {
	req, out := c.BulkPublishRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataset = "DeleteDataset"

// DeleteDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataset for more information on using the DeleteDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDatasetRequest method.
//	req, resp := client.DeleteDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DeleteDataset
func (c *CognitoSync) DeleteDatasetRequest(input *DeleteDatasetInput) (req *request.Request, output *DeleteDatasetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}",
	}

	if input == nil {
		input = &DeleteDatasetInput{}
	}

	output = &DeleteDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataset API operation for Amazon Cognito Sync.
//
// Deletes the specific dataset. The dataset will be deleted permanently, and
// the action can't be undone. Datasets that this dataset was merged with will
// no longer report the merge. Any subsequent operation on this dataset will
// result in a ResourceNotFoundException.
//
// This API can be called with temporary user credentials provided by Cognito
// Identity or with developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation DeleteDataset for usage and error information.
//
// Returned Error Types:
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
//   - ResourceConflictException
//     Thrown if an update can't be applied because the resource was changed by
//     another call and this would result in a conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DeleteDataset
func (c *CognitoSync) DeleteDataset(input *DeleteDatasetInput) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	return out, req.Send()
}

// DeleteDatasetWithContext is the same as DeleteDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) DeleteDatasetWithContext(ctx aws.Context, input *DeleteDatasetInput, opts ...request.Option) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataset = "DescribeDataset"

// DescribeDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataset for more information on using the DescribeDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDatasetRequest method.
//	req, resp := client.DescribeDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DescribeDataset
func (c *CognitoSync) DescribeDatasetRequest(input *DescribeDatasetInput) (req *request.Request, output *DescribeDatasetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataset,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}",
	}

	if input == nil {
		input = &DescribeDatasetInput{}
	}

	output = &DescribeDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataset API operation for Amazon Cognito Sync.
//
// Gets meta data about a dataset by identity and dataset name. With Amazon
// Cognito Sync, each identity has access only to its own data. Thus, the credentials
// used to make this API call need to have access to the identity data.
//
// This API can be called with temporary user credentials provided by Cognito
// Identity or with developer credentials. You should use Cognito Identity credentials
// to make this API call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation DescribeDataset for usage and error information.
//
// Returned Error Types:
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DescribeDataset
func (c *CognitoSync) DescribeDataset(input *DescribeDatasetInput) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	return out, req.Send()
}

// DescribeDatasetWithContext is the same as DescribeDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) DescribeDatasetWithContext(ctx aws.Context, input *DescribeDatasetInput, opts ...request.Option) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIdentityPoolUsage = "DescribeIdentityPoolUsage"

// DescribeIdentityPoolUsageRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentityPoolUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIdentityPoolUsage for more information on using the DescribeIdentityPoolUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIdentityPoolUsageRequest method.
//	req, resp := client.DescribeIdentityPoolUsageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DescribeIdentityPoolUsage
func (c *CognitoSync) DescribeIdentityPoolUsageRequest(input *DescribeIdentityPoolUsageInput) (req *request.Request, output *DescribeIdentityPoolUsageOutput) {
	op := &request.Operation{
		Name:       opDescribeIdentityPoolUsage,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}",
	}

	if input == nil {
		input = &DescribeIdentityPoolUsageInput{}
	}

	output = &DescribeIdentityPoolUsageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdentityPoolUsage API operation for Amazon Cognito Sync.
//
// Gets usage details (for example, data storage) about a particular identity
// pool.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation DescribeIdentityPoolUsage for usage and error information.
//
// Returned Error Types:
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DescribeIdentityPoolUsage
func (c *CognitoSync) DescribeIdentityPoolUsage(input *DescribeIdentityPoolUsageInput) (*DescribeIdentityPoolUsageOutput, error) {
	req, out := c.DescribeIdentityPoolUsageRequest(input)
	return out, req.Send()
}

// DescribeIdentityPoolUsageWithContext is the same as DescribeIdentityPoolUsage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIdentityPoolUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) DescribeIdentityPoolUsageWithContext(ctx aws.Context, input *DescribeIdentityPoolUsageInput, opts ...request.Option) (*DescribeIdentityPoolUsageOutput, error) {
	req, out := c.DescribeIdentityPoolUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIdentityUsage = "DescribeIdentityUsage"

// DescribeIdentityUsageRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentityUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIdentityUsage for more information on using the DescribeIdentityUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIdentityUsageRequest method.
//	req, resp := client.DescribeIdentityUsageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DescribeIdentityUsage
func (c *CognitoSync) DescribeIdentityUsageRequest(input *DescribeIdentityUsageInput) (req *request.Request, output *DescribeIdentityUsageOutput) {
	op := &request.Operation{
		Name:       opDescribeIdentityUsage,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}",
	}

	if input == nil {
		input = &DescribeIdentityUsageInput{}
	}

	output = &DescribeIdentityUsageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdentityUsage API operation for Amazon Cognito Sync.
//
// Gets usage information for an identity, including number of datasets and
// data usage.
//
// This API can be called with temporary user credentials provided by Cognito
// Identity or with developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation DescribeIdentityUsage for usage and error information.
//
// Returned Error Types:
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/DescribeIdentityUsage
func (c *CognitoSync) DescribeIdentityUsage(input *DescribeIdentityUsageInput) (*DescribeIdentityUsageOutput, error) {
	req, out := c.DescribeIdentityUsageRequest(input)
	return out, req.Send()
}

// DescribeIdentityUsageWithContext is the same as DescribeIdentityUsage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIdentityUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) DescribeIdentityUsageWithContext(ctx aws.Context, input *DescribeIdentityUsageInput, opts ...request.Option) (*DescribeIdentityUsageOutput, error) {
	req, out := c.DescribeIdentityUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBulkPublishDetails = "GetBulkPublishDetails"

// GetBulkPublishDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetBulkPublishDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBulkPublishDetails for more information on using the GetBulkPublishDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBulkPublishDetailsRequest method.
//	req, resp := client.GetBulkPublishDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetBulkPublishDetails
func (c *CognitoSync) GetBulkPublishDetailsRequest(input *GetBulkPublishDetailsInput) (req *request.Request, output *GetBulkPublishDetailsOutput) {
	op := &request.Operation{
		Name:       opGetBulkPublishDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/getBulkPublishDetails",
	}

	if input == nil {
		input = &GetBulkPublishDetailsInput{}
	}

	output = &GetBulkPublishDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBulkPublishDetails API operation for Amazon Cognito Sync.
//
// Get the status of the last BulkPublish operation for an identity pool.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation GetBulkPublishDetails for usage and error information.
//
// Returned Error Types:
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetBulkPublishDetails
func (c *CognitoSync) GetBulkPublishDetails(input *GetBulkPublishDetailsInput) (*GetBulkPublishDetailsOutput, error) {
	req, out := c.GetBulkPublishDetailsRequest(input)
	return out, req.Send()
}

// GetBulkPublishDetailsWithContext is the same as GetBulkPublishDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetBulkPublishDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) GetBulkPublishDetailsWithContext(ctx aws.Context, input *GetBulkPublishDetailsInput, opts ...request.Option) (*GetBulkPublishDetailsOutput, error) {
	req, out := c.GetBulkPublishDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCognitoEvents = "GetCognitoEvents"

// GetCognitoEventsRequest generates a "aws/request.Request" representing the
// client's request for the GetCognitoEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCognitoEvents for more information on using the GetCognitoEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCognitoEventsRequest method.
//	req, resp := client.GetCognitoEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetCognitoEvents
func (c *CognitoSync) GetCognitoEventsRequest(input *GetCognitoEventsInput) (req *request.Request, output *GetCognitoEventsOutput) {
	op := &request.Operation{
		Name:       opGetCognitoEvents,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/events",
	}

	if input == nil {
		input = &GetCognitoEventsInput{}
	}

	output = &GetCognitoEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCognitoEvents API operation for Amazon Cognito Sync.
//
// Gets the events and the corresponding Lambda functions associated with an
// identity pool.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation GetCognitoEvents for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetCognitoEvents
func (c *CognitoSync) GetCognitoEvents(input *GetCognitoEventsInput) (*GetCognitoEventsOutput, error) {
	req, out := c.GetCognitoEventsRequest(input)
	return out, req.Send()
}

// GetCognitoEventsWithContext is the same as GetCognitoEvents with the addition of
// the ability to pass a context and additional request options.
//
// See GetCognitoEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) GetCognitoEventsWithContext(ctx aws.Context, input *GetCognitoEventsInput, opts ...request.Option) (*GetCognitoEventsOutput, error) {
	req, out := c.GetCognitoEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityPoolConfiguration = "GetIdentityPoolConfiguration"

// GetIdentityPoolConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityPoolConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdentityPoolConfiguration for more information on using the GetIdentityPoolConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIdentityPoolConfigurationRequest method.
//	req, resp := client.GetIdentityPoolConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetIdentityPoolConfiguration
func (c *CognitoSync) GetIdentityPoolConfigurationRequest(input *GetIdentityPoolConfigurationInput) (req *request.Request, output *GetIdentityPoolConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetIdentityPoolConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/configuration",
	}

	if input == nil {
		input = &GetIdentityPoolConfigurationInput{}
	}

	output = &GetIdentityPoolConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityPoolConfiguration API operation for Amazon Cognito Sync.
//
// Gets the configuration settings of an identity pool.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation GetIdentityPoolConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetIdentityPoolConfiguration
func (c *CognitoSync) GetIdentityPoolConfiguration(input *GetIdentityPoolConfigurationInput) (*GetIdentityPoolConfigurationOutput, error) {
	req, out := c.GetIdentityPoolConfigurationRequest(input)
	return out, req.Send()
}

// GetIdentityPoolConfigurationWithContext is the same as GetIdentityPoolConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityPoolConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) GetIdentityPoolConfigurationWithContext(ctx aws.Context, input *GetIdentityPoolConfigurationInput, opts ...request.Option) (*GetIdentityPoolConfigurationOutput, error) {
	req, out := c.GetIdentityPoolConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDatasets = "ListDatasets"

// ListDatasetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasets for more information on using the ListDatasets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDatasetsRequest method.
//	req, resp := client.ListDatasetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListDatasets
func (c *CognitoSync) ListDatasetsRequest(input *ListDatasetsInput) (req *request.Request, output *ListDatasetsOutput) {
	op := &request.Operation{
		Name:       opListDatasets,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets",
	}

	if input == nil {
		input = &ListDatasetsInput{}
	}

	output = &ListDatasetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasets API operation for Amazon Cognito Sync.
//
// Lists datasets for an identity. With Amazon Cognito Sync, each identity has
// access only to its own data. Thus, the credentials used to make this API
// call need to have access to the identity data.
//
// ListDatasets can be called with temporary user credentials provided by Cognito
// Identity or with developer credentials. You should use the Cognito Identity
// credentials to make this API call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation ListDatasets for usage and error information.
//
// Returned Error Types:
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListDatasets
func (c *CognitoSync) ListDatasets(input *ListDatasetsInput) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	return out, req.Send()
}

// ListDatasetsWithContext is the same as ListDatasets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) ListDatasetsWithContext(ctx aws.Context, input *ListDatasetsInput, opts ...request.Option) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIdentityPoolUsage = "ListIdentityPoolUsage"

// ListIdentityPoolUsageRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentityPoolUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentityPoolUsage for more information on using the ListIdentityPoolUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdentityPoolUsageRequest method.
//	req, resp := client.ListIdentityPoolUsageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListIdentityPoolUsage
func (c *CognitoSync) ListIdentityPoolUsageRequest(input *ListIdentityPoolUsageInput) (req *request.Request, output *ListIdentityPoolUsageOutput) {
	op := &request.Operation{
		Name:       opListIdentityPoolUsage,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools",
	}

	if input == nil {
		input = &ListIdentityPoolUsageInput{}
	}

	output = &ListIdentityPoolUsageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentityPoolUsage API operation for Amazon Cognito Sync.
//
// Gets a list of identity pools registered with Cognito.
//
// ListIdentityPoolUsage can only be called with developer credentials. You
// cannot make this API call with the temporary user credentials provided by
// Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation ListIdentityPoolUsage for usage and error information.
//
// Returned Error Types:
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListIdentityPoolUsage
func (c *CognitoSync) ListIdentityPoolUsage(input *ListIdentityPoolUsageInput) (*ListIdentityPoolUsageOutput, error) {
	req, out := c.ListIdentityPoolUsageRequest(input)
	return out, req.Send()
}

// ListIdentityPoolUsageWithContext is the same as ListIdentityPoolUsage with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentityPoolUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) ListIdentityPoolUsageWithContext(ctx aws.Context, input *ListIdentityPoolUsageInput, opts ...request.Option) (*ListIdentityPoolUsageOutput, error) {
	req, out := c.ListIdentityPoolUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRecords = "ListRecords"

// ListRecordsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecords for more information on using the ListRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecordsRequest method.
//	req, resp := client.ListRecordsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListRecords
func (c *CognitoSync) ListRecordsRequest(input *ListRecordsInput) (req *request.Request, output *ListRecordsOutput) {
	op := &request.Operation{
		Name:       opListRecords,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/records",
	}

	if input == nil {
		input = &ListRecordsInput{}
	}

	output = &ListRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecords API operation for Amazon Cognito Sync.
//
// Gets paginated records, optionally changed after a particular sync count
// for a dataset and identity. With Amazon Cognito Sync, each identity has access
// only to its own data. Thus, the credentials used to make this API call need
// to have access to the identity data.
//
// ListRecords can be called with temporary user credentials provided by Cognito
// Identity or with developer credentials. You should use Cognito Identity credentials
// to make this API call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation ListRecords for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListRecords
func (c *CognitoSync) ListRecords(input *ListRecordsInput) (*ListRecordsOutput, error) {
	req, out := c.ListRecordsRequest(input)
	return out, req.Send()
}

// ListRecordsWithContext is the same as ListRecords with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) ListRecordsWithContext(ctx aws.Context, input *ListRecordsInput, opts ...request.Option) (*ListRecordsOutput, error) {
	req, out := c.ListRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterDevice = "RegisterDevice"

// RegisterDeviceRequest generates a "aws/request.Request" representing the
// client's request for the RegisterDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterDevice for more information on using the RegisterDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterDeviceRequest method.
//	req, resp := client.RegisterDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/RegisterDevice
func (c *CognitoSync) RegisterDeviceRequest(input *RegisterDeviceInput) (req *request.Request, output *RegisterDeviceOutput) {
	op := &request.Operation{
		Name:       opRegisterDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identity/{IdentityId}/device",
	}

	if input == nil {
		input = &RegisterDeviceInput{}
	}

	output = &RegisterDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterDevice API operation for Amazon Cognito Sync.
//
// Registers a device to receive push sync notifications.
//
// This API can only be called with temporary credentials provided by Cognito
// Identity. You cannot call this API with developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation RegisterDevice for usage and error information.
//
// Returned Error Types:
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - InvalidConfigurationException
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/RegisterDevice
func (c *CognitoSync) RegisterDevice(input *RegisterDeviceInput) (*RegisterDeviceOutput, error) {
	req, out := c.RegisterDeviceRequest(input)
	return out, req.Send()
}

// RegisterDeviceWithContext is the same as RegisterDevice with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) RegisterDeviceWithContext(ctx aws.Context, input *RegisterDeviceInput, opts ...request.Option) (*RegisterDeviceOutput, error) {
	req, out := c.RegisterDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetCognitoEvents = "SetCognitoEvents"

// SetCognitoEventsRequest generates a "aws/request.Request" representing the
// client's request for the SetCognitoEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetCognitoEvents for more information on using the SetCognitoEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetCognitoEventsRequest method.
//	req, resp := client.SetCognitoEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/SetCognitoEvents
func (c *CognitoSync) SetCognitoEventsRequest(input *SetCognitoEventsInput) (req *request.Request, output *SetCognitoEventsOutput) {
	op := &request.Operation{
		Name:       opSetCognitoEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/events",
	}

	if input == nil {
		input = &SetCognitoEventsInput{}
	}

	output = &SetCognitoEventsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetCognitoEvents API operation for Amazon Cognito Sync.
//
// Sets the AWS Lambda function for a given event type for an identity pool.
// This request only updates the key/value pair specified. Other key/values
// pairs are not updated. To remove a key value pair, pass a empty value for
// the particular key.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation SetCognitoEvents for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/SetCognitoEvents
func (c *CognitoSync) SetCognitoEvents(input *SetCognitoEventsInput) (*SetCognitoEventsOutput, error) {
	req, out := c.SetCognitoEventsRequest(input)
	return out, req.Send()
}

// SetCognitoEventsWithContext is the same as SetCognitoEvents with the addition of
// the ability to pass a context and additional request options.
//
// See SetCognitoEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) SetCognitoEventsWithContext(ctx aws.Context, input *SetCognitoEventsInput, opts ...request.Option) (*SetCognitoEventsOutput, error) {
	req, out := c.SetCognitoEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetIdentityPoolConfiguration = "SetIdentityPoolConfiguration"

// SetIdentityPoolConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the SetIdentityPoolConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetIdentityPoolConfiguration for more information on using the SetIdentityPoolConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetIdentityPoolConfigurationRequest method.
//	req, resp := client.SetIdentityPoolConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/SetIdentityPoolConfiguration
func (c *CognitoSync) SetIdentityPoolConfigurationRequest(input *SetIdentityPoolConfigurationInput) (req *request.Request, output *SetIdentityPoolConfigurationOutput) {
	op := &request.Operation{
		Name:       opSetIdentityPoolConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/configuration",
	}

	if input == nil {
		input = &SetIdentityPoolConfigurationInput{}
	}

	output = &SetIdentityPoolConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetIdentityPoolConfiguration API operation for Amazon Cognito Sync.
//
// Sets the necessary configuration for push sync.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation SetIdentityPoolConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
//   - ConcurrentModificationException
//     Thrown if there are parallel requests to modify a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/SetIdentityPoolConfiguration
func (c *CognitoSync) SetIdentityPoolConfiguration(input *SetIdentityPoolConfigurationInput) (*SetIdentityPoolConfigurationOutput, error) {
	req, out := c.SetIdentityPoolConfigurationRequest(input)
	return out, req.Send()
}

// SetIdentityPoolConfigurationWithContext is the same as SetIdentityPoolConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See SetIdentityPoolConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) SetIdentityPoolConfigurationWithContext(ctx aws.Context, input *SetIdentityPoolConfigurationInput, opts ...request.Option) (*SetIdentityPoolConfigurationOutput, error) {
	req, out := c.SetIdentityPoolConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSubscribeToDataset = "SubscribeToDataset"

// SubscribeToDatasetRequest generates a "aws/request.Request" representing the
// client's request for the SubscribeToDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SubscribeToDataset for more information on using the SubscribeToDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SubscribeToDatasetRequest method.
//	req, resp := client.SubscribeToDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/SubscribeToDataset
func (c *CognitoSync) SubscribeToDatasetRequest(input *SubscribeToDatasetInput) (req *request.Request, output *SubscribeToDatasetOutput) {
	op := &request.Operation{
		Name:       opSubscribeToDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}",
	}

	if input == nil {
		input = &SubscribeToDatasetInput{}
	}

	output = &SubscribeToDatasetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SubscribeToDataset API operation for Amazon Cognito Sync.
//
// Subscribes to receive notifications when a dataset is modified by another
// device.
//
// This API can only be called with temporary credentials provided by Cognito
// Identity. You cannot call this API with developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation SubscribeToDataset for usage and error information.
//
// Returned Error Types:
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - InvalidConfigurationException
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/SubscribeToDataset
func (c *CognitoSync) SubscribeToDataset(input *SubscribeToDatasetInput) (*SubscribeToDatasetOutput, error) {
	req, out := c.SubscribeToDatasetRequest(input)
	return out, req.Send()
}

// SubscribeToDatasetWithContext is the same as SubscribeToDataset with the addition of
// the ability to pass a context and additional request options.
//
// See SubscribeToDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) SubscribeToDatasetWithContext(ctx aws.Context, input *SubscribeToDatasetInput, opts ...request.Option) (*SubscribeToDatasetOutput, error) {
	req, out := c.SubscribeToDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnsubscribeFromDataset = "UnsubscribeFromDataset"

// UnsubscribeFromDatasetRequest generates a "aws/request.Request" representing the
// client's request for the UnsubscribeFromDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnsubscribeFromDataset for more information on using the UnsubscribeFromDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UnsubscribeFromDatasetRequest method.
//	req, resp := client.UnsubscribeFromDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/UnsubscribeFromDataset
func (c *CognitoSync) UnsubscribeFromDatasetRequest(input *UnsubscribeFromDatasetInput) (req *request.Request, output *UnsubscribeFromDatasetOutput) {
	op := &request.Operation{
		Name:       opUnsubscribeFromDataset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}",
	}

	if input == nil {
		input = &UnsubscribeFromDatasetInput{}
	}

	output = &UnsubscribeFromDatasetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UnsubscribeFromDataset API operation for Amazon Cognito Sync.
//
// Unsubscribes from receiving notifications when a dataset is modified by another
// device.
//
// This API can only be called with temporary credentials provided by Cognito
// Identity. You cannot call this API with developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation UnsubscribeFromDataset for usage and error information.
//
// Returned Error Types:
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
//   - InvalidConfigurationException
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/UnsubscribeFromDataset
func (c *CognitoSync) UnsubscribeFromDataset(input *UnsubscribeFromDatasetInput) (*UnsubscribeFromDatasetOutput, error) {
	req, out := c.UnsubscribeFromDatasetRequest(input)
	return out, req.Send()
}

// UnsubscribeFromDatasetWithContext is the same as UnsubscribeFromDataset with the addition of
// the ability to pass a context and additional request options.
//
// See UnsubscribeFromDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) UnsubscribeFromDatasetWithContext(ctx aws.Context, input *UnsubscribeFromDatasetInput, opts ...request.Option) (*UnsubscribeFromDatasetOutput, error) {
	req, out := c.UnsubscribeFromDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRecords = "UpdateRecords"

// UpdateRecordsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRecords for more information on using the UpdateRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRecordsRequest method.
//	req, resp := client.UpdateRecordsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/UpdateRecords
func (c *CognitoSync) UpdateRecordsRequest(input *UpdateRecordsInput) (req *request.Request, output *UpdateRecordsOutput) {
	op := &request.Operation{
		Name:       opUpdateRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}",
	}

	if input == nil {
		input = &UpdateRecordsInput{}
	}

	output = &UpdateRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRecords API operation for Amazon Cognito Sync.
//
// Posts updates to records and adds and deletes records for a dataset and user.
//
// The sync count in the record patch is your last known sync count for that
// record. The server will reject an UpdateRecords request with a ResourceConflictException
// if you try to patch a record with a new value but a stale sync count.
//
// For example, if the sync count on the server is 5 for a key called highScore
// and you try and submit a new highScore with sync count of 4, the request
// will be rejected. To obtain the current sync count for a record, call ListRecords.
// On a successful update of the record, the response returns the new sync count
// for that record. You should present that sync count the next time you try
// to update that same record. When the record does not exist, specify the sync
// count as 0.
//
// This API can be called with temporary user credentials provided by Cognito
// Identity or with developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation UpdateRecords for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     Thrown when a request parameter does not comply with the associated constraints.
//
//   - LimitExceededException
//     Thrown when the limit on the number of objects or operations has been exceeded.
//
//   - NotAuthorizedException
//     Thrown when a user is not authorized to access the requested resource.
//
//   - ResourceNotFoundException
//     Thrown if the resource doesn't exist.
//
//   - ResourceConflictException
//     Thrown if an update can't be applied because the resource was changed by
//     another call and this would result in a conflict.
//
//   - InvalidLambdaFunctionOutputException
//     The AWS Lambda function returned invalid output or an exception.
//
//   - LambdaThrottledException
//     AWS Lambda throttled your account, please contact AWS Support
//
//   - TooManyRequestsException
//     Thrown if the request is throttled.
//
//   - InternalErrorException
//     Indicates an internal service error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/UpdateRecords
func (c *CognitoSync) UpdateRecords(input *UpdateRecordsInput) (*UpdateRecordsOutput, error) {
	req, out := c.UpdateRecordsRequest(input)
	return out, req.Send()
}

// UpdateRecordsWithContext is the same as UpdateRecords with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoSync) UpdateRecordsWithContext(ctx aws.Context, input *UpdateRecordsInput, opts ...request.Option) (*UpdateRecordsOutput, error) {
	req, out := c.UpdateRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An exception thrown when a bulk publish operation is requested less than
// 24 hours after a previous bulk publish operation completed successfully.
type AlreadyStreamedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message associated with the AlreadyStreamedException exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyStreamedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyStreamedException) GoString() string {
	return s.String()
}

func newErrorAlreadyStreamedException(v protocol.ResponseMetadata) error {
	return &AlreadyStreamedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AlreadyStreamedException) Code() string {
	return "AlreadyStreamedException"
}

// Message returns the exception's message.
func (s *AlreadyStreamedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AlreadyStreamedException) OrigErr() error {
	return nil
}

func (s *AlreadyStreamedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AlreadyStreamedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AlreadyStreamedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input for the BulkPublish operation.
type BulkPublishInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BulkPublishInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BulkPublishInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BulkPublishInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BulkPublishInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *BulkPublishInput) SetIdentityPoolId(v string) *BulkPublishInput {
	s.IdentityPoolId = &v
	return s
}

// The output for the BulkPublish operation.
type BulkPublishOutput struct {
	_ struct{} `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityPoolId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BulkPublishOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BulkPublishOutput) GoString() string {
	return s.String()
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *BulkPublishOutput) SetIdentityPoolId(v string) *BulkPublishOutput {
	s.IdentityPoolId = &v
	return s
}

// Configuration options for configure Cognito streams.
type CognitoStreams struct {
	_ struct{} `type:"structure"`

	// The ARN of the role Amazon Cognito can assume in order to publish to the
	// stream. This role must grant access to Amazon Cognito (cognito-sync) to invoke
	// PutRecord on your Cognito stream.
	RoleArn *string `min:"20" type:"string"`

	// The name of the Cognito stream to receive updates. This stream must be in
	// the developers account and in the same region as the identity pool.
	StreamName *string `min:"1" type:"string"`

	// Status of the Cognito streams. Valid values are:
	// ENABLED - Streaming of updates to identity pool is enabled.
	//
	// DISABLED - Streaming of updates to identity pool is disabled. Bulk publish
	// will also fail if StreamingStatus is DISABLED.
	StreamingStatus *string `type:"string" enum:"StreamingStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoStreams) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CognitoStreams) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoStreams) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CognitoStreams"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *CognitoStreams) SetRoleArn(v string) *CognitoStreams {
	s.RoleArn = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *CognitoStreams) SetStreamName(v string) *CognitoStreams {
	s.StreamName = &v
	return s
}

// SetStreamingStatus sets the StreamingStatus field's value.
func (s *CognitoStreams) SetStreamingStatus(v string) *CognitoStreams {
	s.StreamingStatus = &v
	return s
}

// Thrown if there are parallel requests to modify a resource.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned by a ConcurrentModicationException.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A collection of data for an identity pool. An identity pool can have multiple
// datasets. A dataset is per identity and can be general or associated with
// a particular entity in an application (like a saved game). Datasets are automatically
// created if they don't exist. Data is synced by dataset, and a dataset can
// hold up to 1MB of key-value pairs.
type Dataset struct {
	_ struct{} `type:"structure"`

	// Date on which the dataset was created.
	CreationDate *time.Time `type:"timestamp"`

	// Total size in bytes of the records in this dataset.
	DataStorage *int64 `type:"long"`

	// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_'
	// (underscore), '-' (dash), and '.' (dot).
	DatasetName *string `min:"1" type:"string"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityId *string `min:"1" type:"string"`

	// The device that made the last change to this dataset.
	LastModifiedBy *string `type:"string"`

	// Date when the dataset was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// Number of records in this dataset.
	NumRecords *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dataset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dataset) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *Dataset) SetCreationDate(v time.Time) *Dataset {
	s.CreationDate = &v
	return s
}

// SetDataStorage sets the DataStorage field's value.
func (s *Dataset) SetDataStorage(v int64) *Dataset {
	s.DataStorage = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *Dataset) SetDatasetName(v string) *Dataset {
	s.DatasetName = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *Dataset) SetIdentityId(v string) *Dataset {
	s.IdentityId = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *Dataset) SetLastModifiedBy(v string) *Dataset {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *Dataset) SetLastModifiedDate(v time.Time) *Dataset {
	s.LastModifiedDate = &v
	return s
}

// SetNumRecords sets the NumRecords field's value.
func (s *Dataset) SetNumRecords(v int64) *Dataset {
	s.NumRecords = &v
	return s
}

// A request to delete the specific dataset.
type DeleteDatasetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_'
	// (underscore), '-' (dash), and '.' (dot).
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"DatasetName" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *DeleteDatasetInput) SetDatasetName(v string) *DeleteDatasetInput {
	s.DatasetName = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *DeleteDatasetInput) SetIdentityId(v string) *DeleteDatasetInput {
	s.IdentityId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *DeleteDatasetInput) SetIdentityPoolId(v string) *DeleteDatasetInput {
	s.IdentityPoolId = &v
	return s
}

// Response to a successful DeleteDataset request.
type DeleteDatasetOutput struct {
	_ struct{} `type:"structure"`

	// A collection of data for an identity pool. An identity pool can have multiple
	// datasets. A dataset is per identity and can be general or associated with
	// a particular entity in an application (like a saved game). Datasets are automatically
	// created if they don't exist. Data is synced by dataset, and a dataset can
	// hold up to 1MB of key-value pairs.
	Dataset *Dataset `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetOutput) GoString() string {
	return s.String()
}

// SetDataset sets the Dataset field's value.
func (s *DeleteDatasetOutput) SetDataset(v *Dataset) *DeleteDatasetOutput {
	s.Dataset = v
	return s
}

// A request for meta data about a dataset (creation date, number of records,
// size) by owner and dataset name.
type DescribeDatasetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_'
	// (underscore), '-' (dash), and '.' (dot).
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"DatasetName" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *DescribeDatasetInput) SetDatasetName(v string) *DescribeDatasetInput {
	s.DatasetName = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *DescribeDatasetInput) SetIdentityId(v string) *DescribeDatasetInput {
	s.IdentityId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *DescribeDatasetInput) SetIdentityPoolId(v string) *DescribeDatasetInput {
	s.IdentityPoolId = &v
	return s
}

// Response to a successful DescribeDataset request.
type DescribeDatasetOutput struct {
	_ struct{} `type:"structure"`

	// Meta data for a collection of data for an identity. An identity can have
	// multiple datasets. A dataset can be general or associated with a particular
	// entity in an application (like a saved game). Datasets are automatically
	// created if they don't exist. Data is synced by dataset, and a dataset can
	// hold up to 1MB of key-value pairs.
	Dataset *Dataset `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) GoString() string {
	return s.String()
}

// SetDataset sets the Dataset field's value.
func (s *DescribeDatasetOutput) SetDataset(v *Dataset) *DescribeDatasetOutput {
	s.Dataset = v
	return s
}

// A request for usage information about the identity pool.
type DescribeIdentityPoolUsageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityPoolUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityPoolUsageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityPoolUsageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIdentityPoolUsageInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *DescribeIdentityPoolUsageInput) SetIdentityPoolId(v string) *DescribeIdentityPoolUsageInput {
	s.IdentityPoolId = &v
	return s
}

// Response to a successful DescribeIdentityPoolUsage request.
type DescribeIdentityPoolUsageOutput struct {
	_ struct{} `type:"structure"`

	// Information about the usage of the identity pool.
	IdentityPoolUsage *IdentityPoolUsage `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityPoolUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityPoolUsageOutput) GoString() string {
	return s.String()
}

// SetIdentityPoolUsage sets the IdentityPoolUsage field's value.
func (s *DescribeIdentityPoolUsageOutput) SetIdentityPoolUsage(v *IdentityPoolUsage) *DescribeIdentityPoolUsageOutput {
	s.IdentityPoolUsage = v
	return s
}

// A request for information about the usage of an identity pool.
type DescribeIdentityUsageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityUsageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityUsageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIdentityUsageInput"}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityId sets the IdentityId field's value.
func (s *DescribeIdentityUsageInput) SetIdentityId(v string) *DescribeIdentityUsageInput {
	s.IdentityId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *DescribeIdentityUsageInput) SetIdentityPoolId(v string) *DescribeIdentityUsageInput {
	s.IdentityPoolId = &v
	return s
}

// The response to a successful DescribeIdentityUsage request.
type DescribeIdentityUsageOutput struct {
	_ struct{} `type:"structure"`

	// Usage information for the identity.
	IdentityUsage *IdentityUsage `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityUsageOutput) GoString() string {
	return s.String()
}

// SetIdentityUsage sets the IdentityUsage field's value.
func (s *DescribeIdentityUsageOutput) SetIdentityUsage(v *IdentityUsage) *DescribeIdentityUsageOutput {
	s.IdentityUsage = v
	return s
}

// An exception thrown when there is an IN_PROGRESS bulk publish operation for
// the given identity pool.
type DuplicateRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message associated with the DuplicateRequestException exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateRequestException) GoString() string {
	return s.String()
}

func newErrorDuplicateRequestException(v protocol.ResponseMetadata) error {
	return &DuplicateRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicateRequestException) Code() string {
	return "DuplicateRequestException"
}

// Message returns the exception's message.
func (s *DuplicateRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicateRequestException) OrigErr() error {
	return nil
}

func (s *DuplicateRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicateRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicateRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input for the GetBulkPublishDetails operation.
type GetBulkPublishDetailsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBulkPublishDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBulkPublishDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBulkPublishDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBulkPublishDetailsInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *GetBulkPublishDetailsInput) SetIdentityPoolId(v string) *GetBulkPublishDetailsInput {
	s.IdentityPoolId = &v
	return s
}

// The output for the GetBulkPublishDetails operation.
type GetBulkPublishDetailsOutput struct {
	_ struct{} `type:"structure"`

	// If BulkPublishStatus is SUCCEEDED, the time the last bulk publish operation
	// completed.
	BulkPublishCompleteTime *time.Time `type:"timestamp"`

	// The date/time at which the last bulk publish was initiated.
	BulkPublishStartTime *time.Time `type:"timestamp"`

	// Status of the last bulk publish operation, valid values are:
	// NOT_STARTED - No bulk publish has been requested for this identity pool
	//
	// IN_PROGRESS - Data is being published to the configured stream
	//
	// SUCCEEDED - All data for the identity pool has been published to the configured
	// stream
	//
	// FAILED - Some portion of the data has failed to publish, check FailureMessage
	// for the cause.
	BulkPublishStatus *string `type:"string" enum:"BulkPublishStatus"`

	// If BulkPublishStatus is FAILED this field will contain the error message
	// that caused the bulk publish to fail.
	FailureMessage *string `type:"string"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityPoolId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBulkPublishDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBulkPublishDetailsOutput) GoString() string {
	return s.String()
}

// SetBulkPublishCompleteTime sets the BulkPublishCompleteTime field's value.
func (s *GetBulkPublishDetailsOutput) SetBulkPublishCompleteTime(v time.Time) *GetBulkPublishDetailsOutput {
	s.BulkPublishCompleteTime = &v
	return s
}

// SetBulkPublishStartTime sets the BulkPublishStartTime field's value.
func (s *GetBulkPublishDetailsOutput) SetBulkPublishStartTime(v time.Time) *GetBulkPublishDetailsOutput {
	s.BulkPublishStartTime = &v
	return s
}

// SetBulkPublishStatus sets the BulkPublishStatus field's value.
func (s *GetBulkPublishDetailsOutput) SetBulkPublishStatus(v string) *GetBulkPublishDetailsOutput {
	s.BulkPublishStatus = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *GetBulkPublishDetailsOutput) SetFailureMessage(v string) *GetBulkPublishDetailsOutput {
	s.FailureMessage = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *GetBulkPublishDetailsOutput) SetIdentityPoolId(v string) *GetBulkPublishDetailsOutput {
	s.IdentityPoolId = &v
	return s
}

// A request for a list of the configured Cognito Events
type GetCognitoEventsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Cognito Identity Pool ID for the request
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCognitoEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCognitoEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCognitoEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCognitoEventsInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *GetCognitoEventsInput) SetIdentityPoolId(v string) *GetCognitoEventsInput {
	s.IdentityPoolId = &v
	return s
}

// The response from the GetCognitoEvents request
type GetCognitoEventsOutput struct {
	_ struct{} `type:"structure"`

	// The Cognito Events returned from the GetCognitoEvents request
	Events map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCognitoEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCognitoEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *GetCognitoEventsOutput) SetEvents(v map[string]*string) *GetCognitoEventsOutput {
	s.Events = v
	return s
}

// The input for the GetIdentityPoolConfiguration operation.
type GetIdentityPoolConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. This is the ID of the pool for which to return
	// a configuration.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityPoolConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityPoolConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityPoolConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityPoolConfigurationInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *GetIdentityPoolConfigurationInput) SetIdentityPoolId(v string) *GetIdentityPoolConfigurationInput {
	s.IdentityPoolId = &v
	return s
}

// The output for the GetIdentityPoolConfiguration operation.
type GetIdentityPoolConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Options to apply to this identity pool for Amazon Cognito streams.
	CognitoStreams *CognitoStreams `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito.
	IdentityPoolId *string `min:"1" type:"string"`

	// Options to apply to this identity pool for push synchronization.
	PushSync *PushSync `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityPoolConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityPoolConfigurationOutput) GoString() string {
	return s.String()
}

// SetCognitoStreams sets the CognitoStreams field's value.
func (s *GetIdentityPoolConfigurationOutput) SetCognitoStreams(v *CognitoStreams) *GetIdentityPoolConfigurationOutput {
	s.CognitoStreams = v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *GetIdentityPoolConfigurationOutput) SetIdentityPoolId(v string) *GetIdentityPoolConfigurationOutput {
	s.IdentityPoolId = &v
	return s
}

// SetPushSync sets the PushSync field's value.
func (s *GetIdentityPoolConfigurationOutput) SetPushSync(v *PushSync) *GetIdentityPoolConfigurationOutput {
	s.PushSync = v
	return s
}

// Usage information for the identity pool.
type IdentityPoolUsage struct {
	_ struct{} `type:"structure"`

	// Data storage information for the identity pool.
	DataStorage *int64 `type:"long"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityPoolId *string `min:"1" type:"string"`

	// Date on which the identity pool was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// Number of sync sessions for the identity pool.
	SyncSessionsCount *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityPoolUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityPoolUsage) GoString() string {
	return s.String()
}

// SetDataStorage sets the DataStorage field's value.
func (s *IdentityPoolUsage) SetDataStorage(v int64) *IdentityPoolUsage {
	s.DataStorage = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *IdentityPoolUsage) SetIdentityPoolId(v string) *IdentityPoolUsage {
	s.IdentityPoolId = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *IdentityPoolUsage) SetLastModifiedDate(v time.Time) *IdentityPoolUsage {
	s.LastModifiedDate = &v
	return s
}

// SetSyncSessionsCount sets the SyncSessionsCount field's value.
func (s *IdentityPoolUsage) SetSyncSessionsCount(v int64) *IdentityPoolUsage {
	s.SyncSessionsCount = &v
	return s
}

// Usage information for the identity.
type IdentityUsage struct {
	_ struct{} `type:"structure"`

	// Total data storage for this identity.
	DataStorage *int64 `type:"long"`

	// Number of datasets for the identity.
	DatasetCount *int64 `type:"integer"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityId *string `min:"1" type:"string"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityPoolId *string `min:"1" type:"string"`

	// Date on which the identity was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityUsage) GoString() string {
	return s.String()
}

// SetDataStorage sets the DataStorage field's value.
func (s *IdentityUsage) SetDataStorage(v int64) *IdentityUsage {
	s.DataStorage = &v
	return s
}

// SetDatasetCount sets the DatasetCount field's value.
func (s *IdentityUsage) SetDatasetCount(v int64) *IdentityUsage {
	s.DatasetCount = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *IdentityUsage) SetIdentityId(v string) *IdentityUsage {
	s.IdentityId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *IdentityUsage) SetIdentityPoolId(v string) *IdentityUsage {
	s.IdentityPoolId = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *IdentityUsage) SetLastModifiedDate(v time.Time) *IdentityUsage {
	s.LastModifiedDate = &v
	return s
}

// Indicates an internal service error.
type InternalErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Message returned by InternalErrorException.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalErrorException) GoString() string {
	return s.String()
}

func newErrorInternalErrorException(v protocol.ResponseMetadata) error {
	return &InternalErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalErrorException) Code() string {
	return "InternalErrorException"
}

// Message returns the exception's message.
func (s *InternalErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalErrorException) OrigErr() error {
	return nil
}

func (s *InternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Message returned by InvalidConfigurationException.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidConfigurationException) GoString() string {
	return s.String()
}

func newErrorInvalidConfigurationException(v protocol.ResponseMetadata) error {
	return &InvalidConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidConfigurationException) Code() string {
	return "InvalidConfigurationException"
}

// Message returns the exception's message.
func (s *InvalidConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidConfigurationException) OrigErr() error {
	return nil
}

func (s *InvalidConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The AWS Lambda function returned invalid output or an exception.
type InvalidLambdaFunctionOutputException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message returned when an InvalidLambdaFunctionOutputException occurs
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidLambdaFunctionOutputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidLambdaFunctionOutputException) GoString() string {
	return s.String()
}

func newErrorInvalidLambdaFunctionOutputException(v protocol.ResponseMetadata) error {
	return &InvalidLambdaFunctionOutputException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidLambdaFunctionOutputException) Code() string {
	return "InvalidLambdaFunctionOutputException"
}

// Message returns the exception's message.
func (s *InvalidLambdaFunctionOutputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidLambdaFunctionOutputException) OrigErr() error {
	return nil
}

func (s *InvalidLambdaFunctionOutputException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidLambdaFunctionOutputException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidLambdaFunctionOutputException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Thrown when a request parameter does not comply with the associated constraints.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Message returned by InvalidParameterException.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS Lambda throttled your account, please contact AWS Support
type LambdaThrottledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message returned when an LambdaThrottledException is thrown
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaThrottledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaThrottledException) GoString() string {
	return s.String()
}

func newErrorLambdaThrottledException(v protocol.ResponseMetadata) error {
	return &LambdaThrottledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LambdaThrottledException) Code() string {
	return "LambdaThrottledException"
}

// Message returns the exception's message.
func (s *LambdaThrottledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LambdaThrottledException) OrigErr() error {
	return nil
}

func (s *LambdaThrottledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LambdaThrottledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LambdaThrottledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Thrown when the limit on the number of objects or operations has been exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Message returned by LimitExceededException.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request for a list of datasets for an identity.
type ListDatasetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetsInput"}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityId sets the IdentityId field's value.
func (s *ListDatasetsInput) SetIdentityId(v string) *ListDatasetsInput {
	s.IdentityId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *ListDatasetsInput) SetIdentityPoolId(v string) *ListDatasetsInput {
	s.IdentityPoolId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetsInput) SetMaxResults(v int64) *ListDatasetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsInput) SetNextToken(v string) *ListDatasetsInput {
	s.NextToken = &v
	return s
}

// Returned for a successful ListDatasets request.
type ListDatasetsOutput struct {
	_ struct{} `type:"structure"`

	// Number of datasets returned.
	Count *int64 `type:"integer"`

	// A set of datasets.
	Datasets []*Dataset `type:"list"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ListDatasetsOutput) SetCount(v int64) *ListDatasetsOutput {
	s.Count = &v
	return s
}

// SetDatasets sets the Datasets field's value.
func (s *ListDatasetsOutput) SetDatasets(v []*Dataset) *ListDatasetsOutput {
	s.Datasets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsOutput) SetNextToken(v string) *ListDatasetsOutput {
	s.NextToken = &v
	return s
}

// A request for usage information on an identity pool.
type ListIdentityPoolUsageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityPoolUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityPoolUsageInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdentityPoolUsageInput) SetMaxResults(v int64) *ListIdentityPoolUsageInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityPoolUsageInput) SetNextToken(v string) *ListIdentityPoolUsageInput {
	s.NextToken = &v
	return s
}

// Returned for a successful ListIdentityPoolUsage request.
type ListIdentityPoolUsageOutput struct {
	_ struct{} `type:"structure"`

	// Total number of identities for the identity pool.
	Count *int64 `type:"integer"`

	// Usage information for the identity pools.
	IdentityPoolUsages []*IdentityPoolUsage `type:"list"`

	// The maximum number of results to be returned.
	MaxResults *int64 `type:"integer"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityPoolUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityPoolUsageOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ListIdentityPoolUsageOutput) SetCount(v int64) *ListIdentityPoolUsageOutput {
	s.Count = &v
	return s
}

// SetIdentityPoolUsages sets the IdentityPoolUsages field's value.
func (s *ListIdentityPoolUsageOutput) SetIdentityPoolUsages(v []*IdentityPoolUsage) *ListIdentityPoolUsageOutput {
	s.IdentityPoolUsages = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdentityPoolUsageOutput) SetMaxResults(v int64) *ListIdentityPoolUsageOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityPoolUsageOutput) SetNextToken(v string) *ListIdentityPoolUsageOutput {
	s.NextToken = &v
	return s
}

// A request for a list of records.
type ListRecordsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_'
	// (underscore), '-' (dash), and '.' (dot).
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"DatasetName" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`

	// The last server sync count for this record.
	LastSyncCount *int64 `location:"querystring" locationName:"lastSyncCount" type:"long"`

	// The maximum number of results to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// A token containing a session ID, identity ID, and expiration.
	SyncSessionToken *string `location:"querystring" locationName:"syncSessionToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecordsInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *ListRecordsInput) SetDatasetName(v string) *ListRecordsInput {
	s.DatasetName = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *ListRecordsInput) SetIdentityId(v string) *ListRecordsInput {
	s.IdentityId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *ListRecordsInput) SetIdentityPoolId(v string) *ListRecordsInput {
	s.IdentityPoolId = &v
	return s
}

// SetLastSyncCount sets the LastSyncCount field's value.
func (s *ListRecordsInput) SetLastSyncCount(v int64) *ListRecordsInput {
	s.LastSyncCount = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecordsInput) SetMaxResults(v int64) *ListRecordsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecordsInput) SetNextToken(v string) *ListRecordsInput {
	s.NextToken = &v
	return s
}

// SetSyncSessionToken sets the SyncSessionToken field's value.
func (s *ListRecordsInput) SetSyncSessionToken(v string) *ListRecordsInput {
	s.SyncSessionToken = &v
	return s
}

// Returned for a successful ListRecordsRequest.
type ListRecordsOutput struct {
	_ struct{} `type:"structure"`

	// Total number of records.
	Count *int64 `type:"integer"`

	// A boolean value specifying whether to delete the dataset locally.
	DatasetDeletedAfterRequestedSyncCount *bool `type:"boolean"`

	// Indicates whether the dataset exists.
	DatasetExists *bool `type:"boolean"`

	// Server sync count for this dataset.
	DatasetSyncCount *int64 `type:"long"`

	// The user/device that made the last change to this record.
	LastModifiedBy *string `type:"string"`

	// Names of merged datasets.
	MergedDatasetNames []*string `type:"list"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `type:"string"`

	// A list of all records.
	Records []*Record `type:"list"`

	// A token containing a session ID, identity ID, and expiration.
	SyncSessionToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecordsOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ListRecordsOutput) SetCount(v int64) *ListRecordsOutput {
	s.Count = &v
	return s
}

// SetDatasetDeletedAfterRequestedSyncCount sets the DatasetDeletedAfterRequestedSyncCount field's value.
func (s *ListRecordsOutput) SetDatasetDeletedAfterRequestedSyncCount(v bool) *ListRecordsOutput {
	s.DatasetDeletedAfterRequestedSyncCount = &v
	return s
}

// SetDatasetExists sets the DatasetExists field's value.
func (s *ListRecordsOutput) SetDatasetExists(v bool) *ListRecordsOutput {
	s.DatasetExists = &v
	return s
}

// SetDatasetSyncCount sets the DatasetSyncCount field's value.
func (s *ListRecordsOutput) SetDatasetSyncCount(v int64) *ListRecordsOutput {
	s.DatasetSyncCount = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *ListRecordsOutput) SetLastModifiedBy(v string) *ListRecordsOutput {
	s.LastModifiedBy = &v
	return s
}

// SetMergedDatasetNames sets the MergedDatasetNames field's value.
func (s *ListRecordsOutput) SetMergedDatasetNames(v []*string) *ListRecordsOutput {
	s.MergedDatasetNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecordsOutput) SetNextToken(v string) *ListRecordsOutput {
	s.NextToken = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *ListRecordsOutput) SetRecords(v []*Record) *ListRecordsOutput {
	s.Records = v
	return s
}

// SetSyncSessionToken sets the SyncSessionToken field's value.
func (s *ListRecordsOutput) SetSyncSessionToken(v string) *ListRecordsOutput {
	s.SyncSessionToken = &v
	return s
}

// Thrown when a user is not authorized to access the requested resource.
type NotAuthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned by a NotAuthorizedException.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotAuthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotAuthorizedException) GoString() string {
	return s.String()
}

func newErrorNotAuthorizedException(v protocol.ResponseMetadata) error {
	return &NotAuthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotAuthorizedException) Code() string {
	return "NotAuthorizedException"
}

// Message returns the exception's message.
func (s *NotAuthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotAuthorizedException) OrigErr() error {
	return nil
}

func (s *NotAuthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotAuthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotAuthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Configuration options to be applied to the identity pool.
type PushSync struct {
	_ struct{} `type:"structure"`

	// List of SNS platform application ARNs that could be used by clients.
	ApplicationArns []*string `type:"list"`

	// A role configured to allow Cognito to call SNS on behalf of the developer.
	RoleArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PushSync) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PushSync) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PushSync) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PushSync"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArns sets the ApplicationArns field's value.
func (s *PushSync) SetApplicationArns(v []*string) *PushSync {
	s.ApplicationArns = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *PushSync) SetRoleArn(v string) *PushSync {
	s.RoleArn = &v
	return s
}

// The basic data structure of a dataset.
type Record struct {
	_ struct{} `type:"structure"`

	// The last modified date of the client device.
	DeviceLastModifiedDate *time.Time `type:"timestamp"`

	// The key for the record.
	Key *string `min:"1" type:"string"`

	// The user/device that made the last change to this record.
	LastModifiedBy *string `type:"string"`

	// The date on which the record was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The server sync count for this record.
	SyncCount *int64 `type:"long"`

	// The value for the record.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Record) GoString() string {
	return s.String()
}

// SetDeviceLastModifiedDate sets the DeviceLastModifiedDate field's value.
func (s *Record) SetDeviceLastModifiedDate(v time.Time) *Record {
	s.DeviceLastModifiedDate = &v
	return s
}

// SetKey sets the Key field's value.
func (s *Record) SetKey(v string) *Record {
	s.Key = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *Record) SetLastModifiedBy(v string) *Record {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *Record) SetLastModifiedDate(v time.Time) *Record {
	s.LastModifiedDate = &v
	return s
}

// SetSyncCount sets the SyncCount field's value.
func (s *Record) SetSyncCount(v int64) *Record {
	s.SyncCount = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Record) SetValue(v string) *Record {
	s.Value = &v
	return s
}

// An update operation for a record.
type RecordPatch struct {
	_ struct{} `type:"structure"`

	// The last modified date of the client device.
	DeviceLastModifiedDate *time.Time `type:"timestamp"`

	// The key associated with the record patch.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// An operation, either replace or remove.
	//
	// Op is a required field
	Op *string `type:"string" required:"true" enum:"Operation"`

	// Last known server sync count for this record. Set to 0 if unknown.
	//
	// SyncCount is a required field
	SyncCount *int64 `type:"long" required:"true"`

	// The value associated with the record patch.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordPatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordPatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordPatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecordPatch"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Op == nil {
		invalidParams.Add(request.NewErrParamRequired("Op"))
	}
	if s.SyncCount == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncCount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceLastModifiedDate sets the DeviceLastModifiedDate field's value.
func (s *RecordPatch) SetDeviceLastModifiedDate(v time.Time) *RecordPatch {
	s.DeviceLastModifiedDate = &v
	return s
}

// SetKey sets the Key field's value.
func (s *RecordPatch) SetKey(v string) *RecordPatch {
	s.Key = &v
	return s
}

// SetOp sets the Op field's value.
func (s *RecordPatch) SetOp(v string) *RecordPatch {
	s.Op = &v
	return s
}

// SetSyncCount sets the SyncCount field's value.
func (s *RecordPatch) SetSyncCount(v int64) *RecordPatch {
	s.SyncCount = &v
	return s
}

// SetValue sets the Value field's value.
func (s *RecordPatch) SetValue(v string) *RecordPatch {
	s.Value = &v
	return s
}

// A request to RegisterDevice.
type RegisterDeviceInput struct {
	_ struct{} `type:"structure"`

	// The unique ID for this identity.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. Here, the ID of the pool that the identity belongs
	// to.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`

	// The SNS platform type (e.g. GCM, SDM, APNS, APNS_SANDBOX).
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true" enum:"Platform"`

	// The push token.
	//
	// Token is a required field
	Token *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterDeviceInput"}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.Platform == nil {
		invalidParams.Add(request.NewErrParamRequired("Platform"))
	}
	if s.Token == nil {
		invalidParams.Add(request.NewErrParamRequired("Token"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityId sets the IdentityId field's value.
func (s *RegisterDeviceInput) SetIdentityId(v string) *RegisterDeviceInput {
	s.IdentityId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *RegisterDeviceInput) SetIdentityPoolId(v string) *RegisterDeviceInput {
	s.IdentityPoolId = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *RegisterDeviceInput) SetPlatform(v string) *RegisterDeviceInput {
	s.Platform = &v
	return s
}

// SetToken sets the Token field's value.
func (s *RegisterDeviceInput) SetToken(v string) *RegisterDeviceInput {
	s.Token = &v
	return s
}

// Response to a RegisterDevice request.
type RegisterDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID generated for this device by Cognito.
	DeviceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterDeviceOutput) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *RegisterDeviceOutput) SetDeviceId(v string) *RegisterDeviceOutput {
	s.DeviceId = &v
	return s
}

// Thrown if an update can't be applied because the resource was changed by
// another call and this would result in a conflict.
type ResourceConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message returned by a ResourceConflictException.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceConflictException) GoString() string {
	return s.String()
}

func newErrorResourceConflictException(v protocol.ResponseMetadata) error {
	return &ResourceConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceConflictException) Code() string {
	return "ResourceConflictException"
}

// Message returns the exception's message.
func (s *ResourceConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceConflictException) OrigErr() error {
	return nil
}

func (s *ResourceConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Thrown if the resource doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Message returned by a ResourceNotFoundException.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A request to configure Cognito Events"
// "
type SetCognitoEventsInput struct {
	_ struct{} `type:"structure"`

	// The events to configure
	//
	// Events is a required field
	Events map[string]*string `type:"map" required:"true"`

	// The Cognito Identity Pool to use when configuring Cognito Events
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetCognitoEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetCognitoEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetCognitoEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetCognitoEventsInput"}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvents sets the Events field's value.
func (s *SetCognitoEventsInput) SetEvents(v map[string]*string) *SetCognitoEventsInput {
	s.Events = v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *SetCognitoEventsInput) SetIdentityPoolId(v string) *SetCognitoEventsInput {
	s.IdentityPoolId = &v
	return s
}

type SetCognitoEventsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetCognitoEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetCognitoEventsOutput) GoString() string {
	return s.String()
}

// The input for the SetIdentityPoolConfiguration operation.
type SetIdentityPoolConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Options to apply to this identity pool for Amazon Cognito streams.
	CognitoStreams *CognitoStreams `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. This is the ID of the pool to modify.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`

	// Options to apply to this identity pool for push synchronization.
	PushSync *PushSync `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityPoolConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityPoolConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityPoolConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetIdentityPoolConfigurationInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.CognitoStreams != nil {
		if err := s.CognitoStreams.Validate(); err != nil {
			invalidParams.AddNested("CognitoStreams", err.(request.ErrInvalidParams))
		}
	}
	if s.PushSync != nil {
		if err := s.PushSync.Validate(); err != nil {
			invalidParams.AddNested("PushSync", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCognitoStreams sets the CognitoStreams field's value.
func (s *SetIdentityPoolConfigurationInput) SetCognitoStreams(v *CognitoStreams) *SetIdentityPoolConfigurationInput {
	s.CognitoStreams = v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *SetIdentityPoolConfigurationInput) SetIdentityPoolId(v string) *SetIdentityPoolConfigurationInput {
	s.IdentityPoolId = &v
	return s
}

// SetPushSync sets the PushSync field's value.
func (s *SetIdentityPoolConfigurationInput) SetPushSync(v *PushSync) *SetIdentityPoolConfigurationInput {
	s.PushSync = v
	return s
}

// The output for the SetIdentityPoolConfiguration operation
type SetIdentityPoolConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Options to apply to this identity pool for Amazon Cognito streams.
	CognitoStreams *CognitoStreams `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito.
	IdentityPoolId *string `min:"1" type:"string"`

	// Options to apply to this identity pool for push synchronization.
	PushSync *PushSync `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityPoolConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityPoolConfigurationOutput) GoString() string {
	return s.String()
}

// SetCognitoStreams sets the CognitoStreams field's value.
func (s *SetIdentityPoolConfigurationOutput) SetCognitoStreams(v *CognitoStreams) *SetIdentityPoolConfigurationOutput {
	s.CognitoStreams = v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *SetIdentityPoolConfigurationOutput) SetIdentityPoolId(v string) *SetIdentityPoolConfigurationOutput {
	s.IdentityPoolId = &v
	return s
}

// SetPushSync sets the PushSync field's value.
func (s *SetIdentityPoolConfigurationOutput) SetPushSync(v *PushSync) *SetIdentityPoolConfigurationOutput {
	s.PushSync = v
	return s
}

// A request to SubscribeToDatasetRequest.
type SubscribeToDatasetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the dataset to subcribe to.
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"DatasetName" min:"1" type:"string" required:"true"`

	// The unique ID generated for this device by Cognito.
	//
	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"DeviceId" min:"1" type:"string" required:"true"`

	// Unique ID for this identity.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. The ID of the pool to which the identity belongs.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeToDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeToDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubscribeToDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubscribeToDatasetInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *SubscribeToDatasetInput) SetDatasetName(v string) *SubscribeToDatasetInput {
	s.DatasetName = &v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *SubscribeToDatasetInput) SetDeviceId(v string) *SubscribeToDatasetInput {
	s.DeviceId = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *SubscribeToDatasetInput) SetIdentityId(v string) *SubscribeToDatasetInput {
	s.IdentityId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *SubscribeToDatasetInput) SetIdentityPoolId(v string) *SubscribeToDatasetInput {
	s.IdentityPoolId = &v
	return s
}

// Response to a SubscribeToDataset request.
type SubscribeToDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeToDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeToDatasetOutput) GoString() string {
	return s.String()
}

// Thrown if the request is throttled.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Message returned by a TooManyRequestsException.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A request to UnsubscribeFromDataset.
type UnsubscribeFromDatasetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the dataset from which to unsubcribe.
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"DatasetName" min:"1" type:"string" required:"true"`

	// The unique ID generated for this device by Cognito.
	//
	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"DeviceId" min:"1" type:"string" required:"true"`

	// Unique ID for this identity.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. The ID of the pool to which this identity belongs.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsubscribeFromDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsubscribeFromDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnsubscribeFromDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnsubscribeFromDatasetInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *UnsubscribeFromDatasetInput) SetDatasetName(v string) *UnsubscribeFromDatasetInput {
	s.DatasetName = &v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *UnsubscribeFromDatasetInput) SetDeviceId(v string) *UnsubscribeFromDatasetInput {
	s.DeviceId = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *UnsubscribeFromDatasetInput) SetIdentityId(v string) *UnsubscribeFromDatasetInput {
	s.IdentityId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *UnsubscribeFromDatasetInput) SetIdentityPoolId(v string) *UnsubscribeFromDatasetInput {
	s.IdentityPoolId = &v
	return s
}

// Response to an UnsubscribeFromDataset request.
type UnsubscribeFromDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsubscribeFromDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsubscribeFromDatasetOutput) GoString() string {
	return s.String()
}

// A request to post updates to records or add and delete records for a dataset
// and user.
type UpdateRecordsInput struct {
	_ struct{} `type:"structure"`

	// Intended to supply a device ID that will populate the lastModifiedBy field
	// referenced in other methods. The ClientContext field is not yet implemented.
	ClientContext *string `location:"header" locationName:"x-amz-Client-Context" type:"string"`

	// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_'
	// (underscore), '-' (dash), and '.' (dot).
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"DatasetName" min:"1" type:"string" required:"true"`

	// The unique ID generated for this device by Cognito.
	DeviceId *string `min:"1" type:"string"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`

	// A list of patch operations.
	RecordPatches []*RecordPatch `type:"list"`

	// The SyncSessionToken returned by a previous call to ListRecords for this
	// dataset and identity.
	//
	// SyncSessionToken is a required field
	SyncSessionToken *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRecordsInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.SyncSessionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncSessionToken"))
	}
	if s.RecordPatches != nil {
		for i, v := range s.RecordPatches {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RecordPatches", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientContext sets the ClientContext field's value.
func (s *UpdateRecordsInput) SetClientContext(v string) *UpdateRecordsInput {
	s.ClientContext = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *UpdateRecordsInput) SetDatasetName(v string) *UpdateRecordsInput {
	s.DatasetName = &v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *UpdateRecordsInput) SetDeviceId(v string) *UpdateRecordsInput {
	s.DeviceId = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *UpdateRecordsInput) SetIdentityId(v string) *UpdateRecordsInput {
	s.IdentityId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *UpdateRecordsInput) SetIdentityPoolId(v string) *UpdateRecordsInput {
	s.IdentityPoolId = &v
	return s
}

// SetRecordPatches sets the RecordPatches field's value.
func (s *UpdateRecordsInput) SetRecordPatches(v []*RecordPatch) *UpdateRecordsInput {
	s.RecordPatches = v
	return s
}

// SetSyncSessionToken sets the SyncSessionToken field's value.
func (s *UpdateRecordsInput) SetSyncSessionToken(v string) *UpdateRecordsInput {
	s.SyncSessionToken = &v
	return s
}

// Returned for a successful UpdateRecordsRequest.
type UpdateRecordsOutput struct {
	_ struct{} `type:"structure"`

	// A list of records that have been updated.
	Records []*Record `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecordsOutput) GoString() string {
	return s.String()
}

// SetRecords sets the Records field's value.
func (s *UpdateRecordsOutput) SetRecords(v []*Record) *UpdateRecordsOutput {
	s.Records = v
	return s
}

const (
	// BulkPublishStatusNotStarted is a BulkPublishStatus enum value
	BulkPublishStatusNotStarted = "NOT_STARTED"

	// BulkPublishStatusInProgress is a BulkPublishStatus enum value
	BulkPublishStatusInProgress = "IN_PROGRESS"

	// BulkPublishStatusFailed is a BulkPublishStatus enum value
	BulkPublishStatusFailed = "FAILED"

	// BulkPublishStatusSucceeded is a BulkPublishStatus enum value
	BulkPublishStatusSucceeded = "SUCCEEDED"
)

// BulkPublishStatus_Values returns all elements of the BulkPublishStatus enum
func BulkPublishStatus_Values() []string {
	return []string{
		BulkPublishStatusNotStarted,
		BulkPublishStatusInProgress,
		BulkPublishStatusFailed,
		BulkPublishStatusSucceeded,
	}
}

const (
	// OperationReplace is a Operation enum value
	OperationReplace = "replace"

	// OperationRemove is a Operation enum value
	OperationRemove = "remove"
)

// Operation_Values returns all elements of the Operation enum
func Operation_Values() []string {
	return []string{
		OperationReplace,
		OperationRemove,
	}
}

const (
	// PlatformApns is a Platform enum value
	PlatformApns = "APNS"

	// PlatformApnsSandbox is a Platform enum value
	PlatformApnsSandbox = "APNS_SANDBOX"

	// PlatformGcm is a Platform enum value
	PlatformGcm = "GCM"

	// PlatformAdm is a Platform enum value
	PlatformAdm = "ADM"
)

// Platform_Values returns all elements of the Platform enum
func Platform_Values() []string {
	return []string{
		PlatformApns,
		PlatformApnsSandbox,
		PlatformGcm,
		PlatformAdm,
	}
}

const (
	// StreamingStatusEnabled is a StreamingStatus enum value
	StreamingStatusEnabled = "ENABLED"

	// StreamingStatusDisabled is a StreamingStatus enum value
	StreamingStatusDisabled = "DISABLED"
)

// StreamingStatus_Values returns all elements of the StreamingStatus enum
func StreamingStatus_Values() []string {
	return []string{
		StreamingStatusEnabled,
		StreamingStatusDisabled,
	}
}
