// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package bedrock

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateEvaluationJob = "CreateEvaluationJob"

// CreateEvaluationJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateEvaluationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEvaluationJob for more information on using the CreateEvaluationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEvaluationJobRequest method.
//	req, resp := client.CreateEvaluationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateEvaluationJob
func (c *Bedrock) CreateEvaluationJobRequest(input *CreateEvaluationJobInput) (req *request.Request, output *CreateEvaluationJobOutput) {
	op := &request.Operation{
		Name:       opCreateEvaluationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/evaluation-jobs",
	}

	if input == nil {
		input = &CreateEvaluationJobInput{}
	}

	output = &CreateEvaluationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEvaluationJob API operation for Amazon Bedrock.
//
// API operation for creating and managing Amazon Bedrock automatic model evaluation
// jobs and model evaluation jobs that use human workers. To learn more about
// the requirements for creating a model evaluation job see, Model evaluations
// (https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation CreateEvaluationJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateEvaluationJob
func (c *Bedrock) CreateEvaluationJob(input *CreateEvaluationJobInput) (*CreateEvaluationJobOutput, error) {
	req, out := c.CreateEvaluationJobRequest(input)
	return out, req.Send()
}

// CreateEvaluationJobWithContext is the same as CreateEvaluationJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEvaluationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) CreateEvaluationJobWithContext(ctx aws.Context, input *CreateEvaluationJobInput, opts ...request.Option) (*CreateEvaluationJobOutput, error) {
	req, out := c.CreateEvaluationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGuardrail = "CreateGuardrail"

// CreateGuardrailRequest generates a "aws/request.Request" representing the
// client's request for the CreateGuardrail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGuardrail for more information on using the CreateGuardrail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGuardrailRequest method.
//	req, resp := client.CreateGuardrailRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateGuardrail
func (c *Bedrock) CreateGuardrailRequest(input *CreateGuardrailInput) (req *request.Request, output *CreateGuardrailOutput) {
	op := &request.Operation{
		Name:       opCreateGuardrail,
		HTTPMethod: "POST",
		HTTPPath:   "/guardrails",
	}

	if input == nil {
		input = &CreateGuardrailInput{}
	}

	output = &CreateGuardrailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGuardrail API operation for Amazon Bedrock.
//
// Creates a guardrail to block topics and to implement safeguards for your
// generative AI applications.
//
// You can configure the following policies in a guardrail to avoid undesirable
// and harmful content, filter out denied topics and words, and remove sensitive
// information for privacy protection.
//
//   - Content filters - Adjust filter strengths to block input prompts or
//     model responses containing harmful content.
//
//   - Denied topics - Define a set of topics that are undesirable in the context
//     of your application. These topics will be blocked if detected in user
//     queries or model responses.
//
//   - Word filters - Configure filters to block undesirable words, phrases,
//     and profanity. Such words can include offensive terms, competitor names
//     etc.
//
//   - Sensitive information filters - Block or mask sensitive information
//     such as personally identifiable information (PII) or custom regex in user
//     inputs and model responses.
//
// In addition to the above policies, you can also configure the messages to
// be returned to the user if a user input or model response is in violation
// of the policies defined in the guardrail.
//
// For more information, see Guardrails for Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation CreateGuardrail for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateGuardrail
func (c *Bedrock) CreateGuardrail(input *CreateGuardrailInput) (*CreateGuardrailOutput, error) {
	req, out := c.CreateGuardrailRequest(input)
	return out, req.Send()
}

// CreateGuardrailWithContext is the same as CreateGuardrail with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGuardrail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) CreateGuardrailWithContext(ctx aws.Context, input *CreateGuardrailInput, opts ...request.Option) (*CreateGuardrailOutput, error) {
	req, out := c.CreateGuardrailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGuardrailVersion = "CreateGuardrailVersion"

// CreateGuardrailVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateGuardrailVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGuardrailVersion for more information on using the CreateGuardrailVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGuardrailVersionRequest method.
//	req, resp := client.CreateGuardrailVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateGuardrailVersion
func (c *Bedrock) CreateGuardrailVersionRequest(input *CreateGuardrailVersionInput) (req *request.Request, output *CreateGuardrailVersionOutput) {
	op := &request.Operation{
		Name:       opCreateGuardrailVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/guardrails/{guardrailIdentifier}",
	}

	if input == nil {
		input = &CreateGuardrailVersionInput{}
	}

	output = &CreateGuardrailVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGuardrailVersion API operation for Amazon Bedrock.
//
// Creates a version of the guardrail. Use this API to create a snapshot of
// the guardrail when you are satisfied with a configuration, or to compare
// the configuration with another version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation CreateGuardrailVersion for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateGuardrailVersion
func (c *Bedrock) CreateGuardrailVersion(input *CreateGuardrailVersionInput) (*CreateGuardrailVersionOutput, error) {
	req, out := c.CreateGuardrailVersionRequest(input)
	return out, req.Send()
}

// CreateGuardrailVersionWithContext is the same as CreateGuardrailVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGuardrailVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) CreateGuardrailVersionWithContext(ctx aws.Context, input *CreateGuardrailVersionInput, opts ...request.Option) (*CreateGuardrailVersionOutput, error) {
	req, out := c.CreateGuardrailVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModelCustomizationJob = "CreateModelCustomizationJob"

// CreateModelCustomizationJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateModelCustomizationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModelCustomizationJob for more information on using the CreateModelCustomizationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateModelCustomizationJobRequest method.
//	req, resp := client.CreateModelCustomizationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateModelCustomizationJob
func (c *Bedrock) CreateModelCustomizationJobRequest(input *CreateModelCustomizationJobInput) (req *request.Request, output *CreateModelCustomizationJobOutput) {
	op := &request.Operation{
		Name:       opCreateModelCustomizationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/model-customization-jobs",
	}

	if input == nil {
		input = &CreateModelCustomizationJobInput{}
	}

	output = &CreateModelCustomizationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModelCustomizationJob API operation for Amazon Bedrock.
//
// Creates a fine-tuning job to customize a base model.
//
// You specify the base foundation model and the location of the training data.
// After the model-customization job completes successfully, your custom model
// resource will be ready to use. Amazon Bedrock returns validation loss metrics
// and output generations after the job completes.
//
// For information on the format of training and validation data, see Prepare
// the datasets (https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-prepare.html).
//
// Model-customization jobs are asynchronous and the completion time depends
// on the base model and the training/validation data size. To monitor a job,
// use the GetModelCustomizationJob operation to retrieve the job status.
//
// For more information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation CreateModelCustomizationJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateModelCustomizationJob
func (c *Bedrock) CreateModelCustomizationJob(input *CreateModelCustomizationJobInput) (*CreateModelCustomizationJobOutput, error) {
	req, out := c.CreateModelCustomizationJobRequest(input)
	return out, req.Send()
}

// CreateModelCustomizationJobWithContext is the same as CreateModelCustomizationJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelCustomizationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) CreateModelCustomizationJobWithContext(ctx aws.Context, input *CreateModelCustomizationJobInput, opts ...request.Option) (*CreateModelCustomizationJobOutput, error) {
	req, out := c.CreateModelCustomizationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProvisionedModelThroughput = "CreateProvisionedModelThroughput"

// CreateProvisionedModelThroughputRequest generates a "aws/request.Request" representing the
// client's request for the CreateProvisionedModelThroughput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProvisionedModelThroughput for more information on using the CreateProvisionedModelThroughput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProvisionedModelThroughputRequest method.
//	req, resp := client.CreateProvisionedModelThroughputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateProvisionedModelThroughput
func (c *Bedrock) CreateProvisionedModelThroughputRequest(input *CreateProvisionedModelThroughputInput) (req *request.Request, output *CreateProvisionedModelThroughputOutput) {
	op := &request.Operation{
		Name:       opCreateProvisionedModelThroughput,
		HTTPMethod: "POST",
		HTTPPath:   "/provisioned-model-throughput",
	}

	if input == nil {
		input = &CreateProvisionedModelThroughputInput{}
	}

	output = &CreateProvisionedModelThroughputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProvisionedModelThroughput API operation for Amazon Bedrock.
//
// Creates dedicated throughput for a base or custom model with the model units
// and for the duration that you specify. For pricing details, see Amazon Bedrock
// Pricing (http://aws.amazon.com/bedrock/pricing/). For more information, see
// Provisioned Throughput (https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation CreateProvisionedModelThroughput for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateProvisionedModelThroughput
func (c *Bedrock) CreateProvisionedModelThroughput(input *CreateProvisionedModelThroughputInput) (*CreateProvisionedModelThroughputOutput, error) {
	req, out := c.CreateProvisionedModelThroughputRequest(input)
	return out, req.Send()
}

// CreateProvisionedModelThroughputWithContext is the same as CreateProvisionedModelThroughput with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProvisionedModelThroughput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) CreateProvisionedModelThroughputWithContext(ctx aws.Context, input *CreateProvisionedModelThroughputInput, opts ...request.Option) (*CreateProvisionedModelThroughputOutput, error) {
	req, out := c.CreateProvisionedModelThroughputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomModel = "DeleteCustomModel"

// DeleteCustomModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomModel for more information on using the DeleteCustomModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomModelRequest method.
//	req, resp := client.DeleteCustomModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteCustomModel
func (c *Bedrock) DeleteCustomModelRequest(input *DeleteCustomModelInput) (req *request.Request, output *DeleteCustomModelOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomModel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/custom-models/{modelIdentifier}",
	}

	if input == nil {
		input = &DeleteCustomModelInput{}
	}

	output = &DeleteCustomModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomModel API operation for Amazon Bedrock.
//
// Deletes a custom model that you created earlier. For more information, see
// Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation DeleteCustomModel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteCustomModel
func (c *Bedrock) DeleteCustomModel(input *DeleteCustomModelInput) (*DeleteCustomModelOutput, error) {
	req, out := c.DeleteCustomModelRequest(input)
	return out, req.Send()
}

// DeleteCustomModelWithContext is the same as DeleteCustomModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) DeleteCustomModelWithContext(ctx aws.Context, input *DeleteCustomModelInput, opts ...request.Option) (*DeleteCustomModelOutput, error) {
	req, out := c.DeleteCustomModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGuardrail = "DeleteGuardrail"

// DeleteGuardrailRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGuardrail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGuardrail for more information on using the DeleteGuardrail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGuardrailRequest method.
//	req, resp := client.DeleteGuardrailRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteGuardrail
func (c *Bedrock) DeleteGuardrailRequest(input *DeleteGuardrailInput) (req *request.Request, output *DeleteGuardrailOutput) {
	op := &request.Operation{
		Name:       opDeleteGuardrail,
		HTTPMethod: "DELETE",
		HTTPPath:   "/guardrails/{guardrailIdentifier}",
	}

	if input == nil {
		input = &DeleteGuardrailInput{}
	}

	output = &DeleteGuardrailOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGuardrail API operation for Amazon Bedrock.
//
// Deletes a guardrail.
//
//   - To delete a guardrail, only specify the ARN of the guardrail in the
//     guardrailIdentifier field. If you delete a guardrail, all of its versions
//     will be deleted.
//
//   - To delete a version of a guardrail, specify the ARN of the guardrail
//     in the guardrailIdentifier field and the version in the guardrailVersion
//     field.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation DeleteGuardrail for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteGuardrail
func (c *Bedrock) DeleteGuardrail(input *DeleteGuardrailInput) (*DeleteGuardrailOutput, error) {
	req, out := c.DeleteGuardrailRequest(input)
	return out, req.Send()
}

// DeleteGuardrailWithContext is the same as DeleteGuardrail with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGuardrail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) DeleteGuardrailWithContext(ctx aws.Context, input *DeleteGuardrailInput, opts ...request.Option) (*DeleteGuardrailOutput, error) {
	req, out := c.DeleteGuardrailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModelInvocationLoggingConfiguration = "DeleteModelInvocationLoggingConfiguration"

// DeleteModelInvocationLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModelInvocationLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModelInvocationLoggingConfiguration for more information on using the DeleteModelInvocationLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteModelInvocationLoggingConfigurationRequest method.
//	req, resp := client.DeleteModelInvocationLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteModelInvocationLoggingConfiguration
func (c *Bedrock) DeleteModelInvocationLoggingConfigurationRequest(input *DeleteModelInvocationLoggingConfigurationInput) (req *request.Request, output *DeleteModelInvocationLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteModelInvocationLoggingConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/logging/modelinvocations",
	}

	if input == nil {
		input = &DeleteModelInvocationLoggingConfigurationInput{}
	}

	output = &DeleteModelInvocationLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModelInvocationLoggingConfiguration API operation for Amazon Bedrock.
//
// Delete the invocation logging.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation DeleteModelInvocationLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteModelInvocationLoggingConfiguration
func (c *Bedrock) DeleteModelInvocationLoggingConfiguration(input *DeleteModelInvocationLoggingConfigurationInput) (*DeleteModelInvocationLoggingConfigurationOutput, error) {
	req, out := c.DeleteModelInvocationLoggingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteModelInvocationLoggingConfigurationWithContext is the same as DeleteModelInvocationLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModelInvocationLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) DeleteModelInvocationLoggingConfigurationWithContext(ctx aws.Context, input *DeleteModelInvocationLoggingConfigurationInput, opts ...request.Option) (*DeleteModelInvocationLoggingConfigurationOutput, error) {
	req, out := c.DeleteModelInvocationLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProvisionedModelThroughput = "DeleteProvisionedModelThroughput"

// DeleteProvisionedModelThroughputRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProvisionedModelThroughput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProvisionedModelThroughput for more information on using the DeleteProvisionedModelThroughput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProvisionedModelThroughputRequest method.
//	req, resp := client.DeleteProvisionedModelThroughputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteProvisionedModelThroughput
func (c *Bedrock) DeleteProvisionedModelThroughputRequest(input *DeleteProvisionedModelThroughputInput) (req *request.Request, output *DeleteProvisionedModelThroughputOutput) {
	op := &request.Operation{
		Name:       opDeleteProvisionedModelThroughput,
		HTTPMethod: "DELETE",
		HTTPPath:   "/provisioned-model-throughput/{provisionedModelId}",
	}

	if input == nil {
		input = &DeleteProvisionedModelThroughputInput{}
	}

	output = &DeleteProvisionedModelThroughputOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProvisionedModelThroughput API operation for Amazon Bedrock.
//
// Deletes a Provisioned Throughput. You can't delete a Provisioned Throughput
// before the commitment term is over. For more information, see Provisioned
// Throughput (https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation DeleteProvisionedModelThroughput for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteProvisionedModelThroughput
func (c *Bedrock) DeleteProvisionedModelThroughput(input *DeleteProvisionedModelThroughputInput) (*DeleteProvisionedModelThroughputOutput, error) {
	req, out := c.DeleteProvisionedModelThroughputRequest(input)
	return out, req.Send()
}

// DeleteProvisionedModelThroughputWithContext is the same as DeleteProvisionedModelThroughput with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProvisionedModelThroughput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) DeleteProvisionedModelThroughputWithContext(ctx aws.Context, input *DeleteProvisionedModelThroughputInput, opts ...request.Option) (*DeleteProvisionedModelThroughputOutput, error) {
	req, out := c.DeleteProvisionedModelThroughputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCustomModel = "GetCustomModel"

// GetCustomModelRequest generates a "aws/request.Request" representing the
// client's request for the GetCustomModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCustomModel for more information on using the GetCustomModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCustomModelRequest method.
//	req, resp := client.GetCustomModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetCustomModel
func (c *Bedrock) GetCustomModelRequest(input *GetCustomModelInput) (req *request.Request, output *GetCustomModelOutput) {
	op := &request.Operation{
		Name:       opGetCustomModel,
		HTTPMethod: "GET",
		HTTPPath:   "/custom-models/{modelIdentifier}",
	}

	if input == nil {
		input = &GetCustomModelInput{}
	}

	output = &GetCustomModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCustomModel API operation for Amazon Bedrock.
//
// Get the properties associated with a Amazon Bedrock custom model that you
// have created.For more information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation GetCustomModel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetCustomModel
func (c *Bedrock) GetCustomModel(input *GetCustomModelInput) (*GetCustomModelOutput, error) {
	req, out := c.GetCustomModelRequest(input)
	return out, req.Send()
}

// GetCustomModelWithContext is the same as GetCustomModel with the addition of
// the ability to pass a context and additional request options.
//
// See GetCustomModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) GetCustomModelWithContext(ctx aws.Context, input *GetCustomModelInput, opts ...request.Option) (*GetCustomModelOutput, error) {
	req, out := c.GetCustomModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEvaluationJob = "GetEvaluationJob"

// GetEvaluationJobRequest generates a "aws/request.Request" representing the
// client's request for the GetEvaluationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEvaluationJob for more information on using the GetEvaluationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEvaluationJobRequest method.
//	req, resp := client.GetEvaluationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetEvaluationJob
func (c *Bedrock) GetEvaluationJobRequest(input *GetEvaluationJobInput) (req *request.Request, output *GetEvaluationJobOutput) {
	op := &request.Operation{
		Name:       opGetEvaluationJob,
		HTTPMethod: "GET",
		HTTPPath:   "/evaluation-jobs/{jobIdentifier}",
	}

	if input == nil {
		input = &GetEvaluationJobInput{}
	}

	output = &GetEvaluationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEvaluationJob API operation for Amazon Bedrock.
//
// Retrieves the properties associated with a model evaluation job, including
// the status of the job. For more information, see Model evaluations (https://docs.aws.amazon.com/bedrock/latest/userguide/latest/userguide/model-evaluation.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation GetEvaluationJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetEvaluationJob
func (c *Bedrock) GetEvaluationJob(input *GetEvaluationJobInput) (*GetEvaluationJobOutput, error) {
	req, out := c.GetEvaluationJobRequest(input)
	return out, req.Send()
}

// GetEvaluationJobWithContext is the same as GetEvaluationJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetEvaluationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) GetEvaluationJobWithContext(ctx aws.Context, input *GetEvaluationJobInput, opts ...request.Option) (*GetEvaluationJobOutput, error) {
	req, out := c.GetEvaluationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFoundationModel = "GetFoundationModel"

// GetFoundationModelRequest generates a "aws/request.Request" representing the
// client's request for the GetFoundationModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFoundationModel for more information on using the GetFoundationModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFoundationModelRequest method.
//	req, resp := client.GetFoundationModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetFoundationModel
func (c *Bedrock) GetFoundationModelRequest(input *GetFoundationModelInput) (req *request.Request, output *GetFoundationModelOutput) {
	op := &request.Operation{
		Name:       opGetFoundationModel,
		HTTPMethod: "GET",
		HTTPPath:   "/foundation-models/{modelIdentifier}",
	}

	if input == nil {
		input = &GetFoundationModelInput{}
	}

	output = &GetFoundationModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFoundationModel API operation for Amazon Bedrock.
//
// Get details about a Amazon Bedrock foundation model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation GetFoundationModel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetFoundationModel
func (c *Bedrock) GetFoundationModel(input *GetFoundationModelInput) (*GetFoundationModelOutput, error) {
	req, out := c.GetFoundationModelRequest(input)
	return out, req.Send()
}

// GetFoundationModelWithContext is the same as GetFoundationModel with the addition of
// the ability to pass a context and additional request options.
//
// See GetFoundationModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) GetFoundationModelWithContext(ctx aws.Context, input *GetFoundationModelInput, opts ...request.Option) (*GetFoundationModelOutput, error) {
	req, out := c.GetFoundationModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGuardrail = "GetGuardrail"

// GetGuardrailRequest generates a "aws/request.Request" representing the
// client's request for the GetGuardrail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGuardrail for more information on using the GetGuardrail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGuardrailRequest method.
//	req, resp := client.GetGuardrailRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetGuardrail
func (c *Bedrock) GetGuardrailRequest(input *GetGuardrailInput) (req *request.Request, output *GetGuardrailOutput) {
	op := &request.Operation{
		Name:       opGetGuardrail,
		HTTPMethod: "GET",
		HTTPPath:   "/guardrails/{guardrailIdentifier}",
	}

	if input == nil {
		input = &GetGuardrailInput{}
	}

	output = &GetGuardrailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGuardrail API operation for Amazon Bedrock.
//
// Gets details about a guardrail. If you don't specify a version, the response
// returns details for the DRAFT version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation GetGuardrail for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetGuardrail
func (c *Bedrock) GetGuardrail(input *GetGuardrailInput) (*GetGuardrailOutput, error) {
	req, out := c.GetGuardrailRequest(input)
	return out, req.Send()
}

// GetGuardrailWithContext is the same as GetGuardrail with the addition of
// the ability to pass a context and additional request options.
//
// See GetGuardrail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) GetGuardrailWithContext(ctx aws.Context, input *GetGuardrailInput, opts ...request.Option) (*GetGuardrailOutput, error) {
	req, out := c.GetGuardrailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModelCustomizationJob = "GetModelCustomizationJob"

// GetModelCustomizationJobRequest generates a "aws/request.Request" representing the
// client's request for the GetModelCustomizationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModelCustomizationJob for more information on using the GetModelCustomizationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetModelCustomizationJobRequest method.
//	req, resp := client.GetModelCustomizationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelCustomizationJob
func (c *Bedrock) GetModelCustomizationJobRequest(input *GetModelCustomizationJobInput) (req *request.Request, output *GetModelCustomizationJobOutput) {
	op := &request.Operation{
		Name:       opGetModelCustomizationJob,
		HTTPMethod: "GET",
		HTTPPath:   "/model-customization-jobs/{jobIdentifier}",
	}

	if input == nil {
		input = &GetModelCustomizationJobInput{}
	}

	output = &GetModelCustomizationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModelCustomizationJob API operation for Amazon Bedrock.
//
// Retrieves the properties associated with a model-customization job, including
// the status of the job. For more information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation GetModelCustomizationJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelCustomizationJob
func (c *Bedrock) GetModelCustomizationJob(input *GetModelCustomizationJobInput) (*GetModelCustomizationJobOutput, error) {
	req, out := c.GetModelCustomizationJobRequest(input)
	return out, req.Send()
}

// GetModelCustomizationJobWithContext is the same as GetModelCustomizationJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetModelCustomizationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) GetModelCustomizationJobWithContext(ctx aws.Context, input *GetModelCustomizationJobInput, opts ...request.Option) (*GetModelCustomizationJobOutput, error) {
	req, out := c.GetModelCustomizationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModelInvocationLoggingConfiguration = "GetModelInvocationLoggingConfiguration"

// GetModelInvocationLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetModelInvocationLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModelInvocationLoggingConfiguration for more information on using the GetModelInvocationLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetModelInvocationLoggingConfigurationRequest method.
//	req, resp := client.GetModelInvocationLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelInvocationLoggingConfiguration
func (c *Bedrock) GetModelInvocationLoggingConfigurationRequest(input *GetModelInvocationLoggingConfigurationInput) (req *request.Request, output *GetModelInvocationLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetModelInvocationLoggingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/logging/modelinvocations",
	}

	if input == nil {
		input = &GetModelInvocationLoggingConfigurationInput{}
	}

	output = &GetModelInvocationLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModelInvocationLoggingConfiguration API operation for Amazon Bedrock.
//
// Get the current configuration values for model invocation logging.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation GetModelInvocationLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelInvocationLoggingConfiguration
func (c *Bedrock) GetModelInvocationLoggingConfiguration(input *GetModelInvocationLoggingConfigurationInput) (*GetModelInvocationLoggingConfigurationOutput, error) {
	req, out := c.GetModelInvocationLoggingConfigurationRequest(input)
	return out, req.Send()
}

// GetModelInvocationLoggingConfigurationWithContext is the same as GetModelInvocationLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetModelInvocationLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) GetModelInvocationLoggingConfigurationWithContext(ctx aws.Context, input *GetModelInvocationLoggingConfigurationInput, opts ...request.Option) (*GetModelInvocationLoggingConfigurationOutput, error) {
	req, out := c.GetModelInvocationLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProvisionedModelThroughput = "GetProvisionedModelThroughput"

// GetProvisionedModelThroughputRequest generates a "aws/request.Request" representing the
// client's request for the GetProvisionedModelThroughput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProvisionedModelThroughput for more information on using the GetProvisionedModelThroughput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProvisionedModelThroughputRequest method.
//	req, resp := client.GetProvisionedModelThroughputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetProvisionedModelThroughput
func (c *Bedrock) GetProvisionedModelThroughputRequest(input *GetProvisionedModelThroughputInput) (req *request.Request, output *GetProvisionedModelThroughputOutput) {
	op := &request.Operation{
		Name:       opGetProvisionedModelThroughput,
		HTTPMethod: "GET",
		HTTPPath:   "/provisioned-model-throughput/{provisionedModelId}",
	}

	if input == nil {
		input = &GetProvisionedModelThroughputInput{}
	}

	output = &GetProvisionedModelThroughputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProvisionedModelThroughput API operation for Amazon Bedrock.
//
// Returns details for a Provisioned Throughput. For more information, see Provisioned
// Throughput (https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation GetProvisionedModelThroughput for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetProvisionedModelThroughput
func (c *Bedrock) GetProvisionedModelThroughput(input *GetProvisionedModelThroughputInput) (*GetProvisionedModelThroughputOutput, error) {
	req, out := c.GetProvisionedModelThroughputRequest(input)
	return out, req.Send()
}

// GetProvisionedModelThroughputWithContext is the same as GetProvisionedModelThroughput with the addition of
// the ability to pass a context and additional request options.
//
// See GetProvisionedModelThroughput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) GetProvisionedModelThroughputWithContext(ctx aws.Context, input *GetProvisionedModelThroughputInput, opts ...request.Option) (*GetProvisionedModelThroughputOutput, error) {
	req, out := c.GetProvisionedModelThroughputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCustomModels = "ListCustomModels"

// ListCustomModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomModels for more information on using the ListCustomModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomModelsRequest method.
//	req, resp := client.ListCustomModelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListCustomModels
func (c *Bedrock) ListCustomModelsRequest(input *ListCustomModelsInput) (req *request.Request, output *ListCustomModelsOutput) {
	op := &request.Operation{
		Name:       opListCustomModels,
		HTTPMethod: "GET",
		HTTPPath:   "/custom-models",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomModelsInput{}
	}

	output = &ListCustomModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomModels API operation for Amazon Bedrock.
//
// Returns a list of the custom models that you have created with the CreateModelCustomizationJob
// operation.
//
// For more information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation ListCustomModels for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListCustomModels
func (c *Bedrock) ListCustomModels(input *ListCustomModelsInput) (*ListCustomModelsOutput, error) {
	req, out := c.ListCustomModelsRequest(input)
	return out, req.Send()
}

// ListCustomModelsWithContext is the same as ListCustomModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListCustomModelsWithContext(ctx aws.Context, input *ListCustomModelsInput, opts ...request.Option) (*ListCustomModelsOutput, error) {
	req, out := c.ListCustomModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomModelsPages iterates over the pages of a ListCustomModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomModels operation.
//	pageNum := 0
//	err := client.ListCustomModelsPages(params,
//	    func(page *bedrock.ListCustomModelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Bedrock) ListCustomModelsPages(input *ListCustomModelsInput, fn func(*ListCustomModelsOutput, bool) bool) error {
	return c.ListCustomModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomModelsPagesWithContext same as ListCustomModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListCustomModelsPagesWithContext(ctx aws.Context, input *ListCustomModelsInput, fn func(*ListCustomModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEvaluationJobs = "ListEvaluationJobs"

// ListEvaluationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListEvaluationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEvaluationJobs for more information on using the ListEvaluationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEvaluationJobsRequest method.
//	req, resp := client.ListEvaluationJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListEvaluationJobs
func (c *Bedrock) ListEvaluationJobsRequest(input *ListEvaluationJobsInput) (req *request.Request, output *ListEvaluationJobsOutput) {
	op := &request.Operation{
		Name:       opListEvaluationJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/evaluation-jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEvaluationJobsInput{}
	}

	output = &ListEvaluationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEvaluationJobs API operation for Amazon Bedrock.
//
// Lists model evaluation jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation ListEvaluationJobs for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListEvaluationJobs
func (c *Bedrock) ListEvaluationJobs(input *ListEvaluationJobsInput) (*ListEvaluationJobsOutput, error) {
	req, out := c.ListEvaluationJobsRequest(input)
	return out, req.Send()
}

// ListEvaluationJobsWithContext is the same as ListEvaluationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEvaluationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListEvaluationJobsWithContext(ctx aws.Context, input *ListEvaluationJobsInput, opts ...request.Option) (*ListEvaluationJobsOutput, error) {
	req, out := c.ListEvaluationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEvaluationJobsPages iterates over the pages of a ListEvaluationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEvaluationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEvaluationJobs operation.
//	pageNum := 0
//	err := client.ListEvaluationJobsPages(params,
//	    func(page *bedrock.ListEvaluationJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Bedrock) ListEvaluationJobsPages(input *ListEvaluationJobsInput, fn func(*ListEvaluationJobsOutput, bool) bool) error {
	return c.ListEvaluationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEvaluationJobsPagesWithContext same as ListEvaluationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListEvaluationJobsPagesWithContext(ctx aws.Context, input *ListEvaluationJobsInput, fn func(*ListEvaluationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEvaluationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEvaluationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEvaluationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFoundationModels = "ListFoundationModels"

// ListFoundationModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListFoundationModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFoundationModels for more information on using the ListFoundationModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFoundationModelsRequest method.
//	req, resp := client.ListFoundationModelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListFoundationModels
func (c *Bedrock) ListFoundationModelsRequest(input *ListFoundationModelsInput) (req *request.Request, output *ListFoundationModelsOutput) {
	op := &request.Operation{
		Name:       opListFoundationModels,
		HTTPMethod: "GET",
		HTTPPath:   "/foundation-models",
	}

	if input == nil {
		input = &ListFoundationModelsInput{}
	}

	output = &ListFoundationModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFoundationModels API operation for Amazon Bedrock.
//
// Lists Amazon Bedrock foundation models that you can use. You can filter the
// results with the request parameters. For more information, see Foundation
// models (https://docs.aws.amazon.com/bedrock/latest/userguide/foundation-models.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation ListFoundationModels for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListFoundationModels
func (c *Bedrock) ListFoundationModels(input *ListFoundationModelsInput) (*ListFoundationModelsOutput, error) {
	req, out := c.ListFoundationModelsRequest(input)
	return out, req.Send()
}

// ListFoundationModelsWithContext is the same as ListFoundationModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListFoundationModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListFoundationModelsWithContext(ctx aws.Context, input *ListFoundationModelsInput, opts ...request.Option) (*ListFoundationModelsOutput, error) {
	req, out := c.ListFoundationModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGuardrails = "ListGuardrails"

// ListGuardrailsRequest generates a "aws/request.Request" representing the
// client's request for the ListGuardrails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGuardrails for more information on using the ListGuardrails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGuardrailsRequest method.
//	req, resp := client.ListGuardrailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListGuardrails
func (c *Bedrock) ListGuardrailsRequest(input *ListGuardrailsInput) (req *request.Request, output *ListGuardrailsOutput) {
	op := &request.Operation{
		Name:       opListGuardrails,
		HTTPMethod: "GET",
		HTTPPath:   "/guardrails",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGuardrailsInput{}
	}

	output = &ListGuardrailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGuardrails API operation for Amazon Bedrock.
//
// Lists details about all the guardrails in an account. To list the DRAFT version
// of all your guardrails, don't specify the guardrailIdentifier field. To list
// all versions of a guardrail, specify the ARN of the guardrail in the guardrailIdentifier
// field.
//
// You can set the maximum number of results to return in a response in the
// maxResults field. If there are more results than the number you set, the
// response returns a nextToken that you can send in another ListGuardrails
// request to see the next batch of results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation ListGuardrails for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListGuardrails
func (c *Bedrock) ListGuardrails(input *ListGuardrailsInput) (*ListGuardrailsOutput, error) {
	req, out := c.ListGuardrailsRequest(input)
	return out, req.Send()
}

// ListGuardrailsWithContext is the same as ListGuardrails with the addition of
// the ability to pass a context and additional request options.
//
// See ListGuardrails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListGuardrailsWithContext(ctx aws.Context, input *ListGuardrailsInput, opts ...request.Option) (*ListGuardrailsOutput, error) {
	req, out := c.ListGuardrailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGuardrailsPages iterates over the pages of a ListGuardrails operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGuardrails method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGuardrails operation.
//	pageNum := 0
//	err := client.ListGuardrailsPages(params,
//	    func(page *bedrock.ListGuardrailsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Bedrock) ListGuardrailsPages(input *ListGuardrailsInput, fn func(*ListGuardrailsOutput, bool) bool) error {
	return c.ListGuardrailsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGuardrailsPagesWithContext same as ListGuardrailsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListGuardrailsPagesWithContext(ctx aws.Context, input *ListGuardrailsInput, fn func(*ListGuardrailsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGuardrailsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGuardrailsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGuardrailsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListModelCustomizationJobs = "ListModelCustomizationJobs"

// ListModelCustomizationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListModelCustomizationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModelCustomizationJobs for more information on using the ListModelCustomizationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListModelCustomizationJobsRequest method.
//	req, resp := client.ListModelCustomizationJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelCustomizationJobs
func (c *Bedrock) ListModelCustomizationJobsRequest(input *ListModelCustomizationJobsInput) (req *request.Request, output *ListModelCustomizationJobsOutput) {
	op := &request.Operation{
		Name:       opListModelCustomizationJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/model-customization-jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelCustomizationJobsInput{}
	}

	output = &ListModelCustomizationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModelCustomizationJobs API operation for Amazon Bedrock.
//
// Returns a list of model customization jobs that you have submitted. You can
// filter the jobs to return based on one or more criteria.
//
// For more information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation ListModelCustomizationJobs for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelCustomizationJobs
func (c *Bedrock) ListModelCustomizationJobs(input *ListModelCustomizationJobsInput) (*ListModelCustomizationJobsOutput, error) {
	req, out := c.ListModelCustomizationJobsRequest(input)
	return out, req.Send()
}

// ListModelCustomizationJobsWithContext is the same as ListModelCustomizationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListModelCustomizationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListModelCustomizationJobsWithContext(ctx aws.Context, input *ListModelCustomizationJobsInput, opts ...request.Option) (*ListModelCustomizationJobsOutput, error) {
	req, out := c.ListModelCustomizationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelCustomizationJobsPages iterates over the pages of a ListModelCustomizationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModelCustomizationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListModelCustomizationJobs operation.
//	pageNum := 0
//	err := client.ListModelCustomizationJobsPages(params,
//	    func(page *bedrock.ListModelCustomizationJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Bedrock) ListModelCustomizationJobsPages(input *ListModelCustomizationJobsInput, fn func(*ListModelCustomizationJobsOutput, bool) bool) error {
	return c.ListModelCustomizationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelCustomizationJobsPagesWithContext same as ListModelCustomizationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListModelCustomizationJobsPagesWithContext(ctx aws.Context, input *ListModelCustomizationJobsInput, fn func(*ListModelCustomizationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelCustomizationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelCustomizationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelCustomizationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProvisionedModelThroughputs = "ListProvisionedModelThroughputs"

// ListProvisionedModelThroughputsRequest generates a "aws/request.Request" representing the
// client's request for the ListProvisionedModelThroughputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProvisionedModelThroughputs for more information on using the ListProvisionedModelThroughputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProvisionedModelThroughputsRequest method.
//	req, resp := client.ListProvisionedModelThroughputsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListProvisionedModelThroughputs
func (c *Bedrock) ListProvisionedModelThroughputsRequest(input *ListProvisionedModelThroughputsInput) (req *request.Request, output *ListProvisionedModelThroughputsOutput) {
	op := &request.Operation{
		Name:       opListProvisionedModelThroughputs,
		HTTPMethod: "GET",
		HTTPPath:   "/provisioned-model-throughputs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProvisionedModelThroughputsInput{}
	}

	output = &ListProvisionedModelThroughputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProvisionedModelThroughputs API operation for Amazon Bedrock.
//
// Lists the Provisioned Throughputs in the account. For more information, see
// Provisioned Throughput (https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation ListProvisionedModelThroughputs for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListProvisionedModelThroughputs
func (c *Bedrock) ListProvisionedModelThroughputs(input *ListProvisionedModelThroughputsInput) (*ListProvisionedModelThroughputsOutput, error) {
	req, out := c.ListProvisionedModelThroughputsRequest(input)
	return out, req.Send()
}

// ListProvisionedModelThroughputsWithContext is the same as ListProvisionedModelThroughputs with the addition of
// the ability to pass a context and additional request options.
//
// See ListProvisionedModelThroughputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListProvisionedModelThroughputsWithContext(ctx aws.Context, input *ListProvisionedModelThroughputsInput, opts ...request.Option) (*ListProvisionedModelThroughputsOutput, error) {
	req, out := c.ListProvisionedModelThroughputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProvisionedModelThroughputsPages iterates over the pages of a ListProvisionedModelThroughputs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProvisionedModelThroughputs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProvisionedModelThroughputs operation.
//	pageNum := 0
//	err := client.ListProvisionedModelThroughputsPages(params,
//	    func(page *bedrock.ListProvisionedModelThroughputsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Bedrock) ListProvisionedModelThroughputsPages(input *ListProvisionedModelThroughputsInput, fn func(*ListProvisionedModelThroughputsOutput, bool) bool) error {
	return c.ListProvisionedModelThroughputsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProvisionedModelThroughputsPagesWithContext same as ListProvisionedModelThroughputsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListProvisionedModelThroughputsPagesWithContext(ctx aws.Context, input *ListProvisionedModelThroughputsInput, fn func(*ListProvisionedModelThroughputsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProvisionedModelThroughputsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProvisionedModelThroughputsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProvisionedModelThroughputsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListTagsForResource
func (c *Bedrock) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/listTagsForResource",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Bedrock.
//
// List the tags associated with the specified resource.
//
// For more information, see Tagging resources (https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListTagsForResource
func (c *Bedrock) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutModelInvocationLoggingConfiguration = "PutModelInvocationLoggingConfiguration"

// PutModelInvocationLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutModelInvocationLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutModelInvocationLoggingConfiguration for more information on using the PutModelInvocationLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutModelInvocationLoggingConfigurationRequest method.
//	req, resp := client.PutModelInvocationLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/PutModelInvocationLoggingConfiguration
func (c *Bedrock) PutModelInvocationLoggingConfigurationRequest(input *PutModelInvocationLoggingConfigurationInput) (req *request.Request, output *PutModelInvocationLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutModelInvocationLoggingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/logging/modelinvocations",
	}

	if input == nil {
		input = &PutModelInvocationLoggingConfigurationInput{}
	}

	output = &PutModelInvocationLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutModelInvocationLoggingConfiguration API operation for Amazon Bedrock.
//
// Set the configuration values for model invocation logging.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation PutModelInvocationLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/PutModelInvocationLoggingConfiguration
func (c *Bedrock) PutModelInvocationLoggingConfiguration(input *PutModelInvocationLoggingConfigurationInput) (*PutModelInvocationLoggingConfigurationOutput, error) {
	req, out := c.PutModelInvocationLoggingConfigurationRequest(input)
	return out, req.Send()
}

// PutModelInvocationLoggingConfigurationWithContext is the same as PutModelInvocationLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutModelInvocationLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) PutModelInvocationLoggingConfigurationWithContext(ctx aws.Context, input *PutModelInvocationLoggingConfigurationInput, opts ...request.Option) (*PutModelInvocationLoggingConfigurationOutput, error) {
	req, out := c.PutModelInvocationLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopEvaluationJob = "StopEvaluationJob"

// StopEvaluationJobRequest generates a "aws/request.Request" representing the
// client's request for the StopEvaluationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopEvaluationJob for more information on using the StopEvaluationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopEvaluationJobRequest method.
//	req, resp := client.StopEvaluationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StopEvaluationJob
func (c *Bedrock) StopEvaluationJobRequest(input *StopEvaluationJobInput) (req *request.Request, output *StopEvaluationJobOutput) {
	op := &request.Operation{
		Name:       opStopEvaluationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/evaluation-job/{jobIdentifier}/stop",
	}

	if input == nil {
		input = &StopEvaluationJobInput{}
	}

	output = &StopEvaluationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopEvaluationJob API operation for Amazon Bedrock.
//
// Stops an in progress model evaluation job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation StopEvaluationJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StopEvaluationJob
func (c *Bedrock) StopEvaluationJob(input *StopEvaluationJobInput) (*StopEvaluationJobOutput, error) {
	req, out := c.StopEvaluationJobRequest(input)
	return out, req.Send()
}

// StopEvaluationJobWithContext is the same as StopEvaluationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopEvaluationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) StopEvaluationJobWithContext(ctx aws.Context, input *StopEvaluationJobInput, opts ...request.Option) (*StopEvaluationJobOutput, error) {
	req, out := c.StopEvaluationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopModelCustomizationJob = "StopModelCustomizationJob"

// StopModelCustomizationJobRequest generates a "aws/request.Request" representing the
// client's request for the StopModelCustomizationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopModelCustomizationJob for more information on using the StopModelCustomizationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopModelCustomizationJobRequest method.
//	req, resp := client.StopModelCustomizationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StopModelCustomizationJob
func (c *Bedrock) StopModelCustomizationJobRequest(input *StopModelCustomizationJobInput) (req *request.Request, output *StopModelCustomizationJobOutput) {
	op := &request.Operation{
		Name:       opStopModelCustomizationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/model-customization-jobs/{jobIdentifier}/stop",
	}

	if input == nil {
		input = &StopModelCustomizationJobInput{}
	}

	output = &StopModelCustomizationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopModelCustomizationJob API operation for Amazon Bedrock.
//
// Stops an active model customization job. For more information, see Custom
// models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation StopModelCustomizationJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StopModelCustomizationJob
func (c *Bedrock) StopModelCustomizationJob(input *StopModelCustomizationJobInput) (*StopModelCustomizationJobOutput, error) {
	req, out := c.StopModelCustomizationJobRequest(input)
	return out, req.Send()
}

// StopModelCustomizationJobWithContext is the same as StopModelCustomizationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopModelCustomizationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) StopModelCustomizationJobWithContext(ctx aws.Context, input *StopModelCustomizationJobInput, opts ...request.Option) (*StopModelCustomizationJobOutput, error) {
	req, out := c.StopModelCustomizationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/TagResource
func (c *Bedrock) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tagResource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Bedrock.
//
// Associate tags with a resource. For more information, see Tagging resources
// (https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html) in the
// Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/TagResource
func (c *Bedrock) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UntagResource
func (c *Bedrock) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/untagResource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Bedrock.
//
// Remove one or more tags from a resource. For more information, see Tagging
// resources (https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UntagResource
func (c *Bedrock) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGuardrail = "UpdateGuardrail"

// UpdateGuardrailRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGuardrail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGuardrail for more information on using the UpdateGuardrail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGuardrailRequest method.
//	req, resp := client.UpdateGuardrailRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateGuardrail
func (c *Bedrock) UpdateGuardrailRequest(input *UpdateGuardrailInput) (req *request.Request, output *UpdateGuardrailOutput) {
	op := &request.Operation{
		Name:       opUpdateGuardrail,
		HTTPMethod: "PUT",
		HTTPPath:   "/guardrails/{guardrailIdentifier}",
	}

	if input == nil {
		input = &UpdateGuardrailInput{}
	}

	output = &UpdateGuardrailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGuardrail API operation for Amazon Bedrock.
//
// Updates a guardrail with the values you specify.
//
//   - Specify a name and optional description.
//
//   - Specify messages for when the guardrail successfully blocks a prompt
//     or a model response in the blockedInputMessaging and blockedOutputsMessaging
//     fields.
//
//   - Specify topics for the guardrail to deny in the topicPolicyConfig object.
//     Each GuardrailTopicConfig (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailTopicConfig.html)
//     object in the topicsConfig list pertains to one topic. Give a name and
//     description so that the guardrail can properly identify the topic. Specify
//     DENY in the type field. (Optional) Provide up to five prompts that you
//     would categorize as belonging to the topic in the examples list.
//
//   - Specify filter strengths for the harmful categories defined in Amazon
//     Bedrock in the contentPolicyConfig object. Each GuardrailContentFilterConfig
//     (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html)
//     object in the filtersConfig list pertains to a harmful category. For more
//     information, see Content filters (https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-content-filters).
//     For more information about the fields in a content filter, see GuardrailContentFilterConfig
//     (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html).
//     Specify the category in the type field. Specify the strength of the filter
//     for prompts in the inputStrength field and for model responses in the
//     strength field of the GuardrailContentFilterConfig (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html).
//
//   - (Optional) For security, include the ARN of a KMS key in the kmsKeyId
//     field.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation UpdateGuardrail for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateGuardrail
func (c *Bedrock) UpdateGuardrail(input *UpdateGuardrailInput) (*UpdateGuardrailOutput, error) {
	req, out := c.UpdateGuardrailRequest(input)
	return out, req.Send()
}

// UpdateGuardrailWithContext is the same as UpdateGuardrail with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGuardrail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) UpdateGuardrailWithContext(ctx aws.Context, input *UpdateGuardrailInput, opts ...request.Option) (*UpdateGuardrailOutput, error) {
	req, out := c.UpdateGuardrailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProvisionedModelThroughput = "UpdateProvisionedModelThroughput"

// UpdateProvisionedModelThroughputRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProvisionedModelThroughput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProvisionedModelThroughput for more information on using the UpdateProvisionedModelThroughput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProvisionedModelThroughputRequest method.
//	req, resp := client.UpdateProvisionedModelThroughputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateProvisionedModelThroughput
func (c *Bedrock) UpdateProvisionedModelThroughputRequest(input *UpdateProvisionedModelThroughputInput) (req *request.Request, output *UpdateProvisionedModelThroughputOutput) {
	op := &request.Operation{
		Name:       opUpdateProvisionedModelThroughput,
		HTTPMethod: "PATCH",
		HTTPPath:   "/provisioned-model-throughput/{provisionedModelId}",
	}

	if input == nil {
		input = &UpdateProvisionedModelThroughputInput{}
	}

	output = &UpdateProvisionedModelThroughputOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateProvisionedModelThroughput API operation for Amazon Bedrock.
//
// Updates the name or associated model for a Provisioned Throughput. For more
// information, see Provisioned Throughput (https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation UpdateProvisionedModelThroughput for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateProvisionedModelThroughput
func (c *Bedrock) UpdateProvisionedModelThroughput(input *UpdateProvisionedModelThroughputInput) (*UpdateProvisionedModelThroughputOutput, error) {
	req, out := c.UpdateProvisionedModelThroughputRequest(input)
	return out, req.Send()
}

// UpdateProvisionedModelThroughputWithContext is the same as UpdateProvisionedModelThroughput with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProvisionedModelThroughput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) UpdateProvisionedModelThroughputWithContext(ctx aws.Context, input *UpdateProvisionedModelThroughputInput, opts ...request.Option) (*UpdateProvisionedModelThroughputOutput, error) {
	req, out := c.UpdateProvisionedModelThroughputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The request is denied because of missing access permissions.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Use to specify a automatic model evaluation job. The EvaluationDatasetMetricConfig
// object is used to specify the prompt datasets, task type, and metric names.
type AutomatedEvaluationConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the required elements for an automatic model evaluation job.
	//
	// DatasetMetricConfigs is a required field
	DatasetMetricConfigs []*EvaluationDatasetMetricConfig `locationName:"datasetMetricConfigs" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomatedEvaluationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomatedEvaluationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutomatedEvaluationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutomatedEvaluationConfig"}
	if s.DatasetMetricConfigs == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetMetricConfigs"))
	}
	if s.DatasetMetricConfigs != nil && len(s.DatasetMetricConfigs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetMetricConfigs", 1))
	}
	if s.DatasetMetricConfigs != nil {
		for i, v := range s.DatasetMetricConfigs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DatasetMetricConfigs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetMetricConfigs sets the DatasetMetricConfigs field's value.
func (s *AutomatedEvaluationConfig) SetDatasetMetricConfigs(v []*EvaluationDatasetMetricConfig) *AutomatedEvaluationConfig {
	s.DatasetMetricConfigs = v
	return s
}

// CloudWatch logging configuration.
type CloudWatchConfig struct {
	_ struct{} `type:"structure"`

	// S3 configuration for delivering a large amount of data.
	LargeDataDeliveryS3Config *S3Config `locationName:"largeDataDeliveryS3Config" type:"structure"`

	// The log group name.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The role Amazon Resource Name (ARN).
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchConfig"}
	if s.LogGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.LargeDataDeliveryS3Config != nil {
		if err := s.LargeDataDeliveryS3Config.Validate(); err != nil {
			invalidParams.AddNested("LargeDataDeliveryS3Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLargeDataDeliveryS3Config sets the LargeDataDeliveryS3Config field's value.
func (s *CloudWatchConfig) SetLargeDataDeliveryS3Config(v *S3Config) *CloudWatchConfig {
	s.LargeDataDeliveryS3Config = v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *CloudWatchConfig) SetLogGroupName(v string) *CloudWatchConfig {
	s.LogGroupName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CloudWatchConfig) SetRoleArn(v string) *CloudWatchConfig {
	s.RoleArn = &v
	return s
}

// Error occurred because of a conflict while performing an operation.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateEvaluationJobInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// Specify your customer managed key ARN that will be used to encrypt your model
	// evaluation job.
	CustomerEncryptionKeyId *string `locationName:"customerEncryptionKeyId" min:"1" type:"string"`

	// Specifies whether the model evaluation job is automatic or uses human worker.
	//
	// EvaluationConfig is a required field
	EvaluationConfig *EvaluationConfig `locationName:"evaluationConfig" type:"structure" required:"true"`

	// Specify the models you want to use in your model evaluation job. Automatic
	// model evaluation jobs support a single model, and model evaluation job that
	// use human workers support two models.
	//
	// InferenceConfig is a required field
	InferenceConfig *EvaluationInferenceConfig `locationName:"inferenceConfig" type:"structure" required:"true"`

	// A description of the model evaluation job.
	//
	// JobDescription is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEvaluationJobInput's
	// String and GoString methods.
	JobDescription *string `locationName:"jobDescription" min:"1" type:"string" sensitive:"true"`

	// The name of the model evaluation job. Model evaluation job names must unique
	// with your AWS account, and your account's AWS region.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// Tags to attach to the model evaluation job.
	JobTags []*Tag `locationName:"jobTags" type:"list"`

	// An object that defines where the results of model evaluation job will be
	// saved in Amazon S3.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *EvaluationOutputDataConfig `locationName:"outputDataConfig" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock
	// can assume to perform tasks on your behalf. The service role must have Amazon
	// Bedrock as the service principal, and provide access to any Amazon S3 buckets
	// specified in the EvaluationConfig object. To pass this role to Amazon Bedrock,
	// the caller of this API must have the iam:PassRole permission. To learn more
	// about the required permissions, see Required permissions (https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-security.html).
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEvaluationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEvaluationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEvaluationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEvaluationJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.CustomerEncryptionKeyId != nil && len(*s.CustomerEncryptionKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerEncryptionKeyId", 1))
	}
	if s.EvaluationConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationConfig"))
	}
	if s.InferenceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InferenceConfig"))
	}
	if s.JobDescription != nil && len(*s.JobDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobDescription", 1))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.EvaluationConfig != nil {
		if err := s.EvaluationConfig.Validate(); err != nil {
			invalidParams.AddNested("EvaluationConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.InferenceConfig != nil {
		if err := s.InferenceConfig.Validate(); err != nil {
			invalidParams.AddNested("InferenceConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.JobTags != nil {
		for i, v := range s.JobTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "JobTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateEvaluationJobInput) SetClientRequestToken(v string) *CreateEvaluationJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetCustomerEncryptionKeyId sets the CustomerEncryptionKeyId field's value.
func (s *CreateEvaluationJobInput) SetCustomerEncryptionKeyId(v string) *CreateEvaluationJobInput {
	s.CustomerEncryptionKeyId = &v
	return s
}

// SetEvaluationConfig sets the EvaluationConfig field's value.
func (s *CreateEvaluationJobInput) SetEvaluationConfig(v *EvaluationConfig) *CreateEvaluationJobInput {
	s.EvaluationConfig = v
	return s
}

// SetInferenceConfig sets the InferenceConfig field's value.
func (s *CreateEvaluationJobInput) SetInferenceConfig(v *EvaluationInferenceConfig) *CreateEvaluationJobInput {
	s.InferenceConfig = v
	return s
}

// SetJobDescription sets the JobDescription field's value.
func (s *CreateEvaluationJobInput) SetJobDescription(v string) *CreateEvaluationJobInput {
	s.JobDescription = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *CreateEvaluationJobInput) SetJobName(v string) *CreateEvaluationJobInput {
	s.JobName = &v
	return s
}

// SetJobTags sets the JobTags field's value.
func (s *CreateEvaluationJobInput) SetJobTags(v []*Tag) *CreateEvaluationJobInput {
	s.JobTags = v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *CreateEvaluationJobInput) SetOutputDataConfig(v *EvaluationOutputDataConfig) *CreateEvaluationJobInput {
	s.OutputDataConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateEvaluationJobInput) SetRoleArn(v string) *CreateEvaluationJobInput {
	s.RoleArn = &v
	return s
}

type CreateEvaluationJobOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the model evaluation job.
	//
	// JobArn is a required field
	JobArn *string `locationName:"jobArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEvaluationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEvaluationJobOutput) GoString() string {
	return s.String()
}

// SetJobArn sets the JobArn field's value.
func (s *CreateEvaluationJobOutput) SetJobArn(v string) *CreateEvaluationJobOutput {
	s.JobArn = &v
	return s
}

type CreateGuardrailInput struct {
	_ struct{} `type:"structure"`

	// The message to return when the guardrail blocks a prompt.
	//
	// BlockedInputMessaging is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGuardrailInput's
	// String and GoString methods.
	//
	// BlockedInputMessaging is a required field
	BlockedInputMessaging *string `locationName:"blockedInputMessaging" min:"1" type:"string" required:"true" sensitive:"true"`

	// The message to return when the guardrail blocks a model response.
	//
	// BlockedOutputsMessaging is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGuardrailInput's
	// String and GoString methods.
	//
	// BlockedOutputsMessaging is a required field
	BlockedOutputsMessaging *string `locationName:"blockedOutputsMessaging" min:"1" type:"string" required:"true" sensitive:"true"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than once. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
	// in the Amazon S3 User Guide.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The content filter policies to configure for the guardrail.
	ContentPolicyConfig *GuardrailContentPolicyConfig `locationName:"contentPolicyConfig" type:"structure"`

	// The contextual grounding policy configuration used to create a guardrail.
	ContextualGroundingPolicyConfig *GuardrailContextualGroundingPolicyConfig `locationName:"contextualGroundingPolicyConfig" type:"structure"`

	// A description of the guardrail.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGuardrailInput's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The ARN of the KMS key that you use to encrypt the guardrail.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name to give the guardrail.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGuardrailInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The sensitive information policy to configure for the guardrail.
	SensitiveInformationPolicyConfig *GuardrailSensitiveInformationPolicyConfig `locationName:"sensitiveInformationPolicyConfig" type:"structure"`

	// The tags that you want to attach to the guardrail.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The topic policies to configure for the guardrail.
	TopicPolicyConfig *GuardrailTopicPolicyConfig `locationName:"topicPolicyConfig" type:"structure"`

	// The word policy you configure for the guardrail.
	WordPolicyConfig *GuardrailWordPolicyConfig `locationName:"wordPolicyConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGuardrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGuardrailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGuardrailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGuardrailInput"}
	if s.BlockedInputMessaging == nil {
		invalidParams.Add(request.NewErrParamRequired("BlockedInputMessaging"))
	}
	if s.BlockedInputMessaging != nil && len(*s.BlockedInputMessaging) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BlockedInputMessaging", 1))
	}
	if s.BlockedOutputsMessaging == nil {
		invalidParams.Add(request.NewErrParamRequired("BlockedOutputsMessaging"))
	}
	if s.BlockedOutputsMessaging != nil && len(*s.BlockedOutputsMessaging) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BlockedOutputsMessaging", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ContentPolicyConfig != nil {
		if err := s.ContentPolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("ContentPolicyConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ContextualGroundingPolicyConfig != nil {
		if err := s.ContextualGroundingPolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("ContextualGroundingPolicyConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.SensitiveInformationPolicyConfig != nil {
		if err := s.SensitiveInformationPolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("SensitiveInformationPolicyConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TopicPolicyConfig != nil {
		if err := s.TopicPolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("TopicPolicyConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.WordPolicyConfig != nil {
		if err := s.WordPolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("WordPolicyConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockedInputMessaging sets the BlockedInputMessaging field's value.
func (s *CreateGuardrailInput) SetBlockedInputMessaging(v string) *CreateGuardrailInput {
	s.BlockedInputMessaging = &v
	return s
}

// SetBlockedOutputsMessaging sets the BlockedOutputsMessaging field's value.
func (s *CreateGuardrailInput) SetBlockedOutputsMessaging(v string) *CreateGuardrailInput {
	s.BlockedOutputsMessaging = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateGuardrailInput) SetClientRequestToken(v string) *CreateGuardrailInput {
	s.ClientRequestToken = &v
	return s
}

// SetContentPolicyConfig sets the ContentPolicyConfig field's value.
func (s *CreateGuardrailInput) SetContentPolicyConfig(v *GuardrailContentPolicyConfig) *CreateGuardrailInput {
	s.ContentPolicyConfig = v
	return s
}

// SetContextualGroundingPolicyConfig sets the ContextualGroundingPolicyConfig field's value.
func (s *CreateGuardrailInput) SetContextualGroundingPolicyConfig(v *GuardrailContextualGroundingPolicyConfig) *CreateGuardrailInput {
	s.ContextualGroundingPolicyConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateGuardrailInput) SetDescription(v string) *CreateGuardrailInput {
	s.Description = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateGuardrailInput) SetKmsKeyId(v string) *CreateGuardrailInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGuardrailInput) SetName(v string) *CreateGuardrailInput {
	s.Name = &v
	return s
}

// SetSensitiveInformationPolicyConfig sets the SensitiveInformationPolicyConfig field's value.
func (s *CreateGuardrailInput) SetSensitiveInformationPolicyConfig(v *GuardrailSensitiveInformationPolicyConfig) *CreateGuardrailInput {
	s.SensitiveInformationPolicyConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGuardrailInput) SetTags(v []*Tag) *CreateGuardrailInput {
	s.Tags = v
	return s
}

// SetTopicPolicyConfig sets the TopicPolicyConfig field's value.
func (s *CreateGuardrailInput) SetTopicPolicyConfig(v *GuardrailTopicPolicyConfig) *CreateGuardrailInput {
	s.TopicPolicyConfig = v
	return s
}

// SetWordPolicyConfig sets the WordPolicyConfig field's value.
func (s *CreateGuardrailInput) SetWordPolicyConfig(v *GuardrailWordPolicyConfig) *CreateGuardrailInput {
	s.WordPolicyConfig = v
	return s
}

type CreateGuardrailOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the guardrail was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ARN of the guardrail.
	//
	// GuardrailArn is a required field
	GuardrailArn *string `locationName:"guardrailArn" type:"string" required:"true"`

	// The unique identifier of the guardrail that was created.
	//
	// GuardrailId is a required field
	GuardrailId *string `locationName:"guardrailId" type:"string" required:"true"`

	// The version of the guardrail that was created. This value will always be
	// DRAFT.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGuardrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGuardrailOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateGuardrailOutput) SetCreatedAt(v time.Time) *CreateGuardrailOutput {
	s.CreatedAt = &v
	return s
}

// SetGuardrailArn sets the GuardrailArn field's value.
func (s *CreateGuardrailOutput) SetGuardrailArn(v string) *CreateGuardrailOutput {
	s.GuardrailArn = &v
	return s
}

// SetGuardrailId sets the GuardrailId field's value.
func (s *CreateGuardrailOutput) SetGuardrailId(v string) *CreateGuardrailOutput {
	s.GuardrailId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateGuardrailOutput) SetVersion(v string) *CreateGuardrailOutput {
	s.Version = &v
	return s
}

type CreateGuardrailVersionInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than once. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
	// in the Amazon S3 User Guide.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description of the guardrail version.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGuardrailVersionInput's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The unique identifier of the guardrail. This can be an ID or the ARN.
	//
	// GuardrailIdentifier is a required field
	GuardrailIdentifier *string `location:"uri" locationName:"guardrailIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGuardrailVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGuardrailVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGuardrailVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGuardrailVersionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.GuardrailIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GuardrailIdentifier"))
	}
	if s.GuardrailIdentifier != nil && len(*s.GuardrailIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GuardrailIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateGuardrailVersionInput) SetClientRequestToken(v string) *CreateGuardrailVersionInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateGuardrailVersionInput) SetDescription(v string) *CreateGuardrailVersionInput {
	s.Description = &v
	return s
}

// SetGuardrailIdentifier sets the GuardrailIdentifier field's value.
func (s *CreateGuardrailVersionInput) SetGuardrailIdentifier(v string) *CreateGuardrailVersionInput {
	s.GuardrailIdentifier = &v
	return s
}

type CreateGuardrailVersionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the guardrail.
	//
	// GuardrailId is a required field
	GuardrailId *string `locationName:"guardrailId" type:"string" required:"true"`

	// The number of the version of the guardrail.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGuardrailVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGuardrailVersionOutput) GoString() string {
	return s.String()
}

// SetGuardrailId sets the GuardrailId field's value.
func (s *CreateGuardrailVersionOutput) SetGuardrailId(v string) *CreateGuardrailVersionOutput {
	s.GuardrailId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateGuardrailVersionOutput) SetVersion(v string) *CreateGuardrailVersionOutput {
	s.Version = &v
	return s
}

type CreateModelCustomizationJobInput struct {
	_ struct{} `type:"structure"`

	// Name of the base model.
	//
	// BaseModelIdentifier is a required field
	BaseModelIdentifier *string `locationName:"baseModelIdentifier" min:"1" type:"string" required:"true"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The custom model is encrypted at rest using this key.
	CustomModelKmsKeyId *string `locationName:"customModelKmsKeyId" min:"1" type:"string"`

	// A name for the resulting custom model.
	//
	// CustomModelName is a required field
	CustomModelName *string `locationName:"customModelName" min:"1" type:"string" required:"true"`

	// Tags to attach to the resulting custom model.
	CustomModelTags []*Tag `locationName:"customModelTags" type:"list"`

	// The customization type.
	CustomizationType *string `locationName:"customizationType" type:"string" enum:"CustomizationType"`

	// Parameters related to tuning the model. For details on the format for different
	// models, see Custom model hyperparameters (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html).
	//
	// HyperParameters is a required field
	HyperParameters map[string]*string `locationName:"hyperParameters" type:"map" required:"true"`

	// A name for the fine-tuning job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// Tags to attach to the job.
	JobTags []*Tag `locationName:"jobTags" type:"list"`

	// S3 location for the output data.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `locationName:"outputDataConfig" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock
	// can assume to perform tasks on your behalf. For example, during model training,
	// Amazon Bedrock needs your permission to read input data from an S3 bucket,
	// write model artifacts to an S3 bucket. To pass this role to Amazon Bedrock,
	// the caller of this API must have the iam:PassRole permission.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Information about the training dataset.
	//
	// TrainingDataConfig is a required field
	TrainingDataConfig *TrainingDataConfig `locationName:"trainingDataConfig" type:"structure" required:"true"`

	// Information about the validation dataset.
	ValidationDataConfig *ValidationDataConfig `locationName:"validationDataConfig" type:"structure"`

	// VPC configuration (optional). Configuration parameters for the private Virtual
	// Private Cloud (VPC) that contains the resources you are using for this job.
	VpcConfig *VpcConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelCustomizationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelCustomizationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelCustomizationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelCustomizationJobInput"}
	if s.BaseModelIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("BaseModelIdentifier"))
	}
	if s.BaseModelIdentifier != nil && len(*s.BaseModelIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BaseModelIdentifier", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.CustomModelKmsKeyId != nil && len(*s.CustomModelKmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomModelKmsKeyId", 1))
	}
	if s.CustomModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomModelName"))
	}
	if s.CustomModelName != nil && len(*s.CustomModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomModelName", 1))
	}
	if s.HyperParameters == nil {
		invalidParams.Add(request.NewErrParamRequired("HyperParameters"))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.TrainingDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingDataConfig"))
	}
	if s.CustomModelTags != nil {
		for i, v := range s.CustomModelTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomModelTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.JobTags != nil {
		for i, v := range s.JobTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "JobTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.TrainingDataConfig != nil {
		if err := s.TrainingDataConfig.Validate(); err != nil {
			invalidParams.AddNested("TrainingDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ValidationDataConfig != nil {
		if err := s.ValidationDataConfig.Validate(); err != nil {
			invalidParams.AddNested("ValidationDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseModelIdentifier sets the BaseModelIdentifier field's value.
func (s *CreateModelCustomizationJobInput) SetBaseModelIdentifier(v string) *CreateModelCustomizationJobInput {
	s.BaseModelIdentifier = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateModelCustomizationJobInput) SetClientRequestToken(v string) *CreateModelCustomizationJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetCustomModelKmsKeyId sets the CustomModelKmsKeyId field's value.
func (s *CreateModelCustomizationJobInput) SetCustomModelKmsKeyId(v string) *CreateModelCustomizationJobInput {
	s.CustomModelKmsKeyId = &v
	return s
}

// SetCustomModelName sets the CustomModelName field's value.
func (s *CreateModelCustomizationJobInput) SetCustomModelName(v string) *CreateModelCustomizationJobInput {
	s.CustomModelName = &v
	return s
}

// SetCustomModelTags sets the CustomModelTags field's value.
func (s *CreateModelCustomizationJobInput) SetCustomModelTags(v []*Tag) *CreateModelCustomizationJobInput {
	s.CustomModelTags = v
	return s
}

// SetCustomizationType sets the CustomizationType field's value.
func (s *CreateModelCustomizationJobInput) SetCustomizationType(v string) *CreateModelCustomizationJobInput {
	s.CustomizationType = &v
	return s
}

// SetHyperParameters sets the HyperParameters field's value.
func (s *CreateModelCustomizationJobInput) SetHyperParameters(v map[string]*string) *CreateModelCustomizationJobInput {
	s.HyperParameters = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *CreateModelCustomizationJobInput) SetJobName(v string) *CreateModelCustomizationJobInput {
	s.JobName = &v
	return s
}

// SetJobTags sets the JobTags field's value.
func (s *CreateModelCustomizationJobInput) SetJobTags(v []*Tag) *CreateModelCustomizationJobInput {
	s.JobTags = v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *CreateModelCustomizationJobInput) SetOutputDataConfig(v *OutputDataConfig) *CreateModelCustomizationJobInput {
	s.OutputDataConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateModelCustomizationJobInput) SetRoleArn(v string) *CreateModelCustomizationJobInput {
	s.RoleArn = &v
	return s
}

// SetTrainingDataConfig sets the TrainingDataConfig field's value.
func (s *CreateModelCustomizationJobInput) SetTrainingDataConfig(v *TrainingDataConfig) *CreateModelCustomizationJobInput {
	s.TrainingDataConfig = v
	return s
}

// SetValidationDataConfig sets the ValidationDataConfig field's value.
func (s *CreateModelCustomizationJobInput) SetValidationDataConfig(v *ValidationDataConfig) *CreateModelCustomizationJobInput {
	s.ValidationDataConfig = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateModelCustomizationJobInput) SetVpcConfig(v *VpcConfig) *CreateModelCustomizationJobInput {
	s.VpcConfig = v
	return s
}

type CreateModelCustomizationJobOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the fine tuning job
	//
	// JobArn is a required field
	JobArn *string `locationName:"jobArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelCustomizationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelCustomizationJobOutput) GoString() string {
	return s.String()
}

// SetJobArn sets the JobArn field's value.
func (s *CreateModelCustomizationJobOutput) SetJobArn(v string) *CreateModelCustomizationJobOutput {
	s.JobArn = &v
	return s
}

type CreateProvisionedModelThroughputInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
	// in the Amazon S3 User Guide.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The commitment duration requested for the Provisioned Throughput. Billing
	// occurs hourly and is discounted for longer commitment terms. To request a
	// no-commit Provisioned Throughput, omit this field.
	//
	// Custom models support all levels of commitment. To see which base models
	// support no commitment, see Supported regions and models for Provisioned Throughput
	// (https://docs.aws.amazon.com/bedrock/latest/userguide/pt-supported.html)
	// in the Amazon Bedrock User Guide
	CommitmentDuration *string `locationName:"commitmentDuration" type:"string" enum:"CommitmentDuration"`

	// The Amazon Resource Name (ARN) or name of the model to associate with this
	// Provisioned Throughput. For a list of models for which you can purchase Provisioned
	// Throughput, see Amazon Bedrock model IDs for purchasing Provisioned Throughput
	// (https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#prov-throughput-models)
	// in the Amazon Bedrock User Guide.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// Number of model units to allocate. A model unit delivers a specific throughput
	// level for the specified model. The throughput level of a model unit specifies
	// the total number of input and output tokens that it can process and generate
	// within a span of one minute. By default, your account has no model units
	// for purchasing Provisioned Throughputs with commitment. You must first visit
	// the Amazon Web Services support center (https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase)
	// to request MUs.
	//
	// For model unit quotas, see Provisioned Throughput quotas (https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html#prov-thru-quotas)
	// in the Amazon Bedrock User Guide.
	//
	// For more information about what an MU specifies, contact your Amazon Web
	// Services account manager.
	//
	// ModelUnits is a required field
	ModelUnits *int64 `locationName:"modelUnits" min:"1" type:"integer" required:"true"`

	// The name for this Provisioned Throughput.
	//
	// ProvisionedModelName is a required field
	ProvisionedModelName *string `locationName:"provisionedModelName" min:"1" type:"string" required:"true"`

	// Tags to associate with this Provisioned Throughput.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProvisionedModelThroughputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProvisionedModelThroughputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProvisionedModelThroughputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProvisionedModelThroughputInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelUnits"))
	}
	if s.ModelUnits != nil && *s.ModelUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ModelUnits", 1))
	}
	if s.ProvisionedModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedModelName"))
	}
	if s.ProvisionedModelName != nil && len(*s.ProvisionedModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedModelName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateProvisionedModelThroughputInput) SetClientRequestToken(v string) *CreateProvisionedModelThroughputInput {
	s.ClientRequestToken = &v
	return s
}

// SetCommitmentDuration sets the CommitmentDuration field's value.
func (s *CreateProvisionedModelThroughputInput) SetCommitmentDuration(v string) *CreateProvisionedModelThroughputInput {
	s.CommitmentDuration = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *CreateProvisionedModelThroughputInput) SetModelId(v string) *CreateProvisionedModelThroughputInput {
	s.ModelId = &v
	return s
}

// SetModelUnits sets the ModelUnits field's value.
func (s *CreateProvisionedModelThroughputInput) SetModelUnits(v int64) *CreateProvisionedModelThroughputInput {
	s.ModelUnits = &v
	return s
}

// SetProvisionedModelName sets the ProvisionedModelName field's value.
func (s *CreateProvisionedModelThroughputInput) SetProvisionedModelName(v string) *CreateProvisionedModelThroughputInput {
	s.ProvisionedModelName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProvisionedModelThroughputInput) SetTags(v []*Tag) *CreateProvisionedModelThroughputInput {
	s.Tags = v
	return s
}

type CreateProvisionedModelThroughputOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for this Provisioned Throughput.
	//
	// ProvisionedModelArn is a required field
	ProvisionedModelArn *string `locationName:"provisionedModelArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProvisionedModelThroughputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProvisionedModelThroughputOutput) GoString() string {
	return s.String()
}

// SetProvisionedModelArn sets the ProvisionedModelArn field's value.
func (s *CreateProvisionedModelThroughputOutput) SetProvisionedModelArn(v string) *CreateProvisionedModelThroughputOutput {
	s.ProvisionedModelArn = &v
	return s
}

// Summary information for a custom model.
type CustomModelSummary struct {
	_ struct{} `type:"structure"`

	// The base model Amazon Resource Name (ARN).
	//
	// BaseModelArn is a required field
	BaseModelArn *string `locationName:"baseModelArn" min:"20" type:"string" required:"true"`

	// The base model name.
	//
	// BaseModelName is a required field
	BaseModelName *string `locationName:"baseModelName" min:"1" type:"string" required:"true"`

	// Creation time of the model.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Specifies whether to carry out continued pre-training of a model or whether
	// to fine-tune it. For more information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html).
	CustomizationType *string `locationName:"customizationType" type:"string" enum:"CustomizationType"`

	// The Amazon Resource Name (ARN) of the custom model.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" min:"20" type:"string" required:"true"`

	// The name of the custom model.
	//
	// ModelName is a required field
	ModelName *string `locationName:"modelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomModelSummary) GoString() string {
	return s.String()
}

// SetBaseModelArn sets the BaseModelArn field's value.
func (s *CustomModelSummary) SetBaseModelArn(v string) *CustomModelSummary {
	s.BaseModelArn = &v
	return s
}

// SetBaseModelName sets the BaseModelName field's value.
func (s *CustomModelSummary) SetBaseModelName(v string) *CustomModelSummary {
	s.BaseModelName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CustomModelSummary) SetCreationTime(v time.Time) *CustomModelSummary {
	s.CreationTime = &v
	return s
}

// SetCustomizationType sets the CustomizationType field's value.
func (s *CustomModelSummary) SetCustomizationType(v string) *CustomModelSummary {
	s.CustomizationType = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *CustomModelSummary) SetModelArn(v string) *CustomModelSummary {
	s.ModelArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CustomModelSummary) SetModelName(v string) *CustomModelSummary {
	s.ModelName = &v
	return s
}

type DeleteCustomModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Name of the model to delete.
	//
	// ModelIdentifier is a required field
	ModelIdentifier *string `location:"uri" locationName:"modelIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomModelInput"}
	if s.ModelIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelIdentifier"))
	}
	if s.ModelIdentifier != nil && len(*s.ModelIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelIdentifier sets the ModelIdentifier field's value.
func (s *DeleteCustomModelInput) SetModelIdentifier(v string) *DeleteCustomModelInput {
	s.ModelIdentifier = &v
	return s
}

type DeleteCustomModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomModelOutput) GoString() string {
	return s.String()
}

type DeleteGuardrailInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the guardrail. This can be an ID or the ARN.
	//
	// GuardrailIdentifier is a required field
	GuardrailIdentifier *string `location:"uri" locationName:"guardrailIdentifier" type:"string" required:"true"`

	// The version of the guardrail.
	GuardrailVersion *string `location:"querystring" locationName:"guardrailVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGuardrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGuardrailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGuardrailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGuardrailInput"}
	if s.GuardrailIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GuardrailIdentifier"))
	}
	if s.GuardrailIdentifier != nil && len(*s.GuardrailIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GuardrailIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGuardrailIdentifier sets the GuardrailIdentifier field's value.
func (s *DeleteGuardrailInput) SetGuardrailIdentifier(v string) *DeleteGuardrailInput {
	s.GuardrailIdentifier = &v
	return s
}

// SetGuardrailVersion sets the GuardrailVersion field's value.
func (s *DeleteGuardrailInput) SetGuardrailVersion(v string) *DeleteGuardrailInput {
	s.GuardrailVersion = &v
	return s
}

type DeleteGuardrailOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGuardrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGuardrailOutput) GoString() string {
	return s.String()
}

type DeleteModelInvocationLoggingConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInvocationLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInvocationLoggingConfigurationInput) GoString() string {
	return s.String()
}

type DeleteModelInvocationLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInvocationLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInvocationLoggingConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteProvisionedModelThroughputInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or name of the Provisioned Throughput.
	//
	// ProvisionedModelId is a required field
	ProvisionedModelId *string `location:"uri" locationName:"provisionedModelId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProvisionedModelThroughputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProvisionedModelThroughputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProvisionedModelThroughputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProvisionedModelThroughputInput"}
	if s.ProvisionedModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedModelId"))
	}
	if s.ProvisionedModelId != nil && len(*s.ProvisionedModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProvisionedModelId sets the ProvisionedModelId field's value.
func (s *DeleteProvisionedModelThroughputInput) SetProvisionedModelId(v string) *DeleteProvisionedModelThroughputInput {
	s.ProvisionedModelId = &v
	return s
}

type DeleteProvisionedModelThroughputOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProvisionedModelThroughputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProvisionedModelThroughputOutput) GoString() string {
	return s.String()
}

// Contains the ARN of the Amazon Bedrock models specified in your model evaluation
// job. Each Amazon Bedrock model supports different inferenceParams. To learn
// more about supported inference parameters for Amazon Bedrock models, see
// Inference parameters for foundation models (https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-prompt-datasets-custom.html).
//
// The inferenceParams are specified using JSON. To successfully insert JSON
// as string make sure that all quotations are properly escaped. For example,
// "temperature":"0.25" key value pair would need to be formatted as \"temperature\":\"0.25\"
// to successfully accepted in the request.
type EvaluationBedrockModel struct {
	_ struct{} `type:"structure"`

	// Each Amazon Bedrock support different inference parameters that change how
	// the model behaves during inference.
	//
	// InferenceParams is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EvaluationBedrockModel's
	// String and GoString methods.
	//
	// InferenceParams is a required field
	InferenceParams *string `locationName:"inferenceParams" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ARN of the Amazon Bedrock model specified.
	//
	// ModelIdentifier is a required field
	ModelIdentifier *string `locationName:"modelIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationBedrockModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationBedrockModel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluationBedrockModel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EvaluationBedrockModel"}
	if s.InferenceParams == nil {
		invalidParams.Add(request.NewErrParamRequired("InferenceParams"))
	}
	if s.InferenceParams != nil && len(*s.InferenceParams) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InferenceParams", 1))
	}
	if s.ModelIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelIdentifier"))
	}
	if s.ModelIdentifier != nil && len(*s.ModelIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInferenceParams sets the InferenceParams field's value.
func (s *EvaluationBedrockModel) SetInferenceParams(v string) *EvaluationBedrockModel {
	s.InferenceParams = &v
	return s
}

// SetModelIdentifier sets the ModelIdentifier field's value.
func (s *EvaluationBedrockModel) SetModelIdentifier(v string) *EvaluationBedrockModel {
	s.ModelIdentifier = &v
	return s
}

// Used to specify either a AutomatedEvaluationConfig or HumanEvaluationConfig
// object.
type EvaluationConfig struct {
	_ struct{} `type:"structure"`

	// Used to specify an automated model evaluation job. See AutomatedEvaluationConfig
	// to view the required parameters.
	Automated *AutomatedEvaluationConfig `locationName:"automated" type:"structure"`

	// Used to specify a model evaluation job that uses human workers.See HumanEvaluationConfig
	// to view the required parameters.
	Human *HumanEvaluationConfig `locationName:"human" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EvaluationConfig"}
	if s.Automated != nil {
		if err := s.Automated.Validate(); err != nil {
			invalidParams.AddNested("Automated", err.(request.ErrInvalidParams))
		}
	}
	if s.Human != nil {
		if err := s.Human.Validate(); err != nil {
			invalidParams.AddNested("Human", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomated sets the Automated field's value.
func (s *EvaluationConfig) SetAutomated(v *AutomatedEvaluationConfig) *EvaluationConfig {
	s.Automated = v
	return s
}

// SetHuman sets the Human field's value.
func (s *EvaluationConfig) SetHuman(v *HumanEvaluationConfig) *EvaluationConfig {
	s.Human = v
	return s
}

// Used to specify the name of a built-in prompt dataset and optionally, the
// Amazon S3 bucket where a custom prompt dataset is saved.
type EvaluationDataset struct {
	_ struct{} `type:"structure"`

	// For custom prompt datasets, you must specify the location in Amazon S3 where
	// the prompt dataset is saved.
	DatasetLocation *EvaluationDatasetLocation `locationName:"datasetLocation" type:"structure"`

	// Used to specify supported built-in prompt datasets. Valid values are Builtin.Bold,
	// Builtin.BoolQ, Builtin.NaturalQuestions, Builtin.Gigaword, Builtin.RealToxicityPrompts,
	// Builtin.TriviaQa, Builtin.T-Rex, Builtin.WomensEcommerceClothingReviews and
	// Builtin.Wikitext2.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EvaluationDataset's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationDataset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationDataset) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluationDataset) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EvaluationDataset"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.DatasetLocation != nil {
		if err := s.DatasetLocation.Validate(); err != nil {
			invalidParams.AddNested("DatasetLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetLocation sets the DatasetLocation field's value.
func (s *EvaluationDataset) SetDatasetLocation(v *EvaluationDatasetLocation) *EvaluationDataset {
	s.DatasetLocation = v
	return s
}

// SetName sets the Name field's value.
func (s *EvaluationDataset) SetName(v string) *EvaluationDataset {
	s.Name = &v
	return s
}

// The location in Amazon S3 where your prompt dataset is stored.
type EvaluationDatasetLocation struct {
	_ struct{} `type:"structure"`

	// The S3 URI of the S3 bucket specified in the job.
	S3Uri *string `locationName:"s3Uri" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationDatasetLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationDatasetLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluationDatasetLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EvaluationDatasetLocation"}
	if s.S3Uri != nil && len(*s.S3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *EvaluationDatasetLocation) SetS3Uri(v string) *EvaluationDatasetLocation {
	s.S3Uri = &v
	return s
}

// Defines the built-in prompt datasets, built-in metric names and custom metric
// names, and the task type.
type EvaluationDatasetMetricConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the prompt dataset.
	//
	// Dataset is a required field
	Dataset *EvaluationDataset `locationName:"dataset" type:"structure" required:"true"`

	// The names of the metrics used. For automated model evaluation jobs valid
	// values are "Builtin.Accuracy", "Builtin.Robustness", and "Builtin.Toxicity".
	// In human-based model evaluation jobs the array of strings must match the
	// name parameter specified in HumanEvaluationCustomMetric.
	//
	// MetricNames is a required field
	MetricNames []*string `locationName:"metricNames" min:"1" type:"list" required:"true" sensitive:"true"`

	// The task type you want the model to carry out.
	//
	// TaskType is a required field
	TaskType *string `locationName:"taskType" min:"1" type:"string" required:"true" enum:"EvaluationTaskType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationDatasetMetricConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationDatasetMetricConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluationDatasetMetricConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EvaluationDatasetMetricConfig"}
	if s.Dataset == nil {
		invalidParams.Add(request.NewErrParamRequired("Dataset"))
	}
	if s.MetricNames == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricNames"))
	}
	if s.MetricNames != nil && len(s.MetricNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricNames", 1))
	}
	if s.TaskType == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskType"))
	}
	if s.TaskType != nil && len(*s.TaskType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskType", 1))
	}
	if s.Dataset != nil {
		if err := s.Dataset.Validate(); err != nil {
			invalidParams.AddNested("Dataset", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataset sets the Dataset field's value.
func (s *EvaluationDatasetMetricConfig) SetDataset(v *EvaluationDataset) *EvaluationDatasetMetricConfig {
	s.Dataset = v
	return s
}

// SetMetricNames sets the MetricNames field's value.
func (s *EvaluationDatasetMetricConfig) SetMetricNames(v []*string) *EvaluationDatasetMetricConfig {
	s.MetricNames = v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *EvaluationDatasetMetricConfig) SetTaskType(v string) *EvaluationDatasetMetricConfig {
	s.TaskType = &v
	return s
}

// Used to define the models you want used in your model evaluation job. Automated
// model evaluation jobs support only a single model. In a human-based model
// evaluation job, your annotator can compare the responses for up to two different
// models.
type EvaluationInferenceConfig struct {
	_ struct{} `type:"structure"`

	// Used to specify the models.
	Models []*EvaluationModelConfig `locationName:"models" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationInferenceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationInferenceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluationInferenceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EvaluationInferenceConfig"}
	if s.Models != nil && len(s.Models) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Models", 1))
	}
	if s.Models != nil {
		for i, v := range s.Models {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Models", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModels sets the Models field's value.
func (s *EvaluationInferenceConfig) SetModels(v []*EvaluationModelConfig) *EvaluationInferenceConfig {
	s.Models = v
	return s
}

// Defines the models used in the model evaluation job.
type EvaluationModelConfig struct {
	_ struct{} `type:"structure"`

	// Defines the Amazon Bedrock model and inference parameters you want used.
	BedrockModel *EvaluationBedrockModel `locationName:"bedrockModel" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationModelConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationModelConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluationModelConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EvaluationModelConfig"}
	if s.BedrockModel != nil {
		if err := s.BedrockModel.Validate(); err != nil {
			invalidParams.AddNested("BedrockModel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBedrockModel sets the BedrockModel field's value.
func (s *EvaluationModelConfig) SetBedrockModel(v *EvaluationBedrockModel) *EvaluationModelConfig {
	s.BedrockModel = v
	return s
}

// The Amazon S3 location where the results of your model evaluation job are
// saved.
type EvaluationOutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 URI where the results of model evaluation job are saved.
	//
	// S3Uri is a required field
	S3Uri *string `locationName:"s3Uri" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationOutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationOutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluationOutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EvaluationOutputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}
	if s.S3Uri != nil && len(*s.S3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *EvaluationOutputDataConfig) SetS3Uri(v string) *EvaluationOutputDataConfig {
	s.S3Uri = &v
	return s
}

// A summary of the model evaluation job.
type EvaluationSummary struct {
	_ struct{} `type:"structure"`

	// When the model evaluation job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// What task type was used in the model evaluation job.
	//
	// EvaluationTaskTypes is a required field
	EvaluationTaskTypes []*string `locationName:"evaluationTaskTypes" min:"1" type:"list" required:"true" enum:"EvaluationTaskType"`

	// The Amazon Resource Name (ARN) of the model evaluation job.
	//
	// JobArn is a required field
	JobArn *string `locationName:"jobArn" type:"string" required:"true"`

	// The name of the model evaluation job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// The type, either human or automatic, of model evaluation job.
	//
	// JobType is a required field
	JobType *string `locationName:"jobType" type:"string" required:"true" enum:"EvaluationJobType"`

	// The Amazon Resource Names (ARNs) of the model(s) used in the model evaluation
	// job.
	//
	// ModelIdentifiers is a required field
	ModelIdentifiers []*string `locationName:"modelIdentifiers" min:"1" type:"list" required:"true"`

	// The current status of the model evaluation job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"EvaluationJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *EvaluationSummary) SetCreationTime(v time.Time) *EvaluationSummary {
	s.CreationTime = &v
	return s
}

// SetEvaluationTaskTypes sets the EvaluationTaskTypes field's value.
func (s *EvaluationSummary) SetEvaluationTaskTypes(v []*string) *EvaluationSummary {
	s.EvaluationTaskTypes = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *EvaluationSummary) SetJobArn(v string) *EvaluationSummary {
	s.JobArn = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *EvaluationSummary) SetJobName(v string) *EvaluationSummary {
	s.JobName = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *EvaluationSummary) SetJobType(v string) *EvaluationSummary {
	s.JobType = &v
	return s
}

// SetModelIdentifiers sets the ModelIdentifiers field's value.
func (s *EvaluationSummary) SetModelIdentifiers(v []*string) *EvaluationSummary {
	s.ModelIdentifiers = v
	return s
}

// SetStatus sets the Status field's value.
func (s *EvaluationSummary) SetStatus(v string) *EvaluationSummary {
	s.Status = &v
	return s
}

// Information about a foundation model.
type FoundationModelDetails struct {
	_ struct{} `type:"structure"`

	// The customization that the model supports.
	CustomizationsSupported []*string `locationName:"customizationsSupported" type:"list" enum:"ModelCustomization"`

	// The inference types that the model supports.
	InferenceTypesSupported []*string `locationName:"inferenceTypesSupported" type:"list" enum:"InferenceType"`

	// The input modalities that the model supports.
	InputModalities []*string `locationName:"inputModalities" type:"list" enum:"ModelModality"`

	// The model Amazon Resource Name (ARN).
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" type:"string" required:"true"`

	// The model identifier.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" type:"string" required:"true"`

	// Contains details about whether a model version is available or deprecated
	ModelLifecycle *FoundationModelLifecycle `locationName:"modelLifecycle" type:"structure"`

	// The model name.
	ModelName *string `locationName:"modelName" min:"1" type:"string"`

	// The output modalities that the model supports.
	OutputModalities []*string `locationName:"outputModalities" type:"list" enum:"ModelModality"`

	// The model's provider name.
	ProviderName *string `locationName:"providerName" min:"1" type:"string"`

	// Indicates whether the model supports streaming.
	ResponseStreamingSupported *bool `locationName:"responseStreamingSupported" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FoundationModelDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FoundationModelDetails) GoString() string {
	return s.String()
}

// SetCustomizationsSupported sets the CustomizationsSupported field's value.
func (s *FoundationModelDetails) SetCustomizationsSupported(v []*string) *FoundationModelDetails {
	s.CustomizationsSupported = v
	return s
}

// SetInferenceTypesSupported sets the InferenceTypesSupported field's value.
func (s *FoundationModelDetails) SetInferenceTypesSupported(v []*string) *FoundationModelDetails {
	s.InferenceTypesSupported = v
	return s
}

// SetInputModalities sets the InputModalities field's value.
func (s *FoundationModelDetails) SetInputModalities(v []*string) *FoundationModelDetails {
	s.InputModalities = v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *FoundationModelDetails) SetModelArn(v string) *FoundationModelDetails {
	s.ModelArn = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *FoundationModelDetails) SetModelId(v string) *FoundationModelDetails {
	s.ModelId = &v
	return s
}

// SetModelLifecycle sets the ModelLifecycle field's value.
func (s *FoundationModelDetails) SetModelLifecycle(v *FoundationModelLifecycle) *FoundationModelDetails {
	s.ModelLifecycle = v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *FoundationModelDetails) SetModelName(v string) *FoundationModelDetails {
	s.ModelName = &v
	return s
}

// SetOutputModalities sets the OutputModalities field's value.
func (s *FoundationModelDetails) SetOutputModalities(v []*string) *FoundationModelDetails {
	s.OutputModalities = v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *FoundationModelDetails) SetProviderName(v string) *FoundationModelDetails {
	s.ProviderName = &v
	return s
}

// SetResponseStreamingSupported sets the ResponseStreamingSupported field's value.
func (s *FoundationModelDetails) SetResponseStreamingSupported(v bool) *FoundationModelDetails {
	s.ResponseStreamingSupported = &v
	return s
}

// Details about whether a model version is available or deprecated.
type FoundationModelLifecycle struct {
	_ struct{} `type:"structure"`

	// Specifies whether a model version is available (ACTIVE) or deprecated (LEGACY.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FoundationModelLifecycleStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FoundationModelLifecycle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FoundationModelLifecycle) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *FoundationModelLifecycle) SetStatus(v string) *FoundationModelLifecycle {
	s.Status = &v
	return s
}

// Summary information for a foundation model.
type FoundationModelSummary struct {
	_ struct{} `type:"structure"`

	// Whether the model supports fine-tuning or continual pre-training.
	CustomizationsSupported []*string `locationName:"customizationsSupported" type:"list" enum:"ModelCustomization"`

	// The inference types that the model supports.
	InferenceTypesSupported []*string `locationName:"inferenceTypesSupported" type:"list" enum:"InferenceType"`

	// The input modalities that the model supports.
	InputModalities []*string `locationName:"inputModalities" type:"list" enum:"ModelModality"`

	// The Amazon Resource Name (ARN) of the foundation model.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" type:"string" required:"true"`

	// The model ID of the foundation model.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" type:"string" required:"true"`

	// Contains details about whether a model version is available or deprecated.
	ModelLifecycle *FoundationModelLifecycle `locationName:"modelLifecycle" type:"structure"`

	// The name of the model.
	ModelName *string `locationName:"modelName" min:"1" type:"string"`

	// The output modalities that the model supports.
	OutputModalities []*string `locationName:"outputModalities" type:"list" enum:"ModelModality"`

	// The model's provider name.
	ProviderName *string `locationName:"providerName" min:"1" type:"string"`

	// Indicates whether the model supports streaming.
	ResponseStreamingSupported *bool `locationName:"responseStreamingSupported" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FoundationModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FoundationModelSummary) GoString() string {
	return s.String()
}

// SetCustomizationsSupported sets the CustomizationsSupported field's value.
func (s *FoundationModelSummary) SetCustomizationsSupported(v []*string) *FoundationModelSummary {
	s.CustomizationsSupported = v
	return s
}

// SetInferenceTypesSupported sets the InferenceTypesSupported field's value.
func (s *FoundationModelSummary) SetInferenceTypesSupported(v []*string) *FoundationModelSummary {
	s.InferenceTypesSupported = v
	return s
}

// SetInputModalities sets the InputModalities field's value.
func (s *FoundationModelSummary) SetInputModalities(v []*string) *FoundationModelSummary {
	s.InputModalities = v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *FoundationModelSummary) SetModelArn(v string) *FoundationModelSummary {
	s.ModelArn = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *FoundationModelSummary) SetModelId(v string) *FoundationModelSummary {
	s.ModelId = &v
	return s
}

// SetModelLifecycle sets the ModelLifecycle field's value.
func (s *FoundationModelSummary) SetModelLifecycle(v *FoundationModelLifecycle) *FoundationModelSummary {
	s.ModelLifecycle = v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *FoundationModelSummary) SetModelName(v string) *FoundationModelSummary {
	s.ModelName = &v
	return s
}

// SetOutputModalities sets the OutputModalities field's value.
func (s *FoundationModelSummary) SetOutputModalities(v []*string) *FoundationModelSummary {
	s.OutputModalities = v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *FoundationModelSummary) SetProviderName(v string) *FoundationModelSummary {
	s.ProviderName = &v
	return s
}

// SetResponseStreamingSupported sets the ResponseStreamingSupported field's value.
func (s *FoundationModelSummary) SetResponseStreamingSupported(v bool) *FoundationModelSummary {
	s.ResponseStreamingSupported = &v
	return s
}

type GetCustomModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Name or Amazon Resource Name (ARN) of the custom model.
	//
	// ModelIdentifier is a required field
	ModelIdentifier *string `location:"uri" locationName:"modelIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCustomModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCustomModelInput"}
	if s.ModelIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelIdentifier"))
	}
	if s.ModelIdentifier != nil && len(*s.ModelIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelIdentifier sets the ModelIdentifier field's value.
func (s *GetCustomModelInput) SetModelIdentifier(v string) *GetCustomModelInput {
	s.ModelIdentifier = &v
	return s
}

type GetCustomModelOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the base model.
	//
	// BaseModelArn is a required field
	BaseModelArn *string `locationName:"baseModelArn" min:"20" type:"string" required:"true"`

	// Creation time of the model.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The type of model customization.
	CustomizationType *string `locationName:"customizationType" type:"string" enum:"CustomizationType"`

	// Hyperparameter values associated with this model. For details on the format
	// for different models, see Custom model hyperparameters (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html).
	HyperParameters map[string]*string `locationName:"hyperParameters" type:"map"`

	// Job Amazon Resource Name (ARN) associated with this model.
	//
	// JobArn is a required field
	JobArn *string `locationName:"jobArn" type:"string" required:"true"`

	// Job name associated with this model.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// Amazon Resource Name (ARN) associated with this model.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" min:"20" type:"string" required:"true"`

	// The custom model is encrypted at rest using this key.
	ModelKmsKeyArn *string `locationName:"modelKmsKeyArn" min:"1" type:"string"`

	// Model name associated with this model.
	//
	// ModelName is a required field
	ModelName *string `locationName:"modelName" min:"1" type:"string" required:"true"`

	// Output data configuration associated with this custom model.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `locationName:"outputDataConfig" type:"structure" required:"true"`

	// Contains information about the training dataset.
	//
	// TrainingDataConfig is a required field
	TrainingDataConfig *TrainingDataConfig `locationName:"trainingDataConfig" type:"structure" required:"true"`

	// Contains training metrics from the job creation.
	TrainingMetrics *TrainingMetrics `locationName:"trainingMetrics" type:"structure"`

	// Contains information about the validation dataset.
	ValidationDataConfig *ValidationDataConfig `locationName:"validationDataConfig" type:"structure"`

	// The validation metrics from the job creation.
	ValidationMetrics []*ValidatorMetric `locationName:"validationMetrics" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomModelOutput) GoString() string {
	return s.String()
}

// SetBaseModelArn sets the BaseModelArn field's value.
func (s *GetCustomModelOutput) SetBaseModelArn(v string) *GetCustomModelOutput {
	s.BaseModelArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetCustomModelOutput) SetCreationTime(v time.Time) *GetCustomModelOutput {
	s.CreationTime = &v
	return s
}

// SetCustomizationType sets the CustomizationType field's value.
func (s *GetCustomModelOutput) SetCustomizationType(v string) *GetCustomModelOutput {
	s.CustomizationType = &v
	return s
}

// SetHyperParameters sets the HyperParameters field's value.
func (s *GetCustomModelOutput) SetHyperParameters(v map[string]*string) *GetCustomModelOutput {
	s.HyperParameters = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *GetCustomModelOutput) SetJobArn(v string) *GetCustomModelOutput {
	s.JobArn = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *GetCustomModelOutput) SetJobName(v string) *GetCustomModelOutput {
	s.JobName = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *GetCustomModelOutput) SetModelArn(v string) *GetCustomModelOutput {
	s.ModelArn = &v
	return s
}

// SetModelKmsKeyArn sets the ModelKmsKeyArn field's value.
func (s *GetCustomModelOutput) SetModelKmsKeyArn(v string) *GetCustomModelOutput {
	s.ModelKmsKeyArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *GetCustomModelOutput) SetModelName(v string) *GetCustomModelOutput {
	s.ModelName = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *GetCustomModelOutput) SetOutputDataConfig(v *OutputDataConfig) *GetCustomModelOutput {
	s.OutputDataConfig = v
	return s
}

// SetTrainingDataConfig sets the TrainingDataConfig field's value.
func (s *GetCustomModelOutput) SetTrainingDataConfig(v *TrainingDataConfig) *GetCustomModelOutput {
	s.TrainingDataConfig = v
	return s
}

// SetTrainingMetrics sets the TrainingMetrics field's value.
func (s *GetCustomModelOutput) SetTrainingMetrics(v *TrainingMetrics) *GetCustomModelOutput {
	s.TrainingMetrics = v
	return s
}

// SetValidationDataConfig sets the ValidationDataConfig field's value.
func (s *GetCustomModelOutput) SetValidationDataConfig(v *ValidationDataConfig) *GetCustomModelOutput {
	s.ValidationDataConfig = v
	return s
}

// SetValidationMetrics sets the ValidationMetrics field's value.
func (s *GetCustomModelOutput) SetValidationMetrics(v []*ValidatorMetric) *GetCustomModelOutput {
	s.ValidationMetrics = v
	return s
}

type GetEvaluationJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the model evaluation job.
	//
	// JobIdentifier is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetEvaluationJobInput's
	// String and GoString methods.
	//
	// JobIdentifier is a required field
	JobIdentifier *string `location:"uri" locationName:"jobIdentifier" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEvaluationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEvaluationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEvaluationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEvaluationJobInput"}
	if s.JobIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("JobIdentifier"))
	}
	if s.JobIdentifier != nil && len(*s.JobIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobIdentifier sets the JobIdentifier field's value.
func (s *GetEvaluationJobInput) SetJobIdentifier(v string) *GetEvaluationJobInput {
	s.JobIdentifier = &v
	return s
}

type GetEvaluationJobOutput struct {
	_ struct{} `type:"structure"`

	// When the model evaluation job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the customer managed key specified when
	// the model evaluation job was created.
	CustomerEncryptionKeyId *string `locationName:"customerEncryptionKeyId" min:"1" type:"string"`

	// Contains details about the type of model evaluation job, the metrics used,
	// the task type selected, the datasets used, and any custom metrics you defined.
	//
	// EvaluationConfig is a required field
	EvaluationConfig *EvaluationConfig `locationName:"evaluationConfig" type:"structure" required:"true"`

	// An array of strings the specify why the model evaluation job has failed.
	FailureMessages []*string `locationName:"failureMessages" type:"list"`

	// Details about the models you specified in your model evaluation job.
	//
	// InferenceConfig is a required field
	InferenceConfig *EvaluationInferenceConfig `locationName:"inferenceConfig" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the model evaluation job.
	//
	// JobArn is a required field
	JobArn *string `locationName:"jobArn" type:"string" required:"true"`

	// The description of the model evaluation job.
	//
	// JobDescription is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetEvaluationJobOutput's
	// String and GoString methods.
	JobDescription *string `locationName:"jobDescription" min:"1" type:"string" sensitive:"true"`

	// The name of the model evaluation job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// The type of model evaluation job.
	//
	// JobType is a required field
	JobType *string `locationName:"jobType" type:"string" required:"true" enum:"EvaluationJobType"`

	// When the model evaluation job was last modified.
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp" timestampFormat:"iso8601"`

	// Amazon S3 location for where output data is saved.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *EvaluationOutputDataConfig `locationName:"outputDataConfig" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM service role used in the model
	// evaluation job.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The status of the model evaluation job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"EvaluationJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEvaluationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEvaluationJobOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetEvaluationJobOutput) SetCreationTime(v time.Time) *GetEvaluationJobOutput {
	s.CreationTime = &v
	return s
}

// SetCustomerEncryptionKeyId sets the CustomerEncryptionKeyId field's value.
func (s *GetEvaluationJobOutput) SetCustomerEncryptionKeyId(v string) *GetEvaluationJobOutput {
	s.CustomerEncryptionKeyId = &v
	return s
}

// SetEvaluationConfig sets the EvaluationConfig field's value.
func (s *GetEvaluationJobOutput) SetEvaluationConfig(v *EvaluationConfig) *GetEvaluationJobOutput {
	s.EvaluationConfig = v
	return s
}

// SetFailureMessages sets the FailureMessages field's value.
func (s *GetEvaluationJobOutput) SetFailureMessages(v []*string) *GetEvaluationJobOutput {
	s.FailureMessages = v
	return s
}

// SetInferenceConfig sets the InferenceConfig field's value.
func (s *GetEvaluationJobOutput) SetInferenceConfig(v *EvaluationInferenceConfig) *GetEvaluationJobOutput {
	s.InferenceConfig = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *GetEvaluationJobOutput) SetJobArn(v string) *GetEvaluationJobOutput {
	s.JobArn = &v
	return s
}

// SetJobDescription sets the JobDescription field's value.
func (s *GetEvaluationJobOutput) SetJobDescription(v string) *GetEvaluationJobOutput {
	s.JobDescription = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *GetEvaluationJobOutput) SetJobName(v string) *GetEvaluationJobOutput {
	s.JobName = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *GetEvaluationJobOutput) SetJobType(v string) *GetEvaluationJobOutput {
	s.JobType = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetEvaluationJobOutput) SetLastModifiedTime(v time.Time) *GetEvaluationJobOutput {
	s.LastModifiedTime = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *GetEvaluationJobOutput) SetOutputDataConfig(v *EvaluationOutputDataConfig) *GetEvaluationJobOutput {
	s.OutputDataConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetEvaluationJobOutput) SetRoleArn(v string) *GetEvaluationJobOutput {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetEvaluationJobOutput) SetStatus(v string) *GetEvaluationJobOutput {
	s.Status = &v
	return s
}

type GetFoundationModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The model identifier.
	//
	// ModelIdentifier is a required field
	ModelIdentifier *string `location:"uri" locationName:"modelIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFoundationModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFoundationModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFoundationModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFoundationModelInput"}
	if s.ModelIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelIdentifier"))
	}
	if s.ModelIdentifier != nil && len(*s.ModelIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelIdentifier sets the ModelIdentifier field's value.
func (s *GetFoundationModelInput) SetModelIdentifier(v string) *GetFoundationModelInput {
	s.ModelIdentifier = &v
	return s
}

type GetFoundationModelOutput struct {
	_ struct{} `type:"structure"`

	// Information about the foundation model.
	ModelDetails *FoundationModelDetails `locationName:"modelDetails" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFoundationModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFoundationModelOutput) GoString() string {
	return s.String()
}

// SetModelDetails sets the ModelDetails field's value.
func (s *GetFoundationModelOutput) SetModelDetails(v *FoundationModelDetails) *GetFoundationModelOutput {
	s.ModelDetails = v
	return s
}

type GetGuardrailInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the guardrail for which to get details. This can
	// be an ID or the ARN.
	//
	// GuardrailIdentifier is a required field
	GuardrailIdentifier *string `location:"uri" locationName:"guardrailIdentifier" type:"string" required:"true"`

	// The version of the guardrail for which to get details. If you don't specify
	// a version, the response returns details for the DRAFT version.
	GuardrailVersion *string `location:"querystring" locationName:"guardrailVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGuardrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGuardrailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGuardrailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGuardrailInput"}
	if s.GuardrailIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GuardrailIdentifier"))
	}
	if s.GuardrailIdentifier != nil && len(*s.GuardrailIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GuardrailIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGuardrailIdentifier sets the GuardrailIdentifier field's value.
func (s *GetGuardrailInput) SetGuardrailIdentifier(v string) *GetGuardrailInput {
	s.GuardrailIdentifier = &v
	return s
}

// SetGuardrailVersion sets the GuardrailVersion field's value.
func (s *GetGuardrailInput) SetGuardrailVersion(v string) *GetGuardrailInput {
	s.GuardrailVersion = &v
	return s
}

type GetGuardrailOutput struct {
	_ struct{} `type:"structure"`

	// The message that the guardrail returns when it blocks a prompt.
	//
	// BlockedInputMessaging is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetGuardrailOutput's
	// String and GoString methods.
	//
	// BlockedInputMessaging is a required field
	BlockedInputMessaging *string `locationName:"blockedInputMessaging" min:"1" type:"string" required:"true" sensitive:"true"`

	// The message that the guardrail returns when it blocks a model response.
	//
	// BlockedOutputsMessaging is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetGuardrailOutput's
	// String and GoString methods.
	//
	// BlockedOutputsMessaging is a required field
	BlockedOutputsMessaging *string `locationName:"blockedOutputsMessaging" min:"1" type:"string" required:"true" sensitive:"true"`

	// The content policy that was configured for the guardrail.
	ContentPolicy *GuardrailContentPolicy `locationName:"contentPolicy" type:"structure"`

	// The contextual grounding policy used in the guardrail.
	ContextualGroundingPolicy *GuardrailContextualGroundingPolicy `locationName:"contextualGroundingPolicy" type:"structure"`

	// The date and time at which the guardrail was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the guardrail.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetGuardrailOutput's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// Appears if the status of the guardrail is FAILED. A list of recommendations
	// to carry out before retrying the request.
	FailureRecommendations []*string `locationName:"failureRecommendations" type:"list" sensitive:"true"`

	// The ARN of the guardrail.
	//
	// GuardrailArn is a required field
	GuardrailArn *string `locationName:"guardrailArn" type:"string" required:"true"`

	// The unique identifier of the guardrail.
	//
	// GuardrailId is a required field
	GuardrailId *string `locationName:"guardrailId" type:"string" required:"true"`

	// The ARN of the KMS key that encrypts the guardrail.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"1" type:"string"`

	// The name of the guardrail.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetGuardrailOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The sensitive information policy that was configured for the guardrail.
	SensitiveInformationPolicy *GuardrailSensitiveInformationPolicy `locationName:"sensitiveInformationPolicy" type:"structure"`

	// The status of the guardrail.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"GuardrailStatus"`

	// Appears if the status is FAILED. A list of reasons for why the guardrail
	// failed to be created, updated, versioned, or deleted.
	StatusReasons []*string `locationName:"statusReasons" type:"list" sensitive:"true"`

	// The topic policy that was configured for the guardrail.
	TopicPolicy *GuardrailTopicPolicy `locationName:"topicPolicy" type:"structure"`

	// The date and time at which the guardrail was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The version of the guardrail.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`

	// The word policy that was configured for the guardrail.
	WordPolicy *GuardrailWordPolicy `locationName:"wordPolicy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGuardrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGuardrailOutput) GoString() string {
	return s.String()
}

// SetBlockedInputMessaging sets the BlockedInputMessaging field's value.
func (s *GetGuardrailOutput) SetBlockedInputMessaging(v string) *GetGuardrailOutput {
	s.BlockedInputMessaging = &v
	return s
}

// SetBlockedOutputsMessaging sets the BlockedOutputsMessaging field's value.
func (s *GetGuardrailOutput) SetBlockedOutputsMessaging(v string) *GetGuardrailOutput {
	s.BlockedOutputsMessaging = &v
	return s
}

// SetContentPolicy sets the ContentPolicy field's value.
func (s *GetGuardrailOutput) SetContentPolicy(v *GuardrailContentPolicy) *GetGuardrailOutput {
	s.ContentPolicy = v
	return s
}

// SetContextualGroundingPolicy sets the ContextualGroundingPolicy field's value.
func (s *GetGuardrailOutput) SetContextualGroundingPolicy(v *GuardrailContextualGroundingPolicy) *GetGuardrailOutput {
	s.ContextualGroundingPolicy = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetGuardrailOutput) SetCreatedAt(v time.Time) *GetGuardrailOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetGuardrailOutput) SetDescription(v string) *GetGuardrailOutput {
	s.Description = &v
	return s
}

// SetFailureRecommendations sets the FailureRecommendations field's value.
func (s *GetGuardrailOutput) SetFailureRecommendations(v []*string) *GetGuardrailOutput {
	s.FailureRecommendations = v
	return s
}

// SetGuardrailArn sets the GuardrailArn field's value.
func (s *GetGuardrailOutput) SetGuardrailArn(v string) *GetGuardrailOutput {
	s.GuardrailArn = &v
	return s
}

// SetGuardrailId sets the GuardrailId field's value.
func (s *GetGuardrailOutput) SetGuardrailId(v string) *GetGuardrailOutput {
	s.GuardrailId = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *GetGuardrailOutput) SetKmsKeyArn(v string) *GetGuardrailOutput {
	s.KmsKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetGuardrailOutput) SetName(v string) *GetGuardrailOutput {
	s.Name = &v
	return s
}

// SetSensitiveInformationPolicy sets the SensitiveInformationPolicy field's value.
func (s *GetGuardrailOutput) SetSensitiveInformationPolicy(v *GuardrailSensitiveInformationPolicy) *GetGuardrailOutput {
	s.SensitiveInformationPolicy = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetGuardrailOutput) SetStatus(v string) *GetGuardrailOutput {
	s.Status = &v
	return s
}

// SetStatusReasons sets the StatusReasons field's value.
func (s *GetGuardrailOutput) SetStatusReasons(v []*string) *GetGuardrailOutput {
	s.StatusReasons = v
	return s
}

// SetTopicPolicy sets the TopicPolicy field's value.
func (s *GetGuardrailOutput) SetTopicPolicy(v *GuardrailTopicPolicy) *GetGuardrailOutput {
	s.TopicPolicy = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetGuardrailOutput) SetUpdatedAt(v time.Time) *GetGuardrailOutput {
	s.UpdatedAt = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetGuardrailOutput) SetVersion(v string) *GetGuardrailOutput {
	s.Version = &v
	return s
}

// SetWordPolicy sets the WordPolicy field's value.
func (s *GetGuardrailOutput) SetWordPolicy(v *GuardrailWordPolicy) *GetGuardrailOutput {
	s.WordPolicy = v
	return s
}

type GetModelCustomizationJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier for the customization job.
	//
	// JobIdentifier is a required field
	JobIdentifier *string `location:"uri" locationName:"jobIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelCustomizationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelCustomizationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelCustomizationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelCustomizationJobInput"}
	if s.JobIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("JobIdentifier"))
	}
	if s.JobIdentifier != nil && len(*s.JobIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobIdentifier sets the JobIdentifier field's value.
func (s *GetModelCustomizationJobInput) SetJobIdentifier(v string) *GetModelCustomizationJobInput {
	s.JobIdentifier = &v
	return s
}

type GetModelCustomizationJobOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the base model.
	//
	// BaseModelArn is a required field
	BaseModelArn *string `locationName:"baseModelArn" type:"string" required:"true"`

	// The token that you specified in the CreateCustomizationJob request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// Time that the resource was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The type of model customization.
	CustomizationType *string `locationName:"customizationType" type:"string" enum:"CustomizationType"`

	// Time that the resource transitioned to terminal state.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// Information about why the job failed.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The hyperparameter values for the job. For details on the format for different
	// models, see Custom model hyperparameters (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html).
	//
	// HyperParameters is a required field
	HyperParameters map[string]*string `locationName:"hyperParameters" type:"map" required:"true"`

	// The Amazon Resource Name (ARN) of the customization job.
	//
	// JobArn is a required field
	JobArn *string `locationName:"jobArn" type:"string" required:"true"`

	// The name of the customization job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// Time that the resource was last modified.
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp" timestampFormat:"iso8601"`

	// Output data configuration
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `locationName:"outputDataConfig" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the output model.
	OutputModelArn *string `locationName:"outputModelArn" min:"20" type:"string"`

	// The custom model is encrypted at rest using this key.
	OutputModelKmsKeyArn *string `locationName:"outputModelKmsKeyArn" min:"1" type:"string"`

	// The name of the output model.
	//
	// OutputModelName is a required field
	OutputModelName *string `locationName:"outputModelName" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The status of the job. A successful job transitions from in-progress to completed
	// when the output model is ready to use. If the job failed, the failure message
	// contains information about why the job failed.
	Status *string `locationName:"status" type:"string" enum:"ModelCustomizationJobStatus"`

	// Contains information about the training dataset.
	//
	// TrainingDataConfig is a required field
	TrainingDataConfig *TrainingDataConfig `locationName:"trainingDataConfig" type:"structure" required:"true"`

	// Contains training metrics from the job creation.
	TrainingMetrics *TrainingMetrics `locationName:"trainingMetrics" type:"structure"`

	// Contains information about the validation dataset.
	//
	// ValidationDataConfig is a required field
	ValidationDataConfig *ValidationDataConfig `locationName:"validationDataConfig" type:"structure" required:"true"`

	// The loss metric for each validator that you provided in the createjob request.
	ValidationMetrics []*ValidatorMetric `locationName:"validationMetrics" type:"list"`

	// VPC configuration for the custom model job.
	VpcConfig *VpcConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelCustomizationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelCustomizationJobOutput) GoString() string {
	return s.String()
}

// SetBaseModelArn sets the BaseModelArn field's value.
func (s *GetModelCustomizationJobOutput) SetBaseModelArn(v string) *GetModelCustomizationJobOutput {
	s.BaseModelArn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *GetModelCustomizationJobOutput) SetClientRequestToken(v string) *GetModelCustomizationJobOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetModelCustomizationJobOutput) SetCreationTime(v time.Time) *GetModelCustomizationJobOutput {
	s.CreationTime = &v
	return s
}

// SetCustomizationType sets the CustomizationType field's value.
func (s *GetModelCustomizationJobOutput) SetCustomizationType(v string) *GetModelCustomizationJobOutput {
	s.CustomizationType = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetModelCustomizationJobOutput) SetEndTime(v time.Time) *GetModelCustomizationJobOutput {
	s.EndTime = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *GetModelCustomizationJobOutput) SetFailureMessage(v string) *GetModelCustomizationJobOutput {
	s.FailureMessage = &v
	return s
}

// SetHyperParameters sets the HyperParameters field's value.
func (s *GetModelCustomizationJobOutput) SetHyperParameters(v map[string]*string) *GetModelCustomizationJobOutput {
	s.HyperParameters = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *GetModelCustomizationJobOutput) SetJobArn(v string) *GetModelCustomizationJobOutput {
	s.JobArn = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *GetModelCustomizationJobOutput) SetJobName(v string) *GetModelCustomizationJobOutput {
	s.JobName = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetModelCustomizationJobOutput) SetLastModifiedTime(v time.Time) *GetModelCustomizationJobOutput {
	s.LastModifiedTime = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *GetModelCustomizationJobOutput) SetOutputDataConfig(v *OutputDataConfig) *GetModelCustomizationJobOutput {
	s.OutputDataConfig = v
	return s
}

// SetOutputModelArn sets the OutputModelArn field's value.
func (s *GetModelCustomizationJobOutput) SetOutputModelArn(v string) *GetModelCustomizationJobOutput {
	s.OutputModelArn = &v
	return s
}

// SetOutputModelKmsKeyArn sets the OutputModelKmsKeyArn field's value.
func (s *GetModelCustomizationJobOutput) SetOutputModelKmsKeyArn(v string) *GetModelCustomizationJobOutput {
	s.OutputModelKmsKeyArn = &v
	return s
}

// SetOutputModelName sets the OutputModelName field's value.
func (s *GetModelCustomizationJobOutput) SetOutputModelName(v string) *GetModelCustomizationJobOutput {
	s.OutputModelName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetModelCustomizationJobOutput) SetRoleArn(v string) *GetModelCustomizationJobOutput {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetModelCustomizationJobOutput) SetStatus(v string) *GetModelCustomizationJobOutput {
	s.Status = &v
	return s
}

// SetTrainingDataConfig sets the TrainingDataConfig field's value.
func (s *GetModelCustomizationJobOutput) SetTrainingDataConfig(v *TrainingDataConfig) *GetModelCustomizationJobOutput {
	s.TrainingDataConfig = v
	return s
}

// SetTrainingMetrics sets the TrainingMetrics field's value.
func (s *GetModelCustomizationJobOutput) SetTrainingMetrics(v *TrainingMetrics) *GetModelCustomizationJobOutput {
	s.TrainingMetrics = v
	return s
}

// SetValidationDataConfig sets the ValidationDataConfig field's value.
func (s *GetModelCustomizationJobOutput) SetValidationDataConfig(v *ValidationDataConfig) *GetModelCustomizationJobOutput {
	s.ValidationDataConfig = v
	return s
}

// SetValidationMetrics sets the ValidationMetrics field's value.
func (s *GetModelCustomizationJobOutput) SetValidationMetrics(v []*ValidatorMetric) *GetModelCustomizationJobOutput {
	s.ValidationMetrics = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *GetModelCustomizationJobOutput) SetVpcConfig(v *VpcConfig) *GetModelCustomizationJobOutput {
	s.VpcConfig = v
	return s
}

type GetModelInvocationLoggingConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelInvocationLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelInvocationLoggingConfigurationInput) GoString() string {
	return s.String()
}

type GetModelInvocationLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The current configuration values.
	LoggingConfig *LoggingConfig `locationName:"loggingConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelInvocationLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelInvocationLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetLoggingConfig sets the LoggingConfig field's value.
func (s *GetModelInvocationLoggingConfigurationOutput) SetLoggingConfig(v *LoggingConfig) *GetModelInvocationLoggingConfigurationOutput {
	s.LoggingConfig = v
	return s
}

type GetProvisionedModelThroughputInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) or name of the Provisioned Throughput.
	//
	// ProvisionedModelId is a required field
	ProvisionedModelId *string `location:"uri" locationName:"provisionedModelId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProvisionedModelThroughputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProvisionedModelThroughputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProvisionedModelThroughputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProvisionedModelThroughputInput"}
	if s.ProvisionedModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedModelId"))
	}
	if s.ProvisionedModelId != nil && len(*s.ProvisionedModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProvisionedModelId sets the ProvisionedModelId field's value.
func (s *GetProvisionedModelThroughputInput) SetProvisionedModelId(v string) *GetProvisionedModelThroughputInput {
	s.ProvisionedModelId = &v
	return s
}

type GetProvisionedModelThroughputOutput struct {
	_ struct{} `type:"structure"`

	// Commitment duration of the Provisioned Throughput.
	CommitmentDuration *string `locationName:"commitmentDuration" type:"string" enum:"CommitmentDuration"`

	// The timestamp for when the commitment term for the Provisioned Throughput
	// expires.
	CommitmentExpirationTime *time.Time `locationName:"commitmentExpirationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The timestamp of the creation time for this Provisioned Throughput.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the model requested to be associated to
	// this Provisioned Throughput. This value differs from the modelArn if updating
	// hasn't completed.
	//
	// DesiredModelArn is a required field
	DesiredModelArn *string `locationName:"desiredModelArn" min:"20" type:"string" required:"true"`

	// The number of model units that was requested for this Provisioned Throughput.
	//
	// DesiredModelUnits is a required field
	DesiredModelUnits *int64 `locationName:"desiredModelUnits" min:"1" type:"integer" required:"true"`

	// A failure message for any issues that occurred during creation, updating,
	// or deletion of the Provisioned Throughput.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The Amazon Resource Name (ARN) of the base model for which the Provisioned
	// Throughput was created, or of the base model that the custom model for which
	// the Provisioned Throughput was created was customized.
	//
	// FoundationModelArn is a required field
	FoundationModelArn *string `locationName:"foundationModelArn" type:"string" required:"true"`

	// The timestamp of the last time that this Provisioned Throughput was modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the model associated with this Provisioned
	// Throughput.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" min:"20" type:"string" required:"true"`

	// The number of model units allocated to this Provisioned Throughput.
	//
	// ModelUnits is a required field
	ModelUnits *int64 `locationName:"modelUnits" min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the Provisioned Throughput.
	//
	// ProvisionedModelArn is a required field
	ProvisionedModelArn *string `locationName:"provisionedModelArn" type:"string" required:"true"`

	// The name of the Provisioned Throughput.
	//
	// ProvisionedModelName is a required field
	ProvisionedModelName *string `locationName:"provisionedModelName" min:"1" type:"string" required:"true"`

	// The status of the Provisioned Throughput.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ProvisionedModelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProvisionedModelThroughputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProvisionedModelThroughputOutput) GoString() string {
	return s.String()
}

// SetCommitmentDuration sets the CommitmentDuration field's value.
func (s *GetProvisionedModelThroughputOutput) SetCommitmentDuration(v string) *GetProvisionedModelThroughputOutput {
	s.CommitmentDuration = &v
	return s
}

// SetCommitmentExpirationTime sets the CommitmentExpirationTime field's value.
func (s *GetProvisionedModelThroughputOutput) SetCommitmentExpirationTime(v time.Time) *GetProvisionedModelThroughputOutput {
	s.CommitmentExpirationTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetProvisionedModelThroughputOutput) SetCreationTime(v time.Time) *GetProvisionedModelThroughputOutput {
	s.CreationTime = &v
	return s
}

// SetDesiredModelArn sets the DesiredModelArn field's value.
func (s *GetProvisionedModelThroughputOutput) SetDesiredModelArn(v string) *GetProvisionedModelThroughputOutput {
	s.DesiredModelArn = &v
	return s
}

// SetDesiredModelUnits sets the DesiredModelUnits field's value.
func (s *GetProvisionedModelThroughputOutput) SetDesiredModelUnits(v int64) *GetProvisionedModelThroughputOutput {
	s.DesiredModelUnits = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *GetProvisionedModelThroughputOutput) SetFailureMessage(v string) *GetProvisionedModelThroughputOutput {
	s.FailureMessage = &v
	return s
}

// SetFoundationModelArn sets the FoundationModelArn field's value.
func (s *GetProvisionedModelThroughputOutput) SetFoundationModelArn(v string) *GetProvisionedModelThroughputOutput {
	s.FoundationModelArn = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetProvisionedModelThroughputOutput) SetLastModifiedTime(v time.Time) *GetProvisionedModelThroughputOutput {
	s.LastModifiedTime = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *GetProvisionedModelThroughputOutput) SetModelArn(v string) *GetProvisionedModelThroughputOutput {
	s.ModelArn = &v
	return s
}

// SetModelUnits sets the ModelUnits field's value.
func (s *GetProvisionedModelThroughputOutput) SetModelUnits(v int64) *GetProvisionedModelThroughputOutput {
	s.ModelUnits = &v
	return s
}

// SetProvisionedModelArn sets the ProvisionedModelArn field's value.
func (s *GetProvisionedModelThroughputOutput) SetProvisionedModelArn(v string) *GetProvisionedModelThroughputOutput {
	s.ProvisionedModelArn = &v
	return s
}

// SetProvisionedModelName sets the ProvisionedModelName field's value.
func (s *GetProvisionedModelThroughputOutput) SetProvisionedModelName(v string) *GetProvisionedModelThroughputOutput {
	s.ProvisionedModelName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetProvisionedModelThroughputOutput) SetStatus(v string) *GetProvisionedModelThroughputOutput {
	s.Status = &v
	return s
}

// Contains filter strengths for harmful content. Guardrails support the following
// content filters to detect and filter harmful user inputs and FM-generated
// outputs.
//
//   - Hate – Describes language or a statement that discriminates, criticizes,
//     insults, denounces, or dehumanizes a person or group on the basis of an
//     identity (such as race, ethnicity, gender, religion, sexual orientation,
//     ability, and national origin).
//
//   - Insults – Describes language or a statement that includes demeaning,
//     humiliating, mocking, insulting, or belittling language. This type of
//     language is also labeled as bullying.
//
//   - Sexual – Describes language or a statement that indicates sexual interest,
//     activity, or arousal using direct or indirect references to body parts,
//     physical traits, or sex.
//
//   - Violence – Describes language or a statement that includes glorification
//     of or threats to inflict physical pain, hurt, or injury toward a person,
//     group or thing.
//
// Content filtering depends on the confidence classification of user inputs
// and FM responses across each of the four harmful categories. All input and
// output statements are classified into one of four confidence levels (NONE,
// LOW, MEDIUM, HIGH) for each harmful category. For example, if a statement
// is classified as Hate with HIGH confidence, the likelihood of the statement
// representing hateful content is high. A single statement can be classified
// across multiple categories with varying confidence levels. For example, a
// single statement can be classified as Hate with HIGH confidence, Insults
// with LOW confidence, Sexual with NONE confidence, and Violence with MEDIUM
// confidence.
//
// For more information, see Guardrails content filters (https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-filters.html).
//
// This data type is used in the following API operations:
//
//   - GetGuardrail response body (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax)
type GuardrailContentFilter struct {
	_ struct{} `type:"structure"`

	// The strength of the content filter to apply to prompts. As you increase the
	// filter strength, the likelihood of filtering harmful content increases and
	// the probability of seeing harmful content in your application reduces.
	//
	// InputStrength is a required field
	InputStrength *string `locationName:"inputStrength" type:"string" required:"true" enum:"GuardrailFilterStrength"`

	// The strength of the content filter to apply to model responses. As you increase
	// the filter strength, the likelihood of filtering harmful content increases
	// and the probability of seeing harmful content in your application reduces.
	//
	// OutputStrength is a required field
	OutputStrength *string `locationName:"outputStrength" type:"string" required:"true" enum:"GuardrailFilterStrength"`

	// The harmful category that the content filter is applied to.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"GuardrailContentFilterType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContentFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContentFilter) GoString() string {
	return s.String()
}

// SetInputStrength sets the InputStrength field's value.
func (s *GuardrailContentFilter) SetInputStrength(v string) *GuardrailContentFilter {
	s.InputStrength = &v
	return s
}

// SetOutputStrength sets the OutputStrength field's value.
func (s *GuardrailContentFilter) SetOutputStrength(v string) *GuardrailContentFilter {
	s.OutputStrength = &v
	return s
}

// SetType sets the Type field's value.
func (s *GuardrailContentFilter) SetType(v string) *GuardrailContentFilter {
	s.Type = &v
	return s
}

// Contains filter strengths for harmful content. Guardrails support the following
// content filters to detect and filter harmful user inputs and FM-generated
// outputs.
//
//   - Hate – Describes language or a statement that discriminates, criticizes,
//     insults, denounces, or dehumanizes a person or group on the basis of an
//     identity (such as race, ethnicity, gender, religion, sexual orientation,
//     ability, and national origin).
//
//   - Insults – Describes language or a statement that includes demeaning,
//     humiliating, mocking, insulting, or belittling language. This type of
//     language is also labeled as bullying.
//
//   - Sexual – Describes language or a statement that indicates sexual interest,
//     activity, or arousal using direct or indirect references to body parts,
//     physical traits, or sex.
//
//   - Violence – Describes language or a statement that includes glorification
//     of or threats to inflict physical pain, hurt, or injury toward a person,
//     group or thing.
//
// Content filtering depends on the confidence classification of user inputs
// and FM responses across each of the four harmful categories. All input and
// output statements are classified into one of four confidence levels (NONE,
// LOW, MEDIUM, HIGH) for each harmful category. For example, if a statement
// is classified as Hate with HIGH confidence, the likelihood of the statement
// representing hateful content is high. A single statement can be classified
// across multiple categories with varying confidence levels. For example, a
// single statement can be classified as Hate with HIGH confidence, Insults
// with LOW confidence, Sexual with NONE confidence, and Violence with MEDIUM
// confidence.
//
// For more information, see Guardrails content filters (https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-filters.html).
type GuardrailContentFilterConfig struct {
	_ struct{} `type:"structure"`

	// The strength of the content filter to apply to prompts. As you increase the
	// filter strength, the likelihood of filtering harmful content increases and
	// the probability of seeing harmful content in your application reduces.
	//
	// InputStrength is a required field
	InputStrength *string `locationName:"inputStrength" type:"string" required:"true" enum:"GuardrailFilterStrength"`

	// The strength of the content filter to apply to model responses. As you increase
	// the filter strength, the likelihood of filtering harmful content increases
	// and the probability of seeing harmful content in your application reduces.
	//
	// OutputStrength is a required field
	OutputStrength *string `locationName:"outputStrength" type:"string" required:"true" enum:"GuardrailFilterStrength"`

	// The harmful category that the content filter is applied to.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"GuardrailContentFilterType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContentFilterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContentFilterConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GuardrailContentFilterConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GuardrailContentFilterConfig"}
	if s.InputStrength == nil {
		invalidParams.Add(request.NewErrParamRequired("InputStrength"))
	}
	if s.OutputStrength == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputStrength"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputStrength sets the InputStrength field's value.
func (s *GuardrailContentFilterConfig) SetInputStrength(v string) *GuardrailContentFilterConfig {
	s.InputStrength = &v
	return s
}

// SetOutputStrength sets the OutputStrength field's value.
func (s *GuardrailContentFilterConfig) SetOutputStrength(v string) *GuardrailContentFilterConfig {
	s.OutputStrength = &v
	return s
}

// SetType sets the Type field's value.
func (s *GuardrailContentFilterConfig) SetType(v string) *GuardrailContentFilterConfig {
	s.Type = &v
	return s
}

// Contains details about how to handle harmful content.
//
// This data type is used in the following API operations:
//
//   - GetGuardrail response body (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax)
type GuardrailContentPolicy struct {
	_ struct{} `type:"structure"`

	// Contains the type of the content filter and how strongly it should apply
	// to prompts and model responses.
	Filters []*GuardrailContentFilter `locationName:"filters" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContentPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContentPolicy) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *GuardrailContentPolicy) SetFilters(v []*GuardrailContentFilter) *GuardrailContentPolicy {
	s.Filters = v
	return s
}

// Contains details about how to handle harmful content.
type GuardrailContentPolicyConfig struct {
	_ struct{} `type:"structure"`

	// Contains the type of the content filter and how strongly it should apply
	// to prompts and model responses.
	//
	// FiltersConfig is a required field
	FiltersConfig []*GuardrailContentFilterConfig `locationName:"filtersConfig" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContentPolicyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContentPolicyConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GuardrailContentPolicyConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GuardrailContentPolicyConfig"}
	if s.FiltersConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("FiltersConfig"))
	}
	if s.FiltersConfig != nil && len(s.FiltersConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FiltersConfig", 1))
	}
	if s.FiltersConfig != nil {
		for i, v := range s.FiltersConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FiltersConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFiltersConfig sets the FiltersConfig field's value.
func (s *GuardrailContentPolicyConfig) SetFiltersConfig(v []*GuardrailContentFilterConfig) *GuardrailContentPolicyConfig {
	s.FiltersConfig = v
	return s
}

// The details for the guardrails contextual grounding filter.
type GuardrailContextualGroundingFilter struct {
	_ struct{} `type:"structure"`

	// The threshold details for the guardrails contextual grounding filter.
	//
	// Threshold is a required field
	Threshold *float64 `locationName:"threshold" type:"double" required:"true"`

	// The filter type details for the guardrails contextual grounding filter.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"GuardrailContextualGroundingFilterType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContextualGroundingFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContextualGroundingFilter) GoString() string {
	return s.String()
}

// SetThreshold sets the Threshold field's value.
func (s *GuardrailContextualGroundingFilter) SetThreshold(v float64) *GuardrailContextualGroundingFilter {
	s.Threshold = &v
	return s
}

// SetType sets the Type field's value.
func (s *GuardrailContextualGroundingFilter) SetType(v string) *GuardrailContextualGroundingFilter {
	s.Type = &v
	return s
}

// The filter configuration details for the guardrails contextual grounding
// filter.
type GuardrailContextualGroundingFilterConfig struct {
	_ struct{} `type:"structure"`

	// The threshold details for the guardrails contextual grounding filter.
	//
	// Threshold is a required field
	Threshold *float64 `locationName:"threshold" type:"double" required:"true"`

	// The filter details for the guardrails contextual grounding filter.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"GuardrailContextualGroundingFilterType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContextualGroundingFilterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContextualGroundingFilterConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GuardrailContextualGroundingFilterConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GuardrailContextualGroundingFilterConfig"}
	if s.Threshold == nil {
		invalidParams.Add(request.NewErrParamRequired("Threshold"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThreshold sets the Threshold field's value.
func (s *GuardrailContextualGroundingFilterConfig) SetThreshold(v float64) *GuardrailContextualGroundingFilterConfig {
	s.Threshold = &v
	return s
}

// SetType sets the Type field's value.
func (s *GuardrailContextualGroundingFilterConfig) SetType(v string) *GuardrailContextualGroundingFilterConfig {
	s.Type = &v
	return s
}

// The details for the guardrails contextual grounding policy.
type GuardrailContextualGroundingPolicy struct {
	_ struct{} `type:"structure"`

	// The filter details for the guardrails contextual grounding policy.
	//
	// Filters is a required field
	Filters []*GuardrailContextualGroundingFilter `locationName:"filters" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContextualGroundingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContextualGroundingPolicy) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *GuardrailContextualGroundingPolicy) SetFilters(v []*GuardrailContextualGroundingFilter) *GuardrailContextualGroundingPolicy {
	s.Filters = v
	return s
}

// The policy configuration details for the guardrails contextual grounding
// policy.
type GuardrailContextualGroundingPolicyConfig struct {
	_ struct{} `type:"structure"`

	// The filter configuration details for the guardrails contextual grounding
	// policy.
	//
	// FiltersConfig is a required field
	FiltersConfig []*GuardrailContextualGroundingFilterConfig `locationName:"filtersConfig" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContextualGroundingPolicyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailContextualGroundingPolicyConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GuardrailContextualGroundingPolicyConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GuardrailContextualGroundingPolicyConfig"}
	if s.FiltersConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("FiltersConfig"))
	}
	if s.FiltersConfig != nil && len(s.FiltersConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FiltersConfig", 1))
	}
	if s.FiltersConfig != nil {
		for i, v := range s.FiltersConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FiltersConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFiltersConfig sets the FiltersConfig field's value.
func (s *GuardrailContextualGroundingPolicyConfig) SetFiltersConfig(v []*GuardrailContextualGroundingFilterConfig) *GuardrailContextualGroundingPolicyConfig {
	s.FiltersConfig = v
	return s
}

// The managed word list that was configured for the guardrail. (This is a list
// of words that are pre-defined and managed by guardrails only.)
type GuardrailManagedWords struct {
	_ struct{} `type:"structure"`

	// ManagedWords$type The managed word type that was configured for the guardrail.
	// (For now, we only offer profanity word list)
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"GuardrailManagedWordsType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailManagedWords) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailManagedWords) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *GuardrailManagedWords) SetType(v string) *GuardrailManagedWords {
	s.Type = &v
	return s
}

// The managed word list to configure for the guardrail.
type GuardrailManagedWordsConfig struct {
	_ struct{} `type:"structure"`

	// The managed word type to configure for the guardrail.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"GuardrailManagedWordsType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailManagedWordsConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailManagedWordsConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GuardrailManagedWordsConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GuardrailManagedWordsConfig"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *GuardrailManagedWordsConfig) SetType(v string) *GuardrailManagedWordsConfig {
	s.Type = &v
	return s
}

// The PII entity configured for the guardrail.
type GuardrailPiiEntity struct {
	_ struct{} `type:"structure"`

	// The configured guardrail action when PII entity is detected.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"GuardrailSensitiveInformationAction"`

	// The type of PII entity. For example, Social Security Number.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"GuardrailPiiEntityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailPiiEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailPiiEntity) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *GuardrailPiiEntity) SetAction(v string) *GuardrailPiiEntity {
	s.Action = &v
	return s
}

// SetType sets the Type field's value.
func (s *GuardrailPiiEntity) SetType(v string) *GuardrailPiiEntity {
	s.Type = &v
	return s
}

// The PII entity to configure for the guardrail.
type GuardrailPiiEntityConfig struct {
	_ struct{} `type:"structure"`

	// Configure guardrail action when the PII entity is detected.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"GuardrailSensitiveInformationAction"`

	// Configure guardrail type when the PII entity is detected.
	//
	// The following PIIs are used to block or mask sensitive information:
	//
	//    * General ADDRESS A physical address, such as "100 Main Street, Anytown,
	//    USA" or "Suite #12, Building 123". An address can include information
	//    such as the street, building, location, city, state, country, county,
	//    zip code, precinct, and neighborhood. AGE An individual's age, including
	//    the quantity and unit of time. For example, in the phrase "I am 40 years
	//    old," Guarrails recognizes "40 years" as an age. NAME An individual's
	//    name. This entity type does not include titles, such as Dr., Mr., Mrs.,
	//    or Miss. guardrails doesn't apply this entity type to names that are part
	//    of organizations or addresses. For example, guardrails recognizes the
	//    "John Doe Organization" as an organization, and it recognizes "Jane Doe
	//    Street" as an address. EMAIL An email address, such as marymajor@email.com.
	//    PHONE A phone number. This entity type also includes fax and pager numbers.
	//    USERNAME A user name that identifies an account, such as a login name,
	//    screen name, nick name, or handle. PASSWORD An alphanumeric string that
	//    is used as a password, such as "*very20special#pass*". DRIVER_ID The number
	//    assigned to a driver's license, which is an official document permitting
	//    an individual to operate one or more motorized vehicles on a public road.
	//    A driver's license number consists of alphanumeric characters. LICENSE_PLATE
	//    A license plate for a vehicle is issued by the state or country where
	//    the vehicle is registered. The format for passenger vehicles is typically
	//    five to eight digits, consisting of upper-case letters and numbers. The
	//    format varies depending on the location of the issuing state or country.
	//    VEHICLE_IDENTIFICATION_NUMBER A Vehicle Identification Number (VIN) uniquely
	//    identifies a vehicle. VIN content and format are defined in the ISO 3779
	//    specification. Each country has specific codes and formats for VINs.
	//
	//    * Finance REDIT_DEBIT_CARD_CVV A three-digit card verification code (CVV)
	//    that is present on VISA, MasterCard, and Discover credit and debit cards.
	//    For American Express credit or debit cards, the CVV is a four-digit numeric
	//    code. CREDIT_DEBIT_CARD_EXPIRY The expiration date for a credit or debit
	//    card. This number is usually four digits long and is often formatted as
	//    month/year or MM/YY. Guardrails recognizes expiration dates such as 01/21,
	//    01/2021, and Jan 2021. CREDIT_DEBIT_CARD_NUMBER The number for a credit
	//    or debit card. These numbers can vary from 13 to 16 digits in length.
	//    However, Amazon Comprehend also recognizes credit or debit card numbers
	//    when only the last four digits are present. PIN A four-digit personal
	//    identification number (PIN) with which you can access your bank account.
	//    INTERNATIONAL_BANK_ACCOUNT_NUMBER An International Bank Account Number
	//    has specific formats in each country. For more information, see www.iban.com/structure
	//    (https://www.iban.com/structure). SWIFT_CODE A SWIFT code is a standard
	//    format of Bank Identifier Code (BIC) used to specify a particular bank
	//    or branch. Banks use these codes for money transfers such as international
	//    wire transfers. SWIFT codes consist of eight or 11 characters. The 11-digit
	//    codes refer to specific branches, while eight-digit codes (or 11-digit
	//    codes ending in 'XXX') refer to the head or primary office.
	//
	//    * IT IP_ADDRESS An IPv4 address, such as 198.51.100.0. MAC_ADDRESS A media
	//    access control (MAC) address is a unique identifier assigned to a network
	//    interface controller (NIC). URL A web address, such as www.example.com.
	//    AWS_ACCESS_KEY A unique identifier that's associated with a secret access
	//    key; you use the access key ID and secret access key to sign programmatic
	//    Amazon Web Services requests cryptographically. AWS_SECRET_KEY A unique
	//    identifier that's associated with an access key. You use the access key
	//    ID and secret access key to sign programmatic Amazon Web Services requests
	//    cryptographically.
	//
	//    * USA specific US_BANK_ACCOUNT_NUMBER A US bank account number, which
	//    is typically 10 to 12 digits long. US_BANK_ROUTING_NUMBER A US bank account
	//    routing number. These are typically nine digits long, US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER
	//    A US Individual Taxpayer Identification Number (ITIN) is a nine-digit
	//    number that starts with a "9" and contain a "7" or "8" as the fourth digit.
	//    An ITIN can be formatted with a space or a dash after the third and forth
	//    digits. US_PASSPORT_NUMBER A US passport number. Passport numbers range
	//    from six to nine alphanumeric characters. US_SOCIAL_SECURITY_NUMBER A
	//    US Social Security Number (SSN) is a nine-digit number that is issued
	//    to US citizens, permanent residents, and temporary working residents.
	//
	//    * Canada specific CA_HEALTH_NUMBER A Canadian Health Service Number is
	//    a 10-digit unique identifier, required for individuals to access healthcare
	//    benefits. CA_SOCIAL_INSURANCE_NUMBER A Canadian Social Insurance Number
	//    (SIN) is a nine-digit unique identifier, required for individuals to access
	//    government programs and benefits. The SIN is formatted as three groups
	//    of three digits, such as 123-456-789. A SIN can be validated through a
	//    simple check-digit process called the Luhn algorithm (https://www.wikipedia.org/wiki/Luhn_algorithm).
	//
	//    * UK Specific UK_NATIONAL_HEALTH_SERVICE_NUMBER A UK National Health Service
	//    Number is a 10-17 digit number, such as 485 777 3456. The current system
	//    formats the 10-digit number with spaces after the third and sixth digits.
	//    The final digit is an error-detecting checksum. UK_NATIONAL_INSURANCE_NUMBER
	//    A UK National Insurance Number (NINO) provides individuals with access
	//    to National Insurance (social security) benefits. It is also used for
	//    some purposes in the UK tax system. The number is nine digits long and
	//    starts with two letters, followed by six numbers and one letter. A NINO
	//    can be formatted with a space or a dash after the two letters and after
	//    the second, forth, and sixth digits. UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER
	//    A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies
	//    a taxpayer or a business.
	//
	//    * Custom Regex filter - You can use a regular expressions to define patterns
	//    for a guardrail to recognize and act upon such as serial number, booking
	//    ID etc..
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"GuardrailPiiEntityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailPiiEntityConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailPiiEntityConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GuardrailPiiEntityConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GuardrailPiiEntityConfig"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *GuardrailPiiEntityConfig) SetAction(v string) *GuardrailPiiEntityConfig {
	s.Action = &v
	return s
}

// SetType sets the Type field's value.
func (s *GuardrailPiiEntityConfig) SetType(v string) *GuardrailPiiEntityConfig {
	s.Type = &v
	return s
}

// The regular expression configured for the guardrail.
type GuardrailRegex struct {
	_ struct{} `type:"structure"`

	// The action taken when a match to the regular expression is detected.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"GuardrailSensitiveInformationAction"`

	// The description of the regular expression for the guardrail.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the regular expression for the guardrail.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The pattern of the regular expression configured for the guardrail.
	//
	// Pattern is a required field
	Pattern *string `locationName:"pattern" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailRegex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailRegex) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *GuardrailRegex) SetAction(v string) *GuardrailRegex {
	s.Action = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GuardrailRegex) SetDescription(v string) *GuardrailRegex {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *GuardrailRegex) SetName(v string) *GuardrailRegex {
	s.Name = &v
	return s
}

// SetPattern sets the Pattern field's value.
func (s *GuardrailRegex) SetPattern(v string) *GuardrailRegex {
	s.Pattern = &v
	return s
}

// The regular expression to configure for the guardrail.
type GuardrailRegexConfig struct {
	_ struct{} `type:"structure"`

	// The guardrail action to configure when matching regular expression is detected.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"GuardrailSensitiveInformationAction"`

	// The description of the regular expression to configure for the guardrail.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the regular expression to configure for the guardrail.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The regular expression pattern to configure for the guardrail.
	//
	// Pattern is a required field
	Pattern *string `locationName:"pattern" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailRegexConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailRegexConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GuardrailRegexConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GuardrailRegexConfig"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Pattern == nil {
		invalidParams.Add(request.NewErrParamRequired("Pattern"))
	}
	if s.Pattern != nil && len(*s.Pattern) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Pattern", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *GuardrailRegexConfig) SetAction(v string) *GuardrailRegexConfig {
	s.Action = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GuardrailRegexConfig) SetDescription(v string) *GuardrailRegexConfig {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *GuardrailRegexConfig) SetName(v string) *GuardrailRegexConfig {
	s.Name = &v
	return s
}

// SetPattern sets the Pattern field's value.
func (s *GuardrailRegexConfig) SetPattern(v string) *GuardrailRegexConfig {
	s.Pattern = &v
	return s
}

// Contains details about PII entities and regular expressions configured for
// the guardrail.
type GuardrailSensitiveInformationPolicy struct {
	_ struct{} `type:"structure"`

	// The list of PII entities configured for the guardrail.
	PiiEntities []*GuardrailPiiEntity `locationName:"piiEntities" min:"1" type:"list"`

	// The list of regular expressions configured for the guardrail.
	Regexes []*GuardrailRegex `locationName:"regexes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailSensitiveInformationPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailSensitiveInformationPolicy) GoString() string {
	return s.String()
}

// SetPiiEntities sets the PiiEntities field's value.
func (s *GuardrailSensitiveInformationPolicy) SetPiiEntities(v []*GuardrailPiiEntity) *GuardrailSensitiveInformationPolicy {
	s.PiiEntities = v
	return s
}

// SetRegexes sets the Regexes field's value.
func (s *GuardrailSensitiveInformationPolicy) SetRegexes(v []*GuardrailRegex) *GuardrailSensitiveInformationPolicy {
	s.Regexes = v
	return s
}

// Contains details about PII entities and regular expressions to configure
// for the guardrail.
type GuardrailSensitiveInformationPolicyConfig struct {
	_ struct{} `type:"structure"`

	// A list of PII entities to configure to the guardrail.
	PiiEntitiesConfig []*GuardrailPiiEntityConfig `locationName:"piiEntitiesConfig" min:"1" type:"list"`

	// A list of regular expressions to configure to the guardrail.
	RegexesConfig []*GuardrailRegexConfig `locationName:"regexesConfig" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailSensitiveInformationPolicyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailSensitiveInformationPolicyConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GuardrailSensitiveInformationPolicyConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GuardrailSensitiveInformationPolicyConfig"}
	if s.PiiEntitiesConfig != nil && len(s.PiiEntitiesConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PiiEntitiesConfig", 1))
	}
	if s.RegexesConfig != nil && len(s.RegexesConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegexesConfig", 1))
	}
	if s.PiiEntitiesConfig != nil {
		for i, v := range s.PiiEntitiesConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PiiEntitiesConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RegexesConfig != nil {
		for i, v := range s.RegexesConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RegexesConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPiiEntitiesConfig sets the PiiEntitiesConfig field's value.
func (s *GuardrailSensitiveInformationPolicyConfig) SetPiiEntitiesConfig(v []*GuardrailPiiEntityConfig) *GuardrailSensitiveInformationPolicyConfig {
	s.PiiEntitiesConfig = v
	return s
}

// SetRegexesConfig sets the RegexesConfig field's value.
func (s *GuardrailSensitiveInformationPolicyConfig) SetRegexesConfig(v []*GuardrailRegexConfig) *GuardrailSensitiveInformationPolicyConfig {
	s.RegexesConfig = v
	return s
}

// Contains details about a guardrail.
//
// This data type is used in the following API operations:
//
//   - ListGuardrails response body (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListGuardrails.html#API_ListGuardrails_ResponseSyntax)
type GuardrailSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the guardrail.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The date and time at which the guardrail was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A description of the guardrail.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GuardrailSummary's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The unique identifier of the guardrail.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the guardrail.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GuardrailSummary's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The status of the guardrail.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"GuardrailStatus"`

	// The date and time at which the guardrail was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The version of the guardrail.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GuardrailSummary) SetArn(v string) *GuardrailSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GuardrailSummary) SetCreatedAt(v time.Time) *GuardrailSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GuardrailSummary) SetDescription(v string) *GuardrailSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GuardrailSummary) SetId(v string) *GuardrailSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GuardrailSummary) SetName(v string) *GuardrailSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GuardrailSummary) SetStatus(v string) *GuardrailSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GuardrailSummary) SetUpdatedAt(v time.Time) *GuardrailSummary {
	s.UpdatedAt = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GuardrailSummary) SetVersion(v string) *GuardrailSummary {
	s.Version = &v
	return s
}

// Details about topics for the guardrail to identify and deny.
//
// This data type is used in the following API operations:
//
//   - GetGuardrail response body (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax)
type GuardrailTopic struct {
	_ struct{} `type:"structure"`

	// A definition of the topic to deny.
	//
	// Definition is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GuardrailTopic's
	// String and GoString methods.
	//
	// Definition is a required field
	Definition *string `locationName:"definition" min:"1" type:"string" required:"true" sensitive:"true"`

	// A list of prompts, each of which is an example of a prompt that can be categorized
	// as belonging to the topic.
	Examples []*string `locationName:"examples" type:"list" sensitive:"true"`

	// The name of the topic to deny.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GuardrailTopic's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// Specifies to deny the topic.
	Type *string `locationName:"type" type:"string" enum:"GuardrailTopicType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailTopic) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailTopic) GoString() string {
	return s.String()
}

// SetDefinition sets the Definition field's value.
func (s *GuardrailTopic) SetDefinition(v string) *GuardrailTopic {
	s.Definition = &v
	return s
}

// SetExamples sets the Examples field's value.
func (s *GuardrailTopic) SetExamples(v []*string) *GuardrailTopic {
	s.Examples = v
	return s
}

// SetName sets the Name field's value.
func (s *GuardrailTopic) SetName(v string) *GuardrailTopic {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *GuardrailTopic) SetType(v string) *GuardrailTopic {
	s.Type = &v
	return s
}

// Details about topics for the guardrail to identify and deny.
type GuardrailTopicConfig struct {
	_ struct{} `type:"structure"`

	// A definition of the topic to deny.
	//
	// Definition is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GuardrailTopicConfig's
	// String and GoString methods.
	//
	// Definition is a required field
	Definition *string `locationName:"definition" min:"1" type:"string" required:"true" sensitive:"true"`

	// A list of prompts, each of which is an example of a prompt that can be categorized
	// as belonging to the topic.
	Examples []*string `locationName:"examples" type:"list" sensitive:"true"`

	// The name of the topic to deny.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GuardrailTopicConfig's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// Specifies to deny the topic.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"GuardrailTopicType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailTopicConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailTopicConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GuardrailTopicConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GuardrailTopicConfig"}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.Definition != nil && len(*s.Definition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Definition", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefinition sets the Definition field's value.
func (s *GuardrailTopicConfig) SetDefinition(v string) *GuardrailTopicConfig {
	s.Definition = &v
	return s
}

// SetExamples sets the Examples field's value.
func (s *GuardrailTopicConfig) SetExamples(v []*string) *GuardrailTopicConfig {
	s.Examples = v
	return s
}

// SetName sets the Name field's value.
func (s *GuardrailTopicConfig) SetName(v string) *GuardrailTopicConfig {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *GuardrailTopicConfig) SetType(v string) *GuardrailTopicConfig {
	s.Type = &v
	return s
}

// Contains details about topics that the guardrail should identify and deny.
//
// This data type is used in the following API operations:
//
//   - GetGuardrail response body (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax)
type GuardrailTopicPolicy struct {
	_ struct{} `type:"structure"`

	// A list of policies related to topics that the guardrail should deny.
	//
	// Topics is a required field
	Topics []*GuardrailTopic `locationName:"topics" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailTopicPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailTopicPolicy) GoString() string {
	return s.String()
}

// SetTopics sets the Topics field's value.
func (s *GuardrailTopicPolicy) SetTopics(v []*GuardrailTopic) *GuardrailTopicPolicy {
	s.Topics = v
	return s
}

// Contains details about topics that the guardrail should identify and deny.
type GuardrailTopicPolicyConfig struct {
	_ struct{} `type:"structure"`

	// A list of policies related to topics that the guardrail should deny.
	//
	// TopicsConfig is a required field
	TopicsConfig []*GuardrailTopicConfig `locationName:"topicsConfig" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailTopicPolicyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailTopicPolicyConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GuardrailTopicPolicyConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GuardrailTopicPolicyConfig"}
	if s.TopicsConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicsConfig"))
	}
	if s.TopicsConfig != nil && len(s.TopicsConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicsConfig", 1))
	}
	if s.TopicsConfig != nil {
		for i, v := range s.TopicsConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TopicsConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTopicsConfig sets the TopicsConfig field's value.
func (s *GuardrailTopicPolicyConfig) SetTopicsConfig(v []*GuardrailTopicConfig) *GuardrailTopicPolicyConfig {
	s.TopicsConfig = v
	return s
}

// A word configured for the guardrail.
type GuardrailWord struct {
	_ struct{} `type:"structure"`

	// Text of the word configured for the guardrail to block.
	//
	// Text is a required field
	Text *string `locationName:"text" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailWord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailWord) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *GuardrailWord) SetText(v string) *GuardrailWord {
	s.Text = &v
	return s
}

// A word to configure for the guardrail.
type GuardrailWordConfig struct {
	_ struct{} `type:"structure"`

	// Text of the word configured for the guardrail to block.
	//
	// Text is a required field
	Text *string `locationName:"text" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailWordConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailWordConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GuardrailWordConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GuardrailWordConfig"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *GuardrailWordConfig) SetText(v string) *GuardrailWordConfig {
	s.Text = &v
	return s
}

// Contains details about the word policy configured for the guardrail.
type GuardrailWordPolicy struct {
	_ struct{} `type:"structure"`

	// A list of managed words configured for the guardrail.
	ManagedWordLists []*GuardrailManagedWords `locationName:"managedWordLists" type:"list"`

	// A list of words configured for the guardrail.
	Words []*GuardrailWord `locationName:"words" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailWordPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailWordPolicy) GoString() string {
	return s.String()
}

// SetManagedWordLists sets the ManagedWordLists field's value.
func (s *GuardrailWordPolicy) SetManagedWordLists(v []*GuardrailManagedWords) *GuardrailWordPolicy {
	s.ManagedWordLists = v
	return s
}

// SetWords sets the Words field's value.
func (s *GuardrailWordPolicy) SetWords(v []*GuardrailWord) *GuardrailWordPolicy {
	s.Words = v
	return s
}

// Contains details about the word policy to configured for the guardrail.
type GuardrailWordPolicyConfig struct {
	_ struct{} `type:"structure"`

	// A list of managed words to configure for the guardrail.
	ManagedWordListsConfig []*GuardrailManagedWordsConfig `locationName:"managedWordListsConfig" type:"list"`

	// A list of words to configure for the guardrail.
	WordsConfig []*GuardrailWordConfig `locationName:"wordsConfig" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailWordPolicyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailWordPolicyConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GuardrailWordPolicyConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GuardrailWordPolicyConfig"}
	if s.WordsConfig != nil && len(s.WordsConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WordsConfig", 1))
	}
	if s.ManagedWordListsConfig != nil {
		for i, v := range s.ManagedWordListsConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ManagedWordListsConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.WordsConfig != nil {
		for i, v := range s.WordsConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WordsConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManagedWordListsConfig sets the ManagedWordListsConfig field's value.
func (s *GuardrailWordPolicyConfig) SetManagedWordListsConfig(v []*GuardrailManagedWordsConfig) *GuardrailWordPolicyConfig {
	s.ManagedWordListsConfig = v
	return s
}

// SetWordsConfig sets the WordsConfig field's value.
func (s *GuardrailWordPolicyConfig) SetWordsConfig(v []*GuardrailWordConfig) *GuardrailWordPolicyConfig {
	s.WordsConfig = v
	return s
}

// Specifies the custom metrics, how tasks will be rated, the flow definition
// ARN, and your custom prompt datasets. Model evaluation jobs use human workers
// only support the use of custom prompt datasets. To learn more about custom
// prompt datasets and the required format, see Custom prompt datasets (https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-prompt-datasets-custom.html).
//
// When you create custom metrics in HumanEvaluationCustomMetric you must specify
// the metric's name. The list of names specified in the HumanEvaluationCustomMetric
// array, must match the metricNames array of strings specified in EvaluationDatasetMetricConfig.
// For example, if in the HumanEvaluationCustomMetric array your specified the
// names "accuracy", "toxicity", "readability" as custom metrics then the metricNames
// array would need to look like the following ["accuracy", "toxicity", "readability"]
// in EvaluationDatasetMetricConfig.
type HumanEvaluationConfig struct {
	_ struct{} `type:"structure"`

	// A HumanEvaluationCustomMetric object. It contains the names the metrics,
	// how the metrics are to be evaluated, an optional description.
	CustomMetrics []*HumanEvaluationCustomMetric `locationName:"customMetrics" min:"1" type:"list"`

	// Use to specify the metrics, task, and prompt dataset to be used in your model
	// evaluation job.
	//
	// DatasetMetricConfigs is a required field
	DatasetMetricConfigs []*EvaluationDatasetMetricConfig `locationName:"datasetMetricConfigs" min:"1" type:"list" required:"true"`

	// The parameters of the human workflow.
	HumanWorkflowConfig *HumanWorkflowConfig `locationName:"humanWorkflowConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanEvaluationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanEvaluationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanEvaluationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HumanEvaluationConfig"}
	if s.CustomMetrics != nil && len(s.CustomMetrics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomMetrics", 1))
	}
	if s.DatasetMetricConfigs == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetMetricConfigs"))
	}
	if s.DatasetMetricConfigs != nil && len(s.DatasetMetricConfigs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetMetricConfigs", 1))
	}
	if s.CustomMetrics != nil {
		for i, v := range s.CustomMetrics {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomMetrics", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DatasetMetricConfigs != nil {
		for i, v := range s.DatasetMetricConfigs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DatasetMetricConfigs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.HumanWorkflowConfig != nil {
		if err := s.HumanWorkflowConfig.Validate(); err != nil {
			invalidParams.AddNested("HumanWorkflowConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomMetrics sets the CustomMetrics field's value.
func (s *HumanEvaluationConfig) SetCustomMetrics(v []*HumanEvaluationCustomMetric) *HumanEvaluationConfig {
	s.CustomMetrics = v
	return s
}

// SetDatasetMetricConfigs sets the DatasetMetricConfigs field's value.
func (s *HumanEvaluationConfig) SetDatasetMetricConfigs(v []*EvaluationDatasetMetricConfig) *HumanEvaluationConfig {
	s.DatasetMetricConfigs = v
	return s
}

// SetHumanWorkflowConfig sets the HumanWorkflowConfig field's value.
func (s *HumanEvaluationConfig) SetHumanWorkflowConfig(v *HumanWorkflowConfig) *HumanEvaluationConfig {
	s.HumanWorkflowConfig = v
	return s
}

// In a model evaluation job that uses human workers you must define the name
// of the metric, and how you want that metric rated ratingMethod, and an optional
// description of the metric.
type HumanEvaluationCustomMetric struct {
	_ struct{} `type:"structure"`

	// An optional description of the metric. Use this parameter to provide more
	// details about the metric.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by HumanEvaluationCustomMetric's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The name of the metric. Your human evaluators will see this name in the evaluation
	// UI.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by HumanEvaluationCustomMetric's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// Choose how you want your human workers to evaluation your model. Valid values
	// for rating methods are ThumbsUpDown, IndividualLikertScale,ComparisonLikertScale,
	// ComparisonChoice, and ComparisonRank
	//
	// RatingMethod is a required field
	RatingMethod *string `locationName:"ratingMethod" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanEvaluationCustomMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanEvaluationCustomMetric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanEvaluationCustomMetric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HumanEvaluationCustomMetric"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RatingMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("RatingMethod"))
	}
	if s.RatingMethod != nil && len(*s.RatingMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RatingMethod", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *HumanEvaluationCustomMetric) SetDescription(v string) *HumanEvaluationCustomMetric {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *HumanEvaluationCustomMetric) SetName(v string) *HumanEvaluationCustomMetric {
	s.Name = &v
	return s
}

// SetRatingMethod sets the RatingMethod field's value.
func (s *HumanEvaluationCustomMetric) SetRatingMethod(v string) *HumanEvaluationCustomMetric {
	s.RatingMethod = &v
	return s
}

// Contains SageMakerFlowDefinition object. The object is used to specify the
// prompt dataset, task type, rating method and metric names.
type HumanWorkflowConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) for the flow definition
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `locationName:"flowDefinitionArn" type:"string" required:"true"`

	// Instructions for the flow definition
	//
	// Instructions is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by HumanWorkflowConfig's
	// String and GoString methods.
	Instructions *string `locationName:"instructions" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanWorkflowConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanWorkflowConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanWorkflowConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HumanWorkflowConfig"}
	if s.FlowDefinitionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowDefinitionArn"))
	}
	if s.Instructions != nil && len(*s.Instructions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Instructions", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowDefinitionArn sets the FlowDefinitionArn field's value.
func (s *HumanWorkflowConfig) SetFlowDefinitionArn(v string) *HumanWorkflowConfig {
	s.FlowDefinitionArn = &v
	return s
}

// SetInstructions sets the Instructions field's value.
func (s *HumanWorkflowConfig) SetInstructions(v string) *HumanWorkflowConfig {
	s.Instructions = &v
	return s
}

// An internal server error occurred. Retry your request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCustomModelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Return custom models only if the base model Amazon Resource Name (ARN) matches
	// this parameter.
	BaseModelArnEquals *string `location:"querystring" locationName:"baseModelArnEquals" min:"20" type:"string"`

	// Return custom models created after the specified time.
	CreationTimeAfter *time.Time `location:"querystring" locationName:"creationTimeAfter" type:"timestamp" timestampFormat:"iso8601"`

	// Return custom models created before the specified time.
	CreationTimeBefore *time.Time `location:"querystring" locationName:"creationTimeBefore" type:"timestamp" timestampFormat:"iso8601"`

	// Return custom models only if the foundation model Amazon Resource Name (ARN)
	// matches this parameter.
	FoundationModelArnEquals *string `location:"querystring" locationName:"foundationModelArnEquals" type:"string"`

	// Maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Return custom models only if the job name contains these characters.
	NameContains *string `location:"querystring" locationName:"nameContains" min:"1" type:"string"`

	// Continuation token from the previous response, for Amazon Bedrock to list
	// the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The field to sort by in the returned list of models.
	SortBy *string `location:"querystring" locationName:"sortBy" type:"string" enum:"SortModelsBy"`

	// The sort order of the results.
	SortOrder *string `location:"querystring" locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomModelsInput"}
	if s.BaseModelArnEquals != nil && len(*s.BaseModelArnEquals) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BaseModelArnEquals", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseModelArnEquals sets the BaseModelArnEquals field's value.
func (s *ListCustomModelsInput) SetBaseModelArnEquals(v string) *ListCustomModelsInput {
	s.BaseModelArnEquals = &v
	return s
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListCustomModelsInput) SetCreationTimeAfter(v time.Time) *ListCustomModelsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListCustomModelsInput) SetCreationTimeBefore(v time.Time) *ListCustomModelsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetFoundationModelArnEquals sets the FoundationModelArnEquals field's value.
func (s *ListCustomModelsInput) SetFoundationModelArnEquals(v string) *ListCustomModelsInput {
	s.FoundationModelArnEquals = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomModelsInput) SetMaxResults(v int64) *ListCustomModelsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListCustomModelsInput) SetNameContains(v string) *ListCustomModelsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomModelsInput) SetNextToken(v string) *ListCustomModelsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListCustomModelsInput) SetSortBy(v string) *ListCustomModelsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListCustomModelsInput) SetSortOrder(v string) *ListCustomModelsInput {
	s.SortOrder = &v
	return s
}

type ListCustomModelsOutput struct {
	_ struct{} `type:"structure"`

	// Model summaries.
	ModelSummaries []*CustomModelSummary `locationName:"modelSummaries" type:"list"`

	// Continuation token for the next request to list the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomModelsOutput) GoString() string {
	return s.String()
}

// SetModelSummaries sets the ModelSummaries field's value.
func (s *ListCustomModelsOutput) SetModelSummaries(v []*CustomModelSummary) *ListCustomModelsOutput {
	s.ModelSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomModelsOutput) SetNextToken(v string) *ListCustomModelsOutput {
	s.NextToken = &v
	return s
}

type ListEvaluationJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A filter that includes model evaluation jobs created after the time specified.
	CreationTimeAfter *time.Time `location:"querystring" locationName:"creationTimeAfter" type:"timestamp" timestampFormat:"iso8601"`

	// A filter that includes model evaluation jobs created prior to the time specified.
	CreationTimeBefore *time.Time `location:"querystring" locationName:"creationTimeBefore" type:"timestamp" timestampFormat:"iso8601"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Query parameter string for model evaluation job names.
	NameContains *string `location:"querystring" locationName:"nameContains" min:"1" type:"string"`

	// Continuation token from the previous response, for Amazon Bedrock to list
	// the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// Allows you to sort model evaluation jobs by when they were created.
	SortBy *string `location:"querystring" locationName:"sortBy" type:"string" enum:"SortJobsBy"`

	// How you want the order of jobs sorted.
	SortOrder *string `location:"querystring" locationName:"sortOrder" type:"string" enum:"SortOrder"`

	// Only return jobs where the status condition is met.
	StatusEquals *string `location:"querystring" locationName:"statusEquals" type:"string" enum:"EvaluationJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEvaluationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEvaluationJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEvaluationJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEvaluationJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListEvaluationJobsInput) SetCreationTimeAfter(v time.Time) *ListEvaluationJobsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListEvaluationJobsInput) SetCreationTimeBefore(v time.Time) *ListEvaluationJobsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEvaluationJobsInput) SetMaxResults(v int64) *ListEvaluationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListEvaluationJobsInput) SetNameContains(v string) *ListEvaluationJobsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEvaluationJobsInput) SetNextToken(v string) *ListEvaluationJobsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListEvaluationJobsInput) SetSortBy(v string) *ListEvaluationJobsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListEvaluationJobsInput) SetSortOrder(v string) *ListEvaluationJobsInput {
	s.SortOrder = &v
	return s
}

// SetStatusEquals sets the StatusEquals field's value.
func (s *ListEvaluationJobsInput) SetStatusEquals(v string) *ListEvaluationJobsInput {
	s.StatusEquals = &v
	return s
}

type ListEvaluationJobsOutput struct {
	_ struct{} `type:"structure"`

	// A summary of the model evaluation jobs.
	JobSummaries []*EvaluationSummary `locationName:"jobSummaries" min:"1" type:"list"`

	// Continuation token from the previous response, for Amazon Bedrock to list
	// the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEvaluationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEvaluationJobsOutput) GoString() string {
	return s.String()
}

// SetJobSummaries sets the JobSummaries field's value.
func (s *ListEvaluationJobsOutput) SetJobSummaries(v []*EvaluationSummary) *ListEvaluationJobsOutput {
	s.JobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEvaluationJobsOutput) SetNextToken(v string) *ListEvaluationJobsOutput {
	s.NextToken = &v
	return s
}

type ListFoundationModelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Return models that support the customization type that you specify. For more
	// information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
	// in the Amazon Bedrock User Guide.
	ByCustomizationType *string `location:"querystring" locationName:"byCustomizationType" type:"string" enum:"ModelCustomization"`

	// Return models that support the inference type that you specify. For more
	// information, see Provisioned Throughput (https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html)
	// in the Amazon Bedrock User Guide.
	ByInferenceType *string `location:"querystring" locationName:"byInferenceType" type:"string" enum:"InferenceType"`

	// Return models that support the output modality that you specify.
	ByOutputModality *string `location:"querystring" locationName:"byOutputModality" type:"string" enum:"ModelModality"`

	// Return models belonging to the model provider that you specify.
	ByProvider *string `location:"querystring" locationName:"byProvider" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFoundationModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFoundationModelsInput) GoString() string {
	return s.String()
}

// SetByCustomizationType sets the ByCustomizationType field's value.
func (s *ListFoundationModelsInput) SetByCustomizationType(v string) *ListFoundationModelsInput {
	s.ByCustomizationType = &v
	return s
}

// SetByInferenceType sets the ByInferenceType field's value.
func (s *ListFoundationModelsInput) SetByInferenceType(v string) *ListFoundationModelsInput {
	s.ByInferenceType = &v
	return s
}

// SetByOutputModality sets the ByOutputModality field's value.
func (s *ListFoundationModelsInput) SetByOutputModality(v string) *ListFoundationModelsInput {
	s.ByOutputModality = &v
	return s
}

// SetByProvider sets the ByProvider field's value.
func (s *ListFoundationModelsInput) SetByProvider(v string) *ListFoundationModelsInput {
	s.ByProvider = &v
	return s
}

type ListFoundationModelsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Amazon Bedrock foundation models.
	ModelSummaries []*FoundationModelSummary `locationName:"modelSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFoundationModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFoundationModelsOutput) GoString() string {
	return s.String()
}

// SetModelSummaries sets the ModelSummaries field's value.
func (s *ListFoundationModelsOutput) SetModelSummaries(v []*FoundationModelSummary) *ListFoundationModelsOutput {
	s.ModelSummaries = v
	return s
}

type ListGuardrailsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the guardrail. This can be an ID or the ARN.
	GuardrailIdentifier *string `location:"querystring" locationName:"guardrailIdentifier" type:"string"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If there are more results than were returned in the response, the response
	// returns a nextToken that you can send in another ListGuardrails request to
	// see the next batch of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGuardrailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGuardrailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGuardrailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGuardrailsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGuardrailIdentifier sets the GuardrailIdentifier field's value.
func (s *ListGuardrailsInput) SetGuardrailIdentifier(v string) *ListGuardrailsInput {
	s.GuardrailIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGuardrailsInput) SetMaxResults(v int64) *ListGuardrailsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGuardrailsInput) SetNextToken(v string) *ListGuardrailsInput {
	s.NextToken = &v
	return s
}

type ListGuardrailsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains details about a guardrail.
	//
	// Guardrails is a required field
	Guardrails []*GuardrailSummary `locationName:"guardrails" type:"list" required:"true"`

	// If there are more results than were returned in the response, the response
	// returns a nextToken that you can send in another ListGuardrails request to
	// see the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGuardrailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGuardrailsOutput) GoString() string {
	return s.String()
}

// SetGuardrails sets the Guardrails field's value.
func (s *ListGuardrailsOutput) SetGuardrails(v []*GuardrailSummary) *ListGuardrailsOutput {
	s.Guardrails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGuardrailsOutput) SetNextToken(v string) *ListGuardrailsOutput {
	s.NextToken = &v
	return s
}

type ListModelCustomizationJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Return customization jobs created after the specified time.
	CreationTimeAfter *time.Time `location:"querystring" locationName:"creationTimeAfter" type:"timestamp" timestampFormat:"iso8601"`

	// Return customization jobs created before the specified time.
	CreationTimeBefore *time.Time `location:"querystring" locationName:"creationTimeBefore" type:"timestamp" timestampFormat:"iso8601"`

	// Maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Return customization jobs only if the job name contains these characters.
	NameContains *string `location:"querystring" locationName:"nameContains" min:"1" type:"string"`

	// Continuation token from the previous response, for Amazon Bedrock to list
	// the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The field to sort by in the returned list of jobs.
	SortBy *string `location:"querystring" locationName:"sortBy" type:"string" enum:"SortJobsBy"`

	// The sort order of the results.
	SortOrder *string `location:"querystring" locationName:"sortOrder" type:"string" enum:"SortOrder"`

	// Return customization jobs with the specified status.
	StatusEquals *string `location:"querystring" locationName:"statusEquals" type:"string" enum:"FineTuningJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelCustomizationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelCustomizationJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListModelCustomizationJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListModelCustomizationJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListModelCustomizationJobsInput) SetCreationTimeAfter(v time.Time) *ListModelCustomizationJobsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListModelCustomizationJobsInput) SetCreationTimeBefore(v time.Time) *ListModelCustomizationJobsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListModelCustomizationJobsInput) SetMaxResults(v int64) *ListModelCustomizationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListModelCustomizationJobsInput) SetNameContains(v string) *ListModelCustomizationJobsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelCustomizationJobsInput) SetNextToken(v string) *ListModelCustomizationJobsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListModelCustomizationJobsInput) SetSortBy(v string) *ListModelCustomizationJobsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListModelCustomizationJobsInput) SetSortOrder(v string) *ListModelCustomizationJobsInput {
	s.SortOrder = &v
	return s
}

// SetStatusEquals sets the StatusEquals field's value.
func (s *ListModelCustomizationJobsInput) SetStatusEquals(v string) *ListModelCustomizationJobsInput {
	s.StatusEquals = &v
	return s
}

type ListModelCustomizationJobsOutput struct {
	_ struct{} `type:"structure"`

	// Job summaries.
	ModelCustomizationJobSummaries []*ModelCustomizationJobSummary `locationName:"modelCustomizationJobSummaries" type:"list"`

	// Page continuation token to use in the next request.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelCustomizationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelCustomizationJobsOutput) GoString() string {
	return s.String()
}

// SetModelCustomizationJobSummaries sets the ModelCustomizationJobSummaries field's value.
func (s *ListModelCustomizationJobsOutput) SetModelCustomizationJobSummaries(v []*ModelCustomizationJobSummary) *ListModelCustomizationJobsOutput {
	s.ModelCustomizationJobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelCustomizationJobsOutput) SetNextToken(v string) *ListModelCustomizationJobsOutput {
	s.NextToken = &v
	return s
}

type ListProvisionedModelThroughputsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A filter that returns Provisioned Throughputs created after the specified
	// time.
	CreationTimeAfter *time.Time `location:"querystring" locationName:"creationTimeAfter" type:"timestamp" timestampFormat:"iso8601"`

	// A filter that returns Provisioned Throughputs created before the specified
	// time.
	CreationTimeBefore *time.Time `location:"querystring" locationName:"creationTimeBefore" type:"timestamp" timestampFormat:"iso8601"`

	// THe maximum number of results to return in the response. If there are more
	// results than the number you specified, the response returns a nextToken value.
	// To see the next batch of results, send the nextToken value in another list
	// request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A filter that returns Provisioned Throughputs whose model Amazon Resource
	// Name (ARN) is equal to the value that you specify.
	ModelArnEquals *string `location:"querystring" locationName:"modelArnEquals" min:"20" type:"string"`

	// A filter that returns Provisioned Throughputs if their name contains the
	// expression that you specify.
	NameContains *string `location:"querystring" locationName:"nameContains" min:"1" type:"string"`

	// If there are more results than the number you specified in the maxResults
	// field, the response returns a nextToken value. To see the next batch of results,
	// specify the nextToken value in this field.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The field by which to sort the returned list of Provisioned Throughputs.
	SortBy *string `location:"querystring" locationName:"sortBy" type:"string" enum:"SortByProvisionedModels"`

	// The sort order of the results.
	SortOrder *string `location:"querystring" locationName:"sortOrder" type:"string" enum:"SortOrder"`

	// A filter that returns Provisioned Throughputs if their statuses matches the
	// value that you specify.
	StatusEquals *string `location:"querystring" locationName:"statusEquals" type:"string" enum:"ProvisionedModelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProvisionedModelThroughputsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProvisionedModelThroughputsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProvisionedModelThroughputsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProvisionedModelThroughputsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ModelArnEquals != nil && len(*s.ModelArnEquals) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ModelArnEquals", 20))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListProvisionedModelThroughputsInput) SetCreationTimeAfter(v time.Time) *ListProvisionedModelThroughputsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListProvisionedModelThroughputsInput) SetCreationTimeBefore(v time.Time) *ListProvisionedModelThroughputsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProvisionedModelThroughputsInput) SetMaxResults(v int64) *ListProvisionedModelThroughputsInput {
	s.MaxResults = &v
	return s
}

// SetModelArnEquals sets the ModelArnEquals field's value.
func (s *ListProvisionedModelThroughputsInput) SetModelArnEquals(v string) *ListProvisionedModelThroughputsInput {
	s.ModelArnEquals = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListProvisionedModelThroughputsInput) SetNameContains(v string) *ListProvisionedModelThroughputsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProvisionedModelThroughputsInput) SetNextToken(v string) *ListProvisionedModelThroughputsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListProvisionedModelThroughputsInput) SetSortBy(v string) *ListProvisionedModelThroughputsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListProvisionedModelThroughputsInput) SetSortOrder(v string) *ListProvisionedModelThroughputsInput {
	s.SortOrder = &v
	return s
}

// SetStatusEquals sets the StatusEquals field's value.
func (s *ListProvisionedModelThroughputsInput) SetStatusEquals(v string) *ListProvisionedModelThroughputsInput {
	s.StatusEquals = &v
	return s
}

type ListProvisionedModelThroughputsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more results than the number you specified in the maxResults
	// field, this value is returned. To see the next batch of results, include
	// this value in the nextToken field in another list request.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of summaries, one for each Provisioned Throughput in the response.
	ProvisionedModelSummaries []*ProvisionedModelSummary `locationName:"provisionedModelSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProvisionedModelThroughputsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProvisionedModelThroughputsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProvisionedModelThroughputsOutput) SetNextToken(v string) *ListProvisionedModelThroughputsOutput {
	s.NextToken = &v
	return s
}

// SetProvisionedModelSummaries sets the ProvisionedModelSummaries field's value.
func (s *ListProvisionedModelThroughputsOutput) SetProvisionedModelSummaries(v []*ProvisionedModelSummary) *ListProvisionedModelThroughputsOutput {
	s.ProvisionedModelSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An array of the tags associated with this resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Configuration fields for invocation logging.
type LoggingConfig struct {
	_ struct{} `type:"structure"`

	// CloudWatch logging configuration.
	CloudWatchConfig *CloudWatchConfig `locationName:"cloudWatchConfig" type:"structure"`

	// Set to include embeddings data in the log delivery.
	EmbeddingDataDeliveryEnabled *bool `locationName:"embeddingDataDeliveryEnabled" type:"boolean"`

	// Set to include image data in the log delivery.
	ImageDataDeliveryEnabled *bool `locationName:"imageDataDeliveryEnabled" type:"boolean"`

	// S3 configuration for storing log data.
	S3Config *S3Config `locationName:"s3Config" type:"structure"`

	// Set to include text data in the log delivery.
	TextDataDeliveryEnabled *bool `locationName:"textDataDeliveryEnabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingConfig"}
	if s.CloudWatchConfig != nil {
		if err := s.CloudWatchConfig.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Config != nil {
		if err := s.S3Config.Validate(); err != nil {
			invalidParams.AddNested("S3Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchConfig sets the CloudWatchConfig field's value.
func (s *LoggingConfig) SetCloudWatchConfig(v *CloudWatchConfig) *LoggingConfig {
	s.CloudWatchConfig = v
	return s
}

// SetEmbeddingDataDeliveryEnabled sets the EmbeddingDataDeliveryEnabled field's value.
func (s *LoggingConfig) SetEmbeddingDataDeliveryEnabled(v bool) *LoggingConfig {
	s.EmbeddingDataDeliveryEnabled = &v
	return s
}

// SetImageDataDeliveryEnabled sets the ImageDataDeliveryEnabled field's value.
func (s *LoggingConfig) SetImageDataDeliveryEnabled(v bool) *LoggingConfig {
	s.ImageDataDeliveryEnabled = &v
	return s
}

// SetS3Config sets the S3Config field's value.
func (s *LoggingConfig) SetS3Config(v *S3Config) *LoggingConfig {
	s.S3Config = v
	return s
}

// SetTextDataDeliveryEnabled sets the TextDataDeliveryEnabled field's value.
func (s *LoggingConfig) SetTextDataDeliveryEnabled(v bool) *LoggingConfig {
	s.TextDataDeliveryEnabled = &v
	return s
}

// Information about one customization job
type ModelCustomizationJobSummary struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the base model.
	//
	// BaseModelArn is a required field
	BaseModelArn *string `locationName:"baseModelArn" min:"20" type:"string" required:"true"`

	// Creation time of the custom model.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Amazon Resource Name (ARN) of the custom model.
	CustomModelArn *string `locationName:"customModelArn" min:"20" type:"string"`

	// Name of the custom model.
	CustomModelName *string `locationName:"customModelName" min:"1" type:"string"`

	// Specifies whether to carry out continued pre-training of a model or whether
	// to fine-tune it. For more information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html).
	CustomizationType *string `locationName:"customizationType" type:"string" enum:"CustomizationType"`

	// Time that the customization job ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// Amazon Resource Name (ARN) of the customization job.
	//
	// JobArn is a required field
	JobArn *string `locationName:"jobArn" type:"string" required:"true"`

	// Name of the customization job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// Time that the customization job was last modified.
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp" timestampFormat:"iso8601"`

	// Status of the customization job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ModelCustomizationJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelCustomizationJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelCustomizationJobSummary) GoString() string {
	return s.String()
}

// SetBaseModelArn sets the BaseModelArn field's value.
func (s *ModelCustomizationJobSummary) SetBaseModelArn(v string) *ModelCustomizationJobSummary {
	s.BaseModelArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ModelCustomizationJobSummary) SetCreationTime(v time.Time) *ModelCustomizationJobSummary {
	s.CreationTime = &v
	return s
}

// SetCustomModelArn sets the CustomModelArn field's value.
func (s *ModelCustomizationJobSummary) SetCustomModelArn(v string) *ModelCustomizationJobSummary {
	s.CustomModelArn = &v
	return s
}

// SetCustomModelName sets the CustomModelName field's value.
func (s *ModelCustomizationJobSummary) SetCustomModelName(v string) *ModelCustomizationJobSummary {
	s.CustomModelName = &v
	return s
}

// SetCustomizationType sets the CustomizationType field's value.
func (s *ModelCustomizationJobSummary) SetCustomizationType(v string) *ModelCustomizationJobSummary {
	s.CustomizationType = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ModelCustomizationJobSummary) SetEndTime(v time.Time) *ModelCustomizationJobSummary {
	s.EndTime = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *ModelCustomizationJobSummary) SetJobArn(v string) *ModelCustomizationJobSummary {
	s.JobArn = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *ModelCustomizationJobSummary) SetJobName(v string) *ModelCustomizationJobSummary {
	s.JobName = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *ModelCustomizationJobSummary) SetLastModifiedTime(v time.Time) *ModelCustomizationJobSummary {
	s.LastModifiedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ModelCustomizationJobSummary) SetStatus(v string) *ModelCustomizationJobSummary {
	s.Status = &v
	return s
}

// S3 Location of the output data.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The S3 URI where the output data is stored.
	//
	// S3Uri is a required field
	S3Uri *string `locationName:"s3Uri" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}
	if s.S3Uri != nil && len(*s.S3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *OutputDataConfig) SetS3Uri(v string) *OutputDataConfig {
	s.S3Uri = &v
	return s
}

// A summary of information about a Provisioned Throughput.
//
// This data type is used in the following API operations:
//
//   - ListProvisionedThroughputs response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListProvisionedModelThroughputs.html#API_ListProvisionedModelThroughputs_ResponseSyntax)
type ProvisionedModelSummary struct {
	_ struct{} `type:"structure"`

	// The duration for which the Provisioned Throughput was committed.
	CommitmentDuration *string `locationName:"commitmentDuration" type:"string" enum:"CommitmentDuration"`

	// The timestamp for when the commitment term of the Provisioned Throughput
	// expires.
	CommitmentExpirationTime *time.Time `locationName:"commitmentExpirationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The time that the Provisioned Throughput was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the model requested to be associated to
	// this Provisioned Throughput. This value differs from the modelArn if updating
	// hasn't completed.
	//
	// DesiredModelArn is a required field
	DesiredModelArn *string `locationName:"desiredModelArn" min:"20" type:"string" required:"true"`

	// The number of model units that was requested to be allocated to the Provisioned
	// Throughput.
	//
	// DesiredModelUnits is a required field
	DesiredModelUnits *int64 `locationName:"desiredModelUnits" min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the base model for which the Provisioned
	// Throughput was created, or of the base model that the custom model for which
	// the Provisioned Throughput was created was customized.
	//
	// FoundationModelArn is a required field
	FoundationModelArn *string `locationName:"foundationModelArn" type:"string" required:"true"`

	// The time that the Provisioned Throughput was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the model associated with the Provisioned
	// Throughput.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" min:"20" type:"string" required:"true"`

	// The number of model units allocated to the Provisioned Throughput.
	//
	// ModelUnits is a required field
	ModelUnits *int64 `locationName:"modelUnits" min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the Provisioned Throughput.
	//
	// ProvisionedModelArn is a required field
	ProvisionedModelArn *string `locationName:"provisionedModelArn" type:"string" required:"true"`

	// The name of the Provisioned Throughput.
	//
	// ProvisionedModelName is a required field
	ProvisionedModelName *string `locationName:"provisionedModelName" min:"1" type:"string" required:"true"`

	// The status of the Provisioned Throughput.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ProvisionedModelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedModelSummary) GoString() string {
	return s.String()
}

// SetCommitmentDuration sets the CommitmentDuration field's value.
func (s *ProvisionedModelSummary) SetCommitmentDuration(v string) *ProvisionedModelSummary {
	s.CommitmentDuration = &v
	return s
}

// SetCommitmentExpirationTime sets the CommitmentExpirationTime field's value.
func (s *ProvisionedModelSummary) SetCommitmentExpirationTime(v time.Time) *ProvisionedModelSummary {
	s.CommitmentExpirationTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ProvisionedModelSummary) SetCreationTime(v time.Time) *ProvisionedModelSummary {
	s.CreationTime = &v
	return s
}

// SetDesiredModelArn sets the DesiredModelArn field's value.
func (s *ProvisionedModelSummary) SetDesiredModelArn(v string) *ProvisionedModelSummary {
	s.DesiredModelArn = &v
	return s
}

// SetDesiredModelUnits sets the DesiredModelUnits field's value.
func (s *ProvisionedModelSummary) SetDesiredModelUnits(v int64) *ProvisionedModelSummary {
	s.DesiredModelUnits = &v
	return s
}

// SetFoundationModelArn sets the FoundationModelArn field's value.
func (s *ProvisionedModelSummary) SetFoundationModelArn(v string) *ProvisionedModelSummary {
	s.FoundationModelArn = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *ProvisionedModelSummary) SetLastModifiedTime(v time.Time) *ProvisionedModelSummary {
	s.LastModifiedTime = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *ProvisionedModelSummary) SetModelArn(v string) *ProvisionedModelSummary {
	s.ModelArn = &v
	return s
}

// SetModelUnits sets the ModelUnits field's value.
func (s *ProvisionedModelSummary) SetModelUnits(v int64) *ProvisionedModelSummary {
	s.ModelUnits = &v
	return s
}

// SetProvisionedModelArn sets the ProvisionedModelArn field's value.
func (s *ProvisionedModelSummary) SetProvisionedModelArn(v string) *ProvisionedModelSummary {
	s.ProvisionedModelArn = &v
	return s
}

// SetProvisionedModelName sets the ProvisionedModelName field's value.
func (s *ProvisionedModelSummary) SetProvisionedModelName(v string) *ProvisionedModelSummary {
	s.ProvisionedModelName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProvisionedModelSummary) SetStatus(v string) *ProvisionedModelSummary {
	s.Status = &v
	return s
}

type PutModelInvocationLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The logging configuration values to set.
	//
	// LoggingConfig is a required field
	LoggingConfig *LoggingConfig `locationName:"loggingConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutModelInvocationLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutModelInvocationLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutModelInvocationLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutModelInvocationLoggingConfigurationInput"}
	if s.LoggingConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggingConfig"))
	}
	if s.LoggingConfig != nil {
		if err := s.LoggingConfig.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingConfig sets the LoggingConfig field's value.
func (s *PutModelInvocationLoggingConfigurationInput) SetLoggingConfig(v *LoggingConfig) *PutModelInvocationLoggingConfigurationInput {
	s.LoggingConfig = v
	return s
}

type PutModelInvocationLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutModelInvocationLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutModelInvocationLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// The specified resource Amazon Resource Name (ARN) was not found. Check the
// Amazon Resource Name (ARN) and try your request again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// S3 configuration for storing log data.
type S3Config struct {
	_ struct{} `type:"structure"`

	// S3 bucket name.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`

	// S3 prefix.
	KeyPrefix *string `locationName:"keyPrefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Config) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Config) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Config) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Config"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Config) SetBucketName(v string) *S3Config {
	s.BucketName = &v
	return s
}

// SetKeyPrefix sets the KeyPrefix field's value.
func (s *S3Config) SetKeyPrefix(v string) *S3Config {
	s.KeyPrefix = &v
	return s
}

// The number of requests exceeds the service quota. Resubmit your request later.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StopEvaluationJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the model evaluation job you want to stop.
	//
	// JobIdentifier is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StopEvaluationJobInput's
	// String and GoString methods.
	//
	// JobIdentifier is a required field
	JobIdentifier *string `location:"uri" locationName:"jobIdentifier" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEvaluationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEvaluationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopEvaluationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopEvaluationJobInput"}
	if s.JobIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("JobIdentifier"))
	}
	if s.JobIdentifier != nil && len(*s.JobIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobIdentifier sets the JobIdentifier field's value.
func (s *StopEvaluationJobInput) SetJobIdentifier(v string) *StopEvaluationJobInput {
	s.JobIdentifier = &v
	return s
}

type StopEvaluationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEvaluationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEvaluationJobOutput) GoString() string {
	return s.String()
}

type StopModelCustomizationJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Job identifier of the job to stop.
	//
	// JobIdentifier is a required field
	JobIdentifier *string `location:"uri" locationName:"jobIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopModelCustomizationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopModelCustomizationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopModelCustomizationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopModelCustomizationJobInput"}
	if s.JobIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("JobIdentifier"))
	}
	if s.JobIdentifier != nil && len(*s.JobIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobIdentifier sets the JobIdentifier field's value.
func (s *StopModelCustomizationJobInput) SetJobIdentifier(v string) *StopModelCustomizationJobInput {
	s.JobIdentifier = &v
	return s
}

type StopModelCustomizationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopModelCustomizationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopModelCustomizationJobOutput) GoString() string {
	return s.String()
}

// Definition of the key/value pair for a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// Key for the tag.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// Value for the tag.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to tag.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"20" type:"string" required:"true"`

	// Tags to associate with the resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The number of requests exceeds the limit. Resubmit your request later.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request contains more tags than can be associated with a resource (50
// tags per resource). The maximum number of tags includes both existing tags
// and those included in your current request.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The name of the resource with too many tags.
	ResourceName *string `locationName:"resourceName" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// S3 Location of the training data.
type TrainingDataConfig struct {
	_ struct{} `type:"structure"`

	// The S3 URI where the training data is stored.
	//
	// S3Uri is a required field
	S3Uri *string `locationName:"s3Uri" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrainingDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrainingDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}
	if s.S3Uri != nil && len(*s.S3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *TrainingDataConfig) SetS3Uri(v string) *TrainingDataConfig {
	s.S3Uri = &v
	return s
}

// Metrics associated with the custom job.
type TrainingMetrics struct {
	_ struct{} `type:"structure"`

	// Loss metric associated with the custom job.
	TrainingLoss *float64 `locationName:"trainingLoss" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingMetrics) GoString() string {
	return s.String()
}

// SetTrainingLoss sets the TrainingLoss field's value.
func (s *TrainingMetrics) SetTrainingLoss(v float64) *TrainingMetrics {
	s.TrainingLoss = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to untag.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"20" type:"string" required:"true"`

	// Tag keys of the tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateGuardrailInput struct {
	_ struct{} `type:"structure"`

	// The message to return when the guardrail blocks a prompt.
	//
	// BlockedInputMessaging is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateGuardrailInput's
	// String and GoString methods.
	//
	// BlockedInputMessaging is a required field
	BlockedInputMessaging *string `locationName:"blockedInputMessaging" min:"1" type:"string" required:"true" sensitive:"true"`

	// The message to return when the guardrail blocks a model response.
	//
	// BlockedOutputsMessaging is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateGuardrailInput's
	// String and GoString methods.
	//
	// BlockedOutputsMessaging is a required field
	BlockedOutputsMessaging *string `locationName:"blockedOutputsMessaging" min:"1" type:"string" required:"true" sensitive:"true"`

	// The content policy to configure for the guardrail.
	ContentPolicyConfig *GuardrailContentPolicyConfig `locationName:"contentPolicyConfig" type:"structure"`

	// The contextual grounding policy configuration used to update a guardrail.
	ContextualGroundingPolicyConfig *GuardrailContextualGroundingPolicyConfig `locationName:"contextualGroundingPolicyConfig" type:"structure"`

	// A description of the guardrail.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateGuardrailInput's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The unique identifier of the guardrail. This can be an ID or the ARN.
	//
	// GuardrailIdentifier is a required field
	GuardrailIdentifier *string `location:"uri" locationName:"guardrailIdentifier" type:"string" required:"true"`

	// The ARN of the KMS key with which to encrypt the guardrail.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// A name for the guardrail.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateGuardrailInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The sensitive information policy to configure for the guardrail.
	SensitiveInformationPolicyConfig *GuardrailSensitiveInformationPolicyConfig `locationName:"sensitiveInformationPolicyConfig" type:"structure"`

	// The topic policy to configure for the guardrail.
	TopicPolicyConfig *GuardrailTopicPolicyConfig `locationName:"topicPolicyConfig" type:"structure"`

	// The word policy to configure for the guardrail.
	WordPolicyConfig *GuardrailWordPolicyConfig `locationName:"wordPolicyConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGuardrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGuardrailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGuardrailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGuardrailInput"}
	if s.BlockedInputMessaging == nil {
		invalidParams.Add(request.NewErrParamRequired("BlockedInputMessaging"))
	}
	if s.BlockedInputMessaging != nil && len(*s.BlockedInputMessaging) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BlockedInputMessaging", 1))
	}
	if s.BlockedOutputsMessaging == nil {
		invalidParams.Add(request.NewErrParamRequired("BlockedOutputsMessaging"))
	}
	if s.BlockedOutputsMessaging != nil && len(*s.BlockedOutputsMessaging) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BlockedOutputsMessaging", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.GuardrailIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GuardrailIdentifier"))
	}
	if s.GuardrailIdentifier != nil && len(*s.GuardrailIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GuardrailIdentifier", 1))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ContentPolicyConfig != nil {
		if err := s.ContentPolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("ContentPolicyConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ContextualGroundingPolicyConfig != nil {
		if err := s.ContextualGroundingPolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("ContextualGroundingPolicyConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.SensitiveInformationPolicyConfig != nil {
		if err := s.SensitiveInformationPolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("SensitiveInformationPolicyConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.TopicPolicyConfig != nil {
		if err := s.TopicPolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("TopicPolicyConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.WordPolicyConfig != nil {
		if err := s.WordPolicyConfig.Validate(); err != nil {
			invalidParams.AddNested("WordPolicyConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockedInputMessaging sets the BlockedInputMessaging field's value.
func (s *UpdateGuardrailInput) SetBlockedInputMessaging(v string) *UpdateGuardrailInput {
	s.BlockedInputMessaging = &v
	return s
}

// SetBlockedOutputsMessaging sets the BlockedOutputsMessaging field's value.
func (s *UpdateGuardrailInput) SetBlockedOutputsMessaging(v string) *UpdateGuardrailInput {
	s.BlockedOutputsMessaging = &v
	return s
}

// SetContentPolicyConfig sets the ContentPolicyConfig field's value.
func (s *UpdateGuardrailInput) SetContentPolicyConfig(v *GuardrailContentPolicyConfig) *UpdateGuardrailInput {
	s.ContentPolicyConfig = v
	return s
}

// SetContextualGroundingPolicyConfig sets the ContextualGroundingPolicyConfig field's value.
func (s *UpdateGuardrailInput) SetContextualGroundingPolicyConfig(v *GuardrailContextualGroundingPolicyConfig) *UpdateGuardrailInput {
	s.ContextualGroundingPolicyConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateGuardrailInput) SetDescription(v string) *UpdateGuardrailInput {
	s.Description = &v
	return s
}

// SetGuardrailIdentifier sets the GuardrailIdentifier field's value.
func (s *UpdateGuardrailInput) SetGuardrailIdentifier(v string) *UpdateGuardrailInput {
	s.GuardrailIdentifier = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateGuardrailInput) SetKmsKeyId(v string) *UpdateGuardrailInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateGuardrailInput) SetName(v string) *UpdateGuardrailInput {
	s.Name = &v
	return s
}

// SetSensitiveInformationPolicyConfig sets the SensitiveInformationPolicyConfig field's value.
func (s *UpdateGuardrailInput) SetSensitiveInformationPolicyConfig(v *GuardrailSensitiveInformationPolicyConfig) *UpdateGuardrailInput {
	s.SensitiveInformationPolicyConfig = v
	return s
}

// SetTopicPolicyConfig sets the TopicPolicyConfig field's value.
func (s *UpdateGuardrailInput) SetTopicPolicyConfig(v *GuardrailTopicPolicyConfig) *UpdateGuardrailInput {
	s.TopicPolicyConfig = v
	return s
}

// SetWordPolicyConfig sets the WordPolicyConfig field's value.
func (s *UpdateGuardrailInput) SetWordPolicyConfig(v *GuardrailWordPolicyConfig) *UpdateGuardrailInput {
	s.WordPolicyConfig = v
	return s
}

type UpdateGuardrailOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the guardrail.
	//
	// GuardrailArn is a required field
	GuardrailArn *string `locationName:"guardrailArn" type:"string" required:"true"`

	// The unique identifier of the guardrail
	//
	// GuardrailId is a required field
	GuardrailId *string `locationName:"guardrailId" type:"string" required:"true"`

	// The date and time at which the guardrail was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The version of the guardrail.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGuardrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGuardrailOutput) GoString() string {
	return s.String()
}

// SetGuardrailArn sets the GuardrailArn field's value.
func (s *UpdateGuardrailOutput) SetGuardrailArn(v string) *UpdateGuardrailOutput {
	s.GuardrailArn = &v
	return s
}

// SetGuardrailId sets the GuardrailId field's value.
func (s *UpdateGuardrailOutput) SetGuardrailId(v string) *UpdateGuardrailOutput {
	s.GuardrailId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateGuardrailOutput) SetUpdatedAt(v time.Time) *UpdateGuardrailOutput {
	s.UpdatedAt = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateGuardrailOutput) SetVersion(v string) *UpdateGuardrailOutput {
	s.Version = &v
	return s
}

type UpdateProvisionedModelThroughputInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new model to associate with this Provisioned
	// Throughput. You can't specify this field if this Provisioned Throughput is
	// associated with a base model.
	//
	// If this Provisioned Throughput is associated with a custom model, you can
	// specify one of the following options:
	//
	//    * The base model from which the custom model was customized.
	//
	//    * Another custom model that was customized from the same base model as
	//    the custom model.
	DesiredModelId *string `locationName:"desiredModelId" min:"1" type:"string"`

	// The new name for this Provisioned Throughput.
	DesiredProvisionedModelName *string `locationName:"desiredProvisionedModelName" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) or name of the Provisioned Throughput to update.
	//
	// ProvisionedModelId is a required field
	ProvisionedModelId *string `location:"uri" locationName:"provisionedModelId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProvisionedModelThroughputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProvisionedModelThroughputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProvisionedModelThroughputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProvisionedModelThroughputInput"}
	if s.DesiredModelId != nil && len(*s.DesiredModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DesiredModelId", 1))
	}
	if s.DesiredProvisionedModelName != nil && len(*s.DesiredProvisionedModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DesiredProvisionedModelName", 1))
	}
	if s.ProvisionedModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedModelId"))
	}
	if s.ProvisionedModelId != nil && len(*s.ProvisionedModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredModelId sets the DesiredModelId field's value.
func (s *UpdateProvisionedModelThroughputInput) SetDesiredModelId(v string) *UpdateProvisionedModelThroughputInput {
	s.DesiredModelId = &v
	return s
}

// SetDesiredProvisionedModelName sets the DesiredProvisionedModelName field's value.
func (s *UpdateProvisionedModelThroughputInput) SetDesiredProvisionedModelName(v string) *UpdateProvisionedModelThroughputInput {
	s.DesiredProvisionedModelName = &v
	return s
}

// SetProvisionedModelId sets the ProvisionedModelId field's value.
func (s *UpdateProvisionedModelThroughputInput) SetProvisionedModelId(v string) *UpdateProvisionedModelThroughputInput {
	s.ProvisionedModelId = &v
	return s
}

type UpdateProvisionedModelThroughputOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProvisionedModelThroughputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProvisionedModelThroughputOutput) GoString() string {
	return s.String()
}

// Array of up to 10 validators.
type ValidationDataConfig struct {
	_ struct{} `type:"structure"`

	// Information about the validators.
	//
	// Validators is a required field
	Validators []*Validator `locationName:"validators" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidationDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidationDataConfig"}
	if s.Validators == nil {
		invalidParams.Add(request.NewErrParamRequired("Validators"))
	}
	if s.Validators != nil {
		for i, v := range s.Validators {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Validators", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValidators sets the Validators field's value.
func (s *ValidationDataConfig) SetValidators(v []*Validator) *ValidationDataConfig {
	s.Validators = v
	return s
}

// Input validation failed. Check your request parameters and retry the request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a validator.
type Validator struct {
	_ struct{} `type:"structure"`

	// The S3 URI where the validation data is stored.
	//
	// S3Uri is a required field
	S3Uri *string `locationName:"s3Uri" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Validator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Validator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Validator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Validator"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}
	if s.S3Uri != nil && len(*s.S3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *Validator) SetS3Uri(v string) *Validator {
	s.S3Uri = &v
	return s
}

// The metric for the validator.
type ValidatorMetric struct {
	_ struct{} `type:"structure"`

	// The validation loss associated with this validator.
	ValidationLoss *float64 `locationName:"validationLoss" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatorMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatorMetric) GoString() string {
	return s.String()
}

// SetValidationLoss sets the ValidationLoss field's value.
func (s *ValidatorMetric) SetValidationLoss(v float64) *ValidatorMetric {
	s.ValidationLoss = &v
	return s
}

// VPC configuration.
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// VPC configuration security group Ids.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list" required:"true"`

	// VPC configuration subnets.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfig"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfig) SetSecurityGroupIds(v []*string) *VpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfig) SetSubnetIds(v []*string) *VpcConfig {
	s.SubnetIds = v
	return s
}

const (
	// CommitmentDurationOneMonth is a CommitmentDuration enum value
	CommitmentDurationOneMonth = "OneMonth"

	// CommitmentDurationSixMonths is a CommitmentDuration enum value
	CommitmentDurationSixMonths = "SixMonths"
)

// CommitmentDuration_Values returns all elements of the CommitmentDuration enum
func CommitmentDuration_Values() []string {
	return []string{
		CommitmentDurationOneMonth,
		CommitmentDurationSixMonths,
	}
}

const (
	// CustomizationTypeFineTuning is a CustomizationType enum value
	CustomizationTypeFineTuning = "FINE_TUNING"

	// CustomizationTypeContinuedPreTraining is a CustomizationType enum value
	CustomizationTypeContinuedPreTraining = "CONTINUED_PRE_TRAINING"
)

// CustomizationType_Values returns all elements of the CustomizationType enum
func CustomizationType_Values() []string {
	return []string{
		CustomizationTypeFineTuning,
		CustomizationTypeContinuedPreTraining,
	}
}

const (
	// EvaluationJobStatusInProgress is a EvaluationJobStatus enum value
	EvaluationJobStatusInProgress = "InProgress"

	// EvaluationJobStatusCompleted is a EvaluationJobStatus enum value
	EvaluationJobStatusCompleted = "Completed"

	// EvaluationJobStatusFailed is a EvaluationJobStatus enum value
	EvaluationJobStatusFailed = "Failed"

	// EvaluationJobStatusStopping is a EvaluationJobStatus enum value
	EvaluationJobStatusStopping = "Stopping"

	// EvaluationJobStatusStopped is a EvaluationJobStatus enum value
	EvaluationJobStatusStopped = "Stopped"
)

// EvaluationJobStatus_Values returns all elements of the EvaluationJobStatus enum
func EvaluationJobStatus_Values() []string {
	return []string{
		EvaluationJobStatusInProgress,
		EvaluationJobStatusCompleted,
		EvaluationJobStatusFailed,
		EvaluationJobStatusStopping,
		EvaluationJobStatusStopped,
	}
}

const (
	// EvaluationJobTypeHuman is a EvaluationJobType enum value
	EvaluationJobTypeHuman = "Human"

	// EvaluationJobTypeAutomated is a EvaluationJobType enum value
	EvaluationJobTypeAutomated = "Automated"
)

// EvaluationJobType_Values returns all elements of the EvaluationJobType enum
func EvaluationJobType_Values() []string {
	return []string{
		EvaluationJobTypeHuman,
		EvaluationJobTypeAutomated,
	}
}

const (
	// EvaluationTaskTypeSummarization is a EvaluationTaskType enum value
	EvaluationTaskTypeSummarization = "Summarization"

	// EvaluationTaskTypeClassification is a EvaluationTaskType enum value
	EvaluationTaskTypeClassification = "Classification"

	// EvaluationTaskTypeQuestionAndAnswer is a EvaluationTaskType enum value
	EvaluationTaskTypeQuestionAndAnswer = "QuestionAndAnswer"

	// EvaluationTaskTypeGeneration is a EvaluationTaskType enum value
	EvaluationTaskTypeGeneration = "Generation"

	// EvaluationTaskTypeCustom is a EvaluationTaskType enum value
	EvaluationTaskTypeCustom = "Custom"
)

// EvaluationTaskType_Values returns all elements of the EvaluationTaskType enum
func EvaluationTaskType_Values() []string {
	return []string{
		EvaluationTaskTypeSummarization,
		EvaluationTaskTypeClassification,
		EvaluationTaskTypeQuestionAndAnswer,
		EvaluationTaskTypeGeneration,
		EvaluationTaskTypeCustom,
	}
}

const (
	// FineTuningJobStatusInProgress is a FineTuningJobStatus enum value
	FineTuningJobStatusInProgress = "InProgress"

	// FineTuningJobStatusCompleted is a FineTuningJobStatus enum value
	FineTuningJobStatusCompleted = "Completed"

	// FineTuningJobStatusFailed is a FineTuningJobStatus enum value
	FineTuningJobStatusFailed = "Failed"

	// FineTuningJobStatusStopping is a FineTuningJobStatus enum value
	FineTuningJobStatusStopping = "Stopping"

	// FineTuningJobStatusStopped is a FineTuningJobStatus enum value
	FineTuningJobStatusStopped = "Stopped"
)

// FineTuningJobStatus_Values returns all elements of the FineTuningJobStatus enum
func FineTuningJobStatus_Values() []string {
	return []string{
		FineTuningJobStatusInProgress,
		FineTuningJobStatusCompleted,
		FineTuningJobStatusFailed,
		FineTuningJobStatusStopping,
		FineTuningJobStatusStopped,
	}
}

const (
	// FoundationModelLifecycleStatusActive is a FoundationModelLifecycleStatus enum value
	FoundationModelLifecycleStatusActive = "ACTIVE"

	// FoundationModelLifecycleStatusLegacy is a FoundationModelLifecycleStatus enum value
	FoundationModelLifecycleStatusLegacy = "LEGACY"
)

// FoundationModelLifecycleStatus_Values returns all elements of the FoundationModelLifecycleStatus enum
func FoundationModelLifecycleStatus_Values() []string {
	return []string{
		FoundationModelLifecycleStatusActive,
		FoundationModelLifecycleStatusLegacy,
	}
}

const (
	// GuardrailContentFilterTypeSexual is a GuardrailContentFilterType enum value
	GuardrailContentFilterTypeSexual = "SEXUAL"

	// GuardrailContentFilterTypeViolence is a GuardrailContentFilterType enum value
	GuardrailContentFilterTypeViolence = "VIOLENCE"

	// GuardrailContentFilterTypeHate is a GuardrailContentFilterType enum value
	GuardrailContentFilterTypeHate = "HATE"

	// GuardrailContentFilterTypeInsults is a GuardrailContentFilterType enum value
	GuardrailContentFilterTypeInsults = "INSULTS"

	// GuardrailContentFilterTypeMisconduct is a GuardrailContentFilterType enum value
	GuardrailContentFilterTypeMisconduct = "MISCONDUCT"

	// GuardrailContentFilterTypePromptAttack is a GuardrailContentFilterType enum value
	GuardrailContentFilterTypePromptAttack = "PROMPT_ATTACK"
)

// GuardrailContentFilterType_Values returns all elements of the GuardrailContentFilterType enum
func GuardrailContentFilterType_Values() []string {
	return []string{
		GuardrailContentFilterTypeSexual,
		GuardrailContentFilterTypeViolence,
		GuardrailContentFilterTypeHate,
		GuardrailContentFilterTypeInsults,
		GuardrailContentFilterTypeMisconduct,
		GuardrailContentFilterTypePromptAttack,
	}
}

const (
	// GuardrailContextualGroundingFilterTypeGrounding is a GuardrailContextualGroundingFilterType enum value
	GuardrailContextualGroundingFilterTypeGrounding = "GROUNDING"

	// GuardrailContextualGroundingFilterTypeRelevance is a GuardrailContextualGroundingFilterType enum value
	GuardrailContextualGroundingFilterTypeRelevance = "RELEVANCE"
)

// GuardrailContextualGroundingFilterType_Values returns all elements of the GuardrailContextualGroundingFilterType enum
func GuardrailContextualGroundingFilterType_Values() []string {
	return []string{
		GuardrailContextualGroundingFilterTypeGrounding,
		GuardrailContextualGroundingFilterTypeRelevance,
	}
}

const (
	// GuardrailFilterStrengthNone is a GuardrailFilterStrength enum value
	GuardrailFilterStrengthNone = "NONE"

	// GuardrailFilterStrengthLow is a GuardrailFilterStrength enum value
	GuardrailFilterStrengthLow = "LOW"

	// GuardrailFilterStrengthMedium is a GuardrailFilterStrength enum value
	GuardrailFilterStrengthMedium = "MEDIUM"

	// GuardrailFilterStrengthHigh is a GuardrailFilterStrength enum value
	GuardrailFilterStrengthHigh = "HIGH"
)

// GuardrailFilterStrength_Values returns all elements of the GuardrailFilterStrength enum
func GuardrailFilterStrength_Values() []string {
	return []string{
		GuardrailFilterStrengthNone,
		GuardrailFilterStrengthLow,
		GuardrailFilterStrengthMedium,
		GuardrailFilterStrengthHigh,
	}
}

const (
	// GuardrailManagedWordsTypeProfanity is a GuardrailManagedWordsType enum value
	GuardrailManagedWordsTypeProfanity = "PROFANITY"
)

// GuardrailManagedWordsType_Values returns all elements of the GuardrailManagedWordsType enum
func GuardrailManagedWordsType_Values() []string {
	return []string{
		GuardrailManagedWordsTypeProfanity,
	}
}

const (
	// GuardrailPiiEntityTypeAddress is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeAddress = "ADDRESS"

	// GuardrailPiiEntityTypeAge is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeAge = "AGE"

	// GuardrailPiiEntityTypeAwsAccessKey is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeAwsAccessKey = "AWS_ACCESS_KEY"

	// GuardrailPiiEntityTypeAwsSecretKey is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeAwsSecretKey = "AWS_SECRET_KEY"

	// GuardrailPiiEntityTypeCaHealthNumber is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeCaHealthNumber = "CA_HEALTH_NUMBER"

	// GuardrailPiiEntityTypeCaSocialInsuranceNumber is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeCaSocialInsuranceNumber = "CA_SOCIAL_INSURANCE_NUMBER"

	// GuardrailPiiEntityTypeCreditDebitCardCvv is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeCreditDebitCardCvv = "CREDIT_DEBIT_CARD_CVV"

	// GuardrailPiiEntityTypeCreditDebitCardExpiry is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeCreditDebitCardExpiry = "CREDIT_DEBIT_CARD_EXPIRY"

	// GuardrailPiiEntityTypeCreditDebitCardNumber is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeCreditDebitCardNumber = "CREDIT_DEBIT_CARD_NUMBER"

	// GuardrailPiiEntityTypeDriverId is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeDriverId = "DRIVER_ID"

	// GuardrailPiiEntityTypeEmail is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeEmail = "EMAIL"

	// GuardrailPiiEntityTypeInternationalBankAccountNumber is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeInternationalBankAccountNumber = "INTERNATIONAL_BANK_ACCOUNT_NUMBER"

	// GuardrailPiiEntityTypeIpAddress is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeIpAddress = "IP_ADDRESS"

	// GuardrailPiiEntityTypeLicensePlate is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeLicensePlate = "LICENSE_PLATE"

	// GuardrailPiiEntityTypeMacAddress is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeMacAddress = "MAC_ADDRESS"

	// GuardrailPiiEntityTypeName is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeName = "NAME"

	// GuardrailPiiEntityTypePassword is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypePassword = "PASSWORD"

	// GuardrailPiiEntityTypePhone is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypePhone = "PHONE"

	// GuardrailPiiEntityTypePin is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypePin = "PIN"

	// GuardrailPiiEntityTypeSwiftCode is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeSwiftCode = "SWIFT_CODE"

	// GuardrailPiiEntityTypeUkNationalHealthServiceNumber is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeUkNationalHealthServiceNumber = "UK_NATIONAL_HEALTH_SERVICE_NUMBER"

	// GuardrailPiiEntityTypeUkNationalInsuranceNumber is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeUkNationalInsuranceNumber = "UK_NATIONAL_INSURANCE_NUMBER"

	// GuardrailPiiEntityTypeUkUniqueTaxpayerReferenceNumber is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeUkUniqueTaxpayerReferenceNumber = "UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER"

	// GuardrailPiiEntityTypeUrl is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeUrl = "URL"

	// GuardrailPiiEntityTypeUsername is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeUsername = "USERNAME"

	// GuardrailPiiEntityTypeUsBankAccountNumber is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeUsBankAccountNumber = "US_BANK_ACCOUNT_NUMBER"

	// GuardrailPiiEntityTypeUsBankRoutingNumber is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeUsBankRoutingNumber = "US_BANK_ROUTING_NUMBER"

	// GuardrailPiiEntityTypeUsIndividualTaxIdentificationNumber is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeUsIndividualTaxIdentificationNumber = "US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER"

	// GuardrailPiiEntityTypeUsPassportNumber is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeUsPassportNumber = "US_PASSPORT_NUMBER"

	// GuardrailPiiEntityTypeUsSocialSecurityNumber is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeUsSocialSecurityNumber = "US_SOCIAL_SECURITY_NUMBER"

	// GuardrailPiiEntityTypeVehicleIdentificationNumber is a GuardrailPiiEntityType enum value
	GuardrailPiiEntityTypeVehicleIdentificationNumber = "VEHICLE_IDENTIFICATION_NUMBER"
)

// GuardrailPiiEntityType_Values returns all elements of the GuardrailPiiEntityType enum
func GuardrailPiiEntityType_Values() []string {
	return []string{
		GuardrailPiiEntityTypeAddress,
		GuardrailPiiEntityTypeAge,
		GuardrailPiiEntityTypeAwsAccessKey,
		GuardrailPiiEntityTypeAwsSecretKey,
		GuardrailPiiEntityTypeCaHealthNumber,
		GuardrailPiiEntityTypeCaSocialInsuranceNumber,
		GuardrailPiiEntityTypeCreditDebitCardCvv,
		GuardrailPiiEntityTypeCreditDebitCardExpiry,
		GuardrailPiiEntityTypeCreditDebitCardNumber,
		GuardrailPiiEntityTypeDriverId,
		GuardrailPiiEntityTypeEmail,
		GuardrailPiiEntityTypeInternationalBankAccountNumber,
		GuardrailPiiEntityTypeIpAddress,
		GuardrailPiiEntityTypeLicensePlate,
		GuardrailPiiEntityTypeMacAddress,
		GuardrailPiiEntityTypeName,
		GuardrailPiiEntityTypePassword,
		GuardrailPiiEntityTypePhone,
		GuardrailPiiEntityTypePin,
		GuardrailPiiEntityTypeSwiftCode,
		GuardrailPiiEntityTypeUkNationalHealthServiceNumber,
		GuardrailPiiEntityTypeUkNationalInsuranceNumber,
		GuardrailPiiEntityTypeUkUniqueTaxpayerReferenceNumber,
		GuardrailPiiEntityTypeUrl,
		GuardrailPiiEntityTypeUsername,
		GuardrailPiiEntityTypeUsBankAccountNumber,
		GuardrailPiiEntityTypeUsBankRoutingNumber,
		GuardrailPiiEntityTypeUsIndividualTaxIdentificationNumber,
		GuardrailPiiEntityTypeUsPassportNumber,
		GuardrailPiiEntityTypeUsSocialSecurityNumber,
		GuardrailPiiEntityTypeVehicleIdentificationNumber,
	}
}

const (
	// GuardrailSensitiveInformationActionBlock is a GuardrailSensitiveInformationAction enum value
	GuardrailSensitiveInformationActionBlock = "BLOCK"

	// GuardrailSensitiveInformationActionAnonymize is a GuardrailSensitiveInformationAction enum value
	GuardrailSensitiveInformationActionAnonymize = "ANONYMIZE"
)

// GuardrailSensitiveInformationAction_Values returns all elements of the GuardrailSensitiveInformationAction enum
func GuardrailSensitiveInformationAction_Values() []string {
	return []string{
		GuardrailSensitiveInformationActionBlock,
		GuardrailSensitiveInformationActionAnonymize,
	}
}

const (
	// GuardrailStatusCreating is a GuardrailStatus enum value
	GuardrailStatusCreating = "CREATING"

	// GuardrailStatusUpdating is a GuardrailStatus enum value
	GuardrailStatusUpdating = "UPDATING"

	// GuardrailStatusVersioning is a GuardrailStatus enum value
	GuardrailStatusVersioning = "VERSIONING"

	// GuardrailStatusReady is a GuardrailStatus enum value
	GuardrailStatusReady = "READY"

	// GuardrailStatusFailed is a GuardrailStatus enum value
	GuardrailStatusFailed = "FAILED"

	// GuardrailStatusDeleting is a GuardrailStatus enum value
	GuardrailStatusDeleting = "DELETING"
)

// GuardrailStatus_Values returns all elements of the GuardrailStatus enum
func GuardrailStatus_Values() []string {
	return []string{
		GuardrailStatusCreating,
		GuardrailStatusUpdating,
		GuardrailStatusVersioning,
		GuardrailStatusReady,
		GuardrailStatusFailed,
		GuardrailStatusDeleting,
	}
}

const (
	// GuardrailTopicTypeDeny is a GuardrailTopicType enum value
	GuardrailTopicTypeDeny = "DENY"
)

// GuardrailTopicType_Values returns all elements of the GuardrailTopicType enum
func GuardrailTopicType_Values() []string {
	return []string{
		GuardrailTopicTypeDeny,
	}
}

const (
	// InferenceTypeOnDemand is a InferenceType enum value
	InferenceTypeOnDemand = "ON_DEMAND"

	// InferenceTypeProvisioned is a InferenceType enum value
	InferenceTypeProvisioned = "PROVISIONED"
)

// InferenceType_Values returns all elements of the InferenceType enum
func InferenceType_Values() []string {
	return []string{
		InferenceTypeOnDemand,
		InferenceTypeProvisioned,
	}
}

const (
	// ModelCustomizationFineTuning is a ModelCustomization enum value
	ModelCustomizationFineTuning = "FINE_TUNING"

	// ModelCustomizationContinuedPreTraining is a ModelCustomization enum value
	ModelCustomizationContinuedPreTraining = "CONTINUED_PRE_TRAINING"
)

// ModelCustomization_Values returns all elements of the ModelCustomization enum
func ModelCustomization_Values() []string {
	return []string{
		ModelCustomizationFineTuning,
		ModelCustomizationContinuedPreTraining,
	}
}

const (
	// ModelCustomizationJobStatusInProgress is a ModelCustomizationJobStatus enum value
	ModelCustomizationJobStatusInProgress = "InProgress"

	// ModelCustomizationJobStatusCompleted is a ModelCustomizationJobStatus enum value
	ModelCustomizationJobStatusCompleted = "Completed"

	// ModelCustomizationJobStatusFailed is a ModelCustomizationJobStatus enum value
	ModelCustomizationJobStatusFailed = "Failed"

	// ModelCustomizationJobStatusStopping is a ModelCustomizationJobStatus enum value
	ModelCustomizationJobStatusStopping = "Stopping"

	// ModelCustomizationJobStatusStopped is a ModelCustomizationJobStatus enum value
	ModelCustomizationJobStatusStopped = "Stopped"
)

// ModelCustomizationJobStatus_Values returns all elements of the ModelCustomizationJobStatus enum
func ModelCustomizationJobStatus_Values() []string {
	return []string{
		ModelCustomizationJobStatusInProgress,
		ModelCustomizationJobStatusCompleted,
		ModelCustomizationJobStatusFailed,
		ModelCustomizationJobStatusStopping,
		ModelCustomizationJobStatusStopped,
	}
}

const (
	// ModelModalityText is a ModelModality enum value
	ModelModalityText = "TEXT"

	// ModelModalityImage is a ModelModality enum value
	ModelModalityImage = "IMAGE"

	// ModelModalityEmbedding is a ModelModality enum value
	ModelModalityEmbedding = "EMBEDDING"
)

// ModelModality_Values returns all elements of the ModelModality enum
func ModelModality_Values() []string {
	return []string{
		ModelModalityText,
		ModelModalityImage,
		ModelModalityEmbedding,
	}
}

const (
	// ProvisionedModelStatusCreating is a ProvisionedModelStatus enum value
	ProvisionedModelStatusCreating = "Creating"

	// ProvisionedModelStatusInService is a ProvisionedModelStatus enum value
	ProvisionedModelStatusInService = "InService"

	// ProvisionedModelStatusUpdating is a ProvisionedModelStatus enum value
	ProvisionedModelStatusUpdating = "Updating"

	// ProvisionedModelStatusFailed is a ProvisionedModelStatus enum value
	ProvisionedModelStatusFailed = "Failed"
)

// ProvisionedModelStatus_Values returns all elements of the ProvisionedModelStatus enum
func ProvisionedModelStatus_Values() []string {
	return []string{
		ProvisionedModelStatusCreating,
		ProvisionedModelStatusInService,
		ProvisionedModelStatusUpdating,
		ProvisionedModelStatusFailed,
	}
}

const (
	// SortByProvisionedModelsCreationTime is a SortByProvisionedModels enum value
	SortByProvisionedModelsCreationTime = "CreationTime"
)

// SortByProvisionedModels_Values returns all elements of the SortByProvisionedModels enum
func SortByProvisionedModels_Values() []string {
	return []string{
		SortByProvisionedModelsCreationTime,
	}
}

const (
	// SortJobsByCreationTime is a SortJobsBy enum value
	SortJobsByCreationTime = "CreationTime"
)

// SortJobsBy_Values returns all elements of the SortJobsBy enum
func SortJobsBy_Values() []string {
	return []string{
		SortJobsByCreationTime,
	}
}

const (
	// SortModelsByCreationTime is a SortModelsBy enum value
	SortModelsByCreationTime = "CreationTime"
)

// SortModelsBy_Values returns all elements of the SortModelsBy enum
func SortModelsBy_Values() []string {
	return []string{
		SortModelsByCreationTime,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "Ascending"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "Descending"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}
