/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFEntry;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReaderEntryTranslator;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
abstract class SplitLDIFTranslator
implements LDIFReaderEntryTranslator {
    @NotNull
    private final DN splitBaseDN;
    @NotNull
    private final RDN[] splitBaseRDNs;
    @NotNull
    private final Set<String> errorSetNames;
    @NotNull
    private final ThreadLocal<ByteStringBuffer> ldifBuffers;
    @NotNull
    private final ThreadLocal<MessageDigest> messageDigests;

    SplitLDIFTranslator(@NotNull DN splitBaseDN) {
        this.splitBaseDN = splitBaseDN;
        this.splitBaseRDNs = splitBaseDN.getRDNs();
        this.errorSetNames = Collections.singleton(".errors");
        this.ldifBuffers = new ThreadLocal();
        this.messageDigests = new ThreadLocal();
    }

    @NotNull
    final DN getSplitBaseDN() {
        return this.splitBaseDN;
    }

    @NotNull
    final RDN[] getSplitBaseRDNs() {
        return this.splitBaseRDNs;
    }

    @NotNull
    final Set<String> getErrorSetNames() {
        return this.errorSetNames;
    }

    @NotNull
    MessageDigest getMD5() throws NoSuchAlgorithmException {
        MessageDigest md5 = this.messageDigests.get();
        if (md5 == null) {
            md5 = CryptoHelper.getMessageDigest("MD5");
            this.messageDigests.set(md5);
        }
        return md5;
    }

    @NotNull
    SplitLDIFEntry createEntry(@NotNull Entry e, @NotNull Set<String> sets) {
        return this.createEntry(e, null, sets);
    }

    @NotNull
    SplitLDIFEntry createEntry(@NotNull Entry e, @Nullable String comment, @NotNull Set<String> sets) {
        ByteStringBuffer buffer = this.ldifBuffers.get();
        if (buffer == null) {
            buffer = new ByteStringBuffer();
            this.ldifBuffers.set(buffer);
        } else {
            buffer.clear();
        }
        if (comment != null) {
            buffer.append("# ");
            buffer.append(comment);
            buffer.append(StaticUtils.EOL_BYTES);
        }
        e.toLDIF(buffer, 0);
        buffer.append(StaticUtils.EOL_BYTES);
        return new SplitLDIFEntry(e, buffer.toByteArray(), sets);
    }

    @NotNull
    SplitLDIFEntry createFromRDNHash(@NotNull Entry e, @NotNull DN dn, @NotNull Map<Integer, Set<String>> setNames) {
        MessageDigest md5Digest;
        RDN[] rdns = dn.getRDNs();
        int targetRDNIndex = rdns.length - this.splitBaseRDNs.length - 1;
        byte[] normalizedRDNBytes = StaticUtils.getBytes(rdns[targetRDNIndex].toNormalizedString());
        try {
            md5Digest = this.getMD5();
        }
        catch (Exception ex) {
            Debug.debugException(ex);
            return this.createEntry(e, ToolMessages.ERR_SPLIT_LDIF_TRANSLATOR_CANNOT_GET_MD5.get(StaticUtils.getExceptionMessage(ex)), this.errorSetNames);
        }
        byte[] md5Bytes = md5Digest.digest(normalizedRDNBytes);
        int checksum = (md5Bytes[0] & 0x7F) << 24 | (md5Bytes[1] & 0xFF) << 16 | (md5Bytes[2] & 0xFF) << 8 | md5Bytes[3] & 0xFF;
        int setNumber = checksum % setNames.size();
        return this.createEntry(e, setNames.get(setNumber));
    }

    @Override
    @NotNull
    public abstract SplitLDIFEntry translate(@NotNull Entry var1, long var2) throws LDIFException;
}

