# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
import sys
from typing import Any, AsyncIterable, AsyncIterator, Callable, Dict, IO, List, Optional, TypeVar, Union, cast, overload
from urllib.parse import parse_qs, urljoin, urlparse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ...operations._operations import (
    build_application_data_create_cascade_delete_job_request,
    build_application_data_create_or_update_request,
    build_application_data_delete_request,
    build_application_data_get_cascade_delete_job_details_request,
    build_application_data_get_request,
    build_application_data_list_by_party_id_request,
    build_application_data_list_request,
    build_attachments_delete_request,
    build_attachments_download_request,
    build_attachments_get_request,
    build_attachments_list_by_party_id_request,
    build_boundaries_create_cascade_delete_job_request,
    build_boundaries_create_or_update_request,
    build_boundaries_delete_request,
    build_boundaries_get_cascade_delete_job_details_request,
    build_boundaries_get_overlap_request,
    build_boundaries_get_request,
    build_boundaries_list_by_party_id_request,
    build_boundaries_list_request,
    build_boundaries_search_by_party_id_request,
    build_boundaries_search_request,
    build_crop_products_create_or_update_request,
    build_crop_products_delete_request,
    build_crop_products_get_request,
    build_crop_products_list_request,
    build_crops_create_or_update_request,
    build_crops_delete_request,
    build_crops_get_request,
    build_crops_list_request,
    build_device_data_models_create_or_update_request,
    build_device_data_models_delete_request,
    build_device_data_models_get_request,
    build_device_data_models_list_request,
    build_devices_create_or_update_request,
    build_devices_delete_request,
    build_devices_get_request,
    build_devices_list_request,
    build_farm_operations_create_data_ingestion_job_request,
    build_farm_operations_get_data_ingestion_job_details_request,
    build_farms_create_cascade_delete_job_request,
    build_farms_create_or_update_request,
    build_farms_delete_request,
    build_farms_get_cascade_delete_job_details_request,
    build_farms_get_request,
    build_farms_list_by_party_id_request,
    build_farms_list_request,
    build_fields_create_cascade_delete_job_request,
    build_fields_create_or_update_request,
    build_fields_delete_request,
    build_fields_get_cascade_delete_job_details_request,
    build_fields_get_request,
    build_fields_list_by_party_id_request,
    build_fields_list_request,
    build_harvest_data_create_cascade_delete_job_request,
    build_harvest_data_create_or_update_request,
    build_harvest_data_delete_request,
    build_harvest_data_get_cascade_delete_job_details_request,
    build_harvest_data_get_request,
    build_harvest_data_list_by_party_id_request,
    build_harvest_data_list_request,
    build_image_processing_create_rasterize_job_request,
    build_image_processing_get_rasterize_job_request,
    build_insight_attachments_delete_request,
    build_insight_attachments_download_request,
    build_insight_attachments_get_request,
    build_insight_attachments_list_by_party_id_model_id_and_resource_request,
    build_insights_create_cascade_delete_job_request,
    build_insights_create_or_update_request,
    build_insights_delete_request,
    build_insights_get_cascade_delete_job_details_request,
    build_insights_get_request,
    build_insights_list_by_party_id_model_id_and_resource_request,
    build_management_zones_create_cascade_delete_job_request,
    build_management_zones_create_or_update_request,
    build_management_zones_delete_request,
    build_management_zones_get_cascade_delete_job_details_request,
    build_management_zones_get_request,
    build_management_zones_list_by_party_id_request,
    build_management_zones_list_request,
    build_model_inference_create_biomass_model_job_request,
    build_model_inference_create_sensor_placement_model_job_request,
    build_model_inference_create_soil_moisture_model_job_request,
    build_model_inference_get_biomass_model_job_request,
    build_model_inference_get_sensor_placement_model_job_request,
    build_model_inference_get_soil_moisture_model_job_request,
    build_nutrient_analyses_create_or_update_request,
    build_nutrient_analyses_delete_request,
    build_nutrient_analyses_get_request,
    build_nutrient_analyses_list_by_party_id_request,
    build_nutrient_analyses_list_request,
    build_oauth_providers_create_cascade_delete_job_request,
    build_oauth_providers_create_or_update_request,
    build_oauth_providers_delete_request,
    build_oauth_providers_get_cascade_delete_job_details_request,
    build_oauth_providers_get_request,
    build_oauth_providers_list_request,
    build_oauth_tokens_create_cascade_delete_job_request,
    build_oauth_tokens_get_cascade_delete_job_details_request,
    build_oauth_tokens_get_o_auth_connection_link_request,
    build_oauth_tokens_list_request,
    build_parties_create_cascade_delete_job_request,
    build_parties_create_or_update_request,
    build_parties_delete_request,
    build_parties_get_cascade_delete_job_details_request,
    build_parties_get_request,
    build_parties_list_request,
    build_plant_tissue_analyses_create_cascade_delete_job_request,
    build_plant_tissue_analyses_create_or_update_request,
    build_plant_tissue_analyses_delete_request,
    build_plant_tissue_analyses_get_cascade_delete_job_details_request,
    build_plant_tissue_analyses_get_request,
    build_plant_tissue_analyses_list_by_party_id_request,
    build_plant_tissue_analyses_list_request,
    build_planting_data_create_cascade_delete_job_request,
    build_planting_data_create_or_update_request,
    build_planting_data_delete_request,
    build_planting_data_get_cascade_delete_job_details_request,
    build_planting_data_get_request,
    build_planting_data_list_by_party_id_request,
    build_planting_data_list_request,
    build_prescription_maps_create_cascade_delete_job_request,
    build_prescription_maps_create_or_update_request,
    build_prescription_maps_delete_request,
    build_prescription_maps_get_cascade_delete_job_details_request,
    build_prescription_maps_get_request,
    build_prescription_maps_list_by_party_id_request,
    build_prescription_maps_list_request,
    build_prescriptions_create_cascade_delete_job_request,
    build_prescriptions_create_or_update_request,
    build_prescriptions_delete_request,
    build_prescriptions_get_cascade_delete_job_details_request,
    build_prescriptions_get_request,
    build_prescriptions_list_by_party_id_request,
    build_prescriptions_list_request,
    build_scenes_create_satellite_data_ingestion_job_request,
    build_scenes_download_request,
    build_scenes_get_satellite_data_ingestion_job_details_request,
    build_scenes_get_stac_feature_request,
    build_scenes_list_request,
    build_scenes_search_features_request,
    build_seasonal_fields_create_cascade_delete_job_request,
    build_seasonal_fields_create_or_update_request,
    build_seasonal_fields_delete_request,
    build_seasonal_fields_get_cascade_delete_job_details_request,
    build_seasonal_fields_get_request,
    build_seasonal_fields_list_by_party_id_request,
    build_seasonal_fields_list_request,
    build_seasons_create_or_update_request,
    build_seasons_delete_request,
    build_seasons_get_request,
    build_seasons_list_request,
    build_sensor_data_models_create_or_update_request,
    build_sensor_data_models_delete_request,
    build_sensor_data_models_get_request,
    build_sensor_data_models_list_request,
    build_sensor_events_list_request,
    build_sensor_mappings_create_or_update_request,
    build_sensor_mappings_delete_request,
    build_sensor_mappings_get_request,
    build_sensor_mappings_list_request,
    build_sensor_partner_integrations_check_consent_request,
    build_sensor_partner_integrations_create_or_update_request,
    build_sensor_partner_integrations_delete_request,
    build_sensor_partner_integrations_generate_consent_link_request,
    build_sensor_partner_integrations_get_request,
    build_sensor_partner_integrations_list_request,
    build_sensors_create_or_update_request,
    build_sensors_delete_request,
    build_sensors_get_connection_string_request,
    build_sensors_get_request,
    build_sensors_list_request,
    build_sensors_renew_connection_string_request,
    build_solution_inference_cancel_request,
    build_solution_inference_create_or_update_request,
    build_solution_inference_fetch_request,
    build_tillage_data_create_cascade_delete_job_request,
    build_tillage_data_create_or_update_request,
    build_tillage_data_delete_request,
    build_tillage_data_get_cascade_delete_job_details_request,
    build_tillage_data_get_request,
    build_tillage_data_list_by_party_id_request,
    build_tillage_data_list_request,
    build_weather_create_data_delete_job_request,
    build_weather_create_data_ingestion_job_request,
    build_weather_data_get_request,
    build_weather_get_data_delete_job_details_request,
    build_weather_get_data_ingestion_job_details_request,
    build_weather_list_request,
    build_zones_create_cascade_delete_job_request,
    build_zones_create_or_update_request,
    build_zones_delete_request,
    build_zones_get_cascade_delete_job_details_request,
    build_zones_get_request,
    build_zones_list_by_party_id_request,
    build_zones_list_request,
)
from .._vendor import raise_if_not_implemented

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ApplicationDataOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`application_data` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        min_avg_material: Optional[float] = None,
        max_avg_material: Optional[float] = None,
        min_total_material: Optional[float] = None,
        max_total_material: Optional[float] = None,
        sources: Optional[List[str]] = None,
        associated_boundary_ids: Optional[List[str]] = None,
        min_operation_start_date_time: Optional[datetime.datetime] = None,
        max_operation_start_date_time: Optional[datetime.datetime] = None,
        min_operation_end_date_time: Optional[datetime.datetime] = None,
        max_operation_end_date_time: Optional[datetime.datetime] = None,
        min_operation_modified_date_time: Optional[datetime.datetime] = None,
        max_operation_modified_date_time: Optional[datetime.datetime] = None,
        min_area: Optional[float] = None,
        max_area: Optional[float] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of application data resources across all parties.

        :keyword min_avg_material: Minimum average amount of material applied during the application
         (inclusive). Default value is None.
        :paramtype min_avg_material: float
        :keyword max_avg_material: Maximum average amount of material applied during the application
         (inclusive). Default value is None.
        :paramtype max_avg_material: float
        :keyword min_total_material: Minimum total amount of material applied during the application
         (inclusive). Default value is None.
        :paramtype min_total_material: float
        :keyword max_total_material: Maximum total amount of material applied during the application
         (inclusive). Default value is None.
        :paramtype max_total_material: float
        :keyword sources: Sources of the operation data. Default value is None.
        :paramtype sources: list[str]
        :keyword associated_boundary_ids: Boundary IDs associated with operation data. Default value is
         None.
        :paramtype associated_boundary_ids: list[str]
        :keyword min_operation_start_date_time: Minimum start date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_start_date_time: ~datetime.datetime
        :keyword max_operation_start_date_time: Maximum start date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_start_date_time: ~datetime.datetime
        :keyword min_operation_end_date_time: Minimum end date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_end_date_time: ~datetime.datetime
        :keyword max_operation_end_date_time: Maximum end date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_end_date_time: ~datetime.datetime
        :keyword min_operation_modified_date_time: Minimum modified date-time of the operation data,
         sample format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_modified_date_time: ~datetime.datetime
        :keyword max_operation_modified_date_time: Maximum modified date-time of the operation data,
         sample format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_modified_date_time: ~datetime.datetime
        :keyword min_area: Minimum area for which operation was applied (inclusive). Default value is
         None.
        :paramtype min_area: float
        :keyword max_area: Maximum area for which operation was applied (inclusive). Default value is
         None.
        :paramtype max_area: float
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "applicationProductDetails": [
                        {
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "isCarrier": False,  # Optional. Default value is False. A
                              flag indicating whether product is a carrier for a tank mix.
                            "productName": "str",  # Optional. Name of the product
                              applied.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_application_data_list_request(
                    min_avg_material=min_avg_material,
                    max_avg_material=max_avg_material,
                    min_total_material=min_total_material,
                    max_total_material=max_total_material,
                    sources=sources,
                    associated_boundary_ids=associated_boundary_ids,
                    min_operation_start_date_time=min_operation_start_date_time,
                    max_operation_start_date_time=max_operation_start_date_time,
                    min_operation_end_date_time=min_operation_end_date_time,
                    max_operation_end_date_time=max_operation_end_date_time,
                    min_operation_modified_date_time=min_operation_modified_date_time,
                    max_operation_modified_date_time=max_operation_modified_date_time,
                    min_area=min_area,
                    max_area=max_area,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _create_cascade_delete_job_initial(
        self, job_id: str, *, party_id: str, application_data_id: str, **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_application_data_create_cascade_delete_job_request(
            job_id=job_id,
            party_id=party_id,
            application_data_id=application_data_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_create_cascade_delete_job(
        self, job_id: str, *, party_id: str, application_data_id: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create cascade delete job for application data resource.

        :param job_id: Job Id supplied by end user. Required.
        :type job_id: str
        :keyword party_id: Id of the party. Required.
        :paramtype party_id: str
        :keyword application_data_id: Id of the application data. Required.
        :paramtype application_data_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_cascade_delete_job_initial(  # type: ignore
                job_id=job_id,
                party_id=party_id,
                application_data_id=application_data_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace_async
    async def get_cascade_delete_job_details(self, job_id: str, **kwargs: Any) -> JSON:
        """Get cascade delete job for application data resource.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_application_data_get_cascade_delete_job_details_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_by_party_id(
        self,
        party_id: str,
        *,
        min_avg_material: Optional[float] = None,
        max_avg_material: Optional[float] = None,
        min_total_material: Optional[float] = None,
        max_total_material: Optional[float] = None,
        sources: Optional[List[str]] = None,
        associated_boundary_ids: Optional[List[str]] = None,
        min_operation_start_date_time: Optional[datetime.datetime] = None,
        max_operation_start_date_time: Optional[datetime.datetime] = None,
        min_operation_end_date_time: Optional[datetime.datetime] = None,
        max_operation_end_date_time: Optional[datetime.datetime] = None,
        min_operation_modified_date_time: Optional[datetime.datetime] = None,
        max_operation_modified_date_time: Optional[datetime.datetime] = None,
        min_area: Optional[float] = None,
        max_area: Optional[float] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of application data resources under a particular party.

        :param party_id: ID of the associated party. Required.
        :type party_id: str
        :keyword min_avg_material: Minimum average amount of material applied during the application
         (inclusive). Default value is None.
        :paramtype min_avg_material: float
        :keyword max_avg_material: Maximum average amount of material applied during the application
         (inclusive). Default value is None.
        :paramtype max_avg_material: float
        :keyword min_total_material: Minimum total amount of material applied during the application
         (inclusive). Default value is None.
        :paramtype min_total_material: float
        :keyword max_total_material: Maximum total amount of material applied during the application
         (inclusive). Default value is None.
        :paramtype max_total_material: float
        :keyword sources: Sources of the operation data. Default value is None.
        :paramtype sources: list[str]
        :keyword associated_boundary_ids: Boundary IDs associated with operation data. Default value is
         None.
        :paramtype associated_boundary_ids: list[str]
        :keyword min_operation_start_date_time: Minimum start date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_start_date_time: ~datetime.datetime
        :keyword max_operation_start_date_time: Maximum start date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_start_date_time: ~datetime.datetime
        :keyword min_operation_end_date_time: Minimum end date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_end_date_time: ~datetime.datetime
        :keyword max_operation_end_date_time: Maximum end date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_end_date_time: ~datetime.datetime
        :keyword min_operation_modified_date_time: Minimum modified date-time of the operation data,
         sample format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_modified_date_time: ~datetime.datetime
        :keyword max_operation_modified_date_time: Maximum modified date-time of the operation data,
         sample format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_modified_date_time: ~datetime.datetime
        :keyword min_area: Minimum area for which operation was applied (inclusive). Default value is
         None.
        :paramtype min_area: float
        :keyword max_area: Maximum area for which operation was applied (inclusive). Default value is
         None.
        :paramtype max_area: float
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "applicationProductDetails": [
                        {
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "isCarrier": False,  # Optional. Default value is False. A
                              flag indicating whether product is a carrier for a tank mix.
                            "productName": "str",  # Optional. Name of the product
                              applied.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_application_data_list_by_party_id_request(
                    party_id=party_id,
                    min_avg_material=min_avg_material,
                    max_avg_material=max_avg_material,
                    min_total_material=min_total_material,
                    max_total_material=max_total_material,
                    sources=sources,
                    associated_boundary_ids=associated_boundary_ids,
                    min_operation_start_date_time=min_operation_start_date_time,
                    max_operation_start_date_time=max_operation_start_date_time,
                    min_operation_end_date_time=min_operation_end_date_time,
                    max_operation_end_date_time=max_operation_end_date_time,
                    min_operation_modified_date_time=min_operation_modified_date_time,
                    max_operation_modified_date_time=max_operation_modified_date_time,
                    min_area=min_area,
                    max_area=max_area,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, party_id: str, application_data_id: str, **kwargs: Any) -> JSON:
        """Get a specified application data resource under a particular party.

        :param party_id: ID of the associated party resource. Required.
        :type party_id: str
        :param application_data_id: ID of the application data resource. Required.
        :type application_data_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "applicationProductDetails": [
                        {
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "isCarrier": False,  # Optional. Default value is False. A
                              flag indicating whether product is a carrier for a tank mix.
                            "productName": "str",  # Optional. Name of the product
                              applied.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_application_data_get_request(
            party_id=party_id,
            application_data_id=application_data_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update(
        self,
        party_id: str,
        application_data_id: str,
        application_data: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates an application data resource under a particular party.

        :param party_id: ID of the associated party. Required.
        :type party_id: str
        :param application_data_id: ID of the application data resource. Required.
        :type application_data_id: str
        :param application_data: Application data resource payload to create or update. Required.
        :type application_data: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                application_data = {
                    "applicationProductDetails": [
                        {
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "isCarrier": False,  # Optional. Default value is False. A
                              flag indicating whether product is a carrier for a tank mix.
                            "productName": "str",  # Optional. Name of the product
                              applied.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }

                # response body for status code(s): 200, 201
                response == {
                    "applicationProductDetails": [
                        {
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "isCarrier": False,  # Optional. Default value is False. A
                              flag indicating whether product is a carrier for a tank mix.
                            "productName": "str",  # Optional. Name of the product
                              applied.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """

    @overload
    async def create_or_update(
        self,
        party_id: str,
        application_data_id: str,
        application_data: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates an application data resource under a particular party.

        :param party_id: ID of the associated party. Required.
        :type party_id: str
        :param application_data_id: ID of the application data resource. Required.
        :type application_data_id: str
        :param application_data: Application data resource payload to create or update. Required.
        :type application_data: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "applicationProductDetails": [
                        {
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "isCarrier": False,  # Optional. Default value is False. A
                              flag indicating whether product is a carrier for a tank mix.
                            "productName": "str",  # Optional. Name of the product
                              applied.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """

    @distributed_trace_async
    async def create_or_update(
        self, party_id: str, application_data_id: str, application_data: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        """Creates or updates an application data resource under a particular party.

        :param party_id: ID of the associated party. Required.
        :type party_id: str
        :param application_data_id: ID of the application data resource. Required.
        :type application_data_id: str
        :param application_data: Application data resource payload to create or update. Is either a
         model type or a IO type. Required.
        :type application_data: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "applicationProductDetails": [
                        {
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "isCarrier": False,  # Optional. Default value is False. A
                              flag indicating whether product is a carrier for a tank mix.
                            "productName": "str",  # Optional. Name of the product
                              applied.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(application_data, (IO, bytes)):
            _content = application_data
        else:
            _json = application_data

        request = build_application_data_create_or_update_request(
            party_id=party_id,
            application_data_id=application_data_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, party_id: str, application_data_id: str, **kwargs: Any
    ) -> None:
        """Deletes a specified application data resource under a particular party.

        :param party_id: ID of the associated party resource. Required.
        :type party_id: str
        :param application_data_id: ID of the application data. Required.
        :type application_data_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_application_data_delete_request(
            party_id=party_id,
            application_data_id=application_data_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class AttachmentsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`attachments` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        raise_if_not_implemented(
            self.__class__,
            [
                "create_or_update",
            ],
        )

    @distributed_trace
    def list_by_party_id(
        self,
        party_id: str,
        *,
        resource_ids: Optional[List[str]] = None,
        resource_types: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of attachment resources under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :keyword resource_ids: Resource Ids of the resource. Default value is None.
        :paramtype resource_ids: list[str]
        :keyword resource_types: Resource Types of the resource.
         i.e. Party, Farm, Field, SeasonalField, Boundary, ApplicationData, HarvestData, TillageData,
         PlantingData, PlantTissueAnalysis. Default value is None.
        :paramtype resource_types: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date when resource was
                      created.
                    "description": "str",  # Optional. Textual description of resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique id.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date when resource
                      was last modified.
                    "name": "str",  # Optional. Name to identify resource.
                    "originalFileName": "str",  # Optional. Original File Name for this
                      attachment.
                    "partyId": "str",  # Optional. PartyId id for this attachment.
                    "resourceId": "str",  # Optional. Associated Resource id for this attachment.
                    "resourceType": "str",  # Optional. Associated Resource type for this
                      attachment. Known values are: "Party", "Farm", "Field", "SeasonalField",
                      "Boundary", "ApplicationData", "HarvestData", "TillageData", "PlantingData", and
                      "PlantTissueAnalysis".
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_attachments_list_by_party_id_request(
                    party_id=party_id,
                    resource_ids=resource_ids,
                    resource_types=resource_types,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, party_id: str, attachment_id: str, **kwargs: Any) -> JSON:
        """Gets a specified attachment resource under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param attachment_id: Id of the attachment. Required.
        :type attachment_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date when resource was
                      created.
                    "description": "str",  # Optional. Textual description of resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique id.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date when resource
                      was last modified.
                    "name": "str",  # Optional. Name to identify resource.
                    "originalFileName": "str",  # Optional. Original File Name for this
                      attachment.
                    "partyId": "str",  # Optional. PartyId id for this attachment.
                    "resourceId": "str",  # Optional. Associated Resource id for this attachment.
                    "resourceType": "str",  # Optional. Associated Resource type for this
                      attachment. Known values are: "Party", "Farm", "Field", "SeasonalField",
                      "Boundary", "ApplicationData", "HarvestData", "TillageData", "PlantingData", and
                      "PlantTissueAnalysis".
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_attachments_get_request(
            party_id=party_id,
            attachment_id=attachment_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, party_id: str, attachment_id: str, **kwargs: Any
    ) -> None:
        """Deletes a specified attachment resource under a particular party.

        :param party_id: Id of the party. Required.
        :type party_id: str
        :param attachment_id: Id of the attachment. Required.
        :type attachment_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_attachments_delete_request(
            party_id=party_id,
            attachment_id=attachment_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def download(self, party_id: str, attachment_id: str, **kwargs: Any) -> AsyncIterator[bytes]:
        """Downloads and returns attachment as response for the given input filePath.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param attachment_id: Id of attachment to be downloaded. Required.
        :type attachment_id: str
        :return: Async iterator of the response bytes
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[AsyncIterator[bytes]]

        request = build_attachments_download_request(
            party_id=party_id,
            attachment_id=attachment_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=True, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, cast(AsyncIterator[bytes], deserialized), {})

        return cast(AsyncIterator[bytes], deserialized)


class BoundariesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`boundaries` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        parent_type: Optional[str] = None,
        type: Optional[str] = None,
        parent_ids: Optional[List[str]] = None,
        min_area: Optional[float] = None,
        max_area: Optional[float] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of boundary resources across all parties.

        :keyword parent_type: Type of the parent it belongs to. Default value is None.
        :paramtype parent_type: str
        :keyword type: Type it belongs to. Default value is None.
        :paramtype type: str
        :keyword parent_ids: Parent Ids of the resource. Default value is None.
        :paramtype parent_ids: list[str]
        :keyword min_area: Minimum area of the boundary (inclusive). Default value is None.
        :paramtype min_area: float
        :keyword max_area: Maximum acreage of the boundary (inclusive). Default value is None.
        :paramtype max_area: float
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Id of the parent it belongs to.
                    "parentType": "str",  # Optional. Type of the parent it belongs to. Known
                      values are: "Field", "SeasonalField", "Zone", "Prescription",
                      "PlantTissueAnalysis", "ApplicationData", "PlantingData", "TillageData", and
                      "HarvestData".
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type it belongs to.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_boundaries_list_request(
                    parent_type=parent_type,
                    type=type,
                    parent_ids=parent_ids,
                    min_area=min_area,
                    max_area=max_area,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    def search(
        self, search_boundary_query: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Search for boundaries across all parties by fields and intersecting geometry.

        :param search_boundary_query: Query filters. Required.
        :type search_boundary_query: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "type":

                # JSON input template for discriminator value "MultiPolygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                [
                                    0.0  # Gets or sets Coordinates of GeoJSON
                                      Object."nIt must be an array of polygons, each polygon contains
                                      list of linear rings."nFor Polygons with more than one of these
                                      rings, the first MUST be the exterior ring,"nand any others MUST
                                      be interior rings. Required.
                                ]
                            ]
                        ]
                    ],
                    "type": "MultiPolygon"
                }

                # JSON input template for discriminator value "Point":
                geo_json_object = {
                    "coordinates": [
                        0.0  # Gets or sets the coordinate of this point."nIt must be an
                          array of 2 or 3 elements for a 2D or 3D system. Required.
                    ],
                    "type": "Point"
                }

                # JSON input template for discriminator value "Polygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                0.0  # Gets or sets type of the GeoJSON Object."nIt
                                  must be an array of linear ring coordinate arrays."nFor Polygons with
                                  more than one of these rings, the first MUST be the exterior
                                  ring,"nand any others MUST be interior rings. Required.
                            ]
                        ]
                    ],
                    "type": "Polygon"
                }

                # JSON input template you can fill out and use as your body input.
                search_boundary_query = {
                    "ids": [
                        "str"  # Optional. Ids of the resource.
                    ],
                    "intersectsWithGeometry": geo_json_object,
                    "maxArea": 0.0,  # Optional. Maximum acreage of the boundary (inclusive).
                    "maxCreatedDateTime": "2020-02-20 00:00:00",  # Optional. Maximum creation
                      date of resource (inclusive).
                    "maxLastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Maximum last
                      modified date of resource (inclusive).
                    "maxPageSize": 50,  # Optional. Default value is 50. Maximum number of items
                      needed (inclusive)."nMinimum = 10, Maximum = 1000, Default value = 50.
                    "minArea": 0.0,  # Optional. Minimum acreage of the boundary (inclusive).
                    "minCreatedDateTime": "2020-02-20 00:00:00",  # Optional. Minimum creation
                      date of resource (inclusive).
                    "minLastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Minimum last
                      modified date of resource (inclusive).
                    "names": [
                        "str"  # Optional. Names of the resource.
                    ],
                    "parentIds": [
                        "str"  # Optional. Parent Ids of the resource.
                    ],
                    "parentType": "str",  # Optional. Type of the parent it belongs to. Known
                      values are: "Field", "SeasonalField", "Zone", "Prescription",
                      "PlantTissueAnalysis", "ApplicationData", "PlantingData", "TillageData", and
                      "HarvestData".
                    "propertyFilters": [
                        "str"  # Optional. Filters on key-value pairs within the Properties
                          object."ne.g. "{testKey} eq {testValue}".
                    ],
                    "skipToken": "str",  # Optional. Skip token for getting next set of results.
                    "statuses": [
                        "str"  # Optional. Statuses of the resource.
                    ],
                    "type": "str"  # Optional. Type it belongs to.
                }

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Id of the parent it belongs to.
                    "parentType": "str",  # Optional. Type of the parent it belongs to. Known
                      values are: "Field", "SeasonalField", "Zone", "Prescription",
                      "PlantTissueAnalysis", "ApplicationData", "PlantingData", "TillageData", and
                      "HarvestData".
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type it belongs to.
                }
        """

    @overload
    def search(
        self, search_boundary_query: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Search for boundaries across all parties by fields and intersecting geometry.

        :param search_boundary_query: Query filters. Required.
        :type search_boundary_query: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Id of the parent it belongs to.
                    "parentType": "str",  # Optional. Type of the parent it belongs to. Known
                      values are: "Field", "SeasonalField", "Zone", "Prescription",
                      "PlantTissueAnalysis", "ApplicationData", "PlantingData", "TillageData", and
                      "HarvestData".
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type it belongs to.
                }
        """

    @distributed_trace
    def search(self, search_boundary_query: Union[JSON, IO], **kwargs: Any) -> AsyncIterable[JSON]:
        """Search for boundaries across all parties by fields and intersecting geometry.

        :param search_boundary_query: Query filters. Is either a model type or a IO type. Required.
        :type search_boundary_query: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Id of the parent it belongs to.
                    "parentType": "str",  # Optional. Type of the parent it belongs to. Known
                      values are: "Field", "SeasonalField", "Zone", "Prescription",
                      "PlantTissueAnalysis", "ApplicationData", "PlantingData", "TillageData", and
                      "HarvestData".
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type it belongs to.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(search_boundary_query, (IO, bytes)):
            _content = search_boundary_query
        else:
            _json = search_boundary_query

        def prepare_request(next_link=None):
            if not next_link:

                request = build_boundaries_search_request(
                    content_type=content_type,
                    api_version=self._config.api_version,
                    json=_json,
                    content=_content,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _create_cascade_delete_job_initial(
        self, job_id: str, *, party_id: str, boundary_id: str, **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_boundaries_create_cascade_delete_job_request(
            job_id=job_id,
            party_id=party_id,
            boundary_id=boundary_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_create_cascade_delete_job(
        self, job_id: str, *, party_id: str, boundary_id: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a cascade delete job for specified boundary.

        :param job_id: Job ID supplied by end user. Required.
        :type job_id: str
        :keyword party_id: ID of the associated party. Required.
        :paramtype party_id: str
        :keyword boundary_id: ID of the boundary to be deleted. Required.
        :paramtype boundary_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_cascade_delete_job_initial(  # type: ignore
                job_id=job_id,
                party_id=party_id,
                boundary_id=boundary_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace_async
    async def get_cascade_delete_job_details(self, job_id: str, **kwargs: Any) -> JSON:
        """Get cascade delete job for specified boundary.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_boundaries_get_cascade_delete_job_details_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_by_party_id(
        self,
        party_id: str,
        *,
        parent_type: Optional[str] = None,
        type: Optional[str] = None,
        parent_ids: Optional[List[str]] = None,
        min_area: Optional[float] = None,
        max_area: Optional[float] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of boundary resources under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :keyword parent_type: Type of the parent it belongs to. Default value is None.
        :paramtype parent_type: str
        :keyword type: Type it belongs to. Default value is None.
        :paramtype type: str
        :keyword parent_ids: Parent Ids of the resource. Default value is None.
        :paramtype parent_ids: list[str]
        :keyword min_area: Minimum area of the boundary (inclusive). Default value is None.
        :paramtype min_area: float
        :keyword max_area: Maximum acreage of the boundary (inclusive). Default value is None.
        :paramtype max_area: float
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Id of the parent it belongs to.
                    "parentType": "str",  # Optional. Type of the parent it belongs to. Known
                      values are: "Field", "SeasonalField", "Zone", "Prescription",
                      "PlantTissueAnalysis", "ApplicationData", "PlantingData", "TillageData", and
                      "HarvestData".
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type it belongs to.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_boundaries_list_by_party_id_request(
                    party_id=party_id,
                    parent_type=parent_type,
                    type=type,
                    parent_ids=parent_ids,
                    min_area=min_area,
                    max_area=max_area,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    def search_by_party_id(
        self, party_id: str, search_boundary_query: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Search for boundaries by fields and intersecting geometry.

        :param party_id: Id of the party. Required.
        :type party_id: str
        :param search_boundary_query: Query filters. Required.
        :type search_boundary_query: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "type":

                # JSON input template for discriminator value "MultiPolygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                [
                                    0.0  # Gets or sets Coordinates of GeoJSON
                                      Object."nIt must be an array of polygons, each polygon contains
                                      list of linear rings."nFor Polygons with more than one of these
                                      rings, the first MUST be the exterior ring,"nand any others MUST
                                      be interior rings. Required.
                                ]
                            ]
                        ]
                    ],
                    "type": "MultiPolygon"
                }

                # JSON input template for discriminator value "Point":
                geo_json_object = {
                    "coordinates": [
                        0.0  # Gets or sets the coordinate of this point."nIt must be an
                          array of 2 or 3 elements for a 2D or 3D system. Required.
                    ],
                    "type": "Point"
                }

                # JSON input template for discriminator value "Polygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                0.0  # Gets or sets type of the GeoJSON Object."nIt
                                  must be an array of linear ring coordinate arrays."nFor Polygons with
                                  more than one of these rings, the first MUST be the exterior
                                  ring,"nand any others MUST be interior rings. Required.
                            ]
                        ]
                    ],
                    "type": "Polygon"
                }

                # JSON input template you can fill out and use as your body input.
                search_boundary_query = {
                    "ids": [
                        "str"  # Optional. Ids of the resource.
                    ],
                    "intersectsWithGeometry": geo_json_object,
                    "maxArea": 0.0,  # Optional. Maximum acreage of the boundary (inclusive).
                    "maxCreatedDateTime": "2020-02-20 00:00:00",  # Optional. Maximum creation
                      date of resource (inclusive).
                    "maxLastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Maximum last
                      modified date of resource (inclusive).
                    "maxPageSize": 50,  # Optional. Default value is 50. Maximum number of items
                      needed (inclusive)."nMinimum = 10, Maximum = 1000, Default value = 50.
                    "minArea": 0.0,  # Optional. Minimum acreage of the boundary (inclusive).
                    "minCreatedDateTime": "2020-02-20 00:00:00",  # Optional. Minimum creation
                      date of resource (inclusive).
                    "minLastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Minimum last
                      modified date of resource (inclusive).
                    "names": [
                        "str"  # Optional. Names of the resource.
                    ],
                    "parentIds": [
                        "str"  # Optional. Parent Ids of the resource.
                    ],
                    "parentType": "str",  # Optional. Type of the parent it belongs to. Known
                      values are: "Field", "SeasonalField", "Zone", "Prescription",
                      "PlantTissueAnalysis", "ApplicationData", "PlantingData", "TillageData", and
                      "HarvestData".
                    "propertyFilters": [
                        "str"  # Optional. Filters on key-value pairs within the Properties
                          object."ne.g. "{testKey} eq {testValue}".
                    ],
                    "skipToken": "str",  # Optional. Skip token for getting next set of results.
                    "statuses": [
                        "str"  # Optional. Statuses of the resource.
                    ],
                    "type": "str"  # Optional. Type it belongs to.
                }

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Id of the parent it belongs to.
                    "parentType": "str",  # Optional. Type of the parent it belongs to. Known
                      values are: "Field", "SeasonalField", "Zone", "Prescription",
                      "PlantTissueAnalysis", "ApplicationData", "PlantingData", "TillageData", and
                      "HarvestData".
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type it belongs to.
                }
        """

    @overload
    def search_by_party_id(
        self, party_id: str, search_boundary_query: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Search for boundaries by fields and intersecting geometry.

        :param party_id: Id of the party. Required.
        :type party_id: str
        :param search_boundary_query: Query filters. Required.
        :type search_boundary_query: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Id of the parent it belongs to.
                    "parentType": "str",  # Optional. Type of the parent it belongs to. Known
                      values are: "Field", "SeasonalField", "Zone", "Prescription",
                      "PlantTissueAnalysis", "ApplicationData", "PlantingData", "TillageData", and
                      "HarvestData".
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type it belongs to.
                }
        """

    @distributed_trace
    def search_by_party_id(
        self, party_id: str, search_boundary_query: Union[JSON, IO], **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Search for boundaries by fields and intersecting geometry.

        :param party_id: Id of the party. Required.
        :type party_id: str
        :param search_boundary_query: Query filters. Is either a model type or a IO type. Required.
        :type search_boundary_query: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Id of the parent it belongs to.
                    "parentType": "str",  # Optional. Type of the parent it belongs to. Known
                      values are: "Field", "SeasonalField", "Zone", "Prescription",
                      "PlantTissueAnalysis", "ApplicationData", "PlantingData", "TillageData", and
                      "HarvestData".
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type it belongs to.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(search_boundary_query, (IO, bytes)):
            _content = search_boundary_query
        else:
            _json = search_boundary_query

        def prepare_request(next_link=None):
            if not next_link:

                request = build_boundaries_search_by_party_id_request(
                    party_id=party_id,
                    content_type=content_type,
                    api_version=self._config.api_version,
                    json=_json,
                    content=_content,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create_or_update(
        self,
        party_id: str,
        boundary_id: str,
        boundary: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates a boundary resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param boundary_id: Id of the boundary resource. Required.
        :type boundary_id: str
        :param boundary: Boundary resource payload to create or update. Required.
        :type boundary: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "type":

                # JSON input template for discriminator value "MultiPolygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                [
                                    0.0  # Gets or sets Coordinates of GeoJSON
                                      Object."nIt must be an array of polygons, each polygon contains
                                      list of linear rings."nFor Polygons with more than one of these
                                      rings, the first MUST be the exterior ring,"nand any others MUST
                                      be interior rings. Required.
                                ]
                            ]
                        ]
                    ],
                    "type": "MultiPolygon"
                }

                # JSON input template for discriminator value "Point":
                geo_json_object = {
                    "coordinates": [
                        0.0  # Gets or sets the coordinate of this point."nIt must be an
                          array of 2 or 3 elements for a 2D or 3D system. Required.
                    ],
                    "type": "Point"
                }

                # JSON input template for discriminator value "Polygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                0.0  # Gets or sets type of the GeoJSON Object."nIt
                                  must be an array of linear ring coordinate arrays."nFor Polygons with
                                  more than one of these rings, the first MUST be the exterior
                                  ring,"nand any others MUST be interior rings. Required.
                            ]
                        ]
                    ],
                    "type": "Polygon"
                }

                # JSON input template you can fill out and use as your body input.
                boundary = {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "bbox": geo_json_object,
                    "centroid": geo_json_object,
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "crs": "str",  # Optional. Coordinate  Reference System.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "geometry": geo_json_object,
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Id of the parent it belongs to.
                    "parentType": "str",  # Optional. Type of the parent it belongs to."ni.e.
                      Field, SeasonalField, Zone, Prescription, PlantTissueAnalysis, ApplicationData,
                      HarvestData, TillageData, PlantingData. Known values are: "Field",
                      "SeasonalField", "Zone", "Prescription", "PlantTissueAnalysis",
                      "ApplicationData", "PlantingData", "TillageData", and "HarvestData".
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Indicates the type of boundary belonging to a
                      parent.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "type":

                # JSON input template for discriminator value "MultiPolygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                [
                                    0.0  # Gets or sets Coordinates of GeoJSON
                                      Object."nIt must be an array of polygons, each polygon contains
                                      list of linear rings."nFor Polygons with more than one of these
                                      rings, the first MUST be the exterior ring,"nand any others MUST
                                      be interior rings. Required.
                                ]
                            ]
                        ]
                    ],
                    "type": "MultiPolygon"
                }

                # JSON input template for discriminator value "Point":
                geo_json_object = {
                    "coordinates": [
                        0.0  # Gets or sets the coordinate of this point."nIt must be an
                          array of 2 or 3 elements for a 2D or 3D system. Required.
                    ],
                    "type": "Point"
                }

                # JSON input template for discriminator value "Polygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                0.0  # Gets or sets type of the GeoJSON Object."nIt
                                  must be an array of linear ring coordinate arrays."nFor Polygons with
                                  more than one of these rings, the first MUST be the exterior
                                  ring,"nand any others MUST be interior rings. Required.
                            ]
                        ]
                    ],
                    "type": "Polygon"
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "type":

                # JSON input template for discriminator value "MultiPolygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                [
                                    0.0  # Gets or sets Coordinates of GeoJSON
                                      Object."nIt must be an array of polygons, each polygon contains
                                      list of linear rings."nFor Polygons with more than one of these
                                      rings, the first MUST be the exterior ring,"nand any others MUST
                                      be interior rings. Required.
                                ]
                            ]
                        ]
                    ],
                    "type": "MultiPolygon"
                }

                # JSON input template for discriminator value "Point":
                geo_json_object = {
                    "coordinates": [
                        0.0  # Gets or sets the coordinate of this point."nIt must be an
                          array of 2 or 3 elements for a 2D or 3D system. Required.
                    ],
                    "type": "Point"
                }

                # JSON input template for discriminator value "Polygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                0.0  # Gets or sets type of the GeoJSON Object."nIt
                                  must be an array of linear ring coordinate arrays."nFor Polygons with
                                  more than one of these rings, the first MUST be the exterior
                                  ring,"nand any others MUST be interior rings. Required.
                            ]
                        ]
                    ],
                    "type": "Polygon"
                }

                # response body for status code(s): 200, 201
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "bbox": geo_json_object,
                    "centroid": geo_json_object,
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "crs": "str",  # Optional. Coordinate  Reference System.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "geometry": geo_json_object,
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Id of the parent it belongs to.
                    "parentType": "str",  # Optional. Type of the parent it belongs to."ni.e.
                      Field, SeasonalField, Zone, Prescription, PlantTissueAnalysis, ApplicationData,
                      HarvestData, TillageData, PlantingData. Known values are: "Field",
                      "SeasonalField", "Zone", "Prescription", "PlantTissueAnalysis",
                      "ApplicationData", "PlantingData", "TillageData", and "HarvestData".
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Indicates the type of boundary belonging to a
                      parent.
                }
        """

    @overload
    async def create_or_update(
        self,
        party_id: str,
        boundary_id: str,
        boundary: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates a boundary resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param boundary_id: Id of the boundary resource. Required.
        :type boundary_id: str
        :param boundary: Boundary resource payload to create or update. Required.
        :type boundary: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "type":

                # JSON input template for discriminator value "MultiPolygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                [
                                    0.0  # Gets or sets Coordinates of GeoJSON
                                      Object."nIt must be an array of polygons, each polygon contains
                                      list of linear rings."nFor Polygons with more than one of these
                                      rings, the first MUST be the exterior ring,"nand any others MUST
                                      be interior rings. Required.
                                ]
                            ]
                        ]
                    ],
                    "type": "MultiPolygon"
                }

                # JSON input template for discriminator value "Point":
                geo_json_object = {
                    "coordinates": [
                        0.0  # Gets or sets the coordinate of this point."nIt must be an
                          array of 2 or 3 elements for a 2D or 3D system. Required.
                    ],
                    "type": "Point"
                }

                # JSON input template for discriminator value "Polygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                0.0  # Gets or sets type of the GeoJSON Object."nIt
                                  must be an array of linear ring coordinate arrays."nFor Polygons with
                                  more than one of these rings, the first MUST be the exterior
                                  ring,"nand any others MUST be interior rings. Required.
                            ]
                        ]
                    ],
                    "type": "Polygon"
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "type":

                # JSON input template for discriminator value "MultiPolygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                [
                                    0.0  # Gets or sets Coordinates of GeoJSON
                                      Object."nIt must be an array of polygons, each polygon contains
                                      list of linear rings."nFor Polygons with more than one of these
                                      rings, the first MUST be the exterior ring,"nand any others MUST
                                      be interior rings. Required.
                                ]
                            ]
                        ]
                    ],
                    "type": "MultiPolygon"
                }

                # JSON input template for discriminator value "Point":
                geo_json_object = {
                    "coordinates": [
                        0.0  # Gets or sets the coordinate of this point."nIt must be an
                          array of 2 or 3 elements for a 2D or 3D system. Required.
                    ],
                    "type": "Point"
                }

                # JSON input template for discriminator value "Polygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                0.0  # Gets or sets type of the GeoJSON Object."nIt
                                  must be an array of linear ring coordinate arrays."nFor Polygons with
                                  more than one of these rings, the first MUST be the exterior
                                  ring,"nand any others MUST be interior rings. Required.
                            ]
                        ]
                    ],
                    "type": "Polygon"
                }

                # response body for status code(s): 200, 201
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "bbox": geo_json_object,
                    "centroid": geo_json_object,
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "crs": "str",  # Optional. Coordinate  Reference System.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "geometry": geo_json_object,
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Id of the parent it belongs to.
                    "parentType": "str",  # Optional. Type of the parent it belongs to."ni.e.
                      Field, SeasonalField, Zone, Prescription, PlantTissueAnalysis, ApplicationData,
                      HarvestData, TillageData, PlantingData. Known values are: "Field",
                      "SeasonalField", "Zone", "Prescription", "PlantTissueAnalysis",
                      "ApplicationData", "PlantingData", "TillageData", and "HarvestData".
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Indicates the type of boundary belonging to a
                      parent.
                }
        """

    @distributed_trace_async
    async def create_or_update(self, party_id: str, boundary_id: str, boundary: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates or updates a boundary resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param boundary_id: Id of the boundary resource. Required.
        :type boundary_id: str
        :param boundary: Boundary resource payload to create or update. Is either a model type or a IO
         type. Required.
        :type boundary: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "type":

                # JSON input template for discriminator value "MultiPolygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                [
                                    0.0  # Gets or sets Coordinates of GeoJSON
                                      Object."nIt must be an array of polygons, each polygon contains
                                      list of linear rings."nFor Polygons with more than one of these
                                      rings, the first MUST be the exterior ring,"nand any others MUST
                                      be interior rings. Required.
                                ]
                            ]
                        ]
                    ],
                    "type": "MultiPolygon"
                }

                # JSON input template for discriminator value "Point":
                geo_json_object = {
                    "coordinates": [
                        0.0  # Gets or sets the coordinate of this point."nIt must be an
                          array of 2 or 3 elements for a 2D or 3D system. Required.
                    ],
                    "type": "Point"
                }

                # JSON input template for discriminator value "Polygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                0.0  # Gets or sets type of the GeoJSON Object."nIt
                                  must be an array of linear ring coordinate arrays."nFor Polygons with
                                  more than one of these rings, the first MUST be the exterior
                                  ring,"nand any others MUST be interior rings. Required.
                            ]
                        ]
                    ],
                    "type": "Polygon"
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "type":

                # JSON input template for discriminator value "MultiPolygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                [
                                    0.0  # Gets or sets Coordinates of GeoJSON
                                      Object."nIt must be an array of polygons, each polygon contains
                                      list of linear rings."nFor Polygons with more than one of these
                                      rings, the first MUST be the exterior ring,"nand any others MUST
                                      be interior rings. Required.
                                ]
                            ]
                        ]
                    ],
                    "type": "MultiPolygon"
                }

                # JSON input template for discriminator value "Point":
                geo_json_object = {
                    "coordinates": [
                        0.0  # Gets or sets the coordinate of this point."nIt must be an
                          array of 2 or 3 elements for a 2D or 3D system. Required.
                    ],
                    "type": "Point"
                }

                # JSON input template for discriminator value "Polygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                0.0  # Gets or sets type of the GeoJSON Object."nIt
                                  must be an array of linear ring coordinate arrays."nFor Polygons with
                                  more than one of these rings, the first MUST be the exterior
                                  ring,"nand any others MUST be interior rings. Required.
                            ]
                        ]
                    ],
                    "type": "Polygon"
                }

                # response body for status code(s): 200, 201
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "bbox": geo_json_object,
                    "centroid": geo_json_object,
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "crs": "str",  # Optional. Coordinate  Reference System.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "geometry": geo_json_object,
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Id of the parent it belongs to.
                    "parentType": "str",  # Optional. Type of the parent it belongs to."ni.e.
                      Field, SeasonalField, Zone, Prescription, PlantTissueAnalysis, ApplicationData,
                      HarvestData, TillageData, PlantingData. Known values are: "Field",
                      "SeasonalField", "Zone", "Prescription", "PlantTissueAnalysis",
                      "ApplicationData", "PlantingData", "TillageData", and "HarvestData".
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Indicates the type of boundary belonging to a
                      parent.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(boundary, (IO, bytes)):
            _content = boundary
        else:
            _json = boundary

        request = build_boundaries_create_or_update_request(
            party_id=party_id,
            boundary_id=boundary_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get(self, party_id: str, boundary_id: str, **kwargs: Any) -> JSON:
        """Gets a specified boundary resource under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param boundary_id: Id of the boundary. Required.
        :type boundary_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "type":

                # JSON input template for discriminator value "MultiPolygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                [
                                    0.0  # Gets or sets Coordinates of GeoJSON
                                      Object."nIt must be an array of polygons, each polygon contains
                                      list of linear rings."nFor Polygons with more than one of these
                                      rings, the first MUST be the exterior ring,"nand any others MUST
                                      be interior rings. Required.
                                ]
                            ]
                        ]
                    ],
                    "type": "MultiPolygon"
                }

                # JSON input template for discriminator value "Point":
                geo_json_object = {
                    "coordinates": [
                        0.0  # Gets or sets the coordinate of this point."nIt must be an
                          array of 2 or 3 elements for a 2D or 3D system. Required.
                    ],
                    "type": "Point"
                }

                # JSON input template for discriminator value "Polygon":
                geo_json_object = {
                    "coordinates": [
                        [
                            [
                                0.0  # Gets or sets type of the GeoJSON Object."nIt
                                  must be an array of linear ring coordinate arrays."nFor Polygons with
                                  more than one of these rings, the first MUST be the exterior
                                  ring,"nand any others MUST be interior rings. Required.
                            ]
                        ]
                    ],
                    "type": "Polygon"
                }

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "bbox": geo_json_object,
                    "centroid": geo_json_object,
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "crs": "str",  # Optional. Coordinate  Reference System.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "geometry": geo_json_object,
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Id of the parent it belongs to.
                    "parentType": "str",  # Optional. Type of the parent it belongs to."ni.e.
                      Field, SeasonalField, Zone, Prescription, PlantTissueAnalysis, ApplicationData,
                      HarvestData, TillageData, PlantingData. Known values are: "Field",
                      "SeasonalField", "Zone", "Prescription", "PlantTissueAnalysis",
                      "ApplicationData", "PlantingData", "TillageData", and "HarvestData".
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Indicates the type of boundary belonging to a
                      parent.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_boundaries_get_request(
            party_id=party_id,
            boundary_id=boundary_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, party_id: str, boundary_id: str, **kwargs: Any
    ) -> None:
        """Deletes a specified boundary resource under a particular party.

        :param party_id: Id of the party. Required.
        :type party_id: str
        :param boundary_id: Id of the boundary. Required.
        :type boundary_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_boundaries_delete_request(
            party_id=party_id,
            boundary_id=boundary_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def get_overlap(
        self, party_id: str, boundary_id: str, *, other_party_id: str, other_boundary_id: str, **kwargs: Any
    ) -> JSON:
        """Returns overlapping area between two boundary Ids.

        :param party_id: Id of the party. Required.
        :type party_id: str
        :param boundary_id: Id of the boundary. Required.
        :type boundary_id: str
        :keyword other_party_id: PartyId of the other field. Required.
        :paramtype other_party_id: str
        :keyword other_boundary_id: Id of the other boundary. Required.
        :paramtype other_boundary_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "boundaryArea": 0.0,  # Optional. Acreage of Main boundary.
                    "intersectingArea": 0.0,  # Optional. Acreage of intersecting boundary.
                    "otherBoundaryArea": 0.0  # Optional. Acreage of other boundary.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_boundaries_get_overlap_request(
            party_id=party_id,
            boundary_id=boundary_id,
            other_party_id=other_party_id,
            other_boundary_id=other_boundary_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class CropProductsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`crop_products` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        crop_ids: Optional[List[str]] = None,
        brands: Optional[List[str]] = None,
        products: Optional[List[str]] = None,
        traits: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of crop product resources.

        :keyword crop_ids: CropIds of the resource. Default value is None.
        :paramtype crop_ids: list[str]
        :keyword brands: Brands of the resource. Default value is None.
        :paramtype brands: list[str]
        :keyword products: Products of the resource. Default value is None.
        :paramtype products: list[str]
        :keyword traits: Traits of the resource. Default value is None.
        :paramtype traits: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "brand": "str",  # Optional. CropProduct Brand.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropIds": [
                        "str"  # Optional. Ids of the crops it belongs to."nNote: A maximum
                          of 25 crops can be associated with a cropProduct.
                    ],
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "product": "str",  # Optional. CropProduct product.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "relativeMaturity": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "trait": "str",  # Optional. CropProduct trait.
                    "treatments": [
                        "str"  # Optional. CropProduct treatments.
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_crop_products_list_request(
                    crop_ids=crop_ids,
                    brands=brands,
                    products=products,
                    traits=traits,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, crop_product_id: str, **kwargs: Any) -> JSON:
        """Gets a specified crop Product resource.

        :param crop_product_id: Id of the crop Product. Required.
        :type crop_product_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "brand": "str",  # Optional. CropProduct Brand.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropIds": [
                        "str"  # Optional. Ids of the crops it belongs to."nNote: A maximum
                          of 25 crops can be associated with a cropProduct.
                    ],
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "product": "str",  # Optional. CropProduct product.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "relativeMaturity": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "trait": "str",  # Optional. CropProduct trait.
                    "treatments": [
                        "str"  # Optional. CropProduct treatments.
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_crop_products_get_request(
            crop_product_id=crop_product_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update(
        self,
        crop_product_id: str,
        crop_product: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates a crop Product resource.

        :param crop_product_id: Id of the crop Product resource. Required.
        :type crop_product_id: str
        :param crop_product: Crop Product resource payload to create or update. Required.
        :type crop_product: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                crop_product = {
                    "brand": "str",  # Optional. CropProduct Brand.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropIds": [
                        "str"  # Optional. Ids of the crops it belongs to."nNote: A maximum
                          of 25 crops can be associated with a cropProduct.
                    ],
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "product": "str",  # Optional. CropProduct product.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "relativeMaturity": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "trait": "str",  # Optional. CropProduct trait.
                    "treatments": [
                        "str"  # Optional. CropProduct treatments.
                    ]
                }

                # response body for status code(s): 200, 201
                response == {
                    "brand": "str",  # Optional. CropProduct Brand.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropIds": [
                        "str"  # Optional. Ids of the crops it belongs to."nNote: A maximum
                          of 25 crops can be associated with a cropProduct.
                    ],
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "product": "str",  # Optional. CropProduct product.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "relativeMaturity": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "trait": "str",  # Optional. CropProduct trait.
                    "treatments": [
                        "str"  # Optional. CropProduct treatments.
                    ]
                }
        """

    @overload
    async def create_or_update(
        self,
        crop_product_id: str,
        crop_product: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates a crop Product resource.

        :param crop_product_id: Id of the crop Product resource. Required.
        :type crop_product_id: str
        :param crop_product: Crop Product resource payload to create or update. Required.
        :type crop_product: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "brand": "str",  # Optional. CropProduct Brand.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropIds": [
                        "str"  # Optional. Ids of the crops it belongs to."nNote: A maximum
                          of 25 crops can be associated with a cropProduct.
                    ],
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "product": "str",  # Optional. CropProduct product.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "relativeMaturity": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "trait": "str",  # Optional. CropProduct trait.
                    "treatments": [
                        "str"  # Optional. CropProduct treatments.
                    ]
                }
        """

    @distributed_trace_async
    async def create_or_update(self, crop_product_id: str, crop_product: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates or updates a crop Product resource.

        :param crop_product_id: Id of the crop Product resource. Required.
        :type crop_product_id: str
        :param crop_product: Crop Product resource payload to create or update. Is either a model type
         or a IO type. Required.
        :type crop_product: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "brand": "str",  # Optional. CropProduct Brand.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropIds": [
                        "str"  # Optional. Ids of the crops it belongs to."nNote: A maximum
                          of 25 crops can be associated with a cropProduct.
                    ],
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "product": "str",  # Optional. CropProduct product.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "relativeMaturity": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "trait": "str",  # Optional. CropProduct trait.
                    "treatments": [
                        "str"  # Optional. CropProduct treatments.
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(crop_product, (IO, bytes)):
            _content = crop_product
        else:
            _json = crop_product

        request = build_crop_products_create_or_update_request(
            crop_product_id=crop_product_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, crop_product_id: str, **kwargs: Any
    ) -> None:
        """Deletes a specified crop Product resource.

        :param crop_product_id: Id of the crop Product. Required.
        :type crop_product_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_crop_products_delete_request(
            crop_product_id=crop_product_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class CropsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`crops` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        phenotypes: Optional[List[str]] = None,
        breeding_methods: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of crop resources.

        :keyword phenotypes: Crop phenotypes of the resource. Default value is None.
        :paramtype phenotypes: list[str]
        :keyword breeding_methods: Breeding method of the resource. Default value is None.
        :paramtype breeding_methods: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "breedingMethod": "str",  # Optional. Breeding Method. Known values are:
                      "VARIETY", "HYBRID", and "UNKNOWN".
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "measurements": {
                        "str": {
                            "unit": "str",  # Optional. Data unit.
                            "value": 0.0  # Optional. Data value.
                        }
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "phenotype": "str",  # Optional. Crop phenotype.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_crops_list_request(
                    phenotypes=phenotypes,
                    breeding_methods=breeding_methods,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, crop_id: str, **kwargs: Any) -> JSON:
        """Gets a specified crop resource.

        :param crop_id: Id of the crop. Required.
        :type crop_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "breedingMethod": "str",  # Optional. Breeding Method. Known values are:
                      "VARIETY", "HYBRID", and "UNKNOWN".
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "measurements": {
                        "str": {
                            "unit": "str",  # Optional. Data unit.
                            "value": 0.0  # Optional. Data value.
                        }
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "phenotype": "str",  # Optional. Crop phenotype.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_crops_get_request(
            crop_id=crop_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update(
        self, crop_id: str, crop: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a crop resource.

        :param crop_id: Id of the crop resource. Required.
        :type crop_id: str
        :param crop: Crop resource payload to create or update. Required.
        :type crop: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                crop = {
                    "breedingMethod": "str",  # Optional. Breeding Method. Known values are:
                      "VARIETY", "HYBRID", and "UNKNOWN".
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "measurements": {
                        "str": {
                            "unit": "str",  # Optional. Data unit.
                            "value": 0.0  # Optional. Data value.
                        }
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "phenotype": "str",  # Optional. Crop phenotype.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }

                # response body for status code(s): 200, 201
                response == {
                    "breedingMethod": "str",  # Optional. Breeding Method. Known values are:
                      "VARIETY", "HYBRID", and "UNKNOWN".
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "measurements": {
                        "str": {
                            "unit": "str",  # Optional. Data unit.
                            "value": 0.0  # Optional. Data value.
                        }
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "phenotype": "str",  # Optional. Crop phenotype.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """

    @overload
    async def create_or_update(
        self, crop_id: str, crop: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a crop resource.

        :param crop_id: Id of the crop resource. Required.
        :type crop_id: str
        :param crop: Crop resource payload to create or update. Required.
        :type crop: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "breedingMethod": "str",  # Optional. Breeding Method. Known values are:
                      "VARIETY", "HYBRID", and "UNKNOWN".
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "measurements": {
                        "str": {
                            "unit": "str",  # Optional. Data unit.
                            "value": 0.0  # Optional. Data value.
                        }
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "phenotype": "str",  # Optional. Crop phenotype.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """

    @distributed_trace_async
    async def create_or_update(self, crop_id: str, crop: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates or updates a crop resource.

        :param crop_id: Id of the crop resource. Required.
        :type crop_id: str
        :param crop: Crop resource payload to create or update. Is either a model type or a IO type.
         Required.
        :type crop: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "breedingMethod": "str",  # Optional. Breeding Method. Known values are:
                      "VARIETY", "HYBRID", and "UNKNOWN".
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "measurements": {
                        "str": {
                            "unit": "str",  # Optional. Data unit.
                            "value": 0.0  # Optional. Data value.
                        }
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "phenotype": "str",  # Optional. Crop phenotype.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(crop, (IO, bytes)):
            _content = crop
        else:
            _json = crop

        request = build_crops_create_or_update_request(
            crop_id=crop_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(self, crop_id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Deletes Crop for given crop id.

        :param crop_id: Id of crop to be deleted. Required.
        :type crop_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_crops_delete_request(
            crop_id=crop_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class DeviceDataModelsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`device_data_models` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        sensor_partner_id: str,
        *,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of device data model resources.

        :param sensor_partner_id: Id of the associated sensor partner. Required.
        :type sensor_partner_id: str
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Id of the resource.
                    "manufacturer": "str",  # Optional. Device manufacturer.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "ports": [
                        {
                            "name": "str",  # Optional. Name of the port.
                            "type": "str"  # Optional. Type of port digital/analog.
                        }
                    ],
                    "productCode": "str",  # Optional. Device productCode.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "sensorPartnerId": "str",  # Optional. Id of the associated sensor partner.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of device.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_device_data_models_list_request(
                    sensor_partner_id=sensor_partner_id,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create_or_update(
        self,
        sensor_partner_id: str,
        device_data_model_id: str,
        device_data_model_object: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Create a device data model entity.

        :param sensor_partner_id: Id of the sensor partner. Required.
        :type sensor_partner_id: str
        :param device_data_model_id: Id of the device data model. Required.
        :type device_data_model_id: str
        :param device_data_model_object: Device data model object details. Required.
        :type device_data_model_object: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                device_data_model_object = {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Id of the resource.
                    "manufacturer": "str",  # Optional. Device manufacturer.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "ports": [
                        {
                            "name": "str",  # Optional. Name of the port.
                            "type": "str"  # Optional. Type of port digital/analog.
                        }
                    ],
                    "productCode": "str",  # Optional. Device productCode.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "sensorPartnerId": "str",  # Optional. Id of the associated sensor partner.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of device.
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Id of the resource.
                    "manufacturer": "str",  # Optional. Device manufacturer.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "ports": [
                        {
                            "name": "str",  # Optional. Name of the port.
                            "type": "str"  # Optional. Type of port digital/analog.
                        }
                    ],
                    "productCode": "str",  # Optional. Device productCode.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "sensorPartnerId": "str",  # Optional. Id of the associated sensor partner.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of device.
                }
        """

    @overload
    async def create_or_update(
        self,
        sensor_partner_id: str,
        device_data_model_id: str,
        device_data_model_object: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Create a device data model entity.

        :param sensor_partner_id: Id of the sensor partner. Required.
        :type sensor_partner_id: str
        :param device_data_model_id: Id of the device data model. Required.
        :type device_data_model_id: str
        :param device_data_model_object: Device data model object details. Required.
        :type device_data_model_object: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Id of the resource.
                    "manufacturer": "str",  # Optional. Device manufacturer.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "ports": [
                        {
                            "name": "str",  # Optional. Name of the port.
                            "type": "str"  # Optional. Type of port digital/analog.
                        }
                    ],
                    "productCode": "str",  # Optional. Device productCode.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "sensorPartnerId": "str",  # Optional. Id of the associated sensor partner.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of device.
                }
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        sensor_partner_id: str,
        device_data_model_id: str,
        device_data_model_object: Union[JSON, IO],
        **kwargs: Any
    ) -> JSON:
        """Create a device data model entity.

        :param sensor_partner_id: Id of the sensor partner. Required.
        :type sensor_partner_id: str
        :param device_data_model_id: Id of the device data model. Required.
        :type device_data_model_id: str
        :param device_data_model_object: Device data model object details. Is either a model type or a
         IO type. Required.
        :type device_data_model_object: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Id of the resource.
                    "manufacturer": "str",  # Optional. Device manufacturer.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "ports": [
                        {
                            "name": "str",  # Optional. Name of the port.
                            "type": "str"  # Optional. Type of port digital/analog.
                        }
                    ],
                    "productCode": "str",  # Optional. Device productCode.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "sensorPartnerId": "str",  # Optional. Id of the associated sensor partner.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of device.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(device_data_model_object, (IO, bytes)):
            _content = device_data_model_object
        else:
            _json = device_data_model_object

        request = build_device_data_models_create_or_update_request(
            sensor_partner_id=sensor_partner_id,
            device_data_model_id=device_data_model_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get(self, sensor_partner_id: str, device_data_model_id: str, **kwargs: Any) -> JSON:
        """Gets a device data model entity.

        :param sensor_partner_id: Id of the sensor partner. Required.
        :type sensor_partner_id: str
        :param device_data_model_id: Id of the device data model resource. Required.
        :type device_data_model_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Id of the resource.
                    "manufacturer": "str",  # Optional. Device manufacturer.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "ports": [
                        {
                            "name": "str",  # Optional. Name of the port.
                            "type": "str"  # Optional. Type of port digital/analog.
                        }
                    ],
                    "productCode": "str",  # Optional. Device productCode.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "sensorPartnerId": "str",  # Optional. Id of the associated sensor partner.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of device.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_device_data_models_get_request(
            sensor_partner_id=sensor_partner_id,
            device_data_model_id=device_data_model_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, sensor_partner_id: str, device_data_model_id: str, **kwargs: Any
    ) -> None:
        """Deletes a device data model entity.

        :param sensor_partner_id: Id of the sensor partner. Required.
        :type sensor_partner_id: str
        :param device_data_model_id: Id of the device data model resource. Required.
        :type device_data_model_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_device_data_models_delete_request(
            sensor_partner_id=sensor_partner_id,
            device_data_model_id=device_data_model_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class DevicesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`devices` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        sensor_partner_id: str,
        *,
        parent_device_ids: Optional[List[str]] = None,
        device_data_model_ids: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of device resources.

        :param sensor_partner_id: Id of the associated sensor partner. Required.
        :type sensor_partner_id: str
        :keyword parent_device_ids: Id's of the parent devices. Default value is None.
        :paramtype parent_device_ids: list[str]
        :keyword device_data_model_ids: Id's of the device data models. Default value is None.
        :paramtype device_data_model_ids: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "deviceDataModelId": "str",  # Optional. Id of the associated device data
                      model.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "hardwareId": "str",  # Optional. Device hardwareId.
                    "id": "str",  # Optional. Id of the resource.
                    "integrationId": "str",  # Optional. Integration id for the device.
                    "location": {
                        "latitude": 0.0,  # Latitude of the location. Required.
                        "longitude": 0.0  # Longitude of the location. Required.
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentDeviceId": "str",  # Optional. Parent device Id for this device.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "reportingIntervalInSeconds": 0,  # Optional. Interval at which the device
                      sends data in seconds.
                    "sensorPartnerId": "str",  # Optional. Id of the associated sensor partner.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of device.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_devices_list_request(
                    sensor_partner_id=sensor_partner_id,
                    parent_device_ids=parent_device_ids,
                    device_data_model_ids=device_data_model_ids,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create_or_update(
        self,
        sensor_partner_id: str,
        device_id: str,
        device_details: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Create a device entity.

        :param sensor_partner_id: Id of the sensor partner. Required.
        :type sensor_partner_id: str
        :param device_id: Id of the device resource. Required.
        :type device_id: str
        :param device_details: Device object details. Required.
        :type device_details: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                device_details = {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "deviceDataModelId": "str",  # Optional. Id of the associated device data
                      model.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "hardwareId": "str",  # Optional. Device hardwareId.
                    "id": "str",  # Optional. Id of the resource.
                    "integrationId": "str",  # Optional. Integration id for the device.
                    "location": {
                        "latitude": 0.0,  # Latitude of the location. Required.
                        "longitude": 0.0  # Longitude of the location. Required.
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentDeviceId": "str",  # Optional. Parent device Id for this device.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "reportingIntervalInSeconds": 0,  # Optional. Interval at which the device
                      sends data in seconds.
                    "sensorPartnerId": "str",  # Optional. Id of the associated sensor partner.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of device.
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "deviceDataModelId": "str",  # Optional. Id of the associated device data
                      model.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "hardwareId": "str",  # Optional. Device hardwareId.
                    "id": "str",  # Optional. Id of the resource.
                    "integrationId": "str",  # Optional. Integration id for the device.
                    "location": {
                        "latitude": 0.0,  # Latitude of the location. Required.
                        "longitude": 0.0  # Longitude of the location. Required.
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentDeviceId": "str",  # Optional. Parent device Id for this device.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "reportingIntervalInSeconds": 0,  # Optional. Interval at which the device
                      sends data in seconds.
                    "sensorPartnerId": "str",  # Optional. Id of the associated sensor partner.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of device.
                }
        """

    @overload
    async def create_or_update(
        self,
        sensor_partner_id: str,
        device_id: str,
        device_details: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Create a device entity.

        :param sensor_partner_id: Id of the sensor partner. Required.
        :type sensor_partner_id: str
        :param device_id: Id of the device resource. Required.
        :type device_id: str
        :param device_details: Device object details. Required.
        :type device_details: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "deviceDataModelId": "str",  # Optional. Id of the associated device data
                      model.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "hardwareId": "str",  # Optional. Device hardwareId.
                    "id": "str",  # Optional. Id of the resource.
                    "integrationId": "str",  # Optional. Integration id for the device.
                    "location": {
                        "latitude": 0.0,  # Latitude of the location. Required.
                        "longitude": 0.0  # Longitude of the location. Required.
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentDeviceId": "str",  # Optional. Parent device Id for this device.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "reportingIntervalInSeconds": 0,  # Optional. Interval at which the device
                      sends data in seconds.
                    "sensorPartnerId": "str",  # Optional. Id of the associated sensor partner.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of device.
                }
        """

    @distributed_trace_async
    async def create_or_update(
        self, sensor_partner_id: str, device_id: str, device_details: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        """Create a device entity.

        :param sensor_partner_id: Id of the sensor partner. Required.
        :type sensor_partner_id: str
        :param device_id: Id of the device resource. Required.
        :type device_id: str
        :param device_details: Device object details. Is either a model type or a IO type. Required.
        :type device_details: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "deviceDataModelId": "str",  # Optional. Id of the associated device data
                      model.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "hardwareId": "str",  # Optional. Device hardwareId.
                    "id": "str",  # Optional. Id of the resource.
                    "integrationId": "str",  # Optional. Integration id for the device.
                    "location": {
                        "latitude": 0.0,  # Latitude of the location. Required.
                        "longitude": 0.0  # Longitude of the location. Required.
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentDeviceId": "str",  # Optional. Parent device Id for this device.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "reportingIntervalInSeconds": 0,  # Optional. Interval at which the device
                      sends data in seconds.
                    "sensorPartnerId": "str",  # Optional. Id of the associated sensor partner.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of device.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(device_details, (IO, bytes)):
            _content = device_details
        else:
            _json = device_details

        request = build_devices_create_or_update_request(
            sensor_partner_id=sensor_partner_id,
            device_id=device_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get(self, sensor_partner_id: str, device_id: str, **kwargs: Any) -> JSON:
        """Gets a device entity.

        :param sensor_partner_id: Id of the sensor partner. Required.
        :type sensor_partner_id: str
        :param device_id: Id of the device resource. Required.
        :type device_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "deviceDataModelId": "str",  # Optional. Id of the associated device data
                      model.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "hardwareId": "str",  # Optional. Device hardwareId.
                    "id": "str",  # Optional. Id of the resource.
                    "integrationId": "str",  # Optional. Integration id for the device.
                    "location": {
                        "latitude": 0.0,  # Latitude of the location. Required.
                        "longitude": 0.0  # Longitude of the location. Required.
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentDeviceId": "str",  # Optional. Parent device Id for this device.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "reportingIntervalInSeconds": 0,  # Optional. Interval at which the device
                      sends data in seconds.
                    "sensorPartnerId": "str",  # Optional. Id of the associated sensor partner.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of device.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_devices_get_request(
            sensor_partner_id=sensor_partner_id,
            device_id=device_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, sensor_partner_id: str, device_id: str, **kwargs: Any
    ) -> None:
        """Deletes a device entity.

        :param sensor_partner_id: Id of the sensor partner. Required.
        :type sensor_partner_id: str
        :param device_id: Id of the device resource. Required.
        :type device_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_devices_delete_request(
            sensor_partner_id=sensor_partner_id,
            device_id=device_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class FarmOperationsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`farm_operations` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    async def _create_data_ingestion_job_initial(self, job_id: str, job: Union[JSON, IO], **kwargs: Any) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(job, (IO, bytes)):
            _content = job
        else:
            _json = job

        request = build_farm_operations_create_data_ingestion_job_request(
            job_id=job_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def begin_create_data_ingestion_job(
        self, job_id: str, job: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a farm operation data ingestion job.

        :param job_id: Job Id supplied by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Required.
        :type job: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                job = {
                    "authProviderId": "str",  # Authentication provider Id. Required.
                    "partyId": "str",  # Party Id. Required.
                    "startYear": 0,  # Start Year (Minimum = 2000, Maximum = CurrentYear).
                      Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "isIncremental": False,  # Optional. Default value is False. Use this to pull
                      only the incremental changes from the last run.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "operations": [
                        "str"  # Optional. List of operation types for which data needs to be
                          downloaded. Available values: AllOperations, Application, Planting, Harvest,
                          Tillage.
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }

                # response body for status code(s): 202
                response == {
                    "authProviderId": "str",  # Authentication provider Id. Required.
                    "partyId": "str",  # Party Id. Required.
                    "startYear": 0,  # Start Year (Minimum = 2000, Maximum = CurrentYear).
                      Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "isIncremental": False,  # Optional. Default value is False. Use this to pull
                      only the incremental changes from the last run.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "operations": [
                        "str"  # Optional. List of operation types for which data needs to be
                          downloaded. Available values: AllOperations, Application, Planting, Harvest,
                          Tillage.
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """

    @overload
    async def begin_create_data_ingestion_job(
        self, job_id: str, job: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a farm operation data ingestion job.

        :param job_id: Job Id supplied by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Required.
        :type job: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "authProviderId": "str",  # Authentication provider Id. Required.
                    "partyId": "str",  # Party Id. Required.
                    "startYear": 0,  # Start Year (Minimum = 2000, Maximum = CurrentYear).
                      Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "isIncremental": False,  # Optional. Default value is False. Use this to pull
                      only the incremental changes from the last run.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "operations": [
                        "str"  # Optional. List of operation types for which data needs to be
                          downloaded. Available values: AllOperations, Application, Planting, Harvest,
                          Tillage.
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """

    @distributed_trace_async
    async def begin_create_data_ingestion_job(
        self, job_id: str, job: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a farm operation data ingestion job.

        :param job_id: Job Id supplied by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Is either a model type or a IO type. Required.
        :type job: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "authProviderId": "str",  # Authentication provider Id. Required.
                    "partyId": "str",  # Party Id. Required.
                    "startYear": 0,  # Start Year (Minimum = 2000, Maximum = CurrentYear).
                      Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "isIncremental": False,  # Optional. Default value is False. Use this to pull
                      only the incremental changes from the last run.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "operations": [
                        "str"  # Optional. List of operation types for which data needs to be
                          downloaded. Available values: AllOperations, Application, Planting, Harvest,
                          Tillage.
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_data_ingestion_job_initial(  # type: ignore
                job_id=job_id,
                job=job,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace_async
    async def get_data_ingestion_job_details(self, job_id: str, **kwargs: Any) -> JSON:
        """Get a farm operation data ingestion job.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "authProviderId": "str",  # Authentication provider Id. Required.
                    "partyId": "str",  # Party Id. Required.
                    "startYear": 0,  # Start Year (Minimum = 2000, Maximum = CurrentYear).
                      Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "isIncremental": False,  # Optional. Default value is False. Use this to pull
                      only the incremental changes from the last run.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "operations": [
                        "str"  # Optional. List of operation types for which data needs to be
                          downloaded. Available values: AllOperations, Application, Planting, Harvest,
                          Tillage.
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_farm_operations_get_data_ingestion_job_details_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class FarmsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`farms` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of farm resources across all parties.

        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_farms_list_request(
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _create_cascade_delete_job_initial(
        self, job_id: str, *, party_id: str, farm_id: str, **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_farms_create_cascade_delete_job_request(
            job_id=job_id,
            party_id=party_id,
            farm_id=farm_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_create_cascade_delete_job(
        self, job_id: str, *, party_id: str, farm_id: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a cascade delete job for specified farm.

        :param job_id: Job ID supplied by end user. Required.
        :type job_id: str
        :keyword party_id: ID of the associated party. Required.
        :paramtype party_id: str
        :keyword farm_id: ID of the farm to be deleted. Required.
        :paramtype farm_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_cascade_delete_job_initial(  # type: ignore
                job_id=job_id,
                party_id=party_id,
                farm_id=farm_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace_async
    async def get_cascade_delete_job_details(self, job_id: str, **kwargs: Any) -> JSON:
        """Get a cascade delete job for specified farm.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_farms_get_cascade_delete_job_details_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_by_party_id(
        self,
        party_id: str,
        *,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of farm resources under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_farms_list_by_party_id_request(
                    party_id=party_id,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, party_id: str, farm_id: str, **kwargs: Any) -> JSON:
        """Gets a specified farm resource under a particular party.

        :param party_id: ID of the associated party resource. Required.
        :type party_id: str
        :param farm_id: ID of the farm resource. Required.
        :type farm_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_farms_get_request(
            party_id=party_id,
            farm_id=farm_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update(
        self,
        party_id: str,
        farm_id: str,
        farm: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates a farm resource under a particular party.

        :param party_id: Id of the associated party resource. Required.
        :type party_id: str
        :param farm_id: Id of the farm resource. Required.
        :type farm_id: str
        :param farm: Farm resource payload to create or update. Required.
        :type farm: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                farm = {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """

    @overload
    async def create_or_update(
        self,
        party_id: str,
        farm_id: str,
        farm: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates a farm resource under a particular party.

        :param party_id: Id of the associated party resource. Required.
        :type party_id: str
        :param farm_id: Id of the farm resource. Required.
        :type farm_id: str
        :param farm: Farm resource payload to create or update. Required.
        :type farm: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """

    @distributed_trace_async
    async def create_or_update(self, party_id: str, farm_id: str, farm: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates or updates a farm resource under a particular party.

        :param party_id: Id of the associated party resource. Required.
        :type party_id: str
        :param farm_id: Id of the farm resource. Required.
        :type farm_id: str
        :param farm: Farm resource payload to create or update. Is either a model type or a IO type.
         Required.
        :type farm: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(farm, (IO, bytes)):
            _content = farm
        else:
            _json = farm

        request = build_farms_create_or_update_request(
            party_id=party_id,
            farm_id=farm_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, party_id: str, farm_id: str, **kwargs: Any
    ) -> None:
        """Deletes a specified farm resource under a particular party.

        :param party_id: Id of the party. Required.
        :type party_id: str
        :param farm_id: Id of the farm. Required.
        :type farm_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_farms_delete_request(
            party_id=party_id,
            farm_id=farm_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class FieldsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`fields` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        farm_ids: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of field resources across all parties.

        :keyword farm_ids: Farm Ids of the resource. Default value is None.
        :paramtype farm_ids: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "farmId": "str",  # Optional. Id of the associated Farm.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_fields_list_request(
                    farm_ids=farm_ids,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_cascade_delete_job_details(self, job_id: str, **kwargs: Any) -> JSON:
        """Get a cascade delete job for specified field.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_fields_get_cascade_delete_job_details_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    async def _create_cascade_delete_job_initial(
        self, job_id: str, *, party_id: str, field_id: str, **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_fields_create_cascade_delete_job_request(
            job_id=job_id,
            party_id=party_id,
            field_id=field_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_create_cascade_delete_job(
        self, job_id: str, *, party_id: str, field_id: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a cascade delete job for specified field.

        :param job_id: Job ID supplied by end user. Required.
        :type job_id: str
        :keyword party_id: ID of the associated party. Required.
        :paramtype party_id: str
        :keyword field_id: ID of the field to be deleted. Required.
        :paramtype field_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_cascade_delete_job_initial(  # type: ignore
                job_id=job_id,
                party_id=party_id,
                field_id=field_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace
    def list_by_party_id(
        self,
        party_id: str,
        *,
        farm_ids: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of field resources under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :keyword farm_ids: Farm Ids of the resource. Default value is None.
        :paramtype farm_ids: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "farmId": "str",  # Optional. Id of the associated Farm.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_fields_list_by_party_id_request(
                    party_id=party_id,
                    farm_ids=farm_ids,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, party_id: str, field_id: str, **kwargs: Any) -> JSON:
        """Gets a specified field resource under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param field_id: Id of the field. Required.
        :type field_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "farmId": "str",  # Optional. Id of the associated Farm.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_fields_get_request(
            party_id=party_id,
            field_id=field_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update(
        self,
        party_id: str,
        field_id: str,
        field: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or Updates a field resource under a particular party.

        :param party_id: Id of the associated party resource. Required.
        :type party_id: str
        :param field_id: Id of the field resource. Required.
        :type field_id: str
        :param field: Field resource payload to create or update. Required.
        :type field: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                field = {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "farmId": "str",  # Optional. Id of the associated Farm.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "farmId": "str",  # Optional. Id of the associated Farm.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """

    @overload
    async def create_or_update(
        self,
        party_id: str,
        field_id: str,
        field: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or Updates a field resource under a particular party.

        :param party_id: Id of the associated party resource. Required.
        :type party_id: str
        :param field_id: Id of the field resource. Required.
        :type field_id: str
        :param field: Field resource payload to create or update. Required.
        :type field: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "farmId": "str",  # Optional. Id of the associated Farm.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """

    @distributed_trace_async
    async def create_or_update(self, party_id: str, field_id: str, field: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates or Updates a field resource under a particular party.

        :param party_id: Id of the associated party resource. Required.
        :type party_id: str
        :param field_id: Id of the field resource. Required.
        :type field_id: str
        :param field: Field resource payload to create or update. Is either a model type or a IO type.
         Required.
        :type field: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "farmId": "str",  # Optional. Id of the associated Farm.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(field, (IO, bytes)):
            _content = field
        else:
            _json = field

        request = build_fields_create_or_update_request(
            party_id=party_id,
            field_id=field_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, party_id: str, field_id: str, **kwargs: Any
    ) -> None:
        """Deletes a specified field resource under a particular party.

        :param party_id: Id of the party. Required.
        :type party_id: str
        :param field_id: Id of the field. Required.
        :type field_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_fields_delete_request(
            party_id=party_id,
            field_id=field_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class HarvestDataOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`harvest_data` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        min_total_yield: Optional[float] = None,
        max_total_yield: Optional[float] = None,
        min_avg_yield: Optional[float] = None,
        max_avg_yield: Optional[float] = None,
        min_total_wet_mass: Optional[float] = None,
        max_total_wet_mass: Optional[float] = None,
        min_avg_wet_mass: Optional[float] = None,
        max_avg_wet_mass: Optional[float] = None,
        min_avg_moisture: Optional[float] = None,
        max_avg_moisture: Optional[float] = None,
        min_avg_speed: Optional[float] = None,
        max_avg_speed: Optional[float] = None,
        sources: Optional[List[str]] = None,
        associated_boundary_ids: Optional[List[str]] = None,
        min_operation_start_date_time: Optional[datetime.datetime] = None,
        max_operation_start_date_time: Optional[datetime.datetime] = None,
        min_operation_end_date_time: Optional[datetime.datetime] = None,
        max_operation_end_date_time: Optional[datetime.datetime] = None,
        min_operation_modified_date_time: Optional[datetime.datetime] = None,
        max_operation_modified_date_time: Optional[datetime.datetime] = None,
        min_area: Optional[float] = None,
        max_area: Optional[float] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of harvest data resources across all parties.

        :keyword min_total_yield: Minimum Yield value(inclusive). Default value is None.
        :paramtype min_total_yield: float
        :keyword max_total_yield: Maximum Yield value (inclusive). Default value is None.
        :paramtype max_total_yield: float
        :keyword min_avg_yield: Minimum AvgYield value(inclusive). Default value is None.
        :paramtype min_avg_yield: float
        :keyword max_avg_yield: Maximum AvgYield value (inclusive). Default value is None.
        :paramtype max_avg_yield: float
        :keyword min_total_wet_mass: Minimum Total WetMass value(inclusive). Default value is None.
        :paramtype min_total_wet_mass: float
        :keyword max_total_wet_mass: Maximum Total WetMass value (inclusive). Default value is None.
        :paramtype max_total_wet_mass: float
        :keyword min_avg_wet_mass: Minimum AvgWetMass value(inclusive). Default value is None.
        :paramtype min_avg_wet_mass: float
        :keyword max_avg_wet_mass: Maximum AvgWetMass value (inclusive). Default value is None.
        :paramtype max_avg_wet_mass: float
        :keyword min_avg_moisture: Minimum AvgMoisture value(inclusive). Default value is None.
        :paramtype min_avg_moisture: float
        :keyword max_avg_moisture: Maximum AvgMoisture value (inclusive). Default value is None.
        :paramtype max_avg_moisture: float
        :keyword min_avg_speed: Minimum AvgSpeed value(inclusive). Default value is None.
        :paramtype min_avg_speed: float
        :keyword max_avg_speed: Maximum AvgSpeed value (inclusive). Default value is None.
        :paramtype max_avg_speed: float
        :keyword sources: Sources of the operation data. Default value is None.
        :paramtype sources: list[str]
        :keyword associated_boundary_ids: Boundary IDs associated with operation data. Default value is
         None.
        :paramtype associated_boundary_ids: list[str]
        :keyword min_operation_start_date_time: Minimum start date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_start_date_time: ~datetime.datetime
        :keyword max_operation_start_date_time: Maximum start date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_start_date_time: ~datetime.datetime
        :keyword min_operation_end_date_time: Minimum end date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_end_date_time: ~datetime.datetime
        :keyword max_operation_end_date_time: Maximum end date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_end_date_time: ~datetime.datetime
        :keyword min_operation_modified_date_time: Minimum modified date-time of the operation data,
         sample format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_modified_date_time: ~datetime.datetime
        :keyword max_operation_modified_date_time: Maximum modified date-time of the operation data,
         sample format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_modified_date_time: ~datetime.datetime
        :keyword min_area: Minimum area for which operation was applied (inclusive). Default value is
         None.
        :paramtype min_area: float
        :keyword max_area: Maximum area for which operation was applied (inclusive). Default value is
         None.
        :paramtype max_area: float
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMoisture": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgSpeed": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "harvestProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMoisture": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "totalYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "totalYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_harvest_data_list_request(
                    min_total_yield=min_total_yield,
                    max_total_yield=max_total_yield,
                    min_avg_yield=min_avg_yield,
                    max_avg_yield=max_avg_yield,
                    min_total_wet_mass=min_total_wet_mass,
                    max_total_wet_mass=max_total_wet_mass,
                    min_avg_wet_mass=min_avg_wet_mass,
                    max_avg_wet_mass=max_avg_wet_mass,
                    min_avg_moisture=min_avg_moisture,
                    max_avg_moisture=max_avg_moisture,
                    min_avg_speed=min_avg_speed,
                    max_avg_speed=max_avg_speed,
                    sources=sources,
                    associated_boundary_ids=associated_boundary_ids,
                    min_operation_start_date_time=min_operation_start_date_time,
                    max_operation_start_date_time=max_operation_start_date_time,
                    min_operation_end_date_time=min_operation_end_date_time,
                    max_operation_end_date_time=max_operation_end_date_time,
                    min_operation_modified_date_time=min_operation_modified_date_time,
                    max_operation_modified_date_time=max_operation_modified_date_time,
                    min_area=min_area,
                    max_area=max_area,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _create_cascade_delete_job_initial(
        self, job_id: str, *, party_id: str, harvest_data_id: str, **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_harvest_data_create_cascade_delete_job_request(
            job_id=job_id,
            party_id=party_id,
            harvest_data_id=harvest_data_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_create_cascade_delete_job(
        self, job_id: str, *, party_id: str, harvest_data_id: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create cascade delete job for harvest data resource.

        :param job_id: Job Id supplied by end user. Required.
        :type job_id: str
        :keyword party_id: Id of the party. Required.
        :paramtype party_id: str
        :keyword harvest_data_id: Id of the harvest data. Required.
        :paramtype harvest_data_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_cascade_delete_job_initial(  # type: ignore
                job_id=job_id,
                party_id=party_id,
                harvest_data_id=harvest_data_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace_async
    async def get_cascade_delete_job_details(self, job_id: str, **kwargs: Any) -> JSON:
        """Get cascade delete job for harvest data resource.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_harvest_data_get_cascade_delete_job_details_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_by_party_id(
        self,
        party_id: str,
        *,
        min_total_yield: Optional[float] = None,
        max_total_yield: Optional[float] = None,
        min_avg_yield: Optional[float] = None,
        max_avg_yield: Optional[float] = None,
        min_total_wet_mass: Optional[float] = None,
        max_total_wet_mass: Optional[float] = None,
        min_avg_wet_mass: Optional[float] = None,
        max_avg_wet_mass: Optional[float] = None,
        min_avg_moisture: Optional[float] = None,
        max_avg_moisture: Optional[float] = None,
        min_avg_speed: Optional[float] = None,
        max_avg_speed: Optional[float] = None,
        sources: Optional[List[str]] = None,
        associated_boundary_ids: Optional[List[str]] = None,
        min_operation_start_date_time: Optional[datetime.datetime] = None,
        max_operation_start_date_time: Optional[datetime.datetime] = None,
        min_operation_end_date_time: Optional[datetime.datetime] = None,
        max_operation_end_date_time: Optional[datetime.datetime] = None,
        min_operation_modified_date_time: Optional[datetime.datetime] = None,
        max_operation_modified_date_time: Optional[datetime.datetime] = None,
        min_area: Optional[float] = None,
        max_area: Optional[float] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of harvest data resources under a particular farm.

        :param party_id: ID of the associated party. Required.
        :type party_id: str
        :keyword min_total_yield: Minimum Yield value(inclusive). Default value is None.
        :paramtype min_total_yield: float
        :keyword max_total_yield: Maximum Yield value (inclusive). Default value is None.
        :paramtype max_total_yield: float
        :keyword min_avg_yield: Minimum AvgYield value(inclusive). Default value is None.
        :paramtype min_avg_yield: float
        :keyword max_avg_yield: Maximum AvgYield value (inclusive). Default value is None.
        :paramtype max_avg_yield: float
        :keyword min_total_wet_mass: Minimum Total WetMass value(inclusive). Default value is None.
        :paramtype min_total_wet_mass: float
        :keyword max_total_wet_mass: Maximum Total WetMass value (inclusive). Default value is None.
        :paramtype max_total_wet_mass: float
        :keyword min_avg_wet_mass: Minimum AvgWetMass value(inclusive). Default value is None.
        :paramtype min_avg_wet_mass: float
        :keyword max_avg_wet_mass: Maximum AvgWetMass value (inclusive). Default value is None.
        :paramtype max_avg_wet_mass: float
        :keyword min_avg_moisture: Minimum AvgMoisture value(inclusive). Default value is None.
        :paramtype min_avg_moisture: float
        :keyword max_avg_moisture: Maximum AvgMoisture value (inclusive). Default value is None.
        :paramtype max_avg_moisture: float
        :keyword min_avg_speed: Minimum AvgSpeed value(inclusive). Default value is None.
        :paramtype min_avg_speed: float
        :keyword max_avg_speed: Maximum AvgSpeed value (inclusive). Default value is None.
        :paramtype max_avg_speed: float
        :keyword sources: Sources of the operation data. Default value is None.
        :paramtype sources: list[str]
        :keyword associated_boundary_ids: Boundary IDs associated with operation data. Default value is
         None.
        :paramtype associated_boundary_ids: list[str]
        :keyword min_operation_start_date_time: Minimum start date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_start_date_time: ~datetime.datetime
        :keyword max_operation_start_date_time: Maximum start date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_start_date_time: ~datetime.datetime
        :keyword min_operation_end_date_time: Minimum end date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_end_date_time: ~datetime.datetime
        :keyword max_operation_end_date_time: Maximum end date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_end_date_time: ~datetime.datetime
        :keyword min_operation_modified_date_time: Minimum modified date-time of the operation data,
         sample format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_modified_date_time: ~datetime.datetime
        :keyword max_operation_modified_date_time: Maximum modified date-time of the operation data,
         sample format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_modified_date_time: ~datetime.datetime
        :keyword min_area: Minimum area for which operation was applied (inclusive). Default value is
         None.
        :paramtype min_area: float
        :keyword max_area: Maximum area for which operation was applied (inclusive). Default value is
         None.
        :paramtype max_area: float
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMoisture": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgSpeed": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "harvestProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMoisture": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "totalYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "totalYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_harvest_data_list_by_party_id_request(
                    party_id=party_id,
                    min_total_yield=min_total_yield,
                    max_total_yield=max_total_yield,
                    min_avg_yield=min_avg_yield,
                    max_avg_yield=max_avg_yield,
                    min_total_wet_mass=min_total_wet_mass,
                    max_total_wet_mass=max_total_wet_mass,
                    min_avg_wet_mass=min_avg_wet_mass,
                    max_avg_wet_mass=max_avg_wet_mass,
                    min_avg_moisture=min_avg_moisture,
                    max_avg_moisture=max_avg_moisture,
                    min_avg_speed=min_avg_speed,
                    max_avg_speed=max_avg_speed,
                    sources=sources,
                    associated_boundary_ids=associated_boundary_ids,
                    min_operation_start_date_time=min_operation_start_date_time,
                    max_operation_start_date_time=max_operation_start_date_time,
                    min_operation_end_date_time=min_operation_end_date_time,
                    max_operation_end_date_time=max_operation_end_date_time,
                    min_operation_modified_date_time=min_operation_modified_date_time,
                    max_operation_modified_date_time=max_operation_modified_date_time,
                    min_area=min_area,
                    max_area=max_area,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, party_id: str, harvest_data_id: str, **kwargs: Any) -> JSON:
        """Get a specified harvest data resource under a particular party.

        :param party_id: ID of the associated party resource. Required.
        :type party_id: str
        :param harvest_data_id: ID of the harvest data resource. Required.
        :type harvest_data_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMoisture": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgSpeed": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "harvestProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMoisture": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "totalYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "totalYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_harvest_data_get_request(
            party_id=party_id,
            harvest_data_id=harvest_data_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update(
        self,
        party_id: str,
        harvest_data_id: str,
        harvest_data: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates harvest data resource under a particular party.

        :param party_id: ID of the party. Required.
        :type party_id: str
        :param harvest_data_id: ID of the harvest data resource. Required.
        :type harvest_data_id: str
        :param harvest_data: Harvest data resource payload to create or update. Required.
        :type harvest_data: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                harvest_data = {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMoisture": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgSpeed": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "harvestProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMoisture": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "totalYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "totalYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }

                # response body for status code(s): 200, 201
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMoisture": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgSpeed": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "harvestProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMoisture": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "totalYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "totalYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """

    @overload
    async def create_or_update(
        self,
        party_id: str,
        harvest_data_id: str,
        harvest_data: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates harvest data resource under a particular party.

        :param party_id: ID of the party. Required.
        :type party_id: str
        :param harvest_data_id: ID of the harvest data resource. Required.
        :type harvest_data_id: str
        :param harvest_data: Harvest data resource payload to create or update. Required.
        :type harvest_data: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMoisture": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgSpeed": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "harvestProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMoisture": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "totalYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "totalYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """

    @distributed_trace_async
    async def create_or_update(
        self, party_id: str, harvest_data_id: str, harvest_data: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        """Creates or updates harvest data resource under a particular party.

        :param party_id: ID of the party. Required.
        :type party_id: str
        :param harvest_data_id: ID of the harvest data resource. Required.
        :type harvest_data_id: str
        :param harvest_data: Harvest data resource payload to create or update. Is either a model type
         or a IO type. Required.
        :type harvest_data: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMoisture": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgSpeed": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "harvestProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMoisture": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalWetMass": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "totalYield": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalWetMass": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "totalYield": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(harvest_data, (IO, bytes)):
            _content = harvest_data
        else:
            _json = harvest_data

        request = build_harvest_data_create_or_update_request(
            party_id=party_id,
            harvest_data_id=harvest_data_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, party_id: str, harvest_data_id: str, **kwargs: Any
    ) -> None:
        """Deletes a specified harvest data resource under a particular party.

        :param party_id: ID of the associated party resource. Required.
        :type party_id: str
        :param harvest_data_id: ID of the harvest data. Required.
        :type harvest_data_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_harvest_data_delete_request(
            party_id=party_id,
            harvest_data_id=harvest_data_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class ImageProcessingOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`image_processing` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    async def _create_rasterize_job_initial(self, job_id: str, job: Union[JSON, IO], **kwargs: Any) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(job, (IO, bytes)):
            _content = job
        else:
            _json = job

        request = build_image_processing_create_rasterize_job_request(
            job_id=job_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def begin_create_rasterize_job(
        self, job_id: str, job: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a ImageProcessing Rasterize job.

        :param job_id: JobId provided by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Required.
        :type job: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                job = {
                    "partyId": "str",  # Party Id. Required.
                    "shapefileAttachmentId": "str",  # Shapefile attachment Id. Required.
                    "shapefileColumnNames": [
                        "str"  # List of shapefile column names to create raster attachments.
                          Required.
                    ],
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "shapefileAttachmentId": "str",  # Shapefile attachment Id. Required.
                    "shapefileColumnNames": [
                        "str"  # List of shapefile column names to create raster attachments.
                          Required.
                    ],
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """

    @overload
    async def begin_create_rasterize_job(
        self, job_id: str, job: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a ImageProcessing Rasterize job.

        :param job_id: JobId provided by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Required.
        :type job: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "shapefileAttachmentId": "str",  # Shapefile attachment Id. Required.
                    "shapefileColumnNames": [
                        "str"  # List of shapefile column names to create raster attachments.
                          Required.
                    ],
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """

    @distributed_trace_async
    async def begin_create_rasterize_job(
        self, job_id: str, job: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a ImageProcessing Rasterize job.

        :param job_id: JobId provided by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Is either a model type or a IO type. Required.
        :type job: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "shapefileAttachmentId": "str",  # Shapefile attachment Id. Required.
                    "shapefileColumnNames": [
                        "str"  # List of shapefile column names to create raster attachments.
                          Required.
                    ],
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_rasterize_job_initial(  # type: ignore
                job_id=job_id,
                job=job,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace_async
    async def get_rasterize_job(self, job_id: str, **kwargs: Any) -> JSON:
        """Get ImageProcessing Rasterize job's details.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "shapefileAttachmentId": "str",  # Shapefile attachment Id. Required.
                    "shapefileColumnNames": [
                        "str"  # List of shapefile column names to create raster attachments.
                          Required.
                    ],
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_image_processing_get_rasterize_job_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class InsightAttachmentsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`insight_attachments` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        raise_if_not_implemented(
            self.__class__,
            [
                "create_or_update",
            ],
        )

    @distributed_trace
    def list_by_party_id_model_id_and_resource(
        self,
        party_id: str,
        model_id: str,
        resource_type: str,
        resource_id: str,
        *,
        insight_ids: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of insight resources.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param model_id: Id of the associated model. Required.
        :type model_id: str
        :param resource_type: Resource type associated with the record. Required.
        :type resource_type: str
        :param resource_id: Id of the associated resource. Required.
        :type resource_id: str
        :keyword insight_ids: List of insight IDs. Default value is None.
        :paramtype insight_ids: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "insightId": "str",  # InsightID for this InsightAttachment. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date when resource was
                      created.
                    "description": "str",  # Optional. Textual description of resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique id.
                    "modelId": "str",  # Optional. ModelID for this InsightAttachment.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date when resource
                      was last modified.
                    "name": "str",  # Optional. Name to identify resource.
                    "originalFileName": "str",  # Optional. Original File Name for this
                      attachment.
                    "partyId": "str",  # Optional. PartyId id for this attachment.
                    "resourceId": "str",  # Optional. Associated Resource id for this attachment.
                    "resourceType": "str",  # Optional. Associated Resource type for this
                      attachment. Known values are: "Party", "Farm", "Field", "SeasonalField", and
                      "Boundary".
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_insight_attachments_list_by_party_id_model_id_and_resource_request(
                    party_id=party_id,
                    model_id=model_id,
                    resource_type=resource_type,
                    resource_id=resource_id,
                    insight_ids=insight_ids,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(
        self,
        party_id: str,
        model_id: str,
        resource_type: str,
        resource_id: str,
        insight_attachment_id: str,
        **kwargs: Any
    ) -> JSON:
        """Gets a specified insight resource under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param model_id: Id of the associated model.
         It can be either 'BiomassModelId', 'SensorPlacementModelId', 'SoilMoistureModelId' or any
         solution id. Required.
        :type model_id: str
        :param resource_type: Resource type associated with the record. Required.
        :type resource_type: str
        :param resource_id: Id of the associated resource. Required.
        :type resource_id: str
        :param insight_attachment_id: Id of the insight attachment resource. Required.
        :type insight_attachment_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "insightId": "str",  # InsightID for this InsightAttachment. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date when resource was
                      created.
                    "description": "str",  # Optional. Textual description of resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique id.
                    "modelId": "str",  # Optional. ModelID for this InsightAttachment.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date when resource
                      was last modified.
                    "name": "str",  # Optional. Name to identify resource.
                    "originalFileName": "str",  # Optional. Original File Name for this
                      attachment.
                    "partyId": "str",  # Optional. PartyId id for this attachment.
                    "resourceId": "str",  # Optional. Associated Resource id for this attachment.
                    "resourceType": "str",  # Optional. Associated Resource type for this
                      attachment. Known values are: "Party", "Farm", "Field", "SeasonalField", and
                      "Boundary".
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_insight_attachments_get_request(
            party_id=party_id,
            model_id=model_id,
            resource_type=resource_type,
            resource_id=resource_id,
            insight_attachment_id=insight_attachment_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self,
        party_id: str,
        model_id: str,
        resource_type: str,
        resource_id: str,
        insight_attachment_id: str,
        **kwargs: Any
    ) -> None:
        """Deletes a specified insight resource.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param model_id: Id of the associated model.
         It can be either 'BiomassModelId', 'SensorPlacementModelId', 'SoilMoistureModelId' or any
         solution id. Required.
        :type model_id: str
        :param resource_type: Resource type associated with the record. Required.
        :type resource_type: str
        :param resource_id: Id of the associated resource. Required.
        :type resource_id: str
        :param insight_attachment_id: Id of the insight attachment resource. Required.
        :type insight_attachment_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_insight_attachments_delete_request(
            party_id=party_id,
            model_id=model_id,
            resource_type=resource_type,
            resource_id=resource_id,
            insight_attachment_id=insight_attachment_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def download(
        self,
        party_id: str,
        model_id: str,
        resource_type: str,
        resource_id: str,
        insight_attachment_id: str,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Downloads and returns insight-attachment as response for the given input filePath.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param model_id: Id of the associated model.
         It can be either 'BiomassModelId', 'SensorPlacementModelId', 'SoilMoistureModelId' or any
         solution id. Required.
        :type model_id: str
        :param resource_type: Resource type associated with the record. Required.
        :type resource_type: str
        :param resource_id: Id of the associated resource. Required.
        :type resource_id: str
        :param insight_attachment_id: Id of the insight attachment resource. Required.
        :type insight_attachment_id: str
        :return: Async iterator of the response bytes
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[AsyncIterator[bytes]]

        request = build_insight_attachments_download_request(
            party_id=party_id,
            model_id=model_id,
            resource_type=resource_type,
            resource_id=resource_id,
            insight_attachment_id=insight_attachment_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=True, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, cast(AsyncIterator[bytes], deserialized), {})

        return cast(AsyncIterator[bytes], deserialized)


class InsightsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`insights` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    async def _create_cascade_delete_job_initial(
        self,
        job_id: str,
        *,
        party_id: str,
        model_id: str,
        resource_type: str,
        resource_id: str,
        insight_id: str,
        **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_insights_create_cascade_delete_job_request(
            job_id=job_id,
            party_id=party_id,
            model_id=model_id,
            resource_type=resource_type,
            resource_id=resource_id,
            insight_id=insight_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_create_cascade_delete_job(
        self,
        job_id: str,
        *,
        party_id: str,
        model_id: str,
        resource_type: str,
        resource_id: str,
        insight_id: str,
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a cascade delete job for insights specified partyId/modelId/resourceType/resourceId.

        :param job_id: Job ID supplied by end user. Required.
        :type job_id: str
        :keyword party_id: ID of the associated party. Required.
        :paramtype party_id: str
        :keyword model_id: Id of the associated model. Required.
        :paramtype model_id: str
        :keyword resource_type: Resource Type. Required.
        :paramtype resource_type: str
        :keyword resource_id: Id of the associated resource. Required.
        :paramtype resource_id: str
        :keyword insight_id: Insight id. Required.
        :paramtype insight_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_cascade_delete_job_initial(  # type: ignore
                job_id=job_id,
                party_id=party_id,
                model_id=model_id,
                resource_type=resource_type,
                resource_id=resource_id,
                insight_id=insight_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace_async
    async def get_cascade_delete_job_details(self, job_id: str, **kwargs: Any) -> JSON:
        """Get a cascade delete job for specified insight.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_insights_get_cascade_delete_job_details_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_by_party_id_model_id_and_resource(
        self,
        party_id: str,
        model_id: str,
        resource_type: str,
        resource_id: str,
        *,
        min_insight_start_date_time: Optional[datetime.datetime] = None,
        max_insight_start_date_time: Optional[datetime.datetime] = None,
        min_insight_end_date_time: Optional[datetime.datetime] = None,
        max_insight_end_date_time: Optional[datetime.datetime] = None,
        measurement_filters: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of insight resources.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param model_id: Id of the associated model. Required.
        :type model_id: str
        :param resource_type: Resource type associated with the record. Required.
        :type resource_type: str
        :param resource_id: Id of the associated resource. Required.
        :type resource_id: str
        :keyword min_insight_start_date_time: Minimum insightStartDateTime time of insight resources
         (inclusive), sample format: yyyy-MM-ddTHH:mm:ssZ. Default value is None.
        :paramtype min_insight_start_date_time: ~datetime.datetime
        :keyword max_insight_start_date_time: Maximum insightStartDateTime time of insight resources
         (inclusive), sample format: yyyy-MM-ddTHH:mm:ssZ. Default value is None.
        :paramtype max_insight_start_date_time: ~datetime.datetime
        :keyword min_insight_end_date_time: Minimum insightEndDateTime time of insight resources
         (inclusive), sample format: yyyy-MM-ddTHH:mm:ssZ. Default value is None.
        :paramtype min_insight_end_date_time: ~datetime.datetime
        :keyword max_insight_end_date_time: Maximum insightEndDateTime time of insight resources
         (inclusive), sample format: yyyy-MM-ddTHH:mm:ssZ. Default value is None.
        :paramtype max_insight_end_date_time: ~datetime.datetime
        :keyword measurement_filters: Filters on measureKey.unit/unitValue or measureKey.value/value
         pairs within the Measures object.
         eg. "measureKey.unit eq {testValue}" where testValue is string.
         eg. "measureKey.value eq {testValue}" where testValue = double. Default value is None.
        :paramtype measurement_filters: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "attachmentsLink": "str",  # Optional. Gets link for attachments.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Id of the resource.
                    "insightEndDateTime": "2020-02-20 00:00:00",  # Optional. End date to which
                      the insight is related.
                    "insightStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date to
                      which the insight is related.
                    "measurements": {
                        "str": {
                            "unit": "str",  # Optional. Data unit.
                            "value": 0.0  # Optional. Data value.
                        }
                    },
                    "modelId": "str",  # Optional. Id of the associated model.
                    "modelVersion": "str",  # Optional. Version of the associated model.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Id of the associated party.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "resourceId": "str",  # Optional. Id of the associated resource.
                    "resourceType": "str",  # Optional. Resource type associated with the record.
                      Known values are: "Party", "Farm", "Field", "SeasonalField", and "Boundary".
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_insights_list_by_party_id_model_id_and_resource_request(
                    party_id=party_id,
                    model_id=model_id,
                    resource_type=resource_type,
                    resource_id=resource_id,
                    min_insight_start_date_time=min_insight_start_date_time,
                    max_insight_start_date_time=max_insight_start_date_time,
                    min_insight_end_date_time=min_insight_end_date_time,
                    max_insight_end_date_time=max_insight_end_date_time,
                    measurement_filters=measurement_filters,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create_or_update(
        self,
        party_id: str,
        model_id: str,
        resource_type: str,
        resource_id: str,
        insight_id: str,
        insight_data: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates insight entity.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param model_id: Id of the associated model.
         It can be either 'BiomassModelId', 'SensorPlacementModelId', 'SoilMoistureModelId' or any
         solution id. Required.
        :type model_id: str
        :param resource_type: Resource type associated with the record. Required.
        :type resource_type: str
        :param resource_id: Id of the associated resource. Required.
        :type resource_id: str
        :param insight_id: Id of the insight resource. Required.
        :type insight_id: str
        :param insight_data: Insight data. Required.
        :type insight_data: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                insight_data = {
                    "attachmentsLink": "str",  # Optional. Gets link for attachments.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Id of the resource.
                    "insightEndDateTime": "2020-02-20 00:00:00",  # Optional. End date to which
                      the insight is related.
                    "insightStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date to
                      which the insight is related.
                    "measurements": {
                        "str": {
                            "unit": "str",  # Optional. Data unit.
                            "value": 0.0  # Optional. Data value.
                        }
                    },
                    "modelId": "str",  # Optional. Id of the associated model.
                    "modelVersion": "str",  # Optional. Version of the associated model.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Id of the associated party.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "resourceId": "str",  # Optional. Id of the associated resource.
                    "resourceType": "str",  # Optional. Resource type associated with the record.
                      Known values are: "Party", "Farm", "Field", "SeasonalField", and "Boundary".
                    "status": "str"  # Optional. Status of the resource.
                }

                # response body for status code(s): 200, 201
                response == {
                    "attachmentsLink": "str",  # Optional. Gets link for attachments.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Id of the resource.
                    "insightEndDateTime": "2020-02-20 00:00:00",  # Optional. End date to which
                      the insight is related.
                    "insightStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date to
                      which the insight is related.
                    "measurements": {
                        "str": {
                            "unit": "str",  # Optional. Data unit.
                            "value": 0.0  # Optional. Data value.
                        }
                    },
                    "modelId": "str",  # Optional. Id of the associated model.
                    "modelVersion": "str",  # Optional. Version of the associated model.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Id of the associated party.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "resourceId": "str",  # Optional. Id of the associated resource.
                    "resourceType": "str",  # Optional. Resource type associated with the record.
                      Known values are: "Party", "Farm", "Field", "SeasonalField", and "Boundary".
                    "status": "str"  # Optional. Status of the resource.
                }
        """

    @overload
    async def create_or_update(
        self,
        party_id: str,
        model_id: str,
        resource_type: str,
        resource_id: str,
        insight_id: str,
        insight_data: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates insight entity.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param model_id: Id of the associated model.
         It can be either 'BiomassModelId', 'SensorPlacementModelId', 'SoilMoistureModelId' or any
         solution id. Required.
        :type model_id: str
        :param resource_type: Resource type associated with the record. Required.
        :type resource_type: str
        :param resource_id: Id of the associated resource. Required.
        :type resource_id: str
        :param insight_id: Id of the insight resource. Required.
        :type insight_id: str
        :param insight_data: Insight data. Required.
        :type insight_data: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "attachmentsLink": "str",  # Optional. Gets link for attachments.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Id of the resource.
                    "insightEndDateTime": "2020-02-20 00:00:00",  # Optional. End date to which
                      the insight is related.
                    "insightStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date to
                      which the insight is related.
                    "measurements": {
                        "str": {
                            "unit": "str",  # Optional. Data unit.
                            "value": 0.0  # Optional. Data value.
                        }
                    },
                    "modelId": "str",  # Optional. Id of the associated model.
                    "modelVersion": "str",  # Optional. Version of the associated model.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Id of the associated party.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "resourceId": "str",  # Optional. Id of the associated resource.
                    "resourceType": "str",  # Optional. Resource type associated with the record.
                      Known values are: "Party", "Farm", "Field", "SeasonalField", and "Boundary".
                    "status": "str"  # Optional. Status of the resource.
                }
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        party_id: str,
        model_id: str,
        resource_type: str,
        resource_id: str,
        insight_id: str,
        insight_data: Union[JSON, IO],
        **kwargs: Any
    ) -> JSON:
        """Creates or updates insight entity.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param model_id: Id of the associated model.
         It can be either 'BiomassModelId', 'SensorPlacementModelId', 'SoilMoistureModelId' or any
         solution id. Required.
        :type model_id: str
        :param resource_type: Resource type associated with the record. Required.
        :type resource_type: str
        :param resource_id: Id of the associated resource. Required.
        :type resource_id: str
        :param insight_id: Id of the insight resource. Required.
        :type insight_id: str
        :param insight_data: Insight data. Is either a model type or a IO type. Required.
        :type insight_data: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "attachmentsLink": "str",  # Optional. Gets link for attachments.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Id of the resource.
                    "insightEndDateTime": "2020-02-20 00:00:00",  # Optional. End date to which
                      the insight is related.
                    "insightStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date to
                      which the insight is related.
                    "measurements": {
                        "str": {
                            "unit": "str",  # Optional. Data unit.
                            "value": 0.0  # Optional. Data value.
                        }
                    },
                    "modelId": "str",  # Optional. Id of the associated model.
                    "modelVersion": "str",  # Optional. Version of the associated model.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Id of the associated party.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "resourceId": "str",  # Optional. Id of the associated resource.
                    "resourceType": "str",  # Optional. Resource type associated with the record.
                      Known values are: "Party", "Farm", "Field", "SeasonalField", and "Boundary".
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(insight_data, (IO, bytes)):
            _content = insight_data
        else:
            _json = insight_data

        request = build_insights_create_or_update_request(
            party_id=party_id,
            model_id=model_id,
            resource_type=resource_type,
            resource_id=resource_id,
            insight_id=insight_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get(
        self, party_id: str, model_id: str, resource_type: str, resource_id: str, insight_id: str, **kwargs: Any
    ) -> JSON:
        """Gets a specified insight resource under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param model_id: Id of the associated model.
         It can be either 'BiomassModelId', 'SensorPlacementModelId', 'SoilMoistureModelId' or any
         solution id. Required.
        :type model_id: str
        :param resource_type: Resource type associated with the record. Required.
        :type resource_type: str
        :param resource_id: Id of the associated resource. Required.
        :type resource_id: str
        :param insight_id: Id of the insight resource. Required.
        :type insight_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "attachmentsLink": "str",  # Optional. Gets link for attachments.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Id of the resource.
                    "insightEndDateTime": "2020-02-20 00:00:00",  # Optional. End date to which
                      the insight is related.
                    "insightStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date to
                      which the insight is related.
                    "measurements": {
                        "str": {
                            "unit": "str",  # Optional. Data unit.
                            "value": 0.0  # Optional. Data value.
                        }
                    },
                    "modelId": "str",  # Optional. Id of the associated model.
                    "modelVersion": "str",  # Optional. Version of the associated model.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Id of the associated party.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "resourceId": "str",  # Optional. Id of the associated resource.
                    "resourceType": "str",  # Optional. Resource type associated with the record.
                      Known values are: "Party", "Farm", "Field", "SeasonalField", and "Boundary".
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_insights_get_request(
            party_id=party_id,
            model_id=model_id,
            resource_type=resource_type,
            resource_id=resource_id,
            insight_id=insight_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, party_id: str, model_id: str, resource_type: str, resource_id: str, insight_id: str, **kwargs: Any
    ) -> None:
        """Deletes a specified insight resource.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param model_id: Id of the associated model.
         It can be either 'BiomassModelId', 'SensorPlacementModelId', 'SoilMoistureModelId' or any
         solution id. Required.
        :type model_id: str
        :param resource_type: Resource type associated with the record. Required.
        :type resource_type: str
        :param resource_id: Id of the associated resource. Required.
        :type resource_id: str
        :param insight_id: Id of the insight resource. Required.
        :type insight_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_insights_delete_request(
            party_id=party_id,
            model_id=model_id,
            resource_type=resource_type,
            resource_id=resource_id,
            insight_id=insight_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class ManagementZonesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`management_zones` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        types: Optional[List[str]] = None,
        crop_ids: Optional[List[str]] = None,
        season_ids: Optional[List[str]] = None,
        field_ids: Optional[List[str]] = None,
        sources: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of management zone resources across all parties.

        :keyword types: Types of the ManagementZone. Default value is None.
        :paramtype types: list[str]
        :keyword crop_ids: CropIds of the ManagementZone. Default value is None.
        :paramtype crop_ids: list[str]
        :keyword season_ids: SeasonIds of the ManagementZone. Default value is None.
        :paramtype season_ids: list[str]
        :keyword field_ids: FieldIds of the ManagementZone. Default value is None.
        :paramtype field_ids: list[str]
        :keyword sources: Sources of the ManagementZone. Default value is None.
        :paramtype sources: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Crop Id associated with the ManagementZone.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Field Id associated with the ManagementZone.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id associated with the ManagementZone.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "seasonId": "str",  # Optional. Season Id associated with the ManagementZone.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of the ManagementZone.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_management_zones_list_request(
                    types=types,
                    crop_ids=crop_ids,
                    season_ids=season_ids,
                    field_ids=field_ids,
                    sources=sources,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_cascade_delete_job_details(self, job_id: str, **kwargs: Any) -> JSON:
        """Get a cascade delete job for specified job id.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_management_zones_get_cascade_delete_job_details_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    async def _create_cascade_delete_job_initial(
        self, job_id: str, *, party_id: str, management_zone_id: str, **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_management_zones_create_cascade_delete_job_request(
            job_id=job_id,
            party_id=party_id,
            management_zone_id=management_zone_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_create_cascade_delete_job(
        self, job_id: str, *, party_id: str, management_zone_id: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a cascade delete job for specified management zone.

        :param job_id: Job ID supplied by end user. Required.
        :type job_id: str
        :keyword party_id: ID of the associated party. Required.
        :paramtype party_id: str
        :keyword management_zone_id: ID of the management zone to be deleted. Required.
        :paramtype management_zone_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_cascade_delete_job_initial(  # type: ignore
                job_id=job_id,
                party_id=party_id,
                management_zone_id=management_zone_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace
    def list_by_party_id(
        self,
        party_id: str,
        *,
        types: Optional[List[str]] = None,
        crop_ids: Optional[List[str]] = None,
        season_ids: Optional[List[str]] = None,
        field_ids: Optional[List[str]] = None,
        sources: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of management zone resources under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :keyword types: Types of the ManagementZone. Default value is None.
        :paramtype types: list[str]
        :keyword crop_ids: CropIds of the ManagementZone. Default value is None.
        :paramtype crop_ids: list[str]
        :keyword season_ids: SeasonIds of the ManagementZone. Default value is None.
        :paramtype season_ids: list[str]
        :keyword field_ids: FieldIds of the ManagementZone. Default value is None.
        :paramtype field_ids: list[str]
        :keyword sources: Sources of the ManagementZone. Default value is None.
        :paramtype sources: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Crop Id associated with the ManagementZone.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Field Id associated with the ManagementZone.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id associated with the ManagementZone.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "seasonId": "str",  # Optional. Season Id associated with the ManagementZone.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of the ManagementZone.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_management_zones_list_by_party_id_request(
                    party_id=party_id,
                    types=types,
                    crop_ids=crop_ids,
                    season_ids=season_ids,
                    field_ids=field_ids,
                    sources=sources,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, party_id: str, management_zone_id: str, **kwargs: Any) -> JSON:
        """Gets a specified management zone resource under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param management_zone_id: Id of the management zone. Required.
        :type management_zone_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Crop Id associated with the ManagementZone.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Field Id associated with the ManagementZone.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id associated with the ManagementZone.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "seasonId": "str",  # Optional. Season Id associated with the ManagementZone.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of the ManagementZone.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_management_zones_get_request(
            party_id=party_id,
            management_zone_id=management_zone_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update(
        self,
        party_id: str,
        management_zone_id: str,
        management_zone: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates a management zone resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param management_zone_id: Id of the management zone resource. Required.
        :type management_zone_id: str
        :param management_zone: ManagementZone resource payload to create or update. Required.
        :type management_zone: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                management_zone = {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Crop Id associated with the ManagementZone.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Field Id associated with the ManagementZone.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id associated with the ManagementZone.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "seasonId": "str",  # Optional. Season Id associated with the ManagementZone.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of the ManagementZone.
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Crop Id associated with the ManagementZone.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Field Id associated with the ManagementZone.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id associated with the ManagementZone.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "seasonId": "str",  # Optional. Season Id associated with the ManagementZone.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of the ManagementZone.
                }
        """

    @overload
    async def create_or_update(
        self,
        party_id: str,
        management_zone_id: str,
        management_zone: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates a management zone resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param management_zone_id: Id of the management zone resource. Required.
        :type management_zone_id: str
        :param management_zone: ManagementZone resource payload to create or update. Required.
        :type management_zone: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Crop Id associated with the ManagementZone.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Field Id associated with the ManagementZone.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id associated with the ManagementZone.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "seasonId": "str",  # Optional. Season Id associated with the ManagementZone.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of the ManagementZone.
                }
        """

    @distributed_trace_async
    async def create_or_update(
        self, party_id: str, management_zone_id: str, management_zone: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        """Creates or updates a management zone resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param management_zone_id: Id of the management zone resource. Required.
        :type management_zone_id: str
        :param management_zone: ManagementZone resource payload to create or update. Is either a model
         type or a IO type. Required.
        :type management_zone: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Crop Id associated with the ManagementZone.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Field Id associated with the ManagementZone.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id associated with the ManagementZone.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "seasonId": "str",  # Optional. Season Id associated with the ManagementZone.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Type of the ManagementZone.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(management_zone, (IO, bytes)):
            _content = management_zone
        else:
            _json = management_zone

        request = build_management_zones_create_or_update_request(
            party_id=party_id,
            management_zone_id=management_zone_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, party_id: str, management_zone_id: str, **kwargs: Any
    ) -> None:
        """Deletes a specified management zone resource under a particular party.

        :param party_id: Id of the party. Required.
        :type party_id: str
        :param management_zone_id: Id of the management zone. Required.
        :type management_zone_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_management_zones_delete_request(
            party_id=party_id,
            management_zone_id=management_zone_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class ModelInferenceOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`model_inference` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    async def _create_biomass_model_job_initial(self, job_id: str, job: Union[JSON, IO], **kwargs: Any) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(job, (IO, bytes)):
            _content = job
        else:
            _json = job

        request = build_model_inference_create_biomass_model_job_request(
            job_id=job_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def begin_create_biomass_model_job(
        self, job_id: str, job: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a Biomass Model job.

        :param job_id: JobId provided by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Required.
        :type job: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                job = {
                    "boundaryId": "str",  # The id of the boundary object for which biomass is
                      being calculated. Required.
                    "cropName": "str",  # Crop name for biomass model. Available Value: Corn.
                      Required. "Corn"
                    "imageFormat": "str",  # ImageFormat. Available value: TIF. Required. "TIF"
                    "imageResolution": 0.0,  # ImageResolution in meters. Available values: 10,
                      20, 60. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # End datetime till which
                      biomass will be calculated. Sample format: yyyy-MM-ddTHH:mm:ssZ. Required.
                    "modelVersion": "str",  # The version of the biomass model to be run.
                      Available Value: 1.0 . Required.
                    "partyId": "str",  # Party Id. Required.
                    "plantingStartDateTime": "2020-02-20 00:00:00",  # Planting datetime for
                      biomass calculations. Sample format: yyyy-MM-ddTHH:mm:ssZ. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "weatherExtensionId": "str",  # ExtensionId of weather data. Available
                      values: DTN.ClearAg, DTN.ContentServices. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }

                # response body for status code(s): 202
                response == {
                    "boundaryId": "str",  # The id of the boundary object for which biomass is
                      being calculated. Required.
                    "cropName": "str",  # Crop name for biomass model. Available Value: Corn.
                      Required. "Corn"
                    "imageFormat": "str",  # ImageFormat. Available value: TIF. Required. "TIF"
                    "imageResolution": 0.0,  # ImageResolution in meters. Available values: 10,
                      20, 60. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # End datetime till which
                      biomass will be calculated. Sample format: yyyy-MM-ddTHH:mm:ssZ. Required.
                    "modelVersion": "str",  # The version of the biomass model to be run.
                      Available Value: 1.0 . Required.
                    "partyId": "str",  # Party Id. Required.
                    "plantingStartDateTime": "2020-02-20 00:00:00",  # Planting datetime for
                      biomass calculations. Sample format: yyyy-MM-ddTHH:mm:ssZ. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "weatherExtensionId": "str",  # ExtensionId of weather data. Available
                      values: DTN.ClearAg, DTN.ContentServices. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """

    @overload
    async def begin_create_biomass_model_job(
        self, job_id: str, job: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a Biomass Model job.

        :param job_id: JobId provided by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Required.
        :type job: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "boundaryId": "str",  # The id of the boundary object for which biomass is
                      being calculated. Required.
                    "cropName": "str",  # Crop name for biomass model. Available Value: Corn.
                      Required. "Corn"
                    "imageFormat": "str",  # ImageFormat. Available value: TIF. Required. "TIF"
                    "imageResolution": 0.0,  # ImageResolution in meters. Available values: 10,
                      20, 60. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # End datetime till which
                      biomass will be calculated. Sample format: yyyy-MM-ddTHH:mm:ssZ. Required.
                    "modelVersion": "str",  # The version of the biomass model to be run.
                      Available Value: 1.0 . Required.
                    "partyId": "str",  # Party Id. Required.
                    "plantingStartDateTime": "2020-02-20 00:00:00",  # Planting datetime for
                      biomass calculations. Sample format: yyyy-MM-ddTHH:mm:ssZ. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "weatherExtensionId": "str",  # ExtensionId of weather data. Available
                      values: DTN.ClearAg, DTN.ContentServices. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """

    @distributed_trace_async
    async def begin_create_biomass_model_job(
        self, job_id: str, job: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a Biomass Model job.

        :param job_id: JobId provided by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Is either a model type or a IO type. Required.
        :type job: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "boundaryId": "str",  # The id of the boundary object for which biomass is
                      being calculated. Required.
                    "cropName": "str",  # Crop name for biomass model. Available Value: Corn.
                      Required. "Corn"
                    "imageFormat": "str",  # ImageFormat. Available value: TIF. Required. "TIF"
                    "imageResolution": 0.0,  # ImageResolution in meters. Available values: 10,
                      20, 60. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # End datetime till which
                      biomass will be calculated. Sample format: yyyy-MM-ddTHH:mm:ssZ. Required.
                    "modelVersion": "str",  # The version of the biomass model to be run.
                      Available Value: 1.0 . Required.
                    "partyId": "str",  # Party Id. Required.
                    "plantingStartDateTime": "2020-02-20 00:00:00",  # Planting datetime for
                      biomass calculations. Sample format: yyyy-MM-ddTHH:mm:ssZ. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "weatherExtensionId": "str",  # ExtensionId of weather data. Available
                      values: DTN.ClearAg, DTN.ContentServices. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_biomass_model_job_initial(  # type: ignore
                job_id=job_id,
                job=job,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace_async
    async def get_biomass_model_job(self, job_id: str, **kwargs: Any) -> JSON:
        """Get Biomass Model job's details.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "boundaryId": "str",  # The id of the boundary object for which biomass is
                      being calculated. Required.
                    "cropName": "str",  # Crop name for biomass model. Available Value: Corn.
                      Required. "Corn"
                    "imageFormat": "str",  # ImageFormat. Available value: TIF. Required. "TIF"
                    "imageResolution": 0.0,  # ImageResolution in meters. Available values: 10,
                      20, 60. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # End datetime till which
                      biomass will be calculated. Sample format: yyyy-MM-ddTHH:mm:ssZ. Required.
                    "modelVersion": "str",  # The version of the biomass model to be run.
                      Available Value: 1.0 . Required.
                    "partyId": "str",  # Party Id. Required.
                    "plantingStartDateTime": "2020-02-20 00:00:00",  # Planting datetime for
                      biomass calculations. Sample format: yyyy-MM-ddTHH:mm:ssZ. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "weatherExtensionId": "str",  # ExtensionId of weather data. Available
                      values: DTN.ClearAg, DTN.ContentServices. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_model_inference_get_biomass_model_job_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    async def _create_sensor_placement_model_job_initial(
        self, job_id: str, job: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(job, (IO, bytes)):
            _content = job
        else:
            _json = job

        request = build_model_inference_create_sensor_placement_model_job_request(
            job_id=job_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def begin_create_sensor_placement_model_job(
        self, job_id: str, job: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a Sensor Placement Model job.

        :param job_id: JobId provided by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Required.
        :type job: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                job = {
                    "boundaryId": "str",  # The id of the boundary object for which sensor
                      placement is being calculated. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # End datetime for satellite
                      data to be pulled. Required.
                    "inferenceStartDateTime": "2020-02-20 00:00:00",  # Start datetime for
                      satellite data to be pulled. Required.
                    "isRanked": bool,  # IsRanked, if True the sensor placements will be ranked.
                      Required.
                    "modelVersion": "str",  # The version of the sensor placement model to be
                      run. Required.
                    "partyId": "str",  # Party Id. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "sensorType": "str",  # SensorType. The sensor placement map generated for
                      sensor type (e.g., soil moisture, soil temperature, npk). Available Value:
                      SoilMoisture. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }

                # response body for status code(s): 202
                response == {
                    "boundaryId": "str",  # The id of the boundary object for which sensor
                      placement is being calculated. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # End datetime for satellite
                      data to be pulled. Required.
                    "inferenceStartDateTime": "2020-02-20 00:00:00",  # Start datetime for
                      satellite data to be pulled. Required.
                    "isRanked": bool,  # IsRanked, if True the sensor placements will be ranked.
                      Required.
                    "modelVersion": "str",  # The version of the sensor placement model to be
                      run. Required.
                    "partyId": "str",  # Party Id. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "sensorType": "str",  # SensorType. The sensor placement map generated for
                      sensor type (e.g., soil moisture, soil temperature, npk). Available Value:
                      SoilMoisture. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """

    @overload
    async def begin_create_sensor_placement_model_job(
        self, job_id: str, job: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a Sensor Placement Model job.

        :param job_id: JobId provided by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Required.
        :type job: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "boundaryId": "str",  # The id of the boundary object for which sensor
                      placement is being calculated. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # End datetime for satellite
                      data to be pulled. Required.
                    "inferenceStartDateTime": "2020-02-20 00:00:00",  # Start datetime for
                      satellite data to be pulled. Required.
                    "isRanked": bool,  # IsRanked, if True the sensor placements will be ranked.
                      Required.
                    "modelVersion": "str",  # The version of the sensor placement model to be
                      run. Required.
                    "partyId": "str",  # Party Id. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "sensorType": "str",  # SensorType. The sensor placement map generated for
                      sensor type (e.g., soil moisture, soil temperature, npk). Available Value:
                      SoilMoisture. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """

    @distributed_trace_async
    async def begin_create_sensor_placement_model_job(
        self, job_id: str, job: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a Sensor Placement Model job.

        :param job_id: JobId provided by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Is either a model type or a IO type. Required.
        :type job: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "boundaryId": "str",  # The id of the boundary object for which sensor
                      placement is being calculated. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # End datetime for satellite
                      data to be pulled. Required.
                    "inferenceStartDateTime": "2020-02-20 00:00:00",  # Start datetime for
                      satellite data to be pulled. Required.
                    "isRanked": bool,  # IsRanked, if True the sensor placements will be ranked.
                      Required.
                    "modelVersion": "str",  # The version of the sensor placement model to be
                      run. Required.
                    "partyId": "str",  # Party Id. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "sensorType": "str",  # SensorType. The sensor placement map generated for
                      sensor type (e.g., soil moisture, soil temperature, npk). Available Value:
                      SoilMoisture. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_sensor_placement_model_job_initial(  # type: ignore
                job_id=job_id,
                job=job,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace_async
    async def get_sensor_placement_model_job(self, job_id: str, **kwargs: Any) -> JSON:
        """Get Sensor Placement Model job's details.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "boundaryId": "str",  # The id of the boundary object for which sensor
                      placement is being calculated. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # End datetime for satellite
                      data to be pulled. Required.
                    "inferenceStartDateTime": "2020-02-20 00:00:00",  # Start datetime for
                      satellite data to be pulled. Required.
                    "isRanked": bool,  # IsRanked, if True the sensor placements will be ranked.
                      Required.
                    "modelVersion": "str",  # The version of the sensor placement model to be
                      run. Required.
                    "partyId": "str",  # Party Id. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "sensorType": "str",  # SensorType. The sensor placement map generated for
                      sensor type (e.g., soil moisture, soil temperature, npk). Available Value:
                      SoilMoisture. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_model_inference_get_sensor_placement_model_job_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    async def _create_soil_moisture_model_job_initial(self, job_id: str, job: Union[JSON, IO], **kwargs: Any) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(job, (IO, bytes)):
            _content = job
        else:
            _json = job

        request = build_model_inference_create_soil_moisture_model_job_request(
            job_id=job_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def begin_create_soil_moisture_model_job(
        self, job_id: str, job: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a SoilMoisture Model job.

        :param job_id: JobId provided by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Required.
        :type job: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                job = {
                    "boundaryId": "str",  # The id of the boundary object for which soil moisture
                      is being calculated. Required.
                    "imageFormat": "str",  # ImageFormat. Available value: TIF. Required. "TIF"
                    "imageResolution": 0.0,  # ImageResolution in meters. Available values: 10,
                      20, 60. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # Inference end date time for
                      soil moisture calculations. Required.
                    "inferenceStartDateTime": "2020-02-20 00:00:00",  # Inference start date time
                      for soil moisture calculations. Required.
                    "modelVersion": "str",  # The version of the soil moisture model to be run.
                      Required.
                    "partyId": "str",  # Party Id. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "sensorDataModelId": "str",  # Sensor data model Id. Required.
                    "sensorDefinition": {
                        "maxProperty": "str",  # The measurement name for maximum measurement
                          value. Required.
                        "minProperty": "str",  # The measurement name for minimum measurement
                          value. Required.
                        "sensorMeasurement": "str"  # The measurement name for sensor measure
                          in sensorDataModel. Required.
                    },
                    "sensorPartnerId": "str",  # Sensor partner Id. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }

                # response body for status code(s): 202
                response == {
                    "boundaryId": "str",  # The id of the boundary object for which soil moisture
                      is being calculated. Required.
                    "imageFormat": "str",  # ImageFormat. Available value: TIF. Required. "TIF"
                    "imageResolution": 0.0,  # ImageResolution in meters. Available values: 10,
                      20, 60. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # Inference end date time for
                      soil moisture calculations. Required.
                    "inferenceStartDateTime": "2020-02-20 00:00:00",  # Inference start date time
                      for soil moisture calculations. Required.
                    "modelVersion": "str",  # The version of the soil moisture model to be run.
                      Required.
                    "partyId": "str",  # Party Id. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "sensorDataModelId": "str",  # Sensor data model Id. Required.
                    "sensorDefinition": {
                        "maxProperty": "str",  # The measurement name for maximum measurement
                          value. Required.
                        "minProperty": "str",  # The measurement name for minimum measurement
                          value. Required.
                        "sensorMeasurement": "str"  # The measurement name for sensor measure
                          in sensorDataModel. Required.
                    },
                    "sensorPartnerId": "str",  # Sensor partner Id. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """

    @overload
    async def begin_create_soil_moisture_model_job(
        self, job_id: str, job: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a SoilMoisture Model job.

        :param job_id: JobId provided by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Required.
        :type job: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "boundaryId": "str",  # The id of the boundary object for which soil moisture
                      is being calculated. Required.
                    "imageFormat": "str",  # ImageFormat. Available value: TIF. Required. "TIF"
                    "imageResolution": 0.0,  # ImageResolution in meters. Available values: 10,
                      20, 60. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # Inference end date time for
                      soil moisture calculations. Required.
                    "inferenceStartDateTime": "2020-02-20 00:00:00",  # Inference start date time
                      for soil moisture calculations. Required.
                    "modelVersion": "str",  # The version of the soil moisture model to be run.
                      Required.
                    "partyId": "str",  # Party Id. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "sensorDataModelId": "str",  # Sensor data model Id. Required.
                    "sensorDefinition": {
                        "maxProperty": "str",  # The measurement name for maximum measurement
                          value. Required.
                        "minProperty": "str",  # The measurement name for minimum measurement
                          value. Required.
                        "sensorMeasurement": "str"  # The measurement name for sensor measure
                          in sensorDataModel. Required.
                    },
                    "sensorPartnerId": "str",  # Sensor partner Id. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """

    @distributed_trace_async
    async def begin_create_soil_moisture_model_job(
        self, job_id: str, job: Union[JSON, IO], **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a SoilMoisture Model job.

        :param job_id: JobId provided by user. Required.
        :type job_id: str
        :param job: Job parameters supplied by user. Is either a model type or a IO type. Required.
        :type job: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "boundaryId": "str",  # The id of the boundary object for which soil moisture
                      is being calculated. Required.
                    "imageFormat": "str",  # ImageFormat. Available value: TIF. Required. "TIF"
                    "imageResolution": 0.0,  # ImageResolution in meters. Available values: 10,
                      20, 60. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # Inference end date time for
                      soil moisture calculations. Required.
                    "inferenceStartDateTime": "2020-02-20 00:00:00",  # Inference start date time
                      for soil moisture calculations. Required.
                    "modelVersion": "str",  # The version of the soil moisture model to be run.
                      Required.
                    "partyId": "str",  # Party Id. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "sensorDataModelId": "str",  # Sensor data model Id. Required.
                    "sensorDefinition": {
                        "maxProperty": "str",  # The measurement name for maximum measurement
                          value. Required.
                        "minProperty": "str",  # The measurement name for minimum measurement
                          value. Required.
                        "sensorMeasurement": "str"  # The measurement name for sensor measure
                          in sensorDataModel. Required.
                    },
                    "sensorPartnerId": "str",  # Sensor partner Id. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_soil_moisture_model_job_initial(  # type: ignore
                job_id=job_id,
                job=job,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace_async
    async def get_soil_moisture_model_job(self, job_id: str, **kwargs: Any) -> JSON:
        """Get SoilMoisture Model job's details.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "boundaryId": "str",  # The id of the boundary object for which soil moisture
                      is being calculated. Required.
                    "imageFormat": "str",  # ImageFormat. Available value: TIF. Required. "TIF"
                    "imageResolution": 0.0,  # ImageResolution in meters. Available values: 10,
                      20, 60. Required.
                    "inferenceEndDateTime": "2020-02-20 00:00:00",  # Inference end date time for
                      soil moisture calculations. Required.
                    "inferenceStartDateTime": "2020-02-20 00:00:00",  # Inference start date time
                      for soil moisture calculations. Required.
                    "modelVersion": "str",  # The version of the soil moisture model to be run.
                      Required.
                    "partyId": "str",  # Party Id. Required.
                    "satelliteProvider": "str",  # Provider of satellite data. Available Value:
                      Microsoft. Required. "Microsoft"
                    "satelliteSource": "str",  # Source of satellite data. Available Value:
                      Sentinel_2_L2A. Required. Known values are: "Sentinel_2_L2A" and
                      "Sentinel_2_L1C".
                    "sensorDataModelId": "str",  # Sensor data model Id. Required.
                    "sensorDefinition": {
                        "maxProperty": "str",  # The measurement name for maximum measurement
                          value. Required.
                        "minProperty": "str",  # The measurement name for minimum measurement
                          value. Required.
                        "sensorMeasurement": "str"  # The measurement name for sensor measure
                          in sensorDataModel. Required.
                    },
                    "sensorPartnerId": "str",  # Sensor partner Id. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_model_inference_get_soil_moisture_model_job_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class NutrientAnalysesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`nutrient_analyses` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        parent_type: Optional[str] = None,
        parent_ids: Optional[List[str]] = None,
        classifications: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of nutrient analysis resources across all parties.

        :keyword parent_type: Type of the parent it belongs to.
         i.e. PlantTissueAnalysis. Default value is None.
        :paramtype parent_type: str
        :keyword parent_ids: Parent ids of the resource. Default value is None.
        :paramtype parent_ids: list[str]
        :keyword classifications: Classifications for nutrient analyses. Default value is None.
        :paramtype classifications: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "classification": "str",  # Optional. Classification for this nutrient
                      analysis.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Parent id for this nutrient analysis.
                    "parentType": "str",  # Optional. Parent type for this nutrient
                      analysis."ni.e. PlantTissueAnalysis. "PlantTissueAnalysis"
                    "partyId": "str",  # Optional. Party id for this nutrient analysis.
                    "products": [
                        {
                            "instruction": "str",  # Optional. Instruction of the
                              resource.
                            "product": "str",  # Optional. Product of the resource.
                            "rate": "str"  # Optional. Rate of the product.
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "recommendation": "str",  # Optional. Recommendation for this nutrient
                      analysis.
                    "referenceValueHigh": 0.0,  # Optional. Reference value high for this
                      nutrient analysis.
                    "referenceValueLow": 0.0,  # Optional. Reference value low for this nutrient
                      analysis.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "unit": "str",  # Optional. Unit for this nutrient analysis.
                    "value": 0.0  # Optional. Value for this nutrient analysis.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_nutrient_analyses_list_request(
                    parent_type=parent_type,
                    parent_ids=parent_ids,
                    classifications=classifications,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_party_id(
        self,
        party_id: str,
        *,
        parent_type: Optional[str] = None,
        parent_ids: Optional[List[str]] = None,
        classifications: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of nutrient analysis resources under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :keyword parent_type: Type of the parent it belongs to.
         i.e. PlantTissueAnalysis. Default value is None.
        :paramtype parent_type: str
        :keyword parent_ids: Parent ids of the resource. Default value is None.
        :paramtype parent_ids: list[str]
        :keyword classifications: Classifications for nutrient analyses. Default value is None.
        :paramtype classifications: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "classification": "str",  # Optional. Classification for this nutrient
                      analysis.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Parent id for this nutrient analysis.
                    "parentType": "str",  # Optional. Parent type for this nutrient
                      analysis."ni.e. PlantTissueAnalysis. "PlantTissueAnalysis"
                    "partyId": "str",  # Optional. Party id for this nutrient analysis.
                    "products": [
                        {
                            "instruction": "str",  # Optional. Instruction of the
                              resource.
                            "product": "str",  # Optional. Product of the resource.
                            "rate": "str"  # Optional. Rate of the product.
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "recommendation": "str",  # Optional. Recommendation for this nutrient
                      analysis.
                    "referenceValueHigh": 0.0,  # Optional. Reference value high for this
                      nutrient analysis.
                    "referenceValueLow": 0.0,  # Optional. Reference value low for this nutrient
                      analysis.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "unit": "str",  # Optional. Unit for this nutrient analysis.
                    "value": 0.0  # Optional. Value for this nutrient analysis.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_nutrient_analyses_list_by_party_id_request(
                    party_id=party_id,
                    parent_type=parent_type,
                    parent_ids=parent_ids,
                    classifications=classifications,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, party_id: str, nutrient_analysis_id: str, **kwargs: Any) -> JSON:
        """Gets a specified nutrient analysis resource under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param nutrient_analysis_id: Id of the nutrient analysis. Required.
        :type nutrient_analysis_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "classification": "str",  # Optional. Classification for this nutrient
                      analysis.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Parent id for this nutrient analysis.
                    "parentType": "str",  # Optional. Parent type for this nutrient
                      analysis."ni.e. PlantTissueAnalysis. "PlantTissueAnalysis"
                    "partyId": "str",  # Optional. Party id for this nutrient analysis.
                    "products": [
                        {
                            "instruction": "str",  # Optional. Instruction of the
                              resource.
                            "product": "str",  # Optional. Product of the resource.
                            "rate": "str"  # Optional. Rate of the product.
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "recommendation": "str",  # Optional. Recommendation for this nutrient
                      analysis.
                    "referenceValueHigh": 0.0,  # Optional. Reference value high for this
                      nutrient analysis.
                    "referenceValueLow": 0.0,  # Optional. Reference value low for this nutrient
                      analysis.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "unit": "str",  # Optional. Unit for this nutrient analysis.
                    "value": 0.0  # Optional. Value for this nutrient analysis.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_nutrient_analyses_get_request(
            party_id=party_id,
            nutrient_analysis_id=nutrient_analysis_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update(
        self,
        party_id: str,
        nutrient_analysis_id: str,
        nutrient_analysis: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates a nutrient analysis resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param nutrient_analysis_id: Id of the nutrient analysis resource. Required.
        :type nutrient_analysis_id: str
        :param nutrient_analysis: NutrientAnalysis resource payload to create or update. Required.
        :type nutrient_analysis: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                nutrient_analysis = {
                    "classification": "str",  # Optional. Classification for this nutrient
                      analysis.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Parent id for this nutrient analysis.
                    "parentType": "str",  # Optional. Parent type for this nutrient
                      analysis."ni.e. PlantTissueAnalysis. "PlantTissueAnalysis"
                    "partyId": "str",  # Optional. Party id for this nutrient analysis.
                    "products": [
                        {
                            "instruction": "str",  # Optional. Instruction of the
                              resource.
                            "product": "str",  # Optional. Product of the resource.
                            "rate": "str"  # Optional. Rate of the product.
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "recommendation": "str",  # Optional. Recommendation for this nutrient
                      analysis.
                    "referenceValueHigh": 0.0,  # Optional. Reference value high for this
                      nutrient analysis.
                    "referenceValueLow": 0.0,  # Optional. Reference value low for this nutrient
                      analysis.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "unit": "str",  # Optional. Unit for this nutrient analysis.
                    "value": 0.0  # Optional. Value for this nutrient analysis.
                }

                # response body for status code(s): 200, 201
                response == {
                    "classification": "str",  # Optional. Classification for this nutrient
                      analysis.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Parent id for this nutrient analysis.
                    "parentType": "str",  # Optional. Parent type for this nutrient
                      analysis."ni.e. PlantTissueAnalysis. "PlantTissueAnalysis"
                    "partyId": "str",  # Optional. Party id for this nutrient analysis.
                    "products": [
                        {
                            "instruction": "str",  # Optional. Instruction of the
                              resource.
                            "product": "str",  # Optional. Product of the resource.
                            "rate": "str"  # Optional. Rate of the product.
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "recommendation": "str",  # Optional. Recommendation for this nutrient
                      analysis.
                    "referenceValueHigh": 0.0,  # Optional. Reference value high for this
                      nutrient analysis.
                    "referenceValueLow": 0.0,  # Optional. Reference value low for this nutrient
                      analysis.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "unit": "str",  # Optional. Unit for this nutrient analysis.
                    "value": 0.0  # Optional. Value for this nutrient analysis.
                }
        """

    @overload
    async def create_or_update(
        self,
        party_id: str,
        nutrient_analysis_id: str,
        nutrient_analysis: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates a nutrient analysis resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param nutrient_analysis_id: Id of the nutrient analysis resource. Required.
        :type nutrient_analysis_id: str
        :param nutrient_analysis: NutrientAnalysis resource payload to create or update. Required.
        :type nutrient_analysis: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "classification": "str",  # Optional. Classification for this nutrient
                      analysis.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Parent id for this nutrient analysis.
                    "parentType": "str",  # Optional. Parent type for this nutrient
                      analysis."ni.e. PlantTissueAnalysis. "PlantTissueAnalysis"
                    "partyId": "str",  # Optional. Party id for this nutrient analysis.
                    "products": [
                        {
                            "instruction": "str",  # Optional. Instruction of the
                              resource.
                            "product": "str",  # Optional. Product of the resource.
                            "rate": "str"  # Optional. Rate of the product.
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "recommendation": "str",  # Optional. Recommendation for this nutrient
                      analysis.
                    "referenceValueHigh": 0.0,  # Optional. Reference value high for this
                      nutrient analysis.
                    "referenceValueLow": 0.0,  # Optional. Reference value low for this nutrient
                      analysis.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "unit": "str",  # Optional. Unit for this nutrient analysis.
                    "value": 0.0  # Optional. Value for this nutrient analysis.
                }
        """

    @distributed_trace_async
    async def create_or_update(
        self, party_id: str, nutrient_analysis_id: str, nutrient_analysis: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        """Creates or updates a nutrient analysis resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param nutrient_analysis_id: Id of the nutrient analysis resource. Required.
        :type nutrient_analysis_id: str
        :param nutrient_analysis: NutrientAnalysis resource payload to create or update. Is either a
         model type or a IO type. Required.
        :type nutrient_analysis: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "classification": "str",  # Optional. Classification for this nutrient
                      analysis.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "parentId": "str",  # Optional. Parent id for this nutrient analysis.
                    "parentType": "str",  # Optional. Parent type for this nutrient
                      analysis."ni.e. PlantTissueAnalysis. "PlantTissueAnalysis"
                    "partyId": "str",  # Optional. Party id for this nutrient analysis.
                    "products": [
                        {
                            "instruction": "str",  # Optional. Instruction of the
                              resource.
                            "product": "str",  # Optional. Product of the resource.
                            "rate": "str"  # Optional. Rate of the product.
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "recommendation": "str",  # Optional. Recommendation for this nutrient
                      analysis.
                    "referenceValueHigh": 0.0,  # Optional. Reference value high for this
                      nutrient analysis.
                    "referenceValueLow": 0.0,  # Optional. Reference value low for this nutrient
                      analysis.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "unit": "str",  # Optional. Unit for this nutrient analysis.
                    "value": 0.0  # Optional. Value for this nutrient analysis.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(nutrient_analysis, (IO, bytes)):
            _content = nutrient_analysis
        else:
            _json = nutrient_analysis

        request = build_nutrient_analyses_create_or_update_request(
            party_id=party_id,
            nutrient_analysis_id=nutrient_analysis_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, party_id: str, nutrient_analysis_id: str, **kwargs: Any
    ) -> None:
        """Deletes a specified nutrient analysis resource under a particular party.

        :param party_id: Id of the party. Required.
        :type party_id: str
        :param nutrient_analysis_id: Id of the nutrient analysis. Required.
        :type nutrient_analysis_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_nutrient_analyses_delete_request(
            party_id=party_id,
            nutrient_analysis_id=nutrient_analysis_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class OAuthProvidersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`oauth_providers` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of oauthProvider resources.

        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "apiKey": "str",  # Optional. OAuth Api key for given Provider."nNote:
                      currently Applicable to Climate provider. Won't be sent in response.
                    "appId": "str",  # Optional. OAuth App Id for given OAuth Provider.
                    "appSecret": "str",  # Optional. OAuth App secret for given Provider."nNote:
                      Won't be sent in response.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique OAuth provider ID.
                    "isProductionApp": False,  # Optional. Default value is False. An optional
                      flag to determine if the App is ready to be used for Production scenarios in the
                      provider side or not. (Default value: false)"nNote: Currently applicable for
                      JohnDeere.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_oauth_providers_list_request(
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, oauth_provider_id: str, **kwargs: Any) -> JSON:
        """Get a specified oauthProvider resource.

        :param oauth_provider_id: ID of the oauthProvider resource. Required.
        :type oauth_provider_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "apiKey": "str",  # Optional. OAuth Api key for given Provider."nNote:
                      currently Applicable to Climate provider. Won't be sent in response.
                    "appId": "str",  # Optional. OAuth App Id for given OAuth Provider.
                    "appSecret": "str",  # Optional. OAuth App secret for given Provider."nNote:
                      Won't be sent in response.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique OAuth provider ID.
                    "isProductionApp": False,  # Optional. Default value is False. An optional
                      flag to determine if the App is ready to be used for Production scenarios in the
                      provider side or not. (Default value: false)"nNote: Currently applicable for
                      JohnDeere.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_oauth_providers_get_request(
            oauth_provider_id=oauth_provider_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update(
        self,
        oauth_provider_id: str,
        oauth_provider: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates an oauthProvider resource.

        :param oauth_provider_id: ID of oauthProvider resource. Required.
        :type oauth_provider_id: str
        :param oauth_provider: OauthProvider resource payload to create or update. Required.
        :type oauth_provider: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                oauth_provider = {
                    "apiKey": "str",  # Optional. OAuth Api key for given Provider."nNote:
                      currently Applicable to Climate provider. Won't be sent in response.
                    "appId": "str",  # Optional. OAuth App Id for given OAuth Provider.
                    "appSecret": "str",  # Optional. OAuth App secret for given Provider."nNote:
                      Won't be sent in response.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique OAuth provider ID.
                    "isProductionApp": False,  # Optional. Default value is False. An optional
                      flag to determine if the App is ready to be used for Production scenarios in the
                      provider side or not. (Default value: false)"nNote: Currently applicable for
                      JohnDeere.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    }
                }

                # response body for status code(s): 200, 201
                response == {
                    "apiKey": "str",  # Optional. OAuth Api key for given Provider."nNote:
                      currently Applicable to Climate provider. Won't be sent in response.
                    "appId": "str",  # Optional. OAuth App Id for given OAuth Provider.
                    "appSecret": "str",  # Optional. OAuth App secret for given Provider."nNote:
                      Won't be sent in response.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique OAuth provider ID.
                    "isProductionApp": False,  # Optional. Default value is False. An optional
                      flag to determine if the App is ready to be used for Production scenarios in the
                      provider side or not. (Default value: false)"nNote: Currently applicable for
                      JohnDeere.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    }
                }
        """

    @overload
    async def create_or_update(
        self,
        oauth_provider_id: str,
        oauth_provider: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates an oauthProvider resource.

        :param oauth_provider_id: ID of oauthProvider resource. Required.
        :type oauth_provider_id: str
        :param oauth_provider: OauthProvider resource payload to create or update. Required.
        :type oauth_provider: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "apiKey": "str",  # Optional. OAuth Api key for given Provider."nNote:
                      currently Applicable to Climate provider. Won't be sent in response.
                    "appId": "str",  # Optional. OAuth App Id for given OAuth Provider.
                    "appSecret": "str",  # Optional. OAuth App secret for given Provider."nNote:
                      Won't be sent in response.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique OAuth provider ID.
                    "isProductionApp": False,  # Optional. Default value is False. An optional
                      flag to determine if the App is ready to be used for Production scenarios in the
                      provider side or not. (Default value: false)"nNote: Currently applicable for
                      JohnDeere.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    }
                }
        """

    @distributed_trace_async
    async def create_or_update(self, oauth_provider_id: str, oauth_provider: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates or updates an oauthProvider resource.

        :param oauth_provider_id: ID of oauthProvider resource. Required.
        :type oauth_provider_id: str
        :param oauth_provider: OauthProvider resource payload to create or update. Is either a model
         type or a IO type. Required.
        :type oauth_provider: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "apiKey": "str",  # Optional. OAuth Api key for given Provider."nNote:
                      currently Applicable to Climate provider. Won't be sent in response.
                    "appId": "str",  # Optional. OAuth App Id for given OAuth Provider.
                    "appSecret": "str",  # Optional. OAuth App secret for given Provider."nNote:
                      Won't be sent in response.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique OAuth provider ID.
                    "isProductionApp": False,  # Optional. Default value is False. An optional
                      flag to determine if the App is ready to be used for Production scenarios in the
                      provider side or not. (Default value: false)"nNote: Currently applicable for
                      JohnDeere.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and"nonly
                          string, numeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(oauth_provider, (IO, bytes)):
            _content = oauth_provider
        else:
            _json = oauth_provider

        request = build_oauth_providers_create_or_update_request(
            oauth_provider_id=oauth_provider_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, oauth_provider_id: str, **kwargs: Any
    ) -> None:
        """Deletes an specified oauthProvider resource.

        :param oauth_provider_id: ID of oauthProvider. Required.
        :type oauth_provider_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_oauth_providers_delete_request(
            oauth_provider_id=oauth_provider_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def get_cascade_delete_job_details(self, job_id: str, **kwargs: Any) -> JSON:
        """Get cascade delete job for oauthProvider resource.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "oauthProviderId": "str",  # The id of the oauth provider. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_oauth_providers_get_cascade_delete_job_details_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    async def _create_cascade_delete_job_initial(self, job_id: str, *, oauth_provider_id: str, **kwargs: Any) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_oauth_providers_create_cascade_delete_job_request(
            job_id=job_id,
            oauth_provider_id=oauth_provider_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_create_cascade_delete_job(
        self, job_id: str, *, oauth_provider_id: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create cascade delete job for oauthProvider resource.

        :param job_id: Job Id supplied by end user. Required.
        :type job_id: str
        :keyword oauth_provider_id: Id of the application data. Required.
        :paramtype oauth_provider_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "oauthProviderId": "str",  # The id of the oauth provider. Required.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_cascade_delete_job_initial(  # type: ignore
                job_id=job_id,
                oauth_provider_id=oauth_provider_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)


class OAuthTokensOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`oauth_tokens` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        auth_provider_ids: Optional[List[str]] = None,
        party_ids: Optional[List[str]] = None,
        is_valid: Optional[bool] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a list of OAuthToken documents.

        :keyword auth_provider_ids: Name of AuthProvider. Default value is None.
        :paramtype auth_provider_ids: list[str]
        :keyword party_ids: List of parties. Default value is None.
        :paramtype party_ids: list[str]
        :keyword is_valid: If the token object is valid. Default value is None.
        :paramtype is_valid: bool
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "authProviderId": "str",  # ID of the OAuth provider resource containing app
                      information. Required.
                    "partyId": "str",  # Party ID for this OAuth config. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "isValid": True,  # Optional. Default value is True. An optional flag
                      indicating whether the token is a valid or expired (Default value: true).
                    "modifiedDateTime": "2020-02-20 00:00:00"  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_oauth_tokens_list_request(
                    auth_provider_ids=auth_provider_ids,
                    party_ids=party_ids,
                    is_valid=is_valid,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def get_o_auth_connection_link(
        self, oauth_connect_request: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> str:
        """Returns Connection link needed in the OAuth flow.

        :param oauth_connect_request: OAuth Connect Request. Required.
        :type oauth_connect_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: str
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                oauth_connect_request = {
                    "oAuthProviderId": "str",  # Id of the OAuthProvider. Required.
                    "partyId": "str",  # Id of the party. Required.
                    "userRedirectLink": "str",  # Link to redirect the user to, at the end of the
                      oauth flow. Required.
                    "userRedirectState": "str"  # Optional. State to provide back when
                      redirecting the user, at the end of the oauth flow.
                }
        """

    @overload
    async def get_o_auth_connection_link(
        self, oauth_connect_request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> str:
        """Returns Connection link needed in the OAuth flow.

        :param oauth_connect_request: OAuth Connect Request. Required.
        :type oauth_connect_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: str
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def get_o_auth_connection_link(self, oauth_connect_request: Union[JSON, IO], **kwargs: Any) -> str:
        """Returns Connection link needed in the OAuth flow.

        :param oauth_connect_request: OAuth Connect Request. Is either a model type or a IO type.
         Required.
        :type oauth_connect_request: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: str
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[str]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(oauth_connect_request, (IO, bytes)):
            _content = oauth_connect_request
        else:
            _json = oauth_connect_request

        request = build_oauth_tokens_get_o_auth_connection_link_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(str, deserialized), {})

        return cast(str, deserialized)

    @distributed_trace_async
    async def get_cascade_delete_job_details(self, job_id: str, **kwargs: Any) -> JSON:
        """Get remove job for OAuth token.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_oauth_tokens_get_cascade_delete_job_details_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    async def _create_cascade_delete_job_initial(
        self, job_id: str, *, party_id: str, oauth_provider_id: str, **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_oauth_tokens_create_cascade_delete_job_request(
            job_id=job_id,
            party_id=party_id,
            oauth_provider_id=oauth_provider_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_create_cascade_delete_job(
        self, job_id: str, *, party_id: str, oauth_provider_id: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create remove job for OAuth token.

        :param job_id: Job Id supplied by end user. Required.
        :type job_id: str
        :keyword party_id: Id of the party. Required.
        :paramtype party_id: str
        :keyword oauth_provider_id: Id of the OAuthProvider. Required.
        :paramtype oauth_provider_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_cascade_delete_job_initial(  # type: ignore
                job_id=job_id,
                party_id=party_id,
                oauth_provider_id=oauth_provider_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)


class PartiesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`parties` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        *,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of party resources.

        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_parties_list_request(
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, party_id: str, **kwargs: Any) -> JSON:
        """Gets a specified party resource.

        :param party_id: ID of the associated party. Required.
        :type party_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_parties_get_request(
            party_id=party_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update(
        self, party_id: str, party: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a party resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param party: Party resource payload to create or update. Required.
        :type party: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                party = {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """

    @overload
    async def create_or_update(
        self, party_id: str, party: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a party resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param party: Party resource payload to create or update. Required.
        :type party: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """

    @distributed_trace_async
    async def create_or_update(self, party_id: str, party: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates or updates a party resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param party: Party resource payload to create or update. Is either a model type or a IO type.
         Required.
        :type party: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(party, (IO, bytes)):
            _content = party
        else:
            _json = party

        request = build_parties_create_or_update_request(
            party_id=party_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(self, party_id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Deletes a specified party resource.

        :param party_id: Id of party to be deleted. Required.
        :type party_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_parties_delete_request(
            party_id=party_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def get_cascade_delete_job_details(self, job_id: str, **kwargs: Any) -> JSON:
        """Get a cascade delete job for specified party.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_parties_get_cascade_delete_job_details_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    async def _create_cascade_delete_job_initial(self, job_id: str, *, party_id: str, **kwargs: Any) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_parties_create_cascade_delete_job_request(
            job_id=job_id,
            party_id=party_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_create_cascade_delete_job(
        self, job_id: str, *, party_id: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a cascade delete job for specified party.

        :param job_id: Job ID supplied by end user. Required.
        :type job_id: str
        :keyword party_id: ID of the party to be deleted. Required.
        :paramtype party_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_cascade_delete_job_initial(  # type: ignore
                job_id=job_id, party_id=party_id, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)


class PlantingDataOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`planting_data` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_party_id(
        self,
        party_id: str,
        *,
        min_avg_planting_rate: Optional[float] = None,
        max_avg_planting_rate: Optional[float] = None,
        min_total_material: Optional[float] = None,
        max_total_material: Optional[float] = None,
        min_avg_material: Optional[float] = None,
        max_avg_material: Optional[float] = None,
        sources: Optional[List[str]] = None,
        associated_boundary_ids: Optional[List[str]] = None,
        min_operation_start_date_time: Optional[datetime.datetime] = None,
        max_operation_start_date_time: Optional[datetime.datetime] = None,
        min_operation_end_date_time: Optional[datetime.datetime] = None,
        max_operation_end_date_time: Optional[datetime.datetime] = None,
        min_operation_modified_date_time: Optional[datetime.datetime] = None,
        max_operation_modified_date_time: Optional[datetime.datetime] = None,
        min_area: Optional[float] = None,
        max_area: Optional[float] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of planting data resources under a particular party.

        :param party_id: ID of the associated party. Required.
        :type party_id: str
        :keyword min_avg_planting_rate: Minimum AvgPlantingRate value(inclusive). Default value is
         None.
        :paramtype min_avg_planting_rate: float
        :keyword max_avg_planting_rate: Maximum AvgPlantingRate value (inclusive). Default value is
         None.
        :paramtype max_avg_planting_rate: float
        :keyword min_total_material: Minimum TotalMaterial value(inclusive). Default value is None.
        :paramtype min_total_material: float
        :keyword max_total_material: Maximum TotalMaterial value (inclusive). Default value is None.
        :paramtype max_total_material: float
        :keyword min_avg_material: Minimum AvgMaterial value(inclusive). Default value is None.
        :paramtype min_avg_material: float
        :keyword max_avg_material: Maximum AvgMaterial value (inclusive). Default value is None.
        :paramtype max_avg_material: float
        :keyword sources: Sources of the operation data. Default value is None.
        :paramtype sources: list[str]
        :keyword associated_boundary_ids: Boundary IDs associated with operation data. Default value is
         None.
        :paramtype associated_boundary_ids: list[str]
        :keyword min_operation_start_date_time: Minimum start date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_start_date_time: ~datetime.datetime
        :keyword max_operation_start_date_time: Maximum start date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_start_date_time: ~datetime.datetime
        :keyword min_operation_end_date_time: Minimum end date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_end_date_time: ~datetime.datetime
        :keyword max_operation_end_date_time: Maximum end date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_end_date_time: ~datetime.datetime
        :keyword min_operation_modified_date_time: Minimum modified date-time of the operation data,
         sample format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_modified_date_time: ~datetime.datetime
        :keyword max_operation_modified_date_time: Maximum modified date-time of the operation data,
         sample format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_modified_date_time: ~datetime.datetime
        :keyword min_area: Minimum area for which operation was applied (inclusive). Default value is
         None.
        :paramtype min_area: float
        :keyword max_area: Maximum area for which operation was applied (inclusive). Default value is
         None.
        :paramtype max_area: float
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgPlantingRate": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "plantingProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_planting_data_list_by_party_id_request(
                    party_id=party_id,
                    min_avg_planting_rate=min_avg_planting_rate,
                    max_avg_planting_rate=max_avg_planting_rate,
                    min_total_material=min_total_material,
                    max_total_material=max_total_material,
                    min_avg_material=min_avg_material,
                    max_avg_material=max_avg_material,
                    sources=sources,
                    associated_boundary_ids=associated_boundary_ids,
                    min_operation_start_date_time=min_operation_start_date_time,
                    max_operation_start_date_time=max_operation_start_date_time,
                    min_operation_end_date_time=min_operation_end_date_time,
                    max_operation_end_date_time=max_operation_end_date_time,
                    min_operation_modified_date_time=min_operation_modified_date_time,
                    max_operation_modified_date_time=max_operation_modified_date_time,
                    min_area=min_area,
                    max_area=max_area,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, party_id: str, planting_data_id: str, **kwargs: Any) -> JSON:
        """Get a specified planting data resource under a particular party.

        :param party_id: ID of the associated party resource. Required.
        :type party_id: str
        :param planting_data_id: ID of the planting data resource. Required.
        :type planting_data_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgPlantingRate": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "plantingProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_planting_data_get_request(
            party_id=party_id,
            planting_data_id=planting_data_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update(
        self,
        party_id: str,
        planting_data_id: str,
        planting_data: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates an planting data resource under a particular party.

        :param party_id: ID of the associated party. Required.
        :type party_id: str
        :param planting_data_id: ID of the planting data resource. Required.
        :type planting_data_id: str
        :param planting_data: Planting data resource payload to create or update. Required.
        :type planting_data: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                planting_data = {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgPlantingRate": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "plantingProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }

                # response body for status code(s): 200, 201
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgPlantingRate": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "plantingProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """

    @overload
    async def create_or_update(
        self,
        party_id: str,
        planting_data_id: str,
        planting_data: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates an planting data resource under a particular party.

        :param party_id: ID of the associated party. Required.
        :type party_id: str
        :param planting_data_id: ID of the planting data resource. Required.
        :type planting_data_id: str
        :param planting_data: Planting data resource payload to create or update. Required.
        :type planting_data: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgPlantingRate": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "plantingProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """

    @distributed_trace_async
    async def create_or_update(
        self, party_id: str, planting_data_id: str, planting_data: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        """Creates or updates an planting data resource under a particular party.

        :param party_id: ID of the associated party. Required.
        :type party_id: str
        :param planting_data_id: ID of the planting data resource. Required.
        :type planting_data_id: str
        :param planting_data: Planting data resource payload to create or update. Is either a model
         type or a IO type. Required.
        :type planting_data: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgPlantingRate": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "plantingProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(planting_data, (IO, bytes)):
            _content = planting_data
        else:
            _json = planting_data

        request = build_planting_data_create_or_update_request(
            party_id=party_id,
            planting_data_id=planting_data_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, party_id: str, planting_data_id: str, **kwargs: Any
    ) -> None:
        """Deletes a specified planting data resource under a particular party.

        :param party_id: ID of the associated party resource. Required.
        :type party_id: str
        :param planting_data_id: ID of the planting data. Required.
        :type planting_data_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_planting_data_delete_request(
            party_id=party_id,
            planting_data_id=planting_data_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list(
        self,
        *,
        min_avg_planting_rate: Optional[float] = None,
        max_avg_planting_rate: Optional[float] = None,
        min_total_material: Optional[float] = None,
        max_total_material: Optional[float] = None,
        min_avg_material: Optional[float] = None,
        max_avg_material: Optional[float] = None,
        sources: Optional[List[str]] = None,
        associated_boundary_ids: Optional[List[str]] = None,
        min_operation_start_date_time: Optional[datetime.datetime] = None,
        max_operation_start_date_time: Optional[datetime.datetime] = None,
        min_operation_end_date_time: Optional[datetime.datetime] = None,
        max_operation_end_date_time: Optional[datetime.datetime] = None,
        min_operation_modified_date_time: Optional[datetime.datetime] = None,
        max_operation_modified_date_time: Optional[datetime.datetime] = None,
        min_area: Optional[float] = None,
        max_area: Optional[float] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of planting data resources across all parties.

        :keyword min_avg_planting_rate: Minimum AvgPlantingRate value(inclusive). Default value is
         None.
        :paramtype min_avg_planting_rate: float
        :keyword max_avg_planting_rate: Maximum AvgPlantingRate value (inclusive). Default value is
         None.
        :paramtype max_avg_planting_rate: float
        :keyword min_total_material: Minimum TotalMaterial value(inclusive). Default value is None.
        :paramtype min_total_material: float
        :keyword max_total_material: Maximum TotalMaterial value (inclusive). Default value is None.
        :paramtype max_total_material: float
        :keyword min_avg_material: Minimum AvgMaterial value(inclusive). Default value is None.
        :paramtype min_avg_material: float
        :keyword max_avg_material: Maximum AvgMaterial value (inclusive). Default value is None.
        :paramtype max_avg_material: float
        :keyword sources: Sources of the operation data. Default value is None.
        :paramtype sources: list[str]
        :keyword associated_boundary_ids: Boundary IDs associated with operation data. Default value is
         None.
        :paramtype associated_boundary_ids: list[str]
        :keyword min_operation_start_date_time: Minimum start date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_start_date_time: ~datetime.datetime
        :keyword max_operation_start_date_time: Maximum start date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_start_date_time: ~datetime.datetime
        :keyword min_operation_end_date_time: Minimum end date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_end_date_time: ~datetime.datetime
        :keyword max_operation_end_date_time: Maximum end date-time of the operation data, sample
         format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_end_date_time: ~datetime.datetime
        :keyword min_operation_modified_date_time: Minimum modified date-time of the operation data,
         sample format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype min_operation_modified_date_time: ~datetime.datetime
        :keyword max_operation_modified_date_time: Maximum modified date-time of the operation data,
         sample format: yyyy-MM-ddTHH:mm:ssZ (inclusive). Default value is None.
        :paramtype max_operation_modified_date_time: ~datetime.datetime
        :keyword min_area: Minimum area for which operation was applied (inclusive). Default value is
         None.
        :paramtype min_area: float
        :keyword max_area: Maximum area for which operation was applied (inclusive). Default value is
         None.
        :paramtype max_area: float
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "area": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "associatedBoundaryId": "str",  # Optional. Optional boundary ID of the field
                      for which operation was applied.
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "avgMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "avgPlantingRate": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    },
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "operationEndDateTime": "2020-02-20 00:00:00",  # Optional. End date-time of
                      the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "operationModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Modified
                      date-time of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ."nNote: this
                      will be specified by the source provider itself.
                    "operationStartDateTime": "2020-02-20 00:00:00",  # Optional. Start date-time
                      of the operation data, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "partyId": "str",  # Optional. Party ID which belongs to the operation data.
                    "plantingProductDetails": [
                        {
                            "area": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "avgMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            },
                            "productName": "str",  # Optional. Name of the product.
                            "totalMaterial": {
                                "unit": "str",  # Optional. Data unit.
                                "value": 0.0  # Optional. Data value.
                            }
                        }
                    ],
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "totalMaterial": {
                        "unit": "str",  # Optional. Data unit.
                        "value": 0.0  # Optional. Data value.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_planting_data_list_request(
                    min_avg_planting_rate=min_avg_planting_rate,
                    max_avg_planting_rate=max_avg_planting_rate,
                    min_total_material=min_total_material,
                    max_total_material=max_total_material,
                    min_avg_material=min_avg_material,
                    max_avg_material=max_avg_material,
                    sources=sources,
                    associated_boundary_ids=associated_boundary_ids,
                    min_operation_start_date_time=min_operation_start_date_time,
                    max_operation_start_date_time=max_operation_start_date_time,
                    min_operation_end_date_time=min_operation_end_date_time,
                    max_operation_end_date_time=max_operation_end_date_time,
                    min_operation_modified_date_time=min_operation_modified_date_time,
                    max_operation_modified_date_time=max_operation_modified_date_time,
                    min_area=min_area,
                    max_area=max_area,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _create_cascade_delete_job_initial(
        self, job_id: str, *, party_id: str, planting_data_id: str, **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_planting_data_create_cascade_delete_job_request(
            job_id=job_id,
            party_id=party_id,
            planting_data_id=planting_data_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_create_cascade_delete_job(
        self, job_id: str, *, party_id: str, planting_data_id: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create cascade delete job for planting data resource.

        :param job_id: Job Id supplied by end user. Required.
        :type job_id: str
        :keyword party_id: Id of the party. Required.
        :paramtype party_id: str
        :keyword planting_data_id: Id of the planting data. Required.
        :paramtype planting_data_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_cascade_delete_job_initial(  # type: ignore
                job_id=job_id,
                party_id=party_id,
                planting_data_id=planting_data_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace_async
    async def get_cascade_delete_job_details(self, job_id: str, **kwargs: Any) -> JSON:
        """Get cascade delete job for planting data resource.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_planting_data_get_cascade_delete_job_details_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class PlantTissueAnalysesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`plant_tissue_analyses` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_party_id(
        self,
        party_id: str,
        *,
        season_ids: Optional[List[str]] = None,
        crop_ids: Optional[List[str]] = None,
        crop_products_ids: Optional[List[str]] = None,
        field_ids: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of plant tissue analysis resources under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :keyword season_ids: Season ids of the plant tissue analyses. Default value is None.
        :paramtype season_ids: list[str]
        :keyword crop_ids: Crop ids of the plant tissue analyses. Default value is None.
        :paramtype crop_ids: list[str]
        :keyword crop_products_ids: Crop products ids of the plant tissue analyses. Default value is
         None.
        :paramtype crop_products_ids: list[str]
        :keyword field_ids: Field ids of the plant tissue analyses. Default value is None.
        :paramtype field_ids: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Id of the associated Crop.
                    "cropProductId": "str",  # Optional. Id of the associated Crop product.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Id of the associated Field.
                    "growthStage": "str",  # Optional. Growth stage for this plant tissue
                      analysis.
                    "id": "str",  # Optional. Unique resource ID.
                    "labDetails": {
                        "address": "str",  # Optional. Address of the resource.
                        "code": "str",  # Optional. Code of the resource.
                        "description": "str",  # Optional. Description of the resource.
                        "name": "str"  # Optional. Name of the resource.
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Id of the associated Party.
                    "plantAppearance": "str",  # Optional. Plant appearance for this plant tissue
                      analysis.
                    "plantPart": "str",  # Optional. Plant part for this plant tissue analysis.
                    "plantPosition": "str",  # Optional. Plant position for this plant tissue
                      analysis.
                    "plantingDateTime": "2020-02-20 00:00:00",  # Optional. Planting datetime for
                      this plant tissue analysis.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "sampleCollectionCondition": "str",  # Optional. Sample collection condition
                      for this plant tissue analysis.
                    "sampleCollectionDateTime": "2020-02-20 00:00:00",  # Optional. Sample
                      collection dateTime for this plant tissue analysis.
                    "sampleReceivedDateTime": "2020-02-20 00:00:00",  # Optional. Sample received
                      dateTime.
                    "sampleTestResultDateTime": "2020-02-20 00:00:00",  # Optional. Sample test
                      result dateTime for this plant tissue analysis.
                    "seasonId": "str",  # Optional. Id of the associated Season.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_plant_tissue_analyses_list_by_party_id_request(
                    party_id=party_id,
                    season_ids=season_ids,
                    crop_ids=crop_ids,
                    crop_products_ids=crop_products_ids,
                    field_ids=field_ids,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, party_id: str, plant_tissue_analysis_id: str, **kwargs: Any) -> JSON:
        """Gets a specified plant tissue analysis resource under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param plant_tissue_analysis_id: Id of the plant tissue analysis. Required.
        :type plant_tissue_analysis_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Id of the associated Crop.
                    "cropProductId": "str",  # Optional. Id of the associated Crop product.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Id of the associated Field.
                    "growthStage": "str",  # Optional. Growth stage for this plant tissue
                      analysis.
                    "id": "str",  # Optional. Unique resource ID.
                    "labDetails": {
                        "address": "str",  # Optional. Address of the resource.
                        "code": "str",  # Optional. Code of the resource.
                        "description": "str",  # Optional. Description of the resource.
                        "name": "str"  # Optional. Name of the resource.
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Id of the associated Party.
                    "plantAppearance": "str",  # Optional. Plant appearance for this plant tissue
                      analysis.
                    "plantPart": "str",  # Optional. Plant part for this plant tissue analysis.
                    "plantPosition": "str",  # Optional. Plant position for this plant tissue
                      analysis.
                    "plantingDateTime": "2020-02-20 00:00:00",  # Optional. Planting datetime for
                      this plant tissue analysis.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "sampleCollectionCondition": "str",  # Optional. Sample collection condition
                      for this plant tissue analysis.
                    "sampleCollectionDateTime": "2020-02-20 00:00:00",  # Optional. Sample
                      collection dateTime for this plant tissue analysis.
                    "sampleReceivedDateTime": "2020-02-20 00:00:00",  # Optional. Sample received
                      dateTime.
                    "sampleTestResultDateTime": "2020-02-20 00:00:00",  # Optional. Sample test
                      result dateTime for this plant tissue analysis.
                    "seasonId": "str",  # Optional. Id of the associated Season.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_plant_tissue_analyses_get_request(
            party_id=party_id,
            plant_tissue_analysis_id=plant_tissue_analysis_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update(
        self,
        party_id: str,
        plant_tissue_analysis_id: str,
        plant_tissue_analysis: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates a plant tissue analysis resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param plant_tissue_analysis_id: Id of the plant tissue analysis resource. Required.
        :type plant_tissue_analysis_id: str
        :param plant_tissue_analysis: PlantTissueAnalysis resource payload to create or update.
         Required.
        :type plant_tissue_analysis: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                plant_tissue_analysis = {
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Id of the associated Crop.
                    "cropProductId": "str",  # Optional. Id of the associated Crop product.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Id of the associated Field.
                    "growthStage": "str",  # Optional. Growth stage for this plant tissue
                      analysis.
                    "id": "str",  # Optional. Unique resource ID.
                    "labDetails": {
                        "address": "str",  # Optional. Address of the resource.
                        "code": "str",  # Optional. Code of the resource.
                        "description": "str",  # Optional. Description of the resource.
                        "name": "str"  # Optional. Name of the resource.
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Id of the associated Party.
                    "plantAppearance": "str",  # Optional. Plant appearance for this plant tissue
                      analysis.
                    "plantPart": "str",  # Optional. Plant part for this plant tissue analysis.
                    "plantPosition": "str",  # Optional. Plant position for this plant tissue
                      analysis.
                    "plantingDateTime": "2020-02-20 00:00:00",  # Optional. Planting datetime for
                      this plant tissue analysis.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "sampleCollectionCondition": "str",  # Optional. Sample collection condition
                      for this plant tissue analysis.
                    "sampleCollectionDateTime": "2020-02-20 00:00:00",  # Optional. Sample
                      collection dateTime for this plant tissue analysis.
                    "sampleReceivedDateTime": "2020-02-20 00:00:00",  # Optional. Sample received
                      dateTime.
                    "sampleTestResultDateTime": "2020-02-20 00:00:00",  # Optional. Sample test
                      result dateTime for this plant tissue analysis.
                    "seasonId": "str",  # Optional. Id of the associated Season.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }

                # response body for status code(s): 200, 201
                response == {
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Id of the associated Crop.
                    "cropProductId": "str",  # Optional. Id of the associated Crop product.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Id of the associated Field.
                    "growthStage": "str",  # Optional. Growth stage for this plant tissue
                      analysis.
                    "id": "str",  # Optional. Unique resource ID.
                    "labDetails": {
                        "address": "str",  # Optional. Address of the resource.
                        "code": "str",  # Optional. Code of the resource.
                        "description": "str",  # Optional. Description of the resource.
                        "name": "str"  # Optional. Name of the resource.
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Id of the associated Party.
                    "plantAppearance": "str",  # Optional. Plant appearance for this plant tissue
                      analysis.
                    "plantPart": "str",  # Optional. Plant part for this plant tissue analysis.
                    "plantPosition": "str",  # Optional. Plant position for this plant tissue
                      analysis.
                    "plantingDateTime": "2020-02-20 00:00:00",  # Optional. Planting datetime for
                      this plant tissue analysis.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "sampleCollectionCondition": "str",  # Optional. Sample collection condition
                      for this plant tissue analysis.
                    "sampleCollectionDateTime": "2020-02-20 00:00:00",  # Optional. Sample
                      collection dateTime for this plant tissue analysis.
                    "sampleReceivedDateTime": "2020-02-20 00:00:00",  # Optional. Sample received
                      dateTime.
                    "sampleTestResultDateTime": "2020-02-20 00:00:00",  # Optional. Sample test
                      result dateTime for this plant tissue analysis.
                    "seasonId": "str",  # Optional. Id of the associated Season.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """

    @overload
    async def create_or_update(
        self,
        party_id: str,
        plant_tissue_analysis_id: str,
        plant_tissue_analysis: IO,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Creates or updates a plant tissue analysis resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param plant_tissue_analysis_id: Id of the plant tissue analysis resource. Required.
        :type plant_tissue_analysis_id: str
        :param plant_tissue_analysis: PlantTissueAnalysis resource payload to create or update.
         Required.
        :type plant_tissue_analysis: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Id of the associated Crop.
                    "cropProductId": "str",  # Optional. Id of the associated Crop product.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Id of the associated Field.
                    "growthStage": "str",  # Optional. Growth stage for this plant tissue
                      analysis.
                    "id": "str",  # Optional. Unique resource ID.
                    "labDetails": {
                        "address": "str",  # Optional. Address of the resource.
                        "code": "str",  # Optional. Code of the resource.
                        "description": "str",  # Optional. Description of the resource.
                        "name": "str"  # Optional. Name of the resource.
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Id of the associated Party.
                    "plantAppearance": "str",  # Optional. Plant appearance for this plant tissue
                      analysis.
                    "plantPart": "str",  # Optional. Plant part for this plant tissue analysis.
                    "plantPosition": "str",  # Optional. Plant position for this plant tissue
                      analysis.
                    "plantingDateTime": "2020-02-20 00:00:00",  # Optional. Planting datetime for
                      this plant tissue analysis.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "sampleCollectionCondition": "str",  # Optional. Sample collection condition
                      for this plant tissue analysis.
                    "sampleCollectionDateTime": "2020-02-20 00:00:00",  # Optional. Sample
                      collection dateTime for this plant tissue analysis.
                    "sampleReceivedDateTime": "2020-02-20 00:00:00",  # Optional. Sample received
                      dateTime.
                    "sampleTestResultDateTime": "2020-02-20 00:00:00",  # Optional. Sample test
                      result dateTime for this plant tissue analysis.
                    "seasonId": "str",  # Optional. Id of the associated Season.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """

    @distributed_trace_async
    async def create_or_update(
        self, party_id: str, plant_tissue_analysis_id: str, plant_tissue_analysis: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        """Creates or updates a plant tissue analysis resource.

        :param party_id: Id of the party resource. Required.
        :type party_id: str
        :param plant_tissue_analysis_id: Id of the plant tissue analysis resource. Required.
        :type plant_tissue_analysis_id: str
        :param plant_tissue_analysis: PlantTissueAnalysis resource payload to create or update. Is
         either a model type or a IO type. Required.
        :type plant_tissue_analysis: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Id of the associated Crop.
                    "cropProductId": "str",  # Optional. Id of the associated Crop product.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Id of the associated Field.
                    "growthStage": "str",  # Optional. Growth stage for this plant tissue
                      analysis.
                    "id": "str",  # Optional. Unique resource ID.
                    "labDetails": {
                        "address": "str",  # Optional. Address of the resource.
                        "code": "str",  # Optional. Code of the resource.
                        "description": "str",  # Optional. Description of the resource.
                        "name": "str"  # Optional. Name of the resource.
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Id of the associated Party.
                    "plantAppearance": "str",  # Optional. Plant appearance for this plant tissue
                      analysis.
                    "plantPart": "str",  # Optional. Plant part for this plant tissue analysis.
                    "plantPosition": "str",  # Optional. Plant position for this plant tissue
                      analysis.
                    "plantingDateTime": "2020-02-20 00:00:00",  # Optional. Planting datetime for
                      this plant tissue analysis.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "sampleCollectionCondition": "str",  # Optional. Sample collection condition
                      for this plant tissue analysis.
                    "sampleCollectionDateTime": "2020-02-20 00:00:00",  # Optional. Sample
                      collection dateTime for this plant tissue analysis.
                    "sampleReceivedDateTime": "2020-02-20 00:00:00",  # Optional. Sample received
                      dateTime.
                    "sampleTestResultDateTime": "2020-02-20 00:00:00",  # Optional. Sample test
                      result dateTime for this plant tissue analysis.
                    "seasonId": "str",  # Optional. Id of the associated Season.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(plant_tissue_analysis, (IO, bytes)):
            _content = plant_tissue_analysis
        else:
            _json = plant_tissue_analysis

        request = build_plant_tissue_analyses_create_or_update_request(
            party_id=party_id,
            plant_tissue_analysis_id=plant_tissue_analysis_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, party_id: str, plant_tissue_analysis_id: str, **kwargs: Any
    ) -> None:
        """Deletes a specified plant tissue analysis resource under a particular party.

        :param party_id: Id of the party. Required.
        :type party_id: str
        :param plant_tissue_analysis_id: Id of the plant tissue analysis. Required.
        :type plant_tissue_analysis_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_plant_tissue_analyses_delete_request(
            party_id=party_id,
            plant_tissue_analysis_id=plant_tissue_analysis_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list(
        self,
        *,
        season_ids: Optional[List[str]] = None,
        crop_ids: Optional[List[str]] = None,
        crop_products_ids: Optional[List[str]] = None,
        field_ids: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of plant tissue analysis resources across all parties.

        :keyword season_ids: Season ids of the plant tissue analyses. Default value is None.
        :paramtype season_ids: list[str]
        :keyword crop_ids: Crop ids of the plant tissue analyses. Default value is None.
        :paramtype crop_ids: list[str]
        :keyword crop_products_ids: Crop products ids of the plant tissue analyses. Default value is
         None.
        :paramtype crop_products_ids: list[str]
        :keyword field_ids: Field ids of the plant tissue analyses. Default value is None.
        :paramtype field_ids: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "attachmentsLink": "str",  # Optional. Link for attachments.
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Id of the associated Crop.
                    "cropProductId": "str",  # Optional. Id of the associated Crop product.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Id of the associated Field.
                    "growthStage": "str",  # Optional. Growth stage for this plant tissue
                      analysis.
                    "id": "str",  # Optional. Unique resource ID.
                    "labDetails": {
                        "address": "str",  # Optional. Address of the resource.
                        "code": "str",  # Optional. Code of the resource.
                        "description": "str",  # Optional. Description of the resource.
                        "name": "str"  # Optional. Name of the resource.
                    },
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Id of the associated Party.
                    "plantAppearance": "str",  # Optional. Plant appearance for this plant tissue
                      analysis.
                    "plantPart": "str",  # Optional. Plant part for this plant tissue analysis.
                    "plantPosition": "str",  # Optional. Plant position for this plant tissue
                      analysis.
                    "plantingDateTime": "2020-02-20 00:00:00",  # Optional. Planting datetime for
                      this plant tissue analysis.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "sampleCollectionCondition": "str",  # Optional. Sample collection condition
                      for this plant tissue analysis.
                    "sampleCollectionDateTime": "2020-02-20 00:00:00",  # Optional. Sample
                      collection dateTime for this plant tissue analysis.
                    "sampleReceivedDateTime": "2020-02-20 00:00:00",  # Optional. Sample received
                      dateTime.
                    "sampleTestResultDateTime": "2020-02-20 00:00:00",  # Optional. Sample test
                      result dateTime for this plant tissue analysis.
                    "seasonId": "str",  # Optional. Id of the associated Season.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str"  # Optional. Status of the resource.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_plant_tissue_analyses_list_request(
                    season_ids=season_ids,
                    crop_ids=crop_ids,
                    crop_products_ids=crop_products_ids,
                    field_ids=field_ids,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _create_cascade_delete_job_initial(
        self, job_id: str, *, party_id: str, plant_tissue_analysis_id: str, **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_plant_tissue_analyses_create_cascade_delete_job_request(
            job_id=job_id,
            party_id=party_id,
            plant_tissue_analysis_id=plant_tissue_analysis_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def begin_create_cascade_delete_job(
        self, job_id: str, *, party_id: str, plant_tissue_analysis_id: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create a cascade delete job for specified plant tissue analysis.

        :param job_id: Job ID supplied by end user. Required.
        :type job_id: str
        :keyword party_id: ID of the associated party. Required.
        :paramtype party_id: str
        :keyword plant_tissue_analysis_id: ID of the plant tissue analysis to be deleted. Required.
        :paramtype plant_tissue_analysis_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 202
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_cascade_delete_job_initial(  # type: ignore
                job_id=job_id,
                party_id=party_id,
                plant_tissue_analysis_id=plant_tissue_analysis_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace_async
    async def get_cascade_delete_job_details(self, job_id: str, **kwargs: Any) -> JSON:
        """Get a cascade delete job for specified plant tissue analysis.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "partyId": "str",  # Party Id. Required.
                    "resourceId": "str",  # The id of the resource. Required.
                    "resourceType": "str",  # The type of the resource. Required.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Job created at
                      dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "durationInSeconds": 0.0,  # Optional. Duration of the job in seconds.
                    "endTime": "2020-02-20 00:00:00",  # Optional. Job end time when available.
                      Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "errorCode": "str",  # Optional. Error Code when job failed.
                    "id": "str",  # Optional. Unique job id.
                    "lastActionDateTime": "2020-02-20 00:00:00",  # Optional. Job was last acted
                      upon at dateTime. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "message": "str",  # Optional. Status message to capture more details of the
                      job.
                    "startTime": "2020-02-20 00:00:00",  # Optional. Job start time when
                      available. Sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "status": "str"  # Optional. Status of the job."nPossible values: 'Waiting',
                      'Running', 'Succeeded', 'Failed', 'Cancelled'. Known values are: "Waiting",
                      "Running", "Succeeded", "Failed", and "Cancelled".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_plant_tissue_analyses_get_cascade_delete_job_details_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class PrescriptionMapsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.agrifood.farming.aio.FarmBeatsClient`'s
        :attr:`prescription_maps` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_party_id(
        self,
        party_id: str,
        *,
        types: Optional[List[str]] = None,
        crop_ids: Optional[List[str]] = None,
        season_ids: Optional[List[str]] = None,
        field_ids: Optional[List[str]] = None,
        sources: Optional[List[str]] = None,
        ids: Optional[List[str]] = None,
        names: Optional[List[str]] = None,
        property_filters: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        min_created_date_time: Optional[datetime.datetime] = None,
        max_created_date_time: Optional[datetime.datetime] = None,
        min_last_modified_date_time: Optional[datetime.datetime] = None,
        max_last_modified_date_time: Optional[datetime.datetime] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Returns a paginated list of prescription map resources under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :keyword types: Types of the resource. Default value is None.
        :paramtype types: list[str]
        :keyword crop_ids: Crop Ids of the resource. Default value is None.
        :paramtype crop_ids: list[str]
        :keyword season_ids: Season Ids of the resource. Default value is None.
        :paramtype season_ids: list[str]
        :keyword field_ids: Field Ids of the resource. Default value is None.
        :paramtype field_ids: list[str]
        :keyword sources: Sources for the resource. Default value is None.
        :paramtype sources: list[str]
        :keyword ids: Ids of the resource. Default value is None.
        :paramtype ids: list[str]
        :keyword names: Names of the resource. Default value is None.
        :paramtype names: list[str]
        :keyword property_filters: Filters on key-value pairs within the Properties object.
         eg. "{testKey} eq {testValue}". Default value is None.
        :paramtype property_filters: list[str]
        :keyword statuses: Statuses of the resource. Default value is None.
        :paramtype statuses: list[str]
        :keyword min_created_date_time: Minimum creation date of resource (inclusive). Default value is
         None.
        :paramtype min_created_date_time: ~datetime.datetime
        :keyword max_created_date_time: Maximum creation date of resource (inclusive). Default value is
         None.
        :paramtype max_created_date_time: ~datetime.datetime
        :keyword min_last_modified_date_time: Minimum last modified date of resource (inclusive).
         Default value is None.
        :paramtype min_last_modified_date_time: ~datetime.datetime
        :keyword max_last_modified_date_time: Maximum last modified date of resource (inclusive).
         Default value is None.
        :paramtype max_last_modified_date_time: ~datetime.datetime
        :keyword skip_token: Skip token for getting next set of results. Default value is None.
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Crop Id.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Field Id.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "partyId": "str",  # Optional. Party Id.
                    "properties": {
                        "str": {}  # Optional. A collection of key value pairs that belongs
                          to the resource."nEach pair must not have a key greater than 50
                          characters"nand must not have a value greater than 150 characters."nNote: A
                          maximum of 25 key value pairs can be provided for a resource and only
                          string,"nnumeral and datetime (yyyy-MM-ddTHH:mm:ssZ) values are supported.
                    },
                    "seasonId": "str",  # Optional. Season Id.
                    "source": "str",  # Optional. Source of the resource.
                    "status": "str",  # Optional. Status of the resource.
                    "type": "str"  # Optional. Prescription map type.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_prescription_maps_list_by_party_id_request(
                    party_id=party_id,
                    types=types,
                    crop_ids=crop_ids,
                    season_ids=season_ids,
                    field_ids=field_ids,
                    sources=sources,
                    ids=ids,
                    names=names,
                    property_filters=property_filters,
                    statuses=statuses,
                    min_created_date_time=min_created_date_time,
                    max_created_date_time=max_created_date_time,
                    min_last_modified_date_time=min_last_modified_date_time,
                    max_last_modified_date_time=max_last_modified_date_time,
                    skip_token=skip_token,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request.url = self._client.format_url(request.url)  # type: ignore

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, party_id: str, prescription_map_id: str, **kwargs: Any) -> JSON:
        """Gets a specified prescription map resource under a particular party.

        :param party_id: Id of the associated party. Required.
        :type party_id: str
        :param prescription_map_id: Id of the prescription map. Required.
        :type prescription_map_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. Created by user/tenant id.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was created, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "cropId": "str",  # Optional. Crop Id.
                    "description": "str",  # Optional. Textual description of the resource.
                    "eTag": "str",  # Optional. The ETag value to implement optimistic
                      concurrency.
                    "fieldId": "str",  # Optional. Field Id.
                    "id": "str",  # Optional. Unique resource ID.
                    "modifiedBy": "str",  # Optional. Modified by user/tenant id.
                    "modifiedDateTime": "2020-02-20 00:00:00",  # Optional. Date-time when
                      resource was last modified, sample format: yyyy-MM-ddTHH:mm:ssZ.
                    "name": "str",  # Optional. Name to identify resource.
                    "