# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
import functools
from typing import Any, AsyncIterable, Callable, Dict, Generic, Optional, TypeVar
import warnings

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._diagnostics_operations import build_execute_site_analysis_request, build_execute_site_analysis_slot_request, build_execute_site_detector_request, build_execute_site_detector_slot_request, build_get_hosting_environment_detector_response_request, build_get_site_analysis_request, build_get_site_analysis_slot_request, build_get_site_detector_request, build_get_site_detector_response_request, build_get_site_detector_response_slot_request, build_get_site_detector_slot_request, build_get_site_diagnostic_category_request, build_get_site_diagnostic_category_slot_request, build_list_hosting_environment_detector_responses_request, build_list_site_analyses_request, build_list_site_analyses_slot_request, build_list_site_detector_responses_request, build_list_site_detector_responses_slot_request, build_list_site_detectors_request, build_list_site_detectors_slot_request, build_list_site_diagnostic_categories_request, build_list_site_diagnostic_categories_slot_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class DiagnosticsOperations:
    """DiagnosticsOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.web.v2020_09_01.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def list_hosting_environment_detector_responses(
        self,
        resource_group_name: str,
        name: str,
        **kwargs: Any
    ) -> AsyncIterable["_models.DetectorResponseCollection"]:
        """List Hosting Environment Detector Responses.

        Description for List Hosting Environment Detector Responses.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param name: Site Name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DetectorResponseCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_09_01.models.DetectorResponseCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DetectorResponseCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_hosting_environment_detector_responses_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    template_url=self.list_hosting_environment_detector_responses.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_hosting_environment_detector_responses_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DetectorResponseCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_hosting_environment_detector_responses.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/detectors'}  # type: ignore

    @distributed_trace_async
    async def get_hosting_environment_detector_response(
        self,
        resource_group_name: str,
        name: str,
        detector_name: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.DetectorResponse":
        """Get Hosting Environment Detector Response.

        Description for Get Hosting Environment Detector Response.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param name: App Service Environment Name.
        :type name: str
        :param detector_name: Detector Resource Name.
        :type detector_name: str
        :param start_time: Start Time.
        :type start_time: ~datetime.datetime
        :param end_time: End Time.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DetectorResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_09_01.models.DetectorResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DetectorResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_hosting_environment_detector_response_request(
            resource_group_name=resource_group_name,
            name=name,
            detector_name=detector_name,
            subscription_id=self._config.subscription_id,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.get_hosting_environment_detector_response.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DetectorResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_hosting_environment_detector_response.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/detectors/{detectorName}'}  # type: ignore


    @distributed_trace
    def list_site_detector_responses(
        self,
        resource_group_name: str,
        site_name: str,
        **kwargs: Any
    ) -> AsyncIterable["_models.DetectorResponseCollection"]:
        """List Site Detector Responses.

        Description for List Site Detector Responses.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DetectorResponseCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_09_01.models.DetectorResponseCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DetectorResponseCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_detector_responses_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    subscription_id=self._config.subscription_id,
                    template_url=self.list_site_detector_responses.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_site_detector_responses_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DetectorResponseCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_detector_responses.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/detectors'}  # type: ignore

    @distributed_trace_async
    async def get_site_detector_response(
        self,
        resource_group_name: str,
        site_name: str,
        detector_name: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.DetectorResponse":
        """Get site detector response.

        Description for Get site detector response.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param detector_name: Detector Resource Name.
        :type detector_name: str
        :param start_time: Start Time.
        :type start_time: ~datetime.datetime
        :param end_time: End Time.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DetectorResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_09_01.models.DetectorResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DetectorResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_site_detector_response_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            detector_name=detector_name,
            subscription_id=self._config.subscription_id,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.get_site_detector_response.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DetectorResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_detector_response.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/detectors/{detectorName}'}  # type: ignore


    @distributed_trace
    def list_site_diagnostic_categories(
        self,
        resource_group_name: str,
        site_name: str,
        **kwargs: Any
    ) -> AsyncIterable["_models.DiagnosticCategoryCollection"]:
        """Get Diagnostics Categories.

        Description for Get Diagnostics Categories.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticCategoryCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_09_01.models.DiagnosticCategoryCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DiagnosticCategoryCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_diagnostic_categories_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    subscription_id=self._config.subscription_id,
                    template_url=self.list_site_diagnostic_categories.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_site_diagnostic_categories_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticCategoryCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_diagnostic_categories.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics'}  # type: ignore

    @distributed_trace_async
    async def get_site_diagnostic_category(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        **kwargs: Any
    ) -> "_models.DiagnosticCategory":
        """Get Diagnostics Category.

        Description for Get Diagnostics Category.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticCategory, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_09_01.models.DiagnosticCategory
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DiagnosticCategory"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_site_diagnostic_category_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            subscription_id=self._config.subscription_id,
            template_url=self.get_site_diagnostic_category.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticCategory', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_diagnostic_category.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}'}  # type: ignore


    @distributed_trace
    def list_site_analyses(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        **kwargs: Any
    ) -> AsyncIterable["_models.DiagnosticAnalysisCollection"]:
        """Get Site Analyses.

        Description for Get Site Analyses.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticAnalysisCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_09_01.models.DiagnosticAnalysisCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DiagnosticAnalysisCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_analyses_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    subscription_id=self._config.subscription_id,
                    template_url=self.list_site_analyses.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_site_analyses_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticAnalysisCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_analyses.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses'}  # type: ignore

    @distributed_trace_async
    async def get_site_analysis(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        analysis_name: str,
        **kwargs: Any
    ) -> "_models.AnalysisDefinition":
        """Get Site Analysis.

        Description for Get Site Analysis.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param analysis_name: Analysis Name.
        :type analysis_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AnalysisDefinition, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_09_01.models.AnalysisDefinition
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.AnalysisDefinition"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_site_analysis_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            analysis_name=analysis_name,
            subscription_id=self._config.subscription_id,
            template_url=self.get_site_analysis.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('AnalysisDefinition', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_analysis.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}'}  # type: ignore


    @distributed_trace_async
    async def execute_site_analysis(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        analysis_name: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.DiagnosticAnalysis":
        """Execute Analysis.

        Description for Execute Analysis.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Category Name.
        :type diagnostic_category: str
        :param analysis_name: Analysis Resource Name.
        :type analysis_name: str
        :param start_time: Start Time.
        :type start_time: ~datetime.datetime
        :param end_time: End Time.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticAnalysis, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_09_01.models.DiagnosticAnalysis
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DiagnosticAnalysis"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_execute_site_analysis_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            analysis_name=analysis_name,
            subscription_id=self._config.subscription_id,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.execute_site_analysis.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticAnalysis', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    execute_site_analysis.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute'}  # type: ignore


    @distributed_trace
    def list_site_detectors(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        **kwargs: Any
    ) -> AsyncIterable["_models.DiagnosticDetectorCollection"]:
        """Get Detectors.

        Description for Get Detectors.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticDetectorCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_09_01.models.DiagnosticDetectorCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DiagnosticDetectorCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_detectors_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    subscription_id=self._config.subscription_id,
                    template_url=self.list_site_detectors.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_site_detectors_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticDetectorCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_detectors.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors'}  # type: ignore

    @distributed_trace_async
    async def get_site_detector(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        detector_name: str,
        **kwargs: Any
    ) -> "_models.DetectorDefinition":
        """Get Detector.

        Description for Get Detector.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param detector_name: Detector Name.
        :type detector_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DetectorDefinition, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_09_01.models.DetectorDefinition
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DetectorDefinition"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_site_detector_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            detector_name=detector_name,
            subscription_id=self._config.subscription_id,
            template_url=self.get_site_detector.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DetectorDefinition', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_detector.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}'}  # type: ignore


    @distributed_trace_async
    async def execute_site_detector(
        self,
        resource_group_name: str,
        site_name: str,
        detector_name: str,
        diagnostic_category: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.DiagnosticDetectorResponse":
        """Execute Detector.

        Description for Execute Detector.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param detector_name: Detector Resource Name.
        :type detector_name: str
        :param diagnostic_category: Category Name.
        :type diagnostic_category: str
        :param start_time: Start Time.
        :type start_time: ~datetime.datetime
        :param end_time: End Time.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticDetectorResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_09_01.models.DiagnosticDetectorResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DiagnosticDetectorResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_execute_site_detector_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            detector_name=detector_name,
            diagnostic_category=diagnostic_category,
            subscription_id=self._config.subscription_id,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.execute_site_detector.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticDetectorResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    execute_site_detector.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute'}  # type: ignore


    @distributed_trace
    def list_site_detector_responses_slot(
        self,
        resource_group_name: str,
        site_name: str,
        slot: str,
        **kwargs: Any
    ) -> AsyncIterable["_models.DetectorResponseCollection"]:
        """List Site Detector Responses.

        Description for List Site Detector Responses.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param slot: Slot Name.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DetectorResponseCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_09_01.models.DetectorResponseCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DetectorResponseCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_detector_responses_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    template_url=self.list_site_detector_responses_slot.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_site_detector_responses_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DetectorResponseCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_detector_responses_slot.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/detectors'}  # type: ignore

    @distributed_trace_async
    async def get_site_detector_response_slot(
        self,
        resource_group_name: str,
        site_name: str,
        detector_name: str,
        slot: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.DetectorResponse":
        """Get site detector response.

        Description for Get site detector response.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param detector_name: Detector Resource Name.
        :type detector_name: str
        :param slot: Slot Name.
        :type slot: str
        :param start_time: Start Time.
        :type start_time: ~datetime.datetime
        :param end_time: End Time.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DetectorResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_09_01.models.DetectorResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DetectorResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_site_detector_response_slot_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            detector_name=detector_name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.get_site_detector_response_slot.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DetectorResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_detector_response_slot.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/detectors/{detectorName}'}  # type: ignore


    @distributed_trace
    def list_site_diagnostic_categories_slot(
        self,
        resource_group_name: str,
        site_name: str,
        slot: str,
        **kwargs: Any
    ) -> AsyncIterable["_models.DiagnosticCategoryCollection"]:
        """Get Diagnostics Categories.

        Description for Get Diagnostics Categories.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param slot: Slot Name.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticCategoryCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_09_01.models.DiagnosticCategoryCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DiagnosticCategoryCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_diagnostic_categories_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    template_url=self.list_site_diagnostic_categories_slot.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_site_diagnostic_categories_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticCategoryCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_diagnostic_categories_slot.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics'}  # type: ignore

    @distributed_trace_async
    async def get_site_diagnostic_category_slot(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        slot: str,
        **kwargs: Any
    ) -> "_models.DiagnosticCategory":
        """Get Diagnostics Category.

        Description for Get Diagnostics Category.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param slot: Slot Name.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticCategory, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_09_01.models.DiagnosticCategory
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DiagnosticCategory"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_site_diagnostic_category_slot_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            slot=slot,
            subscription_id=self._config.subscription_id,
            template_url=self.get_site_diagnostic_category_slot.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticCategory', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_diagnostic_category_slot.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}'}  # type: ignore


    @distributed_trace
    def list_site_analyses_slot(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        slot: str,
        **kwargs: Any
    ) -> AsyncIterable["_models.DiagnosticAnalysisCollection"]:
        """Get Site Analyses.

        Description for Get Site Analyses.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param slot: Slot Name.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticAnalysisCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_09_01.models.DiagnosticAnalysisCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DiagnosticAnalysisCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_analyses_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    template_url=self.list_site_analyses_slot.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_site_analyses_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticAnalysisCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_analyses_slot.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses'}  # type: ignore

    @distributed_trace_async
    async def get_site_analysis_slot(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        analysis_name: str,
        slot: str,
        **kwargs: Any
    ) -> "_models.AnalysisDefinition":
        """Get Site Analysis.

        Description for Get Site Analysis.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param analysis_name: Analysis Name.
        :type analysis_name: str
        :param slot: Slot - optional.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AnalysisDefinition, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_09_01.models.AnalysisDefinition
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.AnalysisDefinition"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_site_analysis_slot_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            analysis_name=analysis_name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            template_url=self.get_site_analysis_slot.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('AnalysisDefinition', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_analysis_slot.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}'}  # type: ignore


    @distributed_trace_async
    async def execute_site_analysis_slot(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        analysis_name: str,
        slot: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.DiagnosticAnalysis":
        """Execute Analysis.

        Description for Execute Analysis.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Category Name.
        :type diagnostic_category: str
        :param analysis_name: Analysis Resource Name.
        :type analysis_name: str
        :param slot: Slot Name.
        :type slot: str
        :param start_time: Start Time.
        :type start_time: ~datetime.datetime
        :param end_time: End Time.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticAnalysis, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_09_01.models.DiagnosticAnalysis
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DiagnosticAnalysis"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_execute_site_analysis_slot_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            analysis_name=analysis_name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.execute_site_analysis_slot.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticAnalysis', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    execute_site_analysis_slot.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute'}  # type: ignore


    @distributed_trace
    def list_site_detectors_slot(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        slot: str,
        **kwargs: Any
    ) -> AsyncIterable["_models.DiagnosticDetectorCollection"]:
        """Get Detectors.

        Description for Get Detectors.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param slot: Slot Name.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DiagnosticDetectorCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_09_01.models.DiagnosticDetectorCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DiagnosticDetectorCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_site_detectors_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    template_url=self.list_site_detectors_slot.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_site_detectors_slot_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    diagnostic_category=diagnostic_category,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DiagnosticDetectorCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_site_detectors_slot.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors'}  # type: ignore

    @distributed_trace_async
    async def get_site_detector_slot(
        self,
        resource_group_name: str,
        site_name: str,
        diagnostic_category: str,
        detector_name: str,
        slot: str,
        **kwargs: Any
    ) -> "_models.DetectorDefinition":
        """Get Detector.

        Description for Get Detector.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param diagnostic_category: Diagnostic Category.
        :type diagnostic_category: str
        :param detector_name: Detector Name.
        :type detector_name: str
        :param slot: Slot Name.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DetectorDefinition, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_09_01.models.DetectorDefinition
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DetectorDefinition"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_site_detector_slot_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            diagnostic_category=diagnostic_category,
            detector_name=detector_name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            template_url=self.get_site_detector_slot.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DetectorDefinition', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_detector_slot.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}'}  # type: ignore


    @distributed_trace_async
    async def execute_site_detector_slot(
        self,
        resource_group_name: str,
        site_name: str,
        detector_name: str,
        diagnostic_category: str,
        slot: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.DiagnosticDetectorResponse":
        """Execute Detector.

        Description for Execute Detector.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site Name.
        :type site_name: str
        :param detector_name: Detector Resource Name.
        :type detector_name: str
        :param diagnostic_category: Category Name.
        :type diagnostic_category: str
        :param slot: Slot Name.
        :type slot: str
        :param start_time: Start Time.
        :type start_time: ~datetime.datetime
        :param end_time: End Time.
        :type end_time: ~datetime.datetime
        :param time_grain: Time Grain.
        :type time_grain: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DiagnosticDetectorResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_09_01.models.DiagnosticDetectorResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DiagnosticDetectorResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_execute_site_detector_slot_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            detector_name=detector_name,
            diagnostic_category=diagnostic_category,
            slot=slot,
            subscription_id=self._config.subscription_id,
            start_time=start_time,
            end_time=end_time,
            time_grain=time_grain,
            template_url=self.execute_site_detector_slot.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DiagnosticDetectorResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    execute_site_detector_slot.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute'}  # type: ignore

