/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.cobertura.ant.AntUtil;
import net.sourceforge.cobertura.ant.CommonMatchingTask;
import net.sourceforge.cobertura.ant.ExcludeClasses;
import net.sourceforge.cobertura.ant.Ignore;
import net.sourceforge.cobertura.ant.IgnoreBranches;
import net.sourceforge.cobertura.ant.IncludeClasses;
import net.sourceforge.cobertura.util.CommandLineBuilder;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class InstrumentTask
extends CommonMatchingTask {
    private String dataFile = null;
    private File toDir = null;
    List ignoreRegexs = new ArrayList();
    List ignoreBranchesRegexs = new ArrayList();
    List includeClassesRegexs = new ArrayList();
    List excludeClassesRegexs = new ArrayList();
    private Integer forkedJVMDebugPort;
    private Path instrumentationClasspath = null;
    private HashMap fileSetMap = new HashMap();

    public InstrumentTask() {
        super("net.sourceforge.cobertura.instrument.Main");
    }

    public Ignore createIgnore() {
        Ignore ignoreRegex = new Ignore();
        this.ignoreRegexs.add(ignoreRegex);
        return ignoreRegex;
    }

    public IgnoreBranches createIgnoreBranches() {
        IgnoreBranches ignoreBranchesRegex = new IgnoreBranches();
        this.ignoreBranchesRegexs.add(ignoreBranchesRegex);
        return ignoreBranchesRegex;
    }

    public IncludeClasses createIncludeClasses() {
        IncludeClasses includeClassesRegex = new IncludeClasses();
        this.includeClassesRegexs.add(includeClassesRegex);
        return includeClassesRegex;
    }

    public ExcludeClasses createExcludeClasses() {
        ExcludeClasses excludeClassesRegex = new ExcludeClasses();
        this.excludeClassesRegexs.add(excludeClassesRegex);
        return excludeClassesRegex;
    }

    public Path createInstrumentationClasspath() {
        if (this.instrumentationClasspath == null) {
            this.instrumentationClasspath = new Path(this.getProject());
        }
        return this.instrumentationClasspath.createPath();
    }

    public void execute() throws BuildException {
        CommandLineBuilder builder = null;
        try {
            int i;
            builder = new CommandLineBuilder();
            if (this.dataFile != null) {
                builder.addArg("--datafile", this.dataFile);
            }
            if (this.toDir != null) {
                builder.addArg("--destination", this.toDir.getAbsolutePath());
            }
            for (i = 0; i < this.ignoreRegexs.size(); ++i) {
                Ignore ignoreRegex = (Ignore)this.ignoreRegexs.get(i);
                builder.addArg("--ignore", ignoreRegex.getRegex());
            }
            for (i = 0; i < this.ignoreBranchesRegexs.size(); ++i) {
                IgnoreBranches ignoreBranchesRegex = (IgnoreBranches)this.ignoreBranchesRegexs.get(i);
                builder.addArg("--ignoreBranches", ignoreBranchesRegex.getRegex());
            }
            for (i = 0; i < this.includeClassesRegexs.size(); ++i) {
                IncludeClasses includeClassesRegex = (IncludeClasses)this.includeClassesRegexs.get(i);
                builder.addArg("--includeClasses", includeClassesRegex.getRegex());
            }
            for (i = 0; i < this.excludeClassesRegexs.size(); ++i) {
                ExcludeClasses excludeClassesRegex = (ExcludeClasses)this.excludeClassesRegexs.get(i);
                builder.addArg("--excludeClasses", excludeClassesRegex.getRegex());
            }
            if (this.instrumentationClasspath != null) {
                this.processInstrumentationClasspath();
            }
            this.createArgumentsForFilesets(builder);
            builder.saveArgs();
        }
        catch (IOException ioe) {
            this.getProject().log("Error creating commands file.", 0);
            throw new BuildException("Unable to create the commands file.", (Throwable)ioe);
        }
        this.getJava().createArg().setValue("--commandsfile");
        this.getJava().createArg().setValue(builder.getCommandLineFile());
        if (this.forkedJVMDebugPort != null && this.forkedJVMDebugPort > 0) {
            this.getJava().createJvmarg().setValue("-Xdebug");
            this.getJava().createJvmarg().setValue("-Xrunjdwp:transport=dt_socket,address=" + this.forkedJVMDebugPort + ",server=y,suspend=y");
        }
        AntUtil.transferCoberturaDataFileProperty(this.getJava());
        if (this.getJava().executeJava() != 0) {
            throw new BuildException("Error instrumenting classes. See messages above.");
        }
        builder.dispose();
    }

    private void processInstrumentationClasspath() {
        if (this.includeClassesRegexs.size() == 0) {
            throw new BuildException("'includeClasses' is required when 'instrumentationClasspath' is used");
        }
        String[] sources = this.instrumentationClasspath.list();
        for (int i = 0; i < sources.length; ++i) {
            File fileOrDir = new File(sources[i]);
            if (!fileOrDir.exists()) continue;
            if (fileOrDir.isDirectory()) {
                this.createFilesetForDirectory(fileOrDir);
                continue;
            }
            this.addFileToFilesets(fileOrDir);
        }
    }

    private void addFileToFilesets(File file) {
        File dir = file.getParentFile();
        String filename = file.getName();
        FileSet fileSet = this.getFileSet(dir);
        fileSet.createInclude().setName(filename);
    }

    private FileSet getFileSet(File dir) {
        String key = dir.getAbsolutePath();
        FileSet fileSet = (FileSet)this.fileSetMap.get(key);
        if (fileSet == null) {
            fileSet = new FileSet();
            fileSet.setProject(this.getProject());
            fileSet.setDir(dir);
            this.fileSetMap.put(key, fileSet);
            this.addFileset(fileSet);
        }
        return fileSet;
    }

    private void createFilesetForDirectory(File dir) {
        FileSet fileSet = this.getFileSet(dir);
        fileSet.createInclude().setName("**/*.class");
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }

    public void setForkedJVMDebugPort(Integer forkedJVMDebugPort) {
        this.forkedJVMDebugPort = forkedJVMDebugPort;
    }
}

