/**********************************************************************
 * $list_cells example -- C source code using ACC PLI routines
 *
 * C source to scan through a module and list the names of all cells
 * in the module.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $list_cells(<module_instance>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_ListCells_checktf(),
 *              PLIbook_ListCells_calltf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     PLIbook_ListCells_checktf,     /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_ListCells_calltf,      /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$list_cells",                 /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_ListCells_checktf()
{
  acc_initialize();
  if (tf_nump() != 1)
    tf_error("$list_cells must have 1 argument.");
  else if (tf_typep(1) == TF_NULLPARAM)
    tf_error("$list_cells arg cannot be null.");
  else if (acc_fetch_type(acc_handle_tfarg(1)) != accModule)
    tf_error("$list_cells arg must be a module instance.");
  acc_close();
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_ListCells_calltf()
{
  handle mod_h, cell_h;
  int    cell_cnt = 0;

  acc_initialize();
  acc_configure(accDisplayWarnings, "true");

  mod_h = acc_handle_tfarg(1);
  io_printf("\nCells in Module %s, instance %s:\n",
            acc_fetch_defname(mod_h), acc_fetch_fullname(mod_h));
  cell_h = null; /* start with null (no cells found yet) */
  while (cell_h = acc_next_cell(mod_h,cell_h))
    io_printf("  %s (%s)\n",
              acc_fetch_fullname(cell_h), acc_fetch_defname(cell_h));
    cell_cnt++;
  io_printf("Total cells in this hierarchy tree = %d\n\n", cell_cnt);
  acc_close();
  return(0);
}
/*********************************************************************/

