/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.repository;

import fr.jayasoft.ivy.event.IvyEvent;
import fr.jayasoft.ivy.repository.Repository;
import fr.jayasoft.ivy.repository.Resource;
import java.io.File;

public class TransferEvent
extends IvyEvent {
    public static final int TRANSFER_INITIATED = 0;
    public static final int TRANSFER_STARTED = 1;
    public static final int TRANSFER_COMPLETED = 2;
    public static final int TRANSFER_PROGRESS = 3;
    public static final int TRANSFER_ERROR = 4;
    public static final int REQUEST_GET = 5;
    public static final int REQUEST_PUT = 6;
    private Resource _resource;
    private int _eventType;
    private int _requestType;
    private Exception _exception;
    private File _localFile;
    private Repository _repository;
    private byte[] _buffer;
    private long _length;
    private long _totalLength;
    private boolean _isTotalLengthSet = false;

    public TransferEvent(Repository repository, Resource resource, int eventType, int requestType) {
        this._repository = repository;
        this._resource = resource;
        this.setEventType(eventType);
        this.setRequestType(requestType);
    }

    public TransferEvent(Repository repository, Resource resource, Exception exception, int requestType) {
        this(repository, resource, 4, requestType);
        this._exception = exception;
    }

    public TransferEvent(Repository repository, Resource resource, byte[] buffer, long length, int requestType) {
        this(repository, resource, 3, requestType);
        this._buffer = buffer;
        this._length = length;
        this._totalLength = length;
    }

    public Resource getResource() {
        return this._resource;
    }

    public Exception getException() {
        return this._exception;
    }

    public int getRequestType() {
        return this._requestType;
    }

    protected void setRequestType(int requestType) {
        switch (requestType) {
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal request type: " + requestType);
            }
        }
        this._requestType = requestType;
    }

    public int getEventType() {
        return this._eventType;
    }

    protected void setEventType(int eventType) {
        switch (eventType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal event type: " + eventType);
            }
        }
        this._eventType = eventType;
    }

    protected void setResource(Resource resource) {
        this._resource = resource;
    }

    public File getLocalFile() {
        return this._localFile;
    }

    protected void setLocalFile(File localFile) {
        this._localFile = localFile;
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    protected void setBuffer(byte[] buffer) {
        this._buffer = buffer;
    }

    public long getLength() {
        return this._length;
    }

    protected void setLength(long length) {
        this._length = length;
    }

    public long getTotalLength() {
        return this._totalLength;
    }

    protected void setTotalLength(long totalLength) {
        this._totalLength = totalLength;
    }

    public void setException(Exception exception) {
        this._exception = exception;
    }

    public boolean isTotalLengthSet() {
        return this._isTotalLengthSet;
    }

    public void setTotalLengthSet(boolean isTotalLengthSet) {
        this._isTotalLengthSet = isTotalLengthSet;
    }
}

