/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.conflict;

import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.conflict.AbstractConflictManager;
import fr.jayasoft.ivy.conflict.StrictConflictException;
import fr.jayasoft.ivy.util.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class StrictConflictManager
extends AbstractConflictManager {
    public Collection resolveConflicts(IvyNode parent, Collection conflicts) {
        IvyNode lastNode = null;
        Iterator iter = conflicts.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (lastNode != null && !lastNode.equals(node)) {
                String msg = lastNode + " (needed by " + lastNode.getParent() + ") conflicts with " + node + " (needed by " + node.getParent() + ")";
                Message.error(msg);
                Message.sumupProblems();
                throw new StrictConflictException(msg);
            }
            lastNode = node;
        }
        return Collections.singleton(lastNode);
    }
}

