/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import fr.jayasoft.ivy.ArtifactId;
import fr.jayasoft.ivy.ModuleRevisionId;

public class ArtifactRevisionId {
    private ArtifactId _artifactId;
    private ModuleRevisionId _mrid;

    public static ArtifactRevisionId newInstance(ModuleRevisionId mrid, String name, String type, String ext) {
        return new ArtifactRevisionId(new ArtifactId(mrid.getModuleId(), name, type, ext), mrid);
    }

    public ArtifactRevisionId(ArtifactId artifactId, ModuleRevisionId mrid) {
        this._artifactId = artifactId;
        this._mrid = mrid;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ArtifactRevisionId)) {
            return false;
        }
        ArtifactRevisionId arid = (ArtifactRevisionId)obj;
        return this.getArtifactId().equals(arid.getArtifactId()) && this.getModuleRevisionId().equals(arid.getModuleRevisionId());
    }

    public int hashCode() {
        int hash = 17;
        hash += this.getArtifactId().hashCode() * 37;
        return hash += this.getModuleRevisionId().hashCode() * 37;
    }

    public String toString() {
        return "[ " + this.getModuleRevisionId().getOrganisation() + " | " + this.getModuleRevisionId().getName() + " | " + this.getModuleRevisionId().getRevision() + " :: " + this.getName() + " . " + this.getExt() + " ( " + this.getType() + " ) ]";
    }

    public ArtifactId getArtifactId() {
        return this._artifactId;
    }

    public ModuleRevisionId getModuleRevisionId() {
        return this._mrid;
    }

    public String getName() {
        return this._artifactId.getName();
    }

    public String getType() {
        return this._artifactId.getType();
    }

    public String getExt() {
        return this._artifactId.getExt();
    }

    public String getRevision() {
        return this._mrid.getRevision();
    }
}

