/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/rbac/v1"
	rbacv1 "k8s.io/client-go/applyconfigurations/rbac/v1"
	gentype "k8s.io/client-go/gentype"
	typedrbacv1 "k8s.io/client-go/kubernetes/typed/rbac/v1"
)

// fakeRoleBindings implements RoleBindingInterface
type fakeRoleBindings struct {
	*gentype.FakeClientWithListAndApply[*v1.RoleBinding, *v1.RoleBindingList, *rbacv1.RoleBindingApplyConfiguration]
	Fake *FakeRbacV1
}

func newFakeRoleBindings(fake *FakeRbacV1, namespace string) typedrbacv1.RoleBindingInterface {
	return &fakeRoleBindings{
		gentype.NewFakeClientWithListAndApply[*v1.RoleBinding, *v1.RoleBindingList, *rbacv1.RoleBindingApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("rolebindings"),
			v1.SchemeGroupVersion.WithKind("RoleBinding"),
			func() *v1.RoleBinding { return &v1.RoleBinding{} },
			func() *v1.RoleBindingList { return &v1.RoleBindingList{} },
			func(dst, src *v1.RoleBindingList) { dst.ListMeta = src.ListMeta },
			func(list *v1.RoleBindingList) []*v1.RoleBinding { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.RoleBindingList, items []*v1.RoleBinding) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
