/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.printers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.stylebook.AbstractComponent;
import org.apache.stylebook.CreationContext;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Printer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLPrinter
extends AbstractComponent
implements Printer {
    private void indent(PrintStream printStream, int n) {
        int n2 = 0;
        while (n2 < n) {
            printStream.print("  ");
            ++n2;
        }
    }

    private String leftTrim(String string) {
        if (string.length() == 0) {
            return string;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (!Character.isWhitespace(string.charAt(n2))) break;
            n = n2 + 1;
            ++n2;
        }
        if (n == string.length()) {
            return "";
        }
        return string.substring(n);
    }

    public void print(Document document, CreationContext creationContext, OutputStream outputStream) throws CreationException, IOException {
        this.printDocument(document, new PrintStream(outputStream), 0);
    }

    private void printAttribute(Attr attr, PrintStream printStream, int n) {
        printStream.print(String.valueOf(attr.getName()) + "=\"" + attr.getValue() + "\"");
    }

    private void printCDATASection(CDATASection cDATASection, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<[CDATA[" + cDATASection.getData() + "]]>");
    }

    private void printComment(Comment comment, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<!--" + comment.getData() + "-->");
    }

    private void printDocument(Document document, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<?xml version=\"1.0\"?>");
        this.printNodeList(document.getChildNodes(), printStream, n);
    }

    private void printDocumentFragment(DocumentFragment documentFragment, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<!-- Document Fragment Node -->");
    }

    private void printDocumentType(DocumentType documentType, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<!DOCTYPE " + documentType.getName() + ">");
    }

    private void printElement(Element element, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.print("<" + element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null && namedNodeMap.getLength() > 0) {
            int n2 = 0;
            while (n2 < namedNodeMap.getLength()) {
                printStream.print(' ');
                this.printAttribute((Attr)namedNodeMap.item(n2), printStream, n);
                ++n2;
            }
        }
        if (element.getChildNodes() != null && element.getChildNodes().getLength() > 0) {
            printStream.println(">");
            this.printNodeList(element.getChildNodes(), printStream, n + 1);
            this.indent(printStream, n);
            printStream.println("</" + element.getTagName() + ">");
        } else {
            printStream.println("/>");
        }
    }

    private void printEntity(Entity entity, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<!-- Entity Node -->");
    }

    private void printEntityReference(EntityReference entityReference, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<!-- Entity Reference Node -->");
    }

    private void printNodeList(NodeList nodeList, PrintStream printStream, int n) {
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Node node = nodeList.item(n2);
            switch (node.getNodeType()) {
                case 2: {
                    this.printAttribute((Attr)node, printStream, n);
                    break;
                }
                case 4: {
                    this.printCDATASection((CDATASection)node, printStream, n);
                    break;
                }
                case 8: {
                    this.printComment((Comment)node, printStream, n);
                    break;
                }
                case 11: {
                    this.printDocumentFragment((DocumentFragment)node, printStream, n);
                    break;
                }
                case 9: {
                    this.printDocument((Document)node, printStream, n);
                    break;
                }
                case 10: {
                    this.printDocumentType((DocumentType)node, printStream, n);
                    break;
                }
                case 1: {
                    this.printElement((Element)node, printStream, n);
                    break;
                }
                case 6: {
                    this.printEntity((Entity)node, printStream, n);
                    break;
                }
                case 5: {
                    this.printEntityReference((EntityReference)node, printStream, n);
                    break;
                }
                case 12: {
                    this.printNotation((Notation)node, printStream, n);
                    break;
                }
                case 7: {
                    this.printProcessingInstruction((ProcessingInstruction)node, printStream, n);
                    break;
                }
                case 3: {
                    this.printText((Text)node, printStream, n);
                    break;
                }
            }
            ++n2;
        }
    }

    private void printNotation(Notation notation, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<!-- Notation Node -->");
    }

    private void printProcessingInstruction(ProcessingInstruction processingInstruction, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<?" + processingInstruction.getTarget() + " " + processingInstruction.getData() + "?>");
    }

    private void printText(Text text, PrintStream printStream, int n) {
        Node node;
        String string = text.getData();
        if (string.length() == 0) {
            return;
        }
        if ((string = this.leftTrim(string)).length() == 0) {
            return;
        }
        Text text2 = text;
        while ((node = text2.getNextSibling()) != null && node.getNodeType() == 3) {
            Text text3 = (Text)node;
            String string2 = text3.getData();
            if (string2.length() > 0) {
                string = Character.isWhitespace(string2.charAt(0)) ? String.valueOf(this.trim(string)) + ' ' + this.leftTrim(string2) : String.valueOf(this.trim(string)) + this.leftTrim(string2);
            }
            text3.setData("");
            text2 = text3;
        }
        string = this.trim(string);
        text.setData(string);
        if (string.length() > 0) {
            this.indent(printStream, n);
            printStream.println(string);
        }
    }

    private String rightTrim(String string) {
        if (string.length() == 0) {
            return string;
        }
        int n = string.length();
        int n2 = n - 1;
        while (n2 >= 0) {
            if (!Character.isWhitespace(string.charAt(n2))) break;
            n = n2--;
        }
        return string.substring(0, n);
    }

    private String trim(String string) {
        return this.leftTrim(this.rightTrim(string));
    }
}

