# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
from aliyunsdkoceanbasepro.endpoint import endpoint_data

class DescribeAvailableZoneRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'OceanBasePro', '2019-09-01', 'DescribeAvailableZone','oceanbase')
		self.set_protocol_type('https')
		self.set_method('POST')

		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())

	def get_Spec(self): # String
		return self.get_body_params().get('Spec')

	def set_Spec(self, Spec):  # String
		self.add_body_params('Spec', Spec)
	def get_ObVersion(self): # String
		return self.get_body_params().get('ObVersion')

	def set_ObVersion(self, ObVersion):  # String
		self.add_body_params('ObVersion', ObVersion)
	def get_Series(self): # String
		return self.get_body_params().get('Series')

	def set_Series(self, Series):  # String
		self.add_body_params('Series', Series)
	def get_InstanceType(self): # String
		return self.get_body_params().get('InstanceType')

	def set_InstanceType(self, InstanceType):  # String
		self.add_body_params('InstanceType', InstanceType)
	def get_DeployType(self): # String
		return self.get_body_params().get('DeployType')

	def set_DeployType(self, DeployType):  # String
		self.add_body_params('DeployType', DeployType)
