# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EventsClientInfo(Model):
    """Client info for an event result.

    :param model: Model of the client
    :type model: str
    :param os: Operating system of the client
    :type os: str
    :param type: Type of the client
    :type type: str
    :param browser: Browser of the client
    :type browser: str
    :param ip: IP address of the client
    :type ip: str
    :param city: City of the client
    :type city: str
    :param state_or_province: State or province of the client
    :type state_or_province: str
    :param country_or_region: Country or region of the client
    :type country_or_region: str
    """

    _attribute_map = {
        'model': {'key': 'model', 'type': 'str'},
        'os': {'key': 'os', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'browser': {'key': 'browser', 'type': 'str'},
        'ip': {'key': 'ip', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'state_or_province': {'key': 'stateOrProvince', 'type': 'str'},
        'country_or_region': {'key': 'countryOrRegion', 'type': 'str'},
    }

    def __init__(self, *, model: str=None, os: str=None, type: str=None, browser: str=None, ip: str=None, city: str=None, state_or_province: str=None, country_or_region: str=None, **kwargs) -> None:
        super(EventsClientInfo, self).__init__(**kwargs)
        self.model = model
        self.os = os
        self.type = type
        self.browser = browser
        self.ip = ip
        self.city = city
        self.state_or_province = state_or_province
        self.country_or_region = country_or_region
