#ifndef _SCR_H
#define _SCR_H

/* mode argument for getscr () */
#define SCR_TEXT 0              /* get screen text */
#define SCR_ATTRIB 1            /* get screen attributes */

/* disp argument for selectdisp () */
#define LIVE_SCRN 0             /* read the physical screen */
#define FROZ_SCRN 1             /* read frozen screen image */
#define HELP_SCRN 2             /* read help screen */

typedef struct
{
  short rows, cols;             /* screen dimentions */
  short posx, posy;             /* cursor position */
  short no;                     /* screen number */
}
scrstat;

typedef struct
{
  unsigned short left, top;     /* coordinates of corner, counting from 0 */
  unsigned short width, height; /* dimensions */
}
winpos;

/* Functions provided by this library */
int initscr (void);             /* initialise screen reading functions */
void getstat (scrstat *);       /* get screen status */
unsigned char *getscr (winpos, unsigned char *, short);
void closescr (void);           /* close screen reading */

/*int selectdisp (int);           select display page */

/* An extra `thread' for the cursor routing subprocess.
 * This is needed because the forked subprocess shares the parent's
 * filedescriptors.  A getscr equivalent is not needed, and so not provided.
 */
int initscr_phys (void);
void getstat_phys (scrstat *);
void closescr_phys (void);

#endif /* !_SCR_H */
