// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1200 -show-encoding %s | FileCheck --check-prefix=GFX12 %s

ds_nop
// GFX12: [0x00,0x00,0x50,0xd8,0x00,0x00,0x00,0x00]

ds_add_f32 v1, v2
// GFX12: [0x00,0x00,0x54,0xd8,0x01,0x02,0x00,0x00]

ds_add_f32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x54,0xd8,0x01,0x02,0x00,0x00]

ds_add_f32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x54,0xd8,0x01,0x02,0x00,0x00]

ds_add_f32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x54,0xd8,0xff,0xff,0x00,0x00]

ds_add_rtn_f32 v5, v1, v2
// GFX12: [0x00,0x00,0xe4,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_f32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0xe4,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_f32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0xe4,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_f32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xe4,0xd9,0xff,0xff,0x00,0xff]

ds_add_rtn_u32 v5, v1, v2
// GFX12: [0x00,0x00,0x80,0xd8,0x01,0x02,0x00,0x05]

ds_add_rtn_u32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0x80,0xd8,0x01,0x02,0x00,0x05]

ds_add_rtn_u32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0x80,0xd8,0x01,0x02,0x00,0x05]

ds_add_rtn_u32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0x80,0xd8,0xff,0xff,0x00,0xff]

ds_add_rtn_u64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x80,0xd9,0xff,0xfe,0x00,0xfe]

ds_add_u32 v1, v2
// GFX12: [0x00,0x00,0x00,0xd8,0x01,0x02,0x00,0x00]

ds_add_u32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x00,0xd8,0x01,0x02,0x00,0x00]

ds_add_u32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x00,0xd8,0x01,0x02,0x00,0x00]

ds_add_u32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x00,0xd8,0xff,0xff,0x00,0x00]

ds_add_u64 v1, v[2:3]
// GFX12: [0x00,0x00,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x00,0xd9,0xff,0xfe,0x00,0x00]

ds_and_b32 v1, v2
// GFX12: [0x00,0x00,0x24,0xd8,0x01,0x02,0x00,0x00]

ds_and_b32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x24,0xd8,0x01,0x02,0x00,0x00]

ds_and_b32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x24,0xd8,0x01,0x02,0x00,0x00]

ds_and_b32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x24,0xd8,0xff,0xff,0x00,0x00]

ds_and_b64 v1, v[2:3]
// GFX12: [0x00,0x00,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x24,0xd9,0xff,0xfe,0x00,0x00]

ds_and_rtn_b32 v5, v1, v2
// GFX12: [0x00,0x00,0xa4,0xd8,0x01,0x02,0x00,0x05]

ds_and_rtn_b32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0xa4,0xd8,0x01,0x02,0x00,0x05]

ds_and_rtn_b32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0xa4,0xd8,0x01,0x02,0x00,0x05]

ds_and_rtn_b32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xa4,0xd8,0xff,0xff,0x00,0xff]

ds_and_rtn_b64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0xa4,0xd9,0xff,0xfe,0x00,0xfe]

ds_append v5
// GFX12: [0x00,0x00,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:65535
// GFX12: [0xff,0xff,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:0
// GFX12: [0x00,0x00,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v255 offset:4
// GFX12: [0x04,0x00,0xf8,0xd8,0x00,0x00,0x00,0xff]

ds_bpermute_b32 v5, v1, v2
// GFX12: [0x00,0x00,0xcc,0xda,0x01,0x02,0x00,0x05]

ds_bpermute_b32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0xcc,0xda,0x01,0x02,0x00,0x05]

ds_bpermute_b32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0xcc,0xda,0x01,0x02,0x00,0x05]

ds_bpermute_b32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xcc,0xda,0xff,0xff,0x00,0xff]

ds_cmpstore_b32 v1, v2, v3
// GFX12: [0x00,0x00,0x40,0xd8,0x01,0x02,0x03,0x00]

ds_cmpstore_b32 v1, v2, v3 offset:65535
// GFX12: [0xff,0xff,0x40,0xd8,0x01,0x02,0x03,0x00]

ds_cmpstore_b32 v1, v2, v3 offset:0
// GFX12: [0x00,0x00,0x40,0xd8,0x01,0x02,0x03,0x00]

ds_cmpstore_b32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0x40,0xd8,0xff,0xff,0xff,0x00]

ds_cmpstore_b64 v1, v[2:3], v[3:4]
// GFX12: [0x00,0x00,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpstore_b64 v1, v[2:3], v[3:4] offset:65535
// GFX12: [0xff,0xff,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpstore_b64 v1, v[2:3], v[3:4] offset:0
// GFX12: [0x00,0x00,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpstore_b64 v255, v[254:255], v[254:255] offset:4
// GFX12: [0x04,0x00,0x40,0xd9,0xff,0xfe,0xfe,0x00]

ds_cmpstore_rtn_b32 v5, v1, v2, v3
// GFX12: [0x00,0x00,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpstore_rtn_b32 v5, v1, v2, v3 offset:65535
// GFX12: [0xff,0xff,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpstore_rtn_b32 v5, v1, v2, v3 offset:0
// GFX12: [0x00,0x00,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpstore_rtn_b32 v255, v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xc0,0xd8,0xff,0xff,0xff,0xff]

ds_cmpstore_rtn_b64 v[5:6], v1, v[2:3], v[3:4]
// GFX12: [0x00,0x00,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpstore_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535
// GFX12: [0xff,0xff,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpstore_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:0
// GFX12: [0x00,0x00,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpstore_rtn_b64 v[254:255], v255, v[254:255], v[254:255] offset:4
// GFX12: [0x04,0x00,0xc0,0xd9,0xff,0xfe,0xfe,0xfe]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0xf8,0xd9,0xff,0xfe,0x00,0xfe]

ds_consume v5
// GFX12: [0x00,0x00,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v5 offset:65535
// GFX12: [0xff,0xff,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v5 offset:0
// GFX12: [0x00,0x00,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v255 offset:4
// GFX12: [0x04,0x00,0xf4,0xd8,0x00,0x00,0x00,0xff]

ds_dec_rtn_u32 v5, v1, v2
// GFX12: [0x00,0x00,0x90,0xd8,0x01,0x02,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0x90,0xd8,0x01,0x02,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0x90,0xd8,0x01,0x02,0x00,0x05]

ds_dec_rtn_u32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0x90,0xd8,0xff,0xff,0x00,0xff]

ds_dec_rtn_u64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x90,0xd9,0xff,0xfe,0x00,0xfe]

ds_dec_u32 v1, v2
// GFX12: [0x00,0x00,0x10,0xd8,0x01,0x02,0x00,0x00]

ds_dec_u32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x10,0xd8,0x01,0x02,0x00,0x00]

ds_dec_u32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x10,0xd8,0x01,0x02,0x00,0x00]

ds_dec_u32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x10,0xd8,0xff,0xff,0x00,0x00]

ds_dec_u64 v1, v[2:3]
// GFX12: [0x00,0x00,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x10,0xd9,0xff,0xfe,0x00,0x00]

ds_inc_rtn_u32 v5, v1, v2
// GFX12: [0x00,0x00,0x8c,0xd8,0x01,0x02,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0x8c,0xd8,0x01,0x02,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0x8c,0xd8,0x01,0x02,0x00,0x05]

ds_inc_rtn_u32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0x8c,0xd8,0xff,0xff,0x00,0xff]

ds_inc_rtn_u64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x8c,0xd9,0xff,0xfe,0x00,0xfe]

ds_inc_u32 v1, v2
// GFX12: [0x00,0x00,0x0c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_u32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x0c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_u32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x0c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_u32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x0c,0xd8,0xff,0xff,0x00,0x00]

ds_inc_u64 v1, v[2:3]
// GFX12: [0x00,0x00,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x0c,0xd9,0xff,0xfe,0x00,0x00]

ds_load_2addr_b32 v[5:6], v1
// GFX12: [0x00,0x00,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_load_2addr_b32 v[5:6], v1 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_load_2addr_b32 v[5:6], v1 offset0:0 offset1:0
// GFX12: [0x00,0x00,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_load_2addr_b32 v[254:255], v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0xdc,0xd8,0xff,0x00,0x00,0xfe]

ds_load_2addr_b64 v[5:8], v1
// GFX12: [0x00,0x00,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_load_2addr_b64 v[5:8], v1 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_load_2addr_b64 v[5:8], v1 offset0:0 offset1:0
// GFX12: [0x00,0x00,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_load_2addr_b64 v[252:255], v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0xdc,0xd9,0xff,0x00,0x00,0xfc]

ds_load_2addr_stride64_b32 v[5:6], v1
// GFX12: [0x00,0x00,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_load_2addr_stride64_b32 v[5:6], v1 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_load_2addr_stride64_b32 v[5:6], v1 offset0:0 offset1:0
// GFX12: [0x00,0x00,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_load_2addr_stride64_b32 v[254:255], v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0xe0,0xd8,0xff,0x00,0x00,0xfe]

ds_load_2addr_stride64_b64 v[5:8], v1
// GFX12: [0x00,0x00,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_load_2addr_stride64_b64 v[5:8], v1 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_load_2addr_stride64_b64 v[5:8], v1 offset0:0 offset1:0
// GFX12: [0x00,0x00,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_load_2addr_stride64_b64 v[252:255], v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0xe0,0xd9,0xff,0x00,0x00,0xfc]

ds_load_addtid_b32 v5
// GFX12: [0x00,0x00,0xc4,0xda,0x00,0x00,0x00,0x05]

ds_load_addtid_b32 v5 offset:65535
// GFX12: [0xff,0xff,0xc4,0xda,0x00,0x00,0x00,0x05]

ds_load_addtid_b32 v5 offset:0
// GFX12: [0x00,0x00,0xc4,0xda,0x00,0x00,0x00,0x05]

ds_load_addtid_b32 v255 offset:4
// GFX12: [0x04,0x00,0xc4,0xda,0x00,0x00,0x00,0xff]

ds_load_b128 v[5:8], v1
// GFX12: [0x00,0x00,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_load_b128 v[5:8], v1 offset:65535
// GFX12: [0xff,0xff,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_load_b128 v[5:8], v1 offset:0
// GFX12: [0x00,0x00,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_load_b128 v[252:255], v255 offset:4
// GFX12: [0x04,0x00,0xfc,0xdb,0xff,0x00,0x00,0xfc]

ds_load_b32 v5, v1
// GFX12: [0x00,0x00,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_load_b32 v5, v1 offset:65535
// GFX12: [0xff,0xff,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_load_b32 v5, v1 offset:0
// GFX12: [0x00,0x00,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_load_b32 v255, v255 offset:4
// GFX12: [0x04,0x00,0xd8,0xd8,0xff,0x00,0x00,0xff]

ds_load_b64 v[5:6], v1
// GFX12: [0x00,0x00,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_load_b64 v[5:6], v1 offset:65535
// GFX12: [0xff,0xff,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_load_b64 v[5:6], v1 offset:0
// GFX12: [0x00,0x00,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_load_b64 v[254:255], v255 offset:4
// GFX12: [0x04,0x00,0xd8,0xd9,0xff,0x00,0x00,0xfe]

ds_load_b96 v[5:7], v1
// GFX12: [0x00,0x00,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_load_b96 v[5:7], v1 offset:65535
// GFX12: [0xff,0xff,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_load_b96 v[5:7], v1 offset:0
// GFX12: [0x00,0x00,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_load_b96 v[253:255], v255 offset:4
// GFX12: [0x04,0x00,0xf8,0xdb,0xff,0x00,0x00,0xfd]

ds_load_i16 v5, v1
// GFX12: [0x00,0x00,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_load_i16 v5, v1 offset:65535
// GFX12: [0xff,0xff,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_load_i16 v5, v1 offset:0
// GFX12: [0x00,0x00,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_load_i16 v255, v255 offset:4
// GFX12: [0x04,0x00,0xec,0xd8,0xff,0x00,0x00,0xff]

ds_load_i8 v5, v1
// GFX12: [0x00,0x00,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_load_i8 v5, v1 offset:65535
// GFX12: [0xff,0xff,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_load_i8 v5, v1 offset:0
// GFX12: [0x00,0x00,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_load_i8 v255, v255 offset:4
// GFX12: [0x04,0x00,0xe4,0xd8,0xff,0x00,0x00,0xff]

ds_load_i8_d16 v5, v1
// GFX12: [0x00,0x00,0x90,0xda,0x01,0x00,0x00,0x05]

ds_load_i8_d16 v5, v1 offset:65535
// GFX12: [0xff,0xff,0x90,0xda,0x01,0x00,0x00,0x05]

ds_load_i8_d16 v5, v1 offset:0
// GFX12: [0x00,0x00,0x90,0xda,0x01,0x00,0x00,0x05]

ds_load_i8_d16 v255, v255 offset:4
// GFX12: [0x04,0x00,0x90,0xda,0xff,0x00,0x00,0xff]

ds_load_i8_d16_hi v5, v1
// GFX12: [0x00,0x00,0x94,0xda,0x01,0x00,0x00,0x05]

ds_load_i8_d16_hi v5, v1 offset:65535
// GFX12: [0xff,0xff,0x94,0xda,0x01,0x00,0x00,0x05]

ds_load_i8_d16_hi v5, v1 offset:0
// GFX12: [0x00,0x00,0x94,0xda,0x01,0x00,0x00,0x05]

ds_load_i8_d16_hi v255, v255 offset:4
// GFX12: [0x04,0x00,0x94,0xda,0xff,0x00,0x00,0xff]

ds_load_u16 v5, v1
// GFX12: [0x00,0x00,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_load_u16 v5, v1 offset:65535
// GFX12: [0xff,0xff,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_load_u16 v5, v1 offset:0
// GFX12: [0x00,0x00,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_load_u16 v255, v255 offset:4
// GFX12: [0x04,0x00,0xf0,0xd8,0xff,0x00,0x00,0xff]

ds_load_u16_d16 v5, v1
// GFX12: [0x00,0x00,0x98,0xda,0x01,0x00,0x00,0x05]

ds_load_u16_d16 v5, v1 offset:65535
// GFX12: [0xff,0xff,0x98,0xda,0x01,0x00,0x00,0x05]

ds_load_u16_d16 v5, v1 offset:0
// GFX12: [0x00,0x00,0x98,0xda,0x01,0x00,0x00,0x05]

ds_load_u16_d16 v255, v255 offset:4
// GFX12: [0x04,0x00,0x98,0xda,0xff,0x00,0x00,0xff]

ds_load_u16_d16_hi v5, v1
// GFX12: [0x00,0x00,0x9c,0xda,0x01,0x00,0x00,0x05]

ds_load_u16_d16_hi v5, v1 offset:65535
// GFX12: [0xff,0xff,0x9c,0xda,0x01,0x00,0x00,0x05]

ds_load_u16_d16_hi v5, v1 offset:0
// GFX12: [0x00,0x00,0x9c,0xda,0x01,0x00,0x00,0x05]

ds_load_u16_d16_hi v255, v255 offset:4
// GFX12: [0x04,0x00,0x9c,0xda,0xff,0x00,0x00,0xff]

ds_load_u8 v5, v1
// GFX12: [0x00,0x00,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_load_u8 v5, v1 offset:65535
// GFX12: [0xff,0xff,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_load_u8 v5, v1 offset:0
// GFX12: [0x00,0x00,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_load_u8 v255, v255 offset:4
// GFX12: [0x04,0x00,0xe8,0xd8,0xff,0x00,0x00,0xff]

ds_load_u8_d16 v5, v1
// GFX12: [0x00,0x00,0x88,0xda,0x01,0x00,0x00,0x05]

ds_load_u8_d16 v5, v1 offset:65535
// GFX12: [0xff,0xff,0x88,0xda,0x01,0x00,0x00,0x05]

ds_load_u8_d16 v5, v1 offset:0
// GFX12: [0x00,0x00,0x88,0xda,0x01,0x00,0x00,0x05]

ds_load_u8_d16 v255, v255 offset:4
// GFX12: [0x04,0x00,0x88,0xda,0xff,0x00,0x00,0xff]

ds_load_u8_d16_hi v5, v1
// GFX12: [0x00,0x00,0x8c,0xda,0x01,0x00,0x00,0x05]

ds_load_u8_d16_hi v5, v1 offset:65535
// GFX12: [0xff,0xff,0x8c,0xda,0x01,0x00,0x00,0x05]

ds_load_u8_d16_hi v5, v1 offset:0
// GFX12: [0x00,0x00,0x8c,0xda,0x01,0x00,0x00,0x05]

ds_load_u8_d16_hi v255, v255 offset:4
// GFX12: [0x04,0x00,0x8c,0xda,0xff,0x00,0x00,0xff]

ds_max_num_f32 v1, v2
// GFX12: [0x00,0x00,0x4c,0xd8,0x01,0x02,0x00,0x00]

ds_max_num_f32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x4c,0xd8,0x01,0x02,0x00,0x00]

ds_max_num_f32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x4c,0xd8,0x01,0x02,0x00,0x00]

ds_max_num_f32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x4c,0xd8,0xff,0xff,0x00,0x00]

ds_max_num_f64 v1, v[2:3]
// GFX12: [0x00,0x00,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_num_f64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_num_f64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_num_f64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x4c,0xd9,0xff,0xfe,0x00,0x00]

ds_max_i32 v1, v2
// GFX12: [0x00,0x00,0x18,0xd8,0x01,0x02,0x00,0x00]

ds_max_i32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x18,0xd8,0x01,0x02,0x00,0x00]

ds_max_i32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x18,0xd8,0x01,0x02,0x00,0x00]

ds_max_i32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x18,0xd8,0xff,0xff,0x00,0x00]

ds_max_i64 v1, v[2:3]
// GFX12: [0x00,0x00,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x18,0xd9,0xff,0xfe,0x00,0x00]

ds_max_num_rtn_f32 v5, v1, v2
// GFX12: [0x00,0x00,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_num_rtn_f32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_num_rtn_f32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_num_rtn_f32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xcc,0xd8,0xff,0xff,0x00,0xff]

ds_max_num_rtn_f64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_num_rtn_f64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_num_rtn_f64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_num_rtn_f64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0xcc,0xd9,0xff,0xfe,0x00,0xfe]

ds_max_rtn_i32 v5, v1, v2
// GFX12: [0x00,0x00,0x98,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_i32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0x98,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_i32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0x98,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_i32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0x98,0xd8,0xff,0xff,0x00,0xff]

ds_max_rtn_i64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x98,0xd9,0xff,0xfe,0x00,0xfe]

ds_max_rtn_u32 v5, v1, v2
// GFX12: [0x00,0x00,0xa0,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_u32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0xa0,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_u32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0xa0,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_u32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xa0,0xd8,0xff,0xff,0x00,0xff]

ds_max_rtn_u64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0xa0,0xd9,0xff,0xfe,0x00,0xfe]

ds_max_u32 v1, v2
// GFX12: [0x00,0x00,0x20,0xd8,0x01,0x02,0x00,0x00]

ds_max_u32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x20,0xd8,0x01,0x02,0x00,0x00]

ds_max_u32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x20,0xd8,0x01,0x02,0x00,0x00]

ds_max_u32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x20,0xd8,0xff,0xff,0x00,0x00]

ds_max_u64 v1, v[2:3]
// GFX12: [0x00,0x00,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x20,0xd9,0xff,0xfe,0x00,0x00]

ds_min_num_f32 v1, v2
// GFX12: [0x00,0x00,0x48,0xd8,0x01,0x02,0x00,0x00]

ds_min_num_f32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x48,0xd8,0x01,0x02,0x00,0x00]

ds_min_num_f32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x48,0xd8,0x01,0x02,0x00,0x00]

ds_min_num_f32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x48,0xd8,0xff,0xff,0x00,0x00]

ds_min_num_f64 v1, v[2:3]
// GFX12: [0x00,0x00,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_num_f64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_num_f64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_num_f64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x48,0xd9,0xff,0xfe,0x00,0x00]

ds_min_i32 v1, v2
// GFX12: [0x00,0x00,0x14,0xd8,0x01,0x02,0x00,0x00]

ds_min_i32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x14,0xd8,0x01,0x02,0x00,0x00]

ds_min_i32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x14,0xd8,0x01,0x02,0x00,0x00]

ds_min_i32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x14,0xd8,0xff,0xff,0x00,0x00]

ds_min_i64 v1, v[2:3]
// GFX12: [0x00,0x00,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x14,0xd9,0xff,0xfe,0x00,0x00]

ds_min_num_rtn_f32 v5, v1, v2
// GFX12: [0x00,0x00,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_num_rtn_f32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_num_rtn_f32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_num_rtn_f32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xc8,0xd8,0xff,0xff,0x00,0xff]

ds_min_num_rtn_f64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_num_rtn_f64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_num_rtn_f64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_num_rtn_f64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0xc8,0xd9,0xff,0xfe,0x00,0xfe]

ds_min_rtn_i32 v5, v1, v2
// GFX12: [0x00,0x00,0x94,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_i32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0x94,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_i32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0x94,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_i32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0x94,0xd8,0xff,0xff,0x00,0xff]

ds_min_rtn_i64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x94,0xd9,0xff,0xfe,0x00,0xfe]

ds_min_rtn_u32 v5, v1, v2
// GFX12: [0x00,0x00,0x9c,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_u32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0x9c,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_u32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0x9c,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_u32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0x9c,0xd8,0xff,0xff,0x00,0xff]

ds_min_rtn_u64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x9c,0xd9,0xff,0xfe,0x00,0xfe]

ds_min_u32 v1, v2
// GFX12: [0x00,0x00,0x1c,0xd8,0x01,0x02,0x00,0x00]

ds_min_u32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x1c,0xd8,0x01,0x02,0x00,0x00]

ds_min_u32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x1c,0xd8,0x01,0x02,0x00,0x00]

ds_min_u32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x1c,0xd8,0xff,0xff,0x00,0x00]

ds_min_u64 v1, v[2:3]
// GFX12: [0x00,0x00,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x1c,0xd9,0xff,0xfe,0x00,0x00]

ds_mskor_b32 v1, v2, v3
// GFX12: [0x00,0x00,0x30,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_b32 v1, v2, v3 offset:65535
// GFX12: [0xff,0xff,0x30,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_b32 v1, v2, v3 offset:0
// GFX12: [0x00,0x00,0x30,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_b32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0x30,0xd8,0xff,0xff,0xff,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4]
// GFX12: [0x00,0x00,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:65535
// GFX12: [0xff,0xff,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:0
// GFX12: [0x00,0x00,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v255, v[254:255], v[254:255] offset:4
// GFX12: [0x04,0x00,0x30,0xd9,0xff,0xfe,0xfe,0x00]

ds_mskor_rtn_b32 v5, v1, v2, v3
// GFX12: [0x00,0x00,0xb0,0xd8,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v3 offset:65535
// GFX12: [0xff,0xff,0xb0,0xd8,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v3 offset:0
// GFX12: [0x00,0x00,0xb0,0xd8,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b32 v255, v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xb0,0xd8,0xff,0xff,0xff,0xff]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4]
// GFX12: [0x00,0x00,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535
// GFX12: [0xff,0xff,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:0
// GFX12: [0x00,0x00,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[254:255], v255, v[254:255], v[254:255] offset:4
// GFX12: [0x04,0x00,0xb0,0xd9,0xff,0xfe,0xfe,0xfe]

ds_or_b32 v1, v2
// GFX12: [0x00,0x00,0x28,0xd8,0x01,0x02,0x00,0x00]

ds_or_b32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x28,0xd8,0x01,0x02,0x00,0x00]

ds_or_b32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x28,0xd8,0x01,0x02,0x00,0x00]

ds_or_b32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x28,0xd8,0xff,0xff,0x00,0x00]

ds_or_b64 v1, v[2:3]
// GFX12: [0x00,0x00,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x28,0xd9,0xff,0xfe,0x00,0x00]

ds_or_rtn_b32 v5, v1, v2
// GFX12: [0x00,0x00,0xa8,0xd8,0x01,0x02,0x00,0x05]

ds_or_rtn_b32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0xa8,0xd8,0x01,0x02,0x00,0x05]

ds_or_rtn_b32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0xa8,0xd8,0x01,0x02,0x00,0x05]

ds_or_rtn_b32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xa8,0xd8,0xff,0xff,0x00,0xff]

ds_or_rtn_b64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0xa8,0xd9,0xff,0xfe,0x00,0xfe]

ds_permute_b32 v5, v1, v2
// GFX12: [0x00,0x00,0xc8,0xda,0x01,0x02,0x00,0x05]

ds_permute_b32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0xc8,0xda,0x01,0x02,0x00,0x05]

ds_permute_b32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0xc8,0xda,0x01,0x02,0x00,0x05]

ds_permute_b32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xc8,0xda,0xff,0xff,0x00,0xff]

ds_pk_add_f16 v2, v1
// GFX12: [0x00,0x00,0x68,0xda,0x02,0x01,0x00,0x00]

ds_pk_add_f16 v2, v1 offset:0
// GFX12: [0x00,0x00,0x68,0xda,0x02,0x01,0x00,0x00]

ds_pk_add_f16 v2, v1 offset:4660
// GFX12: [0x34,0x12,0x68,0xda,0x02,0x01,0x00,0x00]

ds_pk_add_f16 v2, v1 offset:65535
// GFX12: [0xff,0xff,0x68,0xda,0x02,0x01,0x00,0x00]

ds_pk_add_f16 v255, v255
// GFX12: [0x00,0x00,0x68,0xda,0xff,0xff,0x00,0x00]

ds_pk_add_f16 v255, v255 offset:0
// GFX12: [0x00,0x00,0x68,0xda,0xff,0xff,0x00,0x00]

ds_pk_add_f16 v255, v255 offset:4660
// GFX12: [0x34,0x12,0x68,0xda,0xff,0xff,0x00,0x00]

ds_pk_add_f16 v255, v255 offset:65535
// GFX12: [0xff,0xff,0x68,0xda,0xff,0xff,0x00,0x00]

ds_pk_add_f16 v0, v0
// GFX12: [0x00,0x00,0x68,0xda,0x00,0x00,0x00,0x00]

ds_pk_add_bf16 v2, v1
// GFX12: [0x00,0x00,0x6c,0xda,0x02,0x01,0x00,0x00]

ds_pk_add_bf16 v2, v1 offset:0
// GFX12: [0x00,0x00,0x6c,0xda,0x02,0x01,0x00,0x00]

ds_pk_add_bf16 v255, v255
// GFX12: [0x00,0x00,0x6c,0xda,0xff,0xff,0x00,0x00]

ds_pk_add_bf16 v255, v255 offset:4660
// GFX12: [0x34,0x12,0x6c,0xda,0xff,0xff,0x00,0x00]

ds_pk_add_bf16 v0, v0
// GFX12: [0x00,0x00,0x6c,0xda,0x00,0x00,0x00,0x00]

ds_pk_add_bf16 v0, v0 offset:65535
// GFX12: [0xff,0xff,0x6c,0xda,0x00,0x00,0x00,0x00]

ds_pk_add_rtn_f16 v3, v2, v1
// GFX12: [0x00,0x00,0xa8,0xda,0x02,0x01,0x00,0x03]

ds_pk_add_rtn_f16 v3, v2, v1 offset:4660
// GFX12: [0x34,0x12,0xa8,0xda,0x02,0x01,0x00,0x03]

ds_pk_add_rtn_f16 v255, v0, v200
// GFX12: [0x00,0x00,0xa8,0xda,0x00,0xc8,0x00,0xff]

ds_pk_add_rtn_f16 v255, v0, v200 offset:65535
// GFX12: [0xff,0xff,0xa8,0xda,0x00,0xc8,0x00,0xff]

ds_pk_add_rtn_f16 v255, v255, v255
// GFX12: [0x00,0x00,0xa8,0xda,0xff,0xff,0x00,0xff]

ds_pk_add_rtn_bf16 v3, v2, v1
// GFX12: [0x00,0x00,0xac,0xda,0x02,0x01,0x00,0x03]

ds_pk_add_rtn_bf16 v3, v2, v1 offset:4660
// GFX12: [0x34,0x12,0xac,0xda,0x02,0x01,0x00,0x03]

ds_pk_add_rtn_bf16 v255, v0, v200
// GFX12: [0x00,0x00,0xac,0xda,0x00,0xc8,0x00,0xff]

ds_pk_add_rtn_bf16 v255, v255, v255
// GFX12: [0x00,0x00,0xac,0xda,0xff,0xff,0x00,0xff]

ds_pk_add_rtn_bf16 v255, v255, v255 offset:65535
// GFX12: [0xff,0xff,0xac,0xda,0xff,0xff,0x00,0xff]

ds_read2_b32 v[5:6], v1
// GFX12: [0x00,0x00,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:0 offset1:0
// GFX12: [0x00,0x00,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[254:255], v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0xdc,0xd8,0xff,0x00,0x00,0xfe]

ds_read2_b64 v[5:8], v1
// GFX12: [0x00,0x00,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:0 offset1:0
// GFX12: [0x00,0x00,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[252:255], v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0xdc,0xd9,0xff,0x00,0x00,0xfc]

ds_read2st64_b32 v[5:6], v1
// GFX12: [0x00,0x00,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:0 offset1:0
// GFX12: [0x00,0x00,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[254:255], v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0xe0,0xd8,0xff,0x00,0x00,0xfe]

ds_read2st64_b64 v[5:8], v1
// GFX12: [0x00,0x00,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:0 offset1:0
// GFX12: [0x00,0x00,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[252:255], v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0xe0,0xd9,0xff,0x00,0x00,0xfc]

ds_read_addtid_b32 v5
// GFX12: [0x00,0x00,0xc4,0xda,0x00,0x00,0x00,0x05]

ds_read_addtid_b32 v5 offset:65535
// GFX12: [0xff,0xff,0xc4,0xda,0x00,0x00,0x00,0x05]

ds_read_addtid_b32 v5 offset:0
// GFX12: [0x00,0x00,0xc4,0xda,0x00,0x00,0x00,0x05]

ds_read_addtid_b32 v255 offset:4
// GFX12: [0x04,0x00,0xc4,0xda,0x00,0x00,0x00,0xff]

ds_read_b128 v[5:8], v1
// GFX12: [0x00,0x00,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:65535
// GFX12: [0xff,0xff,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:0
// GFX12: [0x00,0x00,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[252:255], v255 offset:4
// GFX12: [0x04,0x00,0xfc,0xdb,0xff,0x00,0x00,0xfc]

ds_read_b32 v5, v1
// GFX12: [0x00,0x00,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:65535
// GFX12: [0xff,0xff,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:0
// GFX12: [0x00,0x00,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v255, v255 offset:4
// GFX12: [0x04,0x00,0xd8,0xd8,0xff,0x00,0x00,0xff]

ds_read_b64 v[5:6], v1
// GFX12: [0x00,0x00,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:65535
// GFX12: [0xff,0xff,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:0
// GFX12: [0x00,0x00,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[254:255], v255 offset:4
// GFX12: [0x04,0x00,0xd8,0xd9,0xff,0x00,0x00,0xfe]

ds_read_b96 v[5:7], v1
// GFX12: [0x00,0x00,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1 offset:65535
// GFX12: [0xff,0xff,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1 offset:0
// GFX12: [0x00,0x00,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[253:255], v255 offset:4
// GFX12: [0x04,0x00,0xf8,0xdb,0xff,0x00,0x00,0xfd]

ds_read_i16 v5, v1
// GFX12: [0x00,0x00,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:65535
// GFX12: [0xff,0xff,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:0
// GFX12: [0x00,0x00,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v255, v255 offset:4
// GFX12: [0x04,0x00,0xec,0xd8,0xff,0x00,0x00,0xff]

ds_read_i8 v5, v1
// GFX12: [0x00,0x00,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:65535
// GFX12: [0xff,0xff,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:0
// GFX12: [0x00,0x00,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v255, v255 offset:4
// GFX12: [0x04,0x00,0xe4,0xd8,0xff,0x00,0x00,0xff]

ds_read_i8_d16 v5, v1
// GFX12: [0x00,0x00,0x90,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16 v5, v1 offset:65535
// GFX12: [0xff,0xff,0x90,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16 v5, v1 offset:0
// GFX12: [0x00,0x00,0x90,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16 v255, v255 offset:4
// GFX12: [0x04,0x00,0x90,0xda,0xff,0x00,0x00,0xff]

ds_read_i8_d16_hi v5, v1
// GFX12: [0x00,0x00,0x94,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16_hi v5, v1 offset:65535
// GFX12: [0xff,0xff,0x94,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16_hi v5, v1 offset:0
// GFX12: [0x00,0x00,0x94,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16_hi v255, v255 offset:4
// GFX12: [0x04,0x00,0x94,0xda,0xff,0x00,0x00,0xff]

ds_read_u16 v5, v1
// GFX12: [0x00,0x00,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:65535
// GFX12: [0xff,0xff,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:0
// GFX12: [0x00,0x00,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v255, v255 offset:4
// GFX12: [0x04,0x00,0xf0,0xd8,0xff,0x00,0x00,0xff]

ds_read_u16_d16 v5, v1
// GFX12: [0x00,0x00,0x98,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16 v5, v1 offset:65535
// GFX12: [0xff,0xff,0x98,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16 v5, v1 offset:0
// GFX12: [0x00,0x00,0x98,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16 v255, v255 offset:4
// GFX12: [0x04,0x00,0x98,0xda,0xff,0x00,0x00,0xff]

ds_read_u16_d16_hi v5, v1
// GFX12: [0x00,0x00,0x9c,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16_hi v5, v1 offset:65535
// GFX12: [0xff,0xff,0x9c,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16_hi v5, v1 offset:0
// GFX12: [0x00,0x00,0x9c,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16_hi v255, v255 offset:4
// GFX12: [0x04,0x00,0x9c,0xda,0xff,0x00,0x00,0xff]

ds_read_u8 v5, v1
// GFX12: [0x00,0x00,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:65535
// GFX12: [0xff,0xff,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:0
// GFX12: [0x00,0x00,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v255, v255 offset:4
// GFX12: [0x04,0x00,0xe8,0xd8,0xff,0x00,0x00,0xff]

ds_read_u8_d16 v5, v1
// GFX12: [0x00,0x00,0x88,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16 v5, v1 offset:65535
// GFX12: [0xff,0xff,0x88,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16 v5, v1 offset:0
// GFX12: [0x00,0x00,0x88,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16 v255, v255 offset:4
// GFX12: [0x04,0x00,0x88,0xda,0xff,0x00,0x00,0xff]

ds_read_u8_d16_hi v5, v1
// GFX12: [0x00,0x00,0x8c,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16_hi v5, v1 offset:65535
// GFX12: [0xff,0xff,0x8c,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16_hi v5, v1 offset:0
// GFX12: [0x00,0x00,0x8c,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16_hi v255, v255 offset:4
// GFX12: [0x04,0x00,0x8c,0xda,0xff,0x00,0x00,0xff]

ds_rsub_rtn_u32 v5, v1, v2
// GFX12: [0x00,0x00,0x88,0xd8,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0x88,0xd8,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0x88,0xd8,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0x88,0xd8,0xff,0xff,0x00,0xff]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x88,0xd9,0xff,0xfe,0x00,0xfe]

ds_rsub_u32 v1, v2
// GFX12: [0x00,0x00,0x08,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_u32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x08,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_u32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x08,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_u32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x08,0xd8,0xff,0xff,0x00,0x00]

ds_rsub_u64 v1, v[2:3]
// GFX12: [0x00,0x00,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x08,0xd9,0xff,0xfe,0x00,0x00]

ds_store_2addr_b32 v1, v2, v3
// GFX12: [0x00,0x00,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_store_2addr_b32 v1, v2, v3 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_store_2addr_b32 v1, v2, v3 offset0:0 offset1:0
// GFX12: [0x00,0x00,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_store_2addr_b32 v255, v255, v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0x38,0xd8,0xff,0xff,0xff,0x00]

ds_store_2addr_b64 v1, v[2:3], v[3:4]
// GFX12: [0x00,0x00,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_store_2addr_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX12: [0x7f,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_store_2addr_b64 v1, v[2:3], v[3:4] offset0:0 offset1:0
// GFX12: [0x00,0x00,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_store_2addr_b64 v255, v[254:255], v[254:255] offset0:16 offset1:1
// GFX12: [0x10,0x01,0x38,0xd9,0xff,0xfe,0xfe,0x00]

ds_store_2addr_stride64_b32 v1, v2, v3
// GFX12: [0x00,0x00,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_store_2addr_stride64_b32 v1, v2, v3 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_store_2addr_stride64_b32 v1, v2, v3 offset0:0 offset1:0
// GFX12: [0x00,0x00,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_store_2addr_stride64_b32 v255, v255, v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0x3c,0xd8,0xff,0xff,0xff,0x00]

ds_store_2addr_stride64_b64 v1, v[2:3], v[3:4]
// GFX12: [0x00,0x00,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_store_2addr_stride64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX12: [0x7f,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_store_2addr_stride64_b64 v1, v[2:3], v[3:4] offset0:0 offset1:0
// GFX12: [0x00,0x00,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_store_2addr_stride64_b64 v255, v[254:255], v[254:255] offset0:16 offset1:1
// GFX12: [0x10,0x01,0x3c,0xd9,0xff,0xfe,0xfe,0x00]

ds_store_addtid_b32 v1
// GFX12: [0x00,0x00,0xc0,0xda,0x00,0x01,0x00,0x00]

ds_store_addtid_b32 v1 offset:65535
// GFX12: [0xff,0xff,0xc0,0xda,0x00,0x01,0x00,0x00]

ds_store_addtid_b32 v1 offset:0
// GFX12: [0x00,0x00,0xc0,0xda,0x00,0x01,0x00,0x00]

ds_store_addtid_b32 v255 offset:4
// GFX12: [0x04,0x00,0xc0,0xda,0x00,0xff,0x00,0x00]

ds_store_b128 v1, v[2:5]
// GFX12: [0x00,0x00,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_store_b128 v1, v[2:5] offset:65535
// GFX12: [0xff,0xff,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_store_b128 v1, v[2:5] offset:0
// GFX12: [0x00,0x00,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_store_b128 v255, v[252:255] offset:4
// GFX12: [0x04,0x00,0x7c,0xdb,0xff,0xfc,0x00,0x00]

ds_store_b16 v1, v2
// GFX12: [0x00,0x00,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_store_b16 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_store_b16 v1, v2 offset:0
// GFX12: [0x00,0x00,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_store_b16 v255, v255 offset:4
// GFX12: [0x04,0x00,0x7c,0xd8,0xff,0xff,0x00,0x00]

ds_store_b16_d16_hi v1, v2
// GFX12: [0x00,0x00,0x84,0xda,0x01,0x02,0x00,0x00]

ds_store_b16_d16_hi v1, v2 offset:65535
// GFX12: [0xff,0xff,0x84,0xda,0x01,0x02,0x00,0x00]

ds_store_b16_d16_hi v1, v2 offset:0
// GFX12: [0x00,0x00,0x84,0xda,0x01,0x02,0x00,0x00]

ds_store_b16_d16_hi v255, v255 offset:4
// GFX12: [0x04,0x00,0x84,0xda,0xff,0xff,0x00,0x00]

ds_store_b32 v1, v2
// GFX12: [0x00,0x00,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_store_b32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_store_b32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_store_b32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x34,0xd8,0xff,0xff,0x00,0x00]

ds_store_b64 v1, v[2:3]
// GFX12: [0x00,0x00,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_store_b64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_store_b64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_store_b64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x34,0xd9,0xff,0xfe,0x00,0x00]

ds_store_b8 v1, v2
// GFX12: [0x00,0x00,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_store_b8 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_store_b8 v1, v2 offset:0
// GFX12: [0x00,0x00,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_store_b8 v255, v255 offset:4
// GFX12: [0x04,0x00,0x78,0xd8,0xff,0xff,0x00,0x00]

ds_store_b8_d16_hi v1, v2
// GFX12: [0x00,0x00,0x80,0xda,0x01,0x02,0x00,0x00]

ds_store_b8_d16_hi v1, v2 offset:65535
// GFX12: [0xff,0xff,0x80,0xda,0x01,0x02,0x00,0x00]

ds_store_b8_d16_hi v1, v2 offset:0
// GFX12: [0x00,0x00,0x80,0xda,0x01,0x02,0x00,0x00]

ds_store_b8_d16_hi v255, v255 offset:4
// GFX12: [0x04,0x00,0x80,0xda,0xff,0xff,0x00,0x00]

ds_store_b96 v1, v[2:4]
// GFX12: [0x00,0x00,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_store_b96 v1, v[2:4] offset:65535
// GFX12: [0xff,0xff,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_store_b96 v1, v[2:4] offset:0
// GFX12: [0x00,0x00,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_store_b96 v255, v[253:255] offset:4
// GFX12: [0x04,0x00,0x78,0xdb,0xff,0xfd,0x00,0x00]

ds_storexchg_2addr_rtn_b32 v[5:6], v1, v2, v3
// GFX12: [0x00,0x00,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_storexchg_2addr_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_storexchg_2addr_rtn_b32 v[5:6], v1, v2, v3 offset0:0 offset1:0
// GFX12: [0x00,0x00,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_storexchg_2addr_rtn_b32 v[254:255], v255, v255, v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0xb8,0xd8,0xff,0xff,0xff,0xfe]

ds_storexchg_2addr_rtn_b64 v[5:8], v1, v[2:3], v[3:4]
// GFX12: [0x00,0x00,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_storexchg_2addr_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_storexchg_2addr_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:0 offset1:0
// GFX12: [0x00,0x00,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_storexchg_2addr_rtn_b64 v[252:255], v255, v[254:255], v[254:255] offset0:16 offset1:1
// GFX12: [0x10,0x01,0xb8,0xd9,0xff,0xfe,0xfe,0xfc]

ds_storexchg_2addr_stride64_rtn_b32 v[5:6], v1, v2, v3
// GFX12: [0x00,0x00,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_storexchg_2addr_stride64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_storexchg_2addr_stride64_rtn_b32 v[5:6], v1, v2, v3 offset0:0 offset1:0
// GFX12: [0x00,0x00,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_storexchg_2addr_stride64_rtn_b32 v[254:255], v255, v255, v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0xbc,0xd8,0xff,0xff,0xff,0xfe]

ds_storexchg_2addr_stride64_rtn_b64 v[5:8], v1, v[2:3], v[3:4]
// GFX12: [0x00,0x00,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_storexchg_2addr_stride64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_storexchg_2addr_stride64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:0 offset1:0
// GFX12: [0x00,0x00,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_storexchg_2addr_stride64_rtn_b64 v[252:255], v255, v[254:255], v[254:255] offset0:16 offset1:1
// GFX12: [0x10,0x01,0xbc,0xd9,0xff,0xfe,0xfe,0xfc]

ds_storexchg_rtn_b32 v5, v1, v2
// GFX12: [0x00,0x00,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_storexchg_rtn_b32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_storexchg_rtn_b32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_storexchg_rtn_b32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xb4,0xd8,0xff,0xff,0x00,0xff]

ds_storexchg_rtn_b64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_storexchg_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_storexchg_rtn_b64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_storexchg_rtn_b64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0xb4,0xd9,0xff,0xfe,0x00,0xfe]

ds_cond_sub_rtn_u32 v5, v1, v2
// GFX12: [0x00,0x00,0xa0,0xda,0x01,0x02,0x00,0x05]

ds_cond_sub_rtn_u32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0xa0,0xda,0x01,0x02,0x00,0x05]

ds_cond_sub_rtn_u32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0xa0,0xda,0x01,0x02,0x00,0x05]

ds_cond_sub_u32 v1, v2
// GFX12: [0x00,0x00,0x60,0xda,0x01,0x02,0x00,0x00]

ds_cond_sub_u32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x60,0xda,0x01,0x02,0x00,0x00]

ds_cond_sub_u32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x60,0xda,0x01,0x02,0x00,0x00]

ds_sub_clamp_rtn_u32 v5, v1, v2
// GFX12: [0x00,0x00,0xa4,0xda,0x01,0x02,0x00,0x05]

ds_sub_clamp_rtn_u32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0xa4,0xda,0x01,0x02,0x00,0x05]

ds_sub_clamp_rtn_u32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0xa4,0xda,0x01,0x02,0x00,0x05]

ds_sub_clamp_rtn_u32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xa4,0xda,0xff,0xff,0x00,0xff]

ds_sub_clamp_u32 v1, v2
// GFX12: [0x00,0x00,0x64,0xda,0x01,0x02,0x00,0x00]

ds_sub_clamp_u32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x64,0xda,0x01,0x02,0x00,0x00]

ds_sub_clamp_u32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x64,0xda,0x01,0x02,0x00,0x00]

ds_sub_clamp_u32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x64,0xda,0xff,0xff,0x00,0x00]

ds_sub_rtn_u32 v5, v1, v2
// GFX12: [0x00,0x00,0x84,0xd8,0x01,0x02,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0x84,0xd8,0x01,0x02,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0x84,0xd8,0x01,0x02,0x00,0x05]

ds_sub_rtn_u32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0x84,0xd8,0xff,0xff,0x00,0xff]

ds_sub_rtn_u64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x84,0xd9,0xff,0xfe,0x00,0xfe]

ds_sub_u32 v1, v2
// GFX12: [0x00,0x00,0x04,0xd8,0x01,0x02,0x00,0x00]

ds_sub_u32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x04,0xd8,0x01,0x02,0x00,0x00]

ds_sub_u32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x04,0xd8,0x01,0x02,0x00,0x00]

ds_sub_u32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x04,0xd8,0xff,0xff,0x00,0x00]

ds_sub_u64 v1, v[2:3]
// GFX12: [0x00,0x00,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x04,0xd9,0xff,0xfe,0x00,0x00]

ds_write2_b32 v1, v2, v3
// GFX12: [0x00,0x00,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:0 offset1:0
// GFX12: [0x00,0x00,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v255, v255, v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0x38,0xd8,0xff,0xff,0xff,0x00]

ds_write2_b64 v1, v[2:3], v[3:4]
// GFX12: [0x00,0x00,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX12: [0x7f,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:0 offset1:0
// GFX12: [0x00,0x00,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v255, v[254:255], v[254:255] offset0:16 offset1:1
// GFX12: [0x10,0x01,0x38,0xd9,0xff,0xfe,0xfe,0x00]

ds_write2st64_b32 v1, v2, v3
// GFX12: [0x00,0x00,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:0 offset1:0
// GFX12: [0x00,0x00,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v255, v255, v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0x3c,0xd8,0xff,0xff,0xff,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4]
// GFX12: [0x00,0x00,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX12: [0x7f,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:0 offset1:0
// GFX12: [0x00,0x00,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v255, v[254:255], v[254:255] offset0:16 offset1:1
// GFX12: [0x10,0x01,0x3c,0xd9,0xff,0xfe,0xfe,0x00]

ds_write_addtid_b32 v1
// GFX12: [0x00,0x00,0xc0,0xda,0x00,0x01,0x00,0x00]

ds_write_addtid_b32 v1 offset:65535
// GFX12: [0xff,0xff,0xc0,0xda,0x00,0x01,0x00,0x00]

ds_write_addtid_b32 v1 offset:0
// GFX12: [0x00,0x00,0xc0,0xda,0x00,0x01,0x00,0x00]

ds_write_addtid_b32 v255 offset:4
// GFX12: [0x04,0x00,0xc0,0xda,0x00,0xff,0x00,0x00]

ds_write_b128 v1, v[2:5]
// GFX12: [0x00,0x00,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:65535
// GFX12: [0xff,0xff,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:0
// GFX12: [0x00,0x00,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v255, v[252:255] offset:4
// GFX12: [0x04,0x00,0x7c,0xdb,0xff,0xfc,0x00,0x00]

ds_write_b16 v1, v2
// GFX12: [0x00,0x00,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_write_b16 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_write_b16 v1, v2 offset:0
// GFX12: [0x00,0x00,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_write_b16 v255, v255 offset:4
// GFX12: [0x04,0x00,0x7c,0xd8,0xff,0xff,0x00,0x00]

ds_write_b16_d16_hi v1, v2
// GFX12: [0x00,0x00,0x84,0xda,0x01,0x02,0x00,0x00]

ds_write_b16_d16_hi v1, v2 offset:65535
// GFX12: [0xff,0xff,0x84,0xda,0x01,0x02,0x00,0x00]

ds_write_b16_d16_hi v1, v2 offset:0
// GFX12: [0x00,0x00,0x84,0xda,0x01,0x02,0x00,0x00]

ds_write_b16_d16_hi v255, v255 offset:4
// GFX12: [0x04,0x00,0x84,0xda,0xff,0xff,0x00,0x00]

ds_write_b32 v1, v2
// GFX12: [0x00,0x00,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_write_b32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_write_b32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_write_b32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x34,0xd8,0xff,0xff,0x00,0x00]

ds_write_b64 v1, v[2:3]
// GFX12: [0x00,0x00,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x34,0xd9,0xff,0xfe,0x00,0x00]

ds_write_b8 v1, v2
// GFX12: [0x00,0x00,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_write_b8 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_write_b8 v1, v2 offset:0
// GFX12: [0x00,0x00,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_write_b8 v255, v255 offset:4
// GFX12: [0x04,0x00,0x78,0xd8,0xff,0xff,0x00,0x00]

ds_write_b8_d16_hi v1, v2
// GFX12: [0x00,0x00,0x80,0xda,0x01,0x02,0x00,0x00]

ds_write_b8_d16_hi v1, v2 offset:65535
// GFX12: [0xff,0xff,0x80,0xda,0x01,0x02,0x00,0x00]

ds_write_b8_d16_hi v1, v2 offset:0
// GFX12: [0x00,0x00,0x80,0xda,0x01,0x02,0x00,0x00]

ds_write_b8_d16_hi v255, v255 offset:4
// GFX12: [0x04,0x00,0x80,0xda,0xff,0xff,0x00,0x00]

ds_write_b96 v1, v[2:4]
// GFX12: [0x00,0x00,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:65535
// GFX12: [0xff,0xff,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:0
// GFX12: [0x00,0x00,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v255, v[253:255] offset:4
// GFX12: [0x04,0x00,0x78,0xdb,0xff,0xfd,0x00,0x00]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3
// GFX12: [0x00,0x00,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:0 offset1:0
// GFX12: [0x00,0x00,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[254:255], v255, v255, v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0xb8,0xd8,0xff,0xff,0xff,0xfe]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4]
// GFX12: [0x00,0x00,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:0 offset1:0
// GFX12: [0x00,0x00,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[252:255], v255, v[254:255], v[254:255] offset0:16 offset1:1
// GFX12: [0x10,0x01,0xb8,0xd9,0xff,0xfe,0xfe,0xfc]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3
// GFX12: [0x00,0x00,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:0 offset1:0
// GFX12: [0x00,0x00,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[254:255], v255, v255, v255 offset0:16 offset1:1
// GFX12: [0x10,0x01,0xbc,0xd8,0xff,0xff,0xff,0xfe]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4]
// GFX12: [0x00,0x00,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX12: [0x7f,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:0 offset1:0
// GFX12: [0x00,0x00,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[252:255], v255, v[254:255], v[254:255] offset0:16 offset1:1
// GFX12: [0x10,0x01,0xbc,0xd9,0xff,0xfe,0xfe,0xfc]

ds_wrxchg_rtn_b32 v5, v1, v2
// GFX12: [0x00,0x00,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xb4,0xd8,0xff,0xff,0x00,0xff]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0xb4,0xd9,0xff,0xfe,0x00,0xfe]

ds_xor_b32 v1, v2
// GFX12: [0x00,0x00,0x2c,0xd8,0x01,0x02,0x00,0x00]

ds_xor_b32 v1, v2 offset:65535
// GFX12: [0xff,0xff,0x2c,0xd8,0x01,0x02,0x00,0x00]

ds_xor_b32 v1, v2 offset:0
// GFX12: [0x00,0x00,0x2c,0xd8,0x01,0x02,0x00,0x00]

ds_xor_b32 v255, v255 offset:4
// GFX12: [0x04,0x00,0x2c,0xd8,0xff,0xff,0x00,0x00]

ds_xor_b64 v1, v[2:3]
// GFX12: [0x00,0x00,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0x2c,0xd9,0xff,0xfe,0x00,0x00]

ds_xor_rtn_b32 v5, v1, v2
// GFX12: [0x00,0x00,0xac,0xd8,0x01,0x02,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v2 offset:65535
// GFX12: [0xff,0xff,0xac,0xd8,0x01,0x02,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v2 offset:0
// GFX12: [0x00,0x00,0xac,0xd8,0x01,0x02,0x00,0x05]

ds_xor_rtn_b32 v255, v255, v255 offset:4
// GFX12: [0x04,0x00,0xac,0xd8,0xff,0xff,0x00,0xff]

ds_xor_rtn_b64 v[5:6], v1, v[2:3]
// GFX12: [0x00,0x00,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// GFX12: [0xff,0xff,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:0
// GFX12: [0x00,0x00,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[254:255], v255, v[254:255] offset:4
// GFX12: [0x04,0x00,0xac,0xd9,0xff,0xfe,0x00,0xfe]

ds_swizzle_b32 v8, v2
// GFX12: [0x00,0x00,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:0
// GFX12: [0x00,0x00,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:0xFFFF
// GFX12: [0xff,0xff,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:swizzle(QUAD_PERM, 0, 1, 2, 3)
// GFX12: [0xe4,0x80,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:swizzle(SWAP,16)
// GFX12: [0x1f,0x40,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:swizzle(REVERSE,8)
// GFX12: [0x1f,0x1c,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:swizzle(BROADCAST,4,1)
// GFX12: [0x3c,0x00,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:swizzle(BROADCAST,8,7)
// GFX12: [0xf8,0x00,0xd4,0xd8,0x02,0x00,0x00,0x08]

ds_swizzle_b32 v8, v2 offset:swizzle(BITMASK_PERM, "01pip")
// GFX12: [0x07,0x09,0xd4,0xd8,0x02,0x00,0x00,0x08]
