# Maintainers

Many of the concepts here are taking from the [KubeVirt maintainers](https://github.com/kubevirt/community/blob/main/GOVERNANCE.md#selecting-maintainers) guide

Containerized Data Importer maintainers govern the project. Maintainers collectively manage the project's resources and contributors, and speak for the project in public.

This privilege is granted with some expectation of responsibility: maintainers are people who care about the KubeVirt project and want to help it grow and improve. A maintainer is not just someone who can make changes, but someone who has demonstrated their ability to collaborate with the team, get the most knowledgeable people to review code and docs, contribute high-quality code, and follow through to fix issues.

# Selecting Maintainers
For nominations, the current maintainers will look at the following criteria:

  * Commitment to the project: have they participated in discussions, 
    contributions, and reviews for 1 year or more?
  * Does the person show leadership in one of these areas?
    * Active reviewer in project.
    * Mentoring other project contributors.
    * Activity in helping new users and guiding them to successful use of the project.
    * Triaging issues.
  * Do they understand how the project works (policies, processes, etc)?
  * Are they willing to take on the additional duties of a maintainer?

## Approvers
The current list of approvers can be found [here](https://github.com/kubevirt/containerized-data-importer/blob/main/OWNERS_ALIASES). Approvers like maintainers need to demonstrate the ability to contribute high quality code, and follow through on to fix issues. As well as mentor and guide new project contributors.

## Code of Conduct

[Code of Conduct](./code-of-conduct.md)
violations by community members will be discussed and resolved
on the [private Maintainer mailing list](mailto:cncf-kubevirt-maintainers@lists.cncf.io).  If the reported CoC violator
is a Maintainer, the Maintainers will instead designate two Maintainers to work
with CNCF staff in resolving the report.

## Removing Maintainers

Maintainers may voluntarily retire at any time.  Should a maintainer retire, 
it requires a majority vote of the current maintainers to reinstate them.

Maintainers may also be demoted at any time for one of the following reasons:

* Inactivity, including 6 months or more of non-participation or non-communication,
* Violations of the Code of Conduct,
* Other actions that harm the reputation, stability, or harmony of the Containerized Data Importer project.
