// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `SigningAlgorithmSpec`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let signingalgorithmspec = unimplemented!();
/// match signingalgorithmspec {
///     SigningAlgorithmSpec::EcdsaSha256 => { /* ... */ },
///     SigningAlgorithmSpec::EcdsaSha384 => { /* ... */ },
///     SigningAlgorithmSpec::EcdsaSha512 => { /* ... */ },
///     SigningAlgorithmSpec::RsassaPkcs1V15Sha256 => { /* ... */ },
///     SigningAlgorithmSpec::RsassaPkcs1V15Sha384 => { /* ... */ },
///     SigningAlgorithmSpec::RsassaPkcs1V15Sha512 => { /* ... */ },
///     SigningAlgorithmSpec::RsassaPssSha256 => { /* ... */ },
///     SigningAlgorithmSpec::RsassaPssSha384 => { /* ... */ },
///     SigningAlgorithmSpec::RsassaPssSha512 => { /* ... */ },
///     SigningAlgorithmSpec::Sm2Dsa => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `signingalgorithmspec` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `SigningAlgorithmSpec::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `SigningAlgorithmSpec::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `SigningAlgorithmSpec::NewFeature` is defined.
/// Specifically, when `signingalgorithmspec` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `SigningAlgorithmSpec::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum SigningAlgorithmSpec {
    #[allow(missing_docs)] // documentation missing in model
    EcdsaSha256,
    #[allow(missing_docs)] // documentation missing in model
    EcdsaSha384,
    #[allow(missing_docs)] // documentation missing in model
    EcdsaSha512,
    #[allow(missing_docs)] // documentation missing in model
    RsassaPkcs1V15Sha256,
    #[allow(missing_docs)] // documentation missing in model
    RsassaPkcs1V15Sha384,
    #[allow(missing_docs)] // documentation missing in model
    RsassaPkcs1V15Sha512,
    #[allow(missing_docs)] // documentation missing in model
    RsassaPssSha256,
    #[allow(missing_docs)] // documentation missing in model
    RsassaPssSha384,
    #[allow(missing_docs)] // documentation missing in model
    RsassaPssSha512,
    #[allow(missing_docs)] // documentation missing in model
    Sm2Dsa,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for SigningAlgorithmSpec {
    fn from(s: &str) -> Self {
        match s {
            "ECDSA_SHA_256" => SigningAlgorithmSpec::EcdsaSha256,
            "ECDSA_SHA_384" => SigningAlgorithmSpec::EcdsaSha384,
            "ECDSA_SHA_512" => SigningAlgorithmSpec::EcdsaSha512,
            "RSASSA_PKCS1_V1_5_SHA_256" => SigningAlgorithmSpec::RsassaPkcs1V15Sha256,
            "RSASSA_PKCS1_V1_5_SHA_384" => SigningAlgorithmSpec::RsassaPkcs1V15Sha384,
            "RSASSA_PKCS1_V1_5_SHA_512" => SigningAlgorithmSpec::RsassaPkcs1V15Sha512,
            "RSASSA_PSS_SHA_256" => SigningAlgorithmSpec::RsassaPssSha256,
            "RSASSA_PSS_SHA_384" => SigningAlgorithmSpec::RsassaPssSha384,
            "RSASSA_PSS_SHA_512" => SigningAlgorithmSpec::RsassaPssSha512,
            "SM2DSA" => SigningAlgorithmSpec::Sm2Dsa,
            other => SigningAlgorithmSpec::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for SigningAlgorithmSpec {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(SigningAlgorithmSpec::from(s))
    }
}
impl SigningAlgorithmSpec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SigningAlgorithmSpec::EcdsaSha256 => "ECDSA_SHA_256",
            SigningAlgorithmSpec::EcdsaSha384 => "ECDSA_SHA_384",
            SigningAlgorithmSpec::EcdsaSha512 => "ECDSA_SHA_512",
            SigningAlgorithmSpec::RsassaPkcs1V15Sha256 => "RSASSA_PKCS1_V1_5_SHA_256",
            SigningAlgorithmSpec::RsassaPkcs1V15Sha384 => "RSASSA_PKCS1_V1_5_SHA_384",
            SigningAlgorithmSpec::RsassaPkcs1V15Sha512 => "RSASSA_PKCS1_V1_5_SHA_512",
            SigningAlgorithmSpec::RsassaPssSha256 => "RSASSA_PSS_SHA_256",
            SigningAlgorithmSpec::RsassaPssSha384 => "RSASSA_PSS_SHA_384",
            SigningAlgorithmSpec::RsassaPssSha512 => "RSASSA_PSS_SHA_512",
            SigningAlgorithmSpec::Sm2Dsa => "SM2DSA",
            SigningAlgorithmSpec::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "ECDSA_SHA_256",
            "ECDSA_SHA_384",
            "ECDSA_SHA_512",
            "RSASSA_PKCS1_V1_5_SHA_256",
            "RSASSA_PKCS1_V1_5_SHA_384",
            "RSASSA_PKCS1_V1_5_SHA_512",
            "RSASSA_PSS_SHA_256",
            "RSASSA_PSS_SHA_384",
            "RSASSA_PSS_SHA_512",
            "SM2DSA",
        ]
    }
}
impl ::std::convert::AsRef<str> for SigningAlgorithmSpec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl SigningAlgorithmSpec {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for SigningAlgorithmSpec {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            SigningAlgorithmSpec::EcdsaSha256 => write!(f, "ECDSA_SHA_256"),
            SigningAlgorithmSpec::EcdsaSha384 => write!(f, "ECDSA_SHA_384"),
            SigningAlgorithmSpec::EcdsaSha512 => write!(f, "ECDSA_SHA_512"),
            SigningAlgorithmSpec::RsassaPkcs1V15Sha256 => write!(f, "RSASSA_PKCS1_V1_5_SHA_256"),
            SigningAlgorithmSpec::RsassaPkcs1V15Sha384 => write!(f, "RSASSA_PKCS1_V1_5_SHA_384"),
            SigningAlgorithmSpec::RsassaPkcs1V15Sha512 => write!(f, "RSASSA_PKCS1_V1_5_SHA_512"),
            SigningAlgorithmSpec::RsassaPssSha256 => write!(f, "RSASSA_PSS_SHA_256"),
            SigningAlgorithmSpec::RsassaPssSha384 => write!(f, "RSASSA_PSS_SHA_384"),
            SigningAlgorithmSpec::RsassaPssSha512 => write!(f, "RSASSA_PSS_SHA_512"),
            SigningAlgorithmSpec::Sm2Dsa => write!(f, "SM2DSA"),
            SigningAlgorithmSpec::Unknown(value) => write!(f, "{}", value),
        }
    }
}
