/*
 *	Routines for loading and storing sysconfig files
 *
 *	Copyright (C) 2009-2010  Olaf Kirch <okir@suse.de>
 *	Copyright (C) 2011 SUSE LINUX Products GmbH, Nuernberg, Germany.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *	MA  02110-1301  USA
 *
 *	Authors: Olaf Kirch <okir@suse.de>
 *	         Marius Tomaschewski <mt@suse.de>
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	You can find the wicked project at http://gitorious.org/wicked/.
 *
 */
#ifndef __NETCONTROL_UTILS_SYSCONFIG_H
#define __NETCONTROL_UTILS_SYSCONFIG_H
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <sutils.h>


typedef struct nc_sysconfig {
	char *			pathname;
	nc_var_array_t		vars;
} nc_sysconfig_t;

typedef struct nc_sysconfig_array {
	unsigned int		count;
	nc_sysconfig_t **	data;
} nc_sysconfig_array_t;

#define NC_SYSCONFIG_ARRAY_INIT	{ .count = 0, .data = NULL }

nc_sysconfig_t *nc_sysconfig_new(const char *filename);
nc_sysconfig_t *nc_sysconfig_read(const char *filename);
int		nc_sysconfig_rewrite(nc_sysconfig_t *sc, const char *dot_backup);
int		nc_sysconfig_overwrite(nc_sysconfig_t *sc, const char *dot_backup);
void		nc_sysconfig_free(nc_sysconfig_t *sc);

int		nc_sysconfig_init(nc_sysconfig_t *sc, const char *filename);
int		nc_sysconfig_load(nc_sysconfig_t *sc, const char *filename);
void		nc_sysconfig_destroy(nc_sysconfig_t *sc);

nc_var_t *	nc_sysconfig_get(const nc_sysconfig_t *, const char *);
int		nc_sysconfig_get_string(const nc_sysconfig_t *, const char *, char **);
int		nc_sysconfig_get_uint(const nc_sysconfig_t *, const char *, unsigned int *);
int		nc_sysconfig_set(nc_sysconfig_t *, const char *, const char *);
int		nc_sysconfig_set_uint(nc_sysconfig_t *, const char *, unsigned int);

int		nc_sysconfig_del(nc_sysconfig_t *, const char *);
int		nc_sysconfig_del_matching(nc_sysconfig_t *, const char *);

int		nc_sysconfig_find_matching(nc_sysconfig_t *, const char *, nc_string_array_t *);

void		nc_sysconfig_array_init(nc_sysconfig_array_t *array);
void		nc_sysconfig_array_destroy(nc_sysconfig_array_t *array);
int		nc_sysconfig_array_append(nc_sysconfig_array_t *array, nc_sysconfig_t *sc);

#endif /* __NETCONTROL_UTILS_SYSCONFIG_H */
