; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v,+zfh,+zvfh,+zfbfmin,+zvfbfmin \
; RUN:   -verify-machineinstrs -target-abi=ilp32d | FileCheck %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v,+zfh,+zvfh,+zfbfmin,+zvfbfmin \
; RUN:   -verify-machineinstrs -target-abi=lp64d | FileCheck %s

declare void @llvm.riscv.vse.nxv1i64(
  <vscale x 1 x i64>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv1i64_nxv1i64(<vscale x 1 x i64> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv1i64(
    <vscale x 1 x i64> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv1i64(
  <vscale x 1 x i64>,
  ptr,
  <vscale x 1 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv1i64_nxv1i64(<vscale x 1 x i64> %0, ptr %1, <vscale x 1 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv1i64(
    <vscale x 1 x i64> %0,
    ptr %1,
    <vscale x 1 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv2i64(
  <vscale x 2 x i64>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv2i64_nxv2i64(<vscale x 2 x i64> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv2i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv2i64(
    <vscale x 2 x i64> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv2i64(
  <vscale x 2 x i64>,
  ptr,
  <vscale x 2 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv2i64_nxv2i64(<vscale x 2 x i64> %0, ptr %1, <vscale x 2 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv2i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv2i64(
    <vscale x 2 x i64> %0,
    ptr %1,
    <vscale x 2 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv4i64(
  <vscale x 4 x i64>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv4i64_nxv4i64(<vscale x 4 x i64> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv4i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv4i64(
    <vscale x 4 x i64> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv4i64(
  <vscale x 4 x i64>,
  ptr,
  <vscale x 4 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv4i64_nxv4i64(<vscale x 4 x i64> %0, ptr %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv4i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv4i64(
    <vscale x 4 x i64> %0,
    ptr %1,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv8i64(
  <vscale x 8 x i64>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv8i64_nxv8i64(<vscale x 8 x i64> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv8i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv8i64(
    <vscale x 8 x i64> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv8i64(
  <vscale x 8 x i64>,
  ptr,
  <vscale x 8 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv8i64_nxv8i64(<vscale x 8 x i64> %0, ptr %1, <vscale x 8 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv8i64_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv8i64(
    <vscale x 8 x i64> %0,
    ptr %1,
    <vscale x 8 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv1f64(
  <vscale x 1 x double>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv1f64_nxv1f64(<vscale x 1 x double> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv1f64_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv1f64(
    <vscale x 1 x double> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv1f64(
  <vscale x 1 x double>,
  ptr,
  <vscale x 1 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv1f64_nxv1f64(<vscale x 1 x double> %0, ptr %1, <vscale x 1 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv1f64_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv1f64(
    <vscale x 1 x double> %0,
    ptr %1,
    <vscale x 1 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv2f64(
  <vscale x 2 x double>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv2f64_nxv2f64(<vscale x 2 x double> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv2f64_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv2f64(
    <vscale x 2 x double> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv2f64(
  <vscale x 2 x double>,
  ptr,
  <vscale x 2 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv2f64_nxv2f64(<vscale x 2 x double> %0, ptr %1, <vscale x 2 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv2f64_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv2f64(
    <vscale x 2 x double> %0,
    ptr %1,
    <vscale x 2 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv4f64(
  <vscale x 4 x double>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv4f64_nxv4f64(<vscale x 4 x double> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv4f64_nxv4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv4f64(
    <vscale x 4 x double> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv4f64(
  <vscale x 4 x double>,
  ptr,
  <vscale x 4 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv4f64_nxv4f64(<vscale x 4 x double> %0, ptr %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv4f64_nxv4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv4f64(
    <vscale x 4 x double> %0,
    ptr %1,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv8f64(
  <vscale x 8 x double>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv8f64_nxv8f64(<vscale x 8 x double> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv8f64_nxv8f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv8f64(
    <vscale x 8 x double> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv8f64(
  <vscale x 8 x double>,
  ptr,
  <vscale x 8 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv8f64_nxv8f64(<vscale x 8 x double> %0, ptr %1, <vscale x 8 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv8f64_nxv8f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv8f64(
    <vscale x 8 x double> %0,
    ptr %1,
    <vscale x 8 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv1i32(
  <vscale x 1 x i32>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv1i32_nxv1i32(<vscale x 1 x i32> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv1i32(
    <vscale x 1 x i32> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv1i32(
  <vscale x 1 x i32>,
  ptr,
  <vscale x 1 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv1i32_nxv1i32(<vscale x 1 x i32> %0, ptr %1, <vscale x 1 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv1i32(
    <vscale x 1 x i32> %0,
    ptr %1,
    <vscale x 1 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv2i32(
  <vscale x 2 x i32>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv2i32_nxv2i32(<vscale x 2 x i32> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv2i32(
    <vscale x 2 x i32> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv2i32(
  <vscale x 2 x i32>,
  ptr,
  <vscale x 2 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv2i32_nxv2i32(<vscale x 2 x i32> %0, ptr %1, <vscale x 2 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv2i32(
    <vscale x 2 x i32> %0,
    ptr %1,
    <vscale x 2 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv4i32(
  <vscale x 4 x i32>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv4i32_nxv4i32(<vscale x 4 x i32> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv4i32(
    <vscale x 4 x i32> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv4i32(
  <vscale x 4 x i32>,
  ptr,
  <vscale x 4 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv4i32_nxv4i32(<vscale x 4 x i32> %0, ptr %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv4i32(
    <vscale x 4 x i32> %0,
    ptr %1,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv8i32(
  <vscale x 8 x i32>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv8i32_nxv8i32(<vscale x 8 x i32> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv8i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv8i32(
    <vscale x 8 x i32> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv8i32(
  <vscale x 8 x i32>,
  ptr,
  <vscale x 8 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv8i32_nxv8i32(<vscale x 8 x i32> %0, ptr %1, <vscale x 8 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv8i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv8i32(
    <vscale x 8 x i32> %0,
    ptr %1,
    <vscale x 8 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv16i32(
  <vscale x 16 x i32>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv16i32_nxv16i32(<vscale x 16 x i32> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv16i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv16i32(
    <vscale x 16 x i32> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv16i32(
  <vscale x 16 x i32>,
  ptr,
  <vscale x 16 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv16i32_nxv16i32(<vscale x 16 x i32> %0, ptr %1, <vscale x 16 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv16i32_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv16i32(
    <vscale x 16 x i32> %0,
    ptr %1,
    <vscale x 16 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv1f32(
  <vscale x 1 x float>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv1f32_nxv1f32(<vscale x 1 x float> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv1f32_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv1f32(
    <vscale x 1 x float> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv1f32(
  <vscale x 1 x float>,
  ptr,
  <vscale x 1 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv1f32_nxv1f32(<vscale x 1 x float> %0, ptr %1, <vscale x 1 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv1f32_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv1f32(
    <vscale x 1 x float> %0,
    ptr %1,
    <vscale x 1 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv2f32(
  <vscale x 2 x float>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv2f32_nxv2f32(<vscale x 2 x float> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv2f32_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv2f32(
    <vscale x 2 x float> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv2f32(
  <vscale x 2 x float>,
  ptr,
  <vscale x 2 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv2f32_nxv2f32(<vscale x 2 x float> %0, ptr %1, <vscale x 2 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv2f32_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv2f32(
    <vscale x 2 x float> %0,
    ptr %1,
    <vscale x 2 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv4f32(
  <vscale x 4 x float>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv4f32_nxv4f32(<vscale x 4 x float> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv4f32_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv4f32(
    <vscale x 4 x float> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv4f32(
  <vscale x 4 x float>,
  ptr,
  <vscale x 4 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv4f32_nxv4f32(<vscale x 4 x float> %0, ptr %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv4f32_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv4f32(
    <vscale x 4 x float> %0,
    ptr %1,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv8f32(
  <vscale x 8 x float>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv8f32_nxv8f32(<vscale x 8 x float> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv8f32_nxv8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv8f32(
    <vscale x 8 x float> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv8f32(
  <vscale x 8 x float>,
  ptr,
  <vscale x 8 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv8f32_nxv8f32(<vscale x 8 x float> %0, ptr %1, <vscale x 8 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv8f32_nxv8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv8f32(
    <vscale x 8 x float> %0,
    ptr %1,
    <vscale x 8 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv16f32(
  <vscale x 16 x float>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv16f32_nxv16f32(<vscale x 16 x float> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv16f32_nxv16f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv16f32(
    <vscale x 16 x float> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv16f32(
  <vscale x 16 x float>,
  ptr,
  <vscale x 16 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv16f32_nxv16f32(<vscale x 16 x float> %0, ptr %1, <vscale x 16 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv16f32_nxv16f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv16f32(
    <vscale x 16 x float> %0,
    ptr %1,
    <vscale x 16 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv1i16(
  <vscale x 1 x i16>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv1i16_nxv1i16(<vscale x 1 x i16> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv1i16(
    <vscale x 1 x i16> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv1i16(
  <vscale x 1 x i16>,
  ptr,
  <vscale x 1 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv1i16_nxv1i16(<vscale x 1 x i16> %0, ptr %1, <vscale x 1 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv1i16(
    <vscale x 1 x i16> %0,
    ptr %1,
    <vscale x 1 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv2i16(
  <vscale x 2 x i16>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv2i16_nxv2i16(<vscale x 2 x i16> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv2i16(
    <vscale x 2 x i16> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv2i16(
  <vscale x 2 x i16>,
  ptr,
  <vscale x 2 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv2i16_nxv2i16(<vscale x 2 x i16> %0, ptr %1, <vscale x 2 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv2i16(
    <vscale x 2 x i16> %0,
    ptr %1,
    <vscale x 2 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv4i16(
  <vscale x 4 x i16>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv4i16_nxv4i16(<vscale x 4 x i16> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv4i16(
    <vscale x 4 x i16> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv4i16(
  <vscale x 4 x i16>,
  ptr,
  <vscale x 4 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv4i16_nxv4i16(<vscale x 4 x i16> %0, ptr %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv4i16(
    <vscale x 4 x i16> %0,
    ptr %1,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv8i16(
  <vscale x 8 x i16>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv8i16_nxv8i16(<vscale x 8 x i16> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv8i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv8i16(
    <vscale x 8 x i16> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv8i16(
  <vscale x 8 x i16>,
  ptr,
  <vscale x 8 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv8i16_nxv8i16(<vscale x 8 x i16> %0, ptr %1, <vscale x 8 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv8i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv8i16(
    <vscale x 8 x i16> %0,
    ptr %1,
    <vscale x 8 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv16i16(
  <vscale x 16 x i16>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv16i16_nxv16i16(<vscale x 16 x i16> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv16i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv16i16(
    <vscale x 16 x i16> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv16i16(
  <vscale x 16 x i16>,
  ptr,
  <vscale x 16 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv16i16_nxv16i16(<vscale x 16 x i16> %0, ptr %1, <vscale x 16 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv16i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv16i16(
    <vscale x 16 x i16> %0,
    ptr %1,
    <vscale x 16 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv32i16(
  <vscale x 32 x i16>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv32i16_nxv32i16(<vscale x 32 x i16> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv32i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv32i16(
    <vscale x 32 x i16> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv32i16(
  <vscale x 32 x i16>,
  ptr,
  <vscale x 32 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv32i16_nxv32i16(<vscale x 32 x i16> %0, ptr %1, <vscale x 32 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv32i16_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv32i16(
    <vscale x 32 x i16> %0,
    ptr %1,
    <vscale x 32 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv1f16(
  <vscale x 1 x half>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv1f16_nxv1f16(<vscale x 1 x half> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv1f16_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv1f16(
    <vscale x 1 x half> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv1f16(
  <vscale x 1 x half>,
  ptr,
  <vscale x 1 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv1f16_nxv1f16(<vscale x 1 x half> %0, ptr %1, <vscale x 1 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv1f16_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv1f16(
    <vscale x 1 x half> %0,
    ptr %1,
    <vscale x 1 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv2f16(
  <vscale x 2 x half>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv2f16_nxv2f16(<vscale x 2 x half> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv2f16_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv2f16(
    <vscale x 2 x half> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv2f16(
  <vscale x 2 x half>,
  ptr,
  <vscale x 2 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv2f16_nxv2f16(<vscale x 2 x half> %0, ptr %1, <vscale x 2 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv2f16_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv2f16(
    <vscale x 2 x half> %0,
    ptr %1,
    <vscale x 2 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv4f16(
  <vscale x 4 x half>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv4f16_nxv4f16(<vscale x 4 x half> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv4f16_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv4f16(
    <vscale x 4 x half> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv4f16(
  <vscale x 4 x half>,
  ptr,
  <vscale x 4 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv4f16_nxv4f16(<vscale x 4 x half> %0, ptr %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv4f16_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv4f16(
    <vscale x 4 x half> %0,
    ptr %1,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv8f16(
  <vscale x 8 x half>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv8f16_nxv8f16(<vscale x 8 x half> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv8f16_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv8f16(
    <vscale x 8 x half> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv8f16(
  <vscale x 8 x half>,
  ptr,
  <vscale x 8 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv8f16_nxv8f16(<vscale x 8 x half> %0, ptr %1, <vscale x 8 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv8f16_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv8f16(
    <vscale x 8 x half> %0,
    ptr %1,
    <vscale x 8 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv16f16(
  <vscale x 16 x half>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv16f16_nxv16f16(<vscale x 16 x half> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv16f16_nxv16f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv16f16(
    <vscale x 16 x half> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv16f16(
  <vscale x 16 x half>,
  ptr,
  <vscale x 16 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv16f16_nxv16f16(<vscale x 16 x half> %0, ptr %1, <vscale x 16 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv16f16_nxv16f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv16f16(
    <vscale x 16 x half> %0,
    ptr %1,
    <vscale x 16 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv32f16(
  <vscale x 32 x half>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv32f16_nxv32f16(<vscale x 32 x half> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv32f16_nxv32f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv32f16(
    <vscale x 32 x half> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv32f16(
  <vscale x 32 x half>,
  ptr,
  <vscale x 32 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv32f16_nxv32f16(<vscale x 32 x half> %0, ptr %1, <vscale x 32 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv32f16_nxv32f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv32f16(
    <vscale x 32 x half> %0,
    ptr %1,
    <vscale x 32 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv1bf16(
  <vscale x 1 x bfloat>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv1bf16_nxv1bf16(<vscale x 1 x bfloat> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv1bf16_nxv1bf16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv1bf16(
    <vscale x 1 x bfloat> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv1bf16(
  <vscale x 1 x bfloat>,
  ptr,
  <vscale x 1 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv1bf16_nxv1bf16(<vscale x 1 x bfloat> %0, ptr %1, <vscale x 1 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv1bf16_nxv1bf16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv1bf16(
    <vscale x 1 x bfloat> %0,
    ptr %1,
    <vscale x 1 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv2bf16(
  <vscale x 2 x bfloat>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv2bf16_nxv2bf16(<vscale x 2 x bfloat> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv2bf16_nxv2bf16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv2bf16(
    <vscale x 2 x bfloat> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv2bf16(
  <vscale x 2 x bfloat>,
  ptr,
  <vscale x 2 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv2bf16_nxv2bf16(<vscale x 2 x bfloat> %0, ptr %1, <vscale x 2 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv2bf16_nxv2bf16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv2bf16(
    <vscale x 2 x bfloat> %0,
    ptr %1,
    <vscale x 2 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv4bf16(
  <vscale x 4 x bfloat>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv4bf16_nxv4bf16(<vscale x 4 x bfloat> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv4bf16_nxv4bf16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv4bf16(
    <vscale x 4 x bfloat> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv4bf16(
  <vscale x 4 x bfloat>,
  ptr,
  <vscale x 4 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv4bf16_nxv4bf16(<vscale x 4 x bfloat> %0, ptr %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv4bf16_nxv4bf16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv4bf16(
    <vscale x 4 x bfloat> %0,
    ptr %1,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv8bf16(
  <vscale x 8 x bfloat>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv8bf16_nxv8bf16(<vscale x 8 x bfloat> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv8bf16_nxv8bf16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv8bf16(
    <vscale x 8 x bfloat> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv8bf16(
  <vscale x 8 x bfloat>,
  ptr,
  <vscale x 8 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv8bf16_nxv8bf16(<vscale x 8 x bfloat> %0, ptr %1, <vscale x 8 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv8bf16_nxv8bf16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv8bf16(
    <vscale x 8 x bfloat> %0,
    ptr %1,
    <vscale x 8 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv16bf16(
  <vscale x 16 x bfloat>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv16bf16_nxv16bf16(<vscale x 16 x bfloat> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv16bf16_nxv16bf16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv16bf16(
    <vscale x 16 x bfloat> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv16bf16(
  <vscale x 16 x bfloat>,
  ptr,
  <vscale x 16 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv16bf16_nxv16bf16(<vscale x 16 x bfloat> %0, ptr %1, <vscale x 16 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv16bf16_nxv16bf16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv16bf16(
    <vscale x 16 x bfloat> %0,
    ptr %1,
    <vscale x 16 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv32bf16(
  <vscale x 32 x bfloat>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv32bf16_nxv32bf16(<vscale x 32 x bfloat> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv32bf16_nxv32bf16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv32bf16(
    <vscale x 32 x bfloat> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv32bf16(
  <vscale x 32 x bfloat>,
  ptr,
  <vscale x 32 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv32bf16_nxv32bf16(<vscale x 32 x bfloat> %0, ptr %1, <vscale x 32 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv32bf16_nxv32bf16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv32bf16(
    <vscale x 32 x bfloat> %0,
    ptr %1,
    <vscale x 32 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv1i8(
  <vscale x 1 x i8>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv1i8_nxv1i8(<vscale x 1 x i8> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv1i8(
    <vscale x 1 x i8> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv1i8(
  <vscale x 1 x i8>,
  ptr,
  <vscale x 1 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv1i8_nxv1i8(<vscale x 1 x i8> %0, ptr %1, <vscale x 1 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv1i8(
    <vscale x 1 x i8> %0,
    ptr %1,
    <vscale x 1 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv2i8(
  <vscale x 2 x i8>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv2i8_nxv2i8(<vscale x 2 x i8> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv2i8(
    <vscale x 2 x i8> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv2i8(
  <vscale x 2 x i8>,
  ptr,
  <vscale x 2 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv2i8_nxv2i8(<vscale x 2 x i8> %0, ptr %1, <vscale x 2 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv2i8(
    <vscale x 2 x i8> %0,
    ptr %1,
    <vscale x 2 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv4i8(
  <vscale x 4 x i8>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv4i8_nxv4i8(<vscale x 4 x i8> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv4i8(
    <vscale x 4 x i8> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv4i8(
  <vscale x 4 x i8>,
  ptr,
  <vscale x 4 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv4i8_nxv4i8(<vscale x 4 x i8> %0, ptr %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv4i8(
    <vscale x 4 x i8> %0,
    ptr %1,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv8i8(
  <vscale x 8 x i8>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv8i8_nxv8i8(<vscale x 8 x i8> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv8i8(
    <vscale x 8 x i8> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv8i8(
  <vscale x 8 x i8>,
  ptr,
  <vscale x 8 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv8i8_nxv8i8(<vscale x 8 x i8> %0, ptr %1, <vscale x 8 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv8i8(
    <vscale x 8 x i8> %0,
    ptr %1,
    <vscale x 8 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv16i8(
  <vscale x 16 x i8>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv16i8_nxv16i8(<vscale x 16 x i8> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv16i8(
    <vscale x 16 x i8> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv16i8(
  <vscale x 16 x i8>,
  ptr,
  <vscale x 16 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv16i8_nxv16i8(<vscale x 16 x i8> %0, ptr %1, <vscale x 16 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv16i8(
    <vscale x 16 x i8> %0,
    ptr %1,
    <vscale x 16 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv32i8(
  <vscale x 32 x i8>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv32i8_nxv32i8(<vscale x 32 x i8> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv32i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv32i8(
    <vscale x 32 x i8> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv32i8(
  <vscale x 32 x i8>,
  ptr,
  <vscale x 32 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv32i8_nxv32i8(<vscale x 32 x i8> %0, ptr %1, <vscale x 32 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv32i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv32i8(
    <vscale x 32 x i8> %0,
    ptr %1,
    <vscale x 32 x i1> %2,
    iXLen %3)

  ret void
}

declare void @llvm.riscv.vse.nxv64i8(
  <vscale x 64 x i8>,
  ptr,
  iXLen);

define void @intrinsic_vse_v_nxv64i8_nxv64i8(<vscale x 64 x i8> %0, ptr %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vse_v_nxv64i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.nxv64i8(
    <vscale x 64 x i8> %0,
    ptr %1,
    iXLen %2)

  ret void
}

declare void @llvm.riscv.vse.mask.nxv64i8(
  <vscale x 64 x i8>,
  ptr,
  <vscale x 64 x i1>,
  iXLen);

define void @intrinsic_vse_mask_v_nxv64i8_nxv64i8(<vscale x 64 x i8> %0, ptr %1, <vscale x 64 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vse_mask_v_nxv64i8_nxv64i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0), v0.t
; CHECK-NEXT:    ret
entry:
  call void @llvm.riscv.vse.mask.nxv64i8(
    <vscale x 64 x i8> %0,
    ptr %1,
    <vscale x 64 x i1> %2,
    iXLen %3)

  ret void
}
