# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network vpn-connection ipsec-policy add",
)
class Add(AAZCommand):
    """Add a VPN connection IPSec policy.

    Set all IPsec policies of a VPN connection. If you want to set any IPsec policy, you must
            set them all.

    :example: Add specified IPsec policies to a connection instead of relying on defaults.
        az network vpn-connection ipsec-policy add -g MyResourceGroup --connection-name MyConnection --dh-group DHGroup14 --ike-encryption AES256 --ike-integrity SHA384 --ipsec-encryption DES3 --ipsec-integrity GCMAES256 --pfs-group PFS2048 --sa-lifetime 27000 --sa-max-size 102400000
    """

    _aaz_info = {
        "version": "2018-11-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/connections/{}", "2018-11-01", "properties.ipsecPolicies[]"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        self.SubresourceSelector(ctx=self.ctx, name="subresource")
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.connection_name = AAZStrArg(
            options=["--connection-name"],
            help="Connection name.",
            required=True,
        )
        _args_schema.ipsec_policy_index = AAZIntArg(
            options=["--ipsec-policy-index"],
        )

        # define Arg Group "IKE Phase 1"

        _args_schema = cls._args_schema
        _args_schema.dh_group = AAZStrArg(
            options=["--dh-group"],
            arg_group="IKE Phase 1",
            help="The DH Groups used for initial SA.",
            required=True,
            enum={"DHGroup1": "DHGroup1", "DHGroup14": "DHGroup14", "DHGroup2": "DHGroup2", "DHGroup2048": "DHGroup2048", "DHGroup24": "DHGroup24", "ECP256": "ECP256", "ECP384": "ECP384", "None": "None"},
        )
        _args_schema.ipsec_encryption = AAZStrArg(
            options=["--ipsec-encryption"],
            arg_group="IKE Phase 1",
            help="The IPSec encryption algorithm.",
            required=True,
            enum={"AES128": "AES128", "AES192": "AES192", "AES256": "AES256", "DES": "DES", "DES3": "DES3", "GCMAES128": "GCMAES128", "GCMAES192": "GCMAES192", "GCMAES256": "GCMAES256", "None": "None"},
        )
        _args_schema.ipsec_integrity = AAZStrArg(
            options=["--ipsec-integrity"],
            arg_group="IKE Phase 1",
            help="The IPSec integrity algorithm.",
            required=True,
            enum={"GCMAES128": "GCMAES128", "GCMAES192": "GCMAES192", "GCMAES256": "GCMAES256", "MD5": "MD5", "SHA1": "SHA1", "SHA256": "SHA256"},
        )

        # define Arg Group "IKE Phase 2"

        _args_schema = cls._args_schema
        _args_schema.ike_encryption = AAZStrArg(
            options=["--ike-encryption"],
            arg_group="IKE Phase 2",
            help="The IKE encryption algorithm.",
            required=True,
            enum={"AES128": "AES128", "AES192": "AES192", "AES256": "AES256", "DES": "DES", "DES3": "DES3", "GCMAES128": "GCMAES128", "GCMAES256": "GCMAES256"},
        )
        _args_schema.ike_integrity = AAZStrArg(
            options=["--ike-integrity"],
            arg_group="IKE Phase 2",
            help="The IKE integrity algorithm.",
            required=True,
            enum={"GCMAES128": "GCMAES128", "GCMAES256": "GCMAES256", "MD5": "MD5", "SHA1": "SHA1", "SHA256": "SHA256", "SHA384": "SHA384"},
        )
        _args_schema.pfs_group = AAZStrArg(
            options=["--pfs-group"],
            arg_group="IKE Phase 2",
            help="The Pfs Groups used for new child SA.",
            required=True,
            enum={"ECP256": "ECP256", "ECP384": "ECP384", "None": "None", "PFS1": "PFS1", "PFS14": "PFS14", "PFS2": "PFS2", "PFS2048": "PFS2048", "PFS24": "PFS24", "PFSMM": "PFSMM"},
        )

        # define Arg Group "Security Association"

        _args_schema = cls._args_schema
        _args_schema.sa_max_size = AAZIntArg(
            options=["--sa-max-size"],
            arg_group="Security Association",
            help="The payload size in KB for P2S client.",
            required=True,
        )
        _args_schema.sa_lifetime = AAZIntArg(
            options=["--sa-lifetime"],
            arg_group="Security Association",
            help="The lifetime in seconds for P2S client.",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.VirtualNetworkGatewayConnectionsGet(ctx=self.ctx)()
        self.pre_instance_create()
        self.InstanceCreateByJson(ctx=self.ctx)()
        self.post_instance_create(self.ctx.selectors.subresource.required())
        yield self.VirtualNetworkGatewayConnectionsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_create(self):
        pass

    @register_callback
    def post_instance_create(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.selectors.subresource.required(), client_flatten=True)
        return result

    class SubresourceSelector(AAZJsonSelector):

        def _get(self):
            result = self.ctx.vars.instance
            result = result.properties.ipsecPolicies
            filters = enumerate(result)
            filters = filter(
                lambda e: e[0] == self.ctx.args.ipsec_policy_index,
                filters
            )
            idx = next(filters)[0]
            return result[idx]

        def _set(self, value):
            result = self.ctx.vars.instance
            result = result.properties.ipsecPolicies
            filters = enumerate(result)
            filters = filter(
                lambda e: e[0] == self.ctx.args.ipsec_policy_index,
                filters
            )
            idx = next(filters, [len(result)])[0]
            self.ctx.args.ipsec_policy_index = idx
            result[idx] = value
            return

    class VirtualNetworkGatewayConnectionsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "virtualNetworkGatewayConnectionName", self.ctx.args.connection_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2018-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _AddHelper._build_schema_virtual_network_gateway_connection_read(cls._schema_on_200)

            return cls._schema_on_200

    class VirtualNetworkGatewayConnectionsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "virtualNetworkGatewayConnectionName", self.ctx.args.connection_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2018-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _AddHelper._build_schema_virtual_network_gateway_connection_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceCreateByJson(AAZJsonInstanceCreateOperation):

        def __call__(self, *args, **kwargs):
            self.ctx.selectors.subresource.set(self._create_instance())

        def _create_instance(self):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType
            )
            _builder.set_prop("dhGroup", AAZStrType, ".dh_group", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("ikeEncryption", AAZStrType, ".ike_encryption", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("ikeIntegrity", AAZStrType, ".ike_integrity", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("ipsecEncryption", AAZStrType, ".ipsec_encryption", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("ipsecIntegrity", AAZStrType, ".ipsec_integrity", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("pfsGroup", AAZStrType, ".pfs_group", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("saDataSizeKilobytes", AAZIntType, ".sa_max_size", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("saLifeTimeSeconds", AAZIntType, ".sa_lifetime", typ_kwargs={"flags": {"required": True}})

            return _instance_value


class _AddHelper:
    """Helper class for Add"""

    _schema_address_space_read = None

    @classmethod
    def _build_schema_address_space_read(cls, _schema):
        if cls._schema_address_space_read is not None:
            _schema.address_prefixes = cls._schema_address_space_read.address_prefixes
            return

        cls._schema_address_space_read = _schema_address_space_read = AAZObjectType()

        address_space_read = _schema_address_space_read
        address_space_read.address_prefixes = AAZListType(
            serialized_name="addressPrefixes",
        )

        address_prefixes = _schema_address_space_read.address_prefixes
        address_prefixes.Element = AAZStrType()

        _schema.address_prefixes = cls._schema_address_space_read.address_prefixes

    _schema_bgp_settings_read = None

    @classmethod
    def _build_schema_bgp_settings_read(cls, _schema):
        if cls._schema_bgp_settings_read is not None:
            _schema.asn = cls._schema_bgp_settings_read.asn
            _schema.bgp_peering_address = cls._schema_bgp_settings_read.bgp_peering_address
            _schema.peer_weight = cls._schema_bgp_settings_read.peer_weight
            return

        cls._schema_bgp_settings_read = _schema_bgp_settings_read = AAZObjectType()

        bgp_settings_read = _schema_bgp_settings_read
        bgp_settings_read.asn = AAZIntType()
        bgp_settings_read.bgp_peering_address = AAZStrType(
            serialized_name="bgpPeeringAddress",
        )
        bgp_settings_read.peer_weight = AAZIntType(
            serialized_name="peerWeight",
        )

        _schema.asn = cls._schema_bgp_settings_read.asn
        _schema.bgp_peering_address = cls._schema_bgp_settings_read.bgp_peering_address
        _schema.peer_weight = cls._schema_bgp_settings_read.peer_weight

    _schema_ipsec_policy_read = None

    @classmethod
    def _build_schema_ipsec_policy_read(cls, _schema):
        if cls._schema_ipsec_policy_read is not None:
            _schema.dh_group = cls._schema_ipsec_policy_read.dh_group
            _schema.ike_encryption = cls._schema_ipsec_policy_read.ike_encryption
            _schema.ike_integrity = cls._schema_ipsec_policy_read.ike_integrity
            _schema.ipsec_encryption = cls._schema_ipsec_policy_read.ipsec_encryption
            _schema.ipsec_integrity = cls._schema_ipsec_policy_read.ipsec_integrity
            _schema.pfs_group = cls._schema_ipsec_policy_read.pfs_group
            _schema.sa_data_size_kilobytes = cls._schema_ipsec_policy_read.sa_data_size_kilobytes
            _schema.sa_life_time_seconds = cls._schema_ipsec_policy_read.sa_life_time_seconds
            return

        cls._schema_ipsec_policy_read = _schema_ipsec_policy_read = AAZObjectType()

        ipsec_policy_read = _schema_ipsec_policy_read
        ipsec_policy_read.dh_group = AAZStrType(
            serialized_name="dhGroup",
            flags={"required": True},
        )
        ipsec_policy_read.ike_encryption = AAZStrType(
            serialized_name="ikeEncryption",
            flags={"required": True},
        )
        ipsec_policy_read.ike_integrity = AAZStrType(
            serialized_name="ikeIntegrity",
            flags={"required": True},
        )
        ipsec_policy_read.ipsec_encryption = AAZStrType(
            serialized_name="ipsecEncryption",
            flags={"required": True},
        )
        ipsec_policy_read.ipsec_integrity = AAZStrType(
            serialized_name="ipsecIntegrity",
            flags={"required": True},
        )
        ipsec_policy_read.pfs_group = AAZStrType(
            serialized_name="pfsGroup",
            flags={"required": True},
        )
        ipsec_policy_read.sa_data_size_kilobytes = AAZIntType(
            serialized_name="saDataSizeKilobytes",
            flags={"required": True},
        )
        ipsec_policy_read.sa_life_time_seconds = AAZIntType(
            serialized_name="saLifeTimeSeconds",
            flags={"required": True},
        )

        _schema.dh_group = cls._schema_ipsec_policy_read.dh_group
        _schema.ike_encryption = cls._schema_ipsec_policy_read.ike_encryption
        _schema.ike_integrity = cls._schema_ipsec_policy_read.ike_integrity
        _schema.ipsec_encryption = cls._schema_ipsec_policy_read.ipsec_encryption
        _schema.ipsec_integrity = cls._schema_ipsec_policy_read.ipsec_integrity
        _schema.pfs_group = cls._schema_ipsec_policy_read.pfs_group
        _schema.sa_data_size_kilobytes = cls._schema_ipsec_policy_read.sa_data_size_kilobytes
        _schema.sa_life_time_seconds = cls._schema_ipsec_policy_read.sa_life_time_seconds

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id

    _schema_virtual_network_gateway_connection_read = None

    @classmethod
    def _build_schema_virtual_network_gateway_connection_read(cls, _schema):
        if cls._schema_virtual_network_gateway_connection_read is not None:
            _schema.etag = cls._schema_virtual_network_gateway_connection_read.etag
            _schema.id = cls._schema_virtual_network_gateway_connection_read.id
            _schema.location = cls._schema_virtual_network_gateway_connection_read.location
            _schema.name = cls._schema_virtual_network_gateway_connection_read.name
            _schema.properties = cls._schema_virtual_network_gateway_connection_read.properties
            _schema.tags = cls._schema_virtual_network_gateway_connection_read.tags
            _schema.type = cls._schema_virtual_network_gateway_connection_read.type
            return

        cls._schema_virtual_network_gateway_connection_read = _schema_virtual_network_gateway_connection_read = AAZObjectType()

        virtual_network_gateway_connection_read = _schema_virtual_network_gateway_connection_read
        virtual_network_gateway_connection_read.etag = AAZStrType()
        virtual_network_gateway_connection_read.id = AAZStrType()
        virtual_network_gateway_connection_read.location = AAZStrType()
        virtual_network_gateway_connection_read.name = AAZStrType(
            flags={"read_only": True},
        )
        virtual_network_gateway_connection_read.properties = AAZObjectType(
            flags={"required": True, "client_flatten": True},
        )
        virtual_network_gateway_connection_read.tags = AAZDictType()
        virtual_network_gateway_connection_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_virtual_network_gateway_connection_read.properties
        properties.authorization_key = AAZStrType(
            serialized_name="authorizationKey",
        )
        properties.connection_protocol = AAZStrType(
            serialized_name="connectionProtocol",
        )
        properties.connection_status = AAZStrType(
            serialized_name="connectionStatus",
            flags={"read_only": True},
        )
        properties.connection_type = AAZStrType(
            serialized_name="connectionType",
            flags={"required": True},
        )
        properties.egress_bytes_transferred = AAZIntType(
            serialized_name="egressBytesTransferred",
            flags={"read_only": True},
        )
        properties.enable_bgp = AAZBoolType(
            serialized_name="enableBgp",
        )
        properties.express_route_gateway_bypass = AAZBoolType(
            serialized_name="expressRouteGatewayBypass",
        )
        properties.ingress_bytes_transferred = AAZIntType(
            serialized_name="ingressBytesTransferred",
            flags={"read_only": True},
        )
        properties.ipsec_policies = AAZListType(
            serialized_name="ipsecPolicies",
        )
        properties.local_network_gateway2 = AAZObjectType(
            serialized_name="localNetworkGateway2",
        )
        properties.peer = AAZObjectType()
        cls._build_schema_sub_resource_read(properties.peer)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.routing_weight = AAZIntType(
            serialized_name="routingWeight",
        )
        properties.shared_key = AAZStrType(
            serialized_name="sharedKey",
        )
        properties.tunnel_connection_status = AAZListType(
            serialized_name="tunnelConnectionStatus",
            flags={"read_only": True},
        )
        properties.use_policy_based_traffic_selectors = AAZBoolType(
            serialized_name="usePolicyBasedTrafficSelectors",
        )
        properties.virtual_network_gateway1 = AAZObjectType(
            serialized_name="virtualNetworkGateway1",
            flags={"required": True},
        )
        cls._build_schema_virtual_network_gateway_read(properties.virtual_network_gateway1)
        properties.virtual_network_gateway2 = AAZObjectType(
            serialized_name="virtualNetworkGateway2",
        )
        cls._build_schema_virtual_network_gateway_read(properties.virtual_network_gateway2)

        ipsec_policies = _schema_virtual_network_gateway_connection_read.properties.ipsec_policies
        ipsec_policies.Element = AAZObjectType()
        cls._build_schema_ipsec_policy_read(ipsec_policies.Element)

        local_network_gateway2 = _schema_virtual_network_gateway_connection_read.properties.local_network_gateway2
        local_network_gateway2.etag = AAZStrType()
        local_network_gateway2.id = AAZStrType()
        local_network_gateway2.location = AAZStrType()
        local_network_gateway2.name = AAZStrType(
            flags={"read_only": True},
        )
        local_network_gateway2.properties = AAZObjectType(
            flags={"required": True, "client_flatten": True},
        )
        local_network_gateway2.tags = AAZDictType()
        local_network_gateway2.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_virtual_network_gateway_connection_read.properties.local_network_gateway2.properties
        properties.bgp_settings = AAZObjectType(
            serialized_name="bgpSettings",
        )
        cls._build_schema_bgp_settings_read(properties.bgp_settings)
        properties.gateway_ip_address = AAZStrType(
            serialized_name="gatewayIpAddress",
        )
        properties.local_network_address_space = AAZObjectType(
            serialized_name="localNetworkAddressSpace",
        )
        cls._build_schema_address_space_read(properties.local_network_address_space)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )

        tags = _schema_virtual_network_gateway_connection_read.properties.local_network_gateway2.tags
        tags.Element = AAZStrType()

        tunnel_connection_status = _schema_virtual_network_gateway_connection_read.properties.tunnel_connection_status
        tunnel_connection_status.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_connection_read.properties.tunnel_connection_status.Element
        _element.connection_status = AAZStrType(
            serialized_name="connectionStatus",
            flags={"read_only": True},
        )
        _element.egress_bytes_transferred = AAZIntType(
            serialized_name="egressBytesTransferred",
            flags={"read_only": True},
        )
        _element.ingress_bytes_transferred = AAZIntType(
            serialized_name="ingressBytesTransferred",
            flags={"read_only": True},
        )
        _element.last_connection_established_utc_time = AAZStrType(
            serialized_name="lastConnectionEstablishedUtcTime",
            flags={"read_only": True},
        )
        _element.tunnel = AAZStrType(
            flags={"read_only": True},
        )

        tags = _schema_virtual_network_gateway_connection_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_virtual_network_gateway_connection_read.etag
        _schema.id = cls._schema_virtual_network_gateway_connection_read.id
        _schema.location = cls._schema_virtual_network_gateway_connection_read.location
        _schema.name = cls._schema_virtual_network_gateway_connection_read.name
        _schema.properties = cls._schema_virtual_network_gateway_connection_read.properties
        _schema.tags = cls._schema_virtual_network_gateway_connection_read.tags
        _schema.type = cls._schema_virtual_network_gateway_connection_read.type

    _schema_virtual_network_gateway_read = None

    @classmethod
    def _build_schema_virtual_network_gateway_read(cls, _schema):
        if cls._schema_virtual_network_gateway_read is not None:
            _schema.etag = cls._schema_virtual_network_gateway_read.etag
            _schema.id = cls._schema_virtual_network_gateway_read.id
            _schema.location = cls._schema_virtual_network_gateway_read.location
            _schema.name = cls._schema_virtual_network_gateway_read.name
            _schema.properties = cls._schema_virtual_network_gateway_read.properties
            _schema.tags = cls._schema_virtual_network_gateway_read.tags
            _schema.type = cls._schema_virtual_network_gateway_read.type
            return

        cls._schema_virtual_network_gateway_read = _schema_virtual_network_gateway_read = AAZObjectType()

        virtual_network_gateway_read = _schema_virtual_network_gateway_read
        virtual_network_gateway_read.etag = AAZStrType()
        virtual_network_gateway_read.id = AAZStrType()
        virtual_network_gateway_read.location = AAZStrType()
        virtual_network_gateway_read.name = AAZStrType(
            flags={"read_only": True},
        )
        virtual_network_gateway_read.properties = AAZObjectType(
            flags={"required": True, "client_flatten": True},
        )
        virtual_network_gateway_read.tags = AAZDictType()
        virtual_network_gateway_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_virtual_network_gateway_read.properties
        properties.active_active = AAZBoolType(
            serialized_name="activeActive",
        )
        properties.bgp_settings = AAZObjectType(
            serialized_name="bgpSettings",
        )
        cls._build_schema_bgp_settings_read(properties.bgp_settings)
        properties.enable_bgp = AAZBoolType(
            serialized_name="enableBgp",
        )
        properties.gateway_default_site = AAZObjectType(
            serialized_name="gatewayDefaultSite",
        )
        cls._build_schema_sub_resource_read(properties.gateway_default_site)
        properties.gateway_type = AAZStrType(
            serialized_name="gatewayType",
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.sku = AAZObjectType()
        properties.vpn_client_configuration = AAZObjectType(
            serialized_name="vpnClientConfiguration",
        )
        properties.vpn_type = AAZStrType(
            serialized_name="vpnType",
        )

        ip_configurations = _schema_virtual_network_gateway_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_read.properties.ip_configurations.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_virtual_network_gateway_read.properties.ip_configurations.Element.properties
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_sub_resource_read(properties.subnet)

        sku = _schema_virtual_network_gateway_read.properties.sku
        sku.capacity = AAZIntType()
        sku.name = AAZStrType()
        sku.tier = AAZStrType()

        vpn_client_configuration = _schema_virtual_network_gateway_read.properties.vpn_client_configuration
        vpn_client_configuration.radius_server_address = AAZStrType(
            serialized_name="radiusServerAddress",
        )
        vpn_client_configuration.radius_server_secret = AAZStrType(
            serialized_name="radiusServerSecret",
        )
        vpn_client_configuration.vpn_client_address_pool = AAZObjectType(
            serialized_name="vpnClientAddressPool",
        )
        cls._build_schema_address_space_read(vpn_client_configuration.vpn_client_address_pool)
        vpn_client_configuration.vpn_client_ipsec_policies = AAZListType(
            serialized_name="vpnClientIpsecPolicies",
        )
        vpn_client_configuration.vpn_client_protocols = AAZListType(
            serialized_name="vpnClientProtocols",
        )
        vpn_client_configuration.vpn_client_revoked_certificates = AAZListType(
            serialized_name="vpnClientRevokedCertificates",
        )
        vpn_client_configuration.vpn_client_root_certificates = AAZListType(
            serialized_name="vpnClientRootCertificates",
        )

        vpn_client_ipsec_policies = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_ipsec_policies
        vpn_client_ipsec_policies.Element = AAZObjectType()
        cls._build_schema_ipsec_policy_read(vpn_client_ipsec_policies.Element)

        vpn_client_protocols = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_protocols
        vpn_client_protocols.Element = AAZStrType()

        vpn_client_revoked_certificates = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_revoked_certificates
        vpn_client_revoked_certificates.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_revoked_certificates.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_revoked_certificates.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.thumbprint = AAZStrType()

        vpn_client_root_certificates = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_root_certificates
        vpn_client_root_certificates.Element = AAZObjectType()

        _element = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_root_certificates.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"required": True, "client_flatten": True},
        )

        properties = _schema_virtual_network_gateway_read.properties.vpn_client_configuration.vpn_client_root_certificates.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.public_cert_data = AAZStrType(
            serialized_name="publicCertData",
            flags={"required": True},
        )

        tags = _schema_virtual_network_gateway_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_virtual_network_gateway_read.etag
        _schema.id = cls._schema_virtual_network_gateway_read.id
        _schema.location = cls._schema_virtual_network_gateway_read.location
        _schema.name = cls._schema_virtual_network_gateway_read.name
        _schema.properties = cls._schema_virtual_network_gateway_read.properties
        _schema.tags = cls._schema_virtual_network_gateway_read.tags
        _schema.type = cls._schema_virtual_network_gateway_read.type


__all__ = ["Add"]
