## RabbitMQ 3.6.8

RabbitMQ `3.6.8` is a maintenance release that restores Erlang/OTP R16B03 and 17.x compatibility
that was unintentionally affected in [3.6.7](https://github.com/rabbitmq/rabbitmq-server/releases/tag/rabbitmq_v3_6_7) by producing that release on a significantly newer Erlang/OTP version.

### Upgrades and Compatibility

See the ["Upgrading clusters" section of the documentation](https://www.rabbitmq.com/clustering.html#upgrading) for general documentation on upgrades.

This release has no incompatibilities with 3.6.7. See [3.6.7 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/rabbitmq_v3_6_7) upgrade and compatibility nodes if upgrading from an earlier release.

### Server

#### Bug Fixes

 * Erlang/OTP R16B03 and 17.x are supported again by producing this release on R16B03.
   Note that [some configurations or community plugins](https://www.rabbitmq.com/which-erlang.html) may require a later version.
   We recommend all users to upgrade to a 19.x series release if possible. See [Debian](https://www.rabbitmq.com/install-debian.html) and [RPM installation](https://www.rabbitmq.com/install-rpm.html) guides for some Erlang/OTP installation options.

   GitHub issues: [rabbitmq-server#1148](https://github.com/rabbitmq/rabbitmq-server/issues/1148), [rabbitmq-server#1149](https://github.com/rabbitmq/rabbitmq-server/issues/1149)


### Management Plugin

#### Bug Fixes

 * Certain user permission violations were resulting in a 500 response and scary log entries.

   GitHub issue: [rabbitmq-management#360](https://github.com/rabbitmq/rabbitmq-management/issues/360)


### Management Agent Plugin

#### Bug Fixes

 * Single atom proplist values no longer break JSON serialisation for endpoints such as `GET /api/overview`.
 
   GitHub issue: [rabbitmq-management-agent#34](https://github.com/rabbitmq/rabbitmq-management-agent/issues/34)


### Web STOMP Plugin

#### Bug Fixes

 * Web STOMP now accepts the same TCP listener options as core RabbitMQ and other plugins.
 
   GitHub issue: [rabbitmq-web-stomp#69](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/69)


## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All configuration and persistent message data are retained. When upgrading using definitions export/import from versions earlier than 3.6.0, see http://rabbitmq.com/passwords.html.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ documentation](https://www.rabbitmq.com/clustering.html#upgrading).

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.6.8.tar.gz`.
