if(WIN32)
    set(CPACK_GENERATOR "NSIS")
    set(CPACK_NSIS_URL_INFO_ABOUT "https://www.hawktracer.org")
    set(CPACK_NSIS_HELP_LINK "https://www.hawktracer.org")
    set(CPACK_NSIS_CONTACT "Marcin Kolny <marcin.kolny@gmail>")
    set(CPACK_NSIS_MODIFY_PATH ON)
    set(CPACK_NSIS_ENABLE_UNINSTALL_BEFORE_INSTALL ON)
else()
    set(CPACK_GENERATOR "TGZ")
endif()

set(CPACK_PACKAGE_VENDOR "Amazon Video")
set(CPACK_PACKAGE_CONTACT "Marcin Kolny <marcin.kolny@gmail.com>")
set(CPACK_PACKAGE_VERSION_MAJOR "${PROJECT_VERSION_MAJOR}")
set(CPACK_PACKAGE_VERSION_MINOR "${PROJECT_VERSION_MINOR}")
set(CPACK_PACKAGE_VERSION_PATCH "${PROJECT_VERSION_PATCH}")
set(CPACK_RESOURCE_FILE_LICENSE "${CMAKE_SOURCE_DIR}/LICENSE")
set(CPACK_RESOURCE_FILE_README "${CMAKE_SOURCE_DIR}/README.md")
set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "Highly portable, low-overhead, configurable profiling tool for getting performance metrics from low-end devices.")
set(CPACK_PACKAGE_EXECUTABLES "hawktracer-converter;HawkTracer Client")

set(CPACK_COMPONENT_APPLICATIONS_DISPLAY_NAME "HawkTracer viewer tools")
set(CPACK_COMPONENT_APPLICATIONS_DESCRIPTION "Profiler visualization tools")
set(CPACK_COMPONENT_CLIENTDEVELOPMENT_DISPLAY_NAME "Profiler libraries and headers")
set(CPACK_COMPONENT_CLIENTDEVELOPMENT_DESCRIPTION "Development files needed to develop new client utilities")
set(CPACK_COMPONENT_COREDEVELOPMENT_DISPLAY_NAME "HawkTracer client libraries and headers")
set(CPACK_COMPONENT_COREDEVELOPMENT_DESCRIPTION "Core development libraries and headers needed to profile an application")
set(CPACK_COMPONENT_PKGCONFIG_DISPLAY_NAME "pkg-config files")
set(CPACK_COMPONENT_CMAKE_DISPLAY_NAME "CMake files")

set(CPACK_COMPONENT_GROUP_DEVELOPMENT_DESCRIPTION "All the tools needed to use HawkTracer in the software.")
set(CPACK_COMPONENT_CLIENTDEVELOPMENT_GROUP "Development")
set(CPACK_COMPONENT_COREDEVELOPMENT_GROUP "Development")
set(CPACK_COMPONENT_PKGCONFIG_GROUP "Development")
set(CPACK_COMPONENT_CMAKE_GROUP "Development")

include(CPack)
