// Script from security/manager/tools/crtshToIdentifyingStruct/crtshToIdentifyingStruct.py
// Invocation: crtshToIdentifyingStruct.py -spki -listname RootAppleAndGoogleSPKIs 142951186 23635000 5250464 12716200 19602712 19602724 21760447 19602706 19602741 8656329 8568700 281399768 281399766

// /C=US/O=Google Inc/CN=Google Internet Authority G2
// SHA256 Fingerprint: 9B:75:9D:41:E3:DE:30:F9:D2:F9:02:02:7D:79:2B:65
//                     D9:50:A9:8B:BB:6D:6D:56:BE:7F:25:28:45:3B:F8:E9
// https://crt.sh/?id=142951186 (crt.sh ID=142951186)
//
// and
//
// /C=US/O=Google Inc/CN=Google Internet Authority G2
// SHA256 Fingerprint: 9F:63:04:26:DF:1D:8A:BF:D8:0A:CE:98:87:1B:A8:33
//                     AB:97:42:CB:34:83:8D:E2:B5:28:5E:D5:4C:0C:7D:CC
// https://crt.sh/?id=23635000 (crt.sh ID=23635000)
static const uint8_t CAGoogleInternetAuthorityG2SPKI[294] = {
  0x30, 0x82, 0x01, 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7,
  0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0F, 0x00, 0x30, 0x82,
  0x01, 0x0A, 0x02, 0x82, 0x01, 0x01, 0x00, 0x9C, 0x2A, 0x04, 0x77, 0x5C, 0xD8,
  0x50, 0x91, 0x3A, 0x06, 0xA3, 0x82, 0xE0, 0xD8, 0x50, 0x48, 0xBC, 0x89, 0x3F,
  0xF1, 0x19, 0x70, 0x1A, 0x88, 0x46, 0x7E, 0xE0, 0x8F, 0xC5, 0xF1, 0x89, 0xCE,
  0x21, 0xEE, 0x5A, 0xFE, 0x61, 0x0D, 0xB7, 0x32, 0x44, 0x89, 0xA0, 0x74, 0x0B,
  0x53, 0x4F, 0x55, 0xA4, 0xCE, 0x82, 0x62, 0x95, 0xEE, 0xEB, 0x59, 0x5F, 0xC6,
  0xE1, 0x05, 0x80, 0x12, 0xC4, 0x5E, 0x94, 0x3F, 0xBC, 0x5B, 0x48, 0x38, 0xF4,
  0x53, 0xF7, 0x24, 0xE6, 0xFB, 0x91, 0xE9, 0x15, 0xC4, 0xCF, 0xF4, 0x53, 0x0D,
  0xF4, 0x4A, 0xFC, 0x9F, 0x54, 0xDE, 0x7D, 0xBE, 0xA0, 0x6B, 0x6F, 0x87, 0xC0,
  0xD0, 0x50, 0x1F, 0x28, 0x30, 0x03, 0x40, 0xDA, 0x08, 0x73, 0x51, 0x6C, 0x7F,
  0xFF, 0x3A, 0x3C, 0xA7, 0x37, 0x06, 0x8E, 0xBD, 0x4B, 0x11, 0x04, 0xEB, 0x7D,
  0x24, 0xDE, 0xE6, 0xF9, 0xFC, 0x31, 0x71, 0xFB, 0x94, 0xD5, 0x60, 0xF3, 0x2E,
  0x4A, 0xAF, 0x42, 0xD2, 0xCB, 0xEA, 0xC4, 0x6A, 0x1A, 0xB2, 0xCC, 0x53, 0xDD,
  0x15, 0x4B, 0x8B, 0x1F, 0xC8, 0x19, 0x61, 0x1F, 0xCD, 0x9D, 0xA8, 0x3E, 0x63,
  0x2B, 0x84, 0x35, 0x69, 0x65, 0x84, 0xC8, 0x19, 0xC5, 0x46, 0x22, 0xF8, 0x53,
  0x95, 0xBE, 0xE3, 0x80, 0x4A, 0x10, 0xC6, 0x2A, 0xEC, 0xBA, 0x97, 0x20, 0x11,
  0xC7, 0x39, 0x99, 0x10, 0x04, 0xA0, 0xF0, 0x61, 0x7A, 0x95, 0x25, 0x8C, 0x4E,
  0x52, 0x75, 0xE2, 0xB6, 0xED, 0x08, 0xCA, 0x14, 0xFC, 0xCE, 0x22, 0x6A, 0xB3,
  0x4E, 0xCF, 0x46, 0x03, 0x97, 0x97, 0x03, 0x7E, 0xC0, 0xB1, 0xDE, 0x7B, 0xAF,
  0x45, 0x33, 0xCF, 0xBA, 0x3E, 0x71, 0xB7, 0xDE, 0xF4, 0x25, 0x25, 0xC2, 0x0D,
  0x35, 0x89, 0x9D, 0x9D, 0xFB, 0x0E, 0x11, 0x79, 0x89, 0x1E, 0x37, 0xC5, 0xAF,
  0x8E, 0x72, 0x69, 0x02, 0x03, 0x01, 0x00, 0x01,
};

// /CN=Apple IST CA 2 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: AC:2B:92:2E:CF:D5:E0:17:11:77:2F:EA:8E:D3:72:DE
//                     9D:1E:22:45:FC:E3:F5:7A:9C:DB:EC:77:29:6A:42:4B
// https://crt.sh/?id=5250464 (crt.sh ID=5250464)
static const uint8_t CAAppleISTCA2G1SPKI[294] = {
  0x30, 0x82, 0x01, 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7,
  0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0F, 0x00, 0x30, 0x82,
  0x01, 0x0A, 0x02, 0x82, 0x01, 0x01, 0x00, 0xD0, 0x93, 0xA1, 0x1D, 0x47, 0x43,
  0x20, 0x16, 0xB2, 0x0B, 0x6B, 0xEB, 0xC3, 0xD5, 0xB4, 0xE8, 0xC7, 0x98, 0xCD,
  0xF3, 0xDE, 0xBF, 0xE8, 0x4D, 0xE9, 0xE3, 0x36, 0x80, 0x07, 0xFC, 0x45, 0x1B,
  0x6A, 0x7C, 0x45, 0x86, 0xAE, 0x56, 0xD3, 0xA4, 0x09, 0x7F, 0x61, 0x0D, 0x6B,
  0x5D, 0x7E, 0x52, 0x6B, 0x7D, 0xB4, 0xC8, 0x39, 0xC4, 0xF4, 0x67, 0x3A, 0xF7,
  0x83, 0xCE, 0x19, 0x6F, 0x86, 0x2F, 0x7E, 0x45, 0x7E, 0x47, 0x1C, 0x67, 0x52,
  0xCA, 0x95, 0x05, 0x5D, 0xE2, 0x36, 0x51, 0x85, 0xC0, 0xD4, 0x67, 0x80, 0x35,
  0x6F, 0x15, 0xDD, 0x3E, 0xFD, 0x1D, 0xD2, 0xFD, 0x8F, 0x34, 0x50, 0xD8, 0xEC,
  0x76, 0x2A, 0xBE, 0xE3, 0xD3, 0xDA, 0xE4, 0xFD, 0xC8, 0xEB, 0x28, 0x02, 0x96,
  0x11, 0x97, 0x17, 0x61, 0x1C, 0xE9, 0xC4, 0x59, 0x3B, 0x42, 0xDC, 0x32, 0xD1,
  0x09, 0x1D, 0xDA, 0xA6, 0xD1, 0x43, 0x86, 0xFF, 0x5E, 0xB2, 0xBC, 0x8C, 0xCF,
  0x66, 0xDB, 0x01, 0x8B, 0x02, 0xAE, 0x94, 0x48, 0xF3, 0x38, 0x8F, 0xFD, 0xEA,
  0x32, 0xA8, 0x08, 0xEC, 0x86, 0x97, 0x51, 0x94, 0x24, 0x3E, 0x49, 0x49, 0x96,
  0x53, 0xE8, 0x79, 0xA1, 0x40, 0x81, 0xE9, 0x05, 0xBB, 0x93, 0x95, 0x51, 0xFC,
  0xE3, 0xFD, 0x7C, 0x11, 0x4B, 0xF7, 0x9E, 0x08, 0xB3, 0x15, 0x49, 0x15, 0x07,
  0xF9, 0xD1, 0x37, 0xA0, 0x9B, 0x4B, 0x32, 0xF6, 0xB5, 0xC4, 0xDC, 0x6A, 0xD1,
  0xFC, 0x0A, 0xED, 0xF6, 0xE0, 0xC5, 0x29, 0xA0, 0xA8, 0x8B, 0x71, 0xFE, 0x0D,
  0x92, 0xBC, 0xFE, 0x54, 0x70, 0x18, 0x0A, 0x6D, 0xC7, 0xED, 0x0C, 0xFB, 0xC9,
  0x2D, 0x06, 0xC3, 0x8C, 0x85, 0xFC, 0xCB, 0x86, 0x5C, 0xD6, 0x36, 0x8E, 0x12,
  0x8B, 0x09, 0x7F, 0xFB, 0x19, 0x1A, 0x38, 0xD5, 0xF0, 0x94, 0x30, 0x7A, 0x0F,
  0xA6, 0x8C, 0xF3, 0x02, 0x03, 0x01, 0x00, 0x01,
};

// /CN=Apple IST CA 5 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: 3D:B7:6D:1D:D7:D3:A7:59:DC:CC:3F:8F:A7:F6:86:75
//                     C0:80:CB:09:5E:48:81:06:3A:6B:85:0F:DD:68:B8:BC
// https://crt.sh/?id=12716200 (crt.sh ID=12716200)
static const uint8_t CAAppleISTCA5G1SPKI[294] = {
  0x30, 0x82, 0x01, 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7,
  0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0F, 0x00, 0x30, 0x82,
  0x01, 0x0A, 0x02, 0x82, 0x01, 0x01, 0x00, 0xF0, 0x8A, 0x08, 0xBA, 0x2C, 0x13,
  0x5C, 0x5A, 0xF1, 0x98, 0xFD, 0x31, 0x59, 0x66, 0xC2, 0x56, 0x7A, 0x7E, 0x40,
  0x2A, 0x4C, 0x94, 0xC9, 0x68, 0xB6, 0xB3, 0x23, 0xBD, 0x60, 0x1B, 0x3B, 0xE7,
  0xFD, 0x3D, 0x5D, 0x70, 0x26, 0xC5, 0x3A, 0xAA, 0xB0, 0xCA, 0x69, 0x64, 0x0B,
  0x62, 0x3E, 0x49, 0xE9, 0x4C, 0x05, 0x21, 0xBE, 0x34, 0xF4, 0xAA, 0x73, 0x21,
  0x13, 0x31, 0x84, 0xE8, 0xCE, 0xEF, 0x38, 0xCF, 0x57, 0xE9, 0xDB, 0xCB, 0xCE,
  0xD1, 0x6D, 0xFA, 0xC8, 0x81, 0x92, 0x2D, 0x22, 0xCE, 0x15, 0x7E, 0x7E, 0xB1,
  0x07, 0xAC, 0x88, 0xC7, 0x18, 0x92, 0xC1, 0x96, 0xC6, 0x0C, 0x90, 0x26, 0x17,
  0x55, 0x5F, 0x19, 0x1B, 0x25, 0xCF, 0x9E, 0x51, 0x34, 0xFA, 0xF3, 0xE7, 0xB1,
  0x1C, 0x78, 0x18, 0xDA, 0xE4, 0x39, 0x1A, 0x91, 0x1B, 0xC2, 0xDF, 0xA8, 0x00,
  0x5B, 0x5F, 0x4E, 0xC4, 0x22, 0xB4, 0xBA, 0x64, 0xE2, 0x4A, 0x77, 0xBA, 0xED,
  0x2C, 0xEB, 0xFE, 0x8B, 0x61, 0x96, 0xF0, 0x1E, 0x84, 0x2D, 0x74, 0x0A, 0x7B,
  0x17, 0xCD, 0xC3, 0xEE, 0x00, 0x6E, 0xD7, 0x66, 0x79, 0x8B, 0x50, 0xE9, 0x4F,
  0xAF, 0xA6, 0x3D, 0x91, 0x31, 0x2F, 0xCA, 0x87, 0x2B, 0xCF, 0xF7, 0x08, 0x49,
  0x14, 0x8A, 0x8E, 0x62, 0x7D, 0xAD, 0x56, 0xAA, 0x95, 0x62, 0xE3, 0xE9, 0x6B,
  0x4E, 0x64, 0x41, 0xE2, 0x4F, 0x22, 0xF7, 0x4B, 0x56, 0xF1, 0x2C, 0xA8, 0x71,
  0x11, 0x38, 0x09, 0x8B, 0x97, 0xB9, 0x08, 0xBF, 0xCF, 0x30, 0x26, 0x83, 0x40,
  0x90, 0x63, 0x1A, 0xB6, 0x69, 0xBA, 0x79, 0xB7, 0xAE, 0x59, 0xEC, 0x6B, 0x0D,
  0x84, 0x47, 0xA7, 0xAE, 0x0B, 0x47, 0x4C, 0x06, 0xFB, 0x76, 0x82, 0x69, 0x7B,
  0x5E, 0x23, 0x60, 0x52, 0x35, 0xD0, 0xAC, 0x46, 0x1C, 0xEA, 0xA0, 0xB6, 0x5A,
  0x8B, 0xD9, 0xED, 0x02, 0x03, 0x01, 0x00, 0x01,
};

// /CN=Apple IST CA 4 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: 61:15:F0:6A:33:8A:64:9E:61:58:52:10:E7:6F:2E:CE
//                     39:89:BC:A6:5A:62:B0:66:04:0C:D7:C5:F4:08:ED:D0
// https://crt.sh/?id=19602712 (crt.sh ID=19602712)
static const uint8_t CAAppleISTCA4G1SPKI[91] = {
  0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x02, 0x01,
  0x06, 0x08, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00,
  0x04, 0x61, 0xC3, 0xA3, 0x9E, 0x49, 0x7E, 0xCA, 0x08, 0x86, 0xEB, 0x46, 0xD9,
  0x46, 0x87, 0x67, 0xE0, 0x3A, 0x5D, 0xDB, 0x25, 0xE0, 0x83, 0x34, 0x03, 0xCB,
  0xB7, 0xD1, 0xBE, 0xAD, 0x43, 0x1D, 0x10, 0x3A, 0xC4, 0x16, 0xDD, 0x71, 0x12,
  0xB4, 0xFD, 0x93, 0x60, 0x69, 0x49, 0xFA, 0xBF, 0x4F, 0x90, 0xE0, 0xC7, 0x3F,
  0x3F, 0xBE, 0x08, 0xC1, 0x28, 0xAE, 0xFE, 0x7F, 0x2D, 0x9E, 0x37, 0x08, 0x4F,
};

// /CN=Apple IST CA 7 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: 17:F9:66:09:AC:6A:D0:A2:D6:AB:0A:21:B2:D1:B5:B2
//                     94:6B:D0:4D:BF:12:07:03:D1:DE:F6:FB:62:F4:B6:61
// https://crt.sh/?id=19602724 (crt.sh ID=19602724)
static const uint8_t CAAppleISTCA7G1SPKI[91] = {
  0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x02, 0x01,
  0x06, 0x08, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00,
  0x04, 0x55, 0x9A, 0x69, 0x4D, 0x4B, 0xE2, 0x14, 0xD3, 0xA7, 0xFF, 0x6A, 0xC4,
  0x22, 0xD4, 0xDD, 0x76, 0x64, 0xE0, 0x64, 0xA6, 0x1D, 0x2A, 0x4D, 0x47, 0xB1,
  0x4B, 0x13, 0x4A, 0x3E, 0xA6, 0xD2, 0x37, 0x18, 0xDF, 0xB4, 0x3B, 0x69, 0xB3,
  0xFC, 0x20, 0xC8, 0x43, 0x4C, 0x3F, 0x26, 0x5C, 0xC0, 0xE6, 0x9F, 0x6D, 0xDA,
  0x05, 0xFF, 0xD2, 0xAE, 0x58, 0xF0, 0xA4, 0xA1, 0xF1, 0xB4, 0x59, 0xB1, 0x8C,
};

// /CN=Apple IST CA 8 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: A4:FE:7C:7F:15:15:5F:3F:0A:EF:7A:AA:83:CF:6E:06
//                     DE:B9:7C:A3:F9:09:DF:92:0A:C1:49:08:82:D4:88:ED
// https://crt.sh/?id=21760447 (crt.sh ID=21760447)
static const uint8_t CAAppleISTCA8G1SPKI[91] = {
  0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x02, 0x01,
  0x06, 0x08, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00,
  0x04, 0x2D, 0x54, 0x8E, 0x68, 0xB0, 0x10, 0x13, 0xEF, 0xF4, 0x2D, 0xDB, 0xD8,
  0x09, 0xB2, 0x43, 0xE8, 0x9D, 0x65, 0x99, 0x6E, 0x34, 0xB8, 0xD4, 0x97, 0xC9,
  0x8E, 0xC9, 0xD6, 0xA8, 0x22, 0x37, 0x32, 0xC8, 0x71, 0x60, 0xEE, 0xB0, 0xF1,
  0xF2, 0xC5, 0x64, 0xF6, 0xBA, 0x47, 0x5F, 0xFC, 0xE6, 0x07, 0x78, 0x32, 0x2D,
  0xF6, 0xCA, 0x80, 0x20, 0xC9, 0xFD, 0x70, 0xF8, 0x72, 0x93, 0x21, 0x88, 0x45,
};

// /CN=Apple IST CA 3 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: 6D:E9:09:78:91:04:22:A8:9E:26:F2:DF:85:97:14:30
//                     C3:F4:4C:D1:78:5D:AD:94:30:8F:7C:A4:B6:FB:E5:21
// https://crt.sh/?id=19602706 (crt.sh ID=19602706)
static const uint8_t CAAppleISTCA3G1SPKI[294] = {
  0x30, 0x82, 0x01, 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7,
  0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0F, 0x00, 0x30, 0x82,
  0x01, 0x0A, 0x02, 0x82, 0x01, 0x01, 0x00, 0xD7, 0xED, 0xF5, 0x8A, 0xCC, 0x0C,
  0xA7, 0x2F, 0xCC, 0xFB, 0xA4, 0xC6, 0x26, 0x7C, 0x56, 0x7A, 0x47, 0xAE, 0xF9,
  0xC2, 0x3D, 0xCC, 0x66, 0x9A, 0xE2, 0x6F, 0x52, 0x89, 0xC4, 0x98, 0x27, 0x9D,
  0xB3, 0x17, 0x33, 0x55, 0xAC, 0xF3, 0xFF, 0xFD, 0xC1, 0xF6, 0xBA, 0x50, 0x14,
  0x03, 0x72, 0xDD, 0xAB, 0x78, 0xFD, 0xFA, 0x7D, 0x20, 0xB3, 0x3E, 0x32, 0xFA,
  0x44, 0xB8, 0xC9, 0x0D, 0x58, 0x28, 0x4E, 0x6C, 0x81, 0x78, 0x6D, 0xA3, 0x42,
  0xD0, 0xA5, 0x6A, 0xE1, 0x69, 0xE7, 0xC2, 0x29, 0x24, 0xEC, 0x86, 0xA0, 0xA4,
  0xF2, 0x36, 0x3D, 0xB4, 0x64, 0xAB, 0x16, 0x6F, 0x4B, 0xD7, 0x0D, 0xA6, 0xB4,
  0x61, 0x3E, 0xD2, 0x7D, 0xF5, 0x2F, 0x22, 0x4F, 0x99, 0x11, 0x1F, 0x33, 0xA1,
  0x15, 0xD7, 0x80, 0x7C, 0xD0, 0x65, 0xCA, 0xD4, 0xE0, 0x9B, 0x76, 0xF3, 0x56,
  0x56, 0xEE, 0xB6, 0x56, 0x40, 0x4E, 0xA9, 0x2B, 0x78, 0x3E, 0xD2, 0xF4, 0x0B,
  0x1E, 0x81, 0xFC, 0xE3, 0xFD, 0xAD, 0x94, 0x07, 0x15, 0x0F, 0x2A, 0x48, 0x19,
  0xEE, 0xB8, 0xA1, 0x56, 0x1A, 0x3D, 0xBC, 0xA8, 0x38, 0xD7, 0x80, 0x0C, 0x14,
  0x8F, 0x6C, 0xAD, 0x5F, 0xF3, 0x83, 0xD0, 0xE7, 0xDD, 0x5D, 0x25, 0xAB, 0x12,
  0x95, 0x31, 0x8C, 0x7E, 0xF9, 0xA1, 0x38, 0xB8, 0x04, 0xB7, 0xE1, 0x73, 0x74,
  0x52, 0xF9, 0x4B, 0x6F, 0xDA, 0x26, 0xB9, 0x40, 0x0D, 0x35, 0x41, 0x8D, 0x65,
  0xA9, 0x25, 0xAB, 0xD2, 0xB5, 0xE2, 0x9C, 0x54, 0x93, 0x64, 0xFC, 0xE7, 0x9E,
  0x67, 0x43, 0x31, 0xE5, 0x63, 0xF0, 0x15, 0x58, 0x39, 0x0A, 0x56, 0x8B, 0xEA,
  0x8C, 0xB2, 0xBE, 0x72, 0x64, 0xF1, 0x2E, 0x35, 0x57, 0xF3, 0xCD, 0x22, 0x1B,
  0x7A, 0xC3, 0x27, 0xD1, 0x65, 0x2C, 0x5B, 0xB3, 0xF5, 0xA4, 0x88, 0x64, 0x86,
  0xAC, 0x70, 0x79, 0x02, 0x03, 0x01, 0x00, 0x01,
};

// /CN=Apple IST CA 6 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: 90:4F:B5:A4:37:75:4B:1B:32:B8:0E:BA:E7:41:6D:B6
//                     3D:05:F5:6A:99:39:72:0B:7C:8E:3D:CC:54:F6:A3:D1
// https://crt.sh/?id=19602741 (crt.sh ID=19602741)
static const uint8_t CAAppleISTCA6G1SPKI[294] = {
  0x30, 0x82, 0x01, 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7,
  0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0F, 0x00, 0x30, 0x82,
  0x01, 0x0A, 0x02, 0x82, 0x01, 0x01, 0x00, 0xE7, 0xDC, 0x81, 0xF0, 0x9A, 0x55,
  0x51, 0xFD, 0x03, 0x80, 0xFD, 0xCA, 0xF5, 0xF8, 0x2E, 0xEF, 0xD4, 0xBC, 0xC1,
  0xF0, 0x1F, 0x19, 0x09, 0x0C, 0x74, 0x3F, 0x55, 0x3A, 0xCA, 0x6E, 0xA5, 0x86,
  0x2C, 0xFB, 0x65, 0x7E, 0x07, 0xDC, 0x18, 0x60, 0xE2, 0xDF, 0x0D, 0x09, 0x19,
  0x84, 0xB1, 0xE5, 0x07, 0x1A, 0x1E, 0x08, 0x25, 0xCC, 0x59, 0x3E, 0x6B, 0x62,
  0x81, 0xD1, 0x55, 0x85, 0xDC, 0x86, 0x91, 0x3F, 0xF1, 0xBB, 0xF7, 0x1C, 0xAE,
  0x79, 0x7C, 0x41, 0xD0, 0x7D, 0xD0, 0x98, 0x3C, 0x2B, 0xCE, 0x53, 0x6F, 0x47,
  0xD5, 0x6E, 0x48, 0x6F, 0x7E, 0x4D, 0x2E, 0x90, 0x37, 0x6F, 0x84, 0x4F, 0x20,
  0x75, 0x8C, 0x1B, 0xAB, 0x3A, 0x00, 0xB2, 0xDC, 0xB2, 0x3A, 0x3F, 0x7F, 0xCD,
  0xF7, 0xC6, 0xC0, 0x91, 0xA2, 0xBB, 0x0C, 0x55, 0x84, 0xB9, 0x85, 0xBE, 0x1D,
  0xBB, 0x16, 0x8E, 0x81, 0x12, 0xCF, 0x0E, 0x3A, 0xBA, 0x36, 0x76, 0x0F, 0x14,
  0xF9, 0x23, 0x04, 0x66, 0x03, 0x58, 0x22, 0xFC, 0xF8, 0x7E, 0x67, 0x3F, 0x5C,
  0x6B, 0x8D, 0xAC, 0xAE, 0xE4, 0x2E, 0x6D, 0x2E, 0x18, 0xEB, 0xCC, 0xDD, 0x5C,
  0x8F, 0x04, 0x97, 0xD3, 0xEF, 0x0F, 0x06, 0x02, 0x93, 0x16, 0x86, 0x46, 0xF5,
  0x19, 0x5B, 0x6F, 0x72, 0x85, 0x07, 0x46, 0x09, 0x6F, 0xE9, 0x76, 0x17, 0xF7,
  0x83, 0x18, 0x5F, 0xB7, 0x1A, 0xA2, 0x39, 0x97, 0xCA, 0x29, 0x60, 0xC2, 0xF2,
  0x73, 0x83, 0x0D, 0x84, 0xD1, 0xBF, 0xDB, 0x9E, 0xEF, 0x6A, 0x7F, 0xD1, 0xD1,
  0xFB, 0x76, 0xFC, 0xEF, 0x5C, 0xBB, 0x0F, 0x16, 0x0C, 0x8B, 0xC2, 0x0B, 0x70,
  0x86, 0x5E, 0xD3, 0x52, 0xDD, 0x6E, 0x76, 0xB4, 0x7F, 0xBF, 0x50, 0x60, 0x38,
  0xF1, 0x64, 0xF5, 0xD6, 0x50, 0xEF, 0x43, 0xAD, 0x6B, 0x8C, 0xD4, 0x30, 0xB0,
  0xB3, 0xC9, 0x29, 0x02, 0x03, 0x01, 0x00, 0x01,
};

// /C=US/O=DigiCert Inc/OU=www.digicert.com/CN=DigiCert Global Root G2
// SHA256 Fingerprint: CB:3C:CB:B7:60:31:E5:E0:13:8F:8D:D3:9A:23:F9:DE
//                     47:FF:C3:5E:43:C1:14:4C:EA:27:D4:6A:5A:B1:CB:5F
// https://crt.sh/?id=8656329 (crt.sh ID=8656329)
static const uint8_t CADigiCertGlobalRootG2SPKI[294] = {
  0x30, 0x82, 0x01, 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7,
  0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0F, 0x00, 0x30, 0x82,
  0x01, 0x0A, 0x02, 0x82, 0x01, 0x01, 0x00, 0xBB, 0x37, 0xCD, 0x34, 0xDC, 0x7B,
  0x6B, 0xC9, 0xB2, 0x68, 0x90, 0xAD, 0x4A, 0x75, 0xFF, 0x46, 0xBA, 0x21, 0x0A,
  0x08, 0x8D, 0xF5, 0x19, 0x54, 0xC9, 0xFB, 0x88, 0xDB, 0xF3, 0xAE, 0xF2, 0x3A,
  0x89, 0x91, 0x3C, 0x7A, 0xE6, 0xAB, 0x06, 0x1A, 0x6B, 0xCF, 0xAC, 0x2D, 0xE8,
  0x5E, 0x09, 0x24, 0x44, 0xBA, 0x62, 0x9A, 0x7E, 0xD6, 0xA3, 0xA8, 0x7E, 0xE0,
  0x54, 0x75, 0x20, 0x05, 0xAC, 0x50, 0xB7, 0x9C, 0x63, 0x1A, 0x6C, 0x30, 0xDC,
  0xDA, 0x1F, 0x19, 0xB1, 0xD7, 0x1E, 0xDE, 0xFD, 0xD7, 0xE0, 0xCB, 0x94, 0x83,
  0x37, 0xAE, 0xEC, 0x1F, 0x43, 0x4E, 0xDD, 0x7B, 0x2C, 0xD2, 0xBD, 0x2E, 0xA5,
  0x2F, 0xE4, 0xA9, 0xB8, 0xAD, 0x3A, 0xD4, 0x99, 0xA4, 0xB6, 0x25, 0xE9, 0x9B,
  0x6B, 0x00, 0x60, 0x92, 0x60, 0xFF, 0x4F, 0x21, 0x49, 0x18, 0xF7, 0x67, 0x90,
  0xAB, 0x61, 0x06, 0x9C, 0x8F, 0xF2, 0xBA, 0xE9, 0xB4, 0xE9, 0x92, 0x32, 0x6B,
  0xB5, 0xF3, 0x57, 0xE8, 0x5D, 0x1B, 0xCD, 0x8C, 0x1D, 0xAB, 0x95, 0x04, 0x95,
  0x49, 0xF3, 0x35, 0x2D, 0x96, 0xE3, 0x49, 0x6D, 0xDD, 0x77, 0xE3, 0xFB, 0x49,
  0x4B, 0xB4, 0xAC, 0x55, 0x07, 0xA9, 0x8F, 0x95, 0xB3, 0xB4, 0x23, 0xBB, 0x4C,
  0x6D, 0x45, 0xF0, 0xF6, 0xA9, 0xB2, 0x95, 0x30, 0xB4, 0xFD, 0x4C, 0x55, 0x8C,
  0x27, 0x4A, 0x57, 0x14, 0x7C, 0x82, 0x9D, 0xCD, 0x73, 0x92, 0xD3, 0x16, 0x4A,
  0x06, 0x0C, 0x8C, 0x50, 0xD1, 0x8F, 0x1E, 0x09, 0xBE, 0x17, 0xA1, 0xE6, 0x21,
  0xCA, 0xFD, 0x83, 0xE5, 0x10, 0xBC, 0x83, 0xA5, 0x0A, 0xC4, 0x67, 0x28, 0xF6,
  0x73, 0x14, 0x14, 0x3D, 0x46, 0x76, 0xC3, 0x87, 0x14, 0x89, 0x21, 0x34, 0x4D,
  0xAF, 0x0F, 0x45, 0x0C, 0xA6, 0x49, 0xA1, 0xBA, 0xBB, 0x9C, 0xC5, 0xB1, 0x33,
  0x83, 0x29, 0x85, 0x02, 0x03, 0x01, 0x00, 0x01,
};

// /C=US/O=DigiCert Inc/OU=www.digicert.com/CN=DigiCert Global Root G3
// SHA256 Fingerprint: 31:AD:66:48:F8:10:41:38:C7:38:F3:9E:A4:32:01:33
//                     39:3E:3A:18:CC:02:29:6E:F9:7C:2A:C9:EF:67:31:D0
// https://crt.sh/?id=8568700 (crt.sh ID=8568700)
static const uint8_t CADigiCertGlobalRootG3SPKI[120] = {
  0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x02, 0x01,
  0x06, 0x05, 0x2B, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xDD, 0xA7,
  0xD9, 0xBB, 0x8A, 0xB8, 0x0B, 0xFB, 0x0B, 0x7F, 0x21, 0xD2, 0xF0, 0xBE, 0xBE,
  0x73, 0xF3, 0x33, 0x5D, 0x1A, 0xBC, 0x34, 0xEA, 0xDE, 0xC6, 0x9B, 0xBC, 0xD0,
  0x95, 0xF6, 0xF0, 0xCC, 0xD0, 0x0B, 0xBA, 0x61, 0x5B, 0x51, 0x46, 0x7E, 0x9E,
  0x2D, 0x9F, 0xEE, 0x8E, 0x63, 0x0C, 0x17, 0xEC, 0x07, 0x70, 0xF5, 0xCF, 0x84,
  0x2E, 0x40, 0x83, 0x9C, 0xE8, 0x3F, 0x41, 0x6D, 0x3B, 0xAD, 0xD3, 0xA4, 0x14,
  0x59, 0x36, 0x78, 0x9D, 0x03, 0x43, 0xEE, 0x10, 0x13, 0x6C, 0x72, 0xDE, 0xAE,
  0x88, 0xA7, 0xA1, 0x6B, 0xB5, 0x43, 0xCE, 0x67, 0xDC, 0x23, 0xFF, 0x03, 0x1C,
  0xA3, 0xE2, 0x3E,
};

// /C=US/O=DigiCert Inc/OU=www.digicert.com/CN=DigiCert Transition ECC Root
// SHA256 Fingerprint: 45:BF:04:DC:A5:DE:7A:63:39:F1:DF:83:5B:C9:01:34
//                     57:B4:87:FD:B4:30:8E:40:80:C6:42:3C:8E:4B:27:05
// https://crt.sh/?id=281399768 (crt.sh ID=281399768)
static const uint8_t CADigiCertTransitionECCRootSPKI[91] = {
  0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x02, 0x01,
  0x06, 0x08, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00,
  0x04, 0x5A, 0xFF, 0x46, 0xDC, 0xC9, 0xAE, 0xBD, 0x2C, 0xE7, 0x1C, 0x56, 0x97,
  0xE4, 0xFA, 0xEB, 0xD5, 0xC6, 0xFF, 0x75, 0x53, 0x23, 0x5E, 0xC6, 0xB0, 0x7D,
  0xAC, 0xAC, 0x57, 0x3A, 0x9F, 0x94, 0x50, 0x07, 0x0D, 0xF1, 0xF3, 0x4D, 0x51,
  0x0D, 0x7D, 0xFD, 0x88, 0x41, 0x82, 0x3F, 0x1C, 0x7F, 0xFB, 0xC3, 0x1E, 0xFA,
  0xF6, 0xEB, 0xD4, 0x37, 0xFF, 0xFE, 0x18, 0x9D, 0x01, 0x83, 0x2A, 0x80, 0x3A,
};

// /C=US/O=DigiCert Inc/OU=www.digicert.com/CN=DigiCert Transition RSA Root
// SHA256 Fingerprint: E5:2B:44:CD:1E:6A:9A:DA:0A:04:09:D1:CC:5D:73:A6
//                     F4:17:60:3D:70:E6:F5:DC:54:83:AB:8A:DA:EF:3C:A4
// https://crt.sh/?id=281399766 (crt.sh ID=281399766)
static const uint8_t CADigiCertTransitionRSARootSPKI[294] = {
  0x30, 0x82, 0x01, 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7,
  0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0F, 0x00, 0x30, 0x82,
  0x01, 0x0A, 0x02, 0x82, 0x01, 0x01, 0x00, 0xB0, 0x3E, 0xD8, 0x46, 0x63, 0x32,
  0xDF, 0x49, 0x1F, 0x61, 0x6D, 0xAE, 0xDF, 0xC9, 0x7F, 0x2B, 0xB1, 0x63, 0xA1,
  0xA7, 0xE6, 0x46, 0x35, 0x34, 0x0E, 0xD4, 0xA5, 0x3D, 0x12, 0xAF, 0x04, 0x6A,
  0xD5, 0xF8, 0xBA, 0xA7, 0x65, 0x93, 0xEC, 0x66, 0xC5, 0xCA, 0xEB, 0x68, 0x01,
  0x24, 0x69, 0x1F, 0xAF, 0xB0, 0xA3, 0x59, 0xAF, 0x3C, 0x5B, 0x39, 0x44, 0x29,
  0x60, 0x6E, 0x8B, 0x41, 0x98, 0x49, 0x21, 0xD8, 0x18, 0x13, 0xD3, 0x41, 0x55,
  0xFE, 0xAA, 0x22, 0x7E, 0xA7, 0x51, 0x4A, 0xA6, 0xD0, 0x23, 0x5F, 0x73, 0x84,
  0xA2, 0x9C, 0xB4, 0xCB, 0x17, 0xD0, 0x65, 0x24, 0x87, 0xE9, 0x80, 0xCB, 0xB7,
  0x3C, 0xA1, 0x10, 0xF5, 0x97, 0xB5, 0x0D, 0x9D, 0xEC, 0xF7, 0xBA, 0x5B, 0xA3,
  0x0B, 0x65, 0xEB, 0x12, 0x75, 0xA9, 0x46, 0x74, 0x0D, 0x80, 0xD7, 0x08, 0x13,
  0x93, 0x21, 0x57, 0xC6, 0x38, 0x3D, 0xA8, 0x4B, 0x3B, 0x0B, 0x6F, 0x18, 0xE5,
  0xB3, 0x4C, 0xF7, 0xC2, 0xCD, 0x18, 0xF9, 0x58, 0x2D, 0x03, 0x33, 0x1B, 0xFC,
  0x16, 0xDD, 0x90, 0x4E, 0xC2, 0x1F, 0x37, 0x9C, 0xD6, 0x7B, 0x61, 0x96, 0xF1,
  0xC5, 0x26, 0x87, 0x52, 0xE3, 0xE2, 0xA4, 0xF8, 0x15, 0xE5, 0x4C, 0x22, 0xE9,
  0x09, 0x2B, 0x95, 0xD1, 0x93, 0xF9, 0x3A, 0x39, 0x76, 0x74, 0x2A, 0x0B, 0x80,
  0xBE, 0xBE, 0x0E, 0xD3, 0x10, 0x0B, 0xE2, 0xE1, 0x48, 0xA6, 0x24, 0x05, 0x69,
  0x3D, 0x17, 0xFD, 0xC7, 0x37, 0x21, 0xB2, 0xB0, 0xE3, 0x77, 0x47, 0x39, 0x87,
  0x01, 0xE0, 0x4E, 0xDB, 0x23, 0xE8, 0xF9, 0x39, 0x9F, 0x36, 0x46, 0x66, 0x23,
  0x1E, 0xC7, 0x22, 0x51, 0x44, 0x3F, 0x33, 0xC5, 0xF5, 0x76, 0xA9, 0xF8, 0x06,
  0xB0, 0x79, 0xCC, 0xEE, 0x41, 0xDC, 0x71, 0x8E, 0x0D, 0x50, 0x8E, 0xB0, 0x3C,
  0x48, 0xAB, 0xF5, 0x02, 0x03, 0x01, 0x00, 0x01,
};

static const DataAndLength RootAppleAndGoogleSPKIs[]= {
  { CAGoogleInternetAuthorityG2SPKI, sizeof(CAGoogleInternetAuthorityG2SPKI) },
  { CAAppleISTCA2G1SPKI, sizeof(CAAppleISTCA2G1SPKI) },
  { CAAppleISTCA5G1SPKI, sizeof(CAAppleISTCA5G1SPKI) },
  { CAAppleISTCA4G1SPKI, sizeof(CAAppleISTCA4G1SPKI) },
  { CAAppleISTCA7G1SPKI, sizeof(CAAppleISTCA7G1SPKI) },
  { CAAppleISTCA8G1SPKI, sizeof(CAAppleISTCA8G1SPKI) },
  { CAAppleISTCA3G1SPKI, sizeof(CAAppleISTCA3G1SPKI) },
  { CAAppleISTCA6G1SPKI, sizeof(CAAppleISTCA6G1SPKI) },
  { CADigiCertGlobalRootG2SPKI, sizeof(CADigiCertGlobalRootG2SPKI) },
  { CADigiCertGlobalRootG3SPKI, sizeof(CADigiCertGlobalRootG3SPKI) },
  { CADigiCertTransitionECCRootSPKI, sizeof(CADigiCertTransitionECCRootSPKI) },
  { CADigiCertTransitionRSARootSPKI, sizeof(CADigiCertTransitionRSARootSPKI) },
};
