# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
import functools
from typing import Any, Callable, Dict, Generic, List, Optional, TypeVar, Union
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._log_analytics_operations import build_get_log_analytics_locations_request, build_get_log_analytics_metrics_request, build_get_log_analytics_rankings_request, build_get_log_analytics_resources_request, build_get_waf_log_analytics_metrics_request, build_get_waf_log_analytics_rankings_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class LogAnalyticsOperations:
    """LogAnalyticsOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.cdn.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace_async
    async def get_log_analytics_metrics(
        self,
        resource_group_name: str,
        profile_name: str,
        metrics: List[Union[str, "_models.LogMetric"]],
        date_time_begin: datetime.datetime,
        date_time_end: datetime.datetime,
        granularity: Union[str, "_models.LogMetricsGranularity"],
        custom_domains: List[str],
        protocols: List[str],
        group_by: Optional[List[Union[str, "_models.LogMetricsGroupBy"]]] = None,
        continents: Optional[List[str]] = None,
        country_or_regions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> "_models.MetricsResponse":
        """Get log report for AFD profile.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the Azure Front Door Standard or Azure Front Door Premium profile
         which is unique within the resource group. which is unique within the resource group.
        :type profile_name: str
        :param metrics:
        :type metrics: list[str or ~azure.mgmt.cdn.models.LogMetric]
        :param date_time_begin:
        :type date_time_begin: ~datetime.datetime
        :param date_time_end:
        :type date_time_end: ~datetime.datetime
        :param granularity:
        :type granularity: str or ~azure.mgmt.cdn.models.LogMetricsGranularity
        :param custom_domains:
        :type custom_domains: list[str]
        :param protocols:
        :type protocols: list[str]
        :param group_by:
        :type group_by: list[str or ~azure.mgmt.cdn.models.LogMetricsGroupBy]
        :param continents:
        :type continents: list[str]
        :param country_or_regions:
        :type country_or_regions: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: MetricsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.MetricsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.MetricsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_log_analytics_metrics_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=resource_group_name,
            profile_name=profile_name,
            metrics=metrics,
            date_time_begin=date_time_begin,
            date_time_end=date_time_end,
            granularity=granularity,
            custom_domains=custom_domains,
            protocols=protocols,
            group_by=group_by,
            continents=continents,
            country_or_regions=country_or_regions,
            template_url=self.get_log_analytics_metrics.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AfdErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('MetricsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_log_analytics_metrics.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsMetrics'}  # type: ignore


    @distributed_trace_async
    async def get_log_analytics_rankings(
        self,
        resource_group_name: str,
        profile_name: str,
        rankings: List[Union[str, "_models.LogRanking"]],
        metrics: List[Union[str, "_models.LogRankingMetric"]],
        max_ranking: int,
        date_time_begin: datetime.datetime,
        date_time_end: datetime.datetime,
        custom_domains: Optional[List[str]] = None,
        **kwargs: Any
    ) -> "_models.RankingsResponse":
        """Get log analytics ranking report for AFD profile.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the Azure Front Door Standard or Azure Front Door Premium profile
         which is unique within the resource group. which is unique within the resource group.
        :type profile_name: str
        :param rankings:
        :type rankings: list[str or ~azure.mgmt.cdn.models.LogRanking]
        :param metrics:
        :type metrics: list[str or ~azure.mgmt.cdn.models.LogRankingMetric]
        :param max_ranking:
        :type max_ranking: int
        :param date_time_begin:
        :type date_time_begin: ~datetime.datetime
        :param date_time_end:
        :type date_time_end: ~datetime.datetime
        :param custom_domains:
        :type custom_domains: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RankingsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.RankingsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RankingsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_log_analytics_rankings_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=resource_group_name,
            profile_name=profile_name,
            rankings=rankings,
            metrics=metrics,
            max_ranking=max_ranking,
            date_time_begin=date_time_begin,
            date_time_end=date_time_end,
            custom_domains=custom_domains,
            template_url=self.get_log_analytics_rankings.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AfdErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('RankingsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_log_analytics_rankings.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsRankings'}  # type: ignore


    @distributed_trace_async
    async def get_log_analytics_locations(
        self,
        resource_group_name: str,
        profile_name: str,
        **kwargs: Any
    ) -> "_models.ContinentsResponse":
        """Get all available location names for AFD log analytics report.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the Azure Front Door Standard or Azure Front Door Premium profile
         which is unique within the resource group. which is unique within the resource group.
        :type profile_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ContinentsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.ContinentsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ContinentsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_log_analytics_locations_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=resource_group_name,
            profile_name=profile_name,
            template_url=self.get_log_analytics_locations.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AfdErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ContinentsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_log_analytics_locations.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsLocations'}  # type: ignore


    @distributed_trace_async
    async def get_log_analytics_resources(
        self,
        resource_group_name: str,
        profile_name: str,
        **kwargs: Any
    ) -> "_models.ResourcesResponse":
        """Get all endpoints and custom domains available for AFD log report.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the Azure Front Door Standard or Azure Front Door Premium profile
         which is unique within the resource group. which is unique within the resource group.
        :type profile_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourcesResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.ResourcesResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ResourcesResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_log_analytics_resources_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=resource_group_name,
            profile_name=profile_name,
            template_url=self.get_log_analytics_resources.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AfdErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ResourcesResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_log_analytics_resources.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsResources'}  # type: ignore


    @distributed_trace_async
    async def get_waf_log_analytics_metrics(
        self,
        resource_group_name: str,
        profile_name: str,
        metrics: List[Union[str, "_models.WafMetric"]],
        date_time_begin: datetime.datetime,
        date_time_end: datetime.datetime,
        granularity: Union[str, "_models.WafGranularity"],
        actions: Optional[List[Union[str, "_models.WafAction"]]] = None,
        group_by: Optional[List[Union[str, "_models.WafRankingGroupBy"]]] = None,
        rule_types: Optional[List[Union[str, "_models.WafRuleType"]]] = None,
        **kwargs: Any
    ) -> "_models.WafMetricsResponse":
        """Get Waf related log analytics report for AFD profile.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the Azure Front Door Standard or Azure Front Door Premium profile
         which is unique within the resource group. which is unique within the resource group.
        :type profile_name: str
        :param metrics:
        :type metrics: list[str or ~azure.mgmt.cdn.models.WafMetric]
        :param date_time_begin:
        :type date_time_begin: ~datetime.datetime
        :param date_time_end:
        :type date_time_end: ~datetime.datetime
        :param granularity:
        :type granularity: str or ~azure.mgmt.cdn.models.WafGranularity
        :param actions:
        :type actions: list[str or ~azure.mgmt.cdn.models.WafAction]
        :param group_by:
        :type group_by: list[str or ~azure.mgmt.cdn.models.WafRankingGroupBy]
        :param rule_types:
        :type rule_types: list[str or ~azure.mgmt.cdn.models.WafRuleType]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WafMetricsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.WafMetricsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.WafMetricsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_waf_log_analytics_metrics_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=resource_group_name,
            profile_name=profile_name,
            metrics=metrics,
            date_time_begin=date_time_begin,
            date_time_end=date_time_end,
            granularity=granularity,
            actions=actions,
            group_by=group_by,
            rule_types=rule_types,
            template_url=self.get_waf_log_analytics_metrics.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AfdErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('WafMetricsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_waf_log_analytics_metrics.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsMetrics'}  # type: ignore


    @distributed_trace_async
    async def get_waf_log_analytics_rankings(
        self,
        resource_group_name: str,
        profile_name: str,
        metrics: List[Union[str, "_models.WafMetric"]],
        date_time_begin: datetime.datetime,
        date_time_end: datetime.datetime,
        max_ranking: int,
        rankings: List[Union[str, "_models.WafRankingType"]],
        actions: Optional[List[Union[str, "_models.WafAction"]]] = None,
        rule_types: Optional[List[Union[str, "_models.WafRuleType"]]] = None,
        **kwargs: Any
    ) -> "_models.WafRankingsResponse":
        """Get WAF log analytics charts for AFD profile.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param profile_name: Name of the Azure Front Door Standard or Azure Front Door Premium profile
         which is unique within the resource group. which is unique within the resource group.
        :type profile_name: str
        :param metrics:
        :type metrics: list[str or ~azure.mgmt.cdn.models.WafMetric]
        :param date_time_begin:
        :type date_time_begin: ~datetime.datetime
        :param date_time_end:
        :type date_time_end: ~datetime.datetime
        :param max_ranking:
        :type max_ranking: int
        :param rankings:
        :type rankings: list[str or ~azure.mgmt.cdn.models.WafRankingType]
        :param actions:
        :type actions: list[str or ~azure.mgmt.cdn.models.WafAction]
        :param rule_types:
        :type rule_types: list[str or ~azure.mgmt.cdn.models.WafRuleType]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WafRankingsResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.WafRankingsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.WafRankingsResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_waf_log_analytics_rankings_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=resource_group_name,
            profile_name=profile_name,
            metrics=metrics,
            date_time_begin=date_time_begin,
            date_time_end=date_time_end,
            max_ranking=max_ranking,
            rankings=rankings,
            actions=actions,
            rule_types=rule_types,
            template_url=self.get_waf_log_analytics_rankings.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AfdErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('WafRankingsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_waf_log_analytics_rankings.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsRankings'}  # type: ignore

