/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.bmp;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.bmp.BMPColorMap;
import com.sun.jimi.core.decoder.bmp.BMPFileHeader;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BMPDecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage ji_;
    private InputStream in_;
    private LEDataInputStream leInput;
    private int state;
    private BMPFileHeader bmpHeader;
    private BMPColorMap bmpColorMap;
    private ColorModel model;
    byte[] rawScanLine;
    int[] intScanLine;
    byte[] byteScanLine;

    public boolean driveDecoder() throws JimiException {
        try {
            this.bmpHeader = new BMPFileHeader(this.leInput);
            this.bmpColorMap = new BMPColorMap(this.leInput, this.bmpHeader);
            this.initJimiImage();
            this.state |= 2;
            this.loadImage(this.leInput);
            this.ji_.addFullCoverage();
            this.state |= 4;
        }
        catch (IOException iOException) {
            this.state |= 1;
            throw new JimiException("IO error reading BMP file");
        }
        catch (JimiException jimiException) {
            this.state |= 1;
            throw jimiException;
        }
        return false;
    }

    public void freeDecoder() throws JimiException {
        this.in_ = null;
        this.ji_ = null;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji_;
    }

    public int getState() {
        return this.state;
    }

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.bmpHeader = null;
        this.bmpColorMap = null;
        this.in_ = inputStream;
        this.leInput = new LEDataInputStream(new BufferedInputStream(this.in_));
        this.ji_ = adaptiveRasterImage;
        this.state = 0;
    }

    private void initJimiImage() throws JimiException {
        this.ji_.setSize(this.bmpHeader.width, this.bmpHeader.height);
        if (this.bmpHeader.bitsPerPixel == 32) {
            this.model = ColorModel.getRGBdefault();
        } else if (this.bmpHeader.bitsPerPixel == 24) {
            this.model = new DirectColorModel(24, 0xFF0000, 65280, 255);
        } else if (this.bmpHeader.bitsPerPixel == 16) {
            this.model = new DirectColorModel(16, this.bmpHeader.redMask, this.bmpHeader.greenMask, this.bmpHeader.blueMask, this.bmpHeader.alphaMask);
        } else {
            if (this.bmpColorMap.noOfEntries <= 0) {
                throw new JimiException("8 bit or less bitsperpixel requies pallete");
            }
            this.model = new IndexColorModel(8, this.bmpColorMap.noOfEntries, this.bmpColorMap.r, this.bmpColorMap.g, this.bmpColorMap.b);
        }
        this.ji_.setColorModel(this.model);
        this.ji_.setPixels();
        if (this.bmpHeader.bitsPerPixel == 32) {
            this.intScanLine = new int[this.bmpHeader.scanLineSize / 4];
        }
        if (this.bmpHeader.bitsPerPixel == 24) {
            this.intScanLine = new int[this.bmpHeader.scanLineSize / 3];
        }
        if (this.bmpHeader.bitsPerPixel == 16) {
            this.intScanLine = new int[this.bmpHeader.scanLineSize / 2];
        } else {
            this.byteScanLine = new byte[this.bmpHeader.width];
        }
        this.rawScanLine = new byte[this.bmpHeader.scanLineSize];
    }

    private void loadImage(LEDataInputStream lEDataInputStream) throws JimiException, IOException {
        switch (this.bmpHeader.compression) {
            case 1: {
                this.ji_.setChannel(0L);
                this.unpackRLE8(lEDataInputStream);
                return;
            }
            case 2: {
                this.ji_.setChannel(0L);
                this.unpackRLE4(lEDataInputStream);
                return;
            }
            default: {
                throw new JimiException("Unsupported compression " + this.bmpHeader.compression);
            }
            case 0: 
            case 3: 
        }
        int n = this.bmpHeader.height - 1;
        while (n >= 0) {
            lEDataInputStream.readFully(this.rawScanLine, 0, this.bmpHeader.scanLineSize);
            if (this.bmpHeader.bitsPerPixel == 32) {
                this.pack32ToInt(this.rawScanLine, 0, this.intScanLine, 0, this.bmpHeader.width);
                this.ji_.setChannel(n, this.intScanLine);
            } else if (this.bmpHeader.bitsPerPixel == 24) {
                this.pack24ToInt(this.rawScanLine, 0, this.intScanLine, 0, this.bmpHeader.width);
                this.ji_.setChannel(n, this.intScanLine);
            } else if (this.bmpHeader.bitsPerPixel == 16) {
                this.pack16ToInt(this.rawScanLine, 0, this.intScanLine, 0, this.bmpHeader.width);
                this.ji_.setChannel(n, this.intScanLine);
            } else if (this.bmpHeader.bitsPerPixel < 8) {
                JimiUtil.expandPixels(this.bmpHeader.bitsPerPixel, this.rawScanLine, this.byteScanLine, this.bmpHeader.width);
                this.ji_.setChannel(0, n, this.byteScanLine);
            } else {
                this.ji_.setChannel(0, n, this.rawScanLine, 0, this.bmpHeader.width);
            }
            this.setProgress((this.bmpHeader.height - n - 1) * 100 / (this.bmpHeader.height - 1));
            --n;
        }
    }

    private void pack16ToInt(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        int n6 = 255;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = byArray[n5++] & n6;
            int n9 = (byArray[n5++] & n6) << 8;
            nArray[n4] = n8 | n9;
            ++n4;
            ++n7;
        }
    }

    private void pack24ToInt(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        int n6 = 255;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = byArray[n5++] & n6;
            int n9 = (byArray[n5++] & n6) << 8;
            int n10 = (byArray[n5++] & n6) << 16;
            nArray[n4] = 0xFF000000 | n8 | n9 | n10;
            ++n4;
            ++n7;
        }
    }

    private void pack32ToInt(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        int n6 = 255;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = byArray[n5++] & n6;
            int n9 = (byArray[n5++] & n6) << 8;
            int n10 = (byArray[n5++] & n6) << 16;
            int n11 = (byArray[n5++] & n6) << 24;
            nArray[n4] = 0xFF000000 | n8 | n9 | n10;
            ++n4;
            ++n7;
        }
    }

    /*
     * Unable to fully structure code
     */
    void unpackRLE4(InputStream var1_1) throws JimiException, IOException {
        var8_2 = this.bmpHeader.height - 1;
        var9_3 = 0;
        var7_4 = new byte[this.bmpHeader.width];
        var10_5 = 0;
        block5: while (true) {
            if ((var3_6 = var1_1.read()) < 0) {
                throw new EOFException();
            }
            if (var3_6 == 0) {
                var5_8 = var1_1.read();
                if (var5_8 < 0) {
                    throw new EOFException();
                }
                switch (var5_8) {
                    case 0: {
                        if (var10_5 > var9_3) {
                            this.ji_.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                        }
                        var10_5 = 0;
                        var9_3 = 0;
                        --var8_2;
                        continue block5;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        if (var10_5 > var9_3) {
                            this.ji_.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                        }
                        var11_10 = var1_1.read();
                        var12_12 = var1_1.read();
                        var10_5 = var9_3 += var11_10;
                        var8_2 += var12_12;
                        continue block5;
                    }
                }
                var6_9 = false;
                if ((var5_8 & 3) == 1 || (var5_8 & 3) == 2) {
                    var6_9 = true;
                }
                var13_13 = 0;
                var14_14 = new byte[2];
                while (--var5_8 >= 0) {
                    if (var13_13 == 0) {
                        var15_15 = var1_1.read();
                        if (var15_15 < 0) {
                            throw new EOFException();
                        }
                        var14_14[0] = (byte)((var15_15 & 240) >> 4);
                        var14_14[1] = (byte)(var15_15 & 15);
                    }
                    if (var10_5 == var7_4.length) {
                        if (var10_5 > var9_3) {
                            this.ji_.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                        }
                        var10_5 = 0;
                        var9_3 = 0;
                        --var8_2;
                    }
                    var7_4[var10_5++] = var14_14[var13_13];
                    var13_13 ^= 1;
                }
                if (!var6_9) continue;
                var1_1.read();
                continue;
            }
            var4_7 = var1_1.read();
            if (var4_7 < 0) {
                throw new EOFException();
            }
            var11_11 = new byte[]{(byte)((var4_7 & 240) >> 4), (byte)(var4_7 & 15)};
            var12_12 = 0;
            while (true) {
                if (--var3_6 >= 0) ** break;
                continue block5;
                if (var10_5 == var7_4.length) {
                    if (var10_5 > var9_3) {
                        this.ji_.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                    }
                    var10_5 = 0;
                    var9_3 = 0;
                    --var8_2;
                }
                var7_4[var10_5++] = var11_11[var12_12];
                var12_12 ^= 1;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    void unpackRLE8(InputStream var1_1) throws JimiException, IOException {
        var8_2 = this.bmpHeader.height - 1;
        var9_3 = 0;
        var7_4 = new byte[this.bmpHeader.width];
        var10_5 = 0;
        block5: while (true) {
            if ((var3_6 = var1_1.read()) < 0) {
                throw new EOFException();
            }
            if (var3_6 == 0) {
                var5_8 = var1_1.read();
                if (var5_8 < 0) {
                    throw new EOFException();
                }
                switch (var5_8) {
                    case 0: {
                        if (var10_5 > var9_3) {
                            this.ji_.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                        }
                        var10_5 = 0;
                        var9_3 = 0;
                        this.setProgress((this.bmpHeader.height - 1 - --var8_2) * 100 / (this.bmpHeader.height - 1));
                        continue block5;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        this.ji_.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                        var11_10 = var1_1.read();
                        var12_11 = var1_1.read();
                        var10_5 = var9_3 += var11_10;
                        var8_2 += var12_11;
                        continue block5;
                    }
                }
                var6_9 = false;
                if ((var5_8 & 1) != 0) {
                    var6_9 = true;
                }
                while (--var5_8 >= 0) {
                    var13_12 = var1_1.read();
                    if (var13_12 < 0) {
                        throw new EOFException();
                    }
                    if (var10_5 == var7_4.length) {
                        this.ji_.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                        var10_5 = 0;
                        var9_3 = 0;
                        this.setProgress((this.bmpHeader.height - 1 - --var8_2) * 100 / (this.bmpHeader.height - 1));
                    }
                    var7_4[var10_5++] = (byte)var13_12;
                }
                if (!var6_9) continue;
                var1_1.read();
                continue;
            }
            var4_7 = var1_1.read();
            if (var4_7 >= 0) ** GOTO lbl56
            throw new EOFException();
lbl-1000:
            // 1 sources

            {
                if (var10_5 == var7_4.length) {
                    this.ji_.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                    var10_5 = 0;
                    var9_3 = 0;
                    --var8_2;
                }
                var7_4[var10_5++] = (byte)var4_7;
lbl56:
                // 2 sources

                ** while (--var3_6 >= 0)
            }
lbl57:
            // 1 sources

        }
    }

    public boolean usesChanneledData() {
        return true;
    }
}

