/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.cookies;

import com.meterware.httpunit.cookies.CookieProperties;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;

public class Cookie {
    private String _name;
    private String _value;
    private String _path;
    private String _domain;

    Cookie(String name, String value) {
        this._name = name;
        this._value = value;
    }

    Cookie(String name, String value, Map attributes) {
        this(name, value);
        Iterator iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key.equalsIgnoreCase("path")) {
                this._path = (String)attributes.get(key);
                continue;
            }
            if (!key.equalsIgnoreCase("domain")) continue;
            this._domain = (String)attributes.get(key);
        }
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public String getPath() {
        return this._path;
    }

    public String getDomain() {
        return this._domain;
    }

    void setPath(String path) {
        this._path = path;
    }

    void setDomain(String domain) {
        this._domain = domain;
    }

    public boolean equals(Object obj) {
        return obj.getClass() == this.getClass() && this.equals((Cookie)obj);
    }

    boolean mayBeSentTo(URL url) {
        if (this.getDomain() == null) {
            return true;
        }
        return Cookie.acceptHost(this.getDomain(), url.getHost()) && this.acceptPath(this.getPath(), url.getPath());
    }

    private boolean acceptPath(String pathPattern, String hostPath) {
        return !CookieProperties.isPathMatchingStrict() || hostPath.startsWith(pathPattern);
    }

    private boolean equals(Cookie other) {
        return this._name.equalsIgnoreCase(other._name) && this.equalProperties(this.getDomain(), other.getDomain()) && this.equalProperties(this.getPath(), other.getPath());
    }

    private boolean equalProperties(String first, String second) {
        return first == second || first != null && first.equals(second);
    }

    private static boolean acceptHost(String hostPattern, String hostName) {
        return hostPattern.equalsIgnoreCase(hostName) || hostPattern.startsWith(".") && hostName.endsWith(hostPattern);
    }
}

