/* G3 fax format declarations */

#ifndef G3_H_INCLUDED
#define G3_H_INCLUDED

/* G3 is nearly universal as the format for fax transmissions in the
   US.  Its full name is CCITT Group 3 (G3).  It is specified in
   Recommendations T.4 and T.30 and in EIA Standards EIA-465 and
   EIA-466.  It dates to 1993.

   G3 faxes are 204 dots per inch (dpi) horizontally and 98 dpi (196
   dpi optionally, in fine-detail mode) vertically.  Since G3 neither
   assumes error free transmission nor retransmits when errors occur,
   the encoding scheme used is differential only over small segments
   never exceeding 2 lines at standard resolution or 4 lines for
   fine-detail. (The incremental G3 encoding scheme is called
   two-dimensional and the number of lines so encoded is specified by
   a parameter called k.)

   G3 specifies much more than the format of the bit stream, which is
   the subject of this header file.  It also specifies layers
   underneath the bit stream.

   There is also the newer G4.  
*/

typedef struct G3TableEntry {
    unsigned short int code;
    unsigned short int length;
} G3TableEntry;


struct BitString {
    /* A string of bits, up to as many fit in 32 bits. */
    uint32_t     intBuffer;
        /* The bits are in the 'bitCount' least significant bit positions 
           of this number.  The rest of the bits of this number are always 
           zero.
        */
    unsigned int bitCount;
        /* The length of the bit string */

    /* Example:  The bit string 010100 would be represented by
       bitCount = 6, intBuffer = 20
       (N.B. 20 = 00000000 00000000 00000000 00010100 in binary)
    */
};


static struct G3TableEntry ttable[] = {
/*    TERMWHITE           TERMBLACK   */
    { 0x35, 8 },    { 0x37, 10 },       /* white 0 , black 0 */
    { 0x07, 6 },    { 0x02,  3 },
    { 0x07, 4 },    { 0x03,  2 },
    { 0x08, 4 },    { 0x02,  2 },
    { 0x0b, 4 },    { 0x03,  3 },
    { 0x0c, 4 },    { 0x03,  4 },
    { 0x0e, 4 },    { 0x02,  4 },
    { 0x0f, 4 },    { 0x03,  5 },
    { 0x13, 5 },    { 0x05,  6 },
    { 0x14, 5 },    { 0x04,  6 },
    { 0x07, 5 },    { 0x04,  7 },
    { 0x08, 5 },    { 0x05,  7 },
    { 0x08, 6 },    { 0x07,  7 },
    { 0x03, 6 },    { 0x04,  8 },
    { 0x34, 6 },    { 0x07,  8 },
    { 0x35, 6 },    { 0x18,  9 },
    { 0x2a, 6 },    { 0x17, 10 },
    { 0x2b, 6 },    { 0x18, 10 },
    { 0x27, 7 },    { 0x08, 10 },
    { 0x0c, 7 },    { 0x67, 11 },
    { 0x08, 7 },    { 0x68, 11 },
    { 0x17, 7 },    { 0x6c, 11 },
    { 0x03, 7 },    { 0x37, 11 },
    { 0x04, 7 },    { 0x28, 11 },
    { 0x28, 7 },    { 0x17, 11 },
    { 0x2b, 7 },    { 0x18, 11 },
    { 0x13, 7 },    { 0xca, 12 },
    { 0x24, 7 },    { 0xcb, 12 },
    { 0x18, 7 },    { 0xcc, 12 },
    { 0x02, 8 },    { 0xcd, 12 },
    { 0x03, 8 },    { 0x68, 12 },
    { 0x1a, 8 },    { 0x69, 12 },
    { 0x1b, 8 },    { 0x6a, 12 },
    { 0x12, 8 },    { 0x6b, 12 },
    { 0x13, 8 },    { 0xd2, 12 },
    { 0x14, 8 },    { 0xd3, 12 },
    { 0x15, 8 },    { 0xd4, 12 },
    { 0x16, 8 },    { 0xd5, 12 },
    { 0x17, 8 },    { 0xd6, 12 },
    { 0x28, 8 },    { 0xd7, 12 },
    { 0x29, 8 },    { 0x6c, 12 },
    { 0x2a, 8 },    { 0x6d, 12 },
    { 0x2b, 8 },    { 0xda, 12 },
    { 0x2c, 8 },    { 0xdb, 12 },
    { 0x2d, 8 },    { 0x54, 12 },
    { 0x04, 8 },    { 0x55, 12 },
    { 0x05, 8 },    { 0x56, 12 },
    { 0x0a, 8 },    { 0x57, 12 },
    { 0x0b, 8 },    { 0x64, 12 },
    { 0x52, 8 },    { 0x65, 12 },
    { 0x53, 8 },    { 0x52, 12 },
    { 0x54, 8 },    { 0x53, 12 },
    { 0x55, 8 },    { 0x24, 12 },
    { 0x24, 8 },    { 0x37, 12 },
    { 0x25, 8 },    { 0x38, 12 },
    { 0x58, 8 },    { 0x27, 12 },
    { 0x59, 8 },    { 0x28, 12 },
    { 0x5a, 8 },    { 0x58, 12 },
    { 0x5b, 8 },    { 0x59, 12 },
    { 0x4a, 8 },    { 0x2b, 12 },
    { 0x4b, 8 },    { 0x2c, 12 },
    { 0x32, 8 },    { 0x5a, 12 },
    { 0x33, 8 },    { 0x66, 12 },
    { 0x34, 8 },    { 0x67, 12 },       /* white 63 , black 63 */

/* mtable */    
/*    MKUPWHITE           MKUPBLACK   */
    { 0x00, 0 },    { 0x00,  0 },   /* dummy to simplify pointer math */
    { 0x1b, 5 },    { 0x0f, 10 },   /* white 64 , black 64 */
    { 0x12, 5 },    { 0xc8, 12 },
    { 0x17, 6 },    { 0xc9, 12 },
    { 0x37, 7 },    { 0x5b, 12 },
    { 0x36, 8 },    { 0x33, 12 },
    { 0x37, 8 },    { 0x34, 12 },
    { 0x64, 8 },    { 0x35, 12 },
    { 0x65, 8 },    { 0x6c, 13 },
    { 0x68, 8 },    { 0x6d, 13 },
    { 0x67, 8 },    { 0x4a, 13 },
    { 0xcc, 9 },    { 0x4b, 13 },
    { 0xcd, 9 },    { 0x4c, 13 },
    { 0xd2, 9 },    { 0x4d, 13 },
    { 0xd3, 9 },    { 0x72, 13 },
    { 0xd4, 9 },    { 0x73, 13 },
    { 0xd5, 9 },    { 0x74, 13 },
    { 0xd6, 9 },    { 0x75, 13 },
    { 0xd7, 9 },    { 0x76, 13 },
    { 0xd8, 9 },    { 0x77, 13 },
    { 0xd9, 9 },    { 0x52, 13 },
    { 0xda, 9 },    { 0x53, 13 },
    { 0xdb, 9 },    { 0x54, 13 },
    { 0x98, 9 },    { 0x55, 13 },
    { 0x99, 9 },    { 0x5a, 13 },
    { 0x9a, 9 },    { 0x5b, 13 },
    { 0x18, 6 },    { 0x64, 13 },
    { 0x9b, 9 },    { 0x65, 13 },
    { 0x08, 11 },   { 0x08, 11 },        /* extable len = 1792 */
    { 0x0c, 11 },   { 0x0c, 11 },
    { 0x0d, 11 },   { 0x0d, 11 },
    { 0x12, 12 },   { 0x12, 12 },
    { 0x13, 12 },   { 0x13, 12 },
    { 0x14, 12 },   { 0x14, 12 },
    { 0x15, 12 },   { 0x15, 12 },
    { 0x16, 12 },   { 0x16, 12 },
    { 0x17, 12 },   { 0x17, 12 },
    { 0x1c, 12 },   { 0x1c, 12 },
    { 0x1d, 12 },   { 0x1d, 12 },
    { 0x1e, 12 },   { 0x1e, 12 },
    { 0x1f, 12 },   { 0x1f, 12 },
};

#define mtable ((ttable)+64*2)


struct PrefabCode {
    unsigned int leadBits;
    unsigned int trailBits;
    struct BitString activeBits;
};


struct PrefabCode const prefabCode[256] =
{
{ 0, 8, {   0x0000,   0}},   /* 000 */
{ 7, 1, {   0x0000,   0}},   /* 001 */
{ 6, 1, {   0x0002,   3}},   /* 002 */
{ 6, 2, {   0x0000,   0}},   /* 003 */
{ 5, 2, {   0x0002,   3}},   /* 004 */
{ 5, 1, {   0x0087,   9}},   /* 005 */
{ 5, 1, {   0x0003,   2}},   /* 006 */
{ 5, 3, {   0x0000,   0}},   /* 007 */
{ 4, 3, {   0x0002,   3}},   /* 008 */
{ 4, 1, {   0x0027,   7}},   /* 009 */
{ 4, 1, {   0x043a,  12}},   /* 010 */
{ 4, 2, {   0x0087,   9}},   /* 011 */
{ 4, 2, {   0x0003,   2}},   /* 012 */
{ 4, 1, {   0x00c7,   8}},   /* 013 */
{ 4, 1, {   0x0002,   2}},   /* 014 */
{ 4, 4, {   0x0000,   0}},   /* 015 */
{ 3, 4, {   0x0002,   3}},   /* 016 */
{ 3, 1, {   0x0028,   7}},   /* 017 */
{ 3, 1, {   0x013a,  10}},   /* 018 */
{ 3, 2, {   0x0027,   7}},   /* 019 */
{ 3, 2, {   0x043a,  12}},   /* 020 */
{ 3, 1, {  0x10e87,  18}},   /* 021 */
{ 3, 1, {   0x021f,  11}},   /* 022 */
{ 3, 3, {   0x0087,   9}},   /* 023 */
{ 3, 3, {   0x0003,   2}},   /* 024 */
{ 3, 1, {   0x0037,   6}},   /* 025 */
{ 3, 1, {   0x063a,  11}},   /* 026 */
{ 3, 2, {   0x00c7,   8}},   /* 027 */
{ 3, 2, {   0x0002,   2}},   /* 028 */
{ 3, 1, {   0x0087,   8}},   /* 029 */
{ 3, 1, {   0x0003,   3}},   /* 030 */
{ 3, 5, {   0x0000,   0}},   /* 031 */
{ 2, 5, {   0x0002,   3}},   /* 032 */
{ 2, 1, {   0x002b,   7}},   /* 033 */
{ 2, 1, {   0x0142,  10}},   /* 034 */
{ 2, 2, {   0x0028,   7}},   /* 035 */
{ 2, 2, {   0x013a,  10}},   /* 036 */
{ 2, 1, {   0x4e87,  16}},   /* 037 */
{ 2, 1, {   0x009f,   9}},   /* 038 */
{ 2, 3, {   0x0027,   7}},   /* 039 */
{ 2, 3, {   0x043a,  12}},   /* 040 */
{ 2, 1, {   0x43a7,  16}},   /* 041 */
{ 2, 1, {  0x8743a,  21}},   /* 042 */
{ 2, 2, {  0x10e87,  18}},   /* 043 */
{ 2, 2, {   0x021f,  11}},   /* 044 */
{ 2, 1, {   0x87c7,  17}},   /* 045 */
{ 2, 1, {   0x021e,  11}},   /* 046 */
{ 2, 4, {   0x0087,   9}},   /* 047 */
{ 2, 4, {   0x0003,   2}},   /* 048 */
{ 2, 1, {   0x0038,   6}},   /* 049 */
{ 2, 1, {   0x01ba,   9}},   /* 050 */
{ 2, 2, {   0x0037,   6}},   /* 051 */
{ 2, 2, {   0x063a,  11}},   /* 052 */
{ 2, 1, {  0x18e87,  17}},   /* 053 */
{ 2, 1, {   0x031f,  10}},   /* 054 */
{ 2, 3, {   0x00c7,   8}},   /* 055 */
{ 2, 3, {   0x0002,   2}},   /* 056 */
{ 2, 1, {   0x0027,   6}},   /* 057 */
{ 2, 1, {   0x043a,  11}},   /* 058 */
{ 2, 2, {   0x0087,   8}},   /* 059 */
{ 2, 2, {   0x0003,   3}},   /* 060 */
{ 2, 1, {   0x00c7,   9}},   /* 061 */
{ 2, 1, {   0x0003,   4}},   /* 062 */
{ 2, 6, {   0x0000,   0}},   /* 063 */
{ 1, 6, {   0x0002,   3}},   /* 064 */
{ 1, 1, {   0x002c,   7}},   /* 065 */
{ 1, 1, {   0x015a,  10}},   /* 066 */
{ 1, 2, {   0x002b,   7}},   /* 067 */
{ 1, 2, {   0x0142,  10}},   /* 068 */
{ 1, 1, {   0x5087,  16}},   /* 069 */
{ 1, 1, {   0x00a3,   9}},   /* 070 */
{ 1, 3, {   0x0028,   7}},   /* 071 */
{ 1, 3, {   0x013a,  10}},   /* 072 */
{ 1, 1, {   0x13a7,  14}},   /* 073 */
{ 1, 1, {  0x2743a,  19}},   /* 074 */
{ 1, 2, {   0x4e87,  16}},   /* 075 */
{ 1, 2, {   0x009f,   9}},   /* 076 */
{ 1, 1, {   0x27c7,  15}},   /* 077 */
{ 1, 1, {   0x009e,   9}},   /* 078 */
{ 1, 4, {   0x0027,   7}},   /* 079 */
{ 1, 4, {   0x043a,  12}},   /* 080 */
{ 1, 1, {   0x43a8,  16}},   /* 081 */
{ 1, 1, {  0x21d3a,  19}},   /* 082 */
{ 1, 2, {   0x43a7,  16}},   /* 083 */
{ 1, 2, {  0x8743a,  21}},   /* 084 */
{ 1, 1, {0x21d0e87,  27}},   /* 085 */
{ 1, 1, {  0x43a1f,  20}},   /* 086 */
{ 1, 3, {  0x10e87,  18}},   /* 087 */
{ 1, 3, {   0x021f,  11}},   /* 088 */
{ 1, 1, {   0x21f7,  15}},   /* 089 */
{ 1, 1, {  0x43e3a,  20}},   /* 090 */
{ 1, 2, {   0x87c7,  17}},   /* 091 */
{ 1, 2, {   0x021e,  11}},   /* 092 */
{ 1, 1, {   0x8787,  17}},   /* 093 */
{ 1, 1, {   0x043b,  12}},   /* 094 */
{ 1, 5, {   0x0087,   9}},   /* 095 */
{ 1, 5, {   0x0003,   2}},   /* 096 */
{ 1, 1, {   0x003b,   6}},   /* 097 */
{ 1, 1, {   0x01c2,   9}},   /* 098 */
{ 1, 2, {   0x0038,   6}},   /* 099 */
{ 1, 2, {   0x01ba,   9}},   /* 100 */
{ 1, 1, {   0x6e87,  15}},   /* 101 */
{ 1, 1, {   0x00df,   8}},   /* 102 */
{ 1, 3, {   0x0037,   6}},   /* 103 */
{ 1, 3, {   0x063a,  11}},   /* 104 */
{ 1, 1, {   0x63a7,  15}},   /* 105 */
{ 1, 1, {  0xc743a,  20}},   /* 106 */
{ 1, 2, {  0x18e87,  17}},   /* 107 */
{ 1, 2, {   0x031f,  10}},   /* 108 */
{ 1, 1, {   0xc7c7,  16}},   /* 109 */
{ 1, 1, {   0x031e,  10}},   /* 110 */
{ 1, 4, {   0x00c7,   8}},   /* 111 */
{ 1, 4, {   0x0002,   2}},   /* 112 */
{ 1, 1, {   0x0028,   6}},   /* 113 */
{ 1, 1, {   0x013a,   9}},   /* 114 */
{ 1, 2, {   0x0027,   6}},   /* 115 */
{ 1, 2, {   0x043a,  11}},   /* 116 */
{ 1, 1, {  0x10e87,  17}},   /* 117 */
{ 1, 1, {   0x021f,  10}},   /* 118 */
{ 1, 3, {   0x0087,   8}},   /* 119 */
{ 1, 3, {   0x0003,   3}},   /* 120 */
{ 1, 1, {   0x0037,   7}},   /* 121 */
{ 1, 1, {   0x063a,  12}},   /* 122 */
{ 1, 2, {   0x00c7,   9}},   /* 123 */
{ 1, 2, {   0x0003,   4}},   /* 124 */
{ 1, 1, {   0x00c7,  10}},   /* 125 */
{ 1, 1, {   0x0002,   4}},   /* 126 */
{ 1, 7, {   0x0000,   0}},   /* 127 */
{ 1, 7, {   0x0000,   0}},   /* 128 */
{ 1, 1, {   0x000e,   4}},   /* 129 */
{ 1, 1, {   0x0062,   7}},   /* 130 */
{ 1, 2, {   0x000c,   4}},   /* 131 */
{ 1, 2, {   0x005a,   7}},   /* 132 */
{ 1, 1, {   0x1687,  13}},   /* 133 */
{ 1, 1, {   0x002f,   6}},   /* 134 */
{ 1, 3, {   0x000b,   4}},   /* 135 */
{ 1, 3, {   0x0042,   7}},   /* 136 */
{ 1, 1, {   0x0427,  11}},   /* 137 */
{ 1, 1, {   0x843a,  16}},   /* 138 */
{ 1, 2, {   0x1087,  13}},   /* 139 */
{ 1, 2, {   0x0023,   6}},   /* 140 */
{ 1, 1, {   0x08c7,  12}},   /* 141 */
{ 1, 1, {   0x0022,   6}},   /* 142 */
{ 1, 4, {   0x0008,   4}},   /* 143 */
{ 1, 4, {   0x003a,   7}},   /* 144 */
{ 1, 1, {   0x03a8,  11}},   /* 145 */
{ 1, 1, {   0x1d3a,  14}},   /* 146 */
{ 1, 2, {   0x03a7,  11}},   /* 147 */
{ 1, 2, {   0x743a,  16}},   /* 148 */
{ 1, 1, { 0x1d0e87,  22}},   /* 149 */
{ 1, 1, {   0x3a1f,  15}},   /* 150 */
{ 1, 3, {   0x0e87,  13}},   /* 151 */
{ 1, 3, {   0x001f,   6}},   /* 152 */
{ 1, 1, {   0x01f7,  10}},   /* 153 */
{ 1, 1, {   0x3e3a,  15}},   /* 154 */
{ 1, 2, {   0x07c7,  12}},   /* 155 */
{ 1, 2, {   0x001e,   6}},   /* 156 */
{ 1, 1, {   0x0787,  12}},   /* 157 */
{ 1, 1, {   0x003b,   7}},   /* 158 */
{ 1, 5, {   0x0007,   4}},   /* 159 */
{ 1, 5, {   0x003a,   9}},   /* 160 */
{ 1, 1, {   0x03ab,  13}},   /* 161 */
{ 1, 1, {   0x1d42,  16}},   /* 162 */
{ 1, 2, {   0x03a8,  13}},   /* 163 */
{ 1, 2, {   0x1d3a,  16}},   /* 164 */
{ 1, 1, {  0x74e87,  22}},   /* 165 */
{ 1, 1, {   0x0e9f,  15}},   /* 166 */
{ 1, 3, {   0x03a7,  13}},   /* 167 */
{ 1, 3, {   0x743a,  18}},   /* 168 */
{ 1, 1, {  0x743a7,  22}},   /* 169 */
{ 1, 1, { 0xe8743a,  27}},   /* 170 */
{ 1, 2, { 0x1d0e87,  24}},   /* 171 */
{ 1, 2, {   0x3a1f,  17}},   /* 172 */
{ 1, 1, {  0xe87c7,  23}},   /* 173 */
{ 1, 1, {   0x3a1e,  17}},   /* 174 */
{ 1, 4, {   0x0e87,  15}},   /* 175 */
{ 1, 4, {   0x001f,   8}},   /* 176 */
{ 1, 1, {   0x01f8,  12}},   /* 177 */
{ 1, 1, {   0x0fba,  15}},   /* 178 */
{ 1, 2, {   0x01f7,  12}},   /* 179 */
{ 1, 2, {   0x3e3a,  17}},   /* 180 */
{ 1, 1, {  0xf8e87,  23}},   /* 181 */
{ 1, 1, {   0x1f1f,  16}},   /* 182 */
{ 1, 3, {   0x07c7,  14}},   /* 183 */
{ 1, 3, {   0x001e,   8}},   /* 184 */
{ 1, 1, {   0x01e7,  12}},   /* 185 */
{ 1, 1, {   0x3c3a,  17}},   /* 186 */
{ 1, 2, {   0x0787,  14}},   /* 187 */
{ 1, 2, {   0x003b,   9}},   /* 188 */
{ 1, 1, {   0x0ec7,  15}},   /* 189 */
{ 1, 1, {   0x0073,  10}},   /* 190 */
{ 1, 6, {   0x0007,   6}},   /* 191 */
{ 2, 6, {   0x0000,   0}},   /* 192 */
{ 2, 1, {   0x000c,   4}},   /* 193 */
{ 2, 1, {   0x005a,   7}},   /* 194 */
{ 2, 2, {   0x000b,   4}},   /* 195 */
{ 2, 2, {   0x0042,   7}},   /* 196 */
{ 2, 1, {   0x1087,  13}},   /* 197 */
{ 2, 1, {   0x0023,   6}},   /* 198 */
{ 2, 3, {   0x0008,   4}},   /* 199 */
{ 2, 3, {   0x003a,   7}},   /* 200 */
{ 2, 1, {   0x03a7,  11}},   /* 201 */
{ 2, 1, {   0x743a,  16}},   /* 202 */
{ 2, 2, {   0x0e87,  13}},   /* 203 */
{ 2, 2, {   0x001f,   6}},   /* 204 */
{ 2, 1, {   0x07c7,  12}},   /* 205 */
{ 2, 1, {   0x001e,   6}},   /* 206 */
{ 2, 4, {   0x0007,   4}},   /* 207 */
{ 2, 4, {   0x003a,   9}},   /* 208 */
{ 2, 1, {   0x03a8,  13}},   /* 209 */
{ 2, 1, {   0x1d3a,  16}},   /* 210 */
{ 2, 2, {   0x03a7,  13}},   /* 211 */
{ 2, 2, {   0x743a,  18}},   /* 212 */
{ 2, 1, { 0x1d0e87,  24}},   /* 213 */
{ 2, 1, {   0x3a1f,  17}},   /* 214 */
{ 2, 3, {   0x0e87,  15}},   /* 215 */
{ 2, 3, {   0x001f,   8}},   /* 216 */
{ 2, 1, {   0x01f7,  12}},   /* 217 */
{ 2, 1, {   0x3e3a,  17}},   /* 218 */
{ 2, 2, {   0x07c7,  14}},   /* 219 */
{ 2, 2, {   0x001e,   8}},   /* 220 */
{ 2, 1, {   0x0787,  14}},   /* 221 */
{ 2, 1, {   0x003b,   9}},   /* 222 */
{ 2, 5, {   0x0007,   6}},   /* 223 */
{ 3, 5, {   0x0000,   0}},   /* 224 */
{ 3, 1, {   0x000b,   4}},   /* 225 */
{ 3, 1, {   0x0042,   7}},   /* 226 */
{ 3, 2, {   0x0008,   4}},   /* 227 */
{ 3, 2, {   0x003a,   7}},   /* 228 */
{ 3, 1, {   0x0e87,  13}},   /* 229 */
{ 3, 1, {   0x001f,   6}},   /* 230 */
{ 3, 3, {   0x0007,   4}},   /* 231 */
{ 3, 3, {   0x003a,   9}},   /* 232 */
{ 3, 1, {   0x03a7,  13}},   /* 233 */
{ 3, 1, {   0x743a,  18}},   /* 234 */
{ 3, 2, {   0x0e87,  15}},   /* 235 */
{ 3, 2, {   0x001f,   8}},   /* 236 */
{ 3, 1, {   0x07c7,  14}},   /* 237 */
{ 3, 1, {   0x001e,   8}},   /* 238 */
{ 3, 4, {   0x0007,   6}},   /* 239 */
{ 4, 4, {   0x0000,   0}},   /* 240 */
{ 4, 1, {   0x0008,   4}},   /* 241 */
{ 4, 1, {   0x003a,   7}},   /* 242 */
{ 4, 2, {   0x0007,   4}},   /* 243 */
{ 4, 2, {   0x003a,   9}},   /* 244 */
{ 4, 1, {   0x0e87,  15}},   /* 245 */
{ 4, 1, {   0x001f,   8}},   /* 246 */
{ 4, 3, {   0x0007,   6}},   /* 247 */
{ 5, 3, {   0x0000,   0}},   /* 248 */
{ 5, 1, {   0x0007,   4}},   /* 249 */
{ 5, 1, {   0x003a,   9}},   /* 250 */
{ 5, 2, {   0x0007,   6}},   /* 251 */
{ 6, 2, {   0x0000,   0}},   /* 252 */
{ 6, 1, {   0x0007,   6}},   /* 253 */
{ 7, 1, {   0x0000,   0}},   /* 254 */
{ 0, 8, {   0x0000,   0}},   /* 255 */
  };

#endif

