#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/select.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include "kbdsniff.h"
static int kbd_connected = KBD_NO_CONN;

static int kbd_send (char *cmd);

static int kbd_recv (char *str);

static int sock_id = -1;

int kbd_open (int port)
{
  struct hostent *hp, *gethostbyname ();

  struct sockaddr_in sock_addr;

  struct sockaddr_un sock_file;

  memset ((char *) &sock_addr, 0, sizeof (sock_addr));
  memset ((char *) &sock_file, 0, sizeof (sock_file));
  if (port)
   {
     sock_addr.sin_family = AF_INET;
     hp = gethostbyname ("localhost");
     memcpy (&sock_addr.sin_addr, hp->h_addr, hp->h_length);
     sock_addr.sin_port = htons (port);
   }
  else                          /* unix socket */
   {
     sock_file.sun_family = AF_UNIX;
     strcpy (sock_file.sun_path, KBD_SOCK_NAME);
   }

  sock_id = -1;
  if ((sock_id = socket ((port ? AF_INET : AF_UNIX), SOCK_STREAM, 0)) < 0)
    return KBD_NO_CONN;

  if (connect
      (sock_id,
       (port ? (struct sockaddr *) &sock_addr : (struct sockaddr *)
        &sock_file), port ? sizeof (sock_addr) : sizeof (sock_file)) < 0)
   {
     if (sock_id >= 0)
       close (sock_id);
     return KBD_NO_CONN;
   }
  kbd_connected = 1;
  return sock_id;
}

static int kbd_send (char *cmd)
{
  struct timeval timeout;

  int ret = 0;

  fd_set select_set;

  if (kbd_connected == KBD_NO_CONN)
    return KBD_NO_CONN;

  FD_ZERO (&select_set);
  FD_SET (sock_id, &select_set);

  timeout.tv_sec = 0;
  timeout.tv_usec = 1000 * KBD_SEND_TIMEOUT;

  if (select (sock_id + 1, NULL, &select_set, NULL, &timeout) <= 0)
   {
     kbd_close (1);
     return KBD_NO_CONN;
   }
  else
   {
     ret = send (sock_id, cmd, strlen (cmd), MSG_DONTWAIT);
     if (ret != (int) strlen (cmd))
      {
        kbd_close (1);
        return KBD_NO_CONN;
      }
   }

  return 0;

}

static int kbd_recv (char *str)
{
  struct timeval timeout;

  int ret = 0;

  fd_set select_set;

  if (kbd_connected == KBD_NO_CONN)
    return KBD_NO_CONN;

  FD_ZERO (&select_set);
  FD_SET (sock_id, &select_set);

  timeout.tv_sec = KBD_RECV_TIMEOUT;
  timeout.tv_usec = 0;

  if (select (sock_id + 1, &select_set, NULL, NULL, &timeout) <= 0)
   {
     kbd_close (1);
     return KBD_NO_CONN;
   }
  else
   {
     ret = recv (sock_id, str, KBD_MAX_STR, MSG_DONTWAIT);
     if (ret <= 0)
      {
        kbd_close (1);
        return KBD_NO_CONN;
      }
   }

  return 0;

}

void kbd_close (int send_quit)
{

  if (sock_id >= 0)
   {
     if (send_quit)
       send (sock_id, "quit\r\n", 6, MSG_DONTWAIT);
     close (sock_id);
   }

  sock_id = -1;
  kbd_connected = KBD_NO_CONN;

}

int kbd_auth (char *authkey)
{
  char tmpstr[KBD_MAX_STR] = "";

  memset (tmpstr, 0, sizeof (tmpstr));
  sprintf (tmpstr, "auth %s\r\n", authkey);
  if (kbd_send (tmpstr))
    return KBD_NO_CONN;

  memset (tmpstr, 0, sizeof (tmpstr));
  if (kbd_recv (tmpstr))
    return KBD_NO_CONN;

  if (!strcmp (tmpstr, "OK\r\n"))
    return 0;

  kbd_close (0);

  return KBD_NO_CONN;
}

int kbd_get ()
{
  char tmpstr[KBD_MAX_STR] = "";

  if (kbd_send ("get\r\n"))
    return KBD_NO_CONN;
  memset (tmpstr, 0, sizeof (tmpstr));
  if (kbd_recv (tmpstr))
    return KBD_NO_CONN;
  if (strlen (tmpstr) == 5 && tmpstr[4] == '\n')
    return atoi (tmpstr);
  else
   {
     kbd_close (1);
     return KBD_NO_CONN;
   }

  return 0;
}

int kbd_setkey (int key)
{

  char tmpstr[KBD_MAX_STR] = "";

  memset (tmpstr, 0, sizeof (tmpstr));
  sprintf (tmpstr, "setkey %03d\r\n", key);
  if (kbd_send (tmpstr))
    return KBD_NO_CONN;

  memset (tmpstr, 0, sizeof (tmpstr));
  if (kbd_recv (tmpstr))
    return KBD_NO_CONN;

  if (!strcmp (tmpstr, "OK\r\n"))
    return 0;
  else
   {
     kbd_close (1);
     return KBD_NO_CONN;
   }

  return 0;

}
