/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.elasticbeanstalk.model;

import java.io.Serializable;
import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * See the example below to learn how to create a request body.
 * </p>
 */
public class DescribeEnvironmentHealthRequest extends AmazonWebServiceRequest
        implements Serializable, Cloneable {

    /**
     * <p>
     * Specifies the AWS Elastic Beanstalk environment name.
     * </p>
     * <p>
     * Condition: You must specify either this or an EnvironmentId, or both. If
     * you do not specify either, AWS Elastic Beanstalk returns
     * <code>MissingRequiredParameter</code> error.
     * </p>
     */
    private String environmentName;
    /**
     * <p>
     * Specifies the AWS Elastic Beanstalk environment ID.
     * </p>
     * <p>
     * Condition: You must specify either this or an EnvironmentName, or both.
     * If you do not specify either, AWS Elastic Beanstalk returns
     * <code>MissingRequiredParameter</code> error.
     * </p>
     */
    private String environmentId;
    /**
     * <p>
     * Specifies the response elements you wish to receive. If no attribute
     * names are specified, AWS Elastic Beanstalk only returns the name of the
     * environment.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> attributeNames;

    /**
     * <p>
     * Specifies the AWS Elastic Beanstalk environment name.
     * </p>
     * <p>
     * Condition: You must specify either this or an EnvironmentId, or both. If
     * you do not specify either, AWS Elastic Beanstalk returns
     * <code>MissingRequiredParameter</code> error.
     * </p>
     * 
     * @param environmentName
     *        Specifies the AWS Elastic Beanstalk environment name.</p>
     *        <p>
     *        Condition: You must specify either this or an EnvironmentId, or
     *        both. If you do not specify either, AWS Elastic Beanstalk returns
     *        <code>MissingRequiredParameter</code> error.
     */

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    /**
     * <p>
     * Specifies the AWS Elastic Beanstalk environment name.
     * </p>
     * <p>
     * Condition: You must specify either this or an EnvironmentId, or both. If
     * you do not specify either, AWS Elastic Beanstalk returns
     * <code>MissingRequiredParameter</code> error.
     * </p>
     * 
     * @return Specifies the AWS Elastic Beanstalk environment name.</p>
     *         <p>
     *         Condition: You must specify either this or an EnvironmentId, or
     *         both. If you do not specify either, AWS Elastic Beanstalk returns
     *         <code>MissingRequiredParameter</code> error.
     */

    public String getEnvironmentName() {
        return this.environmentName;
    }

    /**
     * <p>
     * Specifies the AWS Elastic Beanstalk environment name.
     * </p>
     * <p>
     * Condition: You must specify either this or an EnvironmentId, or both. If
     * you do not specify either, AWS Elastic Beanstalk returns
     * <code>MissingRequiredParameter</code> error.
     * </p>
     * 
     * @param environmentName
     *        Specifies the AWS Elastic Beanstalk environment name.</p>
     *        <p>
     *        Condition: You must specify either this or an EnvironmentId, or
     *        both. If you do not specify either, AWS Elastic Beanstalk returns
     *        <code>MissingRequiredParameter</code> error.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DescribeEnvironmentHealthRequest withEnvironmentName(
            String environmentName) {
        setEnvironmentName(environmentName);
        return this;
    }

    /**
     * <p>
     * Specifies the AWS Elastic Beanstalk environment ID.
     * </p>
     * <p>
     * Condition: You must specify either this or an EnvironmentName, or both.
     * If you do not specify either, AWS Elastic Beanstalk returns
     * <code>MissingRequiredParameter</code> error.
     * </p>
     * 
     * @param environmentId
     *        Specifies the AWS Elastic Beanstalk environment ID.</p>
     *        <p>
     *        Condition: You must specify either this or an EnvironmentName, or
     *        both. If you do not specify either, AWS Elastic Beanstalk returns
     *        <code>MissingRequiredParameter</code> error.
     */

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    /**
     * <p>
     * Specifies the AWS Elastic Beanstalk environment ID.
     * </p>
     * <p>
     * Condition: You must specify either this or an EnvironmentName, or both.
     * If you do not specify either, AWS Elastic Beanstalk returns
     * <code>MissingRequiredParameter</code> error.
     * </p>
     * 
     * @return Specifies the AWS Elastic Beanstalk environment ID.</p>
     *         <p>
     *         Condition: You must specify either this or an EnvironmentName, or
     *         both. If you do not specify either, AWS Elastic Beanstalk returns
     *         <code>MissingRequiredParameter</code> error.
     */

    public String getEnvironmentId() {
        return this.environmentId;
    }

    /**
     * <p>
     * Specifies the AWS Elastic Beanstalk environment ID.
     * </p>
     * <p>
     * Condition: You must specify either this or an EnvironmentName, or both.
     * If you do not specify either, AWS Elastic Beanstalk returns
     * <code>MissingRequiredParameter</code> error.
     * </p>
     * 
     * @param environmentId
     *        Specifies the AWS Elastic Beanstalk environment ID.</p>
     *        <p>
     *        Condition: You must specify either this or an EnvironmentName, or
     *        both. If you do not specify either, AWS Elastic Beanstalk returns
     *        <code>MissingRequiredParameter</code> error.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DescribeEnvironmentHealthRequest withEnvironmentId(
            String environmentId) {
        setEnvironmentId(environmentId);
        return this;
    }

    /**
     * <p>
     * Specifies the response elements you wish to receive. If no attribute
     * names are specified, AWS Elastic Beanstalk only returns the name of the
     * environment.
     * </p>
     * 
     * @return Specifies the response elements you wish to receive. If no
     *         attribute names are specified, AWS Elastic Beanstalk only returns
     *         the name of the environment.
     * @see EnvironmentHealthAttribute
     */

    public java.util.List<String> getAttributeNames() {
        if (attributeNames == null) {
            attributeNames = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return attributeNames;
    }

    /**
     * <p>
     * Specifies the response elements you wish to receive. If no attribute
     * names are specified, AWS Elastic Beanstalk only returns the name of the
     * environment.
     * </p>
     * 
     * @param attributeNames
     *        Specifies the response elements you wish to receive. If no
     *        attribute names are specified, AWS Elastic Beanstalk only returns
     *        the name of the environment.
     * @see EnvironmentHealthAttribute
     */

    public void setAttributeNames(java.util.Collection<String> attributeNames) {
        if (attributeNames == null) {
            this.attributeNames = null;
            return;
        }

        this.attributeNames = new com.amazonaws.internal.SdkInternalList<String>(
                attributeNames);
    }

    /**
     * <p>
     * Specifies the response elements you wish to receive. If no attribute
     * names are specified, AWS Elastic Beanstalk only returns the name of the
     * environment.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if
     * any). Use {@link #setAttributeNames(java.util.Collection)} or
     * {@link #withAttributeNames(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param attributeNames
     *        Specifies the response elements you wish to receive. If no
     *        attribute names are specified, AWS Elastic Beanstalk only returns
     *        the name of the environment.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see EnvironmentHealthAttribute
     */

    public DescribeEnvironmentHealthRequest withAttributeNames(
            String... attributeNames) {
        if (this.attributeNames == null) {
            setAttributeNames(new com.amazonaws.internal.SdkInternalList<String>(
                    attributeNames.length));
        }
        for (String ele : attributeNames) {
            this.attributeNames.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Specifies the response elements you wish to receive. If no attribute
     * names are specified, AWS Elastic Beanstalk only returns the name of the
     * environment.
     * </p>
     * 
     * @param attributeNames
     *        Specifies the response elements you wish to receive. If no
     *        attribute names are specified, AWS Elastic Beanstalk only returns
     *        the name of the environment.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see EnvironmentHealthAttribute
     */

    public DescribeEnvironmentHealthRequest withAttributeNames(
            java.util.Collection<String> attributeNames) {
        setAttributeNames(attributeNames);
        return this;
    }

    /**
     * <p>
     * Specifies the response elements you wish to receive. If no attribute
     * names are specified, AWS Elastic Beanstalk only returns the name of the
     * environment.
     * </p>
     * 
     * @param attributeNames
     *        Specifies the response elements you wish to receive. If no
     *        attribute names are specified, AWS Elastic Beanstalk only returns
     *        the name of the environment.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see EnvironmentHealthAttribute
     */

    public DescribeEnvironmentHealthRequest withAttributeNames(
            EnvironmentHealthAttribute... attributeNames) {
        com.amazonaws.internal.SdkInternalList<String> attributeNamesCopy = new com.amazonaws.internal.SdkInternalList<String>(
                attributeNames.length);
        for (EnvironmentHealthAttribute value : attributeNames) {
            attributeNamesCopy.add(value.toString());
        }
        if (getAttributeNames() == null) {
            setAttributeNames(attributeNamesCopy);
        } else {
            getAttributeNames().addAll(attributeNamesCopy);
        }
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEnvironmentName() != null)
            sb.append("EnvironmentName: " + getEnvironmentName() + ",");
        if (getEnvironmentId() != null)
            sb.append("EnvironmentId: " + getEnvironmentId() + ",");
        if (getAttributeNames() != null)
            sb.append("AttributeNames: " + getAttributeNames());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeEnvironmentHealthRequest == false)
            return false;
        DescribeEnvironmentHealthRequest other = (DescribeEnvironmentHealthRequest) obj;
        if (other.getEnvironmentName() == null
                ^ this.getEnvironmentName() == null)
            return false;
        if (other.getEnvironmentName() != null
                && other.getEnvironmentName().equals(this.getEnvironmentName()) == false)
            return false;
        if (other.getEnvironmentId() == null ^ this.getEnvironmentId() == null)
            return false;
        if (other.getEnvironmentId() != null
                && other.getEnvironmentId().equals(this.getEnvironmentId()) == false)
            return false;
        if (other.getAttributeNames() == null
                ^ this.getAttributeNames() == null)
            return false;
        if (other.getAttributeNames() != null
                && other.getAttributeNames().equals(this.getAttributeNames()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime
                * hashCode
                + ((getEnvironmentName() == null) ? 0 : getEnvironmentName()
                        .hashCode());
        hashCode = prime
                * hashCode
                + ((getEnvironmentId() == null) ? 0 : getEnvironmentId()
                        .hashCode());
        hashCode = prime
                * hashCode
                + ((getAttributeNames() == null) ? 0 : getAttributeNames()
                        .hashCode());
        return hashCode;
    }

    @Override
    public DescribeEnvironmentHealthRequest clone() {
        return (DescribeEnvironmentHealthRequest) super.clone();
    }
}