# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest

class ListIoTCloudConnectorGroupsRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'IoTCC', '2021-05-13', 'ListIoTCloudConnectorGroups','IoTCC')
		self.set_method('POST')

	def get_Type(self): # String
		return self.get_query_params().get('Type')

	def set_Type(self, Type):  # String
		self.add_query_param('Type', Type)
	def get_NextToken(self): # String
		return self.get_query_params().get('NextToken')

	def set_NextToken(self, NextToken):  # String
		self.add_query_param('NextToken', NextToken)
	def get_IoTCloudConnectorGroupIdss(self): # RepeatList
		return self.get_query_params().get('IoTCloudConnectorGroupIds')

	def set_IoTCloudConnectorGroupIdss(self, IoTCloudConnectorGroupIds):  # RepeatList
		for depth1 in range(len(IoTCloudConnectorGroupIds)):
			self.add_query_param('IoTCloudConnectorGroupIds.' + str(depth1 + 1), IoTCloudConnectorGroupIds[depth1])
	def get_IoTCloudConnectorGroupStatuss(self): # RepeatList
		return self.get_query_params().get('IoTCloudConnectorGroupStatus')

	def set_IoTCloudConnectorGroupStatuss(self, IoTCloudConnectorGroupStatus):  # RepeatList
		for depth1 in range(len(IoTCloudConnectorGroupStatus)):
			self.add_query_param('IoTCloudConnectorGroupStatus.' + str(depth1 + 1), IoTCloudConnectorGroupStatus[depth1])
	def get_IoTCloudConnectorGroupNames(self): # RepeatList
		return self.get_query_params().get('IoTCloudConnectorGroupName')

	def set_IoTCloudConnectorGroupNames(self, IoTCloudConnectorGroupName):  # RepeatList
		for depth1 in range(len(IoTCloudConnectorGroupName)):
			self.add_query_param('IoTCloudConnectorGroupName.' + str(depth1 + 1), IoTCloudConnectorGroupName[depth1])
	def get_MaxResults(self): # Integer
		return self.get_query_params().get('MaxResults')

	def set_MaxResults(self, MaxResults):  # Integer
		self.add_query_param('MaxResults', MaxResults)
