from types import ModuleType
from typing import Union, Optional, Callable

from Crypto.PublicKey.DSA import DsaKey
from Crypto.PublicKey.ECC import EccKey

__all__ = ['new', 'DssSigScheme']

class DssSigScheme:
    def __init__(self, key: Union[DsaKey, EccKey], encoding: str, order: int) -> None: ...
    def can_sign(self) -> bool: ...
    def sign(self, msg_hash: ModuleType) -> bytes: ...
    def verify(self, msg_hash: ModuleType, signature: bytes) -> bool: ...

class DeterministicDsaSigScheme(DssSigScheme):
    def __init__(self, key, encoding, order, private_key) -> None: ...

class FipsDsaSigScheme(DssSigScheme):
    def __init__(self, key: DsaKey, encoding: str, order: int, randfunc: Callable) -> None: ...

class FipsEcDsaSigScheme(DssSigScheme):
    def __init__(self, key: EccKey, encoding: str, order: int, randfunc: Callable) -> None: ...

def new(key: Union[DsaKey, EccKey], mode: str, encoding: Optional[str]='binary', randfunc: Optional[Callable]=None) -> Union[DeterministicDsaSigScheme, FipsDsaSigScheme, FipsEcDsaSigScheme]: ...
