# Platform / AFU Interface Management

Platforms are particular physical FPGA systems. The set of local devices offered
varies from platform to platform. Some offer local DDR memory and some offer
high-speed serial connections. The actual wired platform interface to a given
class of devices may also vary from platform to platform. For example, the wired
interface to local memory may change from Avalon to AXI.

AFUs must attach to platform interfaces through an AFU top-level interface. The
code in the platforms tree bridges the gap between platform offerings and AFU
requirements. AFUs declare their top-level interface class, platforms declare
the set of interfaces they offer, and the
[afu_platform_config](scripts/afu_platform_config) script attempts to bridge the
gap by defining a shim between the platform's interface and the AFU's
expectations. Often this is merely a matching of wires, perhaps transforming
wire names or repackaging them in SystemVerilog interfaces.

AFU requirements are defined in [afu_top_ifc_db](afu_top_ifc_db). The schema is
defined in the README file. AFU writers may also write their own JSON
classes. AFUs declare their interface requirements in the AFU's packager JSON
file, using syntax described in [README_AFU](afu_top_ifc_db/README_AFU). Users
may add directories containing their own top-level interface specifications to
afu_platform_config's search path.  Execute _afu_platform_config --help_ for
details.

The [platform_db](platform_db) directory holds descriptions of interfaces
offered by specific platforms. This includes the set of available local devices,
the width and number of banks of local memory, etc. Like AFU requirements, the
set of directories searched for platform databases may be extended using an
environment variable. See _afu_platform_config --help_. The platform database
also holds tuning parameters, such as optimal buffer depths for CCI-P read and
write requests. Tuning parameters are exposed in SystemVerilog packages in
[platform_if/rtl/device_cfg](platform_if/rtl/device_cfg).

The [platform_if](platform_if) tree holds SystemVerilog files with standard
device interfaces and configuration files for loading the RTL into both Quartus
and simulators. Most RTL will:

```verilog
  `include "platform_if.vh"
```

Scripts generated by [afu_platform_config](scripts/afu_platform_config) will
automatically add the directory holding
[platform_if.vh](platform_if/rtl/platform_if.vh) to the search path.
