#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <pwd.h>
#include <stdio.h>
#include <utmp.h>
#include <dirent.h>
#include "system.h"

char *getfgproc (char *sproc, int fgcon)
{
  int i = 0;

  int pgrp = 0, tgid = 0;

  char str[100] = "", dev[50] = "";

  DIR *dirp;

  struct dirent *entry;

  int entvec[2000];

  dirp = opendir ("/proc");

  while ((entry = readdir (dirp)))
    if (atoi (entry->d_name))
     {
       entvec[i] = atoi (entry->d_name);
       i++;
     }

  closedir (dirp);

  sprintf (dev, "/dev/tty%i", fgcon);
  for (i -= 1; i > 1; i--)
   {
     char path[PROC_PATHLEN] = "";

     int cnt = 0;

     sprintf (path, "/proc/%i/fd/0", entvec[i]);
     cnt = readlink (path, str, 100);
     if (cnt < 0)
       str[0] = 0;
     else
       str[cnt] = 0;
     if (!strcmp (str, dev))
      {
        FILE *status;

        char name[100] = "";

        char stat_str[500] = "";

        char state_ch;

        int dummy_int = 0;

        sprintf (path, "/proc/%i/stat", entvec[i]);
        if ((status = fopen (path, "r")) == NULL)
         {
           strcpy (sproc, "default");
           return sproc;
         }

        if (NULL == fgets (stat_str, 250, status))
          return strcpy (sproc, "default");

        if (!sscanf
            (stat_str, "%d %s %c %d %d %d %d %d", &dummy_int, name, &state_ch,
             &dummy_int, &tgid, &dummy_int, &dummy_int, &pgrp))
          return strcpy (sproc, "default");
/*        printf("%s %c %d %d",name,state_ch,tgid,pgrp);*/
        fclose (status);
        if (state_ch != 'T' && tgid == pgrp)
         {
           strcpy (sproc, name + 1);
           sproc[strlen (sproc) - 1] = 0;
           return sproc;
         }
      }
     str[0] = 0;
   }
  strcpy (sproc, "default");
  return sproc;                 /* normaly unreached */
}

char *gethome (char *home, int console)
{
  struct passwd *user;

  getuser (home, console);
  if (!strcmp (home, "none"))
   {
     home[0] = 0;
     return home;
   }
  user = getpwnam (home);
  if (user)
    return strcpy (home, user->pw_dir);
  else
    return strcpy (home, "");
}

char *getuser (char *str, int console)
{

  struct utmp *user;

  char dev[30] = "";

  sprintf (dev, "tty%i", console);

  while ((user = getutent ()))
    if (!strcmp (dev, user->ut_line))
     {
       endutent ();
       return strcpy (str, user->ut_user);
     }

  endutent ();
  return strcpy (str, "none");
}

#if 0
void inskey (unsigned char *string)
{
  int ins_fd;                   /* file descriptor for current terminal */

  long kbmode;

  ins_fd = open (CONSOLE, O_RDONLY);
  if (ins_fd < 0)
    return;

  /* The ultimate goal for this function is to be able to insert characters,
     as well as arrow key controls, even if the keyboard on the console is in 
     K_RAW mode (as in dosemu particularly). For instance, at least, the
     insertion is not performed if in raw keyboard to prevent garbage
     results. */
  ioctl (ins_fd, KDGKBMODE, &kbmode);
  if (kbmode != K_XLATE && kbmode != K_UNICODE)
    return;

  while (*string)
    if (ioctl (ins_fd, TIOCSTI, string++))
      break;

  close (ins_fd);
}

#endif
