#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>
#include<iconv.h>

#include "sbllog.h"
#include "speechdlib.h"
#include <unistd.h>

iconv_t cd;

//static int cur_voice_tmp = 1;

static SPDConnection *speechd_ptr = NULL;

static int speechd_connected = 0;

static int reconnect = 0;

void speechd_close ()
{
  iconv_close (cd);
  if (speechd_ptr == NULL)
    return;
  else
   {
     spd_cancel_all (speechd_ptr);
     spd_close (speechd_ptr);
     speechd_connected = 0;
   }
}

int speechd_init (char *cmd)
{
  sbl_log ("speechd_init\n");

  int cmd_val = atoi (cmd);

  cmd_val++;
  cd = iconv_open ("utf8", "iso8859-1");

  if (speechd_ptr)
   {
     sbl_log ("speechd is already initialized\n");
     return 0;
   }

  speechd_ptr = spd_open ("sbl", NULL, NULL, 0);
  if (speechd_ptr)
   {
     sbl_log ("spd init param set \n");
     speechd_connected = 1;
   }
  else
   {
     sbl_log ("cannot connect to speech-dispatcher server\n");
     return 1;
   }

  return 0;
}

void speechd_start ()
{
}

void speechd_say (char *spkstr)
{
  char tmpbuf[4096];

  unsigned int i = 0, cnt = 0;

  if (reconnect == 10 && (speechd_ptr == NULL || speechd_connected == 0))
   {
     if (speechd_connect () == 0)
      {
        speechd_connected = 1;
        reconnect = 0;
      }

   }

  if (speechd_ptr == NULL || speechd_connected == 0)
   {
     if (reconnect < 10)
       reconnect++;
     return;
   }
  switch (spkstr[0])
   {
   case 0:
     return;
   case '\n':
   case '\r':
   case ' ':
     if (spkstr[1] == 0)
       return;
     break;
   }

  memset (tmpbuf, 0, sizeof (tmpbuf));
  for (i = 0; i < strlen (spkstr); i++)
   {
     if (spkstr[i] == ' ' && spkstr[i + 1] == ' ')
       continue;
     tmpbuf[cnt] = spkstr[i];
     cnt++;
   }

  tmpbuf[cnt] = '\0';


  char buffer[8192];     // it's enough 

  memset (buffer, 0, sizeof (buffer));
  char *inbuf = (char *) tmpbuf;

  char *outbuf = (char *) buffer;

  size_t inbytes = strlen (tmpbuf) + 1, outbytes = sizeof (buffer);

  iconv (cd, &inbuf, &inbytes, &outbuf, &outbytes);
  if (strlen (buffer) == 1)
   {
     if (spd_sayf (speechd_ptr, SPD_TEXT, "%s", buffer) < 0)
      {
        speechd_disconnect ("speechd_char");
      }

     return;
   }

  sbl_log ("ttsay ");
  if (spd_say (speechd_ptr, SPD_TEXT, (char *) buffer) < 0)
   {
     speechd_disconnect ("speechd_say");
   }
}

void speechd_param (char *param)
{
  sbl_log ("%s\n", param);
}

void speechd_vol (char *vol)
{
  int vol_val = atoi (vol);

  if (!speechd_ptr || speechd_connected == 0)
    return;
  if (spd_set_volume (speechd_ptr, vol_val) < 0)
   {
     speechd_disconnect ("speechd_vol");
   }
  sbl_log ("volume: %d ", vol_val);
}

void speechd_frq (char *frq)
{
  int frq_val = atoi (frq);

  if (!speechd_ptr || speechd_connected == 0)
    return;
  if (spd_set_voice_pitch (speechd_ptr, frq_val) < 0)
   {
     speechd_disconnect ("speechd_frq");
   }
}

void speechd_spd (char *spd)
{
  int spd_val = atoi (spd);

  if (!speechd_ptr || speechd_connected == 0)
    return;
  if (spd_set_voice_rate (speechd_ptr, spd_val) < 0)
   {
     speechd_disconnect ("speechd_spd");
   }
}

void speechd_voice (char *voice)
{
  int v;

  if ((v = atoi (voice)) > 8)
    return;
  if (!speechd_ptr || speechd_connected == 0)
    return;
  if (spd_set_voice_type (speechd_ptr, v) < 0)
   {
     speechd_disconnect ("speechd_voice");
   }
}

void speechd_lang (char *lang)
{
  if (!speechd_ptr || speechd_connected == 0)
    return;
  if (spd_set_language (speechd_ptr, lang) < 0)
   {
     speechd_disconnect ("speechd_lang");
   }
}

void speechd_spec (char *spec)
{
  if (!speechd_ptr || speechd_connected == 0)
    return;
  if (spd_set_output_module (speechd_ptr, spec) < 0)
    speechd_disconnect ("spec");

}

void speechd_stop ()
{
  if (!speechd_ptr || speechd_connected == 0)
    return;
  if (spd_cancel (speechd_ptr) < 0)
   {
     speechd_disconnect ("stop");
   }
  usleep (1000);
}

void speechd_punctuation (int on)
{
  if (!speechd_ptr || speechd_connected == 0)
    return;
  if (on == 0)
   {
     if (spd_set_punctuation (speechd_ptr, SPD_PUNCT_NONE) < 0)
      {
        speechd_disconnect ("setpunctuation");
      }
   }
  else
   {
     if (spd_set_punctuation (speechd_ptr, SPD_PUNCT_ALL) < 0)
      {
        speechd_disconnect ("setpunctuation");
      }
   }

}

void speechd_disconnect (char *function)
{
  sbl_log ("disconnecting in %s\n", function);
  spd_close (speechd_ptr);
  speechd_connected = 0;
  speechd_ptr = NULL;
}

int speechd_connect ()
{
  if ((speechd_ptr = spd_open ("sbl", NULL, NULL, 0)) == NULL)
    return 1;
  else
    return 0;
}
