// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct EncryptOutput {
    /// <p>The encrypted plaintext. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub ciphertext_blob: ::std::option::Option<::aws_smithy_types::Blob>,
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to encrypt the plaintext.</p>
    pub key_id: ::std::option::Option<::std::string::String>,
    /// <p>The encryption algorithm that was used to encrypt the plaintext.</p>
    pub encryption_algorithm: ::std::option::Option<crate::types::EncryptionAlgorithmSpec>,
    _request_id: Option<String>,
}
impl EncryptOutput {
    /// <p>The encrypted plaintext. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn ciphertext_blob(&self) -> ::std::option::Option<&::aws_smithy_types::Blob> {
        self.ciphertext_blob.as_ref()
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to encrypt the plaintext.</p>
    pub fn key_id(&self) -> ::std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The encryption algorithm that was used to encrypt the plaintext.</p>
    pub fn encryption_algorithm(&self) -> ::std::option::Option<&crate::types::EncryptionAlgorithmSpec> {
        self.encryption_algorithm.as_ref()
    }
}
impl ::aws_types::request_id::RequestId for EncryptOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl EncryptOutput {
    /// Creates a new builder-style object to manufacture [`EncryptOutput`](crate::operation::encrypt::EncryptOutput).
    pub fn builder() -> crate::operation::encrypt::builders::EncryptOutputBuilder {
        crate::operation::encrypt::builders::EncryptOutputBuilder::default()
    }
}

/// A builder for [`EncryptOutput`](crate::operation::encrypt::EncryptOutput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct EncryptOutputBuilder {
    pub(crate) ciphertext_blob: ::std::option::Option<::aws_smithy_types::Blob>,
    pub(crate) key_id: ::std::option::Option<::std::string::String>,
    pub(crate) encryption_algorithm: ::std::option::Option<crate::types::EncryptionAlgorithmSpec>,
    _request_id: Option<String>,
}
impl EncryptOutputBuilder {
    /// <p>The encrypted plaintext. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn ciphertext_blob(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.ciphertext_blob = ::std::option::Option::Some(input);
        self
    }
    /// <p>The encrypted plaintext. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn set_ciphertext_blob(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.ciphertext_blob = input;
        self
    }
    /// <p>The encrypted plaintext. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn get_ciphertext_blob(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.ciphertext_blob
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to encrypt the plaintext.</p>
    pub fn key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to encrypt the plaintext.</p>
    pub fn set_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.key_id = input;
        self
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to encrypt the plaintext.</p>
    pub fn get_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.key_id
    }
    /// <p>The encryption algorithm that was used to encrypt the plaintext.</p>
    pub fn encryption_algorithm(mut self, input: crate::types::EncryptionAlgorithmSpec) -> Self {
        self.encryption_algorithm = ::std::option::Option::Some(input);
        self
    }
    /// <p>The encryption algorithm that was used to encrypt the plaintext.</p>
    pub fn set_encryption_algorithm(mut self, input: ::std::option::Option<crate::types::EncryptionAlgorithmSpec>) -> Self {
        self.encryption_algorithm = input;
        self
    }
    /// <p>The encryption algorithm that was used to encrypt the plaintext.</p>
    pub fn get_encryption_algorithm(&self) -> &::std::option::Option<crate::types::EncryptionAlgorithmSpec> {
        &self.encryption_algorithm
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`EncryptOutput`](crate::operation::encrypt::EncryptOutput).
    pub fn build(self) -> crate::operation::encrypt::EncryptOutput {
        crate::operation::encrypt::EncryptOutput {
            ciphertext_blob: self.ciphertext_blob,
            key_id: self.key_id,
            encryption_algorithm: self.encryption_algorithm,
            _request_id: self._request_id,
        }
    }
}
